
;  GNU C 2.7.2 [AL 1.1, MM 40] RISC NEWS-OS compiled by CC

;  Cc1 defaults:
;  -mmemcpy

;  Cc1 arguments (-G value = 0, Cpu = 3000, ISA = 1):
;  -quiet -dumpbase -O2 -Wall -o

gcc2_compiled.:
__gnu_compiled_c:
; APP

		.code
		.align		1
		.global		rnd8
		.global		rnd16
		.global		rnd32
		.global		rnd8_range
		.global		rnd16_range
		.global		rnd32_range
		;//-------------------------------------;//
rnd8:
		call		rnd16			;// %r10 := y = rnd32(seed) >> 12
		sra		%r10, 4			;//           = rnd16(seed) >> 4
		ret.d
		ld.ub		%r10, %r10		;// return (unsigned char)y		*delay*
		;//-------------------------------------;//
rnd16:
		call		rnd32			;// %r10 := y = rnd32(seed) >> 8
		sra		%r10, 8
		ret.d
		ld.uh		%r10, %r10		;// return (unsigned short)y		*delay*
		;//-------------------------------------;//
rnd32:
		ld.w		%r10, [%r12]		;// %r10 := y = *seed
	ext	0x125a		; 		xld.w		%r11, 2463534242	;// %r11 := MAGIC_NUMBER		*anti-interlock*
	ext	0x1a32
	ld.w	%r11,0x22
		cmp		%r10, 0			;// if(y == 0) {
		jrne		2			;//    y  = MAGIC_NUMBER
		 ld.w		%r10, %r11		;// }
		;//
		ld.w		%r9, %r10		;// %r9  :=       y
	sll	%r9,0x8		; 		xsll		%r9, 13			;// %r9  :=      (y << 13)
	sll	%r9,0x5
		xor		%r10, %r9		;// %r10 := y ^= (y << 13)
		;//
		ld.w		%r9, %r10		;// %r9  :=       y
	srl	%r9,0x8		; 		xsrl		%r9, 17			;// %r9  :=      (y >> 17)
	srl	%r9,0x8
	srl	%r9,0x1
		xor		%r10, %r9		;// %r10 := y ^= (y >> 17)
		;//
		ld.w		%r9, %r10		;// %r9  :=       y
	sll	%r9,0x5		; 		xsll		%r9, 5			;// %r9  :=      (y <<  5)
		xor		%r10, %r9		;// %r10 := y ^= (y <<  5)
		;//
		cmp		%r10, %r11		;// if(y == MAGIC_NUMBER) {
		jrne		2			;//    y  = 0
		 ld.w		%r10, 0			;// }
		;//
		ld.w		[%r12], %r10		;// *seed = y
		ret					;// return  y
		;//-------------------------------------;//
rnd8_range:
		ld.w		%r15, %r13		;// %r15 :=                                             a
		ld.w		%r13, %r14		;// %r13 :=                                    b
		call.d		rnd8			;// %r10 :=            rnd8(seed)				AZuł rnd8 %r9,%r10,%r11,%psr ȊOj󂵂܂B
		sub		%r13, %r15		;// %r13 :=                                   (b - a)		*delay*
		;//
	ext	__modsi3@rm	; 		xcall.d		__modsi3		;// %r10 :=            rnd8(seed) %           (b - a)		CLiPł__modsi3 %r9,%r10,%alr,%ahr,%psr ȊOj󂵂܂B(clipidiv.s Q)
	call.d	__modsi3@rl
		ld.w		%r12, %r10		;// %r12 :=            rnd8(seed)				*delay*
		;//
		ret.d
		add		%r10, %r15		;// %r10 :=            rnd8(seed) %           (b - a) + a	*delay*
		;//-------------------------------------;//
rnd16_range:
		ld.w		%r15, %r13		;// %r15 :=                                             a
		ld.w		%r13, %r14		;// %r13 :=                                    b
		call.d		rnd16			;// %r10 :=           rnd16(seed)				AZułrnd16 %r9,%r10,%r11,%psr ȊOj󂵂܂B
		sub		%r13, %r15		;// %r13 :=                                   (b - a)		*delay*
		;//
	ext	__modsi3@rm	; 		xcall.d		__modsi3		;// %r10 :=           rnd16(seed) %           (b - a)		CLiPł__modsi3 %r9,%r10,%alr,%ahr,%psr ȊOj󂵂܂B(clipidiv.s Q)
	call.d	__modsi3@rl
		ld.w		%r12, %r10		;// %r12 :=           rnd16(seed)				*delay*
		;//
		ret.d
		add		%r10, %r15		;// %r10 :=           rnd16(seed) %           (b - a) + a	*delay*
		;//-------------------------------------;//
rnd32_range:
		ld.w		%r15, %r13		;// %r15 :=                                             a
		ld.w		%r13, %r14		;// %r13 :=                                    b
		call.d		rnd32			;// %r10 :=           rnd32(seed)				AZułrnd32 %r9,%r10,%r11,%psr ȊOj󂵂܂B
		sub		%r13, %r15		;// %r13 :=                                   (b - a)		*delay*
		;//
	ext	__umodsi3@rm	; 		xcall.d		__umodsi3		;// %r10 := (unsigned)rnd32(seed) % (unsigned)(b - a)		CLiPł__modsi3 %r9,%r10,%alr,%ahr,%psr ȊOj󂵂܂B(clipidiv.s Q)
	call.d	__umodsi3@rl
		ld.w		%r12, %r10		;// %r12 :=           rnd32(seed)				*delay*
		;//
		ret.d
		add		%r10, %r15		;// %r10 := (unsigned)rnd32(seed) % (unsigned)(b - a) + a	*delay*

; NO_APP
	.code
	.align	1
	.global	shuffle
shuffle:
;	.frame	%sp,20,$31		# vars= 0, regs= 5/0, args= 0, extra= 0
;	.mask	0x800f0000,-4
;	.fmask	0x00000000,0
	pushn	%r3
	ld.w	%r1,%r13
	ld.w	%r2,%r14
	ld.w	%r3,%r15
	ld.w	%r0,%r12
	cmp	%r1,0x1		; 	xcmp	%r1,1
	jrle	__LX72		; 	xjrle	__L72
__LX73:				; __L73:
	ld.w	%r12,%r3
	call	rnd32		; 	xcall	rnd32
	ld.w	%r12,%r10
	ld.w	%r13,%r1
	ext	__umodsi3@rm	; 	xcall	__umodsi3
	call	__umodsi3@rl
	mlt.w	%r10,%r2
	ld.w	%r12,%r0
	ld.w	%r4,%alr
	add	%r12,%r4
	ld.w	%r13,0x0
	cmp	%r13,%r2
	jrge	__LX75		; 	xjrge	__L75
__LX77:				; __L77:
	ld.ub	%r11,[%r0]	; 	xld.ub	%r11,[%r0]
	ld.ub	%r10,[%r12]	; 	xld.ub	%r10,[%r12]
	ld.b	[%r0],%r10	; 	xld.b	[%r0],%r10
	ld.b	[%r12],%r11	; 	xld.b	[%r12],%r11
	add	%r0,0x1		; 	xadd	%r0,%r0,1
	add	%r12,0x1	; 	xadd	%r12,%r12,1
	add	%r13,0x1	; 	xadd	%r13,%r13,1
	cmp	%r13,%r2
	jrlt	__LX77		; 	xjrlt	__L77
__LX75:				; __L75:
	sub	%r1,0x1		; 	xsub	%r1,%r1,1
	cmp	%r1,0x1		; 	xcmp	%r1,1
	jrgt	__LX73		; 	xjrgt	__L73
__LX72:				; __L72:
	popn	%r3
	ret
; APP

		.align		1
		.global		minimum_mask_greater_than_or_equal_to
		.global		random_value_less_than_or_equal_to
		;//-----------------------------------------------------;//
minimum_mask_greater_than_or_equal_to:
		;//							;// %r12  := x     
		ld.w		%r10, 0					;// %r10  := y = 0             
		;//							;// do {                                       
		cmp		%r10, %r12				;//     %psr[C] := c = (y < x) ? 1 : 0             
		jrult.d		-1					;//                                
		adc		%r10, %r10				;//     %psr[C] := y[31], %r10 := (y[30:0]<<1) | c 		*delay*
		;//							;// } while(c == 1)  
		adc		%r10, %r8				;// %r10 := (y[30:0]<<1) | y[31] 
		ret.d							;// return   y[31:0]
		rr		%r10, 1					;// %r10 :=  y[31:0]						*delay*
		;//-----------------------------------------------------;//
random_value_less_than_or_equal_to:
		pushn		%r3
		ld.w		%r0, %r12				;// %r0  := x
		ld.w		%r1, %r13				;// %r1  := generator
		call.d		minimum_mask_greater_than_or_equal_to	;// %r10 := mask = minimum_mask_greater_than_or_equal_to(x)
		ld.w		%r2, %r14				;// %r2  := param						*delay*
		ld.w		%r3, %r10				;// %r3  := mask
		;//							;// do {
		call.d		%r1					;//   %r10 := y = (*generator)(param)
		 ld.w		%r12, %r2				;//   %r12 :=                  param				*delay*
		 and		%r10, %r3				;//   %r10 := y &= mask
		 cmp		%r10, %r0				;// } while(y > x)
		jrugt		-4
		popn		%r3
		ret
		;//-----------------------------------------------------;//

