/*	
 *	clipnet.h
 *
 *	lbg[N֘ÃT|[g[`
 *
 *	CLiP - Common Library for P/ECE
 *	Copyright (C) 2001-2005 Naoyuki Sawa
 *
 *	* Sun Jul 24 04:08:00 JST 2005 Naoyuki Sawa
 *	- 쐬JnB
 *	* Tue Aug 02 06:25:00 JST 2005 Naoyuki Sawa
 *	- update_internet_checksum()Aip_unpack_header()Aip_pack_header()ǉ܂B
 *	* Sun Aug 07 04:10:00 JST 2005 Naoyuki Sawa
 *	- ip_pack_header()Aip_unpack_header()pack_ip_header()Aunpack_ip_header()ɉ܂B
 *	* Thu Aug 25 12:46:00 JST 2005 Naoyuki Sawa
 *	- address_class_mask()ǉ܂B
 *	* Fri Aug 26 04:09:00 JST 2005 Naoyuki Sawa
 *	- IP_ADDRESS()}Nǉ܂B
 *	* Mon Sep 12 05:27:00 JST 2005 Naoyuki Sawa
 *	- internet_checksum_pseudo_header()Aupdate_internet_checksum_pseudo_header()ǉ܂B
 *	* Tue Sep 13 22:28:00 JST 2005 Naoyuki Sawa
 *	- address_class_mask()ip_address_class_mask()ɉ܂B
 *	- unpack_tcp_header()Apack_tcp_header()ǉ܂B
 *	* Thu Sep 15 19:51:00 JST 2005 Naoyuki Sawa
 *	- pack_ip_header()Apack_tcp_header()ɂāAdata_length=0̏ꍇɁAdata=NULLƂ܂B
 *	* Wed Nov 18 21:37:53 JST 2015 Naoyuki Sawa
 *	- 'extern "C" {'`'}'ň݂͂܂B.cpp܂Win32vWFNgCN[ho悤ɂ邽߂łB
 */
#ifndef __CLIP_NET_H__
#define __CLIP_NET_H__

#ifdef  __cplusplus
extern "C" {
#endif//__cplusplus

/****************************************************************************
 *	
 ****************************************************************************/

/* IPAhXTulbg}XN쐬}N */
#define IP_ADDRESS(a,b,c,d)	(((a)<<24)|((b)<<16)|((c)<<8)|(d))

/* IPf[^OEwb_ (Kvȕ) */
typedef struct _IPHEADER {
	int identification;		/*  */
	int flags;			/* tO */
	int fragment_offset;		/* tOgItZbg */
	int protocol;			/* vgR */
	int source_ip_address;		/* MIPAhX */
	int destination_ip_address;	/* IPAhX */
	//
	unsigned char* data;		/* f[^ */
	int data_length;		/* f[^ */
} IPHEADER;

/* IPHEADER.flags */
//#define ...	(1<<0)	/* rbg0 \ (0) */
#define IP_DF	(1<<1)	/* rbg1 (DF : Don't Fragment) 0=tOgA1=tOgȂ */
#define IP_MF	(1<<2)	/* rbg2 (MF : More Fragments) 0=Ō̃tOgA1=ptOg */

/****************************************************************************
 *	
 ****************************************************************************/

/* TCPZOgwb_ */
typedef struct _TCPHEADER {
	/*----- wb_ -----*/
	int source_port;		/* M|[g */
	int destination_port;		/* Đ|[g */
	int sequence_number;		/* V[PXԍ */
	int acknowledgement_number;	/* mFԍ */
	int control_flag;		/* Rg[tO */
	int window;			/* EChE */
	/*----- f[^ -----*/
	unsigned char* data;		/* f[^ */
	int data_length;		/* f[^ */
} TCPHEADER;

/* TCPHEADER.control_flag */
#define TCP_FIN	(1<<0)	/* M̌㑱f[^ */
#define TCP_SYN	(1<<1)	/* V[PXԍ̓ */
#define TCP_RST	(1<<2)	/* RlNṼZbg */
#define TCP_PSH	(1<<3)	/* vbV@\ */
#define TCP_ACK	(1<<4)	/* mFtB[hL */
#define TCP_URG	(1<<5)	/* ً}|C^tB[hL */

/****************************************************************************
 *	
 ****************************************************************************/

/* C^[lbg`FbNTvZ܂B
 * [in]
 *	data		`FbNTvZf[^̐擪AhXB
 *	size		f[^̃oCgB(TCYł\܂)
 * [out]
 *	߂l		`FbNTB($0000`$FFFF)
 * [note]
 *	* f[^̒Ƀ`FbNTtB[hꍇ́A0ݒ肵ĂĂB
 *	* UDPVMTPȂǂł́AŏIIȃ`FbNT̒ľvZʂu0000vɂȂꍇɂ
 *	  uFFFFvZbgAu0000v͓ʂȈӖ(`FbNTȂ)ƂĂ܂B
 *	  ̊֐ɂ́Au0000vuFFFFvɒu鏈͊܂߂Ă܂B
 *	  KvɉāAĂяoŁu0000vuFFFFvɒuĂB
 *	* C^[lbg`FbNT̎dĺAȉ̎QƂĂB
 *		dq: RFC 1071 (Computing the Internet Checksum)
 *		:    wC^[lbgRFCTx AXL[oŋ ( p.611`)
 */
int internet_checksum(const void* data, int size);

/* f[^̒́AC^[lbg`FbNTtB[hXV܂B
 * [in]
 *	data		`FbNTvZf[^̐擪AhXB
 *	size		f[^̃oCgB(TCYł\܂)
 *	sum_ofs		`FbNTtB[hdata΃ItZbgB
 * [note]
 *	* `FbNTtB[h́Af[^ɖ΂܂B
 *	  Ȃ킿A(size <= sum_ofs <= size-2) łKv܂B
 *	  ͈̔͂𒴂lw肳ꂽꍇAG[\Ē~܂B
 *	* ̊֐́A`FbNTtB[h0i[ă`FbNTvZA
 *	  ̌A`FbNTtB[hɖ{̃`FbNTi[܂B
 *	  ĂяoɂāA`FbNTtB[h0ɂĂKv͂܂B
 */
void update_internet_checksum(void* data, int size, int sum_ofs);

/* ^wb_܂߂āAC^[lbg`FbNTvZ܂B
 * [in]
 *	source_ip_address	MIPAhX
 *	destination_ip_address	MIPAhX
 *	protocol		vgR (TCP=6, UDP=17, etc)
 *	packet			pPbg
 *	packet_length		pPbg
 * [out]
 *	߂l			`FbNT
 * [note]
 *	* {֐́AUDP`FbNT̓l܂B
 *	  UDP`FbNT̓́AĂяoɂďĂB
 */
int internet_checksum_pseudo_header(int source_ip_address, int destination_ip_address, int protocol, const void* packet, int packet_length);

/* pPbǵA`FbNTtB[h(^wb_܂)XV܂B
 *	source_ip_address	MIPAhX
 *	destination_ip_address	MIPAhX
 *	protocol		vgR (TCP=6, UDP=17, etc)
 *	packet			pPbg
 *	packet_length		pPbg
 *	checksum_offset		`FbNTtB[hpacket΃ItZbg
 * [note]
 *	* {֐́AUDP`FbNT̓l܂B
 *	  UDP`FbNT̓́AĂяoɂďĂB
 */
void update_internet_checksum_pseudo_header(int source_ip_address, int destination_ip_address, int protocol, void* _packet, int packet_length, int checksum_offset);

/****************************************************************************
 *	
 ****************************************************************************/

/* IPAhXNXɑΉATulbg}XN擾܂B
 * [in]
 *	ip_address	IPAhXB
 * [out]
 *	߂l		Tulbg}XNB
 */
int ip_address_class_mask(int ip_address);

/* IPf[^O͂Awb_擾܂B
 * [in]
 *	header		wb_i[IPHEADER\́B
 *	buffer		IPf[^Oi[Ăobt@B
 *	buffer_length	obt@B
 *			ۂIPf[^O傫Ă\܂B
 * [out]
 *	߂l		Ȃ΁AIPf[^ÕoCgԂ܂B
 *			̒l͓ɈӖ̂ŁAȂΐƍlĂB
 *			sȂ΁AlԂ܂B
 */
int unpack_ip_header(IPHEADER* header, const void* buffer, int buffer_length);

/* IPwb_񂩂AIPf[^OgݗĂ܂B
 * [in]
 *	header		wb_񂪊i[ĂIPHEADER\́B
 *	buffer		IPf[^Oi[obt@B
 *	buffer_length	obt@B
 *			IPf[^Oi[[ȑ傫KvłB
 *			obt@sȂ΁A֐͎sAԂ܂B
 * [out]
 *	߂l		Ȃ΁AIPf[^ÕoCgԂ܂B
 *			̃oCgpāAIPf[^ȎMsĂB
 *			sȂ΁AlԂ܂B
 * [note]
 *	* header->data_length=0̏ꍇɌAheader->data=NULLƂĂ\܂B
 *	  ȊȌꍇheader->data=NULLƂƁAG[I܂B
 */
int pack_ip_header(const IPHEADER* header, void* buffer, int buffer_length);

/****************************************************************************
 *	
 ****************************************************************************/

/* TCPZOg͂Awb_擾܂B
 * [in]
 *	header			wb_i[TCPHEADER\́B
 *	buffer			TCPZOgi[Ăobt@B
 *	buffer_length		TCPZOgB
 *	source_ip_address	MIPAhXB
 *	destination_ip_address	ĐIPAhXB
 * [out]
 *	߂l			Ȃ΁ATCPZOĝ܂ܕԂ܂B
 *				sȂ΁AlԂ܂B
 */
int unpack_tcp_header(TCPHEADER* header, const void* buffer, int buffer_length, int source_ip_address, int destination_ip_address);

/* TCPwb_񂩂ATCPZOggݗĂ܂B
 * [in]
 *	header			wb_񂪊i[ĂTCPHEADER\́B
 *	buffer			TCPZOgi[obt@B
 *	buffer_length		obt@B
 *				TCPZOgi[[ȑ傫KvłB
 *				obt@sȂ΁A֐͎sAԂ܂B
 *	source_ip_address	MIPAhXB
 *	destination_ip_address	ĐIPAhXB
 * [out]
 *	߂l			Ȃ΁ATCPZOgԂ܂B
 *				̃oCgpāATCPZOg̑MsĂB
 *				sȂ΁AlԂ܂B
 *	* header->data_length=0̏ꍇɌAheader->data=NULLƂĂ\܂B
 *	  ȊȌꍇheader->data=NULLƂƁAG[I܂B
 */
int pack_tcp_header(TCPHEADER* header, void* buffer, int buffer_length, int source_ip_address, int destination_ip_address);

#ifdef  __cplusplus
}//extern "C"
#endif//__cplusplus

#endif /*__CLIP_NET_H__*/
