/*	
 *	clipmod.h
 *
 *	P/ECE MOD Driver
 *
 *	CLiP - Common Library for P/ECE
 *	Copyright (C) 2001-2002 Naoyuki Sawa
 *
 *	* Tue Nov 19 12:30:00 JST 2002 Naoyuki Sawa
 *	- VK쐬B
 *	* Wed Nov 18 21:37:53 JST 2015 Naoyuki Sawa
 *	- 'extern "C" {'`'}'ň݂͂܂B.cpp܂Win32vWFNgCN[ho悤ɂ邽߂łB
 */
#ifndef __CLIP_MOD_H__
#define __CLIP_MOD_H__

#ifdef  __cplusplus
extern "C" {
#endif//__cplusplus

/****************************************************************************
 *	萔E^`
 ****************************************************************************/

#define MODBUFLEN 320 /* = 16000/50 c 1[tick](=1/50[sec])̃Tv */

/*--------------- MODt@C` ---------------*/

/* MODt@Cwb_̃Tv */
typedef struct _MODSAMPLE {
	char name[22];			/* + 0,22 */
	unsigned short length;		/* +22, 2 */
	unsigned char finetune;		/* +24, 1 */
	unsigned char volume;		/* +25, 1 */
	unsigned short repofs;		/* +26, 2 */
	unsigned short replen;		/* +28, 2 */
					/* =30    */
} MODSAMPLE;

///* p^[̃[ */
//typedef struct _MODROW {
//	unsigned int note[4];		/* + 0,16 */
//					/* =16   */
//} MODROW;
//`lςɂȂ܂(2003/02/01)

///* MODt@Cwb_̃p^[ */
//typedef struct _MODPATTERN {
//	MODROW row[64];			/* +   0,1024 */
//					/* =1024      */
//} MODPATTERN;
//`lςɂȂ܂(2003/02/01)

/* MODt@ČŒ蕔iwb_j */
typedef struct _MODHEADER {
	char title[20];			/* +   0, 20 */
	MODSAMPLE sample[31];		/* +  20,930 */
	unsigned char seqlen;		/* + 950,  1 */
	unsigned char seqrep;		/* + 951,  1 */
	unsigned char sequence[128];	/* + 952,128 */
	char tag[4];			/* +1080,  4 */
					/* =1084     */
	/* MODPATTERN pattern[1`64]                 */
	/* unsigned char smpdat[1`31][2B`128KB]    */
} MODHEADER;

/*--------------- hCo` ---------------*/

#define MODCHANS 16	/* T|[gő`l(MODdlł32) */
			/* ̒萔ύXꍇ́Amod_init()̃^Oe[uǉĂB */

typedef struct _MODCHANNEL {
	/* smpno,volume,periodchar,char,shortŏ[Ȃ̂łAύXƋtɃR[hTCY܂B
	 * MODhCo{͍̂RAMɂAeʂ̗]TȂ̂ŁAint̂܂܂ɂĂ܂B
	 */
	int smpno;	/* Tvԍ(0`31Am[gf[^̃Tvԍ-1Ċi[܂) */
	int volume;	/* {[(0`64A{[XChɕlŝŗvI) */
	int period;	/* sIhl(0`0x0fffAg[XChɕlŝŗvI) */
	int effect;	/* GtFNg(m[gf[^̃rbg11`0̂܂܊i[܂)           */
	int offset;	/* TvItZbg(24.8bitATvf[^擪byteItZbg) */
} MODCHANNEL;

typedef struct _MODDRIVER {
	MODHEADER* header;		/* t@Cwb_AhX                             */
	unsigned char* smpdat[31];	/* Tvf[^AhX                             */
	unsigned int* pattern[64];	/* p^[AhX                                   */
	MODCHANNEL channel[MODCHANS];	/* `l                                           */
	unsigned char chans;		/* `l(1`MODCHANS)                            */
	unsigned char seqno;		/* V[PXԍ(0`126A127ȏȂI)            */
	unsigned char rowno;		/* [ԍ(0`63A64Ȃ玟̃V[PX)            */
	unsigned char speed;		/* Xs[hݒl(1`32)                              */
	unsigned char tempo;		/* e|ݒl(33`255)                              */
	unsigned short tick;		/* `bN(tempoÂAspeed*125ȏȂ玟̃[) */
} MODDRIVER;

/****************************************************************************
 *	֐
 ****************************************************************************/

/* MODt@C̍ĐJn܂B
 * [in]
 *	data		MODf[^̐擪AhXB
 * [out]
 *	߂l		ĐJnɐA 0Ԃ܂B
 *			ĐJnłȂ΁A-1Ԃ܂B
 * [note]
 *	* MODf[^̐^śA^OuM.K.vǂ`FbNĂ܂B
 *	  {I4gbN31TvMODłAuM.K.vȊÕ^Of[^w肵ꍇ́A
 *	  ĐJn-1Ԃ̂łӂB
 *	- 2003/02/01ǋL
 *	  1`16`l܂łMODɑΉ܂B
 *	  uM.K.v̑Au1CHN`9CHNvсu10CHv`u16CHv`̃^Of[^Đ\łB
 *	  MODgdlł́u32CHv܂ő݂܂AP/ECE16`lȏgƂ͂ȂƎv܂B
 *	* ̊֐͓stream_play()ĂяoĂ܂B
 *	* stream_play()ĂԂƁATEh荞݃xN^tbN܂B
 *	  vOIOɕKmod_stop()ĂŁAxN^𕜌ĂB
 */
int mod_play(const void* data);

/* MODt@C̍Đ~܂B
 * [note]
 *	* ĐłȂ΁Å֐͉܂B
 */
void mod_stop();

/* mod_init()/mod_tick()́AMODTvWJs჌x֐łB
 * * P/ECEŎgꍇ́Axmod_play()/mod_stop()gĂB
 *   mod_init()/mod_tick()𒼐ڎgKv͂܂B
 * * Windowsŗpꍇ́Amod_init()/mod_tick()WindowsTEhAPI
 *   gݍ킹ĎgĂB
 */
int mod_init(MODDRIVER* driver, const void* data);
int mod_tick(MODDRIVER* driver, short wbuff[/*MODBUFLEN*/]);

/* mod_tick()Ă΂֐B(clipfram.cŒ`) */
int mod_seq(MODDRIVER* driver);
int mod_mix(MODDRIVER* driver, short wbuff[/*MODBUFLEN*/]);

#ifdef  __cplusplus
}//extern "C"
#endif//__cplusplus

#endif /*__CLIP_MOD_H__*/
