/*	
 *	clipmemp.c
 *
 *	ϒ蓖āEꊇJ̃v[
 *
 *	CLiP - Common Library for P/ECE
 *	Copyright (C) 2016 Naoyuki Sawa
 *
 *	* Sun Oct 16 21:10:38 JST 2016 Naoyuki Sawa
 *	- 1st [XB
 *	- clipcoll.cpool_alloc()ō쐬郁v[L܂AقȂ̃v[KvɂȂ̂œW[쐬܂B
 *	  clipcoll.c̃v[ƁAW[(clipmemc.c)̃v[Ƃ́AȈႢ͈ȉ̒ʂłB
 *	  Eclipcoll.c̃v[͌ŒTCỸubN蓖Ă̂ɑ΂AW[̃v[͔Cӂ̃TCỸubN蓖Ă܂B
 *	  Eclipcoll.c̃v[̓ubNʂɊ蓖āE\łAW[̃v[͈ꊇJ\łB
 *	  Eclipcoll.c̃v[͑SẴubNꂽɎۂɃq[vɕԂ܂AW[̃v[̓v[폜܂Ńq[vɕԋp܂(ꊇJ^Ȃ̂œRłBłȂƃv[̈ӖL܂)B
 *	  Eclipcoll.c̃v[͎QƃJEg,mێR[obN,R[obN̒ǉ@\L܂AW[ɂ͂̒ǉ@\͗L܂B
 */
#include "clip.h"
/****************************************************************************
 *	\
 ****************************************************************************/
//`N\
typedef struct _ST_MemPoolChunk {
	int		chunkWords;		//̃`Ñ[h
	int		allocedWords;		//蓖čς݃[h
//	int		buffer[chunkWords];
} ST_MemPoolChunk;
/****************************************************************************
 *	
 ****************************************************************************/
//v[쐬B
//[in]
//	chunkBytes		`N̊{oCg
//[out]
//	߂l			v[
//[note]
//	- MemPool_New()̈allocByteśAȊOɂ͉e܂B
//	  0łłB
//	- MemPool_Alloc()̈allocBytesɂ́AMemPool_New()̈chunkBytesɎw肵TCYA傫ȃTCYw肷鎖o܂B
//	  MemPool_New()̈chunkByteśAV`N쐬鎞̍ŏTCY肷邽߂̃qgłAȊOɂ͉e܂B
//	- MemPool_New()̈chunkBytesɑ傫Ȓlw肷قǁAxɑ傫ȃ`N쐬ꑬx͌サ܂A͒ቺ܂(ʂȃmۂ\邽)B
//	  MemPool_New()̈chunkBytesɏȒlw肷قǁAcalloc()Ăяo̕pxđxቺ܂A͌サ܂(ʂȃmۂ\邽)B
//	  Aɒ[ɏȒlw肷ƁAubNmۂxɃ`N쐬鎖ɂȂA`N̊Ǘ̈̕Apăቺ鎖ɒӂĉB
//	  ǂ̈ʂK؂́AAvP[Vǂ̈ʂ̃ubNmۂ\ł邩łAʓIɂ́APCȂΐ\LoCgAP/ECEȂΐLoCgƎv܂B
ST_MemPool* MemPool_New(int chunkBytes) {
	//Ǘ\̂̃mۂB
	ST_MemPool* pMemPool = calloc(1, sizeof(ST_MemPool));
	if(!pMemPool) { DIE(); }	//s
	//`N̊{[hi[B
	pMemPool->chunkWords = (chunkBytes + (sizeof(int) - 1)) / sizeof(int);	//oCgPʁ˃[hPʂɕϊB
	return pMemPool;
}
/*--------------------------------------------------------------------------*/
static void MemPool_FreeFunc(void* data) {
	ST_MemPoolChunk* pChunk = data;
	free(pChunk);
}
/*- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */
//v[폜B
//[in]
//	pMemPool		v[
void MemPool_Free(ST_MemPool* pMemPool) {
	//`NSĉB
	g_slist_free_full(pMemPool->chunkList/*NULL*/, MemPool_FreeFunc);	//폜֐Ƃfree𒼐ڎw肵Ă͂ȂBڍׂ́Agarray.c'Wed Apr 20 10:51:26 JST 2016'̃RgQƂĉB
	//Ǘ\̂̃B
	free(pMemPool);
}
/*--------------------------------------------------------------------------*/
//v[烁ubNmۂB
//[in]
//	pMemPool		v[
//	allocBytes		ubÑoCg
//[out]
//	߂l			mۂubN
//[note]
//	- MemPool_Alloc()̈allocBytesɂ́AMemPool_New()̈chunkBytesɎw肵TCYA傫ȃTCYw肷鎖o܂B
//	  ڍׂ́AMemPool_New()̃RgQƂĉB
void* MemPool_Alloc(ST_MemPool* pMemPool, int allocBytes) {
	int i, allocWords = (allocBytes + (sizeof(int) - 1)) / sizeof(int);	//oCgPʁ˃[hPʂɕϊB
	//ȉ̃[v,,sB
	for(i = 0; i < 2; i++) {
		{
			GSList* pList;
			//̃`N𑖍āc
			for(pList = pMemPool->chunkList; pList; pList = pList->next) {
				ST_MemPoolChunk* pChunk = pList->data;
				//̃`NAubN蓖ĉ\Ȃ΁c
				if((pChunk->allocedWords + allocWords) <= pChunk->chunkWords) {
					//蓖ĂubÑAhX߂B
					int* buffer = (int*)(pChunk + 1);
					void* pMem = &buffer[pChunk->allocedWords];
					//̃`ŃA蓖čς݃[h𑝂₷B
					pChunk->allocedWords += allocWords;
					//蓖ĂubÑAhXԂB
					return pMem;	//܂
				}
			}
			//̃`NAubN蓖ĂȂAȉ̏֐iށB
		}
		{
			//V`N쐬B
			// - V`ÑTCÝA`N̊{[h,,蓖Ă郁ubÑ[h́A傫ƂB
			int chunkWords = max(pMemPool->chunkWords, allocWords);
			//V`ÑmۂB
			ST_MemPoolChunk* pChunk = calloc(1, sizeof(ST_MemPoolChunk) + (sizeof(int) * chunkWords));
			if(!pChunk) { DIE(); }	//s
			//V`ŃA[hi[B
			pChunk->chunkWords = chunkWords;
			//V`NA`ÑXg̐擪ɒǉB
			// - K擪ɒǉKv͖AɒǉĂ͖薳A擪ɒǉǂB
			//   ڂ̃[vŁA̐V`N烁ubN蓖Ă鎖łA擪ɒǉĂ邩łB
			//   ܂AGSList̓AɒǉA擪ɒǉ@łB
			//   L̗RɂAĖɒǉ郁bg͉A擪ɒǉ̂K؂łB
			pMemPool->chunkList = g_slist_prepend(pMemPool->chunkList/*NULL*/, pChunk);
		}
	}
	DIE();	//ȂƂڂŃmۏo͂BŃG[~瓖W[̃oOłB
}
/*--------------------------------------------------------------------------*/
static void MemPool_ClearFunc(void* data, void* user_data) {
	ST_MemPoolChunk* pChunk = data;
	pChunk->allocedWords = 0;
}
/*- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */
//̃v[犄蓖ĂubNSāAv[֕ԋpB
void MemPool_Clear(ST_MemPool* pMemPool) {
	//SẴ`ŃA蓖čς݃[hZbgB
	g_slist_foreach(pMemPool->chunkList/*NULL*/, MemPool_ClearFunc, NULL);
}
