/*	
 *	clipimg.c
 *
 *	[eBeBF摜
 *
 *	CLiP - Common Library for P/ECE
 *	Copyright (C) 2001-2016 Naoyuki Sawa
 *
 *	* Sun Sep 06 23:32:49 JST 2015 Naoyuki Sawa
 *	- 1st [XB
 *	- discriminant_analysis()쐬܂B
 *	* Mon Sep 07 22:07:58 JST 2015 Naoyuki Sawa
 *	- image_labeling()ǉ܂B
 *	* Sun Sep 20 18:19:03 JST 2015 Naoyuki Sawa
 *	- discriminant_analysis()̏̈ꕔA32rbgˎɕύX܂B
 *	* Sat Dec 17 21:25:03 JST 2016 Naoyuki Sawa
 *	- k_means_clustering_init(),k_means_clustering_init_r(),k_means_clustering_step(),k_means_clustering_step_r()ǉ܂B
 *	* Sun Dec 25 21:14:35 JST 2016 Naoyuki Sawa
 *	- I蓖ĂgāAxPo[ẂAk_means_clustering_init_r()܂B
 */
#include "clip.h"
/*****************************************************************************
 *	ʕ͖@(Â̓l)
 *****************************************************************************/
//Ql
//@u摜\[Vv(http://imagingsolution.blog107.fc2.com/)́Aʕ͖@(Â̓l)v(http://imagingsolution.blog107.fc2.com/blog-entry-113.html)̋Lp:
//ʕ͖@ydiscriminant analysis methodz͑Â̓lƂAx(separation metrics)ƂlőƂȂ邵l߁AIɓls@łB
//x̓NXԕU(between-class variance)ƃNXU(within-class variance)Ƃ̔ŋ߂鎖łAȉ̗lɋ߂B
//lœlƂAlPxl(NX)̉f1Aς1AU1APxl傫(NX)̉f2Aς2AU2A
//摜Ŝ̉ftAςtAUtƂƂNXUw2
//@@w^2 = (1E1^2 + 2E2^2) / (1 + 2)
//NXԕUb^2
//@@b^2 = (1E(1 - t)^2 + 2E(2 - t)^2) / (1 + 2) = (1E2E(1 - 2)^2) / ((1 + 2)^2)
//ƂĂ킷łBŁASU(total variance)t
//@@t^2 = b^2 + w^2
//ƂĂ킷ł邱ƂA߂NXԕUƃNXUƂ̔ł镪x
//@@(b^2) / (w^2) = (b^2) / (t^2 - b^2)
//ƂȂA̕xőƂȂ邵l߂΂悢BŁASUt͂lɊ֌WȂȂ̂ŁANXԕUb^2őƂȂ邵l߂΂悢B
//ɃNXԕU̎̕lɊ֌WȂȂ̂ŁANXԕU̕q
//@@1E2E(1 - 2)^2
//őƂȂ邵l߂΂悢B
//ǁAW΍Ƃ֌WȂAAꂼ̗̈̃qXgOAfւƋPxl̕ϒlL̒lőƂȂ邵l݂Ԃɋ߂΂̂ŁAȊOƊȒPc
//AuCodeDailyv(http://ayb52895.hatenablog.com/)́Au摜2l`ʕ͖@`v(http://ayb52895.hatenablog.com/entry/2013/05/24/091131)̋L
//L@͗_݂̐̂ŁCLÂ͎݂Ȃ̂ŁA킹ĎQlɂĒ܂B
//L@̎ό`͂ȂȂ̂܂ǂłĂȂL̂łAŎĂ݂R[hƋLA̎ႪقړɂȂ̂ŁA͑ĂƎv܂B
/*---------------------------------------------------------------------------*/
//摜2ls߂́Al߂B
//[in]
//	p		摜̃AhX
//	n		摜̃oCg
//[out]
//	߂l		l
//[note]
//	- 'lȉ''l'ɕ邩C'l''lȏ'ɕ邩́A(_)ǂł\܂B
//	  ֐̎́A{0,1,2,...,14,15}ɑ΂'7'Ԃ̂ŁA'lȉ''l'ɕǂm܂B
//<gp>
//	render_object(&render,0,0,0,0,DISP_X,DISP_Y,DRW_NOMAL);
//	t=discriminant_analysis(vbuff,sizeof vbuff);
//	for(i=0;i<sizeof vbuff;i++){
//	  vbuff[i]=(vbuff[i]<=t)?0:15;//'ؑցE16K\'̎gpz
//	}
//{{2015/09/20ύX:discriminant_analysis()̏̈ꕔA32rbgˎɕύX܂B
//int discriminant_analysis(const uint8_t* p, int n) {
//	int t = 0;
//	if(n) {
//		int w[256];//X^bN1LoCggɒӂB
//		int w1, n1, m1, w2, n2, m2, i, x, max;
//		memset(w, 0, sizeof w);
//		w1 = n;
//		n1 = 0;
//		do {
//			x = *p++;
//			n1 += x;
//			w[x]++;
//		} while(--n);
//		w2 = 0;
//		n2 = 0;
//		max = 0;
//		i = 255;
//		do {
//			if(w1 && w2) {
//				m1 = n1 / w1;
//				m2 = n2 / w2;
//				x = w1 * w2 * (m1 - m2) * (m1 - m2);
//				if(x > max) {
//					t   = i;
//					max = x;
//				}
//			}
//			w1 -= w[i];
//			w2 += w[i];
//			n1 -= w[i] * i;
//			n2 += w[i] * i;
//		} while(--i >= 0);
//	}
//	return t;
//}
//2015/09/20ύX:discriminant_analysis()̏̈ꕔA32rbgˎɕύX܂B
int discriminant_analysis(const uint8_t* p, int n) {
	int sel = 0;
	if(n) {
		int w[256];//X^bN1LoCggɒӂB
		int w1, n1, w2, n2, i;
		double max;
		memset(w, 0, sizeof w);
		w1 = n;
		n1 = 0;
		do {
			int c = *p++;
			n1 += c;
			w[c]++;
		} while(--n);
		w2 = 0;
		n2 = 0;
		max = 0.0;
		i   = 255;
		do {
			if(w1 && w2) {
				double m1 = (double)n1 / (double)w1;	//
				double m2 = (double)n2 / (double)w2;	//32rbgŎ舵ƁA200x200hbgȏ̉摜ɓKpƃI[o[t[B
				double d  = m1 - m2;			//200x200hbgx̉摜ɂ͑ΉoȂƎpIłȂ̂ŁAŎ舵ɂB
				d = d * d * (double)w1 * (double)w2;	//
				if(d > max) {
					max = d;
					sel = i;
				}
			}
			w1 -= w[i];
			w2 += w[i];
			n1 -= w[i] * i;
			n2 += w[i] * i;
		} while(--i >= 0);
	}
	return sel;
}
//}}2015/09/20ύX:discriminant_analysis()̏̈ꕔA32rbgˎɕύX܂B
/****************************************************************************
 *	xO
 ****************************************************************************/
//ȃO[v̑\ɌČoHk(\Ԃ)
static int image_labeling_compress(uint16_t* parents, int a) {
	//aO[v̑\łȂ΁c
	while(parents[a] != a) {
		//ȃO[v̑\̃xɒuB
		a = parents[a] = parents[parents[a]];
	}
	return a;
}
/*- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */
//ȃO[vb̑O[v𕹍(̑\Ԃ)
static int image_labeling_link(uint16_t* parents, int a, int b) {
	a = image_labeling_compress(parents, a);
	b = image_labeling_compress(parents, b);
	return (a <= b) ? (parents[b] = a) : (parents[a] = b);
}
/*- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */
//ԍƂтƂтȃx0,1,2,...ɓ\ւ
static int image_labeling_relabel(uint16_t* parents, int regions) {
	int index = 0, a;
	for(a = 0; a < regions; a++) {
		//aO[v̑\Ȃ΁c
		if(parents[a] == a) {
			//aɐVx蓖ĂB
			parents[a] = index++;
		//aO[v̑\łȂ΁c
		} else {
			//ȃO[v̑\Ɠx蓖ĂB
			parents[a] = parents[parents[a]];
		}
	}
	return index;
}
/*- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */
//摜̃xOsB
//[in]
//	image[w*h]		摜̃AhXB
//	label[w*h]		֐A摜̊efɑΉ郉xi[B
//	diag			0w肷4ߖTA0ȊO̒lw肷8ߖTŏsB
//	parents[parents_max]	֐̓rŎgp郏[NGABŏIIɈӖ̗Ll͊i[܂B
//[out]
//	߂l			Ä̐(=x̍ől+1)ԂB
//				sA0ԂB
//				֐sv́A[NGAsłBparents[parents_max]𑝂₵āAēxĂяoĂB
//				ňȏ(s͗l)ł́Aparents[w*h]̃[NGAeʂKvƂȂ܂B
//[note]
//	- Ql
//	  uA440Hz uOv(http://d.hatena.ne.jp/wosugi/)́AuقڃpXȃxOv(http://d.hatena.ne.jp/wosugi/20110628)̋LQlɂĒ܂B
//	- L̎parents[]ŒTCYŊmۂĂ܂AۂɓK؂ȗeʂ͌X̃AvP[VɂĈقȂ̂ŁAAvP[VŊmۂ悤ɂ܂B
int image_labeling(const uint8_t* image/*[w*h]*/, int w, int h, uint16_t* label/*[w*h]*/, int diag/*0=4ߖT,1=8ߖT*/, uint16_t* parents/*[parents_max]*/, int parents_max) {
	int regions = 0, x, y, c, flagA, flagB, flagC, flagD, index;
	for(y = 0; y < h; y++) {
		for(x = 0; x < w; x++) {
			//אډf(4ߖT,,8ߖT)Ƃ̘A`FbN
			c = image[(w * y) + x];
			flagA = 0;            if( x                ) { flagA = (image[(w *  y     ) + (x - 1)] == c); }		//@
			flagB = 0;            if(                 y) { flagB = (image[(w * (y - 1)) +  x     ] == c); }		//@
			flagC = 0; if(diag) { if( x            && y) { flagC = (image[(w * (y - 1)) + (x - 1)] == c); } }	//
			flagD = 0; if(diag) { if((x < (w - 1)) && y) { flagD = (image[(w * (y - 1)) + (x + 1)] == c); } }	//E
			//ډfƘAf𕹍
			if(regions >= parents_max) { return 0; }	//[NGAsBparents[parents_max]𑝂₵čĎsB
			parents[regions] = regions;
			index = regions++;
			if(flagA | flagB | flagC | flagD) {
				regions--;
				if(flagA) { index = image_labeling_link(parents, index, label[(w *  y     ) + (x - 1)]); }
				if(flagB) { index = image_labeling_link(parents, index, label[(w * (y - 1)) +  x     ]); }
				if(flagC) { index = image_labeling_link(parents, index, label[(w * (y - 1)) + (x - 1)]); }
				if(flagD) { index = image_labeling_link(parents, index, label[(w * (y - 1)) + (x + 1)]); }
			}
			label[(w * y) + x] = index;
		}
	}
	//ăxO
	regions = image_labeling_relabel(parents, regions);
	for(y = 0; y < h; y++) {
		for(x = 0; x < w; x++) {
			label[(w * y) + x] = parents[label[(w * y) + x]];
		}
	}
	return regions;
}
/*- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */
//{{gp
#if 0
//u摜\[Vv(http://imagingsolution.blog107.fc2.com/)́A
//uxOASYv(http://imagingsolution.blog107.fc2.com/blog-entry-193.html)̋LŒ񎦂ĂA
//xOƎs₷Iȉ摜̗Ⴉ(Level.1ALevel.2)ƁA
//Kvȃ[NGA̗eʂőƂȂňP[XłA(s͗l)gāA؂sɂ܂B
#define _ 111
#define X 222
//Level.1@ˁ@ok
static uint8_t image1[9][9]={
  {_,_,_,_,_,_,_,_,_},
  {_,X,_,_,_,_,_,X,_},
  {_,_,X,_,_,_,X,_,_},
  {_,_,_,X,_,X,_,_,_},
  {_,_,_,_,X,_,_,_,_},
  {_,_,_,X,_,X,_,_,_},
  {_,_,X,_,_,_,X,_,_},
  {_,X,_,_,_,_,_,X,_},
  {_,_,_,_,_,_,_,_,_}};
//Level.2@ˁ@ok
static uint8_t image2[9][9]={
  {_,_,_,_,_,_,_,_,_},
  {_,_,X,X,_,X,X,_,_},
  {_,X,_,_,X,_,_,X,_},
  {_,_,_,X,_,X,_,_,_},
  {_,_,X,_,_,_,X,_,_},
  {_,_,_,X,_,X,_,_,_},
  {_,X,_,_,X,_,_,X,_},
  {_,_,X,X,_,X,X,_,_},
  {_,_,_,_,_,_,_,_,_}};
//s͗l
static uint8_t image3[9][9]={
  {X,_,X,_,X,_,X,_,X},
  {_,X,_,X,_,X,_,X,_},
  {X,_,X,_,X,_,X,_,X},
  {_,X,_,X,_,X,_,X,_},
  {X,_,X,_,X,_,X,_,X},
  {_,X,_,X,_,X,_,X,_},
  {X,_,X,_,X,_,X,_,X},
  {_,X,_,X,_,X,_,X,_},
  {X,_,X,_,X,_,X,_,X}};
#undef _
#undef X
static uint16_t label[9][9];
static uint16_t parents[(9*9)/**/];//Level.12[6]ő顎s͗lň(w*h)KvʓIɂ(max(\zِ*2,32))xŗǂƎv
static void test() {
  int regions,x,y;
  //Level.1@ˁ@ok
  regions=image_labeling(&image1[0][0],9,9,&label[0][0],1/*8ߖT*/,parents,ARRAY_SIZE(parents));
  printf("regions=%d\n",regions);
  for(y=0;y<9;y++){for(x=0;x<9;x++){printf("%3d",label[y][x]);}putchar('\n');}
  //Level.2@ˁ@ok
  regions=image_labeling(&image2[0][0],9,9,&label[0][0],1/*8ߖT*/,parents,ARRAY_SIZE(parents));
  printf("regions=%d\n",regions);
  for(y=0;y<9;y++){for(x=0;x<9;x++){printf("%3d",label[y][x]);}putchar('\n');}
  //s͗l@ˁ@ok
  regions=image_labeling(&image3[0][0],9,9,&label[0][0],0/*4ߖT*/,parents,ARRAY_SIZE(parents));
  printf("regions=%d\n",regions);
  for(y=0;y<9;y++){for(x=0;x<9;x++){printf("%3d",label[y][x]);}putchar('\n');}
}
#endif
//}}gp
/*****************************************************************************
 *	k-means@,y,k-means++@ɂNX^O
 *****************************************************************************/
#undef  K_MEANS_USE_DYNAMIC_MEMORY_ALLOCATION
#define K_MEANS_USE_DYNAMIC_MEMORY_ALLOCATION	//̃V{`ƁAI蓖ĂgāAxPo[Wgp܂B̃V{`Ȃ΁AI蓖ĂsȂAᑬłgp܂BǂgpĂAʂ͓ɂȂ܂B
/*--------------------------------------------------------------------------*/
//k-means++@̏sB
//[in]
//	vector		xNg̔z						(in)
//	_n		xNg̐						(in)
//	center		NX^S̔z					(unused)	̈́AՂ̂߂ɁAk_means_clustering_init()k_means_clustering_step()𑵂̈邽߂́A_~[łB֐͂̈QƂȂ̂ŁAۂ̈̒l͉ł\܂B
//	_k		NX^S̐					(in)
//	label		x̔z						(out)		xƂ́AexNgNX^̃CfNX(0`(k-1))̎łB
//	width		xNg,y,NX^S̔zvf̃oCg		(in)
//	distance	xNgƃNX^S̋߂֐
//	arg		AvP[V`̔Cӂ̈
//[out]
//	߂l		_n̂܂ܕԂ܂B
//[note]
//	- Ql
//	  uWikipedia - k-means++@v(http://ja.wikipedia.org/wiki/k-means++@)
//	- ́AI蓖ĂsȂD悵Ď̂ŁAsx͂ȂxłB
//	  AI蓖ĂgāAxPo[W\łB	{{2016/12/25RgǋL:I蓖ĂgāAxPo[ẂAk_means_clustering_init_r()܂B}}
int k_means_clustering_init(  const void* vector/*[width*n]*/, size_t _n, const void* center/*[width*k]*/, size_t _k, int label[/*n*/], size_t width, double (*distance)(const void* vector, const void* center           )           ) {
	return k_means_clustering_init_r(vector, _n, center, _k, label, width, (double (*)(const void*, const void*, void*))distance, NULL);	//k_means_clustering_init()k_means_clustering_init_r()́Adistance֐̌`قȂ܂A'cdeclďoK'Ȃ΁Ak_means_clustering_init()`distance֐ɂāA]Ȉ̂Ŗ肠܂B
}
#ifndef K_MEANS_USE_DYNAMIC_MEMORY_ALLOCATION
//ᑬ(I蓖ĂgpȂ)
int k_means_clustering_init_r(const void* vector/*[width*n]*/, size_t _n, const void* center/*[width*k]*/, size_t _k, int label[/*n*/], size_t width, double (*distance)(const void* vector, const void* center, void* arg), void* arg) {
	int n = _n, k = _k;
	int i, l;
	//xNg0ȉȂΉȂBłȂ΁c
	if(n > 0) {
		//NX^xNgȉɐ؂l߂B
		if(k > n) { k = n; }
		//ŁAŏ̃xNgAŏ̃NX^(0)SƂđIB
		label[0] = 0;
		//Ԗڈȍ~̑SẴxNgɁAx(k-1)ݒ肵ĂB
		// - x(k-1)́ÃxNg܂ANX^SƂđIĂȂB
		//   AŌ܂őIȂxNǵASăNX^(k-1)ɑƌȂ̂ŁAŐݒ肵x(k-1)̂܂܂ŗǂB
		for(i = 1; i < n; i++) { label[i] = (k - 1); }
		//Ԗڂ̃NX^(1)AŌ̈ÕNX^(k-2)܂ł́ANX^SƂȂxNgIB
		for(l = 1; l < (k - 1); l++) {
			//ŋߖT̃NX^S܂ł̋őłxNgB
			// - uWikipedia - k-means++@v(http://ja.wikipedia.org/wiki/k-means++@)ł́AŋߖT̃NX^S܂ł̋d݂ƌȂAd݂mzpă_őIԎɂȂĂB
			//   AŋߖT̃NX^S܂ł̋őłxNgAPɑIĂǂƎv̂ŁA鎖ɂB
			double d_nearest_max = 0.0;	//x}
			int    j_nearest_max =  -1;
			for(i = 1; i < n; i++) {
				//̃xNg܂ANX^SƂđIĂȂ΁c
				if(label[i] == (k - 1)) {
					const void* v = (const char*)vector + (width * i);
					//ŋߖT̃NX^S܂ł̋߂B
					double d_nearest = 0.0;	//x}
					int j, j_nearest =  -1;
					for(j = 0; j < n; j++) {
						//̃xNgANX^SƂđIĂc
						if(label[j] != (k - 1)) {
							const void* c = (const char*)vector + (width * j);
							double d = (*distance)(v, c, arg);
							if(d < 0.0) { DIE(); }
							//,,܂łōŏ̋Ȃ΁c
							if((j_nearest == -1) || (d < d_nearest)) {
								d_nearest = d;
								j_nearest = j;
							}
						}
					}
					if(j_nearest == -1) { DIE(); }	//oO
					//,,܂łōő̋Ȃ΁c
					if((j_nearest_max == -1) || (d_nearest > d_nearest_max)) {
						d_nearest_max = d_nearest;
						j_nearest_max = i;	//'j_nearest_max = j_nearest;'ƂȂ悤ӂB
					}
				}
			}
			if(j_nearest_max == -1) { DIE(); }	//oO
			//ŋߖT̃NX^S܂ł̋őłxNgAlԖڂ̃NX^SɑIB
			label[j_nearest_max] = l;
		}
	}
	//SẴxNg̃NX^tւƌȂāAxNgԂB
	return n;
}
#else //K_MEANS_USE_DYNAMIC_MEMORY_ALLOCATION
//(I蓖Ăgp)
int k_means_clustering_init_r(const void* vector/*[width*n]*/, size_t _n, const void* center/*[width*k]*/, size_t _k, int label[/*n*/], size_t width, double (*distance)(const void* vector, const void* center, void* arg), void* arg) {
	int n = _n, k = _k;
	//xNg0ȉȂΉȂBłȂ΁c
	if(n > 0) {
		double d, d_nearest_max, *TBL_d_nearest/*[n]*/;
		int i, l, j_nearest_max;
		const void *v, *c;
		//ŋߖT̃NX^S܂ł̋i[z̃mۂB
		TBL_d_nearest/*[n]*/ = malloc(sizeof(double) * n);
		if(!TBL_d_nearest) { DIE(); }
		//NX^xNgȉɐ؂l߂B
		if(k > n) { k = n; }
		//ŁAŏ̃xNgAŏ̃NX^(0)SƂđIB
		      j_nearest_max  = 0;
		label[j_nearest_max] = 0;
		//Ԗڈȍ~̑SẴxNgɁAx(k-1)ݒ肵ĂB
		// - x(k-1)́ÃxNg܂ANX^SƂđIĂȂB
		//   AŌ܂őIȂxNǵASăNX^(k-1)ɑƌȂ̂ŁAŐݒ肵x(k-1)̂܂܂ŗǂB
		for(i = 1; i < n; i++) { label[i] = (k - 1); }
		//Ԗڂ̃NX^(1)AŌ̈ÕNX^(k-2)܂ł́ANX^SƂȂxNgIB
		for(l = 1; l < (k - 1); l++) {
			c = (const char*)vector + (width * j_nearest_max);	//OɑIꂽNX^S
			//Ԗڈȍ~̑SẴxNgɑ΂āc
			for(i = 1; i < n; i++) {
				//̃xNg܂ANX^SƂđIĂȂ΁c
				if(label[i] == (k - 1)) {
					//OɑIꂽNX^S܂ł̋߁AŋߖT̃NX^S܂ł̋XVB
					v = (const char*)vector + (width * i);
					d = (*distance)(v, c, arg);
					if(d < 0.0) { DIE(); }	//oO
					if((l == 1) || (d < TBL_d_nearest[i])) { TBL_d_nearest[i] = d; }	//,,܂łōŏ̋Ȃ΁c
				}
			}
			//ŋߖT̃NX^S܂ł̋őłxNgB
			// - uWikipedia - k-means++@v(http://ja.wikipedia.org/wiki/k-means++@)ł́AŋߖT̃NX^S܂ł̋d݂ƌȂAd݂mzpă_őIԎɂȂĂB
			//   AŋߖT̃NX^S܂ł̋őłxNgAPɑIĂǂƎv̂ŁA鎖ɂB
			d_nearest_max = 0.0;	//x}
			j_nearest_max =  -1;
			for(i = 1; i < n; i++) {
				//̃xNg܂ANX^SƂđIĂȂ΁c
				if(label[i] == (k - 1)) {
					//ŋߖT̃NX^S܂ł̋XVB
					d = TBL_d_nearest[i];
					if(d < 0.0) { DIE(); }	//oO
					if((j_nearest_max == -1) || (d > d_nearest_max)) {			//,,܂łōő̋Ȃ΁c
						d_nearest_max = d;
						j_nearest_max = i;
					}
				}
			}
			if(j_nearest_max == -1) { DIE(); }	//oO
			//ŋߖT̃NX^S܂ł̋őłxNgAlԖڂ̃NX^SɑIB
			label[j_nearest_max] = l;
		}
		//ŋߖT̃NX^S܂ł̋i[z̃B
		free(TBL_d_nearest);
	}
	//SẴxNg̃NX^tւƌȂāAxNgԂB
	return n;
}
#endif//K_MEANS_USE_DYNAMIC_MEMORY_ALLOCATION
/*--------------------------------------------------------------------------*/
//k-means@(,,k-means++@)̌JԂ1XebvsB
//[in]
//	vector		xNg̔z						(in)
//	_n		xNg̐						(in)
//	center		NX^S̔z					(in)
//	_k		NX^S̐					(in)
//	label		x̔z						(in,out)	xƂ́AexNgNX^̃CfNX(0`(k-1))̎łB
//	width		xNg,y,NX^S̔zvf̃oCg		(in)
//	distance	xNgƃNX^S̋߂֐
//	arg		AvP[V`̔Cӂ̈
//[out]
//	߂l		ł߂NX^̕tւ
//[note]
//	- Ql
//	  uWikipedia - kϖ@v(http://ja.wikipedia.org/wiki/kϖ@)
//	- ́AI蓖ĂsȂD悵Ď̂ŁAsx͂ȂxłB
//	  AI蓖ĂgāAxPo[W\łB	{{2016/12/25RgǋL:k_means_clustering_step_r()́AXȂɒx͂Ȃ̂ŁÂ݂܂܂ł\ȂCė܂B}}
int k_means_clustering_step(  const void* vector/*[width*n]*/, size_t _n, const void* center/*[width*k]*/, size_t _k, int label[/*n*/], size_t width, double (*distance)(const void* vector, const void* center           )           ) {
	return k_means_clustering_step_r(vector, _n, center, _k, label, width, (double (*)(const void*, const void*, void*))distance, NULL);	//k_means_clustering_step()k_means_clustering_step_r()́Adistance֐̌`قȂ܂A'cdeclďoK'Ȃ΁Ak_means_clustering_step()`distance֐ɂāA]Ȉ̂Ŗ肠܂B
}
int k_means_clustering_step_r(const void* vector/*[width*n]*/, size_t _n, const void* center/*[width*k]*/, size_t _k, int label[/*n*/], size_t width, double (*distance)(const void* vector, const void* center, void* arg), void* arg) {
	int n = _n, k = _k;
	int i, relabel = 0;
	//exNgɂāc
	for(i = 0; i < n; i++) {
		const void* v = (const char*)vector + (width * i);
		double d_nearest = 0.0;	//x}
		int j, j_nearest =  -1;
		//eNX^Sɂāc
		for(j = 0; j < k; j++) {
			const void* c = (const char*)center + (width * j);
			//xNgƃNX^S̋߂B
			double d = (*distance)(v, c, arg);
			if(d < 0.0) { DIE(); }
			//,,܂łōŏ̋Ȃ΁c
			if((j_nearest == -1) || (d < d_nearest)) {
				d_nearest = d;
				j_nearest = j;
			}
		}
		if(j_nearest == -1) { DIE(); }
		//ł߂NX^̕tւc
		if(j_nearest != label[i]) {
			label[i] = j_nearest;
			relabel++;
		}
	}
	//ł߂NX^̕tւ񐔂ԂB
	return relabel;
}
/*--------------------------------------------------------------------------*/
//{{gp
#if 0
static void test(int n, int k);  //OQ
int app_main(int argc, char* argv[]) {
  test(1000/**/, 50/**/);
  return 0;
}
static double distance(const void* vector, const void* center) {
  double v = *(double*)vector;
  double c = *(double*)center;
  return (v - c) * (v - c);
}
static void test(int n, int k) {
  double* vector = malloc(sizeof(double) * n);
  double* center = malloc(sizeof(double) * k);
  int* label = malloc(sizeof(int) * n);
  int i, j, try;
  //xNg쐬B
  for(i = 0; i < n; i++) {
    vector[i] = drand48();
  }
  //k-means++@̏sB
  k_means_clustering_init(vector, n, center/*_~[*/, k, label, sizeof vector[0], distance);
  //k-means@(,,k-means++@)̌JԂsB
  for(try = 0; try < 100/**/; try++) {  //ɒ[Ɏꍇ̂߂ɁAJԂ񐔂𐧌B
    //NX^S߂B
    for(j = 0; j < k; j++) {
      double sum = 0.0;
      int    cnt = 0;
      for(i = 0; i < n; i++) {
        if(label[i] == j) {
          sum += vector[i];
          cnt++;
        }
      }
      if(cnt) { sum /= cnt; }
      center[j] = sum;
    }
    //k-means@(,,k-means++@)̌JԂ1XebvsB
    //ł߂NX^̕tւȂ(͏Ȃ)AIB
    if(k_means_clustering_step(vector, n, center, k, label, sizeof vector[0], distance) <= 1/**/) { break; }
  }
  //ʂ\B
  for(i = 0; i < n; i++) {
    printf("%f\t%d\n", vector[i], label[i]);
  }
  free(vector);
  free(center);
  free(label);
}
#endif
//}}gp
