/*	
 *	clipgpio.c
 *
 *	ėpI/O[`
 *
 *	CLiP - Common Library for P/ECE
 *	Copyright (C) 2001-2016 Naoyuki Sawa
 *
 *	* Wed Sep 11 00:35:50 JST 2013 Naoyuki Sawa
 *	- 1st[XB
 *	* Wed Sep 11 23:15:01 JST 2013 Naoyuki Sawa
 *	- ChatteringCanceller_Update()ASMA32byteߖ񂵂܂B
 *	* Sat Apr 02 23:34:06 JST 2016 Naoyuki Sawa
 *	- ARRAY_SIZE()}N̕ύXɔAVC++6.0intunsigned̔rɑ΂xɏo悤ɂȂ̂ŁAxoȂ悤ɖIȃLXgǉ܂B
 *	  쎩̂͂܂łƕς܂B
 *	  ڍׂclipmisc.h̓̃RgQƂĉB
 *	* Wed Aug 17 21:19:23 JST 2016 Naoyuki Sawa
 *	- \̖̂OAST_ChatteringCancellerST_GpioɕύX܂B
 *	  ֐̖OAChatteringCanceller_`Gpio_`ɕύX܂B
 *	  OύXŔAύXO̖O͒߂ăAvP[VŎghłB
 *	  OȊO͕ύXĂ炸AW[͕̓ςĂ܂B
 */
#include "clip.h"
/****************************************************************************
 *	`^O
 ****************************************************************************/
//\̂܂B
//[in]
//	pGpio		\̂ւ̃|C^
//	StableCount	`^O(0`4)
void Gpio_Init(ST_Gpio* pGpio, int StableCount) {
	if((unsigned)StableCount > (unsigned)ARRAY_SIZE(pGpio->PortStatus)) { DIE(); }	//`^O񐔂LȔ͈͂ł邱ƂmFB
	memset(pGpio, 0, sizeof(ST_Gpio));						//\̂NAB
	pGpio->StableCount = StableCount;						//`^O񐔂i[B
}
/*--------------------------------------------------------------------------*/
//ԂXV܂B
//[in]
//	pGpio		\̂ւ̃|C^
//	PortStatus	̃|[g
//[note]
//	- msԊũ^C}荞݂ĂяoāAXVsƂz肵Ă܂B
//	  ^C}荞݂gpɁAC[vĂяočXVsĂ\܂񂪁Amቺ邨ꂪ܂B
#ifndef PIECE
void Gpio_Update(ST_Gpio* pGpio, int PortStatus) {
	int UnstableBit, Tmp1, Tmp2, i;
	UnstableBit = 0;	//̃|[gԂƁA(1`pGpio->StableCount)Õ|[gԂAłقȂrbgAɒoBȉAsrbgƏ̂B
	Tmp1 = PortStatus;	//(1`pGpio->StableCount)Õ|[gԂA񕪂ÂÂփVtg邽߂́AꎞϐB
	for(i = 0; i < pGpio->StableCount; i++) {
		Tmp2 = pGpio->PortStatus[i];					//(i+1)Õ|[gԂ擾B
		       pGpio->PortStatus[i] = Tmp1;				//|[gԂA񕪂ÂÂփVtgB
		                              Tmp1 = Tmp2;			//
		                     UnstableBit |= (Tmp2 ^ PortStatus);	//srbg𒊏oB
	}
	Tmp1 = ( UnstableBit & pGpio->StableStatus) |	//srbg̕ɂĂ͑ÖԂC
	       (~UnstableBit & PortStatus);		//rbg̕ɂẴ͍|[gԂgݍ킹AVԂƂB
	Tmp2 = (pGpio->StableStatus ^ Tmp1);		//ÖԂƁAVԂŁAGbW𒊏oB
	pGpio->StableStatus = Tmp1;			//VԂi[B
	pGpio->StableOnEdge  |= ( Tmp1 & Tmp2);		//ԂOnGbW~ςB
	pGpio->StableOffEdge |= (~Tmp1 & Tmp2);		//ԂOffGbW~ςB
}
#else //PIECE
asm("
		.code
		.align		1
		.global		Gpio_Update
Gpio_Update:
		;// %r12 := pGpio
		;// %r13 := PortStatus
		xadd		%r9, %r12, 12			;//%r9  :=                             &pGpio->StableCount
		ld.w		%r4, [%r9]+			;//%r4  := i = StableCount, %r9 := p = &pGpio->PortStatus[0]
	;//	ld.w		%r5, 0				;//%r5  := UnstableBit = 0	
		cmp		%r4, 0				;//if(i) {				
		jreq.d		Gpio_Update_L20			;//  					
		ld.w		%r5, 0				;//%r5  := UnstableBit = 0							*delay*
		ld.w		%r6, %r13			;//  %r6  := Tmp1 = PortStatus
Gpio_Update_L10:						;//  do {
		;// %r4  := i
		;// %r5  := UnstableBit
		;// %r6  := Tmp1
		;// %r9  := p
		;// %r12 := pGpio
		;// %r13 := PortStatus
		ld.w		%r7, [%r9]			;//    %r7  := Tmp2 = *p
		ld.w		[%r9]+, %r6			;//                   *p++ = Tmp1
		ld.w		%r6, %r7			;//    %r6  :=               Tmp1 = Tmp2
		xor		%r7, %r13			;//    %r7  :=                     (Tmp2 ^ PortStatus)
	;//	or		%r5, %r7			;//    %r5  :=      UnstableBit |= (Tmp2 ^ PortStatus)	
		sub		%r4, 1				;//    %r4  := i--						
		jrne.d		Gpio_Update_L10			;//  } while(i)							
		or		%r5, %r7			;//    %r5  :=      UnstableBit |= (Tmp2 ^ PortStatus)				*delay*
Gpio_Update_L20:						;//}
		;// %r5  := UnstableBit
		;// %r12 := pGpio
		;// %r13 := PortStatus
		ld.w		%r7, [%r12]			;//%r7  :=                        pGpio->StableStatus
		not		%r6, %r5			;//%r6  :=                                                ~UnstableBit			*anti-interlock*
		and		%r5, %r7			;//%r5  :=         (UnstableBit & pGpio->StableStatus)
		and		%r6, %r13			;//%r6  :=                                               (~UnstableBit & PortStatus)
		or		%r6, %r5			;//%r6  := Tmp1 := (UnstableBit & pGpio->StableStatus) | (~UnstableBit & PortStatus)
		xor		%r7, %r6			;//%r7  := Tmp2 =                (pGpio->StableStatus ^ Tmp1)
		ld.w		[%r12]+, %r6			;//pGpio->StableStatus  = Tmp1
		not		%r4, %r6			;//%r4  :=                                 ~Tmp1
		ld.w		%r5, [%r12]			;//%r5  :=                StableOnEdge  = pGpio->StableOnEdge
		and		%r6, %r7			;//%r6  :=                                ( Tmp1 & Tmp2)				*anti-interlock*
		or		%r5, %r6			;//%r5  :=                StableOnEdge  | ( Tmp1 & Tmp2)
		ld.w		[%r12]+, %r5			;//pGpio->StableOnEdge  = StableOnEdge  | ( Tmp1 & Tmp2)
		ld.w		%r5, [%r12]			;//%r5  :=                StableOffEdge = pGpio->StableOffEdge
		and		%r4, %r7			;//%r6  :=                                (~Tmp1 & Tmp2)				*anti-interlock*
		or		%r5, %r4			;//%r5  :=                StableOffEdge | (~Tmp1 & Tmp2)
		ld.w		[%r12], %r5			;//pGpio->StableOffEdge = StableOnEdge  | (~Tmp1 & Tmp2)
		ret
");
#endif//PIECE
/*--------------------------------------------------------------------------*/
//Ԃ擾܂B
//[in]
//	pGpio		\̂ւ̃|C^
//	pOnEdge		ԂOnGbWi[ϐւ̃|C^  (NULL)
//	pOffEdge	ԂOffGbWi[ϐւ̃|C^ (NULL)
//[out]
//	߂l		
//[note]
//	- ԂOnGbW,y,ԂOffGbWsvȂ΁ANULL|C^w肵ĂB
//	- ԂOnGbW,y,ԂOffGbẂA~ςꂽlԂƂɒӂĂB
//	  OGpio_GetStatus()ĂяoɁAłGbWoꂽrbg"1"ɂȂ܂B
//	  ]āÃrbgɑΉAOnGbWOffGbW̒lAƂ"1"ɂȂ邱ƂL蓾܂B
int Gpio_GetStatus(ST_Gpio* pGpio, int* pOnEdge/*NULL*/, int* pOffEdge/*NULL*/) {
	int Status, Dummy;
	if(!pOnEdge)  { pOnEdge  = &Dummy; }	//ԂOnGbWvĂȂꍇ́A_~[ϐwB
	if(!pOffEdge) { pOffEdge = &Dummy; }	//ԂOffGbWvĂȂꍇ́A_~[ϐwB
ENTER_CS;//Gpio_Update()^C}荞݂Ăяo邱Ƃz肵āAGpio_GetStatus()Gpio_Update()̔rsB
	Status    = pGpio->StableStatus;	//Ԃ擾B
	*pOnEdge  = pGpio->StableOnEdge;	//ԂOnGbW擾B
	            pGpio->StableOnEdge  = 0;	//ԂOnGbWNAB
	*pOffEdge = pGpio->StableOffEdge;	//ԂOffGbW擾B
	            pGpio->StableOffEdge = 0;	//ԂOffGbWNAB
LEAVE_CS;//Gpio_Update()^C}荞݂Ăяo邱Ƃz肵āAGpio_GetStatus()Gpio_Update()̔rsB
	return Status;
}
/****************************************************************************
 *	
 ****************************************************************************/
#if 0


	ST_Gpio\1ŁA32|[g܂ŊǗł܂B
	32|[g𒴂͂Ǘꍇ́AST_Gpio\̂𕡐gpĂB

	̃|[gԂA(pGpio->StableCount+1)AœԂłꍇɁAԂƌȂ܂B
	ۂ̃`^OԂ́AAvP[VGpio_Update()ĂяoԊuɈˑ܂B
	K؂ȌĂяoԊúA1`10msłB(XCb`̉HȂ̂ŁA`^OpԂɂėv)

		                  ݸ   ݸ
		                  |<--->|   |<--->|
		PortStatus   0000 1010 1111 0101 0000 0000 0000 0000
		StableStatus 0000 0000 0011 1111 1100 0000 0000 0000	StableCount=2ŏꍇ̗BPortStatus(2+1)AœɈԂƌȂB
		OnEdge       0000 0000 0011 1111 1111 1111 1100 0000
		OffEdge      0000 0000 0000 0000 0011 1111 1100 0000
		             |||| |||| ||||              |
		             Gpio_Update()                   Gpio_GetStatus()
	
	@\́AP/ECEg[qɉOtXCb`ڑꍇ̂߂ɗpӂ̂łB
	P/ECE{̂̃{^͂́A@\gpKv͂܂B
	P/ECE{̂̃{^͂́A܂łǂpcePadGet(),,CLiPCupad_get()gpĂB

gp

	ST_Gpio stGpio;
	void app_isr(void* context) {
		Gpio_Update(&stGpio,~(	//_ː_ϊ
			pP0_P0D<< 0|	//[ 7: 0] P0X	P06=g[q[6],P05=g[q[7],P04=g[q[8]
			pP1_P1D<< 8|	//[15: 8] P1X	P14=g[q[1],P12=g[q[4]
			pK5_K5D<<16|	//[23:16] K5X	K54=START,K53=SELECT				P/ECE{̂ݓ͂ý
			pK6_K6D<<24));	//[31:24] K6X	K65=A,K64=B,K63=ݏ,K62=݉,K61=ݍK60	P/ECE{̂ݓ͂ý
	}
	void app_main() {
		int Status, OnEdge, OffEdge, OnEdgeCount = 0, OffEdgeCount = 0;
		Gpio_Init(&stGpio, 4);
		timer_start(1/*ms*/, app_isr, NULL);
		for(;;) {
			schedule();
			surface_clear(&surface, 0);
			Status = Gpio_GetStatus(&stGpio, &OnEdge, &OffEdge);
			if(OnEdge  &  (1<<(24+5)/*K65*/)) { OnEdgeCount++;  }
			if(OffEdge &  (1<<(24+5)/*K65*/)) { OffEdgeCount++; }
			render_printf(&render,0, 0,0,3, "K65 Status      : %d", (Status>>(24+5)/*K65*/)&1);
			render_printf(&render,0,10,0,3, "K65 OnEdgeCount : %d", OnEdgeCount);
			render_printf(&render,0,20,0,3, "K65 OffEdgeCount: %d", OffEdgeCount);
		}
	}
#endif
