/*	
 *	clipffa.c
 *
 *	L̉Z (Finite Field Arithmetic)
 *
 *	CLiP - Common Library for P/ECE
 *	Copyright (C) 2001-2015 Naoyuki Sawa
 *
 *	* Sun Aug 16 19:57:01 JST 2015 Naoyuki Sawa
 *	- 쐬JnB
 *	* Sat Aug 22 15:44:43 JST 2015 Naoyuki Sawa
 *	- Polynomial_Parse()ǉ܂B
 *	* Tue Aug 25 00:57:49 JST 2015 Naoyuki Sawa
 *	- Polynomial_ParseF(),Polynomial_ParseV()ǉ܂B
 *	* Wed Aug 26 23:08:45 JST 2015 Naoyuki Sawa
 *	- BCH̊֐쐬Jn܂B
 *	* Fri Aug 28 20:48:55 JST 2015 Naoyuki Sawa
 *	- GaloisField_Det(),GaloisField_Cof(),GaloisField_Solve()ǉ܂B
 *	* Sat Aug 29 00:01:08 JST 2015 Naoyuki Sawa
 *	- BCH_Decode()ǉ܂B
 *	* Sun Aug 30 13:35:11 JST 2015 Naoyuki Sawa
 *	- GaloisField_Deg()ǉ܂B
 *	* Sun Aug 30 18:40:22 JST 2015 Naoyuki Sawa
 *	- [h\̊֐쐬Jn܂B
 *	* Mon Aug 31 21:31:32 JST 2015 Naoyuki Sawa
 *	- GaloisField_NewDeg()ǉ܂B
 *	* Mon Oct 19 22:47:19 JST 2015 Naoyuki Sawa
 *	- BCH_EncodeN(),BCH_DecodeN(),ReedSolomon_EncodeN(),ReedSolomon_DecodeN()ɃRgǋL܂B
 *	  ܂͕ύXĂ܂B
 */
#include "clip.h"
/****************************************************************************
 *	KA
 ****************************************************************************/
//KÂ쐬B
//[in]
//	Gx		nB(0x2`0x1FF)
//[out]
//	߂l		ꍇAKÂԂB
//			sꍇANULLԂB
//[note]
//	- Gx̒ŁAZbgĂŏʃrbg(1<<deg)łꍇA֐GF(2^deg)𐶐B
//	  Ⴆ΁AGx=0x13w肵ꍇAGF(2^4)𐶐BGx=0x11Dw肵ꍇAGF(2^8)𐶐B
//	- GxAŒn(=Mn)𐶐錴nł͂ȂꍇA֐͎sNULLԂB
//	  ̐𗘗pāAGF(2^1)`GF(2^8)𐶐ASĂ̌n񋓂鎖o܂B
//	  int Gx;
//	  for(Gx=(1<<1);Gx<(1<<9);Gx++) {
//	    ST_GaloisField* pGF=GaloisField_New(Gx);
//	    if(pGF){printf("%#11b %#5x\n",Gx,Gx);}
//	    free(pGF);
//	  }
//	  
//	         0b11   0x3
//	        0b111   0x7
//	       0b1011   0xb
//	       0b1101   0xd
//	      0b10011  0x13
//	      0b11001  0x19
//	     0b100101  0x25
//	     0b101001  0x29
//	     0b101111  0x2f
//	     0b110111  0x37
//	     0b111011  0x3b
//	     0b111101  0x3d
//	    0b1000011  0x43
//	    0b1011011  0x5b
//	    0b1100001  0x61
//	    0b1100111  0x67
//	    0b1101101  0x6d
//	    0b1110011  0x73
//	   0b10000011  0x83
//	   0b10001001  0x89
//	   0b10001111  0x8f
//	   0b10010001  0x91
//	   0b10011101  0x9d
//	   0b10100111  0xa7
//	   0b10101011  0xab
//	   0b10111001  0xb9
//	   0b10111111  0xbf
//	   0b11000001  0xc1
//	   0b11001011  0xcb
//	   0b11010011  0xd3
//	   0b11010101  0xd5
//	   0b11100101  0xe5
//	   0b11101111  0xef
//	   0b11110001  0xf1
//	   0b11110111  0xf7
//	   0b11111101  0xfd
//	  0b100011101 0x11d
//	  0b100101011 0x12b
//	  0b100101101 0x12d
//	  0b101001101 0x14d
//	  0b101011111 0x15f
//	  0b101100011 0x163
//	  0b101100101 0x165
//	  0b101101001 0x169
//	  0b101110001 0x171
//	  0b110000111 0x187
//	  0b110001101 0x18d
//	  0b110101001 0x1a9
//	  0b111000011 0x1c3
//	  0b111001111 0x1cf
//	  0b111100111 0x1e7
//	  0b111110101 0x1f5
ST_GaloisField* GaloisField_New(int Gx) {
	ST_GaloisField* pGF;
	int i, c;
	//W[́AGF(2^1)`GF(2^8)͈̔͂ΏۂƂ鎖ɂB
	// - GF(2^9)ȏ@őΉo邪A܂pȂ̂ŁAߖ̂߂GF(2^8)܂łƂB
	// - GF(2^1)̌n0b1?,GF(2^8)̌n0b1????????Ȃ̂ŁA͈͊OȂ΃G[~B
	if((Gx <= (1<<0)) || (Gx >= (1<<9))) { DIE(); }
	//\̂̃mۂB
	pGF = calloc(1, sizeof(ST_GaloisField));
	if(!pGF) { DIE(); }
	//n(Gx)̍ŏʃrbg̈ʒũrbgSăZbgꂽlAmaxɋ߂B
	// - Ƃ΁AGx=0b100011101 Ȃ΁Amax=0b011111111, deg=8 ƂȂB
	//   vɁAmax=(2^deg)-1 łArbg\̍őlɑB
	for(pGF->max = -1; pGF->max >= Gx; pGF->max >>= 1) { /** no job **/ }
	//g原Adegɋ߂B
	pGF->deg = popcount(pGF->max);
	//loge[ȗSvf'gp(max)'i[ĂB
	// - loge[uɊi[l͈̔͂0`(max-1)Ȃ̂ŁAgpƈӖlƂmaxgpo܂B
	memset(pGF->log, pGF->max, sizeof pGF->log);
	//w\(i)=0`(max-1)ɑΉArbg\(c)=1`max߂B
	c = 1;	//(a^0)=1
	for(i = 0; i < pGF->max; i++) {
		//rbg\0ɂȂAɏorbg\ēxoAKÂł͂ȂB
		// - Ăяoɑ΂āAnK؂ł͂Ȃ`邽߂ɁA[v𔲂ăJNULLԂB
		if(!c || (pGF->log[c] != pGF->max)) { break; }
		//expe[úAw\ɑΉvfɁArbg\i[B
		pGF->exp[i] = c;
		//loge[úArbg\ɑΉvfɁAw\i[B
		pGF->log[c] = i;
		//̃rbg\߂B
		if((c <<= 1) > pGF->max) { c ^= Gx; }
	}
	//rbg\0ɂȂɏorbg\ēxoă[vrŔÁA
	//[vŌ܂ŎsʁA(a^max)=1 ɖ߂Ȃꍇ́AKÂł͂ȂB
	// - Ăяoɑ΂āAnK؂ł͂Ȃ`邽߂ɁAJNULLԂB
	if((i != pGF->max) || (c != 1)) {
		GaloisField_Free(pGF);
		pGF = NULL;
	}
	//\̂̃,,NULLԂB
	return pGF;
}
/*--------------------------------------------------------------------------*/
//g原w肵āAKÂ쐬B
//[in]
//	deg		g原B(1`8)
//[out]
//	߂l		KA
//[note]
//	- ́A[eBeB֐łB
//	- {ÃKÂ쐬ɂ́An𖾎KvL܂B
//	  g原łAnقȂƁAKȀł̉Zʂ̃rbg\قȂ邩łB
//	  AeXgvO쐬Arbg\̈ႢdvłȂꍇ́Ag原w肵ăKÂ쐬o֗Ǝv܂B
//	  ܂ۂɂAQRR[h̎dlł́A'̊g原̍ŏ̃rbgp^[n'w肳Ă鎖悤łB
//	- ȏ̗RA֐̂߂ɁA֐쐬鎖ɂ܂B
//	  ֐͂܂łeXgvO쐬ɎgpāAȗprɂGaloisField_New()gpĉB
ST_GaloisField* GaloisField_NewDeg(int deg) {
	//w肳ꂽ̑Aŏ̃rbgp^[珇Ɏāc
	int Gx    =  1<< deg;		//100...000
	int GxMax = (1<<(deg+1))-1;	//111...111
	do {
		//KÂo(=Gxn)AKÂԂB
		ST_GaloisField* pGF = GaloisField_New(Gx);
		if(pGF) { return pGF; }
	} while(++Gx <= GxMax);
	//w肳ꂽ̑́ASẴrbgp^[ŃKÂoȂ΁AG[~B
	DIE();
}
/*--------------------------------------------------------------------------*/
//KÂJB
//[in]
//	pGF		KA	NULL
void GaloisField_Free(ST_GaloisField* pGF) {
//sv	//NULL|C^łȂ΁c
//sv	if(pGF) {
		//\̂̃JB
		free(pGF);
//sv	}
}
/*--------------------------------------------------------------------------*/
//rbg\̍ől擾B
//[in]
//	pGF		KA
//[out]
//	߂l		rbg\̍ől
//[note]
//	- GF(2^1)Ȃ0x1,GF(2^2)Ȃ0x3,...,GF(2^8)Ȃ0xFFԂB
int GaloisField_Max(ST_GaloisField* pGF) {
	return pGF->max;
}
/*--------------------------------------------------------------------------*/
//g原擾B
//[in]
//	pGF		KA
//[out]
//	߂l		g原
//[note]
//	- GF(2^1)Ȃ1,GF(2^2)Ȃ2,...,GF(2^8)Ȃ8ԂB
int GaloisField_Deg(ST_GaloisField* pGF) {
	return pGF->deg;
}
/*--------------------------------------------------------------------------*/
//w\ɑΉArbg\߂B
//[in]
//	pGF		KA
//	i		w\	0`(2^deg)-2
//[out]
//	߂l		rbg\	1`(2^deg)-1
//[note]
//	- KÂł a^((2^deg)-1) = a^0 Ȃ̂ŁA֐͈̈̔͂ 0`(2^deg)-2 ƂB
int GaloisField_Exp(ST_GaloisField* pGF, int i) {
	//expe[úAw\ɑΉvfɁArbg\i[ĂB
	// - w\(i)́A0`(max-1)͈̔͂łȂĂ͂ȂȂB
	if((i < 0) || (i >= pGF->max)) { DIE(); }
	return pGF->exp[i];
}
/*--------------------------------------------------------------------------*/
//rbg\ɑΉAw\߂B
//[in]
//	pGF		KA
//	c		rbg\	1`(2^deg)-1
//[out]
//	߂l		w\	0`(2^deg)-2
//[note]
//	- rbg\ 0 ̎w\ a^- Ȃ̂ŁA֐̈ɂ 0 ͎wsƂB
int GaloisField_Log(ST_GaloisField* pGF, int c) {
	//loge[úArbg\ɑΉvfɁAw\i[ĂB
	// - rbg\(c)́A1`max͈̔͂łȂĂ͂ȂȂB
	if((c <= 0) || (c > pGF->max)) { DIE(); }
	return pGF->log[c];
}
/*--------------------------------------------------------------------------*/
//w\{w\ˎw\
int GaloisField_Add(ST_GaloisField* pGF, int x, int y) {
	if(((unsigned)x > (unsigned)pGF->max) ||
	   ((unsigned)y > (unsigned)pGF->max)) { DIE(); }
	return x ^ y;
}
/*--------------------------------------------------------------------------*/
//w\|w\ˎw\
int GaloisField_Sub(ST_GaloisField* pGF, int x, int y) {
	return GaloisField_Add(pGF, x, y);	//KȀł(Z=Z)
}
/*--------------------------------------------------------------------------*/
//w\~w\ˎw\
int GaloisField_Mul(ST_GaloisField* pGF, int x, int y) {
	if(!x || !y) { return 0; }
	x = GaloisField_Log(pGF, x);	//1`max0`(max-1)
	y = GaloisField_Log(pGF, y);	//1`max0`(max-1)
	if((unsigned)(x += y) >= (unsigned)pGF->max) { x -= pGF->max; }
	return GaloisField_Exp(pGF, x);	//0`(max-1)1`max
}
/*--------------------------------------------------------------------------*/
//w\w\ˎw\
int GaloisField_Div(ST_GaloisField* pGF, int x, int y) {
	if(!x) { return 0; }
	x = GaloisField_Log(pGF, x);	//1`max0`(max-1)
	y = GaloisField_Log(pGF, y);	//1`max0`(max-1)	(y=0)Ȃ΂ŃG[~B
	if((unsigned)(x -= y) >= (unsigned)pGF->max) { x += pGF->max; }
	return GaloisField_Exp(pGF, x);	//0`(max-1)1`max
}
/*--------------------------------------------------------------------------*/
//A[ns][n]̍s(determinant)߂܂B
//[in]
//	pGF		KA
//	A[n][n]		s
//[out]
//	߂l		s
//[note]
//	- clipflt1.cmatnf_determinant()ƓAKȀōs܂B
int GaloisField_Det(ST_GaloisField* pGF, const uint8_t* A/*[n][n]*/, int n) {
	int d, i, t;
	if(n < 1) { DIE(); }
	//]qWJpāAs(determinant)߂܂B
	d = 0;
	for(i = 0; i < n; i++) {
		t = GaloisField_Cof(pGF, A, n, i, 0/*j*/);
		t = GaloisField_Mul(pGF, t, A[(n * i) + 0/*j*/]);
		d = GaloisField_Add(pGF, d, t);
	}
	//s񎮂Ԃ܂B
	return d;
}
/*--------------------------------------------------------------------------*/
//A[ns][n]isjA]q(cofactor)߂܂B */
//[in]
//	pGF		KA
//	A[n][n]		s
//	i		菜s
//	j		菜
//[out]
//	߂l		]q
//[note]
//	- clipflt1.cmatnf_cofactor()ƓAKȀōs܂B
int GaloisField_Cof(ST_GaloisField* pGF, const uint8_t* A/*[n][n]*/, int n, int i, int j) {
	int d, k, l;
	uint8_t* B/*[n-1][n-1]*/;
	if((n < 1) || ((i < 0) || (i >= n)) || ((j < 0) || (j >= n))) { DIE(); }
	//A[ns][n]isjAs(submatrix)쐬܂B
	if(!--n) { return 1; }	//s0s0ɂȂꍇ
	B = malloc(n * n);
	if(!B) { DIE(); }
	for(k = 0; k <= n; k++) {
		for(l = 0; l <= n; l++) {
			if((k != i) && (l != j)) { *B++ = *A; }
			A++;
		}
	}
	B -= (n * n);
	//s(minor determinant)߂܂B
	d = GaloisField_Det(pGF, B, n);
	//]q(cofactor)߂܂B
//sv	if((i ^ j) & 1) { d = GaloisField_Sub(pGF, 0, d); }	˃KȀł́}͓Ȃ̂ŕsv
	//s܂B
	free(B);
	//]qԂ܂B
	return d;
}
/*--------------------------------------------------------------------------*/
//Ả߂܂B
//[in]
//	pGF		KA
//	A[n][n],b[n]	A
//	x[n]		Ải[z
//[out]
//	߂l		s
//			s񎮂0Ȃ΁Ax͋߂Ă܂B
//[note]
//	- clipflt1.csolve_simultaneous_equations()ƓAKȀōs܂B
int GaloisField_Solve(ST_GaloisField* pGF, const uint8_t* A/*[n][n]*/, const uint8_t* b/*[n]*/, uint8_t* x/*[n]*/, int n) {
	int d, i, j, t;
	//ŇpāAA̋ts߂ȂAb|āAx߂܂B
	d = GaloisField_Det(pGF, A, n);
	if(d) {
		for(i = 0; i < n; i++) {
			x[i] = 0;
			for(j = 0; j < n; j++) {
				t = GaloisField_Cof(pGF, A, n, j, i);
				//                   !!~~~~
				t = GaloisField_Div(pGF, t, d);
				t = GaloisField_Mul(pGF, t, b[j]);
				x[i] = GaloisField_Add(pGF, x[i], t);
			}
		}
	}
	//s񎮂Ԃ܂Bs񎮂0Ȃ΁Ax͋߂Ă܂B
	return d;
}
/****************************************************************************
 *	
 ****************************************************************************/
//쐬B
//[in]
//	pGF		KA
//[out]
//	߂l		
//[note]
// - KÂ̍쐬ƊJ́AĂяȍłȂĂB
// - KApGFWƂA255ȉ̑ƂĎgpo܂B
//   쐬̑́ASĂ̍̌W0łB
ST_Polynomial* Polynomial_New(ST_GaloisField* pGF) {
	ST_Polynomial* pP;
	//\̂̃mۂB
	pP = calloc(1, sizeof(ST_Polynomial));
	if(!pP) { DIE(); }
	//KẪ|C^i[B
	pP->pGF = pGF;
	//\̂̃ԂB
	return pP;
}
/*--------------------------------------------------------------------------*/
//JB
//[in]
//	pP		
void Polynomial_Free(ST_Polynomial* pP) {
//sv	//NULL|C^łȂ΁c
//sv	if(pP) {
		//\̂̃JB
		free(pP);
//sv	}
}
/*--------------------------------------------------------------------------*/
//擾B
//[in]
//	pP		
//[out]
//	߂l		
//[note]
//	- SĂ̌W0Ȃ΁Aɂ͎=(-)A֋XI(-1)ԂɂB
int Polynomial_Deg(ST_Polynomial* pP) {
	int i;
	//W0łȂŏʂ̍TB
	//SĂ̌W0Ȃ΁Aɂ͎=(-)A֋XI(-1)ԂɂB
	for(i = ARRAY_SIZE(pP->coef) - 1; i >= 0; i--) {
		//W0łȂ烋[v𔲂āA̍̎ԂB
		if(pP->coef[i]) { break; }
	}
	//W0łȂŏʂ̍̎,,-1ԂB
	return i;
}
/*--------------------------------------------------------------------------*/
//̌W擾B
//[in]
//	pP		
//	i		̎
//[out]
//	߂l		̌W
int Polynomial_GetCoef(ST_Polynomial* pP, int i) {
	if((unsigned)i >= (unsigned)ARRAY_SIZE(pP->coef)) { DIE(); }	//̎zTCYȏȂ΁AG[~B
	return pP->coef[i];
}
/*--------------------------------------------------------------------------*/
//̌Wݒ肷B
//[in]
//	pP		
//	i		̎
//	c		̌W
void Polynomial_SetCoef(ST_Polynomial* pP, int i, int c) {
	if((unsigned)i >= (unsigned)ARRAY_SIZE(pP->coef)) { DIE(); }	//̎zTCYȏȂ΁AG[~B
	if((unsigned)c > (unsigned)GaloisField_Max(pP->pGF)) { DIE(); }	//WKẪrbg\̍ől𒴂ĂAG[~B
	pP->coef[i] = c;
}
/*--------------------------------------------------------------------------*/
//̌WɁAځAZB
//[in]
//	pP		
//	i		̎
//	c		Zl
void Polynomial_AddCoef(ST_Polynomial* pP, int i, int c) {
	Polynomial_SetCoef(pP, i,
		GaloisField_Add(pP->pGF,	//Z
			Polynomial_GetCoef(pP, i),
			c));
}
/*--------------------------------------------------------------------------*/
//̌WɁAځAZB
//[in]
//	pP		
//	i		̎
//	c		Zl
void Polynomial_SubCoef(ST_Polynomial* pP, int i, int c) {
	Polynomial_SetCoef(pP, i,
		GaloisField_Sub(pP->pGF,	//Z
			Polynomial_GetCoef(pP, i),
			c));
}
/*--------------------------------------------------------------------------*/
//̌WɁAځAZB
//[in]
//	pP		
//	i		̎
//	c		Zl
void Polynomial_MulCoef(ST_Polynomial* pP, int i, int c) {
	Polynomial_SetCoef(pP, i,
		GaloisField_Mul(pP->pGF,	//Z
			Polynomial_GetCoef(pP, i),
			c));
}
/*--------------------------------------------------------------------------*/
//̌WɁAځAZB
//[in]
//	pP		
//	i		̎
//	c		Zl
void Polynomial_DivCoef(ST_Polynomial* pP, int i, int c) {
	Polynomial_SetCoef(pP, i,
		GaloisField_Div(pP->pGF,	//Z
			Polynomial_GetCoef(pP, i),
			c));
}
/*--------------------------------------------------------------------------*/
//{ˑ
ST_Polynomial* Polynomial_Add(ST_Polynomial* pP1, ST_Polynomial* pP2) {
	ST_GaloisField* pGF;
	ST_Polynomial* pP3;
	int i, c1, c2, c3;
	if(pP1->pGF != pP2->pGF) { DIE(); }	//P1P2قȂKȀ̑Ȃ΁AG[~B
	//KẪ|C^擾B
	pGF = pP1->pGF;
	//ʂi[鑽쐬B	ĂяoŊJB
	pP3 = Polynomial_New(pGF);
	//SĂ̍ɂāc
	for(i = 0; i < ARRAY_SIZE(pP1->coef); i++) {
		//1Ƒ2̍̌WZA3̍̌WɊi[B
		c1 = Polynomial_GetCoef(pP1, i);
		c2 = Polynomial_GetCoef(pP2, i);
		c3 = GaloisField_Add(pGF, c1, c2);	//Z
		Polynomial_SetCoef(pP3, i, c3);
	}
	//ʂi[ԂB
	return pP3;
}
/*--------------------------------------------------------------------------*/
//|ˑ
ST_Polynomial* Polynomial_Sub(ST_Polynomial* pP1, ST_Polynomial* pP2) {
	return Polynomial_Add(pP1, pP2);	//KȀł(Z=Z)
}
/*--------------------------------------------------------------------------*/
//~ˑ
ST_Polynomial* Polynomial_Mul(ST_Polynomial* pP1, ST_Polynomial* pP2) {
	ST_GaloisField* pGF;
	ST_Polynomial* pP3;
	int i1, c1, i2, c2, i3, c3;
	if(pP1->pGF != pP2->pGF) { DIE(); }	//P1P2قȂKȀ̑Ȃ΁AG[~B
	//KẪ|C^擾B
	pGF = pP1->pGF;
	//ʂi[鑽쐬B	ĂяoŊJB
	pP3 = Polynomial_New(pGF);
	//1̑SĂ̍ɂāc
	for(i1 = 0; i1 < ARRAY_SIZE(pP1->coef); i1++) {
		c1 = Polynomial_GetCoef(pP1, i1);
		//2̑SĂ̍ɂāc
		for(i2 = 0; i2 < ARRAY_SIZE(pP2->coef); i2++) {
			c2 = Polynomial_GetCoef(pP2, i2);
			//1Ƒ2̍̌WZB
			c3 = GaloisField_Mul(pGF, c1, c2);	//Z
			//Zʂ0łȂ΁A3̍ɉZB
			// - 'Zʂ0łȂ'Ƃf͕K{łB
			//   ȂƁA1,2̒lɌW炸A̎zTCYȏ̍ɑ΂ĉZ悤ƂāAPolynomial_AddCoef()G[~܂B
			//   A̔fsĂA1,2̎̍v̎zTCYȏゾꍇ́APolynomial_AddCoef()G[~܂B
			if(c3) {
				i3 = i1 + i2;
				Polynomial_AddCoef(pP3, i3, c3);
			}
		}
	}
	//ʂi[ԂB
	return pP3;
}
/*--------------------------------------------------------------------------*/
static void Polynomial_DivMod(ST_Polynomial* pP1, ST_Polynomial* pP2, ST_Polynomial** ppQuot, ST_Polynomial** ppRem) {
	ST_GaloisField* pGF;
	ST_Polynomial *pQuot, *pRem;
	int deg, div, quot, i1, i2;
	if(pP1->pGF != pP2->pGF) { DIE(); }	//P1P2قȂKȀ̑Ȃ΁AG[~B
	//KẪ|C^擾B
	pGF = pP1->pGF;
	//ʂi[鑽쐬B	ĂяoŊJB
	pQuot = Polynomial_New(pGF);
	pRem  = Polynomial_New(pGF);
	//2̎擾B
	deg = Polynomial_Deg(pP2);
	if(deg < 0) { DIE(); }			//0ZG[
	//2̍ŏʂ̍̌W擾B
	div = Polynomial_GetCoef(pP2, deg);
	//MZ[v
	for(i1 = ARRAY_SIZE(pP1->coef) - 1; i1 >= 0; i1--) {
		//폘̌グ
		memmove(&pRem->coef[1], &pRem->coef[0], ARRAY_SIZE(pRem->coef) - 1);		//pRem  *= x^1	ɂPolynomial_Mul()gׂAPȂ̂Ńőp鎖ɂB
		Polynomial_SetCoef(pRem, 0, Polynomial_GetCoef(pP1, i1));
		//Z
		quot = GaloisField_Div(pGF, Polynomial_GetCoef(pRem, deg), div);
		//̌グ
		memmove(&pQuot->coef[1], &pQuot->coef[0], ARRAY_SIZE(pQuot->coef) - 1);		//pQuot *= x^1	ɂPolynomial_Mul()gׂAPȂ̂Ńőp鎖ɂB
		Polynomial_SetCoef(pQuot, 0, quot);
		//Z
		for(i2 = ARRAY_SIZE(pP2->coef) - 1; i2 >= 0; i2--) {
			Polynomial_SubCoef(pRem, i2,
				GaloisField_Mul(pGF,
					Polynomial_GetCoef(pP2, i2),
					quot));
		}
	}
	//,,]̑i[Bi[Ȃ͊JB
	if(ppQuot) { *ppQuot = pQuot; } else { Polynomial_Free(pQuot); }
	if(ppRem ) { *ppRem  = pRem;  } else { Polynomial_Free(pRem);  }
}
/*- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */
//ˑ
ST_Polynomial* Polynomial_Div(ST_Polynomial* pP1, ST_Polynomial* pP2) {
	ST_Polynomial* pQuot;
	Polynomial_DivMod(pP1, pP2, &pQuot, NULL);	//
	return pQuot;
}
/*- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */
//ˑ
ST_Polynomial* Polynomial_Mod(ST_Polynomial* pP1, ST_Polynomial* pP2) {
	ST_Polynomial* pRem;
	Polynomial_DivMod(pP1, pP2, NULL, &pRem);	//]
	return pRem;
}
/*--------------------------------------------------------------------------*/
//̕ϐɒlʂ߂B
//[in]
//	pP		
//	x		l
//[out]
//	߂l		ʂ̒l
int Polynomial_Assign(ST_Polynomial* pP, int x) {
	int sum = 0;
	int x_i = 1;
	int i;
	for(i = 0; i < ARRAY_SIZE(pP->coef); i++) {
		//sum = sum + x^i
		sum = GaloisField_Add(pP->pGF,
			sum,
			GaloisField_Mul(pP->pGF,
				Polynomial_GetCoef(pP, i),
				x_i));
		//x^(i+1) = x^i * x
		x_i = GaloisField_Mul(pP->pGF,
			x_i,
			x);
	}
	return sum;
}
/*--------------------------------------------------------------------------*/
//\쐬B
//[in]
//	pP		
//[out]
//	߂l		
//[note]
//	- ֐Ԃ́AĂяoɂfree()ŊJĂB
char* Polynomial_Str(ST_Polynomial* pP) {
	char *s, **argv;
	int i, c, argc;
	argv = calloc(ARRAY_SIZE(pP->coef) + 1/*NULL*/, sizeof(char**));
	if(!argv) { DIE(); }
	argc = 0;
	for(i = ARRAY_SIZE(pP->coef) - 1; i >= 0; i--) {
		c = Polynomial_GetCoef(pP, i);
		if(c) {
			char* s;
			int a = GaloisField_Log(pP->pGF, c);
			switch(a) {
			case 0:
				switch(i) {
				case 0:  s = strdup_printf("1");       break;
				case 1:  s = strdup_printf("x");       break;
				default: s = strdup_printf("x^%d", i); break;
				}
				break;
			case 1:
				switch(i) {
				case 0:  s = strdup_printf("a");        break;
				case 1:  s = strdup_printf("ax");       break;
				default: s = strdup_printf("ax^%d", i); break;
				}
				break;
			default:
				switch(i) {
				case 0:  s = strdup_printf("a^%d",     a);    break;
				case 1:  s = strdup_printf("a^%dx",    a);    break;
				default: s = strdup_printf("a^%dx^%d", a, i); break;
				}
				break;
			}
			argv[argc++] = s;
		}
	}
	if(!argc) { argv[argc++] = strdup_printf("%d", 0); }	//SĂ̍̌W0ꍇ
	s = strjoinv(" + ", argv);
	strfreev(argv);
	return s;
}
/*--------------------------------------------------------------------------*/
//\p[Xđ쐬B
//[in]
//	pGF		KA
//	str		
//[out]
//	߂l		
//[note]
//	- \̏́APolynomial_Str()̏o͌`Ɍ݊łB
//		\	:	
//				|	\ (+|-) 
//				;
//				:	l
//				|	a
//				|	a^l
//				|	           x
//				|	           x^l
//				|	a      [*] x
//				|	a      [*] x^l
//				|	a^l [*] x
//				|	a^l [*] x^l
//				;
//		l		:	[0-9]+
//				;
//	- g[N̊Ԃɋ󔒕LĂĂ\܂B
//<>
//	ST_GaloisField* pGF=GaloisField_New(0x11D);
//	ST_Polynomial* pP=Polynomial_Parse(pGF,"a ^ 9 * x ^ 8 + a^7 x^6 + 5x^4 - a^3 + x^2 - ax - 1");
//	//                                                                       ~~~              ~ ǂx^0̍̌WȂ̂ōZ܂B
//	puts(Polynomial_Str(pP)); //a^9x^8 + a^7x^6 + a^50x^4 + x^2 + ax + a^223
ST_Polynomial* Polynomial_Parse(ST_GaloisField* pGF, const char* str) {
	ST_Polynomial* pP = Polynomial_New(pGF);			//쐬B
	char *s, **argv = strsplit_set(str, "+-", 0);			//ɕBKȀł(Z=Z)Ȃ̂'+''-'͋ʕsvłB
	int c, i, argc = 0;
	if(!(s = argv[argc++])) { goto L_ERR; }				//ŏ̍擾B΃G[~B<> ""
	do {
		while(isspace(*s)) { s++; }
		if(*s == '\0') { goto L_ERR; }				//󔒕̂̍LG[~B<> "a^5x^4 +  + a^3x^2"
		//--- W ---
		c = 1;
		//123...
		if(isdigit(*s)) {
			c = strtol(s, (char**)&s, 10);			//(base=10)K{B(base=0)ɂ'a^0x'0xvtBNXƌȂăp[XɎsB
			while(isspace(*s)) { s++; }
			//123*...
			if(*s == '*') {
				s++;	//'*'
				while(isspace(*s)) { s++; }
			}
		//a...
		} else if(*s == 'a') {
			s++;	//'a'
			while(isspace(*s)) { s++; }
			i = 1;
			//a^...
			if(*s == '^') {
				s++;	//'^'
				while(isspace(*s)) { s++; }
				//a^123...
				if(isdigit(*s)) {
					i = strtol(s, (char**)&s, 10);	//(base=10)K{B(base=0)ɂ'a^0x'0xvtBNXƌȂăp[XɎsB
					while(isspace(*s)) { s++; }
				} else {
					goto L_ERR;			//'a^'̌ɐl΃G[~B<> "a^x^2"
				}
			}
			//a[^123]...
			c = GaloisField_Exp(pGF, i);
			//a[^123]*...
			if(*s == '*') {
				s++;	//'*'
				while(isspace(*s)) { s++; }
			}
		}
		//--- ̎ ---
		i = 0;
		//[(123|a[^123])[*]]x...
		if(*s == 'x') {
			s++;	//'x'
			while(isspace(*s)) { s++; }
			i = 1;
			//[123|a[^123][*]]x^...
			if(*s == '^') {
				s++;	//'^'
				while(isspace(*s)) { s++; }
				//[123|a[^123][*]]x^123...
				if(isdigit(*s)) {
					i = strtol(s, (char**)&s, 10);	//(base=10)K{B(base=0)ɂ'a^0x'0xvtBNXƌȂăp[XɎsB
					while(isspace(*s)) { s++; }
				} else {
					goto L_ERR;			//'x^'̌ɐl΃G[~B<> "a^2 * x^y"
				}
			}
		}
		if(*s != '\0') { goto L_ERR; }				//̖ɗ]ȕL΃G[~B<> "a^2 * x^3 * x"
		//[(123|a[^123])[*]][x[^123]]
		Polynomial_AddCoef(pP, i, c);				//̍w肳ꂽꍇ̂߂Polynomial_SetCoef()ł͂ȂPolynomial_AddCoef()ƂBKȀł(Z=Z)Ȃ̂Polynomial_AddCoef()Polynomial_SubCoef()̎g͕svłB
	} while((s = argv[argc++]));					//̍擾BȂ烋[v𔲂B
	strfreev(argv);							//ɕJB
	return pP;							//ԂB
L_ERR:
	die("Polynomial_Parse:'%s'", str);
}
/*- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */
ST_Polynomial* Polynomial_ParseF(ST_GaloisField* pGF, const char* fmt, ...) {
	ST_Polynomial* pP;
	va_list ap;
	va_start(ap, fmt);
	pP = Polynomial_ParseV(pGF, fmt, ap);
	va_end(ap);
	return pP;
}
/*- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */
ST_Polynomial* Polynomial_ParseV(ST_GaloisField* pGF, const char* fmt, va_list ap) {
	char* str = strdup_vprintf(fmt, ap);
	ST_Polynomial* pP = Polynomial_Parse(pGF, str);
	free(str);
	return pP;
}
/****************************************************************************
 *	BCH
 ****************************************************************************/
//BCH̐쐬B
//[in]
//	pGF		KA
//	d		ԋ
//[out]
//	߂l		
//[note]
//	- pGFa^1,a^2,...,a^(d-1),y,̋ɎŏvZ܂B
static ST_Polynomial* BCH_GeneratorPolynomial_New(ST_GaloisField* pGF, int d/*=(2Q+1)*/) {
	ST_Polynomial* pP1 = Polynomial_Parse(pGF, "1");
	const int max = GaloisField_Max(pGF);
	int i;
	for(i = 1; i < d; i++) {
		int j = i;
		do {
			if((j <<= 1) >= max) { j -= max; }				//̋߂B
			if(!j) { DIE(); }						//max=(2^m)-1=Ȃ̂ŁAj=0ɂȂ鎖͖͂B(oO)
			if(j < i) { break; }						//iႢɈvAɊ|Ă̂Ŕ΂B
		} while(j != i);							//1Čɖ߂甲B
		if(j < i) { continue; }							//iႢɈvAɊ|Ă̂Ŕ΂B
		do {
			ST_Polynomial* pP2 = Polynomial_ParseF(pGF, "x - a^%d", j);	//(x-a),(x-a^2),(x-a^3),c
			ST_Polynomial* pP3 = Polynomial_Mul(pP1, pP2);			//(x-a)*(x-a^2)*(x-a^3)*c
			Polynomial_Free(pP1);
			Polynomial_Free(pP2);
			pP1 = pP3;
			if((j <<= 1) >= max) { j -= max; }				//̋߂B
		} while(j != i);							//1Čɖ߂甲B
	}
	for(i = Polynomial_Deg(pP1); i >= 0; i--) {					//ȏ̏ŋ߂́ASĂ̍̌W0,,1ł鎖mFB
		if(Polynomial_GetCoef(pP1, i) & ~1) { DIE(); }				//ȂĂȂ΁AoOłB
	}
	return pP1;
}
/*- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */
//BCH쐬B
//[in]
//	pGF		KA
//	q		\ꐔ
//[out]
//	߂l		BCH
ST_BCH* BCH_New(ST_GaloisField* pGF, int q) {
	ST_BCH* pBCH;
	//\̂̃mۂB
	pBCH = calloc(1, sizeof(ST_BCH));
	if(!pBCH) { DIE(); }
	//KẪ|C^i[B
	pBCH->pGF = pGF;
	//\ꐔ,ԋi[B
	pBCH->q = q;
	pBCH->d = q * 2 + 1;			//\ꐔQ̎Aԋd=(2Q+1)
	//BCH̐쐬B
	pBCH->pGP = BCH_GeneratorPolynomial_New(pBCH->pGF, pBCH->d);
	//ꐔ,񕄍ꐔ,ꐔi[B
	pBCH->n = GaloisField_Max(pBCH->pGF);	//ꐔ
	pBCH->m = Polynomial_Deg(pBCH->pGP);	//ꐔ
	pBCH->k = pBCH->n - pBCH->m;		//񕄍ꐔ
	if(pBCH->n <= pBCH->m) { DIE(); }	//ꐔꐔȉ,,񕄍ꐔ0ȉłĂ͂ȂȂB
	//\̂̃ԂB
	return pBCH;
}
/*--------------------------------------------------------------------------*/
//BCHJB
//[in]
//	pBCH		BCH
void BCH_Free(ST_BCH* pBCH) {
	//NULL|C^łȂ΁c
	if(pBCH) {
		//JB
		Polynomial_Free(pBCH->pGP);
		//\̂̃JB
		free(pBCH);
	}
}
/*--------------------------------------------------------------------------*/
//񕄍𕄍āAM쐬B
//[in]
//	pBCH		BCH
//	aInfo		񕄍		֐bitarray_lsb1st_get()ő삷̂ŁA[hACgĂKvL܂B
//[out]
//	aSend		M		֐bitarray_lsb1st_set()ő삷̂ŁA[hACgĂKvL܂B
void BCH_Encode(ST_BCH* pBCH, const void* aInfo/*int[(k+31)/32]*/, void* aSend/*int[(n+31)/32]*/) {
	ST_Polynomial *pP1, *pP2, *pP3;
	int i, t;
	//񑽍 * x^m
	pP1 = Polynomial_New(pBCH->pGF);
	for(i = 0; i < pBCH->k; i++) {
		t = bitarray_lsb1st_get(aInfo, i, 1);
		Polynomial_SetCoef(pP1, pBCH->m + i, t);
	}
	// = (񑽍 * x^m) % 
	pP2 = Polynomial_Mod(pP1, pBCH->pGP);
	//M = (񑽍 * x^m) + 
	pP3 = Polynomial_Add(pP1, pP2);
	//M̌WAMɊi[B
	for(i = 0; i < pBCH->n; i++) {
		t = Polynomial_GetCoef(pP3, i);
		bitarray_lsb1st_set(aSend, i, 1, t);
	}
	//JB
	Polynomial_Free(pP1);
	Polynomial_Free(pP2);
	Polynomial_Free(pP3);
}
/*- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */
void BCH_EncodeN(ST_BCH* pBCH, const void* aInfK/*int[(K+31)/32]*/, void* aSenN/*int[(N+31)/32]*/, int N) {	//ZkBCH
	void *aInfo, *aSend;
	int K, i, t;
	//ZkꐔABCH̑ꐔ,,ꐔȂ΁AG[~B
	if((N > pBCH->n) || (N < pBCH->m)) { DIE(); }
	//Zk񕄍ꐔ߂B
	K = N - pBCH->n + pBCH->k;
	//BCH̏񕄍ꐔɍ킹邽߂́AꎞIȃrbgzmۂB
	if(!(aInfo = bitarray_alloc(pBCH->k))) { DIE(); }
	//BCH̑ꐔɍ킹邽߂́AꎞIȃrbgzmۂB
	if(!(aSend = bitarray_alloc(pBCH->n))) { DIE(); }
	//w肳ꂽ񕄍AꎞIȃrbgzɃRs[BKȏ̃rbg0̂܂܂ƂB	//* Mon Oct 19 22:47:19 JST 2015 Naoyuki Sawa
	for(i = 0; i < K; i++) {									//- clipbary.cbitarray_lsb1st_copy(),bitarray_msb1st_copy()ǉ܂B
		t = bitarray_lsb1st_get(aInfK, i, 1);							//  L̏bitarray_lsb1st_copy(),bitarray_msb1st_copy()ɒučo܂B
		    bitarray_lsb1st_set(aInfo, i, 1, t);						//- AܕύXĂɌ؏oȂ̂ŁA܂ύXȂɂ܂B
	}												//  ɓW[𗘗pAvP[V쐬鎞ɁAύXČ؂\łB
	//BCH̑ꐔƏ񕄍ꐔpāAsB
	BCH_Encode(pBCH, aInfo, aSend);
	//ꎞIȃrbgzAw肳ꂽMɃRs[BNȏ̃rbĝ͎ĂB		//* Mon Oct 19 22:47:19 JST 2015 Naoyuki Sawa
	for(i = 0; i < N; i++) {									//- clipbary.cbitarray_lsb1st_copy(),bitarray_msb1st_copy()ǉ܂B
		t = bitarray_lsb1st_get(aSend, i, 1);							//  L̏bitarray_lsb1st_copy(),bitarray_msb1st_copy()ɒučo܂B
		    bitarray_lsb1st_set(aSenN, i, 1, t);						//- AܕύXĂɌ؏oȂ̂ŁA܂ύXȂɂ܂B
	}												//  ɓW[𗘗pAvP[V쐬鎞ɁAύXČ؂\łB
	//ꎞIȃrbgzJB
	bitarray_free(aInfo);
	bitarray_free(aSend);
}
/*--------------------------------------------------------------------------*/
//gD[vbcs쐬B
//[in]
//	s[n*2]		gD[vbcs̗vfƂȂlBs[0]͎QƂȂB
//[out]
//	߂l		gD[vbcsBĂяoɂfree()ŊJB
//[note]
//	- ɂ́A֐쐬śAgD[vbcs̍E]`łB
//	  ₷̓sAĂяȍ܂߂āAE]`ɂ܂B
//	- s[]̗vfƁAoA[][]̗vf̑Ή́Aȉ̒ʂłB
//	  n=2̏ꍇ
//		s[1] s[2]
//		s[2] s[3]
//	  n=3̏ꍇ
//		s[1] s[2] s[3]
//		s[2] s[3] s[4]
//		s[3] s[4] s[5]
//	  n=4̏ꍇ
//		s[1] s[2] s[3] s[4]
//		s[2] s[3] s[4] s[5]
//		s[3] s[4] s[5] s[6]
//		s[4] s[5] s[6] s[7]
//	  n=5`̏ꍇl
static uint8_t* BCH_ToeplitzMatrix_New(const uint8_t* s/*[n*2]*/, int n) {
	uint8_t* A;
	int i, j;
	if(n < 1) { DIE(); }
	A = malloc(n * n);
	if(!A) { DIE(); }
	for(i = 0; i < n; i++) {
		for(j = 0; j < n; j++) {
			A[(n * i) + j] = s[1 + i + j];
			//~~~~~~~~~~~BCH_ToeplitzMatrix_New()ReedSolomon_VanDerMonde_New()Ƃŋtł鎖ɒ
		}
	}
	return A;
}
/*- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */
//M𕜍āA񕄍쐬B
//[in]
//	pBCH		BCH
//	aRecv		M		֐bitarray_lsb1st_get()ő삷̂ŁA[hACgĂKvL܂B
//[out]
//	aInfo		񕄍		֐bitarray_lsb1st_set()ő삷̂ŁA[hACgĂKvL܂B
//	߂l		肪΁A0ԂB			̏ꍇAaInfoɐ񕄍i[B
//			肪LAoꍇ́AԂB	
//			肪LAs\Ȃ΁A(-1)ԂB	̏ꍇAaInfo̓e͕s(ۂɂ͒Ȍ񕄍)ƂȂB
//[note]
//	- AvP[V̊ϓ_́A߂l(-1)łȂ΁AaInfoɐ񕄍ꂪi[ĂƌȂč\ȂB
//	  A\ꐔ𒴂ɂāARɈvꍇƂ̋ʂ͏oȂB(̌̏ꍇl)
//	- QƎ
//	  wV 蒼̂߂̍HƐw ʐMҁx(CQoŎ)
//	  u9.6 BCH̕v(p.122`p.126)
//	  u9.7 ̃rbgBCHv(p.126`p.136)  ɂꂪQlɂȂBʒuo̐ՂB
int BCH_Decode(ST_BCH* pBCH, const void* aRecv/*int[(n+31)/32]*/, void* aInfo/*int[(k+31)/32]*/) {
	ST_Polynomial* pP;
	int i, q, t;
	uint8_t *A, s[256], x[256];
	//--- @Vh[ľvZ ---
	//M쐬B
	pP = Polynomial_New(pBCH->pGF);
	for(i = 0; i < pBCH->n; i++) {
		t = bitarray_lsb1st_get(aRecv, i, 1);
		Polynomial_SetCoef(pP, i, t);
		//M̂A񕄍̕Ȃ΁c
		if(i >= pBCH->m) {
			//Ȍ񕄍i[ĂB
			// - 肪΁Â܂܌ʂƂȂB肪L΁Ǎ̏ŒB
			bitarray_lsb1st_set(aInfo, i - pBCH->m, 1, t);
		}
	}
	//Vh[vZB
	// - s[i-1]=Si=P(a^i),i=1`d-1
	t = 0;
	for(i = 1; i < pBCH->d; i++) {	//a^1`a^(d-1)
		//QƎ
		//http://ja.wikipedia.org/wiki/]̒藝
		//Ɋւ]̒藝́Af(x)jbN(=ō̌W1ł)񍀈ꎟx-aŊƂ̏]f(a)łƂ藝B
		//܂ƂɁAf(a)=0Ȃf(x)x-aɎƂ](=藝)B
		s[i - 1] = Polynomial_Assign(pP, GaloisField_Exp(pBCH->pGF, i));	//Si=P(a^i),i=1`d-1
		t |= s[i - 1];
	}
	//MJB
	Polynomial_Free(pP);
	//Vh[S0Ȃ΁AsvȂ̂ł܂ŁB
	if(!t) { return 0; }	//薳
	//--- Ãrbg̎Zo ---
	//--- Bʒuo ^L(x) ̌WvZ ---
	//Q`1̏Ɂc
	for(q = pBCH->q; q; q--) {
		//gD[vbcs쐬B
		A = BCH_ToeplitzMatrix_New(s, q);
		//Ả߂B
		// - Ả́AʒuǒWƂȂB
		//   x[0] = L1, x[1] = L2, ..., x[q-2] = L(q-1), x[q-1] = Lq
		t = GaloisField_Solve(pBCH->pGF, A, s, x, q);
		//gD[vbcsJB
		free(A);
		//Ả܂A[v𔲂B
		if(t) { break; }
	}
	//ǂ̌ɑ΂ĂAẢ܂Ȃ΁As\Ȃ̂ł܂ŁB
	if(!q) { return -1; }	//s\
	//--- C肪rbgʒǔvZ ---
	//--- D̒ ---
	//ʒuo쐬B
	// - ʒuo = Lq * x^q + L(q-1) * x^(q-1) + ... + L2 * x^2 + L1 * x + 1
	pP = Polynomial_Parse(pBCH->pGF, "1");
	for(i = 1; i <= q; i++) {
		Polynomial_SetCoef(pP, i, x[i - 1]);
	}
	//ʒu x = a^(m+i) (i=0,1,2,...,(k-1)) ɁAʒuoɑB
	// - ̕aInfo[]Ɋ܂܂Ȃ̂ŁAa^0`a^(m-1) ͒̕KvB
	for(i = 0; i < pBCH->k; i++) {
		//ʂ0ɂȂc
		if(!Polynomial_Assign(pP, GaloisField_Exp(pBCH->pGF, pBCH->m + i))) {
			//̈ʒȕ񕄍́Arbg𔽓]B
			t = bitarray_lsb1st_get(aInfo, i, 1);
			    bitarray_lsb1st_set(aInfo, i, 1, t ^ 1);
		}
	}
	//ʒuoJB
	Polynomial_Free(pP);
	//ԂB
	return q;
}
/*- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */
int BCH_DecodeN(ST_BCH* pBCH, const void* aRecN/*int[(N+31)/32]*/, void* aInfK/*int[(K+31)/32]*/, int N) {	//ZkBCH
	void *aInfo, *aRecv;
	int K, i, t, q;
	//ZkꐔABCH̑ꐔ,,ꐔȂ΁AG[~B
	if((N > pBCH->n) || (N < pBCH->m)) { DIE(); }
	//Zk񕄍ꐔ߂B
	K = N - pBCH->n + pBCH->k;
	//BCH̏񕄍ꐔɍ킹邽߂́AꎞIȃrbgzmۂB
	if(!(aInfo = bitarray_alloc(pBCH->k))) { DIE(); }
	//BCH̑ꐔɍ킹邽߂́AꎞIȃrbgzmۂB
	if(!(aRecv = bitarray_alloc(pBCH->n))) { DIE(); }
	//w肳ꂽMAꎞIȃrbgzɃRs[BNȏ̃rbg0̂܂܂ƂB	//* Mon Oct 19 22:47:19 JST 2015 Naoyuki Sawa
	for(i = 0; i < N; i++) {									//- clipbary.cbitarray_lsb1st_copy(),bitarray_msb1st_copy()ǉ܂B
		t = bitarray_lsb1st_get(aRecN, i, 1);							//  L̏bitarray_lsb1st_copy(),bitarray_msb1st_copy()ɒučo܂B
		    bitarray_lsb1st_set(aRecv, i, 1, t);						//- AܕύXĂɌ؏oȂ̂ŁA܂ύXȂɂ܂B
	}												//  ɓW[𗘗pAvP[V쐬鎞ɁAύXČ؂\łB
	//BCH̑ꐔƏ񕄍ꐔpāAsB
	q = BCH_Decode(pBCH, aRecv, aInfo);
	//ꎞIȃrbgzAw肳ꂽ񕄍ɃRs[BKȏ̃rbĝ͎ĂB		//* Mon Oct 19 22:47:19 JST 2015 Naoyuki Sawa
	for(i = 0; i < K; i++) {									//- clipbary.cbitarray_lsb1st_copy(),bitarray_msb1st_copy()ǉ܂B
		t = bitarray_lsb1st_get(aInfo, i, 1);							//  L̏bitarray_lsb1st_copy(),bitarray_msb1st_copy()ɒučo܂B
		    bitarray_lsb1st_set(aInfK, i, 1, t);						//- AܕύXĂɌ؏oȂ̂ŁA܂ύXȂɂ܂B
	}												//  ɓW[𗘗pAvP[V쐬鎞ɁAύXČ؂\łB
	//ꎞIȃrbgzJB
	bitarray_free(aInfo);
	bitarray_free(aRecv);
	return q;
}
/****************************************************************************
 *	[h\
 ****************************************************************************/
//[h\̐쐬B
//[in]
//	pGF		KA
//	deg		
//[out]
//	߂l		
//[note]
//	- (x-a^0)~(x-a^1)~...~(x-a^(deg-1)) vZ܂B
static ST_Polynomial* ReedSolomon_GeneratorPolynomial_New(ST_GaloisField* pGF, int deg) {
	ST_Polynomial* pP1 = Polynomial_Parse(pGF, "1");			//( 0 )̐ = 1
	int i;
	for(i = 0; i < deg; i++) {						//i=0`(deg-1)ɂāc
		ST_Polynomial* pP2 = Polynomial_ParseF(pGF, "x - a^%d", i);	//                                        (x-a^i)
		ST_Polynomial* pP3 = Polynomial_Mul(pP1, pP2);			//(i+1)̐ = i̐ * (x-a^i)
		Polynomial_Free(pP1);
		Polynomial_Free(pP2);
		pP1 = pP3;
	}
	return pP1;								//(deg)̐ԂB
}
/*- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */
//[h\쐬B
//[in]
//	pGF		KA
//	q		\ꐔ
//[out]
//	߂l		[h\
ST_ReedSolomon* ReedSolomon_New(ST_GaloisField* pGF, int q) {
	ST_ReedSolomon* pRS;
	//\̂̃mۂB
	pRS = calloc(1, sizeof(ST_ReedSolomon));
	if(!pRS) { DIE(); }
	//KẪ|C^i[B
	pRS->pGF = pGF;
	//\ꐔ,ԋi[B
	pRS->q = q;
	pRS->d = q * 2 + 1;			//\ꐔQ̎Aԋd=(2Q+1)
	//ꐔ,񕄍ꐔ,ꐔi[B
	pRS->n = GaloisField_Max(pRS->pGF);	//ꐔ
	pRS->m = pRS->d - 1;			//ꐔ
	pRS->k = pRS->n - pRS->m;		//񕄍ꐔ
	if(pRS->n <= pRS->m) { DIE(); }		//ꐔꐔȉ,,񕄍ꐔ0ȉłĂ͂ȂȂB
	//[h\̐쐬B
	pRS->pGP = ReedSolomon_GeneratorPolynomial_New(pRS->pGF,
		pRS->m);	//̎=ꐔ		ꐔ͐̍ŏʂ̌W(1)܂܂Ȃ̂-1͕svB
	//\̂̃ԂB
	return pRS;
}
/*- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */
//ꐔw肵āA[h\쐬B
//[in]
//	pGF		KA
//	m		ꐔ
//[out]
//	߂l		[h\
//[note]
//	- AQRR[hɑΉ鎞̂߂ɁA쐬֐łB
//	  ReedSolomon_New() ł́Aꐔ̃[h\킵쐬o܂B
//	  QRR[h̎dlɂ́Aꐔ̏ꍇL邽߁Â߂̊֐pӂ܂B
ST_ReedSolomon* ReedSolomon_NewM(ST_GaloisField* pGF, int m) {	//QRR[hp
	ST_ReedSolomon* pRS;
	//\̂̃mۂB
	pRS = calloc(1, sizeof(ST_ReedSolomon));
	if(!pRS) { DIE(); }
	//KẪ|C^i[B
	pRS->pGF = pGF;
	//ꐔ,񕄍ꐔ,ꐔi[B
	pRS->n = GaloisField_Max(pRS->pGF);	//ꐔ
	pRS->m = m;				//ꐔ
	pRS->k = pRS->n - pRS->m;		//񕄍ꐔ
	if(pRS->n <= pRS->m) { DIE(); }		//ꐔꐔȉ,,񕄍ꐔ0ȉłĂ͂ȂȂB
	//\ꐔ,ԋi[B
	pRS->d = (pRS->m + 1);			//ꐔm̎Aԋd=(m+1)
	pRS->q = (pRS->d - 1) / 2;		//ԋd̎A\ꐔQ=(d-1)/2
	//[h\̐쐬B
	pRS->pGP = ReedSolomon_GeneratorPolynomial_New(pRS->pGF,
		pRS->m);	//̎=ꐔ		ꐔ͐̍ŏʂ̌W(1)܂܂Ȃ̂-1͕svB
	//\̂̃ԂB
	return pRS;
}
/*--------------------------------------------------------------------------*/
//[h\JB
//[in]
//	pRS		[h\
void ReedSolomon_Free(ST_ReedSolomon* pRS) {
	//NULL|C^łȂ΁c
	if(pRS) {
		//JB
		Polynomial_Free(pRS->pGP);
		//\̂̃JB
		free(pRS);
	}
}
/*--------------------------------------------------------------------------*/
//񕄍𕄍āAM쐬B
//[in]
//	pRS		[h\
//	aInfo		񕄍		֐bitarray_lsb1st_get()ő삷̂ŁA[hACgĂKvL܂B
//[out]
//	aSend		M		֐bitarray_lsb1st_set()ő삷̂ŁA[hACgĂKvL܂B
void ReedSolomon_Encode(ST_ReedSolomon* pRS, const void* aInfo/*int[(r*k+31)/32]*/, void* aSend/*int[(r*n+31)/32]*/) {	//r=pGF->deg
	const int r = GaloisField_Deg(pRS->pGF);
	ST_Polynomial *pP1, *pP2, *pP3;
	int i, t;
	//񑽍 * x^m
	pP1 = Polynomial_New(pRS->pGF);
	for(i = 0; i < pRS->k; i++) {
		t = bitarray_lsb1st_get(aInfo, r * i, r);
		Polynomial_SetCoef(pP1, pRS->m + i, t);
	}
	// = (񑽍 * x^m) % 
	pP2 = Polynomial_Mod(pP1, pRS->pGP);
	//M = (񑽍 * x^m) + 
	pP3 = Polynomial_Add(pP1, pP2);
	//M̌WAMɊi[B
	for(i = 0; i < pRS->n; i++) {
		t = Polynomial_GetCoef(pP3, i);
		bitarray_lsb1st_set(aSend, r * i, r, t);
	}
	//JB
	Polynomial_Free(pP1);
	Polynomial_Free(pP2);
	Polynomial_Free(pP3);
}
/*- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */
void ReedSolomon_EncodeN(ST_ReedSolomon* pRS, const void* aInfK/*int[(r*K+31)/32]*/, void* aSenN/*int[(r*N+31)/32]*/, int N) {	//r=pGF->deg	//ZkRS
	const int r = GaloisField_Deg(pRS->pGF);
	void *aInfo, *aSend;
	int K, i, t;
	//ZkꐔA[h\̑ꐔ,,ꐔȂ΁AG[~B
	if((N > pRS->n) || (N < pRS->m)) { DIE(); }
	//Zk񕄍ꐔ߂B
	K = N - pRS->n + pRS->k;
	//[h\̏񕄍ꐔɍ킹邽߂́AꎞIȃrbgzmۂB
	if(!(aInfo = bitarray_alloc(r * pRS->k))) { DIE(); }
	//[h\̑ꐔɍ킹邽߂́AꎞIȃrbgzmۂB
	if(!(aSend = bitarray_alloc(r * pRS->n))) { DIE(); }
	//w肳ꂽ񕄍AꎞIȃrbgzɃRs[BKȏ̃rbg0̂܂܂ƂB	//* Mon Oct 19 22:47:19 JST 2015 Naoyuki Sawa
	for(i = 0; i < K; i++) {									//- clipbary.cbitarray_lsb1st_copy(),bitarray_msb1st_copy()ǉ܂B
		t = bitarray_lsb1st_get(aInfK, r * i, r);						//  L̏bitarray_lsb1st_copy(),bitarray_msb1st_copy()ɒučo܂B
		    bitarray_lsb1st_set(aInfo, r * i, r, t);						//- AܕύXĂɌ؏oȂ̂ŁA܂ύXȂɂ܂B
	}												//  ɓW[𗘗pAvP[V쐬鎞ɁAύXČ؂\łB
	//[h\̑ꐔƏ񕄍ꐔpāAsB
	ReedSolomon_Encode(pRS, aInfo, aSend);
	//ꎞIȃrbgzAw肳ꂽMɃRs[BNȏ̃rbĝ͎ĂB		//* Mon Oct 19 22:47:19 JST 2015 Naoyuki Sawa
	for(i = 0; i < N; i++) {									//- clipbary.cbitarray_lsb1st_copy(),bitarray_msb1st_copy()ǉ܂B
		t = bitarray_lsb1st_get(aSend, r * i, r);						//  L̏bitarray_lsb1st_copy(),bitarray_msb1st_copy()ɒučo܂B
		    bitarray_lsb1st_set(aSenN, r * i, r, t);						//- AܕύXĂɌ؏oȂ̂ŁA܂ύXȂɂ܂B
	}												//  ɓW[𗘗pAvP[V쐬鎞ɁAύXČ؂\łB
	//ꎞIȃrbgzJB
	bitarray_free(aInfo);
	bitarray_free(aSend);
}
/*--------------------------------------------------------------------------*/
//t@fAfs쐬B
//[in]
//	s[n*2]		t@fAfs̓䐔̌WB
//[out]
//	߂l		t@fAfsBĂяoɂfree()ŊJB
//[note]
//	- x[]̗vfƁAoA[][]̗vf̑Ή́Aȉ̒ʂłB
//	  n=2̏ꍇ
//		1          1       
//		a^x[0]     a^ x[1] 
//	  n=3̏ꍇ
//		1          1          1          
//		a^ x[0]    a^ x[1]    a^ x[2]    
//		a^(x[0]*2) a^(x[1]*2) a^(x[2]*2) 
//	  n=4̏ꍇ
//		1          1          1          1          
//		a^ x[0]    a^ x[1]    a^ x[2]    a^ x[3]    
//		a^(x[0]*2) a^(x[1]*2) a^(x[2]*2) a^(x[3]*2) 
//		a^(x[0]*3) a^(x[1]*3) a^(x[2]*3) a^(x[3]*3) 
//	  n=5`̏ꍇl
static uint8_t* ReedSolomon_VanDerMonde_New(ST_GaloisField* pGF, const uint8_t* x/*[n]*/, int n) {
	uint8_t* A;
	int i, j, t, u;
	if(n < 1) { DIE(); }
	A = malloc(n * n);
	if(!A) { DIE(); }
	for(i = 0; i < n; i++) {
		t = 1;
		u = GaloisField_Exp(pGF, *x++);		//   a^x[0]
		for(j = 0; j < n; j++) {
			A[(n * j) + i] = t;
			//~~~~~~~~~~~BCH_ToeplitzMatrix_New()ReedSolomon_VanDerMonde_New()Ƃŋtł鎖ɒ
			t = GaloisField_Mul(pGF, t, u);	//1a^x[i]a^(x[i]*2)...a^(x[i]*(n-1))
		}
	}
	return A;
}
/*- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */
//M𕜍āA񕄍쐬B
//[in]
//	pRS		[h\
//	aRecv		M		֐bitarray_lsb1st_get()ő삷̂ŁA[hACgĂKvL܂B
//[out]
//	aInfo		񕄍		֐bitarray_lsb1st_set()ő삷̂ŁA[hACgĂKvL܂B
//	߂l		肪΁A0ԂB			̏ꍇAaInfoɐ񕄍i[B
//			肪LAoꍇ́AԂB	
//			肪LAs\Ȃ΁A(-1)ԂB	̏ꍇAaInfo̓e͕s(ۂɂ͒Ȍ񕄍)ƂȂB
//[note]
//	- AvP[V̊ϓ_́A߂l(-1)łȂ΁AaInfoɐ񕄍ꂪi[ĂƌȂč\ȂB
//	  A\ꐔ𒴂ɂāARɈvꍇƂ̋ʂ͏oȂB(̌̏ꍇl)
//	- QƎ
//	  wV 蒼̂߂̍HƐw ʐMҁx(CQoŎ)
//	  u10.3 RS̕v(p.143`p.147)
//	  u10.4 ̃rbgRSv(p.148`p.157)  ɂꂪQlɂȂBʒuo,e̐ՂB
int ReedSolomon_Decode(ST_ReedSolomon* pRS, const void* aRecv/*int[(r*n+31)/32]*/, void* aInfo/*int[(r*k+31)/32]*/) {	//r=pGF->deg
	const int r = GaloisField_Deg(pRS->pGF);
	ST_Polynomial* pP;
	int i, q, t;
	uint8_t *A, s[256], x[256], y[256];
	//--- @Vh[ľvZ ---
	//M쐬B
	pP = Polynomial_New(pRS->pGF);
	for(i = 0; i < pRS->n; i++) {
		t = bitarray_lsb1st_get(aRecv, r * i, r);
		Polynomial_SetCoef(pP, i, t);
		//M̂A񕄍̕Ȃ΁c
		if(i >= pRS->m) {
			//Ȍ񕄍i[ĂB
			// - 肪΁Â܂܌ʂƂȂB肪L΁Ǎ̏ŒB
			bitarray_lsb1st_set(aInfo, r * (i - pRS->m), r, t);
		}
	}
	//Vh[vZB
	// - s[i]=Si=P(a^i),i=0`m-1
	t = 0;
	for(i = 0; i < pRS->m; i++) {	//a^0`a^(m-1)
		//QƎ
		//http://ja.wikipedia.org/wiki/]̒藝
		//Ɋւ]̒藝́Af(x)jbN(=ō̌W1ł)񍀈ꎟx-aŊƂ̏]f(a)łƂ藝B
		//܂ƂɁAf(a)=0Ȃf(x)x-aɎƂ](=藝)B
		s[i] = Polynomial_Assign(pP, GaloisField_Exp(pRS->pGF, i));	//Si=P(a^i),i=0`m-1
		t |= s[i];
	}
	//MJB
	Polynomial_Free(pP);
	//Vh[S0Ȃ΁AsvȂ̂ł܂ŁB
	if(!t) { return 0; }	//薳
	//--- ÃubN̎Zo ---
	//--- Bʒuo ^L(x) ̌WvZ ---
	//Q`1̏Ɂc
	for(q = pRS->q; q; q--) {
		//gD[vbcs쐬B
		A = BCH_ToeplitzMatrix_New(s, q);	//BCH̏ƓȂ̂ŁABCH̃Tu[`̂܂܎gp鎖ɂB
		//Ả߂B
		// - Ả́AʒuǒWƂȂB
		//   x[0] = L1, x[1] = L2, ..., x[q-2] = L(q-1), x[q-1] = Lq
		t = GaloisField_Solve(pRS->pGF, A, s, x, q);
		//gD[vbcsJB
		free(A);
		//Ả܂A[v𔲂B
		if(t) { break; }
	}
	//ǂ̌ɑ΂ĂAẢ܂Ȃ΁As\Ȃ̂ł܂ŁB
	if(!q) { return -1; }	//s\
	//--- C肪ubNʒǔvZ ---
	//ʒuo쐬B
	// - ʒuo = Lq * x^q + L(q-1) * x^(q-1) + ... + L2 * x^2 + L1 * x + 1
	pP = Polynomial_Parse(pRS->pGF, "1");
	for(i = 1; i <= q; i++) {
		Polynomial_SetCoef(pP, i, x[i - 1]);
	}
	//ʒu x = a^i (i=0,1,2,...,(n-1)) ɁAʒuoɑB
	// - BCH_Decode()ł͏񕄍̕ŗǂAReedSolomon_Decode()ł͌̕܂߂ĎsKvL܂B
	//   ̌̏ŁAe߂ɁA̕܂߂āASĂ̌ʒuKvłB
	t = 0;
	for(i = 0; i < pRS->n; i++) {
		//ʂ0ɂȂc
		if(!Polynomial_Assign(pP, GaloisField_Exp(pRS->pGF, i))) {
			//ʒui[B
			if(t < q) { x[t] = i; }	//\ꐔ𒴂肪ꍇAʂ0ɂȂӏAq,,q߂ɂȂ鎖LB
			t++;
		}
	}
	//ʒuoJB
	Polynomial_Free(pP);
	//\ꐔ𒴂肪ꍇAʂ0ɂȂӏAq,,q߂ɂȂ鎖LB
	if(t != q) { return -1; }
	//--- DľvZ(e𗘗p) ---
	//t@fAfs쐬B
	// - t@fAfśAe̍s\łB
	A = ReedSolomon_VanDerMonde_New(pRS->pGF, x, q);
	//Ả߂B
	// - Ả́AeƂȂB
	//   x[0] = E1, x[1] = E2, ..., x[q-2] = E(q-1), x[q-1] = Eq
	t = GaloisField_Solve(pRS->pGF, A, s, y, q);
	if(!t) { DIE(); }
	//t@fAfsJB
	free(A);
	//--- E̒ ---
	//X̌ʒuɂāc
	for(i = 0; i < q; i++) {
		//񕄍̕Ȃ΁c
		if(x[i] >= pRS->m) {
			//̈ʒȕ񕄍́Arbg𔽓]B	KȀ̉Z̓rbg𔽓]Ɠ
			t = bitarray_lsb1st_get(aInfo, r * (x[i] - pRS->m), r);
			    bitarray_lsb1st_set(aInfo, r * (x[i] - pRS->m), r, t ^ y[i]);
		}
	}
	//ԂB
	return q;
}
/*- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */
int ReedSolomon_DecodeN(ST_ReedSolomon* pRS, const void* aRecN/*int[(r*N+31)/32]*/, void* aInfK/*int[(r*K+31)/32]*/, int N) {	//r=pGF->deg	//ZkRS
	const int r = GaloisField_Deg(pRS->pGF);
	void *aInfo, *aRecv;
	int K, i, t, q;
	//ZkꐔA[h\̑ꐔ,,ꐔȂ΁AG[~B
	if((N > pRS->n) || (N < pRS->m)) { DIE(); }
	//Zk񕄍ꐔ߂B
	K = N - pRS->n + pRS->k;
	//[h\̏񕄍ꐔɍ킹邽߂́AꎞIȃrbgzmۂB
	if(!(aInfo = bitarray_alloc(r * pRS->k))) { DIE(); }
	//[h\̑ꐔɍ킹邽߂́AꎞIȃrbgzmۂB
	if(!(aRecv = bitarray_alloc(r * pRS->n))) { DIE(); }
	//w肳ꂽMAꎞIȃrbgzɃRs[BNȏ̃rbg0̂܂܂ƂB	//* Mon Oct 19 22:47:19 JST 2015 Naoyuki Sawa
	for(i = 0; i < N; i++) {									//- clipbary.cbitarray_lsb1st_copy(),bitarray_msb1st_copy()ǉ܂B
		t = bitarray_lsb1st_get(aRecN, r * i, r);						//  L̏bitarray_lsb1st_copy(),bitarray_msb1st_copy()ɒučo܂B
		    bitarray_lsb1st_set(aRecv, r * i, r, t);						//- AܕύXĂɌ؏oȂ̂ŁA܂ύXȂɂ܂B
	}												//  ɓW[𗘗pAvP[V쐬鎞ɁAύXČ؂\łB
	//[h\̑ꐔƏ񕄍ꐔpāAsB
	q = ReedSolomon_Decode(pRS, aRecv, aInfo);
	//ꎞIȃrbgzAw肳ꂽ񕄍ɃRs[BKȏ̃rbĝ͎ĂB		//* Mon Oct 19 22:47:19 JST 2015 Naoyuki Sawa
	for(i = 0; i < K; i++) {									//- clipbary.cbitarray_lsb1st_copy(),bitarray_msb1st_copy()ǉ܂B
		t = bitarray_lsb1st_get(aInfo, r * i, r);						//  L̏bitarray_lsb1st_copy(),bitarray_msb1st_copy()ɒučo܂B
		    bitarray_lsb1st_set(aInfK, r * i, r, t);						//- AܕύXĂɌ؏oȂ̂ŁA܂ύXȂɂ܂B
	}												//  ɓW[𗘗pAvP[V쐬鎞ɁAύXČ؂\łB
	//ꎞIȃrbgzJB
	bitarray_free(aInfo);
	bitarray_free(aRecv);
	return q;
}
/****************************************************************************
 *	gp
 ****************************************************************************/
#if 0
//JIS X 0510:2004񎟌޼-QR-{dl
//p.65C(K)`<>ݺ,޺ނ:
void TestBCH(){
  ST_GaloisField* pGF;
  ST_BCH* pBCH;
  int i,t;
  int src[( 5+31)/32];
  int dst[(15+31)/32];
  //---  ---
  pGF=GaloisField_New(0x13);//nw肵Ķ۱̂𐶐
  pBCH=BCH_New(pGF,3);//\ꐔw肵BCH쐬
  printf("(%d,%d)BCH\n",pBCH->n,pBCH->k);//(15,5)BCH
  //--- M ---
  bitarray_lsb1st_set(src,0,1,1);//񕄍=00101
  bitarray_lsb1st_set(src,2,1,1);//
  printf("񕄍=");
  for(i=(pBCH->k-1);i>=0;i--){
    t=bitarray_lsb1st_get(src,i,1);
    printf("%d",t);//񕄍=00101
  }
  printf("\n");
  BCH_Encode(pBCH,src,dst);//5ޯĂ̏񕄍ݺނ15ޯĂ̑M쐬
  printf("M=");
  for(i=(pBCH->n-1);i>=0;i--){
    t=bitarray_lsb1st_get(dst,i,1);
    printf("%d",t);//M=001010011011100
  }
  printf("\n");
  //--- M ---
  i= 0;bitarray_lsb1st_set(dst,i,1,bitarray_lsb1st_get(dst,i,1)^1);//1
  i= 5;bitarray_lsb1st_set(dst,i,1,bitarray_lsb1st_get(dst,i,1)^1);//2
  i=10;bitarray_lsb1st_set(dst,i,1,bitarray_lsb1st_get(dst,i,1)^1);//3
  printf("M=");
  for(i=(pBCH->n-1);i>=0;i--){
    t=bitarray_lsb1st_get(dst,i,1);
    printf("%d",t);//M=001000011111101
  }
  printf("\n");
  t=BCH_Decode(pBCH,dst,src);//15ޯĂ̎M޺ނ5ޯĂ̏񕄍쐬
  printf("=%d\n",t);//=3
  printf("񕄍=");
  for(i=(pBCH->k-1);i>=0;i--){
    t=bitarray_lsb1st_get(src,i,1);
    printf("%d",t);//񕄍=00101
  }
  printf("\n");
  //--- J ---
  BCH_Free(pBCH);//BCHJ
  GaloisField_Free(pGF);//۱̂J
}
/*--------------------------------------------------------------------------*/
//JIS X 0510:2004񎟌޼-QR-{dl
//p.73G(Ql)ق̕ᣂ<菇1,2>ݺ,޺ނ:
void TestRS(){
  ST_GaloisField* pGF;
  ST_ReedSolomon* pRS;
  int i,t;
  int src[(8*16+31)/32];
  int dst[(8*26+31)/32];
  //---  ---
  pGF=GaloisField_New(0x11D);//nw肵Ķ۱̂𐶐
  pRS=ReedSolomon_New(pGF,5);//\ꐔw肵RS쐬
  printf("(%d,%d)RS\n",26,(26-pRS->m));//(26,16)RS
  //--- M ---
  src[3]=BIN32(00010000,00100000,00001100,01010110);
  src[2]=BIN32(01100001,10000000,11101100,00010001);
  src[1]=BIN32(11101100,00010001,11101100,00010001);
  src[0]=BIN32(11101100,00010001,11101100,00010001);
  printf("񕄍=");
  for(i=(8*16-8);i>=0;i-=8){
    t=bitarray_lsb1st_get(src,i,8);
    printf("%02X ",t);//񕄍=10 20 0C 56 61 80 EC 11 EC 11 EC 11 EC 11 EC 11
  }
  printf("\n");
  ReedSolomon_EncodeN(pRS,src,dst,26);//16޲Ă̏񕄍ݺނ26޲Ă̑M쐬
  printf("M=");
  for(i=(8*26-8);i>=0;i-=8){
    t=bitarray_lsb1st_get(dst,i,8);
    printf("%02X ",t);//M=10 20 0C 56 61 80 EC 11 EC 11 EC 11 EC 11 EC 11 A5 24 D4 C1 ED 36 C7 87 2C 55
  }
  printf("\n");
  //--- M ---
  i=8* 3;bitarray_lsb1st_set(dst,i,8,bitarray_lsb1st_get(dst,i,8)^0x11);//1
  i=8* 8;bitarray_lsb1st_set(dst,i,8,bitarray_lsb1st_get(dst,i,8)^0x22);//2
  i=8*13;bitarray_lsb1st_set(dst,i,8,bitarray_lsb1st_get(dst,i,8)^0x33);//3
  i=8*18;bitarray_lsb1st_set(dst,i,8,bitarray_lsb1st_get(dst,i,8)^0x44);//2
  i=8*23;bitarray_lsb1st_set(dst,i,8,bitarray_lsb1st_get(dst,i,8)^0x55);//3
  printf("M=");
  for(i=(8*26-8);i>=0;i-=8){
    t=bitarray_lsb1st_get(dst,i,8);
    printf("%02X ",t);//M=10 20 59 56 61 80 EC 55 EC 11 EC 11 DF 11 EC 11 A5 06 D4 C1 ED 36 D6 87 2C 55
  }
  printf("\n");
  t=ReedSolomon_DecodeN(pRS,dst,src,26);//26޲Ă̎M޺ނ16޲Ă̏񕄍쐬
  printf("=%d\n",t);//=5
  printf("񕄍=");
  for(i=(8*16-8);i>=0;i-=8){
    t=bitarray_lsb1st_get(src,i,8);
    printf("%02X ",t);//񕄍=10 20 0C 56 61 80 EC 11 EC 11 EC 11 EC 11 EC 11
  }
  printf("\n");
  //--- J ---
  ReedSolomon_Free(pRS);//RSJ
  GaloisField_Free(pGF);//۱̂J
}
#endif
