/*
 *	clipenm.c
 *
 *	񋓒`
 *
 *	CLiP - Common Library for P/ECE
 *	Copyright (C) 2001-2016 Naoyuki Sawa
 *
 *	* Fri Jan 01 21:14:34 JST 2016 Naoyuki Sawa
 *	- 1st [XB
 *	* Sat Jan 02 21:26:28 JST 2016 Naoyuki Sawa
 *	- gpǋL܂B
 *	* Wed May 11 21:35:57 JST 2016 Naoyuki Sawa
 *	- EnmDef_GetVal()ǉ܂B
 *	* Thu May 12 22:56:34 JST 2016 Naoyuki Sawa
 *	- EnmDef_GetNum(),EnmDef_GetMin(),EnmDef_GetMax(),EnmDef_GetNth(),EnmDef_GetIdx()ǉ܂B
 *	* Thu Jul 07 21:12:07 JST 2016 Naoyuki Sawa
 *	- EnmDef_IncVal(),EnmDef_DecVal()ǉ܂B
 *	* Mon Aug 15 21:37:25 JST 2016 Naoyuki Sawa
 *	- 񋓌^̖O̔r֐pāA񋓌^̖O̕񂩂񋓌^̒lt郆[eBeB֐Qǉ܂B
 *	  ڍׂ́AEnmDef_GetVal_UseCompar(),EnmDef_GetCanonicalNameCompar(),EnmDef_IsSuitableNameCompar()̃RgQƂĉB
 *	* Mon Sep 05 21:24:05 JST 2016 Naoyuki Sawa
 *	- (int)l(void*)ɃLXgĐL[ƂĎgpӏŁA64rbgłł̓RpČxoĂ܂B
 *	  ڍׂ́AEnmDef_GetIdx_compar(),EnmDef_GetIdx(),EnmDef_GetVal_UseCompar_compar(),EnmDef_GetVal_UseCompar()̃RgQƂĉB
 */
#include "clip.h"
/****************************************************************************
 *	{IȊ֐
 ****************************************************************************/
//O̕ԂB
const char* EnmDef_GetName(const void* pEnmKey, int iEnmDef, int iVal) {
	const void* pEnmDef;
	const char* pName;
	//񋓌^̒l̃L[擾B
	pEnmDef = REG_open_key_l(pEnmKey, iEnmDef, iVal, -1);
	if(!pEnmDef) { DIE(); }		//񋓌^̒l̃L[΃G[BiEnmDef,,iValԈĂBĂяõoOB
	//O̕擾B
	pName = REG_get_string(pEnmDef, Enm_name);
	if(!pName) { DIE(); }		//O̕񂪖΃G[BdEnmDefC.exe͖O̕Ki[Ă͂Bf[^j,,c[oOB
	//O̕ԂB
	return pName;
}
/*--------------------------------------------------------------------------*/
//̕ԂB̕񂪊i[ĂȂNULLԂB
const char* EnmDef_GetDesc(const void* pEnmKey, int iEnmDef, int iVal) {
	const void* pEnmDef;
	const char* pDesc;
	//񋓌^̒l̃L[擾B
	pEnmDef = REG_open_key_l(pEnmKey, iEnmDef, iVal, -1);
	if(!pEnmDef) { DIE(); }		//񋓌^̒l̃L[΃G[BiEnmDef,,iValԈĂBĂяõoOB
	//̕擾B
	pDesc = REG_get_string(pEnmDef, Enm_desc);
//sv	if(!pDesc) { DIE(); }		//͖̕\LB񋓒`XNvgɂĐw肳ȂꍇdEnmDefC.exe͐̕i[ȂB
	//̕ԂB̕񂪊i[ĂȂNULLԂB
	return pDesc;
}
/*--------------------------------------------------------------------------*/
//̕ԂB̕񂪊i[ĂȂΖO̕ԂB
const char* EnmDef_ToStr(const void* pEnmKey, int iEnmDef, int iVal) {
	const void* pEnmDef;
	const char* pStr;
	//񋓌^̒l̃L[擾B
	pEnmDef = REG_open_key_l(pEnmKey, iEnmDef, iVal, -1);
	if(!pEnmDef) { DIE(); }	//񋓌^̒l̃L[΃G[BiEnmDef,,iValԈĂBĂяõoOB
	//̕擾B
	pStr = REG_get_string(pEnmDef, Enm_desc);
	//̕񂪊i[ĂȂ΁c
	if(!pStr) {			//͖̕\LB񋓒`XNvgɂĐw肳ȂꍇdEnmDefC.exe͐̕i[ȂB
		//O̕擾B
		pStr = REG_get_string(pEnmDef, Enm_name);
		if(!pStr) { DIE(); }	//O̕񂪖΃G[BdEnmDefC.exe͖O̕Ki[Ă͂Bf[^j,,c[oOB
	}
	//̕ԂB̕񂪊i[ĂȂΖO̕ԂB
	return pStr;
}
/****************************************************************************
 *	[eBeB֐
 ****************************************************************************/
//񋓌^ɑl̐ԂB
int EnmDef_GetNum(const void* pEnmKey, int iEnmDef) {
	int n = REG_num_key_l(pEnmKey, iEnmDef, -1);	//REG_num_value_l()ł͂ȂɒӂB񋓌^̃WXg\pEnmKey˗񋓌^̃L[˗񋓌^̒l̃L[˒l̖O[,]Ƃ\łB
	if(!n) { DIE(); }	//񋓌^̒l̃L[΃G[BiEnmDefԈĂBĂяõoOB
	return n;
}
/*--------------------------------------------------------------------------*/
//񋓌^ɑl̂AŏlԂB
int EnmDef_GetMin(const void* pEnmKey, int iEnmDef) {
	return EnmDef_GetNth(pEnmKey, iEnmDef, 0);
}
/*--------------------------------------------------------------------------*/
//񋓌^ɑl̂AőlԂB
int EnmDef_GetMax(const void* pEnmKey, int iEnmDef) {
	return EnmDef_GetNth(pEnmKey, iEnmDef,
	       EnmDef_GetNum(pEnmKey, iEnmDef) - 1);
}
/*--------------------------------------------------------------------------*/
//񋓌^ɑl̂AindexԖڂ̒lԂBindexԖڂ̒l΁AG[~B
int EnmDef_GetNth(const void* pEnmKey, int iEnmDef, int index) {
	int iVal;
	if(!REG_open_nth_key_l(pEnmKey, index, &iVal, iEnmDef, -1)) {	//REG_get_nth_value_l()ł͂ȂɒӂB񋓌^̃WXg\pEnmKey˗񋓌^̃L[˗񋓌^̒l̃L[˒l̖O[,]Ƃ\łB
		DIE();	//񋓌^̒l̃L[΃G[BiEnmDef,,indexԈĂBĂяõoOB
	}
	return iVal;
}
/*--------------------------------------------------------------------------*/
typedef struct _ST_EnmDef_GetIdx_Param {
	const void*	pEnmKey;
	int		iEnmDef;
} ST_EnmDef_GetIdx_Param;
/*- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */
static int EnmDef_GetIdx_compar(const void* key, const void* data, void* arg) {
	ST_EnmDef_GetIdx_Param* param = arg;
//{{2016/09/05ύX:(int)l(void*)ɃLXgĐL[ƂĎgpӏŁA64rbgłł̓RpČxoĂ܂B
//	int iVal1 = (int)key;
//	int index = (int)data - 1/*ItZbg*/;
//2016/09/05ύX:(int)l(void*)ɃLXgĐL[ƂĎgpӏŁA64rbgłł̓RpČxoĂ܂B
#ifndef _WIN64
	int iVal1 = (int)key;				//32rbgł́A܂łƕύXL܂B32rbgł64rbgłƓɂĂ͕ςȂ̂łAȌD悵Ă܂ł̂܂܂Ƃ鎖ɂ܂B
	int index = (int)data - 1/*ItZbg*/;	//
#else //_WIN64
	int iVal1 = (intptr_t)key;			//64rbgł́A(void*)(64rbg)(int)(32rbg)ɃLXg悤Ƃƌxo܂B̒l32rbg̐p[^Ȃ̂(int)ɃLXgĂSł͂̂łAx邽߂(void*)(64rbg)(intptr_t)(64rbg)ˈÖق(int)(32rbg)ւ̃LXgAƂ菇鎖ɂ܂B
	int index = (intptr_t)data - 1/*ItZbg*/;	//
#endif//_WIN64
//}}2016/09/05ύX:(int)l(void*)ɃLXgĐL[ƂĎgpӏŁA64rbgłł̓RpČxoĂ܂B
	int iVal2 = EnmDef_GetNth(param->pEnmKey, param->iEnmDef, index);
	return iVal1 - iVal2;	//񋓌^̒l(=WXgL[̖O)͕16rbgȂ̂ŁAI[o[t[̐Sz͖PȌZʂԂΗǂB
}
/*- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */
//w肳ꂽlA̗񋓌^ɂ鉽Ԗڂ̒lł邩tB̗񋓌^ɑlłȂ΁A(-1)ԂB
// - ̑͗񋓌^łȂAWXgʂɂ(قڂ̂܂܂)Kpo鑀Ȃ̂Aclipreg.cɂ͎A񋓌^L̑Ƃ鎖ɂB
//   ŔAȉ̒ʂłB
//   Eclipreg.cɎƁA֐̑Ώ̐AL[łȂl,,BLOBo悤ɂׂłA֐̐ăR[hTCY傷肪L邩B
//   EԖڂ̒lł邩̂́A񋓌^ȊOł(܂)KvƎv̂ŁAclipreg.c𖳑ʂɕGA񋓌^L̑ɂՂƎvB
int EnmDef_GetIdx(const void* pEnmKey, int iEnmDef, int iVal) {
	ST_EnmDef_GetIdx_Param param = { pEnmKey, iEnmDef };
	//bsearch()ԍɑ΂ĎgpeNjbNłBAhXCfNXƌȂ(index=0`(n-1))ɑ΂Čs܂Bɂ̓CfNX+1ItZbgĈ܂Bڍׂ͉L̃RgQƂĉB
//{{2016/09/05ύX:(int)l(void*)ɃLXgĐL[ƂĎgpӏŁA64rbgłł̓RpČxoĂ܂B
//	return (int)bsearch_r((void*)iVal,
//		(void*)(0/*index*/ + 1/*ItZbg*/),	//0Ԗڂ̒lɈvbsearch_r()̖߂lƁAǂ̒lɂvȂbsearch_r()̖߂lNULL(0)ʂ邽߂ɁACfNX+1ItZbgĈɂB
//		EnmDef_GetNum(pEnmKey, iEnmDef),
//		1,
//		EnmDef_GetIdx_compar,
//		&param) - 1/*ItZbg*/;		//CfNX+1ItZbg𑊎EBǂ̒lɂvȂꍇ́Absearch_r()̖߂lNULL(0)ƂȂA-1鎖œ֐̖߂l(-1)ƂȂB
//2016/09/05ύX:(int)l(void*)ɃLXgĐL[ƂĎgpӏŁA64rbgłł̓RpČxoĂ܂B
#ifndef _WIN64
	return (int)bsearch_r(				//32rbgł́A܂łƕύXL܂B32rbgł64rbgłƓɂĂ͕ςȂ̂łAȌD悵Ă܂ł̂܂܂Ƃ鎖ɂ܂B
		(void*)iVal,				//32rbgł́A܂łƕύXL܂B32rbgł64rbgłƓɂĂ͕ςȂ̂łAȌD悵Ă܂ł̂܂܂Ƃ鎖ɂ܂B
		(void*)(0/*index*/ + 1/*ItZbg*/),	//0Ԗڂ̒lɈvbsearch_r()̖߂lƁAǂ̒lɂvȂbsearch_r()̖߂lNULL(0)ʂ邽߂ɁACfNX+1ItZbgĈɂB
		EnmDef_GetNum(pEnmKey, iEnmDef),
		1,
		EnmDef_GetIdx_compar,
		&param) - 1/*ItZbg*/;		//CfNX+1ItZbg𑊎EBǂ̒lɂvȂꍇ́Absearch_r()̖߂lNULL(0)ƂȂA-1鎖œ֐̖߂l(-1)ƂȂB
#else //_WIN64
	return (intptr_t)bsearch_r(			//64rbgł́A(void*)(64rbg)(int)(32rbg)ɃLXg悤Ƃƌxo܂B̒l32rbg̐p[^Ȃ̂(int)ɃLXgĂSł͂̂łAx邽߂(void*)(64rbg)(intptr_t)(64rbg)ˈÖق(int)(32rbg)ւ̃LXgAƂ菇鎖ɂ܂B
		(void*)(intptr_t)iVal,			//64rbgł́A(int)(32rbg)(void*)(64rbg)ɒڃLXg悤Ƃƌxo܂B(int)(32rbg)(intptr_t)(64rbg)(void*)(64rbg)̏ŃLXgΌx͏o܂B
		(void*)(0/*index*/ + 1/*ItZbg*/),	//0Ԗڂ̒lɈvbsearch_r()̖߂lƁAǂ̒lɂvȂbsearch_r()̖߂lNULL(0)ʂ邽߂ɁACfNX+1ItZbgĈɂB
		EnmDef_GetNum(pEnmKey, iEnmDef),
		1,
		EnmDef_GetIdx_compar,
		&param) - 1/*ItZbg*/;		//CfNX+1ItZbg𑊎EBǂ̒lɂvȂꍇ́Absearch_r()̖߂lNULL(0)ƂȂA-1鎖œ֐̖߂l(-1)ƂȂB
#endif//_WIN64
//}}2016/09/05ύX:(int)l(void*)ɃLXgĐL[ƂĎgpӏŁA64rbgłł̓RpČxoĂ܂B
}
/*--------------------------------------------------------------------------*/
//񋓌^̖O̕񂩂A񋓌^̒ltBw肳ꂽO̕ɈvlA(-1)ԂB
// - ̊֐͒PȃjAT[`ŝŒᑬłB
//   l̐񋓌^ɑ΂ē֐gpƁAɒ[ɒԂ鋰ꂪL̂ŒӂĉB
// - ̊֐jAT[`sĂ闝ŔA񋓌^̒l̏ƖO̕яɊւ錈܂͖łB
//   Ⴆ΁A1:AAA,2:CCC,3:BBB,...̂悤ȕтł\̂ŁAPɃjAT[`邵L܂B
// - A̗񋓌^̖O̕яzoꍇ́A֐g킸ɁAʂɏo܂B
//   Ⴆ΁AXvCg̗񋓌^ɑ΂閼O˒l̋t́AXvCgŗL鎖𗘗pčo܂B
//   ̎́Aclipafxb.cAfxBin_Draw_GetFootage()QƂĉB
// - _ƂẮA֐́AxdvłȂP[Xɑ΂Ă̂݁A[eBeB[֐ƂėpĉB
//   <gp>
//   int iVal = EnmDef_GetVal(pEnmKey, RegKey_Color, "Black");
//   if(iVal != -1) { printf("'Black'̒l%dłB", iVal); }
int EnmDef_GetVal(const void* pEnmKey, int iEnmDef, const char* pName) {
	int index, n = EnmDef_GetNum(pEnmKey, iEnmDef);
	for(index = 0; index < n; index++) {
		int iVal = EnmDef_GetNth(pEnmKey, iEnmDef, index);
		if(!strcmp(EnmDef_GetName(pEnmKey, iEnmDef, iVal), pName)) { return iVal; }
	}
	return -1;
}
/*--------------------------------------------------------------------------*/
//̗񋓌^ɂAw肳ꂽl̎̒l擾B
//w肳ꂽlőlȂ΁Aw肳ꂽl̂܂ܕԂB
int EnmDef_IncVal(const void* pEnmKey, int iEnmDef, int iVal) {
	int index = EnmDef_GetIdx(pEnmKey, iEnmDef, iVal);
	if(index == -1) { DIE(); }	//w肳ꂽlA̗񋓌^ɑlłȂ΁AG[~B
	if(index < EnmDef_GetNum(pEnmKey, iEnmDef) - 1) {
		iVal = EnmDef_GetNth(pEnmKey, iEnmDef, index + 1);
	}
	return iVal;
}
/*--------------------------------------------------------------------------*/
//̗񋓌^ɂAw肳ꂽl̑O̒l擾B
//w肳ꂽlŏlȂ΁Aw肳ꂽl̂܂ܕԂB
int EnmDef_DecVal(const void* pEnmKey, int iEnmDef, int iVal) {
	int index = EnmDef_GetIdx(pEnmKey, iEnmDef, iVal);
	if(index == -1) { DIE(); }	//w肳ꂽlA̗񋓌^ɑlłȂ΁AG[~B
	if(index > 0) {
		iVal = EnmDef_GetNth(pEnmKey, iEnmDef, index - 1);
	}
	return iVal;
}
/*--------------------------------------------------------------------------*/
//{{2016/08/15ǉ:񋓌^̖O̔r֐pāA񋓌^̖O̕񂩂񋓌^̒lt郆[eBeB֐Qǉ܂B
typedef struct _ST_EnmDef_GetVal_UseCompar_Param {
	const void*	pEnmKey;
	int		iEnmDef;
	int		(*compar)(const char*, const char*);
} ST_EnmDef_GetVal_UseCompar_Param;
/*- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */
static int EnmDef_GetVal_UseCompar_compar(const void* key, const void* data, void* arg) {
	ST_EnmDef_GetVal_UseCompar_Param* param = arg;
	const char* pName1 = key;
//{{2016/09/05ύX:(int)l(void*)ɃLXgĐL[ƂĎgpӏŁA64rbgłł̓RpČxoĂ܂B
//	int index          = (int)data - 1/*ItZbg*/;
//2016/09/05ύX:(int)l(void*)ɃLXgĐL[ƂĎgpӏŁA64rbgłł̓RpČxoĂ܂B
#ifndef _WIN64
	int index          = (int)data - 1/*ItZbg*/;	//32rbgł́A܂łƕύXL܂B32rbgł64rbgłƓɂĂ͕ςȂ̂łAȌD悵Ă܂ł̂܂܂Ƃ鎖ɂ܂B
#else //_WIN64
	int index          = (intptr_t)data - 1/*ItZbg*/;	//64rbgł́A(void*)(64rbg)(int)(32rbg)ɃLXg悤Ƃƌxo܂B̒l32rbg̐p[^Ȃ̂(int)ɃLXgĂSł͂̂łAx邽߂(void*)(64rbg)(intptr_t)(64rbg)ˈÖق(int)(32rbg)ւ̃LXgAƂ菇鎖ɂ܂B
#endif//_WIN64
//}}2016/09/05ύX:(int)l(void*)ɃLXgĐL[ƂĎgpӏŁA64rbgłł̓RpČxoĂ܂B
	int iVal           = EnmDef_GetNth(param->pEnmKey, param->iEnmDef, index);
	const char* pName2 = EnmDef_GetName(param->pEnmKey, param->iEnmDef, iVal);
	return (*param->compar)(pName1, pName2);
}
/*- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */
//̗񋓌^̖O̔r֐ƂēK؂Ȕr֐pāA񋓌^̖O̕񂩂A񋓌^̒ltB(EnmDef_GetVal()łB)
//w肳ꂽO̕ɈvlA(-1)ԂB
//compaŕA\EnmDef_IsSuitableNameCompar(),,EnmDef_GetCanonicalNameCompar()ŁA擾ĂĉB
//́A̗񋓌^̖O̕я̃[AAvP[VɂĊmȂ΁A̔r֐ߑłŎw肵Ă\܂B
//gp
//int (*compar)(const char*, const char*) = EnmDef_GetCanonicalNameCompar(pEnmKey, RegKey_SprNo); //ۂɂ͏Ɉx߂ĂB
//int iSprNo_Player = EnmDef_GetVal_UseCompar(pEnmKey, RegKey_SprNo, "PLAYER", compar, NULL);
//int iSprNo_Enemy  = EnmDef_GetVal_UseCompar(pEnmKey, RegKey_SprNo, "ENEMY",  compar, NULL);
//int iSprNo_Num1   = EnmDef_GetVal_UseCompar(pEnmKey, RegKey_SprNo, "NUM1",   compar, NULL);
//int iSprNo_Num2   = EnmDef_GetVal_UseCompar(pEnmKey, RegKey_SprNo, "NUM2",   compar, NULL);
//int iSprNo_Num3   = EnmDef_GetVal_UseCompar(pEnmKey, RegKey_SprNo, "NUM3",   compar, NULL);
int EnmDef_GetVal_UseCompar(const void* pEnmKey, int iEnmDef, const char* pName, int (*compar)(const char*, const char*)) {
	ST_EnmDef_GetVal_UseCompar_Param param = { pEnmKey, iEnmDef, compar };
	//ASÝAEnmDef_GetIdx()ƂقړłB
	//AEnmDef_GetIdx()̓CfNXԂA֐͗񋓒lԂƂ_قȂ܂B
//{{2016/09/05ύX:(int)l(void*)ɃLXgĐL[ƂĎgpӏŁA64rbgłł̓RpČxoĂ܂B
//	int index = (int)bsearch_r(pName,
//		(void*)(0/*index*/ + 1/*ItZbg*/),	//0Ԗڂ̒lɈvbsearch_r()̖߂lƁAǂ̒lɂvȂbsearch_r()̖߂lNULL(0)ʂ邽߂ɁACfNX+1ItZbgĈɂB
//		EnmDef_GetNum(pEnmKey, iEnmDef),
//		1,
//		EnmDef_GetVal_UseCompar_compar,
//		&param) - 1/*ItZbg*/;		//CfNX+1ItZbg𑊎EBǂ̒lɂvȂꍇ́Absearch_r()̖߂lNULL(0)ƂȂA-1鎖œ֐̖߂l(-1)ƂȂB
//2016/09/05ύX:(int)l(void*)ɃLXgĐL[ƂĎgpӏŁA64rbgłł̓RpČxoĂ܂B
#ifndef _WIN64
	int index = (int)bsearch_r(pName,		//32rbgł́A܂łƕύXL܂B32rbgł64rbgłƓɂĂ͕ςȂ̂łAȌD悵Ă܂ł̂܂܂Ƃ鎖ɂ܂B
		(void*)(0/*index*/ + 1/*ItZbg*/),	//0Ԗڂ̒lɈvbsearch_r()̖߂lƁAǂ̒lɂvȂbsearch_r()̖߂lNULL(0)ʂ邽߂ɁACfNX+1ItZbgĈɂB
		EnmDef_GetNum(pEnmKey, iEnmDef),
		1,
		EnmDef_GetVal_UseCompar_compar,
		&param) - 1/*ItZbg*/;		//CfNX+1ItZbg𑊎EBǂ̒lɂvȂꍇ́Absearch_r()̖߂lNULL(0)ƂȂA-1鎖œ֐̖߂l(-1)ƂȂB
#else //_WIN64
	int index = (intptr_t)bsearch_r(pName,		//64rbgł́A(void*)(64rbg)(int)(32rbg)ɃLXg悤Ƃƌxo܂B̒l32rbg̐p[^Ȃ̂(int)ɃLXgĂSł͂̂łAx邽߂(void*)(64rbg)(intptr_t)(64rbg)ˈÖق(int)(32rbg)ւ̃LXgAƂ菇鎖ɂ܂B
		(void*)(0/*index*/ + 1/*ItZbg*/),	//0Ԗڂ̒lɈvbsearch_r()̖߂lƁAǂ̒lɂvȂbsearch_r()̖߂lNULL(0)ʂ邽߂ɁACfNX+1ItZbgĈɂB
		EnmDef_GetNum(pEnmKey, iEnmDef),
		1,
		EnmDef_GetVal_UseCompar_compar,
		&param) - 1/*ItZbg*/;		//CfNX+1ItZbg𑊎EBǂ̒lɂvȂꍇ́Absearch_r()̖߂lNULL(0)ƂȂA-1鎖œ֐̖߂l(-1)ƂȂB
#endif//_WIN64
//}}2016/09/05ύX:(int)l(void*)ɃLXgĐL[ƂĎgpӏŁA64rbgłł̓RpČxoĂ܂B
	return (index < 0) ? index/*=-1*/ : EnmDef_GetNth(pEnmKey, iEnmDef, index)/*0*/;
}
/*--------------------------------------------------------------------------*/
//̗񋓌^̖O̔r֐ƂēK؂ȁAWIȔr֐擾B
//WIȔr֐̂K؂łȂꍇ́ANULLԂB
//֐NULLԂꍇAĕWIȔr֐ȊOr֐̌ƂĒꍇ́AAvP[VIEnmDef_IsSuitableNameCompar()ĂяoĔr֐肵ĉB
int (*EnmDef_GetCanonicalNameCompar(const void* pEnmKey, int iEnmDef))(const char*, const char*) {
	//WIȔr֐̌Bǉ\łB
	static int (* const TBL_Compar[])(const char*, const char*) = {
		strcmp,		//啶ʂB
		strcasecmp,	//啶ʂȂB
		strnatcmp,	//啶ʂARrB
		strnatcasecmp,	//啶ʂȂARrB
		//TODO:ǉ\łB
	};
	int i;
	for(i = 0; i < ARRAY_SIZE(TBL_Compar); i++) {
		int (*compar)(const char*, const char*) = TBL_Compar[i];
		if(EnmDef_IsSuitableNameCompar(pEnmKey, iEnmDef, compar)) { return compar; }	//̔r֐K؂Ȃ΁A̔r֐ԂB
	}
	return NULL;	//WIȔr֐̂K؂łȂꍇ́ANULLԂB
}
/*--------------------------------------------------------------------------*/
//w肳ꂽr֐comparA̗񋓌^̖O̔r֐ƂāAK؂ł邩ǂ𒲂ׂB
//̓Iɂ́A̗񋓌^̑SẮANԖڂ̒l̖OpName1ƁA(N+1)Ԗڂ̒l̖OpName2ɑ΂āA((*compar)(pName1,pName2)<0)Ȃ΁Ar֐comparA̗񋓌^̖O̔r֐ƂāAK؂łƌȂB
//yӁz
//dEnmDefC.exe񋓌^̖O̕я́A񋓒l̏łAKO̕яɃ[݂ł͂ȂB
//]āA̗񋓌^̖O̔r֐ƂēK؂Ȕr֐A݂Ƃ͌ȂɒӂB
//񋓌^̖O̕яɃ[݂̂́AdTexDefC.exedPhrDefC.exẽc[Ő񋓒`XNvgAAvP[VӐ}IɖȌɒ`񋓒`XNvg̏ꍇłB
int EnmDef_IsSuitableNameCompar(const void* pEnmKey, int iEnmDef, int (*compar)(const char*, const char*)) {
	int index, n = EnmDef_GetNum(pEnmKey, iEnmDef);
	for(index = 0; index < n; index++) {
		const char* pName1 = NULL;
		for(index = 0; index < n; index++) {
			int iVal           = EnmDef_GetNth(pEnmKey, iEnmDef, index);
			const char* pName2 = EnmDef_GetName(pEnmKey, iEnmDef, iVal);
			if(pName1) {
				if(((*compar)(pName1, pName2) >= 0) ||			//ꂩł((*compar)(pName1,pName2)<0)Ȃ΁AK؂łȂƌȂ0ԂB
				   ((*compar)(pName2, pName1) <= 0)) { return 0; }	//{͏̌ŏ\Ȃ̂łAÔ߂ɔrtɂĂ̌sɂ܂BAcompar-1Ԃ悤Ȋ֐ꍇɁAēK؂łƔfĂ܂邽߂łB
			}
			pName1 = pName2;
		}
	}
	return 1;	//SẲӏ((*compar)(pName1,pName2)<0)Ȃ΁AK؂łƌȂ0ȊO̒lԂB
}
//}}2016/08/15ǉ:񋓌^̖O̔r֐pāA񋓌^̖O̕񂩂񋓌^̒lt郆[eBeB֐Qǉ܂B
/****************************************************************************
 *	gp
 ****************************************************************************/
#if 0
EnmDef.txt
Color
  White  ""
  GlayW  "D(W)"
  GlayB  "D(Z)"
  Black  ""
  Mask   "}XN"
end
dEnmDefC.exe -rRegEnmDef.txt EnmDef.txt > EnmDef.h
#define Color_White  0  //
#define Color_GlayW  1  //D(W)
#define Color_GlayB  2  //D(Z)
#define Color_Black  3  //
#define Color_Mask   4  //}XN
#define Color_Max    4
dRegTblC.exe -pRegKey_ -oRegTbl.bin RegEnmDef.txt > RegTbl.h
#define RegKey_Color   5
#define RegKey_EnmDef  6
gp
#include "RegTbl.h"
#include "EnmDef.h"
void sample() {
  const void* pEnmKey=REG_open_key(TBL_RegTbl,RegKey_EnmDef);
  int iVal;
  for(iVal=0;iVal<=Color_Max;iVal++) {
    puts(EnmDef_ToStr(pEnmKey,RegKey_Color,iVal);
  } //                        ~~~~~~~~~~~~ ~~~~
}   //iEnmDefRegTbl.hɂĒ`܂ iValEnmDef.hɂĒ`܂
#endif
