/*	
 *	clipdes.h
 *
 *	DESÍA
 *
 *	CLiP - Common Library for P/ECE
 *	Copyright (C) 2001-2007 Naoyuki Sawa
 *
 *	* Sat Feb 17 01:51:50 JST 2007 Naoyuki Sawa
 *	- 1st [XB
 *	* Sat Feb 17 22:50:41 JST 2007 Naoyuki Sawa
 *	- pfBO@ANUL paddingPKCS#5 paddingɕύX܂B
 *	  ̕ύXɂA̕ɗ]vNULpfBOtA
 *	  ̃TCYɕ悤ɂȂ܂B
 *	* Sun Feb 18 12:16:59 JST 2007 Naoyuki Sawa
 *	- ܂łDES(ECB)ɉāADES(CBC)ɂΉ܂B
 *	* Wed Nov 18 21:37:53 JST 2015 Naoyuki Sawa
 *	- 'extern "C" {'`'}'ň݂͂܂B.cpp܂Win32vWFNgCN[ho悤ɂ邽߂łB
 */
#ifndef __CLIP_DES_H__
#define __CLIP_DES_H__

#ifdef  __cplusplus
extern "C" {
#endif//__cplusplus

/****************************************************************************
 *	
 ****************************************************************************/

/* DES(ECB)Ís܂B
 * [in]
 *	dst		ÍB(o)
 *	dst_cap		dst[]̋eʁB
 *	src		B()
 *	src_len		src[]̃oCgB
 *	key		64rbgB
 * [out]
 *	߂l		Í̕B
 *			8oCg̔{łȂꍇ́A8oCg̔{ɐ؂グTCYɂȂ܂B
 *			8oCg̔{̏ꍇ́A8oCgǉTCYɂȂ܂B
 *			0oCg̏ꍇlɁA8oCgǉTCYɂȂ܂B
 *			dst[]̋eʂ[łȂꍇ́AAT[g܂B
 * [note]
 *	* dst[]src[]ɁAobt@w肷邱Ƃł܂B(GAXZ[t)
 *	  ÍāAobt@ɁAÍŏ㏑邱Ƃł܂B
 *	* 64rbg̊eoCg̍ŉʃrbg͎gꂸAA56rbgłB
 *	  ASCIIȂǂƂƁAŉʃrbggꂸAアɂȂ܂B
 *	  Kvɉdes_64bit_key()gAK؂64rbg𐶐ĂB
 *	  ڂ́Ades_64bit_key(),des_set_key()̃RgQƂĂB
 */
int des_ecb_encrypt(
	      void* dst/*[dst_cap]*/, int dst_cap,
	const void* src/*[src_len]*/, int src_len,
	const unsigned char key[/*8*/]);

/* DES(ECB)s܂B
 * [in]
 *	dst		B(o)
 *	dst_cap		dst[]̋eʁB
 *	src		ÍB()
 *	src_len		src[]̃oCgB
 *	key		64rbgB
 * [out]
 *	߂l		̕B
 *			(Í̕-8)`(Í̕-1)oCg̃TCYɂȂ܂B
 *			dst[]̋eʂ[łȂꍇ́AAT[g܂B
 * [note]
 *	* dst[]src[]ɁAobt@w肷邱Ƃł܂B(GAXZ[t)
 *	  Í𕜍āAobt@ɁAŏ㏑邱Ƃł܂B
 *	* 64rbg̊eoCg̍ŉʃrbg͎gꂸAA56rbgłB
 *	  ASCIIȂǂƂƁAŉʃrbggꂸAアɂȂ܂B
 *	  Kvɉdes_64bit_key()gAK؂64rbg𐶐ĂB
 *	  ڂ́Ades_64bit_key(),des_set_key()̃RgQƂĂB
 */
int des_ecb_decrypt(
	      void* dst/*[dst_cap]*/, int dst_cap,
	const void* src/*[src_len]*/, int src_len,
	const unsigned char key[/*8*/]);

/* DES(CBC)Ís܂B
 * [note]
 *	* ֐dldes_ecb_encrypt()ƓłB
 *	  des_ecb_encrypt()̃RgQƂĂB
 */
int des_cbc_encrypt(
	      void* dst/*[dst_cap]*/, int dst_cap,
	const void* src/*[src_len]*/, int src_len,
	const unsigned char key[/*8*/]);

/* DES(CBC)s܂B
 * [note]
 *	* ֐dldes_ecb_decrypt()ƓłB
 *	  des_ecb_decrypt()̃RgQƂĂB
 */
int des_cbc_decrypt(
	      void* dst/*[dst_cap]*/, int dst_cap,
	const void* src/*[src_len]*/, int src_len,
	const unsigned char key[/*8*/]);

/* 56rbgȉ̌ɊpeBrbgtADES 64rbg쐬܂B
 * [in]
 *	key		7oCg(56rbg)ȉ̌B
 *			7oCg̏ꍇA7oCg܂nul̂ƌȂ܂B
 *			7oCg߂̏ꍇA7oCgߕ͎g܂B
 *	len		keỹoCgB
 * [out]
 *	߂l		DES 64rbgB
 *			߂ĺA{֐̓obt@wĂ܂B
 *			ēxA{֐ĂяoƁAe͕ύX܂B
 * [note]
 *	* {W[̊֐́ADES 64rbg̃peBrbgPɖ܂B
 *	  ]āAmȊpeBłȂsl̃_~[rbg̕tł[Ȃ̂łA
 *	  ꉞADES 64rbgdlɂāApeBt邱Ƃɂ܂B
 */
const unsigned char* des_64bit_key(const void* key, int len);

#ifdef  __cplusplus
}//extern "C"
#endif//__cplusplus

#endif /*__CLIP_DES_H__*/
