/*	
 *	clipdes.c
 *
 *	DESÍA
 *
 *	CLiP - Common Library for P/ECE
 *	Copyright (C) 2001-2007 Naoyuki Sawa
 *
 *	* Sat Feb 17 01:51:50 JST 2007 Naoyuki Sawa
 *	- 1st [XB
 *	* Sat Feb 17 22:50:41 JST 2007 Naoyuki Sawa
 *	- pfBO@ANUL paddingPKCS#5 paddingɕύX܂B
 *	  ̕ύXɂA̕ɗ]vNULpfBOtA
 *	  ̃TCYɕ悤ɂȂ܂B
 *	* Sun Feb 18 12:16:59 JST 2007 Naoyuki Sawa
 *	- ܂łDES(ECB)ɉāADES(CBC)ɂΉ܂B
 */
#include "clip.h"

/****************************************************************************
 *	[J萔
 ****************************************************************************/

/* IP: initial permutation (]u) */
static const unsigned char IP[64] = {
	(58-1),(50-1),(42-1),(34-1),(26-1),(18-1),(10-1),(2-1),
	(60-1),(52-1),(44-1),(36-1),(28-1),(20-1),(12-1),(4-1),
	(62-1),(54-1),(46-1),(38-1),(30-1),(22-1),(14-1),(6-1),
	(64-1),(56-1),(48-1),(40-1),(32-1),(24-1),(16-1),(8-1),
	(57-1),(49-1),(41-1),(33-1),(25-1),(17-1),( 9-1),(1-1),
	(59-1),(51-1),(43-1),(35-1),(27-1),(19-1),(11-1),(3-1),
	(61-1),(53-1),(45-1),(37-1),(29-1),(21-1),(13-1),(5-1),
	(63-1),(55-1),(47-1),(39-1),(31-1),(23-1),(15-1),(7-1),
};

/* E BIT-SELECTION TABLE (g^]u) */
static const unsigned char E[64] = {
	(32-1),( 1-1),( 2-1),( 3-1),( 4-1),( 5-1),
	( 4-1),( 5-1),( 6-1),( 7-1),( 8-1),( 9-1),
	( 8-1),( 9-1),(10-1),(11-1),(12-1),(13-1),
	(12-1),(13-1),(14-1),(15-1),(16-1),(17-1),
	(16-1),(17-1),(18-1),(19-1),(20-1),(21-1),
	(20-1),(21-1),(22-1),(23-1),(24-1),(25-1),
	(24-1),(25-1),(26-1),(27-1),(28-1),(29-1),
	(28-1),(29-1),(30-1),(31-1),(32-1),( 1-1),
};

/* S BOX */
static const unsigned char S[8][64] = {
/*S1*/	{ 14, 4,13, 1, 2,15,11, 8, 3,10, 6,12, 5, 9, 0, 7,
	   0,15, 7, 4,14, 2,13, 1,10, 6,12,11, 9, 5, 3, 8,
	   4, 1,14, 8,13, 6, 2,11,15,12, 9, 7, 3,10, 5, 0,
	  15,12, 8, 2, 4, 9, 1, 7, 5,11, 3,14,10, 0, 6,13, },
/*S2*/	{ 15, 1, 8,14, 6,11, 3, 4, 9, 7, 2,13,12, 0, 5,10,
	   3,13, 4, 7,15, 2, 8,14,12, 0, 1,10, 6, 9,11, 5,
	   0,14, 7,11,10, 4,13, 1, 5, 8,12, 6, 9, 3, 2,15,
	  13, 8,10, 1, 3,15, 4, 2,11, 6, 7,12, 0, 5,14, 9, },
/*S3*/	{ 10, 0, 9,14, 6, 3,15, 5, 1,13,12, 7,11, 4, 2, 8,
	  13, 7, 0, 9, 3, 4, 6,10, 2, 8, 5,14,12,11,15, 1,
	  13, 6, 4, 9, 8,15, 3, 0,11, 1, 2,12, 5,10,14, 7,
	   1,10,13, 0, 6, 9, 8, 7, 4,15,14, 3,11, 5, 2,12, },
/*S4*/	{  7,13,14, 3, 0, 6, 9,10, 1, 2, 8, 5,11,12, 4,15,
	  13, 8,11, 5, 6,15, 0, 3, 4, 7, 2,12, 1,10,14, 9,
	  10, 6, 9, 0,12,11, 7,13,15, 1, 3,14, 5, 2, 8, 4,
	   3,15, 0, 6,10, 1,13, 8, 9, 4, 5,11,12, 7, 2,14, },
/*S5*/	{  2,12, 4, 1, 7,10,11, 6, 8, 5, 3,15,13, 0,14, 9,
	  14,11, 2,12, 4, 7,13, 1, 5, 0,15,10, 3, 9, 8, 6,
	   4, 2, 1,11,10,13, 7, 8,15, 9,12, 5, 6, 3, 0,14,
	  11, 8,12, 7, 1,14, 2,13, 6,15, 0, 9,10, 4, 5, 3, },
/*S6*/	{ 12, 1,10,15, 9, 2, 6, 8, 0,13, 3, 4,14, 7, 5,11,
	  10,15, 4, 2, 7,12, 9, 5, 6, 1,13,14, 0,11, 3, 8,
	   9,14,15, 5, 2, 8,12, 3, 7, 0, 4,10, 1,13,11, 6,
	   4, 3, 2,12, 9, 5,15,10,11,14, 1, 7, 6, 0, 8,13, },
/*S7*/	{  4,11, 2,14,15, 0, 8,13, 3,12, 9, 7, 5,10, 6, 1,
	  13, 0,11, 7, 4, 9, 1,10,14, 3, 5,12, 2,15, 8, 6,
	   1, 4,11,13,12, 3, 7,14,10,15, 6, 8, 0, 5, 9, 2,
	   6,11,13, 8, 1, 4,10, 7, 9, 5, 0,15,14, 2, 3,12, },
/*S8*/	{ 13, 2, 8, 4, 6,15,11, 1,10, 9, 3,14, 5, 0,12, 7,
	   1,15,13, 8,10, 3, 7, 4,12, 5, 6,11, 0,14, 9, 2,
	   7,11, 4, 1, 9,12,14, 2, 0, 6,10,13,15, 3, 5, 8,
	   2, 1,14, 7, 4,10, 8,13,15,12, 9, 0, 3, 5, 6,11, },
};

/* P]u */
static const unsigned char P[32] = {
	(16-1),( 7-1),(20-1),(21-1),
	(29-1),(12-1),(28-1),(17-1),
	( 1-1),(15-1),(23-1),(26-1),
	( 5-1),(18-1),(31-1),(10-1),
	( 2-1),( 8-1),(24-1),(14-1),
	(32-1),(27-1),( 3-1),( 9-1),
	(19-1),(13-1),(30-1),( 6-1),
	(22-1),(11-1),( 4-1),(25-1),
};

/* PC-1: Permuted choice 1 (k^]u 1) */
static const unsigned char PC1[56] = {
	(57-1),(49-1),(41-1),(33-1),(25-1),(17-1),( 9-1),
	( 1-1),(58-1),(50-1),(42-1),(34-1),(26-1),(18-1),
	(10-1),( 2-1),(59-1),(51-1),(43-1),(35-1),(27-1),
	(19-1),(11-1),( 3-1),(60-1),(52-1),(44-1),(36-1),
	(63-1),(55-1),(47-1),(39-1),(31-1),(23-1),(15-1),
	( 7-1),(62-1),(54-1),(46-1),(38-1),(30-1),(22-1),
	(14-1),( 6-1),(61-1),(53-1),(45-1),(37-1),(29-1),
	(21-1),(13-1),( 5-1),(28-1),(20-1),(12-1),( 4-1),
};

/* schedule of left shifts of the individual blocks (zVtg) */
static const unsigned char shifts[16] = { 1,1,2,2,2,2,2,2,1,2,2,2,2,2,2,1 };

/* PC-2: Permuted choice 2 (k^]u 2) */
static const unsigned char PC2[48] = {
	(14-1),(17-1),(11-1),(24-1),( 1-1),( 5-1),
	( 3-1),(28-1),(15-1),( 6-1),(21-1),(10-1),
	(23-1),(19-1),(12-1),( 4-1),(26-1),( 8-1),
	(16-1),( 7-1),(27-1),(20-1),(13-1),( 2-1),
	(41-1),(52-1),(31-1),(37-1),(47-1),(55-1),
	(30-1),(40-1),(51-1),(45-1),(33-1),(48-1),
	(44-1),(49-1),(39-1),(56-1),(34-1),(53-1),
	(46-1),(42-1),(50-1),(36-1),(29-1),(32-1),
};

/****************************************************************************
 *	[J֐
 ****************************************************************************/

/* oCgzArbgzɓWJ܂B
 * [in]
 *	bit_array	o̓rbgzB
 *			ȂƂA(byte_len*8)ȏ̋eʂKvłB
 *	byte_array	̓oCgzB
 *			҂A(byte_len)̗vfłȂ΂܂B
 *	byte_len	oCgB
 * [note]
 *	* DES̎dlɏ]Arbgя͏ʃrbgsƂȂ܂B
 */
static void
des_byte_array_to_bit_array(
	      unsigned char  bit_array[/*byte_len*8*/],
	const unsigned char byte_array[/*byte_len  */],
	int byte_len)
{
	do {
		int byte = *byte_array++;
		int i_bit = 8;
		do {
			*bit_array++ = (byte >> 7) & 1;
			byte <<= 1;
		} while(--i_bit);
	} while(--byte_len);
}

/* rbgzAoCgzɂ܂Ƃ߂܂B
 * [in]
 *	byte_array	o̓oCgzB
 *			ȂƂA(byte_len)ȏ̋eʂKvłB
 *	bit_array	̓rbgzB
 *			҂A(byte_len*8)̗vfłȂ΂܂B
 *	byte_len	oCgB
 * [note]
 *	* DES̎dlɏ]Arbgя͏ʃrbgsƂȂ܂B
 */
static void
des_bit_array_to_byte_array(
	      unsigned char byte_array[/*byte_len  */],
	const unsigned char  bit_array[/*byte_len*8*/],
	int byte_len)
{
	do {
		int byte = 0;
		int i_bit = 8;
		do {
			byte <<= 1;
			byte |= *bit_array++;
		} while(--i_bit);
		*byte_array++ = byte;
	} while(--byte_len);
}

/* 64rbgA48rbg~16̓𐶐܂B
 * [in]
 *	K		48rbg~16̓B(o)
 *	key		64rbgB()
 *	encrypt_decrypt	0 = Íp̌𐶐, 1 = p̌𐶐
 * [note]
 *	* 64rbg̊eoCg̖̃rbǵAɎgp܂B
 *	  ̓Iɂ́Auk^]u 1v̏ɂāAȉ̃rbĝĂ܂B
 *		(key[0]&0x01),(key[1]&0x01),(key[2]&0x01),(key[3]&0x01)
 *		(key[4]&0x01),(key[5]&0x01),(key[6]&0x01),(key[7]&0x01)
 *	  DESdlł́Ãrbg͊peBƒ߂Ă܂A{֐ł͒Pɖ܂B
 *	* AASCIÎ܂64rbgɎgƁAe̍ŉʃrbĝĂĂ܂܂B
 *	  ͂܂Ȃgݍ킹AアƂȂĂ܂܂B
 *	  ASCII64rbgƂꍇ́A7ȉ̕Ades_64bit_key()ŐLĂB
 *		<>	const char* const str_key = "a#b$c%d";
 *			des_ecb_encrypt(dst, dst_cap, src, src_len, des_64bit_key(str_key, strlen(str_key));
 *	* ASCIIłȂAڃoCil64rbgƂꍇAq̃rbĝĂ邱ƂlāA
 *	  アƂȂȂ悤AӂĂB
 *	  邢́AASCIIƓlɁA7oCgȉ̃oCilAdes_64bit_key()ŐLĂB
 *		<>	const unsigned char bin_key[] = { 0x01,0x23,0x45,0x67,0x89,0xab,0xcd };
 *			des_ecb_encrypt(dst, dst_cap, src, src_len, des_64bit_key(str_key, sizeof bin_key);
 *	* ڂ́Ades_64bit_key()̃RgQƂĂB
 */
static void
des_set_key(
	unsigned char K[/*16*/][48],
	const unsigned char key[/*8*/],
	int encrypt_decrypt) /* 0 = encrypt, 1 = decrypt */
{
	int i;
	int j;
	int t;
	unsigned char KEY[64];
	unsigned char C_D[56]; /* [0:27] = C, [28:55] = D */

	des_byte_array_to_bit_array(KEY, key, 8);

	/* k^]u 1 */
	for(i = 0; i < 56; i++) {
		C_D[i] = KEY[PC1[i]];
	}

	for(i = 0; i < 16; i++) {
		/* zVtg */
		for(j = 0; j < shifts[i]; j++) {
			t = C_D[ 0]; memmove(&C_D[ 0], &C_D[ 1], 27); C_D[27] = t;
			t = C_D[28]; memmove(&C_D[28], &C_D[29], 27); C_D[55] = t;
		}

		/* k^]u 2 */
		for(j = 0; j < 48; j++) {
			if(!encrypt_decrypt) {
				K[     i][j] = C_D[PC2[j]]; /* Í */
			} else {
				K[15 - i][j] = C_D[PC2[j]]; /*  */
			}
		}
	}
}

/* DESÍA܂́ÁA1ubN̏s܂B(ʏł)
 * [in]
 *	dst		ÍA܂́AB(o)
 *	src		A܂́AÍB()
 *	K		ÍpA܂́Ap̓B(ĂяoɂĐ)
 * [note]
 *	* dst[]src[]ɁAobt@w肷邱Ƃł܂B(GAXZ[t)
 */
static void
des_encrypt_decrypt(
	      unsigned char dst[/*8*/],
	const unsigned char src[/*8*/],
	const unsigned char K[/*16*/][48])
{
	int i;
	int j;
	int t;
	unsigned char BLOCK[64];
	unsigned char L[32];
	unsigned char R[32];
	unsigned char R_E_K[48];
	unsigned char REK_S[32];

	des_byte_array_to_bit_array(BLOCK, src, 8);

	/* ]u */
	for(i = 0; i < 32; i++) {
		L[i] = BLOCK[IP[     i]];
		R[i] = BLOCK[IP[32 + i]];
	}

	/* 16ïÍIy[V */
	for(i = 0; i < 16; i++) {

		/* g^]uAƂ̔rI_a */
		for(j = 0; j < 48; j++) {
			R_E_K[j] = R[E[j]] ^ K[i][j];
		}

		/* S BOX */
		for(j = 0; j < 8; j++) {
			t = S[j][(R_E_K[j * 6 + 0] << 5) |
				 (R_E_K[j * 6 + 5] << 4) |
				 (R_E_K[j * 6 + 1] << 3) |
				 (R_E_K[j * 6 + 2] << 2) |
				 (R_E_K[j * 6 + 3] << 1) |
				 (R_E_K[j * 6 + 4] << 0)];
			REK_S[j * 4 + 0] = (t >> 3) & 1;
			REK_S[j * 4 + 1] = (t >> 2) & 1;
			REK_S[j * 4 + 2] = (t >> 1) & 1;
			REK_S[j * 4 + 3] = (t >> 0) & 1;
		}

		/* P]uALƂ̔rI_aALRւ
		 * - {́AŌ16iڂłLRւsȂ̂@Ȃ̂łA
		 *   ȒP̂߂ɁA16iڂłLRւsĂ܂Ƃɂ܂B
		 *   ̌ALRɋtɌāA16iڂ̗]vLRւ𑊎E܂B
		 */
		for(j = 0; j < 32; j++) {
			t = R[j];
			    R[j] = REK_S[P[j]] ^ L[j];
			                         L[j] = t;
		}
	}

	/* LRAŏI]u
	 * - 16iڂ̗]vLRւ𑊎E邽߂ɁAtɌ܂B
	 *   ̃RgQƂĂB
	 * - ŏI]úA]űtȂ̂ŁA]ue[ugďł܂B
	 *   ߖ̂߂ɁAŏI]ue[u͒`܂łB
	 */
	for(i = 0; i < 32; i++) {
		BLOCK[IP[     i]] = R[i]; /* tɌ̂ŁAL[i]ł͂ȂR[i] */
		BLOCK[IP[32 + i]] = L[i]; /* tɌ̂ŁAR[i]ł͂ȂL[i] */
	}

	des_bit_array_to_byte_array(dst, BLOCK, 8);
}

/* DES(ECB)ÍA܂́ADES(CBC)Ís܂B
 * [in]
 *	dst		ÍB(o)
 *	dst_cap		dst[]̋eʁB
 *	src		B()
 *	src_len		src[]̃oCgB
 *	key		64rbgB
 *	ecb_cbc		0 = ECB, 1 = CBCB
 * [out]
 *	߂l		Í̕B
 * [note]
 *	* dst[]src[]ɁAobt@w肷邱Ƃł܂B(GAXZ[t)
 *	  GAXZ[t̂߂ɁAӐ[R[fBO܂B
 *	  AAR[hύXꍇ́AӂĂB
 */
static int
des_ecb_cbc_encrypt(
	      void* _dst/*[dst_cap]*/, int dst_cap,
	const void* _src/*[src_len]*/, int src_len,
	const unsigned char key[/*8*/],
	int ecb_cbc) /* 0 = ECB, 1 = CBC */
{
	int dst_len = 0;
	      unsigned char* dst = _dst;
	const unsigned char* src = _src;
	//
	int i;
	int pad;
	unsigned char tmp[8];
	unsigned char cbc[8];
	unsigned char K[16][48];

	/*  */
	des_set_key(K, key, 0/*encrypt*/);

	/* ÍubN(N-1) */
	memset(cbc, 0, 8);

	/* ŏIubNȊO */
	while(src_len >= 8) {
		src_len -= 8;
		dst_len += 8;
		if(dst_cap < dst_len) DIE(); /* o̓obt@s */
		memcpy(tmp, src, 8);
		for(i = 0; i < 8; i++) {
			tmp[i] ^= cbc[i]; /* ECB̏ꍇAcbc0̂܂܂Ȃ̂ŁA_~[ł */
		}
		des_encrypt_decrypt(dst, tmp, K);
		if(ecb_cbc) {
			memcpy(cbc, dst, 8); /* CBC̏ꍇAÍubN(N-1)ۑ܂ */
		}
		src += 8;
		dst += 8;
	}

	/* ŏIubN */
	dst_len += 8;
	if(dst_cap < dst_len) DIE(); /* o̓obt@s */
	/*{{PKCS#5 padding*/
	pad = (8 - src_len);
	for(i = 0; i < pad; i++) {
		tmp[7 - i] = pad;
	}
	/*}}PKCS#5 padding*/
	memcpy(tmp, src, src_len);
	for(i = 0; i < 8; i++) {
		tmp[i] ^= cbc[i]; /* ECB̏ꍇAcbc0̂܂܂Ȃ̂ŁA_~[ł */
	}
	des_encrypt_decrypt(dst, tmp, K);

	return dst_len;
}

/* DES(ECB)ÍA܂́ADES(CBC)s܂B
 * [in]
 *	dst		B(o)
 *	dst_cap		dst[]̋eʁB
 *	src		ÍB()
 *	src_len		src[]̃oCgB
 *	key		64rbgB
 *	ecb_cbc		0 = ECB, 1 = CBCB
 * [out]
 *	߂l		̕B
 * [note]
 *	* dst[]src[]ɁAobt@w肷邱Ƃł܂B(GAXZ[t)
 *	  GAXZ[t̂߂ɁAӐ[R[fBO܂B
 *	  AAR[hύXꍇ́AӂĂB
 */
static int
des_ecb_cbc_decrypt(
	      void* _dst/*[dst_cap]*/, int dst_cap,
	const void* _src/*[src_len]*/, int src_len,
	const unsigned char key[/*8*/],
	int ecb_cbc) /* 0 = ECB, 1 = CBC */
{
	int dst_len = 0;
	      unsigned char* dst = _dst;
	const unsigned char* src = _src;
	//
	int i;
	int pad;
	unsigned char tmp[8];
	unsigned char cbc[8];
	unsigned char K[16][48];

	/* DESÍ́A8oCg̔{ł͂łB
	 * ܂APKCS#5 paddingsĂ̂ŁA0oCg͗L蓾܂B
	 */
	if((src_len <= 0) || (src_len & 7)) DIE();

	/*  */
	des_set_key(K, key, 1/*decrypt*/);

	/* ÍubN(N-1) */
	memset(cbc, 0, 8);

	/* ŏIubNȊO */
	while(src_len > 8) {
		src_len -= 8;
		dst_len += 8;
		if(dst_cap < dst_len) DIE(); /* o̓obt@s */
		des_encrypt_decrypt(tmp, src, K);
		for(i = 0; i < 8; i++) {
			tmp[i] ^= cbc[i]; /* ECB̏ꍇAcbc0̂܂܂Ȃ̂ŁA_~[ł */
		}
		if(ecb_cbc) {
			memcpy(cbc, src, 8); /* CBC̏ꍇAÍubN(N-1)ۑ܂ */
		}
		memcpy(dst, tmp, 8);
		src += 8;
		dst += 8;
	}

	/* ŏIubN */
	des_encrypt_decrypt(tmp, src, K);
	for(i = 0; i < 8; i++) {
		tmp[i] ^= cbc[i]; /* ECB̏ꍇAcbc0̂܂܂Ȃ̂ŁA_~[ł */
	}
	/*{{PKCS#5 padding*/
	pad = tmp[7];
	if((pad < 1) || (pad > 8)) DIE(); /* pfBOs */
	for(i = 0; i < pad; i++) {
		if(tmp[7 - i] != pad) DIE(); /* pfBOs */
	}
	/*}}PKCS#5 padding*/
	dst_len += (8 - pad);
	if(dst_cap < dst_len) DIE(); /* o̓obt@s */
	memcpy(dst, tmp, (8 - pad));

	return dst_len;
}

/****************************************************************************
 *	O[o֐
 ****************************************************************************/

int
des_ecb_encrypt(
	      void* dst/*[dst_cap]*/, int dst_cap,
	const void* src/*[src_len]*/, int src_len,
	const unsigned char key[/*8*/])
{
	return des_ecb_cbc_encrypt(dst, dst_cap, src, src_len, key, 0/*ECB*/);
}

int
des_ecb_decrypt(
	      void* dst/*[dst_cap]*/, int dst_cap,
	const void* src/*[src_len]*/, int src_len,
	const unsigned char key[/*8*/])
{
	return des_ecb_cbc_decrypt(dst, dst_cap, src, src_len, key, 0/*ECB*/);
}

int
des_cbc_encrypt(
	      void* dst/*[dst_cap]*/, int dst_cap,
	const void* src/*[src_len]*/, int src_len,
	const unsigned char key[/*8*/])
{
	return des_ecb_cbc_encrypt(dst, dst_cap, src, src_len, key, 1/*CBC*/);
}

int
des_cbc_decrypt(
	      void* dst/*[dst_cap]*/, int dst_cap,
	const void* src/*[src_len]*/, int src_len,
	const unsigned char key[/*8*/])
{
	return des_ecb_cbc_decrypt(dst, dst_cap, src, src_len, key, 1/*CBC*/);
}

const unsigned char*
des_64bit_key(const void* key, int len)
{
	static unsigned char out[8];
	//
	int i;
	int j;
	int bit;
	int parity;
	unsigned char src[56];
	unsigned char dst[64];
	unsigned char* psrc;
	unsigned char* pdst;

	if(len > 7) len = 7;
	memset(src, 0, sizeof src);
	des_byte_array_to_bit_array(src, key, len);

	psrc = src;
	pdst = dst;
	for(i = 0; i < 8; i++) {
		parity = 1;
		for(j = 0; j < 7; j++) {
			bit = *psrc++;
			parity ^= bit;
			*pdst++ = bit;
		}
		*pdst++ = parity;
	}

	des_bit_array_to_byte_array(out, dst, 8);

	return out;
}

