/*
 *	clipadp.h
 *
 *	2-bit ADPCM Decoder
 *
 *	CLiP - Common Library for P/ECE
 *	Copyright (C) 2001-2017 Naoyuki Sawa
 *
 *	* Wed Dec 20 00:13:10 JST 2006 Naoyuki Sawa
 *	- 쐬JnB
 *	* Wed Dec 20 17:31:02 JST 2006 Naoyuki Sawa
 *	- 1st [XB
 *	* Thu Dec 21 11:18:32 JST 2006 Naoyuki Sawa
 *	- ADPCMCHANNEL\̂ՂёւāAASMadpcm_mix1()œK܂B
 *	* Thu Mar 01 01:53:43 JST 2007 Naoyuki Sawa
 *	- adpcm_stat()ǉ܂B
 *	* Mon Jul 15 20:32:11 JST 2013 Naoyuki Sawa
 *	- ADPCMCHANNEL\̂ёւAvoltB[hǉ܂B
 *	- ʐݒ@\ɑΉ邽߁Aadpcm_att()֐ǉ܂B
 *	- RAMߖ񂷂邽߁AWe[uframadp.cclipadp.cֈړ܂B
 *	* Wed Nov 18 21:37:53 JST 2015 Naoyuki Sawa
 *	- 'extern "C" {'`'}'ň݂͂܂B.cpp܂Win32vWFNgCN[ho悤ɂ邽߂łB
 *	* Mon Jun 26 22:31:39 JST 2017 Naoyuki Sawa
 *	- adpcm_play()ɂāAvolatilew肪sĂR삵ĂR[hAvolatilet悤ɏC܂B
 *	- adpcm_rate()֐ǉ܂B
 *	* Tue Jun 27 22:55:03 JST 2017 Naoyuki Sawa
 *	- 2017/06/26̕ύXɂčŏI[v̒~O1Tvo͂ȂȂĂC܂B
 *	- [vprogressZbgɈpɂ܂B
 */
#ifndef __CLIP_ADP_H__
#define __CLIP_ADP_H__

#ifdef  __cplusplus
extern "C" {
#endif//__cplusplus

/****************************************************************************
 *	萔A\
 ****************************************************************************/

#ifdef  PIECE
#define ADPCM_ASM
#endif/*PIECE*/

/* PCEWAVEINFO.type ̓Ǝg */
#define PW_TYPE_2BITADPCM	3
#define PW_TYPE_ADPCM_X		(PW_TYPE_2BITADPCM|PW_TYPE_VR|PW_TYPE_ADP_INI)
#define PW_TYPE_ADPCM_X_NI	(PW_TYPE_2BITADPCM|PW_TYPE_VR)

#define ADPCMBUFLEN		320	/* =16000/50 c 1[tick](=1/50[sec])̃Tv */

/* AZuR[h璼ڎQƂ邽߁ACAEgŒł!! */
//typedef struct _ADPCMCHANNEL {
//	int loop;			/* + 0,4: 0=~, 1`=c胋[v, -1=[v */
//	int pcm;			/* + 4,4: oPCMl */
//	short data;			/* + 8,2: ADPCMl̃obt@ */
//	short delta;			/* +10,2: l */
//	short progress;			/* +12,2: isJE^ */
//	short rate;			/* +14,2: TvO[g */
//	int len;			/* +16,4: co̓Tv */
//	const unsigned char* ptr;	/* +20,4: ADPCMf[^ʒu */
//	int init_len;			/* +24,4: co̓TṽZbgl */
//	const unsigned char* init_ptr;	/* +28,4: ADPCMf[^ʒũZbgl */
//} ADPCMCHANNEL;				/* =32 */
//* Thu Dec 21 11:18:32 JST 2006 Naoyuki Sawa
//- ADPCMCHANNEL\̂ՂёւāAASMadpcm_mix1()œK܂B
//typedef struct _ADPCMCHANNEL {
//	int pcm;			/* + 0,4: oPCMl */
//	short data;			/* + 4,2: ADPCMl̃obt@ */
//	short delta;			/* + 6,2: l */
//	short progress;			/* + 8,2: isJE^ */
//	short rate;			/* +10,2: TvO[g */
//	int len;			/* +12,4: co̓Tv */
//	const unsigned char* ptr;	/* +16,4: ADPCMf[^ʒu */
//	int loop;			/* +20,4: 0=~, 1`=c胋[v, -1=[v */
//	int init_len;			/* +24,4: co̓TṽZbgl */
//	const unsigned char* init_ptr;	/* +28,4: ADPCMf[^ʒũZbgl */
//} ADPCMCHANNEL;				/* =32 */
//* Mon Jul 15 20:32:11 JST 2013 Naoyuki Sawa
//- ADPCMCHANNEL\̂̃tB[hёւ܂BŔAȉ̂Ƃł:
//  1. ܂adpcm_mix1()ɂāArate͏߂svł̂ɁA߂Ăʂ܂B
//     ߂svȃtB[hɂ܂Ƃ߂ĕёւArate߂Ȃ悤ɉǂ܂B
//  2. ʐݒ@\ɑΉ邽߁AvoltB[hǉ܂B
//     looptB[hintshortɏkA]ԂvoltB[hǉ܂B
//     ]āAADPCMCHANNEL\̑Ŝ̃TCÝA܂łƕςĂ܂B
//     ⑫ looptB[hk߁AlooplƂ32768`-2̒l͎gpłȂȂ܂B
//            ۂlooplƂďL̂悤ȒlgƂ͂܂̂ŁAvƎv܂B
typedef struct _ADPCMCHANNEL {
	const unsigned char* ptr;	/* + 0,4: ADPCMf[^ʒu */
	int len;			/* + 4,4: co̓Tv */			//{{2017/06/26RgǋL:2017/06/26ȑÓAPCEWAVEINFO.resvƓl(16000HzZł̃Tv)̂܂܊i[Ă܂B2017/06/26ȍ~́Aadpcm_play()ɂĎTvɕϊĊi[悤ɂȂ܂B}}
	int pcm;			/* + 8,4: oPCMl */
	short data;			/* +12,2: ADPCMl̃obt@ */
	short delta;			/* +14,2: l */
	short progress;			/* +16,2: isJE^ */
//{{2017/06/26RgύX:adpcm_rate()֐ǉ܂B
//	short rate;			/* +18,2: TvO[g */
//2017/06/26RgύX:adpcm_rate()֐ǉ܂B
	short rate;			/* +18,2: Đ[g */
//}}2017/06/26RgύX:adpcm_rate()֐ǉ܂B
	short vol;			/* +20,2:  */
	short loop;			/* +22,2: 0=~, 1`=c胋[v, -1=[v */
	const unsigned char* init_ptr;	/* +24,4: ADPCMf[^ʒũZbgl */
	int init_len;			/* +28,4: co̓TṽZbgl */	//{{2017/06/26RgǋL:2017/06/26ȑÓAPCEWAVEINFO.resvƓl(16000HzZł̃Tv)̂܂܊i[Ă܂B2017/06/26ȍ~́Aadpcm_play()ɂĎTvɕϊĊi[悤ɂȂ܂B}}
} ADPCMCHANNEL;				/* =32 */

typedef struct _ADPCMDRIVER {
	int nch;			/* `l */
	ADPCMCHANNEL* pch/*[nch]*/;	/* `l\ */
} ADPCMDRIVER;

/* clipadp.c */
extern const short adpcm_tbl[4/*ADPCMl*/][2];	//{{2013/07/15ǉ:RAMߖ񂷂邽߁AWe[uframadp.cclipadp.cֈړ܂B}}

/* framadp.c */
void adpcm_mix1(ADPCMCHANNEL* pch, int mixbuf[/*ADPCMBUFLEN*/]);
void adpcm_mix2(short wbuff[/*ADPCMBUFLEN*/], int mixbuf[/*ADPCMBUFLEN*/]);

/****************************************************************************
 *	AvP[Vp֐
 ****************************************************************************/

/* 2-bit ADPCM DecoderN܂B
 * [in]
 *	nch		`lB
 * [note]
 *	* adpcm_play()gOadpcm_init()ĂяoāA2-bit ADPCM DecoderNĂĂB
 *	* ̊֐́Astream_play()ĂяoĂ܂B
 *	  stream_play()ĂԂƁATEh荞݃xN^tbN܂B
 *	  vOIOadpcm_exit()ĂяoāAxN^𕜌ĂB
 *	  ACuIɎIɃtbN𕜌̂ŁAadpcm_exit()Ă΂ɏIĂSłB
 */
void adpcm_init(int nch);

/* 2-bit ADPCM Decoder~܂B
 * [note]
 *	* 2-bit ADPCM DecoderNĂȂ΁Å֐͉s܂B
 */
void adpcm_exit();

/* 2-bit ADPCM`ppdf[^Đ܂B
 * [in]
 *	ch		`lԍB(1`nch-1)
 *	data		2-bit ADPCM`ppdf[^B(t@CC[W̐擪AhX)
 *	loop		1` = [v, -1 = [vB
 * [note]
 *	* ̊֐̎ǵAsound_play()ƓłB
 *	  clippce.hsound_play()̃RgQƂĂB
 *	* ̊֐́A2-bit ADPCM`ppdf[^̍Đɂ̂ݗpł܂B
 *	  2-bit ADPCM`ȊOppdw肷ƁAG[I܂B
 *	  2-bit ADPCM`ȊOppdĐɂ́Asound_play()𗘗pĂB
 */
void adpcm_play(int ch, const void* data, int loop);

/* 2-bit ADPCM`ppdf[^Đ~܂B
 * [in]
 *	ch		`lԍB(1`nch-1)
 * [note]
 *	* w肳ꂽ`lĐłȂꍇ́Å֐͉s܂B
 */
void adpcm_stop(int ch);

/* w肳ꂽ2-bit ADPCM`lAĐ~𒲂ׂ܂B
 * [in]
 *	ch		`lԍB(1`nch-1)
 * [out]
 *	߂l		ĐȂ0ȊO̒lԂ܂B
 *			~Ȃ0Ԃ܂B
 * [note]
 *	* 2007/03/01݂̎́AADPCMCHANNEL.loop̒l̂܂ܕԂĂ̂ŁA
 *	  ߂ĺA{0=~, 1`=c胋[v, -1=[v} ƂȂĂ܂B
 *	  AύXꍇɁA߂lς\܂B
 *	  ߂lÂ悤ɉ肵ăR[fBOȂ悤AӂĂB
 */
int adpcm_stat(int ch);

//{{2013/07/15ǉ
/* w肳ꂽ2-bit ADPCM`ĺAʂݒ肵܂B
 * [in]
 *	ch		`lԍB(1`nch-1)
 *	att		ʁB(0`64)
 * [note]
 *	* ʂ :0`64: łB
 *	  l͈͂́AP/ECE APIpceWaveSetMasterAtt()pceWaveSetChAtt()ɕ킢܂B
 *	- pceWaveSetMasterAtt()pceWaveSetChAtt()APIt@Xɂ́Aő:0`127:ŏ ƏĂ܂A
 *	  ۂ̓́A:0`64: łA64ȏ͑SďłB
 *	   /usr/PIECE/sysdev/pcekn/snd.c volcalc() Q
 *	  {֐ApceWaveSetMasterAtt()pceWaveSetChAtt()̎ۂ̓ɕ킢A0`64 Ŏw肷邱Ƃ܂B
 */
void adpcm_att(int ch, int att);
//}}2013/07/15ǉ

//{{2017/06/26ǉ:adpcm_rate()֐ǉ܂B
/* w肳ꂽ2-bit ADPCM`ĺAĐ[gݒ肵܂B
 * [in]
 *	ch		`lԍB(1`nch-1)
 *	rate		Đ[gB(0`SPEAKER_FREQUENCY)
 * [note]
 *	- ~Ă`lɑ΂A֐̌ĂяóA_~[ƂȂASłB			dv
 *	  sꂸAG[܂B									
 *	- ֐Őݒ肵Đ[ǵAY`l̍ĐpĂԂ̂ݗLłB			
 *	  Y`lɂĎ̍Đsꂽɂ́AĐTEhf[^̊̍Đ[ggp܂B	
 *	- ֐́A2-bit ADPCM DecoderL̋@\łB
 *	  ̃TEhhCo(cliptsp.cW[AP/ECEWpceWave*())ɂ́AĐ[gݒ肷@\͗L܂B
 *	  2-bit ADPCM DecoderɁAĐ[gݒ肷@\ǉŔA2-bit ADPCM Decoder̊̃R[hAĐ[g̐ݒɑΉՂɂȂĂłB
 *	- Đ[gݒ肷@\ǉŔAȉ̒ʂłB
 *	  ̓xA[XQ[̃GWAĐ[gωȂĐvA2-bit ADPCM Decoderɂ̋@\ǉđΉ鎖ɂ܂B
 *	  ́Aʂ̈ĂƂāAɍĐ[g̐ݒɑΉĂclipmod.cW[gp(ƂĂclipmidi.c̕@Ă܂)A
 *	  AvP[Vstream_play()gpāAAvP[VڃGW̃f[^Đ[gωȂXg[ɈnĂl̂łA̕@͎܂łB
 *	  O҂̈ĂȂŔAQ[̌ʉ̍Đ[gς邽߂clipmod.cW[gp̂́Aclipmod.cW[̋@\߂ĖʂłB
 *	  ҂̈ĂȂŔAAvP[Vstream_play()gpƁÃTEhhCoƕpoAĐ[gςKv̖ʉ܂ŃAvP[VŃ~LVOKvA̎Ԃ|邩łB
 *	  L̗RɂA2-bit ADPCM DecoderɍĐ[gݒ肷@\ǉ̂K؂Ɣf܂B
 *	  AQ[̌ʉōĐ[gωKvLꍇ́ATEhhCoƂāA2-bit ADPCM DecoderIĉB
 *	- {́Aԃf[^eʂocliptsp.cW[ɁAĐ[gݒ肷@\ǉ̂łA͏o܂łB
 *	  cliptsp.cW[̎́ATrueSpeech̃f[^8KHzł鎖ɈˑĂāAĐ[gςՂ悤Ȏdg݂ɂȂĂȂłB
 *	  ܂AP/ECEWpceWave*()́AIɂ͓W[(2-bit ADPCM Decoder)ƓŁAȂύXōĐ[g̐ݒɑΉôłApceWave*()̓tbVP/ECEJ[lɗLĎ肪oȂ̂ŁAΉsłB
 */
void adpcm_rate(int ch, int rate);
//}}2017/06/26ǉ:adpcm_rate()֐ǉ܂B

#ifdef  __cplusplus
}//extern "C"
#endif//__cplusplus

#endif /*__CLIP_ADP_H__*/
