;
;	clip65ca.s
;
;	P/ECE MOS6502 Emulator ()
;
;	CLiP - Common Library for P/ECE
;	Copyright (C) 2001-2005 Naoyuki Sawa
;
;	* Fri Jan 28 03:55:00 JST 2005 Naoyuki Sawa
;	- 쐬JnB
;
#include "clip65ca.h"

	.code
	.align 1

;****************************************************************************
;	
;****************************************************************************

; 荞݂s܂B
;
; [in]
;		%data	%addr
;		------	------
;	IRQ	0	0xfffe
;	NMI	0	0xfffa
;	BRK	1	0xfffe
;
; [note]
;	* sReLXg痘p܂B
;	  sReLXgO璼ڌĂяoƂ͂ł܂B
;
	.global	m6502cpu_interrupt
m6502cpu_interrupt:
	add	%PC, %data			; if BRK then PC++
	;
	xcall.d	m6502cpu_pack			; %t0 = PSR
	ld.w	%t0, %data			; *delay*
	xand	%data, %data, ~(1<<4)		; if BRK then B=1 else B=0
	xsll	%t0, 4
	or	%t0, %data
	;
	ext	m6502mem@ah			; %data = PC
	ext	m6502mem@al
	sub	%data, %PC
	xcall.d	m6502cpu_push			; Push HI(PC)
	rr	%data, 8			; *delay*
	xcall.d	m6502cpu_push			; Push Lo(PC)
	rl	%data, 8			; *delay*
	xcall.d	m6502cpu_push			; Push PSR
	ld.w	%data, %t0			; *delay*
	;
	ext	m6502mem@ah			; %PC = &mem[mem[addr]]
	ext	m6502mem@al
	ld.uh	%PC, [%addr]
	ext	m6502mem@ah
	ext	m6502mem@al
	add	%PC, %PC
	;
	xbset	[%CPU+BDI], 2			; IRQ}XN܂B
	xbclr	[%CPU+FLAGS], 0			; 荞ݔɂAWAI܂B
	ret

; ۗĂIRQv𒲂ׁAs\ȂΎs܂B
;
; [note]
;	* sReLXg痘p܂B
;	  sReLXgO璼ڌĂяoƂ͂ł܂B
;
	.global	m6502cpu_check_pending
m6502cpu_check_pending:
	xbtst	[%CPU+BDI], 2			; IRQ}XNĂȂ?
	xjrne	m6502cpu_check_pending_EXIT
	xbtst	[%CPU+FLAGS], 1			; IRQvۗĂ邩?
	xjreq	m6502cpu_check_pending_EXIT
	xbclr	[%CPU+FLAGS], 1			; IRQvtONA܂B
	xld.w	%addr, 0xfffe			; IRQs܂B
	xcall.d	m6502cpu_interrupt
	ld.w	%data, 0			; *delay*
m6502cpu_check_pending_EXIT:
	ret

;****************************************************************************
;	
;****************************************************************************

; IRQv܂B
;
; [note]
;	* sReLXgOĂ΂܂B
;	  sReLXgĂяoĂ͂܂B
;
	.global	m6502cpu_irq
m6502cpu_irq:
	pushn	%r3
	xcall	m6502cpu_enter			; sReLXgo܂B
	xbset	[%CPU+FLAGS], 1			; IRQvtOZbg܂B
	xcall	m6502cpu_check_pending		; IRQs\ׂ܂B
	xcall	m6502cpu_leave			; sReLXg߂܂B
	popn	%r3
	ret

; NMIs܂B
;
; [note]
;	* sReLXgOĂ΂܂B
;	  sReLXgĂяoĂ͂܂B
;
	.global	m6502cpu_nmi
m6502cpu_nmi:
	pushn	%r3
	xcall	m6502cpu_enter			; sReLXgo܂B
	xld.w	%addr, 0xfffa			; NMIs܂B
	xcall.d	m6502cpu_interrupt
	ld.w	%data, 0			; *delay*
	xcall	m6502cpu_leave			; sReLXg߂܂B
	popn	%r3
	ret

;****************************************************************************
;	
;****************************************************************************

	.global	m6502cpu_ERR
m6502cpu_ERR:
	xcall	m6502cpu_leave		; sReLXg𔲂܂B
	xjp	m6502cpu_err		; Cł̃G[[`ցB

;****************************************************************************
;	
;****************************************************************************
