//
//	ToolLib_StringInput.c
//
//	GfB^[ʏ - c[GUI̕
//
//	* Tue Apr 18 21:46:46 JST 2017 Naoyuki Sawa
//	- 1st [XB
//	* Wed Apr 19 22:11:14 JST 2017 Naoyuki Sawa
//	- u@DxLibɈˑȂ悤ɂvƁuACŃRpCo悤ɂvΉ܂B
//	  ڍׂ́A/clip/ToolLib/README.TXT ́ÃRgQƂĉB
//	* Thu Apr 20 21:31:57 JST 2017 Naoyuki Sawa
//	- CuIuWFNg̎ʎqAnh˃|C^ɕύX܂B
//	  IWiłł͐IuWFNgŒ蒷zɊi[ĊǗĂ̂łAߖ̂߂ɃXgŊǗ悤ɕύXÂ߂ɂ͐nh|C^̕sǂłB
//	  AtHgnhƕ̓nh́ACuIuWFNgł͂ȂobNGh̃IuWFNgȂ̂ŁA̕ύXɂ͊֌Wnĥ܂܂łB
//	* Tue May 02 22:54:46 JST 2017 Naoyuki Sawa
//	- eW[̃TCY`̔{ꗥŒo悤ɁAToolLib.hTOOL_SCALE̒`ǉ܂B
//	  ڍׂ́AToolLib.h̓̃RgQƂĉB
//	* Sun May 14 23:23:22 JST 2017 Naoyuki Sawa
//	- ToolStringInput_IsAnyHovered(),ToolStringInput_IsHovered()֐ǉ܂B
//	  ڍׂ́AToolLib.h̓̃RgQƂĉB
//
#include "clip.h"
#ifdef  TOOLLIB_USE_STRINGINPUT
//*****************************************************************************
//	萔A}NA\
//*****************************************************************************
#define TOOL_STRINGINPUT_HEIGHT		(TOOL_SCALE*(18))	//͗̈̏cB
#define TOOL_ONE_NUMBER_SIZE		(TOOL_SCALE*(7))	//ꕶ̉̉B
//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
#define TOOL_STRING_BUFFER_SIZE		(2049)			//obt@̃TCYB
//-----------------------------------------------------------------------------
//͍\
/*typedef*/ struct _SToolStringInput {
	SToolVisible*	TVisible;				//֘AtĂ\ԏB
	SToolWindow*	TWindow;				//֘AtĂEChEB
	POINT		Position;				//͂̕\ʒuB
	char*		Name;					//O̕񂪊i[Ă郁AhXۑĂ|C^B
	int		NumberOnly;				//l̂ݓ͉\ǂB
	int		NumberNum;				//͂ł鐔ľB(NumberOnly0ȊȌꍇ̂ݗL)
	int		StringDrawWidth;			//͗̈̉B(NumberOnly0̏ꍇ̂ݗL)
	int		EndFlag;				//͂Ă邩ǂB
	int		Visible;				//\ԁB
	int		IntNumber;				//͕𐮐lɕϊlB
	double		FloatNumber;				//͕𕂓_lɕϊlB
	int		InputHandle;				//̓nhB
	char		InputString[TOOL_STRING_BUFFER_SIZE];	//͕擾ۂɎgpobt@B
} /*SToolStringInput*/;
//*****************************************************************************
//	[Jϐ
//*****************************************************************************
static GSList*	g_TStringInput;
//*****************************************************************************
//	[J֐錾
//*****************************************************************************
static void ToolStringInput_Step(SToolStringInput* TStringInput, double StepTime);
static void ToolStringInput_Draw(SToolStringInput* TStringInput);
//*****************************************************************************
//	AvP[Vp֐
//*****************************************************************************
//͏쐬B
//[in]
//	Name			O̕񂪊i[ꂽAhXB
//	x,y			͂̕\ʒuB
//	NumberOnly		l̂ݓ͉\ɂ邩ǂB
//	NumberNum		͂ł鐔ľB(NumberOnly0ȊȌꍇ̂ݗL)
//	StringDrawWidth		͗̈̉B(NumberOnly0̏ꍇ̂ݗL)
//[out]
//	߂l			͏B
SToolStringInput* ToolStringInput_Create(const char* Name, int x, int y, int NumberOnly, int NumberNum, int StringDrawWidth) {
	SToolStringInput* TStringInput;
	//V{^i[邽߂̃̊mہB
	TStringInput = calloc(1, sizeof(SToolStringInput));
	if(!TStringInput) { DIE(); }
	//mۂ̈ۑB
	g_TStringInput = g_slist_append(g_TStringInput, TStringInput);
	//B
//sv	TStringInput->TVisible        = NULL;
//sv	TStringInput->TWindow         = NULL;
	TStringInput->Position.x      = x;
	TStringInput->Position.y      = y;
	TStringInput->NumberOnly      = NumberOnly;
	TStringInput->NumberNum       = NumberNum;
	TStringInput->StringDrawWidth = StringDrawWidth;
//sv	TStringInput->EndFlag         = 0;
	TStringInput->Visible         = 1;
//sv	TStringInput->IntNumber       = 0;
//sv	TStringInput->FloatNumber     = 0;
	TStringInput->InputHandle     = -1;
	if(Name) {
		TStringInput->Name = strdup(Name);
		if(!TStringInput->Name) { DIE(); }
	}
	//͏ԂB
	return TStringInput;
}
//-----------------------------------------------------------------------------
//͏폜B
//[in]
//	TStringInput		͏B
void ToolStringInput_Delete(SToolStringInput* TStringInput) {
	//OۑpɃmۂĂꍇ͉B
	free(TStringInput->Name);
	//̓nh쐬Ă폜B
	if(TStringInput->InputHandle != -1) { ToolFunc_DeleteKeyInput(TStringInput->InputHandle); }
	//mۂĂB
	g_TStringInput = g_slist_remove(g_TStringInput, TStringInput);
	free(TStringInput);
}
//-----------------------------------------------------------------------------
//SĂ̕͏폜B
void ToolStringInput_Delete_All() {
	//LȑSĂ͂̕폜B
	while(g_TStringInput) { ToolStringInput_Delete(g_TStringInput->data); }
}
//-----------------------------------------------------------------------------
//͏Ɋ֘At\ԏZbgB
//[in]
//	TStringInput		͏B
//	TVisible		\ԏB
void ToolStringInput_SetVisibleHandle(SToolStringInput* TStringInput, SToolVisible* TVisible) {
	TStringInput->TVisible = TVisible;
}
//-----------------------------------------------------------------------------
//͏̕\ԂύXB
//[in]
//	TStringInput		͏B
//	Visible			V\ԁB
void ToolStringInput_SetVisible(SToolStringInput* TStringInput, int Visible) {
	//V\ԂۑB
	TStringInput->Visible = Visible;
}
//-----------------------------------------------------------------------------
//͏̕\Ԃ擾B
//[in]
//	TStringInput		͏B
//[out]
//	߂l			\ԁB(0ȊO:\,0:\)
int ToolStringInput_GetVisible(SToolStringInput* TStringInput) {
	//\Ԃ0̏ꍇ0ԂB
	if(!TStringInput->Visible) { return 0; }
	//֘AtĂEChE̕\Ԃ0̏ꍇ0ԂB
	if(!ToolWindow_GetVisible(TStringInput->TWindow)) { return 0; }
	//\ԏ񂪓o^ĂāA\ԏ̕\Ԃ0̏ꍇ0ԂB
	if(!ToolVisible_GetVisible(TStringInput->TVisible)) { return 0; }
	//ɂĂ\ł͂ȂƂƂȂ̂0ȊOԂB
	return 1;
}
//-----------------------------------------------------------------------------
//͏Ɗ֘AtEChEݒ肷B
//[in]
//	TStringInput		͏B
//	TWindow			EChEB
void ToolStringInput_SetWindow(SToolStringInput* TStringInput, SToolWindow* TWindow) {
	TStringInput->TWindow = TWindow;
}
//-----------------------------------------------------------------------------
//͏͗̈̍̕WύXB
//[in]
//	TStringInput		͏B
//	x,y			ύX͗̈̍̕WB
void ToolStringInput_SetPosition(SToolStringInput* TStringInput, int x, int y) {
	TStringInput->Position.x = x;
	TStringInput->Position.y = y;
}
//-----------------------------------------------------------------------------
//͏̓͒̕ύXB
//[in]
//	TStringInput		͏B
//	String			Zbg镶񂪊i[ꂽAhXB
void ToolStringInput_SetString(SToolStringInput* TStringInput, const char* String) {
	//ۑB
	strcpy(TStringInput->InputString, String);
	//̓nhLȏꍇ͕̓nhɔfB
	if(TStringInput->InputHandle != -1) { ToolFunc_SetKeyInputString(String, TStringInput->InputHandle); }
}
//-----------------------------------------------------------------------------
//͏̓͒̕擾B
//[in]
//	TStringInput		͏B
//	String			͒̕i[郁̈̐擪AhXB
void ToolStringInput_GetString(SToolStringInput* TStringInput, char* String) {
	//̓nhLȏꍇ͓͒̕擾B
	if(TStringInput->InputHandle != -1) {
		ToolFunc_GetKeyInputString(String, TStringInput->InputHandle);
	//͒ł͂Ȃꍇ͓͂m肵Rs[B
	} else {
		strcpy(String, TStringInput->InputString);
	}
}
//-----------------------------------------------------------------------------
//͏͂̕𖳏ŏIB
//[in]
//	TStringInput		͏B
void ToolStringInput_AlwaysEnd(SToolStringInput* TStringInput) {
	//̓nhLȏꍇ͓͒̕擾B
	if(TStringInput->InputHandle != -1) { ToolFunc_GetKeyInputString(TStringInput->InputString, TStringInput->InputHandle); }
}
//-----------------------------------------------------------------------------
//͏̓͒̕ƂĐlɕύXB
//[in]
//	TStringInput		͏B
//	Number			͒ƂĐݒ肷鐮lB
void ToolStringInput_SetIntNumber(SToolStringInput* TStringInput, int Number) {
	//lۑB
	TStringInput->IntNumber   = Number;
	TStringInput->FloatNumber = Number;
	//̓nhLȏꍇ͕̓nhɃZbgB
	if(TStringInput->InputHandle != -1) {
		ToolFunc_SetKeyInputNumber(Number, TStringInput->InputHandle);
		ToolFunc_GetKeyInputString(TStringInput->InputString, TStringInput->InputHandle);
	//̓nhȏꍇ͒Pɐl𕶎ɕϊB
	} else {
		sprintf(TStringInput->InputString, "%d", Number);
	}
}
//-----------------------------------------------------------------------------
//͏̓͒̕Ƃĕ_lɕύXB
//[in]
//	TStringInput		͏B
//	Number			͒ƂĐݒ肷镂_lB
void ToolStringInput_SetFloatNumber(SToolStringInput* TStringInput, double Number) {
	//lۑB
	TStringInput->IntNumber   = Number;
	TStringInput->FloatNumber = Number;
	//̓nhLȏꍇ͕̓nhɃZbgB
	if(TStringInput->InputHandle != -1) {
		ToolFunc_SetKeyInputNumberToFloat(Number, TStringInput->InputHandle);
		ToolFunc_GetKeyInputString(TStringInput->InputString, TStringInput->InputHandle);
	//̓nhȏꍇ͒Pɐl𕶎ɕϊB
	} else {
		sprintf(TStringInput->InputString, "%f", Number);
	}
}
//-----------------------------------------------------------------------------
//͏̓͒̕𐮐lɕϊ̂擾B
//[in]
//	TStringInput		͏B
//[out]
//	߂l			͒̕𐮐lɕϊlB
int ToolStringInput_GetIntNumber(SToolStringInput* TStringInput) {
	return TStringInput->IntNumber;
}
//-----------------------------------------------------------------------------
//͏̓͒̕𕂓_lɕϊ̂擾B
//[in]
//	TStringInput		͏B
//[out]
//	߂l			͒̕𕂓_lɕϊlB
double ToolStringInput_GetFloatNumber(SToolStringInput* TStringInput) {
	return TStringInput->FloatNumber;
}
//-----------------------------------------------------------------------------
//͏̓͂̕IĂ邩ǂ擾B
//[in]
//	TStringInput		͏B
//	Reset			̓͂IĂ邩ǂ̃tOZbg邩ǂB
//[out]
//	߂l			͂IĂ邩ǂB(0ȊO:IĂ,0:IĂȂ)
int ToolStringInput_CheckEnd(SToolStringInput* TStringInput, int Reset) {
	//߂lۑB
	int Result = TStringInput->EndFlag;
	//Zbgw肪ꍇ̓tO|B
	if(Reset) { TStringInput->EndFlag = 0; }
	//߂lԂB
	return Result;
}
//-----------------------------------------------------------------------------
//͏͂̕ANeBuɂȂĂꍇɃANeBuԂB
//[in]
//	TStringInput		͏B
void ToolStringInput_ResetActive(SToolStringInput* TStringInput) {
	//ANeBuȕ̓nhƂȂĂANeBuȕ̓nhԂɂB
	if(ToolFunc_GetActiveKeyInput() == TStringInput->InputHandle) { ToolFunc_SetActiveKeyInput(-1); }
}
//-----------------------------------------------------------------------------
//SĂ̕͏̏ԐڏsB
//[in]
//	StepTime		i߂鎞ԁB(P:b)
void ToolStringInput_Step_All(double StepTime) {
	GSList* list = g_TStringInput;
	while(list) {
		ToolStringInput_Step(list->data, StepTime);
		list = list->next;
	}
}
//-----------------------------------------------------------------------------
//SĂ̕͏̕`ڏsB
void ToolStringInput_Draw_All() {
	GSList* list = g_TStringInput;
	while(list) {
		ToolStringInput_Draw(list->data);
		list = list->next;
	}
}
//-----------------------------------------------------------------------------
//}EXJ[\ꂩ͂̓̕ɂ邩ǂ`FbNB
//[out]
//	߂l			ꂩ͂̓̕Ƀ}EXJ[\邩ǂB(0ȊO:ɂ,0:Oɂ)
int ToolStringInput_IsAnyHovered() {
	GSList* list = g_TStringInput;
	while(list) {
		if(ToolStringInput_IsHovered(list->data)) { return 1; }
		list = list->next;
	}
	return 0;
}
//-----------------------------------------------------------------------------
//}EXJ[\͂̓ɂ邩ǂ`FbNB
//[in]
//	TStringInput		͏B
//[out]
//	߂l			͂̓Ƀ}EXJ[\邩ǂB(0ȊO:ɂ,0:Oɂ)
int ToolStringInput_IsHovered(SToolStringInput* TStringInput) {
	//TODO:
	return 0;
}
//*****************************************************************************
//	[J֐
//*****************************************************************************
//͏̏ԐڏsB
//[in]
//	TStringInput		͏B
//	StepTime		i߂鎞ԁB(P:b)
static void ToolStringInput_Step(SToolStringInput* TStringInput, double StepTime) {
	int ButtonFontHandle;
	int MouseX, MouseY;
	int MouseInput, MouseEdgeInput;
	int MouseSelectStartX, MouseSelectEndX;
	int SizeX, SizeY;
	int NameDrawW;
	int AreaX, AreaY;
	int In;
	int SelectStart, SelectEnd;
	//\Ԃ0̏ꍇ͕̓nh폜ďIB
	if(!ToolStringInput_GetVisible(TStringInput)) {
		//̓nhLꍇ͓͒̕ۑō폜B
		if(TStringInput->InputHandle != -1) {
			ToolFunc_GetKeyInputString(TStringInput->InputString, TStringInput->InputHandle);
			ToolFunc_DeleteKeyInput(TStringInput->InputHandle);
			TStringInput->InputHandle = -1;
		}
		return;	//܂
	}
	//͒`p̃tHgnh擾B
	ButtonFontHandle = ToolStatic_GetButtonFontHandle();
	//}EXJ[\̈ʒu擾B
	ToolStatic_GetMousePosition(&MouseX, &MouseY);
	//}EX̓͏Ԃ擾B
	MouseInput     = ToolStatic_GetMouseButton();
	MouseEdgeInput = ToolStatic_GetMouseEdgeButton();
	//}EX̑I͈͂擾B
	ToolStatic_GetMouseSelectStartPosition(&MouseSelectStartX, NULL,
	                                       &MouseSelectEndX,   NULL);
	//̓nh쐬ĂȂꍇ͍쐬B
	if(TStringInput->InputHandle == -1) {
		//l͂ǂō쐬ύXB
		if(TStringInput->NumberOnly) {
			//l͂łȂ̓nh쐬B
			TStringInput->InputHandle = ToolFunc_MakeKeyInput(TStringInput->NumberNum, 0, 0, 1);
			//lZbgB
			ToolFunc_SetKeyInputNumberToFloat(TStringInput->FloatNumber, TStringInput->InputHandle);
		} else {
			//lȊO͂ł̓̕nh쐬B
			TStringInput->InputHandle = ToolFunc_MakeKeyInput(TOOL_STRING_BUFFER_SIZE - 1, 0, 0, 0);
			//m肵Ă͕ZbgB
			ToolFunc_SetKeyInputString(TStringInput->InputString, TStringInput->InputHandle);
		}
		//̓nh̍쐬ɎsG[B
		if(TStringInput->InputHandle < 0) { DIE(); }
		//݂̓̕nhŐݒ肳Ă镶擾B
		ToolFunc_GetKeyInputString(TStringInput->InputString, TStringInput->InputHandle);
	}
	//͗̈̕ƍZbgB
	SizeX = TStringInput->NumberOnly ? (TStringInput->NumberNum * TOOL_ONE_NUMBER_SIZE + 4)
	                                 :  TStringInput->StringDrawWidth;
	SizeY = TOOL_STRINGINPUT_HEIGHT;
	//O̕`敝擾B
	if(TStringInput->Name) {
		NameDrawW = ToolFunc_GetDrawStringWidthToHandle(TStringInput->Name, -1, ToolStatic_GetNormalFontHandle()) + 2;
	} else {
		NameDrawW = 0;
	}
	//͗̈̍Wƕ͗̈Ƀ}EXJ[\邩ǂ擾B
	if(TStringInput->TWindow) {
		ToolWindow_GetDrawLeftUpPos(TStringInput->TWindow, &AreaX, &AreaY);
		AreaX += TStringInput->Position.x + NameDrawW;
		AreaY += TStringInput->Position.y;
		In = ToolStatic_CheckMouseIn(AreaX, AreaY, AreaX + SizeX, AreaY + SizeY) &&
		     ToolWindow_CheckInfoAreaIn(TStringInput->TWindow, MouseX, MouseY);
	} else {
		AreaX = TStringInput->Position.x + NameDrawW;
		AreaY = TStringInput->Position.y;
		In = ToolStatic_CheckMouseIn(AreaX, AreaY, AreaX + SizeX, AreaY + SizeY);
	}
	//͒̑̕I͈͂擾B
	ToolFunc_GetKeyInputSelectArea(&SelectStart, &SelectEnd, TStringInput->InputHandle);
	//}EX̍NbNuԂ̏ꍇ͏𕪊B
	if(MouseEdgeInput & (1<<0)/*MOUSE_INPUT_LEFT*/) {
		//͗̈̒ŃNbNǂŏ𕪊B
		if(In) {
			//̓nhANeBuɂB
			ToolFunc_SetActiveKeyInput(TStringInput->InputHandle);
			//_uNbNꍇ͓͒ŜIԂɂB
			if(ToolStatic_GetMouseDoubleClick()) {
				ToolFunc_SetKeyInputSelectArea(0, 9999, TStringInput->InputHandle);
			} else {
				//VONbN̏ꍇ͓͒̑I͈͂B
				ToolFunc_SetKeyInputSelectArea(-1, -1, TStringInput->InputHandle);
				//NbNWɍ킹ē͒̃J[\̈ʒuύXB
				ToolFunc_SetKeyInputCursorPosition(ToolStatic_GetKeyInputCursorPos(AreaX,
				                                                                   MouseX,
				                                                                   TStringInput->InputHandle,
				                                                                   ButtonFontHandle),
				                          TStringInput->InputHandle);
			}
		} else {
			//͗̈̊OŃNbNꍇ͕̑I͈͂B
			ToolFunc_SetKeyInputSelectArea(-1, -1, TStringInput->InputHandle);
		}
	//}EX̍{^ĂĊ͗̈Ƀ}EXJ[\ꍇ͓͒̑I͈͂ύXB
	} else if((MouseInput & (1<<0)/*MOUSE_INPUT_LEFT*/) && In) {
		int Start = ToolStatic_GetKeyInputCursorPos(AreaX,
		                                            MouseSelectStartX,
		                                            TStringInput->InputHandle,
		                                            ButtonFontHandle);
		int End   = ToolStatic_GetKeyInputCursorPos(AreaX,
		                                            MouseSelectEndX,
		                                            TStringInput->InputHandle,
		                                            ButtonFontHandle);
		if(Start != End) { ToolFunc_SetKeyInputSelectArea(Start, End, TStringInput->InputHandle); }
		//͒̃J[\ʒu}EXJ[\̈ʒuɂ킹ĕύXB
		ToolFunc_SetKeyInputCursorPosition(ToolStatic_GetKeyInputCursorPos(AreaX,
		                                                                   MouseX,
		                                                                   TStringInput->InputHandle,
		                                                                   ButtonFontHandle),
		                          TStringInput->InputHandle);
	}
	//͗̈ŉENbNꂽꍇB
	if((MouseEdgeInput & (1<<1)/*MOUSE_INPUT_RIGHT*/) && In) {
		if(SelectStart != -1) {
			char TempStr[TOOL_STRING_BUFFER_SIZE];
			int StringLength, smin, smax;
			//͒̑I͈͂ꍇ̓Nbv{[hɕo^B
			ToolFunc_GetKeyInputString(TempStr, TStringInput->InputHandle);
			if(SelectStart < SelectEnd) {
				smin = SelectStart;
				smax = SelectEnd;
			} else {
				smin = SelectEnd;
				smax = SelectStart;
			}
			StringLength = smax - smin;
			memmove(TempStr, TempStr + smin, StringLength);
			TempStr[StringLength] = '\0';
			ToolFunc_SetClipboardText(TempStr);
			ToolFunc_SetKeyInputSelectArea(-1, -1, TStringInput->InputHandle);
		} else {
			char *String, *p;
			int Size;
			//͒̑I͈͂ꍇ̓Nbv{[h͕̕ɒǉB
			//Nbv{[h̃̕TCY擾B
			Size = ToolFunc_GetClipboardText(NULL);
			//i[邽߂̃̊mہB
			String = malloc(Size);
			if(!String) { DIE(); }
			//̊mۂɐNbv{[h̕擾B
			ToolFunc_GetClipboardText(String);
			//擾͕ɒǉB
			for(p = String; *p; p++) { ToolFunc_StockInputChar(*p); }
			//mۂ̉B
			free(String);
		}
	}
	//͂Ă犮sB
	if(ToolFunc_CheckKeyInput(TStringInput->InputHandle)) {
		//͂Ă邩ǂ̃tO𗧂ĂB
		TStringInput->EndFlag = 1;
		//̕擾B
		ToolFunc_GetKeyInputString(TStringInput->InputString, TStringInput->InputHandle);
		//̕𐔒lƂꍇ̒l擾B
		TStringInput->IntNumber   = ToolFunc_GetKeyInputNumber(TStringInput->InputHandle);
		TStringInput->FloatNumber = ToolFunc_GetKeyInputNumberToFloat(TStringInput->InputHandle);
		//̓nh͍ēx͏ԂɂB
		ToolFunc_ReStartKeyInput(TStringInput->InputHandle);
	}
}
//-----------------------------------------------------------------------------
//͏ʂɕ`悷B
//[in]
//	TStringInput		͏B
static void ToolStringInput_Draw(SToolStringInput* TStringInput) {
	char String[TOOL_STRING_BUFFER_SIZE];
	int NormalFontHandle, ButtonFontHandle;
	int AreaX, AreaY;
	int NameDrawW;
	int SizeX, SizeY;
	RECT DrawRect, InfoArea;
	//\Ԃ̏ꍇ͉IB
	if(!ToolStringInput_GetVisible(TStringInput)) { return; }	//܂
	//O`p̃tHgnh擾B
	NormalFontHandle = ToolStatic_GetNormalFontHandle();
	//͒`p̃tHgnh擾B
	ButtonFontHandle = ToolStatic_GetButtonFontHandle();
	//͗̈̍W擾B
	if(TStringInput->TWindow) {
		ToolWindow_GetDrawLeftUpPos(TStringInput->TWindow, &AreaX, &AreaY);
		AreaX += TStringInput->Position.x;
		AreaY += TStringInput->Position.y;
		//EChE񂪗Lȏꍇ͕`̈搧ݒsB
		ToolWindow_SetupDrawArea(TStringInput->TWindow);
	} else {
		AreaX = TStringInput->Position.x;
		AreaY = TStringInput->Position.y;
	}
	//Oꍇ͖O`悷B
	if(TStringInput->Name) {
		//O̕`敝擾B
		NameDrawW = ToolFunc_GetDrawStringWidthToHandle(TStringInput->Name, -1, NormalFontHandle) + 2;
		//O`悷B
		ToolFunc_DrawStringToHandle(AreaX,
		                            AreaY,
		                            TStringInput->Name,
		                            ToolFunc_GetColor(255,255,255),
		                            NormalFontHandle);
		//͗̈𖼑O̕`敝Eɂ炷B
		AreaX += NameDrawW;
	}
	//͗̈̕ƍZbgB
	SizeX = TStringInput->NumberOnly ? (TStringInput->NumberNum * TOOL_ONE_NUMBER_SIZE + 4)
	                                 :  TStringInput->StringDrawWidth;
	SizeY = TOOL_STRINGINPUT_HEIGHT;
	//̘͗̈g`B
	ToolStatic_DrawButton(AreaX - 3,
	                      AreaY - 3,
	                      SizeX + 4,
	                      SizeY,
	                      ToolFunc_GetColor(  0,  0,  0),
	                      ToolFunc_GetColor( 64, 64, 64),
	                      ToolFunc_GetColor(255,255,255),
	                      ToolFunc_GetColor(191,191,191),
	                      ToolFunc_GetColor(220,220,220));
	//֘AtĂEChE񂪂ꍇ̓EChEl`̈搧ݒsB
	if(TStringInput->TWindow) {
		DrawRect.left   = AreaX;
		DrawRect.top    = AreaY;
		DrawRect.right  = AreaX + SizeX;
		DrawRect.bottom = AreaY + SizeY - 1;
		InfoArea = ToolWindow_GetInfoArea(TStringInput->TWindow);
		ToolFunc_RectClipping(&DrawRect, &InfoArea);
		ToolFunc_SetDrawArea(DrawRect.left, DrawRect.top, DrawRect.right, DrawRect.bottom);
	//EChE񂪊֘AtĂȂꍇ͕͗̈̂܂ܕ`搧̈ƂĐݒ肷B
	} else {
		ToolFunc_SetDrawArea(AreaX, AreaY, AreaX + SizeX, AreaY + SizeY - 1);
	}
	//͒̕`ɎgptHgݒ肷B
	ToolFunc_SetKeyInputStringFont(ButtonFontHandle);
	//݂̓͒̕擾B
	ToolFunc_GetKeyInputString(String, TStringInput->InputHandle);
	//͒񂪊m肵ƈقȂꍇ͕`FύXB
	if(strcmp(String, TStringInput->InputString)) {
		ToolFunc_SetKeyInputStringColor(ToolFunc_GetColor(0,0,255), -1, -1, -1, -1, -1, -1);
	} else {
		ToolFunc_SetKeyInputStringColor(ToolFunc_GetColor(0,0,  0), -1, -1, -1, -1, -1, -1);
	}
	//͒̕`B
	ToolFunc_DrawKeyInputString(AreaX, AreaY, TStringInput->InputHandle);
	//ݒɖ߂B
	ToolFunc_SetKeyInputStringFont(-1);
	ToolFunc_SetKeyInputStringColor(-1, -1, -1, -1, -1, -1, -1);
	ToolFunc_SetDrawAreaFull();
}
#endif//TOOLLIB_USE_STRINGINPUT
