//
//	ToolLib_List.c
//
//	GfB^[ʏ - c[GUĨXg
//
//	* Tue Apr 18 21:46:46 JST 2017 Naoyuki Sawa
//	- 1st [XB
//	* Wed Apr 19 22:11:14 JST 2017 Naoyuki Sawa
//	- u@DxLibɈˑȂ悤ɂvƁuACŃRpCo悤ɂvΉ܂B
//	  ڍׂ́A/clip/ToolLib/README.TXT ́ÃRgQƂĉB
//	* Thu Apr 20 21:31:57 JST 2017 Naoyuki Sawa
//	- CuIuWFNg̎ʎqAnh˃|C^ɕύX܂B
//	  IWiłł͐IuWFNgŒ蒷zɊi[ĊǗĂ̂łAߖ̂߂ɃXgŊǗ悤ɕύXÂ߂ɂ͐nh|C^̕sǂłB
//	  AtHgnhƕ̓nh́ACuIuWFNgł͂ȂobNGh̃IuWFNgȂ̂ŁA̕ύXɂ͊֌Wnĥ܂܂łB
//	- ToolLib_List.ćÃmۂ̏P܂B
//	  IWiłł͍̂߂ɂx܂Ƃ߂ămۂ鏈ɂȂĂ܂Ał͒Pstrv`̊֐gpēsxmۂ悤ɕύX܂B
//	  ݂̏AKvȏʂœCugp\͖̂ŁAx̒P̕D悵łB
//	* Tue May 02 22:54:46 JST 2017 Naoyuki Sawa
//	- eW[̃TCY`̔{ꗥŒo悤ɁAToolLib.hTOOL_SCALE̒`ǉ܂B
//	  ڍׂ́AToolLib.h̓̃RgQƂĉB
//	* Sun May 14 23:23:22 JST 2017 Naoyuki Sawa
//	- ToolList_IsAnyHovered(),ToolList_IsHovered()֐ǉ܂B
//	  ڍׂ́AToolLib.h̓̃RgQƂĉB
//
#include "clip.h"
//*****************************************************************************
//	萔A}NA\
//*****************************************************************************
#define TOOL_ONE_LINE_HEIGHT	(TOOL_SCALE*(16))	//Xg1sӂ̏cB
//-----------------------------------------------------------------------------
//Xg\
/*typedef*/ struct _SToolList {
	SToolVisible*	TVisible;	//֘AtĂ\ԏB
	SToolWindow*	TWindow;	//֘AtĂEChEB
	char**		ObjList;	//ǉĂs̃̕AhXi[Ă|C^zB(strv`)
	int		Width;		//ǉĂ镶̒ōő̉B
	int		SelectIndex;	//IĂsB
	int		Change;		//Xg̏ԂɕωǂB
	int		Visible;	//\ԁB
} /*SToolList*/;
//*****************************************************************************
//	[Jϐ
//*****************************************************************************
static GSList*	g_TList;
//*****************************************************************************
//	[J֐錾
//*****************************************************************************
static void ToolList_Step(SToolList* TList, double StepTime);
static void ToolList_Draw(SToolList* TList);
//*****************************************************************************
//	AvP[Vp֐
//*****************************************************************************
//Xg쐬B
//[out]
//	߂l			XgB
SToolList* ToolList_Create() {
	SToolList* TList;
	//VXgi[邽߂̃̊mہB
	TList = calloc(1, sizeof(SToolList));
	if(!TList) { DIE(); }
	//mۂ̈ۑB
	g_TList = g_slist_append(g_TList, TList);
	//B
//sv	TList->TVisible    = NULL;
//sv	TList->TWindow     = NULL;
	TList->ObjList     = strv_new(NULL);
//sv	TList->Width       = 0;
	TList->SelectIndex = -1;
//sv	TList->Change      = 0;
	TList->Visible     = 1;
	//XgԂB
	return TList;
}
//-----------------------------------------------------------------------------
//Xg폜B
//[in]
//	TList			XgB
void ToolList_Delete(SToolList* TList) {
	//spɊmۂĂB
	strv_free(TList->ObjList);
	//mۂĂB
	g_TList = g_slist_remove(g_TList, TList);
	free(TList);
}
//-----------------------------------------------------------------------------
//SẴXg폜B
void ToolList_Delete_All() {
	//LȑSẴXg폜B
	while(g_TList) { ToolList_Delete(g_TList->data); }
}
//-----------------------------------------------------------------------------
//XgɊ֘At\ԏZbgB
//[in]
//	TList			XgB
//	TVisible		\ԏB
void ToolList_SetVisibleHandle(SToolList* TList, SToolVisible* TVisible) {
	TList->TVisible = TVisible;
}
//-----------------------------------------------------------------------------
//XgB
//[in]
//	TList			XgB
//	TWindow			֘AtEChEB
void ToolList_Initialize(SToolList* TList, SToolWindow* TWindow) {
	//spɊmۂĂB
	strv_free(TList->ObjList);
	//B
	TList->TWindow     = TWindow;
	TList->ObjList     = strv_new(NULL);
	TList->Width       = 0;
	TList->SelectIndex = -1;
	TList->Change      = 0;
	//EChẼNCAg̈B
	ToolWindow_SetClientSize(TList->TWindow, 16, 16);
}
//-----------------------------------------------------------------------------
//Xg̑IĂs̕ύXȂǂǂ擾B
//[in]
//	TList			XgB
//	Reset			ύXǂ̏Zbg邩ǂB
//[out]
//	߂l			ύXǂB(0ȊO:ύX,0:ύX͔ĂȂ)
int ToolList_GetChange(SToolList* TList, int Reset) {
	int Result = TList->Change;
	if(Reset) { TList->Change = 0; }
	return Result;
}
//-----------------------------------------------------------------------------
//XgɍsǉB
//[in]
//	TList			XgB
//	String			ǉsɕ\镶B
//	...			όB
void ToolList_AddObj(SToolList* TList, const char* String, ...) {
	va_list VaList;
	char* FixString;
	int DrawWidth;
	//όǉ镶\zB
	va_start(VaList, String);
	FixString = strdup_vprintf(String, VaList);
	va_end(VaList);
	//ǉs̉̕擾B
	DrawWidth = ToolFunc_GetDrawStringWidthToHandle(FixString, -1, ToolStatic_GetNormalFontHandle());
	//܂ł̍ő剡傫ꍇ͍ő剡XVB
	if(DrawWidth > TList->Width) { TList->Width = DrawWidth; }
	//Vs̏ۑB
	strv_push(&TList->ObjList, FixString);
	//EChẼNCAg̈XVB
	ToolWindow_SetClientSize(TList->TWindow, TList->Width, ToolList_GetHeight(TList));
	//ڂ̍sꍇ́AǉsIԂɂB
	if(ToolList_GetObjNum(TList) == 1) { ToolList_SetSelectIndex(TList, 0); }
}
//-----------------------------------------------------------------------------
//Xg̕\ԂύXB
//[in]
//	TList			XgB
//	Visible			V\ԁB
void ToolList_SetVisible(SToolList* TList, int Visible) {
	//V\ԂۑB
	TList->Visible = Visible;
}
//-----------------------------------------------------------------------------
//Xg̕\Ԃ擾B
//[in]
//	TList			XgB
//[out]
//	߂l			\ԁB(0ȊO:\,0:\)
int ToolList_GetVisible(SToolList* TList) {
	//\Ԃ0̏ꍇ0ԂB
	if(!TList->Visible) { return 0; }
	//֘AtĂEChE̕\Ԃ0̏ꍇ0ԂB
	if(!ToolWindow_GetVisible(TList->TWindow)) { return 0; }
	//\ԏ񂪓o^ĂāA\ԏ̕\Ԃ0̏ꍇ0ԂB
	if(!ToolVisible_GetVisible(TList->TVisible)) { return 0; }
	//ɂĂ\ł͂ȂƂƂȂ̂0ȊOԂB
	return 1;
}
//-----------------------------------------------------------------------------
//Xg̑IsύXB
//[in]
//	TList			XgB
//	Index			sԍB
void ToolList_SetSelectIndex(SToolList* TList, int Index) {
	TList->SelectIndex = Index;
}
//-----------------------------------------------------------------------------
//Xg̑IĂs擾B
//[in]
//	TList			XgB
//[out]
//	߂l			IĂs̔ԍB(ǂ̍sIĂȂꍇ-1)
int ToolList_GetSelectIndex(SToolList* TList) {
	return TList->SelectIndex;
}
//-----------------------------------------------------------------------------
//Xgɒǉs̐擾B
//[in]
//	TList			XgB
int ToolList_GetObjNum(SToolList* TList) {
	return strv_length(TList->ObjList);
}
//-----------------------------------------------------------------------------
//XgɒǉSĂ̍s킹c擾B
//[in]
//	TList			XgB
//[out]
//	߂l			Xg̑Ss̏cB(sNZP)
int ToolList_GetHeight(SToolList* TList) {
	return TOOL_ONE_LINE_HEIGHT * ToolList_GetObjNum(TList);
}
//-----------------------------------------------------------------------------
//XgɒǉSĂ̍s킹擾B
//[in]
//	TList			XgB
//[out]
//	߂l			Xg̑Ss̉B(sNZP)
int ToolList_GetWidth(SToolList* TList) {
	return TList->Width;
}
//-----------------------------------------------------------------------------
//SẴXg̏ԐڏsB
//[in]
//	StepTime		i߂鎞ԁB(P:b)
void ToolList_Step_All(double StepTime) {
	GSList* list = g_TList;
	while(list) {
		ToolList_Step(list->data, StepTime);
		list = list->next;
	}
}
//-----------------------------------------------------------------------------
//SẴXg̕`ڏsB
void ToolList_Draw_All() {
	GSList* list = g_TList;
	while(list) {
		ToolList_Draw(list->data);
		list = list->next;
	}
}
//-----------------------------------------------------------------------------
//}EXJ[\ꂩ̃Xg̓ɂ邩ǂ`FbNB
//[out]
//	߂l			ꂩ̃Xg̓Ƀ}EXJ[\邩ǂB(0ȊO:ɂ,0:Oɂ)
int ToolList_IsAnyHovered() {
	GSList* list = g_TList;
	while(list) {
		if(ToolList_IsHovered(list->data)) { return 1; }
		list = list->next;
	}
	return 0;
}
//-----------------------------------------------------------------------------
//}EXJ[\Xg̓ɂ邩ǂ`FbNB
//[in]
//	TList			XgB
//[out]
//	߂l			Xg̓Ƀ}EXJ[\邩ǂB(0ȊO:ɂ,0:Oɂ)
int ToolList_IsHovered(SToolList* TList) {
	int MouseX, MouseY;
	//\Ԃ0̏ꍇ͉IB
	if(!ToolList_GetVisible(TList)) { return 0; }	//܂
	//Xg̓EChȄ\̈Ŝ߂悤ɕ`悷̂ŁA\̈ɑ΂`FbNƓłB
	ToolStatic_GetMousePosition(&MouseX, &MouseY);
	return ToolWindow_CheckInfoAreaIn(TList->TWindow,
	                                  MouseX,
	                                  MouseY);
}
//*****************************************************************************
//	[J֐
//*****************************************************************************
//Xg̏ԐڏsB
//[in]
//	TList			XgB
//	StepTime		i߂鎞ԁB(P:b)
static void ToolList_Step(SToolList* TList, double StepTime) {
	int MouseX, MouseY;
	RECT InfoArea;
	int DrawX, DrawY;
	int MouseOffsetX, MouseOffsetY;
	int Index;
	//\Ԃ0̏ꍇ͉IB
	if(!ToolList_GetVisible(TList)) { return; }	//܂
	//}EX̍{^ꂽuԂł͂Ȃꍇ͓ɉȂB
	if(!(ToolStatic_GetMouseEdgeButton() & (1<<0)/*MOUSE_INPUT_LEFT*/)) { return; }	//܂
	//}EXJ[\̈ʒu擾B
	ToolStatic_GetMousePosition(&MouseX, &MouseY);
	//֘AtĂEChȄ\̈擾B
	InfoArea = ToolWindow_GetInfoArea(TList->TWindow);
	//֘AtĂEChẼXN[o[̏ԂlNCAg̈̕`挴_ƂȂXN[W擾B
	ToolWindow_GetDrawLeftUpPos(TList->TWindow, &DrawX, &DrawY);
	//Xgł̃}EẌʒuZoB
	MouseOffsetX = MouseX - DrawX;
	MouseOffsetY = MouseY - DrawY;
	//}EX̃{^uԂXg̗̈悩OĂ牽IB
	if((MouseX < InfoArea.left) || (MouseX >= InfoArea.right ) ||
	   (MouseY < InfoArea.top ) || (MouseY >= InfoArea.bottom) ||
	   ( MouseOffsetY                         <  0) ||
	   ((MouseOffsetY / TOOL_ONE_LINE_HEIGHT) >= ToolList_GetObjNum(TList))) { return; }	//܂
	//}EXJ[\̈ʒuɊYsZoB
	Index = MouseOffsetY / TOOL_ONE_LINE_HEIGHT;
	//}EXJ[\̈ʒuɂs̕񕔕ɃJ[\Ȃ牽ɏIB
	if((MouseOffsetX <  0) ||
	    MouseOffsetX >= ToolFunc_GetDrawStringWidthToHandle(TList->ObjList[Index], -1, ToolStatic_GetNormalFontHandle())) { return; }	//܂
	//IĂs̕ύXB
	ToolList_SetSelectIndex(TList, Index);
	//Ԃɕωǂ̃tO𗧂ĂB
	TList->Change = 1;
}
//-----------------------------------------------------------------------------
//Xgʂɕ`悷B
//[in]
//	TList			XgB
static void ToolList_Draw(SToolList* TList) {
	int WinDrawX, WinDrawY;
	int ClientY;
	RECT InfoArea;
	int NormalColor, SelectColor;
	int NormalFontHandle;
	int i, n;
	//\Ԃ0̏ꍇ͉IB
	if(!ToolList_GetVisible(TList)) { return; }	//܂
	//EChẼXN[o[̏ԂlNCAg̈̕`挴_ƂȂXN[W擾B
	ToolWindow_GetDrawLeftUpPos(TList->TWindow, &WinDrawX, &WinDrawY);
	//EChẼXN[o[̏ԂlNCAg̈̕`挴_ƂȂW擾B
	ToolWindow_GetClientArea(TList->TWindow, NULL, &ClientY);
	//EChE SetDrawArea ŕ`̈𐧌ݒsB
	ToolWindow_SetupDrawArea(TList->TWindow);
	//EChȄ\̈擾B
	InfoArea = ToolWindow_GetInfoArea(TList->TWindow);
	//ʏ̕̕`FƑIĂ镶̕`F擾B
	NormalColor = ToolFunc_GetColor(255,255,255);
	SelectColor = ToolFunc_GetColor(255,  0,  0);
	//`p̃tHgnh擾B
	NormalFontHandle = ToolStatic_GetNormalFontHandle();
	//s̕`惋[vB
	n = ToolList_GetObjNum(TList);
	for(i = ClientY / TOOL_ONE_LINE_HEIGHT; i < n; i++) {
		//`ʒu\̈悩OĂ烋[v𔲂B
		if((i * TOOL_ONE_LINE_HEIGHT + WinDrawY) > InfoArea.bottom) { break; }
		//s̕`B
		ToolFunc_DrawStringToHandle(WinDrawX,
		                            WinDrawY + i * TOOL_ONE_LINE_HEIGHT,
		                            TList->ObjList[i],
		                           (TList->SelectIndex == i) ? SelectColor : NormalColor,
		                            NormalFontHandle);
	}
	//`\͈͂ɖ߂B
	ToolFunc_SetDrawAreaFull();
}
