/*
 *	UfeSvr - UFEt@CT[o (DOS)
 *
 *	UFE - P/ECE USB File System Emulation
 *	Copyright (C) 2005-2018 Naoyuki Sawa
 *
 *	* Wed Jun 26 19:31:00 JST 2005 Naoyuki Sawa
 *	- ܂ŒP̃vWFNĝACLiP Toolsɑgݍ݂܂B
 *	* Wed Jul 19 18:18:33 JST 2017 Naoyuki Sawa
 *	- \PCŎgpƁAڑP/ECEߕׂŃnOAbv鎖LC܂B
 *	- ()́Aȉ̒ʂłB
 *	  c[͂܂ŁAEFCgŏ펞P/ECEɑ΂USBʐMŃ|[OsāAP/ECẼt@CANZX̗vĎĂ܂B
 *	  c[[X2005ŃA݂ƔׂĂ܂PCxAPCS͂Ń|[OsĂx̊Ԋu󂫁AP/ECEg̏ԂcĂāA肪Ȃ̂Ǝv܂B
 *	  2017݂́AƔׂPCȂAPCS͂Ń|[OsƁAP/ECEg̏ԂcȂ炢ZԊuUSB荞݂AP/ECẼAvnOAbv悤ɂȂĂ܂̂Ǝv܂B
 *	- ΍􂵂@́Aȉ̒ʂłB
 *	  c[P/ECEւ̃|[OsʁAP/ECẼt@CANZX̗vꍇ́Ã|[O܂ł̑҂ԂA񂾂񒷂čs悤ɂ܂B
 *	  10~bÂ₵ĂāAőA100~b܂ŒȂ悤ɂ܂B(10~b,100~bƂl͈Ӗ̂鐔lł͂ȂAۂɓĂ݂ď肭lłB)
 *	  ʓIɃt@CANZX̗v͘AĔ鎖łȀꍇ́AZԊuŃ|[OĂ̂łɗvɉ邱ƂłAv΂炭΃|[OԊuȂĕׂ܂B
 *	- L̒sāA30炢@œmFĂ݂āÂƂnOAbvɓ삷悤ɂȂ܂B
 *	  AvȁAƎv܂B
 *	* Thu May 24 23:59:59 JST 2018 Naoyuki Sawa
 *	- pceFileWriteSct()̑ΉA܂ł͖̂A܂B
 *	- pceFileCreate()̑ΉA܂ł͖̂A܂B
 *	- pceFileDelete()ɂΉ܂B
 *	* Fri May 25 23:59:59 JST 2018 Naoyuki Sawa
 *	- R}hCōƃtH_wo悤ɂ܂B
 *	* Sun May 27 23:59:59 JST 2018 Naoyuki Sawa
 *	- '-a'IvVǉ܂B(Auto-exit)
 *	  '-a'IvVw肳ꂽAxP/ECEƂ̐ڑmAP/ECEڑꂽAufesvr.exeIɏI܂B
 *	  ̃IvVǉړÍAP/ECẼvOňÃt@CsUFEgPCɃt@C𐶐AP/ECẼvOIAufesvr.exeIP[XLłB
 *	  Ⴆ΁Aob`XNvg̒ŉ摜ۑP/ECEvOsAufesvr.exesPCɃt@C𐶐AP/ECẼvOIAufesvr.exeIăob`XNvgpAꂽt@Cɑ΂ĉsꍇȂǂłB
 *	  ܂ł́AL[ufesvr.exeIȂƃob`XNvg̏ֈڍso܂łA'-a'IvVǉɂāAIɎ̏ֈڍso悤ɂȂ܂B
 */
#define STRICT
#include <windows.h>

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <io.h>
#include <conio.h>
#include <fcntl.h>
#include <direct.h>
#include <sys/stat.h>

#define NOPCESPRINTF
#define __PCEKN__
#include "C:/usr/PIECE/include/piece.h"
#include "C:/usr/PIECE/sysdev/pcekn/vector.h"
#include "C:/usr/PIECE/tools/isd/pieceif.h"
#pragma comment(lib,"C:/usr/PIECE/tools/isd/pieceif.lib")

#include "../../clipufe.h"

/****************************************************************************
 *	
 ****************************************************************************/

USBCOMS ucs;
int ufe_addr;
UFE ufe;

/****************************************************************************
 *	
 ****************************************************************************/

//{{2018/05/27ǉ:'-a'IvVǉ܂B(Auto-exit)
static void usage() {
	printf("Usage: ufesvr.exe [-a] [ƃtH_]\n");
}
//}}2018/05/27ǉ:'-a'IvVǉ܂B(Auto-exit)

int
main(int argc, char* argv[])
{
	int retval;
	int c;
	int i;
	//
	int serial = 0;
	int state = -1; /* 񃁃bZ[Ŵ */
//{{2017/07/19ǉ:\PCŎgpƁAڑP/ECEߕׂŃnOAbv鎖LC܂B
	int sleep_time = 0; /* |[OԊuBP/ECẼt@CANZXv΁A10~bÂ₵čsāAŒ100~bԊu܂ő₷B */
//}}2017/07/19ǉ:\PCŎgpƁAڑP/ECEߕׂŃnOAbv鎖LC܂B
//{{2018/05/27ǉ:'-a'IvVǉ܂B(Auto-exit)
	int opt_a = 0;
//}}2018/05/27ǉ:'-a'IvVǉ܂B(Auto-exit)

	/* ismExit()̃bZ[WזȂ̂ŁAG[o͂Ă܂B */
	close(2);

//{{2018/05/25ǉ:R}hCōƃtH_wo悤ɂ܂B
//	if(argc == 1) {
//		/** no job **/
//	} else if(argc == 2) {
//		struct stat st;
//		char* dir = argv[1];
////{{T[rX
//		//fBNg̖'\\'tĂƁAstat()G[Ԃ悤B(VC++6.0ɂĊmF)
//		//ꂾ̌ŁuƃtH_'`\'쐬o܂BBvƂG[\ƁA[U[ȂG[Ȃ̂炸ɍƎv̂ŁA
//		//T[rXƂāAc[̏ŁAfBNg̖'\'mɍ폜鎖ɂB
//		{
//			int len = strlen(dir);
//			if(len && (dir[len - 1] == '\\')) { dir[len - 1] = '\0'; }
//		}
////}}T[rX
//		if(!stat(dir, &st)) {
//			if(!(st.st_mode & S_IFDIR)) {
//				printf("ƃtH_'%s'Ɠ̃t@C݂܂B\n", dir);
//				exit(1);
//			}
//		} else {
//			if(_mkdir(dir)) {	//Unixł́uint mkdir(const char* path, mode_t mode);vłAWindowsł́uint _mkdir(const char* path);vłB
//				printf("ƃtH_'%s'쐬o܂B\n", dir);
//				exit(1);
//			}
//		}
//		if(_chdir(dir)) {
//			printf("ƃtH_'%s'ֈړo܂B\n", dir);
//			exit(1);
//		}
//	} else {
//		printf("Usage: ufesvr.exe [ƃtH_]\n");
//		exit(1);
//	}
//2018/05/27ύX:'-a'IvVǉ܂B(Auto-exit)
	for(i = 1; i < argc; i++) {
		if(argv[i][0] != '-') { break; }
		switch(argv[i][1]) {
		default:
			usage();
			exit(1);
		case 'a':
			if(argv[i][2]) {
				usage();
				exit(1);
			}
			opt_a = 1;
			break;
		}
	}
	if(i <= (argc - 2)) {
		usage();
		exit(1);
	}
	if(i == (argc - 1)) {
		struct stat st;
		char* dir = argv[i];
//{{T[rX
		//fBNg̖'\\'tĂƁAstat()G[Ԃ悤B(VC++6.0ɂĊmF)
		//ꂾ̌ŁuƃtH_'`\'쐬o܂BBvƂG[\ƁA[U[ȂG[Ȃ̂炸ɍƎv̂ŁA
		//T[rXƂāAc[̏ŁAfBNg̖'\'mɍ폜鎖ɂB
		{
			int len = strlen(dir);
			if(len && (dir[len - 1] == '\\')) { dir[len - 1] = '\0'; }
		}
//}}T[rX
		if(!stat(dir, &st)) {
			if(!(st.st_mode & S_IFDIR)) {
				printf("ƃtH_'%s'Ɠ̃t@C݂܂B\n", dir);
				exit(1);
			}
		} else {
			if(_mkdir(dir)) {	//Unixł́uint mkdir(const char* path, mode_t mode);vłAWindowsł́uint _mkdir(const char* path);vłB
				printf("ƃtH_'%s'쐬o܂B\n", dir);
				exit(1);
			}
		}
		if(_chdir(dir)) {
			printf("ƃtH_'%s'ֈړo܂B\n", dir);
			exit(1);
		}
	}
//}}2018/05/27ύX:'-a'IvVǉ܂B(Auto-exit)

L_REDO:
	retval = ismInit();
	if(retval != 0) {
		goto L_ERR;
	}

	retval = ismUCOpen(&ucs);
	if((retval != 0) ||
	   !(ucs.mystat) ||
	   (memcmp(ucs.signature, "UFE1", 4) != 0)) {
		goto L_ERR;
	}
	ufe_addr = *(int*)&ucs.signature[4];

	for(;;) {
		if(_kbhit()) {
			ismUCClose();
			ismExit();
			c = _getch();
			if(c == 'p') {
				printf("### ꎞIP/ECEƂ̐ڑ܂BȂɂL[ƕA܂B\n");
				for(;;) {
					i = GetTickCount();
					while((int)(GetTickCount() - i) < 100/**/) {
						if(_kbhit()) {
							c = _getch();
							goto L_ERR;
						}
						Sleep(100/**/);
					}
				}
			}
			exit(0);
		}

		retval = ismUCGetStat(&ucs);
		if((retval != 0) ||
		   !(ucs.mystat)) {
			goto L_ERR;
		}

		if(state != 1) {
			printf("### P/ECEƂ̐ڑm܂BȂɂL[ƏI܂B\n");
			state = 1;
		}

		retval = ismReadMem((void*)&ufe.ksno, ufe_addr + 4/*ksno*/, 4/*ksno*/);
		if(retval != 0) {
			goto L_ERR;
		}
		if(!ufe.ksno) {
//{{2017/07/19ύX:\PCŎgpƁAڑP/ECEߕׂŃnOAbv鎖LC܂B
//			Sleep(0);
//2017/07/19ύX:\PCŎgpƁAڑP/ECEߕׂŃnOAbv鎖LC܂B
			if((sleep_time += 10/**/) > 100/**/) { sleep_time = 100/**/; } /* P/ECẼt@CANZXv΁AP/ECE̕גጸ̂߂ɁA|[OԊu𑝂₵čsB */
			Sleep(sleep_time);
//}}2017/07/19ύX:\PCŎgpƁAڑP/ECEߕׂŃnOAbv鎖LC܂B
			continue;
		}
//{{2017/07/19ǉ:\PCŎgpƁAڑP/ECEߕׂŃnOAbv鎖LC܂B
		sleep_time = 0; /* P/ECẼt@CANZXvA|[OԊuZbgBP/ECẼt@CANZXv͘AIɔ鎖Ƒz肵āA̗vɂȂׂf邽߂łB */
//}}2017/07/19ǉ:\PCŎgpƁAڑP/ECEߕׂŃnOAbv鎖LC܂B

		retval = ismReadMem((void*)&ufe.api, ufe_addr + 8/*api*/, 16/*api*/);
		if(retval != 0) {
			goto L_ERR;
		}

		switch(ufe.ksno) {
		case KSNO_FileFindOpen:
			printf("%5d: FileFindOpen", serial++);
			ufe.result = pceFileFindOpen(
				ufe.api.find_open.pfi);
			break;
		case KSNO_FileFindNext:
			printf("%5d: FileFindNext", serial++);
			ufe.result = pceFileFindNext(
				ufe.api.find_next.pfi);
			break;
		case KSNO_FileFindClose:
			printf("%5d: FileFindClose", serial++);
			ufe.result = pceFileFindClose(
				ufe.api.find_close.pfi);
			break;
		case KSNO_FileOpen:
			printf("%5d: FileOpen", serial++);
			ufe.result = pceFileOpen(
				ufe.api.open.pfa,
				ufe.api.open.fname,
				ufe.api.open.mode);
			break;
		case KSNO_FileReadSct:
			printf("%5d: FileReadSct", serial++);
			ufe.result = pceFileReadSct(
				ufe.api.read_sct.pfa,
				ufe.api.read_sct.ptr,
				ufe.api.read_sct.sct,
				ufe.api.read_sct.len);
			break;
		case KSNO_FileWriteSct:
			printf("%5d: FileWriteSct", serial++);
			ufe.result = pceFileWriteSct(
				ufe.api.write_sct.pfa,
				ufe.api.write_sct.ptr,
				ufe.api.write_sct.sct,
				ufe.api.write_sct.len);
			break;
		case KSNO_FileClose:
			printf("%5d: FileClose", serial++);
			ufe.result = pceFileClose(
				ufe.api.close.pfa);
			break;
		case KSNO_FileCreate:
			printf("%5d: FileCreate", serial++);
			ufe.result = pceFileCreate(
				ufe.api.create.fname,
				ufe.api.create.size);
			break;
//{{2018/05/24ǉ:pceFileDelete()ɂΉ܂B
		case KSNO_FileDelete:
			printf("%5d: FileDelete", serial++);
			ufe.result = pceFileDelete(
				ufe.api.delete.fname);
			break;
//}}2018/05/24ǉ:pceFileDelete()ɂΉ܂B
		default:
			printf("%5d: Invalid\n", serial++);
			goto L_ERR;
		}
		printf(" -> %d\n", ufe.result);

		ufe.ksno = 0;
		retval = ismWriteMem((void*)&ufe.result, ufe_addr + 0/*result+ksno*/, 8/*result+ksno*/);
		if(retval != 0) {
			goto L_ERR;
		}
	}
L_ERR:
	ismUCClose();
	ismExit();

//{{2018/05/27ǉ:'-a'IvVǉ܂B(Auto-exit)
	//'-a'IvVw肳ꂽc
	if(opt_a) {
		//xP/ECEƂ̐ڑmAP/ECEڑꂽc
		if(state == 1) {
			printf("### P/ECEڑ܂BvOI܂B\n");
			//ufesvr.exeIɏI܂B
			exit(0);
		}
	}
//}}2018/05/27ǉ:'-a'IvVǉ܂B(Auto-exit)

	if(state != 0) {
		printf("### P/ECE̐ڑ҂Ă܂BȂɂL[ƏI܂B\n");
		state = 0;
	}
	i = GetTickCount();
	while((int)(GetTickCount() - i) < 100/**/) {
		if(_kbhit()) {
			c = _getch();
			exit(0);
		}
		Sleep(100/**/);
	}
	goto L_REDO;

	return 0;
}

/****************************************************************************
 *	
 ****************************************************************************/

int
pceFileFindOpen(FILEINFO* pfi)
{
	int retval;
	FILEINFO fi;
	//
	HANDLE hfind = INVALID_HANDLE_VALUE;
	WIN32_FIND_DATA* pfd = NULL;

	pfd = malloc(sizeof(WIN32_FIND_DATA));
	if(!pfd) {
		goto L_ERR;
	}

	hfind = FindFirstFile("*.*", pfd);
	//if(hfind == INVALID_HANDLE_VALUE) {
	//	goto L_ERR;
	//}

	memset(&fi, 0, sizeof fi);
	*(int*)&fi.works[0] = (int)hfind;
	*(int*)&fi.works[4] = (int)pfd;

	retval = ismWriteMem((void*)&fi, (int)pfi, sizeof(FILEINFO));
	if(retval != 0) {
		goto L_ERR;
	}

	return 0;
L_ERR:
	if(hfind != INVALID_HANDLE_VALUE) {
		FindClose(hfind);
	}
	if(pfd) {
		free(pfd);
	}
	return -1;
}

int
pceFileFindNext(FILEINFO* pfi)
{
	int retval;
	FILEINFO fi;
	HANDLE hfind;
	WIN32_FIND_DATA* pfd;

	retval = ismReadMem((void*)&fi, (int)pfi, sizeof(FILEINFO));
	if(retval != 0) {
		return 0;
	}

	hfind = (HANDLE)          *(int*)&fi.works[0];
	pfd   = (WIN32_FIND_DATA*)*(int*)&fi.works[4];

	if(hfind == INVALID_HANDLE_VALUE) {
		return 0;
	}

	while(pfd->dwFileAttributes & FILE_ATTRIBUTE_DIRECTORY) {
		if(!FindNextFile(hfind, pfd)) {
			return 0;
		}
	}

	GetShortPathName(pfd->cFileName, fi.filename, sizeof fi.filename);
	strlwr(fi.filename);
	fi.length = pfd->nFileSizeLow;

	if(!FindNextFile(hfind, pfd)) {
		FindClose(hfind);
		hfind = INVALID_HANDLE_VALUE;
		*(int*)&fi.works[0] = (int)hfind;
	}

	retval = ismWriteMem((void*)&fi, (int)pfi, sizeof(FILEINFO));
	if(retval != 0) {
		return 0;
	}

	printf(" %s(%d)", fi.filename, fi.length);

	return 1;
}

int
pceFileFindClose(FILEINFO* pfi)
{
	int retval;
	FILEINFO fi;
	HANDLE hfind;
	WIN32_FIND_DATA* pfd;

	retval = ismReadMem((void*)&fi, (int)pfi, sizeof(FILEINFO));
	if(retval != 0) {
		return -1;
	}

	hfind = (HANDLE)          *(int*)&fi.works[0];
	pfd   = (WIN32_FIND_DATA*)*(int*)&fi.works[4];

	if(hfind != INVALID_HANDLE_VALUE) {
		FindClose(hfind);
	}
	if(pfd) {
		free(pfd);
	}

	return 0;
}

int
pceFileOpen(FILEACC* pfa, const char* fname, int mode)
{
	int retval;
	FILEACC fa;
	char path[MAXFILENAME + 1];
	//
	FILE* fp = NULL;

	retval = ismReadMem(path, (int)fname, MAXFILENAME);
	if(retval != 0) {
		goto L_ERR;
	}
	path[MAXFILENAME] = '\0';

	printf(" %s(%d)", path, mode);

	switch(mode) {
	case FOMD_RD:
		fp = fopen(path, "rb");
		break;
	case FOMD_WR:
		fp = fopen(path, "r+b");	//pceFileOpen(`,FOMD_WR)̓t@C݂ȂΎsdlȂ̂ŁAłfopen(`"r+b")ĝK؂łB
		break;
	}
	if(!fp) {
		goto L_ERR;
	}

	fseek(fp, 0, SEEK_END);			//̉ftell()Ńt@CTCY擾邽߂Ɍ݈ʒu𖖔ֈړB݈ʒu𖖔ֈړ鎖͖̂ړIł͂ȂB

	memset(&fa, 0, sizeof fa);
	fa.valid         = FILEACC_UFE;
	*(int*)&fa.chain = (int)fp;
	fa.fsize         = ftell(fp);

	retval = ismWriteMem((void*)&fa, (int)pfa, sizeof(FILEACC));
	if(retval != 0) {
		goto L_ERR;
	}

	return 0;

L_ERR:
	if(fp) {
		fclose(fp);
	}
	return -1;
}

int
pceFileReadSct(FILEACC* pfa, void* ptr, int sct, int len)
{
	int retval;
	FILEACC fa;
	FILE* fp;

	printf(" %d %d", sct, len);

	retval = ismReadMem((void*)&fa, (int)pfa, sizeof(FILEACC));
	if(retval != 0) {
		return -1;
	}
	if(fa.valid != FILEACC_UFE) {
		return -1;
	}
	fp = (FILE*)*(int*)&fa.chain;

	if(!ptr || (len > 4096)) {
		len = 4096;
	}
	fseek(fp, sct * 4096, SEEK_SET);
	len = fread(ufe.sctbuf, 1, len, fp);

	if(ptr) {
		retval = ismWriteMem(ufe.sctbuf, (int)ptr, len);
		if(retval != 0) {
			return -1;
		}
	} else {
		fa.aptr = (void*)(ufe_addr + 24/*sctbuf*/);
		retval = ismWriteMem((void*)ufe.sctbuf, (int)fa.aptr, len);
		if(retval != 0) {
			return -1;
		}
		retval = ismWriteMem((void*)&fa, (int)pfa, sizeof(FILEACC));
		if(retval != 0) {
			return -1;
		}
	}

	return len;
}

int
pceFileWriteSct(FILEACC* pfa, const void* ptr, int sct, int len)
{
//{{2018/05/24ǉ:pceFileWriteSct()̑ΉA܂ł͖̂A܂B
	int retval;
	FILEACC fa;
	FILE* fp;
	//
	unsigned char buf[4096];

	printf(" %d %d", sct, len);

	retval = ismReadMem((void*)&fa, (int)pfa, sizeof(FILEACC));
	if(retval != 0) {
		return -1;
	}
	if(fa.valid != FILEACC_UFE) {
		return -1;
	}
	fp = (FILE*)*(int*)&fa.chain;

	if(len > 4096) {	//ɂ͍ŏIZN^Ȃ4096ɐ؂l߂KvL邪Ap4096ł薳낤BȏɂẮAC:\usr\PIECE\sysdev\pcekn\file.c(332)uif ( len > len2 ) len = len2;vQƂB
		len = 4096;
	}

	retval = ismReadMem(buf, (int)ptr, len);
	if(retval != 0) {
		return -1;
	}

	fseek(fp, sct * 4096, SEEK_SET);
	len = fwrite(buf, 1, len, fp);

	return len;
//}}2018/05/24ǉ:pceFileWriteSct()̑ΉA܂ł͖̂A܂B
}

int
pceFileClose(FILEACC* pfa)
{
	int retval;
	FILEACC fa;
	FILE* fp;

	retval = ismReadMem((void*)&fa, (int)pfa, sizeof(FILEACC));
	if(retval != 0) {
		return -1;
	}
	if(fa.valid != FILEACC_UFE) {
		return -1;
	}
	fp = (FILE*)*(int*)&fa.chain;

	fclose(fp);

	return 0;
}

int
pceFileCreate(const char* fname, unsigned long size)
{
//{{2018/05/24ǉ:pceFileCreate()̑ΉA܂ł͖̂A܂B
	int retval;
	char path[MAXFILENAME + 1];
	//
	int fd = -1;

	retval = ismReadMem(path, (int)fname, MAXFILENAME);
	if(retval != 0) {
		goto L_ERR;
	}
	path[MAXFILENAME] = '\0';

	printf(" %s(%d)", path, size);

	fd = _open(path, (_O_BINARY|_O_CREAT|_O_WRONLY/*̃t@Cɑ΂_chsize()s邽߂ɂ_O_WRONLY,,_O_RDWR̎w肪Kv*/), (_S_IREAD|_S_IWRITE)/*_O_CREATw肵͑O̎wKv*/);	//t@Cɑ݂ꍇ_O_CREAT͖ӖƂȂej0oCgɐ؂l߂鎖͂܂B܂Afopen()ŊJĂĂLᔽɂ͂Ȃ炸_open()ŊJăTCYύXo悤ł()B
	if(fd == -1) {
		goto L_ERR;
	}
	if(_chsize(fd, size)) {
		goto L_ERR;
	}
	_close(fd);

	return 0;
L_ERR:
	if(fd != -1) {
		_close(fd);
	}
	return -1;
//}}2018/05/24ǉ:pceFileCreate()̑ΉA܂ł͖̂A܂B
}

//{{2018/05/24ǉ:pceFileDelete()ɂΉ܂B
int
pceFileDelete(const char* fname)
{
	int retval;
	char path[MAXFILENAME + 1];

	retval = ismReadMem(path, (int)fname, MAXFILENAME);
	if(retval != 0) {
		goto L_ERR;
	}
	path[MAXFILENAME] = '\0';

	printf(" %s", path);

	if(remove(path)) {
		goto L_ERR;
	}

	return 0;
L_ERR:
	return -1;
}
//}}2018/05/24ǉ:pceFileDelete()ɂΉ܂B
