#ifndef __SSTYPES__
#define __SSTYPES__

#include <stdlib.h>
#include <string>
#include <vector>
#include <math.h>
#include <algorithm>

namespace ss
{

//===============================================================
//Macros 
//===============================================================
#define	SS_DECLARE_ENUM_STRING_DEF(type) \
	SsString	__EnumToString_( type::_enum n );\
	void	__StringToEnum_( SsString n , type::_enum& out);\




//===============================================================
// Declare Type
//===============================================================

//̐ݒ
typedef std::string SsString;



///QW\邽߂̃NXłB
struct SsPoint2
{
public:
	float	x;
	float	y;

public:
	SsPoint2( float _x , float _y )
	{
		x = _x ; y = _y;
	}
	SsPoint2() : x(0) , y(0){}

	static	float	distance_sq(const SsPoint2 & l, const SsPoint2 & r)
	{
		float x = l.x - r.x;
		float y = l.y - r.y;
		float sq = x * x + y * y;
		return sq;		
	}

	static	float	distance(const SsPoint2 & l, const SsPoint2 & r)
	{
		return  sqrt( distance_sq(l, r) );
	}

	SsPoint2 operator +( const SsPoint2& r) const
	{
		return SsPoint2(x + r.x, y + r.y);
	}

	SsPoint2 operator -( const SsPoint2& r) const
	{
		return SsPoint2(x - r.x, y - r.y);
	}

	SsPoint2 operator *( float r) const
	{
		return SsPoint2(x * r, y * r);
	}

	SsPoint2 operator /( float r) const
	{
		return SsPoint2(x / r, y / r);
	}

	float	length_sq() const
	{
		return (x * x) + (y * y);
	}

	float	length() const
	{
#ifdef _WIN32
		float r = length_sq();
		if ( r < 0.0001f && r > -0.0001f ) return 0;

		return (float)std::sqrtf( r );
#else
		return (float)std::sqrt( length_sq() );
#endif
	}

	static void	normalize(const SsPoint2& in, SsPoint2* out)
	{

		float len = in.length();
		float div = 0;

		if ( len == 0 )
		{
			div = 0;
		}else{
			div = (float)1 / in.length();
		}

		out->x = in.x * div;
		out->y = in.y * div;
	}

	void		normalize()
	{
		normalize(*this, this);
	}

	//----------------------------------------------------------------------------
	static	float	dot(const SsPoint2& l, const SsPoint2 r)
	{
		return (l.x * r.x) + (l.y * r.y);
	}
	static	float	cross(const SsPoint2& l, const SsPoint2& r)
	{
		return (l.x * r.y) - (l.y * r.x);
	}

	//----------------------------------------------------------------------------
	/**
		Q̃xNgDȂpx߂
		͂͒PʃxNgłȂĂ͂ȂB
	*/
	//----------------------------------------------------------------------------
	static	float 	get_angle_unit(const SsPoint2& v0, const SsPoint2 v1)
	{
		float ip = dot(v0, v1);
		if (ip > 1.0f) ip = 1.0f;
		if (ip < -1.0f) ip = -1.0f;
		float f = acos(ip);
		return f;		
		
	}
	//----------------------------------------------------------------------------
	/**
		Q̃xNgDȂpx߂
	*/
	//----------------------------------------------------------------------------
	static	float 	get_angle(const SsPoint2& v0, const SsPoint2& v1)
	{
		SsPoint2 uv0(v0), uv1(v1);
		uv0.normalize();
		uv1.normalize();
		return get_angle_unit(uv0, uv1);
	}

	// v0  v1 ւ̍̊pxԂ
	static	float 	get_angle_360_unit(const SsPoint2& v0, const SsPoint2 v1)
	{
		float ang = get_angle_unit(v0, v1);
		float c = cross(v0, v1);

		if (c < 0)
		{
			ang = (3.1415926535897932385f)*2.0f - ang;
		}
		return ang;
	}

	static	float 	get_angle_360(const SsPoint2& v0, const SsPoint2 v1)
	{
		SsPoint2 uv0(v0), uv1(v1);
		uv0.normalize();
		uv1.normalize();
		return get_angle_360_unit(uv0, uv1);
	}

};

///RW\邽߂̃NXłB
struct SsPoint3
{
public:
	float	x;
	float	y;
	float	z;

public:
	SsPoint3( float _x , float _y , float _z)
	{
		x = _x ; y = _y;z = _z;
	}
	SsPoint3() : x(0) , y(0) ,z(0){}
};

typedef SsPoint2 SsVector2;
typedef SsPoint3 SsVector3;
typedef unsigned int u32;
typedef unsigned char u8;




/// `
template <typename T>
class SsTRect
{
public:
	T	x, y, w, h;

	SsTRect(): x(0), y(0), w(0), h(0)  {}
	SsTRect(T ax, T ay, T aw, T ah): x(ax), y(ay), w(aw), h(ah) {}
	SsTRect(const SsTRect& r): x(r.x), y(r.y), w(r.w), h(r.h) {}

	bool	operator ==(const SsTRect& r) const {return x == r.x && y == r.y && w == r.w && h == r.h;}
	bool	operator !=(const SsTRect& r) const {return !(*this == r);}
private:
};


typedef SsTRect<int>	SsIRect;


///J[l`ev[gNXłB
template <typename T>
class SsTColor
{
public:
	T	r, g, b, a;

	SsTColor(): r(0), g(0), b(0), a(0) {}
	SsTColor(T ar, T ag, T ab, T aa): r(ar), g(ag), b(ab), a(aa) {}
	SsTColor(const SsTColor& s): r(s.r), g(s.g), b(s.b), a(s.a) {}

	void	fromARGB(u32 c);
	void	fromBGRA(u32 c);

	u32		toARGB() const;

	bool	operator ==(const SsTColor& rhs) const
	{
		return r == rhs.r
			&& g == rhs.g
			&& b == rhs.b
			&& a == rhs.a;
	}

private:
};


/// rgba 
template<> inline SsTColor<float>::SsTColor(): r(0.5f), g(0.5f), b(0.5f), a(1.f) {}
template<> inline void SsTColor<float>::fromARGB(u32 c)
{
	a = (float)(c >> 24) / 255.f;
	r = (float)((c >> 16) & 0xff) / 255.f;
	g = (float)((c >> 8) & 0xff) / 255.f;
	b = (float)(c & 0xff) / 255.f;
}
template<> inline void SsTColor<float>::fromBGRA(u32 c)
{
	b = (float)(c >> 24) / 255.f;
	g = (float)((c >> 16) & 0xff) / 255.f;
	r = (float)((c >> 8) & 0xff) / 255.f;
	a = (float)(c & 0xff) / 255.f;
}
template<> inline u32 SsTColor<float>::toARGB() const
{
	u32 c = (u8)(a * 255) << 24 | (u8)(r * 255) << 16 | (u8)(g * 255) << 8 | (u8)(b * 255);
	return c;
}




template<> inline SsTColor<u32>::SsTColor(): r(255), g(255), b(255), a(255) {}
template<> inline void SsTColor<u32>::fromARGB(u32 c)
{
	a = (c >> 24);
	r = ((c >> 16) & 0xff);
	g = ((c >> 8) & 0xff);
	b = (c & 0xff);
}
template<> inline void SsTColor<u32>::fromBGRA(u32 c)
{
	b = (c >> 24) ;
	g = ((c >> 16) & 0xff) ;
	r = ((c >> 8) & 0xff) ;
	a = (c & 0xff) ;
}
template<> inline u32 SsTColor<u32>::toARGB() const
{
	u32 c = (u8)(a) << 24 | (u8)(r) << 16 | (u8)(g) << 8 | (u8)(b);
	return c;
}



template<> inline SsTColor<u8>::SsTColor(): r(255), g(255), b(255), a(255) {}
template<> inline void SsTColor<u8>::fromARGB(u32 c)
{
	a = (c >> 24);
	r = ((c >> 16) & 0xff);
	g = ((c >> 8) & 0xff);
	b = (c & 0xff);
}
template<> inline void SsTColor<u8>::fromBGRA(u32 c)
{
	b = (c >> 24) ;
	g = ((c >> 16) & 0xff) ;
	r = ((c >> 8) & 0xff) ;
	a = (c & 0xff) ;
}
template<> inline u32 SsTColor<u8>::toARGB() const
{
	u32 c = (u8)(a) << 24 | (u8)(r) << 16 | (u8)(g) << 8 | (u8)(b);
	return c;
}


///floatł̃J[l`
typedef SsTColor<float> SsFColor;


///unsigned intł̃J[l`
typedef SsTColor<u32> SsColor;


typedef SsTColor<u8> SsU8Color;

struct ToLower {
    char operator()(char c) { return tolower(c); }
};
///^ꂽJ[lɕϊ邽߂̊֐
inline void	ConvertStringToSsColor( const std::string& str , SsColor& out)
{
	char *endptr;
	unsigned long x;

	std::string temp = "0x";
	temp+=str;
	
	transform(temp.begin(), temp.end(), temp.begin(), ToLower());
	x = strtoul(temp.c_str(), &endptr, 16);
	out.fromARGB( x );
}



/// ȐԌvZpp[^
class SsCurve
{
public:
	float	startTime;		///< n_L[̎Ԃ琧_̎Ԃւ̃ItZbglBwɓB
	float	startValue;		///< n_L[̒l	V	Bx	V
	float	endTime;		///< I_L[̎Ԃ琧_̎Ԃւ̃ItZbglBwɓB
	float	endValue;		///< I_L[̒l	V	Bx	V

	float	startKeyTime;	///< [[Np[^] n_L[̎ vẐݎgp
	float	endKeyTime;		///< [[Np[^] I_L[̎ vẐݎgp

	bool	syncStartEnd;	///< [ҏWpp[^]J[uGfB^ł̕ҏWɎn_EI_nh𓯊ēH

	SsCurve() : startTime(0.f), startValue(0.f), endTime(0.f), endValue(0.f), startKeyTime(0.f), endKeyTime(0.f){}
	~SsCurve(){}

};



//---------------------------------------------------------------
/// \[g[h
namespace SsPartsSortMode
{
	enum _enum
	{
		invalid = -1, 
		prio,			///< `揇͗DxŐ䂷BDx\AyWBB
		z,				///< `揇͂yWŐ䂷ByW\ADxBB
		num
	};
};
SS_DECLARE_ENUM_STRING_DEF( SsPartsSortMode );

//---------------------------------------------------------------
/// Animation Part Type
namespace SsPartType
{
	enum _enum
	{
		invalid = -1,
		null,			///< nullB̈SRT̂݁B~`̓蔻͐ݒ\B
		normal,			///< ʏp[cB̈B摜͖ĂB
		text,			///< eLXg(\@j
		instance,		///< CX^XBAjAp[cւ̎QƁBV[ҏW[h̑ւɂȂ
		effect,
		num
	};
};
SS_DECLARE_ENUM_STRING_DEF( SsPartType );


//---------------------------------------------------------------
/// 蔻`
namespace SsBoundsType
{
	enum _enum 
	{
		invalid = -1,
		none,			///< 蔻ƂĎgȂB
		quad,			///< ݂ɕό`lӌ`B_ό`ȂǓKp̂Sp񂾗̈BłdB
		aabb,			///< ]ȂŜ͂ދ`Ō
		circle,			///< ^~̔aŋɂ蔻肷
		circle_smin,	///< ^~̔aŋɂ蔻肷 (XP[x,y̍ŏlƂj
		circle_smax,	///< ^~̔aŋɂ蔻肷 (XP[x,y̍őlƂj
		num
	};
};
SS_DECLARE_ENUM_STRING_DEF( SsBoundsType );


//---------------------------------------------------------------
/// p^Cv
namespace SsInheritType
{
	enum _enum
	{
		invalid = -1,
		parent,			///< ěp@̂܂܈p
		self,			///< gAgr[gʂɎp@g
		num
	};
};
SS_DECLARE_ENUM_STRING_DEF( SsInheritType );

//---------------------------------------------------------------
/// uh^Cv
namespace SsBlendType
{
	enum _enum{
		invalid=-1,
		mix,			///< 0 uhi~bNXj
		mul,			///< 1 Z
		add,			///< 2 Z
		sub,			///< 3 Z
		num
	};
};
SS_DECLARE_ENUM_STRING_DEF( SsBlendType );


///J[uhL[gpĂۂ̃J[Kp͈͂̒`
namespace SsColorBlendTarget
{
	enum _enum{
		invalid = -1,
		whole,	///< PFBŜɂB
		vertex,	///< _P
		num
	};
};
SS_DECLARE_ENUM_STRING_DEF( SsColorBlendTarget );



///ԃ[h̒`
namespace SsInterpolationType
{
	enum _enum 
	{
		invalid = -1,
		none,			///< Ȃ
		linear,			///< `
		hermite,		///< G~[g
		bezier,			///< xWF
		acceleration,	///< x
		deceleration,	///< x
		num,
	};
};
SS_DECLARE_ENUM_STRING_DEF( SsInterpolationType );


/// eNX`bv[h
namespace SsTexWrapMode
{
	enum _enum
	{
		invalid = -1,	/// Ȃ
		clamp,			/// Nv
		repeat,			/// s[g
		mirror,			/// ~[
		num
	};
};

SS_DECLARE_ENUM_STRING_DEF(SsTexWrapMode);

/// eNX`tB^[[h fԕ@
namespace SsTexFilterMode
{
	enum _enum
	{
		invalid = -1,
		nearlest,	///< jAXglCo[
		linear,		///< jAAoCjA
		num
	};
};
SS_DECLARE_ENUM_STRING_DEF(SsTexFilterMode);




/// Agr[g̎
namespace SsAttributeKind
{
	enum _enum
	{
		invalid=-1,	///< lBf[^̕ϊȂ
		cell=0,		///< [CELL]QƃZ
		posx,		///< [POSX]ʒu.X
		posy,		///< [POSY]ʒu.Y
		posz,		///< [POSZ]ʒu.Z
		rotx,		///< [ROTX]].X
		roty,		///< [ROTY]].Y
		rotz,		///< [ROTZ]].Z
		sclx,		///< [SCLX]XP[.X
		scly,		///< [SCLY]XP[.Y
		alpha,		///< [ALPH]sx
		prio,		///< [PRIO]Dx
		fliph,		///< [FLPH]E](Ž_ɂ)
		flipv,		///< [FLPV]㉺](Ž_ɂ)
		hide,		///< [HIDE]\
		color,		///< [VCOL]J[uh
		vertex,		///< [VERT]_ό`
		pivotx,		///< [PVTX]_ItZbg.X
		pivoty,		///< [PVTY]_ItZbg.Y
		anchorx,	///< [ANCX]AJ[|Cg.X
		anchory,	///< [ANCY]AJ[|Cg.Y
		sizex,		///< [SIZX]\TCY.X
		sizey,		///< [SIZY]\TCY.Y
		imgfliph,	///< [IFLH]C[WE](ɃC[W̒_Ƃ)
		imgflipv,	///< [IFLV]C[W㉺](ɃC[W̒_Ƃ)
		uvtx,		///< [UVTX]UVAj.ړ.X
		uvty,		///< [UVTY]UVAj.ړ.Y
		uvrz,		///< [UVRZ]UVAj.]
		uvsx,		///< [UVSX]UVAj.XP[.X
		uvsy,		///< [UVSY]UVAj.XP[.Y
		boundr,		///< [BNDR]蔻p̔a
		user,		///< [USER][U[f[^
		instance,	///< [IPRM]CX^Xp[cp[^
		num,
	};
};


SS_DECLARE_ENUM_STRING_DEF(SsAttributeKind);

namespace SsKeyValueType
{
	enum _enum
	{
		_unkown = -1,
		_bool = 0,
		_float,
		_int,
		_string,
		_cellmap,
		_vertexAnime,
		_colorAnime,
		_userData,
		_instance,
	};
};






///J[uhL[̃J[l
struct SsColorBlendValue
{
	SsColor		rgba;	///J[l
	float		rate;	///f

	SsColorBlendValue(): rate(0){}

};


///_ό`L[̂S_ό`l
struct SsVertexAnime
{
	SsPoint2	offsets[4];	///< e_̈ړItZbgl
	SsPoint2&	getOffsets(int index){ return offsets[index];}
};




class ISSTexture;
class SsCell;



///J[uhgp̃uh^CvƃJ[l
struct SsColorAnime
{
	SsColorBlendTarget::_enum	target;		//uh̓Kp@  PF(S) , _P 
	SsBlendType::_enum			blendType;	//uh (mix@Z@Z@Zj
	SsColorBlendValue			color;		//PFBŜ̏ꍇɎgpJ[l
	SsColorBlendValue			colors[4];	//_Pʂ̏ꍇgpJ[l

	SsColorBlendValue&			getColors(int index){ return colors[index];}
	int							getTargetToInt(){ return (int)target;}
	int							getBlendTypeToInt(){ return (int)blendType;}
	SsColorAnime() : 
			target( SsColorBlendTarget::invalid ) ,
				blendType( SsBlendType::invalid ){}

};


//GtFNg֘A̒`
//GtFNg̃m[h^Cv
namespace SsEffectNodeType
{
	enum _enum{
		invalid=-1,
		root,
		emmiter,
		particle,
		num
	};
};
SS_DECLARE_ENUM_STRING_DEF( SsEffectNodeType );



//GtFNg֘A̒`
//GtFNg̃uh^Cv
namespace SsRenderBlendType
{
	enum _enum{
		invalid=-1,
		Mix,
		Add,
		num
	};
};
SS_DECLARE_ENUM_STRING_DEF( SsRenderBlendType );





//QƃZl
struct SsRefCell
{
	int			mapid;
	std::string	name;

	
};
class SsUserDataAnime
{
public:
	bool			useInteger;	///<gpĂ邩
	bool			usePoint;	///<Wf[^gpĂ邩
	bool			useRect;	///<`f[^gpĂ邩
	bool			useString;	///<f[^gpĂ邩 

	int				integer;	///< 
	SsPoint2		point;		///< W
	SsIRect			rect;		///< `
	SsString		string;		///< 

	SsUserDataAnime() : 
		useInteger(false),
		usePoint(false),
		useRect(false),
		useString(false){}
};

class SsInstanceAttr
{
public:
    bool   		infinity;		///[vtO
    bool   		reverse;		///tĐtO
    bool   		pingpong;		///ĐtO
	bool		independent;	///ƗtO
    int			loopNum;		///[v񐔁@[vtO=true̎ɂ͖
    SsString	startLabel;		///ĐJnʒu x
    int			startOffset;	///ĐJnʒu x̂̃ItZbg
    SsString	endLabel;		///ĐIʒu x
    int			endOffset;		///ĐIʒu x̂̃ItZbg
    float       speed;			///ĐXs[h
    int			startFrame;		///xʒuƃItZbgʒuۂ̃t[
    int			endFrame;		///xʒuƃItZbgʒuۂ̃t[


    //e| <-GfB^pvZl̉\̂ŌŐ
    int         curKeyframe; //̒lL[t[l (vZlj
    float		liveFrame;	//ĐԂ̗ݐ

	SsInstanceAttr():
    	infinity( false ),
    	reverse( false ),
    	pingpong( false ),
    	independent( false ),
		loopNum( 1 ),
     	startLabel("_start"),
     	startOffset(0),
     	endLabel("_end"),
     	endOffset(0),
		curKeyframe( 0 ),
		speed(1.0f),
		startFrame(0),
		endFrame(0),
		liveFrame(0.0f)
   {}

};
};

#endif
