/*	
 *	sprite.cpp
 *
 *	pcemon - P/ECE monitor
 *	Copyright (C) 2002 Naoyuki Sawa
 *
 *	* Sun Jul 14 23:10:00 JST 2002 Naoyuki Sawa
 *	- 쐬JnB
 *	* Sat Aug 10 09:03:00 JST 2002 Naoyuki Sawa
 *	- fram_find()cursor_x,yoOCB
 */
#include "app.h"

/****************************************************************************
 *	萔E^
 ****************************************************************************/

/* PIECE KERNEL : Ver 1.18 - piece.h  */
typedef struct tagSYSTEMINFO {
	unsigned short size;
	unsigned short hard_ver;
	unsigned short bios_ver;
	unsigned short bios_date;
	unsigned long sys_clock;
	unsigned short vdde_voltage;
	unsigned short resv1;
	unsigned long sram_top;
	unsigned long sram_end;
	unsigned long pffs_top;
	unsigned long pffs_end;
} SYSTEMINFO;

/* PIECE KERNEL : Ver 1.18 - piece.h  */
typedef struct _pceAPPHEAD {
	unsigned long signature;	/* 'pCeA'ŒBsJnAppInit()0NA܂ */
	unsigned short sysver;		/* VXeo[Wi[AڍׂȒl͉łȂj       */
	unsigned short resv1;		/* ݂̃X^[gAbvCuł0ŒiłȂj    */
	unsigned long initialize;	/* ֐AhXi[K{An[t[hACgj */
	unsigned long periodic_proc;	/* ֐AhXi[K{An[t[hACgj */
	unsigned long pre_terminate;	/* I֐AhXi[K{An[t[hACgj   */
	unsigned long notify_proc;	/* ʒm֐AhXi[K{An[t[hACgj   */
	unsigned long stack_size;	/* ݂̃X^[gAbvCuł0ŒiłȂj    */
	unsigned long bss_end;		/* BSS̏IAhXpceHeapAlloc()pq[vJnAhX      */
					/*i[BBIOS1.18̓[hACgz肵Ă邪A    */
					/* J-alignIvVŕύX\B肵ȂSj   */
} pceAPPHEAD;
#define APPSTARTPOS1	0x100000 /* ʏ̃AvP[Ṽwb_ʒu   */
#define APPSTARTPOS2	0x138000 /* ̂̃X^[gAbvVF̃wb_ʒu */

/* PIECE sprite library : Ver 1.00 - pclsprite.h  */
#define FR_CX		(16)				/* Ŝ̃t[obt@   1v[̃CoCg */
#define FR_Y		(88)				/* Ŝ̃t[obt@   C                        */
#define BG_CX		(32)				/* wiLN^obt@   LN^                  */
#define BG_CY		(32)				/* wiLN^obt@   cLN^                  */
#define BG_CBUFF_SIZE	((BG_CX * BG_CY) * 2)		/* wiLN^obt@   oCg                        */
#define BG_FBUFF_SIZE	((BG_CX * BG_CY) * 8 * 3)	/* wit[obt@     oCg                        */
#define FRAME_SIZE	(FR_CX * FR_Y * 2)		/* Ŝ̃t[obt@   oCg                        */
#define BG_LINE_SIZE	(FR_Y * 2)			/* CXN[WX^ oCg                        */
#define SPRITE_WORK_MIN	(BG_CBUFF_SIZE * 4 + BG_FBUFF_SIZE * 2 + FRAME_SIZE + BG_LINE_SIZE * 2)	/* XvCg[N oCg (XvCgWX^͊܂܂Ȃ) */
/* PIECE sprite library : Ver 1.00 - pclsprite.c  */
/* readysprmax͏lݒ肳Ă̂ŁAdataZNVɔzu܂BȊObssZNVɔzu܂ */
typedef struct _SPRITEINFO {
//	short ready;			/* Cugp\tO		ς݂Ȃ-1ŒBO0łA\̂ĂӖȂ̂ōl܂B           */
	unsigned long pclsprite_pat;	/* \[Xp^[			SRAM̃[hEAhXBRAMtbVɒڃ\[Xp^[uP[X͍l܂B     */
	int disp;			/* \Rg[WX^		22rbg͖gpłA}XNĂȂ̂0Ƃ͌܂B̒l̓`FbN܂B           */
	unsigned long fram;		/* Ŝ̃t[obt@		vZ11: line1xy + BG_LINE_SIZE                                                                        */
	unsigned long sreg;		/* XvCgWX^			       4: bg1a + BG_CBUFF_SIZE / 4       int*Ȃ̂"/4"Ă܂AlvZ͏ȂĂB */
//	int sprmax;			/* XvCg			       1: (ssize - SPRITE_WORK_MIN) / 4    ȉlłB                                               */
	unsigned long bg0f;		/* @wi t[obt@		       7: bg1b + BG_CBUFF_SIZE / 4                                                                      */
	unsigned long bg0a;		/* @wi LN^obt@		       2: sbuff                                                                                         */
	unsigned long bg0b;		/* @wi LN^obt@(p)	       5: sreg + sprmax                  int*Ȃ̂"+sprmax"łAlvZ*4KvłB    */
	unsigned long bg1f;		/* Owi t[obt@		       8: bg0f + BG_FBUFF_SIZE / 4                                                                      */
	unsigned long bg1a;		/* Owi LN^obt@		       3: bg0a + BG_CBUFF_SIZE / 4                                                                      */
	unsigned long bg1b;		/* Owi LN^obt@(p)	       6: bg0b + BG_CBUFF_SIZE / 4                                                                      */
	unsigned long line0xy;		/* CXN[WX^		       9: bg1f + BG_FBUFF_SIZE / 4                                                                      */
	unsigned long line1xy;		/* 					      10: line0xy + BG_LINE_SIZE                                                                        */
	unsigned char bg0x;		/* BGXN[WX^ (0`255) */
	unsigned char bg0y;		/*                               */
	unsigned char bg1x;		/*                               */
	unsigned char bg1y;		/*                               */
	unsigned char cursor_x;		/* J[\ʒu       ( 0`15) */
	unsigned char cursor_y;		/* J[\ʒuc       ( 0`10) */
	unsigned char cur_lx;		/* J[\ʒuE   ( 0Œ) */
	unsigned char cur_rx;		/* J[\ʒuEE+1 (16Œ) */
	unsigned char cur_uy;		/* J[\ʒuE   ( 0Œ) */
	unsigned char cur_dy;		/* J[\ʒuE+1 (11Œ) */
} SPRITEINFO;
#define CUR_LX		 0		/* cur_lx̌ŒlAcursor_x̍ŏl   */
#define CUR_RX		16		/* cur_rx̌ŒlAcursor_x̍ől+1 */
#define CUR_UY		 0		/* cur_uy̌ŒlAcursor_y̍ŏl   */
#define CUR_DY		11		/* cur_dy̌ŒlAcursor_y̍ől+1 */

/****************************************************************************
 *	֐錾
 ****************************************************************************/

static unsigned char* sram_read(SYSTEMINFO* sysinfo);
static unsigned long apphead_find(SYSTEMINFO* sysinfo, unsigned char* sram);

/****************************************************************************
 *	fram_find
 ****************************************************************************/

unsigned long
fram_find()
{
	int retval, sprmax;
	unsigned char* sram;
	unsigned long apphead_addr, sprinfo_addr, fram;
	SYSTEMINFO sysinfo;
	SPRITEINFO* sprinfo;
	pceAPPHEAD* apphead;

	/* P/ECEɐڑ܂B */
	retval = ismInitEx(0, 0);
	if(retval != 0) {
		fprintf(stderr, "P/ECEɐڑł܂B\n");
		ismExit(); /* sĂؒfKv */
		return 0;
	}

	/* VXe擾܂B */
	retval = ismGetVersion(&sysinfo, 1);
	if(retval == PIECE_INVALID_VERSION) {
		fprintf(stderr, "VXe񂪎擾ł܂B\n");
		ismExit(); /* ؒf */
		return 0;
	}

	/* SRAMŜǂݍ񂾃擾܂B */
	sram = sram_read(&sysinfo);
	if(sram == NULL) {
		ismExit(); /* ؒf */
		return 0;
	}

	/* AvP[Vwb_T܂B */
	apphead_addr = apphead_find(&sysinfo, sram);
	if(apphead_addr == 0) {
		free(sram); /* SRAMJ */
		ismExit(); /* ؒf */
		return 0;
	}
	apphead = (pceAPPHEAD*)&sram[apphead_addr - sysinfo.sram_top];

	/* AvP[Vwb_̒ォBSS̈I[(-\̃TCY)܂ő... */
	for(sprinfo_addr = apphead_addr + sizeof(pceAPPHEAD);
	    sprinfo_addr < apphead->bss_end - sizeof(SPRITEINFO);
	    sprinfo_addr += 4) {
		sprinfo = (SPRITEINFO*)&sram[sprinfo_addr - sysinfo.sram_top];

		/* ȒPȌ... */

		/* e[h|C^SRAM̃[hEAhXwĂ邩H
		 * line0xy,line1xy̓oCg|C^łK[hEɔzûŁAlɌ܂B
		 */
		if(sprinfo->pclsprite_pat & 3 || sprinfo->pclsprite_pat < sysinfo.sram_top || sysinfo.sram_end <= sprinfo->pclsprite_pat) continue;
		if(sprinfo->fram          & 3 || sprinfo->fram          < sysinfo.sram_top || sysinfo.sram_end <= sprinfo->fram         ) continue;
		if(sprinfo->sreg          & 3 || sprinfo->sreg          < sysinfo.sram_top || sysinfo.sram_end <= sprinfo->sreg         ) continue;
		if(sprinfo->bg0f          & 3 || sprinfo->bg0f          < sysinfo.sram_top || sysinfo.sram_end <= sprinfo->bg0f         ) continue;
		if(sprinfo->bg0a          & 3 || sprinfo->bg0a          < sysinfo.sram_top || sysinfo.sram_end <= sprinfo->bg0a         ) continue;
		if(sprinfo->bg0b          & 3 || sprinfo->bg0b          < sysinfo.sram_top || sysinfo.sram_end <= sprinfo->bg0b         ) continue;
		if(sprinfo->bg1f          & 3 || sprinfo->bg1f          < sysinfo.sram_top || sysinfo.sram_end <= sprinfo->bg1f         ) continue;
		if(sprinfo->bg1a          & 3 || sprinfo->bg1a          < sysinfo.sram_top || sysinfo.sram_end <= sprinfo->bg1a         ) continue;
		if(sprinfo->bg1b          & 3 || sprinfo->bg1b          < sysinfo.sram_top || sysinfo.sram_end <= sprinfo->bg1b         ) continue;
		if(sprinfo->line0xy       & 3 || sprinfo->line0xy       < sysinfo.sram_top || sysinfo.sram_end <= sprinfo->line0xy      ) continue;
		if(sprinfo->line1xy       & 3 || sprinfo->line1xy       < sysinfo.sram_top || sysinfo.sram_end <= sprinfo->line1xy      ) continue;

		/* J[\ʒu͈̔͂ƌŒlB
		 * 2002/08/10C: cursor_x,ỷʉE[E[̔ɂ
		 * * ҂ʉE[ŕ񂪏I悤ɕ`悷ƁAcursor_x=cur_rxɂȂ邱Ƃ܂B
		 *   Ⴆ΁Alocate(9, 0); printstr("HISCORE"); ƂƁAcursor_x=16ɂȂĂ܂B
		 *   ̏ɈvƂAXvCǧoɎsĂ̂ŁA͂u<=vłȂu<vɏC܂B
		 * * cursor_ŷ͂́̕u<=v̂܂܂łƎv̂łAƂȂ|̂łu<vɕύX邱Ƃɂ܂B
		 */
		if(sprinfo->cursor_x < sprinfo->cur_lx || sprinfo->cur_rx < /*u<=vł̓_I*/ sprinfo->cursor_x) continue;
		if(sprinfo->cursor_y < sprinfo->cur_uy || sprinfo->cur_dy < /*u<=vłnjH*/ sprinfo->cursor_y) continue;
		if(sprinfo->cur_lx != CUR_LX) continue;
		if(sprinfo->cur_rx != CUR_RX) continue;
		if(sprinfo->cur_uy != CUR_UY) continue;
		if(sprinfo->cur_dy != CUR_DY) continue;

		/* ȒPȌłĂӂɌ܂܂AÔߏڍׂȌs܂... */

		/* sreg[sprmax],bg0b ̕тȂ̂ŁAsregbg0b̍sprmax߂܂B */
		sprmax = (sprinfo->bg0b - sprinfo->sreg) / 4;
		if(sprmax < 0) continue;

		/* eobt@̈ʒu֌WmF܂B */
		if(sprinfo->bg1a    != sprinfo->bg0a    + BG_CBUFF_SIZE) continue;
		if(sprinfo->sreg    != sprinfo->bg1a    + BG_CBUFF_SIZE) continue;
		if(sprinfo->bg0b    != sprinfo->sreg    + sprmax * 4   ) continue;
		if(sprinfo->bg1b    != sprinfo->bg0b    + BG_CBUFF_SIZE) continue;
		if(sprinfo->bg0f    != sprinfo->bg1b    + BG_CBUFF_SIZE) continue;
		if(sprinfo->bg1f    != sprinfo->bg0f    + BG_FBUFF_SIZE) continue;
		if(sprinfo->line0xy != sprinfo->bg1f    + BG_FBUFF_SIZE) continue;
		if(sprinfo->line1xy != sprinfo->line0xy + BG_LINE_SIZE ) continue;
		if(sprinfo->fram    != sprinfo->line1xy + BG_LINE_SIZE ) continue;

		/* ׂĂ̌ɃpX̂ŁAʂi[A[v𔲂܂B */
		fram = sprinfo->fram;
		break;
	}
	if(sprinfo_addr >= apphead->bss_end - sizeof(SPRITEINFO)) {
		fprintf(stderr, "XvCg񂪌܂B\n");
		free(sram); /* SRAMJ */
		ismExit(); /* ؒf */
		return 0;
	}

	/* SRAMŜǂݍ񂾃J܂B */
	free(sram);

	/* P/ECEؒf܂B */
	ismExit();

	return fram;
}

/****************************************************************************
 *	ismAppPause
 ****************************************************************************/

int
ismAppPause(int pausef)
{
	unsigned char tmp[2];
	tmp[0] = 16;
	tmp[1] = (unsigned char)pausef;
	return ismCmdW(tmp, 2, 0, 0);
}

/****************************************************************************
 *	ismLCDGetInfo
 ****************************************************************************/

int
ismLCDGetInfo(int* pstat, unsigned long* pbuff)
{
	int retval;
	unsigned char tmp[12];
	tmp[0] = 17;
	retval = ismCmdR(tmp, 1, tmp, 12);
	if(retval == 0) {
		if(pstat != NULL) *pstat = tmp[0];
		if(pbuff != NULL) *pbuff = *(unsigned long*)(tmp + 8);
	}
	return retval;
}

/****************************************************************************
 *	sram_read
 ****************************************************************************/

static unsigned char*
sram_read(SYSTEMINFO* sysinfo)
{
	int retval, sram_len, ofs, len;
	unsigned char* sram;

	/* SRAMŜǂݍރmۂ܂B */
	sram_len = sysinfo->sram_end - sysinfo->sram_top;
	sram = (unsigned char*)malloc(sram_len);
	if(sram == NULL) {
		fprintf(stderr, "słB\n");
		return NULL;
	}

	/* ǂݍݒɓeςȂ悤A|[Y܂B */
	retval = ismAppPause(1);
	if(retval != 0) {
		fprintf(stderr, "AvP[V܂B\n");
		free(sram); /* J */
		return NULL;
	}

	/* SRAMŜǂݍ݂܂B
	 * x̎MTCY64KB肩瓮sɂȂXA
	 *   P/ECEnOAbv邱Ƃ̂ŁAM邱Ƃɂ܂B
	 *   oN]̈STCY4KBƕƂ̂ŁA4KBɂ܂B
	 */
	ofs = 0;
	while(ofs < sram_len) {
		len = sram_len - ofs;
		if(len > 0x1000) len = 0x1000; /* 4KB */
		retval = ismReadMem(sram + ofs, sysinfo->sram_top + ofs, len);
		if(retval != 0) {
			fprintf(stderr, "SRAM̓ǂݍ݂Ɏs܂B\n");
			ismAppPause(0); /* |[Y */
			free(sram); /* J */
			return NULL;
		}
		ofs += len;
	}

	/* |[Y܂B */
	ismAppPause(0);

	return sram;
}

/****************************************************************************
 *	apphead_find
 ****************************************************************************/

static unsigned long
apphead_find(SYSTEMINFO* sysinfo, unsigned char* sram)
{
	int i;
	unsigned long addrs[] = { APPSTARTPOS1, APPSTARTPOS2 };
	unsigned long addr;
	pceAPPHEAD* apphead;

	for(i = 0; i < sizeof addrs / sizeof *addrs; i++) {
		addr = addrs[i];
		if(addr < sysinfo->sram_top || sysinfo->sram_end < addr + sizeof(pceAPPHEAD)) continue; /* wb_SRAM͂ݏoĂ */
		apphead = (pceAPPHEAD*)&sram[addr - sysinfo->sram_top];

		if(apphead->signature != 0) continue; /* VOl`NAĂȂ */
		if(apphead->sysver == 0) continue; /* VXeo[Wݒ肳ĂȂ */
		if(apphead->bss_end < sysinfo->sram_top || sysinfo->sram_end < apphead->bss_end) continue; /* BSSIAhXSRAMO */

		/* eGg|CǵA߂̂PoCgڂwĂ̂ŁAn[t[hACgĂ͂B
		 * ܂Asrft@C̃ZNVzúA{ pceAPPHEAD`codeZNV`dataZNV`bssZNV`bss_end } Ȃ̂ŁA
		 * eGg|CǵAȂƂApceAPPHEAD̒ォbss_end̊Ԃɂ͂łB
		 * ȏA̏Al̃Gg|Cgɑ΂Č܂B
		 */
		if(apphead->initialize    & 1 || apphead->initialize    < addr + sizeof(pceAPPHEAD) || apphead->bss_end <= apphead->initialize   ) continue;
		if(apphead->periodic_proc & 1 || apphead->periodic_proc < addr + sizeof(pceAPPHEAD) || apphead->bss_end <= apphead->periodic_proc) continue;
		if(apphead->pre_terminate & 1 || apphead->pre_terminate < addr + sizeof(pceAPPHEAD) || apphead->bss_end <= apphead->pre_terminate) continue;
		if(apphead->notify_proc   & 1 || apphead->notify_proc   < addr + sizeof(pceAPPHEAD) || apphead->bss_end <= apphead->notify_proc  ) continue;

		/* APPSTARTPOS1LȂAAPPSTARTPOS2ׂ͒܂Bʏ̃AvP[V́AAPPSTARTPOS1Ńqbg͂łB
		 * APPSTARTPOS2gĂ̂͂̃X^[gAbvVFŁAmalloc()gĂ܂B
		 * ʏ̃AvP[VAPPSTARTPOS2𒲂ׂĂAԈăS~Ƀqbg邾Ǝv܂B
		 */
		return addr;
	}

	fprintf(stderr, "AvP[Vwb_܂B\n");
	return 0;
}
