/*	
 *	main.cpp
 *
 *	pcemon - P/ECE monitor
 *	Copyright (C) 2002-2018 Naoyuki Sawa
 *
 *	* Mon Mar 25 07:00:00 JST 2002 Naoyuki Sawa
 *	- 쐬JnB
 *	* Wed Jul 10 21:01:00 JST 2002 Naoyuki Sawa
 *	- WM_MOVEł̈ʒuۑŁAŏʃrbg[gĂ̂𕄍gɏCB
 *	  }CiXWŏIƂɁAE[ɕAĂ܂ۂ܂B
 *	- ʊOւ̈ړ֎~IvVǉB
 *	* Mon Jul 15 05:07:00 JST 2002 Naoyuki Sawa
 *	- WM_MOVEł̈ʒuۑŁAEChEʒułȂNCAg̈̈ʒuۑĂ܂Ă̂CB
 *	- XvCgt[obt@̎T@\ǉB
 *	- Lv`̃|[Y҂EFCgȂALv`ׂጸB
 *	- [hؑցEXP[ؑցEĨV[gJbgL[ǉB
 *	* Fri Aug  9 12:30:00 JST 2002 Naoyuki Sawa
 *	- NXvCg[hDIvVǉ܂B
 *	* Fri Aug 15 18:30:00 JST 2002 Naoyuki Sawa
 *	- NXvCg[hD̋ύXAXvCgɖ̕ύX܂B
 *	  EChEANeBuxɃXvCgA
 *	  ΃XvCg[hAȂ΃OtBbN[hɐ؂ւ܂B
 *	* Fri Nov 15 12:30:00 JST 2002 Naoyuki Sawa
 *	- cʃ[hǉ܂B
 *	* Sun Jun 6 20:36:00 JST 2004 Naoyuki Sawa
 *	- 16K[hǉ܂B
 *	* Sat Jul 14 23:59:59 JST 2018 Naoyuki Sawa
 *	- 񓯊Lv`ɁAzVRAMAhX擾ĂȂoOC܂B
 *	- 񓯊Lv`łȂꍇɁAŋ߂̍PCƁAP/ECEɕׂ|߂C܂B
 */
#include "app.h"

/****************************************************************************
 *	萔
 ****************************************************************************/

#define EDGESNAP_DISTANCE	8	/* GbWXibv */

/****************************************************************************
 *	O[oϐ
 ****************************************************************************/

char ini_path[_MAX_PATH];

HINSTANCE g_hinst;
BITMAPINFO* g_bmi_active;
BITMAPINFO* g_bmi_active16;
BITMAPINFO* g_bmi_inactive;
BITMAPINFO* g_bmi_inactive16;
HWND g_hwnd;
NOTIFYICONDATA g_nid;

int g_interval = INTERVAL_MAX;
int g_always = FALSE;
int g_async = FALSE;
int g_clip = FALSE;
int g_scale = SCALE_MIN;
int g_x_pos = 0;
int g_y_pos = 0;
int g_sprite = 0;
int g_vscreen = 0;
int g_xcolor = 0;

unsigned long fram_addr;

/****************************************************************************
 *	WinMain
 ****************************************************************************/

int PASCAL
WinMain(HINSTANCE hInst, HINSTANCE hPrevInst, LPSTR lpCmdLine, int nCmdShow)
{
	int retval, i;
	char drive[_MAX_DRIVE];
	char dir[_MAX_DIR];
	char fname[_MAX_FNAME];
	char ext[_MAX_EXT];
	BITMAPINFOHEADER* bi;
	RGBQUAD* rgb;
	WNDCLASS wc;
	MSG msg;
	char buf[100];

	/* CX^Xnhۑ܂B */
	g_hinst = hInst;

	/* dN`FbNB */
	g_hwnd = FindWindow(NULL, APPTITLE);
	if(g_hwnd != NULL) {
		/* ŏĂA܂B */
		if(!IsWindowVisible(g_hwnd)) {
			PostMessage(g_hwnd, WM_NOTIFY_ICON, 0, WM_LBUTTONDBLCLK);
		}
		return 0; /* ̃CX^X͏IB */
	}

	/* INIt@C쐬܂B */
	GetModuleFileName(NULL, ini_path, sizeof ini_path);
	_splitpath(ini_path, drive, dir, fname, ext);
	_makepath(ini_path, drive, dir, fname, ".ini");

	/* INIt@Cǂ݂܂B */
	g_interval = GetPrivateProfileInt(SEC_DEFAULT, KEY_INTERVAL, g_interval, ini_path);
	if(g_interval < INTERVAL_MIN) g_interval = INTERVAL_MIN;
	if(g_interval > INTERVAL_MAX) g_interval = INTERVAL_MAX;
	g_always = GetPrivateProfileInt(SEC_DEFAULT, KEY_ALWAYS, g_always, ini_path);
	g_always = g_always != 0;
	g_async = GetPrivateProfileInt(SEC_DEFAULT, KEY_ASYNC, g_async, ini_path);
	g_async = g_async != 0;
	g_clip = GetPrivateProfileInt(SEC_DEFAULT, KEY_CLIP, g_clip, ini_path);
	g_clip = g_clip != 0;
	g_scale = GetPrivateProfileInt(SEC_DEFAULT, KEY_SCALE, g_scale, ini_path);
	if(g_scale < SCALE_MIN) g_scale = SCALE_MIN;
	if(g_scale > SCALE_MAX) g_scale = SCALE_MAX;
	g_x_pos = GetPrivateProfileInt(SEC_DEFAULT, KEY_X_POS, g_x_pos, ini_path);
	g_y_pos = GetPrivateProfileInt(SEC_DEFAULT, KEY_Y_POS, g_y_pos, ini_path);
	g_sprite = GetPrivateProfileInt(SEC_DEFAULT, KEY_SPRITE, g_sprite, ini_path);
	g_vscreen = GetPrivateProfileInt(SEC_DEFAULT, KEY_VSCREEN, g_vscreen, ini_path);
	g_xcolor = GetPrivateProfileInt(SEC_DEFAULT, KEY_XCOLOR, g_xcolor, ini_path);

	/* ʓ]pBITMAPINFO\̂pӂĂ܂B */
	/* ANeBup(4K) */
	g_bmi_active = (BITMAPINFO*)calloc(sizeof(BITMAPINFOHEADER) + sizeof(RGBQUAD) * 256, 1);
	if(g_bmi_active == NULL) {
		MessageBox(NULL, "calloc() failed.", APPTITLE, MB_ICONSTOP | MB_OK);
		exit(1);
	}
	bi = &g_bmi_active->bmiHeader;
	rgb = &g_bmi_active->bmiColors[0];
	bi->biSize = sizeof(BITMAPINFOHEADER);
	bi->biWidth = DISP_X;                      /* ]OɍĐݒ肵܂ */
	bi->biHeight = -DISP_Y; /* gbv_E */ /* ]OɍĐݒ肵܂ */
	bi->biPlanes = 1;
	bi->biBitCount = 8;
	for(i = 0; i < 256; i++) {
		if(i < 4) {
			rgb[i].rgbRed   =
			rgb[i].rgbGreen =
			rgb[i].rgbBlue  = 255 - 85 * i;
		} else {
			rgb[i].rgbRed   = 255;
			rgb[i].rgbGreen =   0;
			rgb[i].rgbBlue  = 255;
		}
	}
	/* ANeBup(16K) */
	g_bmi_active16 = (BITMAPINFO*)calloc(sizeof(BITMAPINFOHEADER) + sizeof(RGBQUAD) * 256, 1);
	if(g_bmi_active16 == NULL) {
		MessageBox(NULL, "calloc() failed.", APPTITLE, MB_ICONSTOP | MB_OK);
		exit(1);
	}
	bi = &g_bmi_active16->bmiHeader;
	rgb = &g_bmi_active16->bmiColors[0];
	bi->biSize = sizeof(BITMAPINFOHEADER);
	bi->biWidth = DISP_X;                      /* ]OɍĐݒ肵܂ */
	bi->biHeight = -DISP_Y; /* gbv_E */ /* ]OɍĐݒ肵܂ */
	bi->biPlanes = 1;
	bi->biBitCount = 8;
	for(i = 0; i < 256; i++) {
		if(i < 16) {
			rgb[i].rgbRed   =
			rgb[i].rgbGreen =
			rgb[i].rgbBlue  = 255 - 17 * i;
		} else {
			rgb[i].rgbRed   = 255;
			rgb[i].rgbGreen =   0;
			rgb[i].rgbBlue  = 255;
		}
	}
	/* ANeBup(4K) */
	g_bmi_inactive = (BITMAPINFO*)calloc(sizeof(BITMAPINFOHEADER) + sizeof(RGBQUAD) * 256, 1);
	if(g_bmi_inactive == NULL) {
		MessageBox(NULL, "calloc() failed.", APPTITLE, MB_ICONSTOP | MB_OK);
		exit(1);
	}
	bi = &g_bmi_inactive->bmiHeader;
	rgb = &g_bmi_inactive->bmiColors[0];
	bi->biSize = sizeof(BITMAPINFOHEADER);
	bi->biWidth = DISP_X;                      /* ]OɍĐݒ肵܂ */
	bi->biHeight = -DISP_Y; /* gbv_E */ /* ]OɍĐݒ肵܂ */
	bi->biPlanes = 1;
	bi->biBitCount = 8;
	for(i = 0; i < 256; i++) {
		if(i < 4) {
			rgb[i].rgbRed   =
			rgb[i].rgbGreen =
			rgb[i].rgbBlue  = (int)((255 - 85 * i) * 0.75);
		} else {
			rgb[i].rgbRed   = (int)(255 * 0.75);
			rgb[i].rgbGreen = (int)(  0 * 0.75);
			rgb[i].rgbBlue  = (int)(255 * 0.75);
		}
	}
	/* ANeBup(16K) */
	g_bmi_inactive16 = (BITMAPINFO*)calloc(sizeof(BITMAPINFOHEADER) + sizeof(RGBQUAD) * 256, 1);
	if(g_bmi_inactive16 == NULL) {
		MessageBox(NULL, "calloc() failed.", APPTITLE, MB_ICONSTOP | MB_OK);
		exit(1);
	}
	bi = &g_bmi_inactive16->bmiHeader;
	rgb = &g_bmi_inactive16->bmiColors[0];
	bi->biSize = sizeof(BITMAPINFOHEADER);
	bi->biWidth = DISP_X;                      /* ]OɍĐݒ肵܂ */
	bi->biHeight = -DISP_Y; /* gbv_E */ /* ]OɍĐݒ肵܂ */
	bi->biPlanes = 1;
	bi->biBitCount = 8;
	for(i = 0; i < 256; i++) {
		if(i < 16) {
			rgb[i].rgbRed   =
			rgb[i].rgbGreen =
			rgb[i].rgbBlue  = (int)((255 - 17 * i) * 0.75);
		} else {
			rgb[i].rgbRed   = (int)(255 * 0.75);
			rgb[i].rgbGreen = (int)(  0 * 0.75);
			rgb[i].rgbBlue  = (int)(255 * 0.75);
		}
	}

	/* CEChENXo^܂B */
	memset(&wc, 0, sizeof wc);
	wc.lpfnWndProc = WndProc;
	wc.hInstance = g_hinst;
	wc.hIcon = LoadIcon(g_hinst, MAKEINTRESOURCE(IDR_MAINFRAME));
	wc.lpszClassName = APPNAME;
	retval = RegisterClass(&wc);
	if(!retval) {
		MessageBox(NULL, "RegisterClass() failed.", APPTITLE, MB_ICONSTOP | MB_OK);
		exit(1);
	}

	/* CEChE쐬܂B */
	g_hwnd = CreateWindowEx(
		WS_EX_TOPMOST | WS_EX_TOOLWINDOW/*^XNo[ɕ\Ȃ*/,
		APPNAME,
		APPTITLE,
		WS_POPUP | WS_BORDER,
		g_x_pos, g_y_pos, 0, 0,
		NULL,
		NULL,
		g_hinst,
		NULL);

	/* ^XNgCւ̓o^/̂߂̍\̂pӂĂ܂B */
	memset(&g_nid, 0, sizeof g_nid);
	g_nid.cbSize = sizeof g_nid;
	g_nid.hWnd = g_hwnd;
	g_nid.uID = 1;
	g_nid.uFlags = NIF_MESSAGE | NIF_ICON | NIF_TIP;
	g_nid.uCallbackMessage = WM_NOTIFY_ICON;
	g_nid.hIcon = wc.hIcon;
	strcpy(g_nid.szTip, APPTITLE);

	/* CEChȄʒuݒ肵܂B */
	move_resize();

	/* CEChE\܂B */
	switch(nCmdShow) {
	default:
		show(TRUE);
		break;
	case SW_SHOWMINIMIZED:
	case SW_SHOWMINNOACTIVE:
		show(FALSE);
		break;
	}

	/* bZ[W[vB */
	while(GetMessage(&msg, NULL, 0, 0)) {
		TranslateMessage(&msg);
		DispatchMessage(&msg);
	}

	/* BITMAPINFO\̂J܂B */
	free(g_bmi_active);
	free(g_bmi_active16);
	free(g_bmi_inactive);
	free(g_bmi_inactive16);

	/* INIt@C܂B */
	WritePrivateProfileString(SEC_DEFAULT, KEY_INTERVAL, itoa(g_interval, buf, 10), ini_path);
	WritePrivateProfileString(SEC_DEFAULT, KEY_ALWAYS, itoa(g_always, buf, 10), ini_path);
	WritePrivateProfileString(SEC_DEFAULT, KEY_ASYNC, itoa(g_async, buf, 10), ini_path);
	WritePrivateProfileString(SEC_DEFAULT, KEY_CLIP, itoa(g_clip, buf, 10), ini_path);
	WritePrivateProfileString(SEC_DEFAULT, KEY_SCALE, itoa(g_scale, buf, 10), ini_path);
	WritePrivateProfileString(SEC_DEFAULT, KEY_X_POS, itoa(g_x_pos, buf, 10), ini_path);
	WritePrivateProfileString(SEC_DEFAULT, KEY_Y_POS, itoa(g_y_pos, buf, 10), ini_path);
	WritePrivateProfileString(SEC_DEFAULT, KEY_SPRITE, itoa(g_sprite, buf, 10), ini_path);
	WritePrivateProfileString(SEC_DEFAULT, KEY_VSCREEN, itoa(g_vscreen, buf, 10), ini_path);
	WritePrivateProfileString(SEC_DEFAULT, KEY_XCOLOR, itoa(g_xcolor, buf, 10), ini_path);

	return msg.wParam;
}

/****************************************************************************
 *	WndProc
 ****************************************************************************/

LRESULT CALLBACK
WndProc(HWND hwnd, UINT msg, WPARAM wparam, LPARAM lparam)
{
	HDC hdc;
	PAINTSTRUCT ps;
	RECT rc;
	RECT* pr;

	switch(msg) {
	case WM_DESTROY:
		/* mɃ^XNgCo^B */
		Shell_NotifyIcon(NIM_DELETE, &g_nid);
		PostQuitMessage(0);
		return 0;
	case WM_NCHITTEST:
		/* ǂłhbOăEChEړB */
		return HTCAPTION;
	case WM_MOVE:
		/* WM_MOVElparam̓NCAg̈̍WXN[Wɒ̂Ȃ̂ŁA
		 * ̂܂ܕۑƎNɃEChEʒuĕĂ܂܂B
		 * EChEʒuۑ邽߂ɁAlparam͎g킸IɈʒu擾܂B
		 */
		GetWindowRect(hwnd, &rc);
		g_x_pos = rc.left;
		g_y_pos = rc.top;
		return 0;
	case WM_MOVING:
		if(g_clip) {
			/* ʊOɈړȂB */
			pr = (RECT*)lparam;
			SystemParametersInfo(SPI_GETWORKAREA, 0, &rc, 0);
			if(pr->right  > rc.right  ) { pr->left   -= pr->right  - rc.right ; pr->right  = rc.right ; }
			if(pr->bottom > rc.bottom ) { pr->top    -= pr->bottom - rc.bottom; pr->bottom = rc.bottom; }
			if(pr->left   < rc.left   ) { pr->right  -= pr->left   - rc.left  ; pr->left   = rc.left  ; }
			if(pr->top    < rc.top    ) { pr->bottom -= pr->top    - rc.top   ; pr->top    = rc.top   ; }
		}
		return 0;
	case WM_ACTIVATEAPP:
		/* WM_ACTIVATEł͂ȂWM_ACTIVATEAPPg܂B
		 * WM_ACTIVATEł́ÃAvP[Vg̃_CAOɂbZ[ŴŁA
		 * XvCg܂B
		 * WM_ACTIVATEAPPȂ΁Aʂ̃AvP[V؂ւAbZ[W܂B
		 */
		if(g_sprite) {
			if(wparam) sprite_mode();
		}
		return 0;
	case WM_TIMER:
		InvalidateRect(hwnd, NULL, FALSE);
		return 0;
	case WM_PAINT:
		hdc = BeginPaint(hwnd, &ps);
		GetClientRect(hwnd, &rc);
		update(hdc, &rc);
		EndPaint(hwnd, &ps);
		return 0;
	case WM_NCRBUTTONDOWN:
		popup_menu();
		return 0;
	case WM_KEYDOWN:
		switch(wparam) {
		case VK_SPACE: /* OtBbN/XvCggO */
			if(fram_addr == 0) {
				sprite_mode();
				if(fram_addr == 0) {
					MessageBox(g_hwnd,
						"XvCg񂪌܂B",
						APPTITLE,
						MB_ICONEXCLAMATION | MB_OK);
				}
			} else {
				graphic_mode();
			}
			return 0;
		case '1':
		case '2':
		case '4':
			change_scale(wparam - '0');
			return 0;
		case 'V':
			change_vscreen(!g_vscreen);
			return 0;
		case 'X':
			g_xcolor = !g_xcolor;
			return 0;
		case VK_ESCAPE: /* B */
			show(FALSE);
			return 0;
		case VK_F12: /* I */
			SendMessage(hwnd, WM_CLOSE, 0, 0);
			return 0;
		}
		return 0;
	case WM_NOTIFY_ICON:
		switch(lparam) {
		case WM_RBUTTONUP:
			popup_menu();
			return 0;
		case WM_LBUTTONDBLCLK:
			show(TRUE);
			return 0;
		}
		return 0;
	}
	return DefWindowProc(hwnd, msg, wparam, lparam);
}

/****************************************************************************
 *	popup_menu
 ****************************************************************************/

void
popup_menu()
{
	int retval, visible;
	MENUITEMINFO mii;
	HMENU hmenu;
	POINT point;

	memset(&mii, 0, sizeof mii);
	mii.cbSize = sizeof mii;
	mii.fMask = MIIM_ID | MIIM_STATE | MIIM_TYPE;

	/* j[쐬܂B */
	hmenu = CreatePopupMenu();

	/* \/\ɂāAj[؂ւ܂B */
	visible = IsWindowVisible(g_hwnd);
	if(visible) {
		/* OtBbN/XvCg[h */
		mii.fType = MFT_STRING;
		mii.wID = ID_GRAPHIC;
		mii.dwTypeData = fram_addr == 0 ? mii.dwTypeData = "OtBbN" : "OtBbN\tSpace";
		mii.fState = MFS_ENABLED;
		if(fram_addr == 0) mii.fState |= MFS_CHECKED;
		InsertMenuItem(hmenu, -1, TRUE, &mii);
		mii.wID = ID_SPRITE;
		mii.dwTypeData = fram_addr != 0 ?"XvCg(Č)" : "XvCg\tSpace";
		mii.fState = MFS_ENABLED;
		if(fram_addr != 0) mii.fState |= MFS_CHECKED;
		InsertMenuItem(hmenu, -1, TRUE, &mii);
		mii.wID = -1;
		mii.fType = MFT_SEPARATOR;
		InsertMenuItem(hmenu, -1, TRUE, &mii);

		/* XP[ */
		mii.fType = MFT_STRING;
		mii.wID = ID_SCALE_1;
		mii.dwTypeData = "1{\t1";
		mii.fState = MFS_ENABLED;
		if(g_scale == 1) mii.fState |= MFS_CHECKED;
		InsertMenuItem(hmenu, -1, TRUE, &mii);
		mii.wID = ID_SCALE_2;
		mii.dwTypeData = "2{\t2";
		mii.fState = MFS_ENABLED;
		if(g_scale == 2) mii.fState |= MFS_CHECKED;
		InsertMenuItem(hmenu, -1, TRUE, &mii);
		mii.wID = ID_SCALE_4;
		mii.dwTypeData = "4{\t4";
		mii.fState = MFS_ENABLED;
		if(g_scale == 4) mii.fState |= MFS_CHECKED;
		InsertMenuItem(hmenu, -1, TRUE, &mii);
		mii.wID = -1;
		mii.fType = MFT_SEPARATOR;
		InsertMenuItem(hmenu, -1, TRUE, &mii);

		/* C^[o */
		mii.fType = MFT_STRING;
		mii.wID = ID_INTERVAL_10;
		mii.dwTypeData = "10~b";
		mii.fState = MFS_ENABLED;
		if(g_interval == 10) mii.fState |= MFS_CHECKED;
		InsertMenuItem(hmenu, -1, TRUE, &mii);
		mii.wID = ID_INTERVAL_100;
		mii.dwTypeData = "100~b";
		mii.fState = MFS_ENABLED;
		if(g_interval == 100) mii.fState |= MFS_CHECKED;
		InsertMenuItem(hmenu, -1, TRUE, &mii);
		mii.wID = ID_INTERVAL_1000;
		mii.dwTypeData = "1000~b";
		mii.fState = MFS_ENABLED;
		if(g_interval == 1000) mii.fState |= MFS_CHECKED;
		InsertMenuItem(hmenu, -1, TRUE, &mii);
		mii.wID = -1;
		mii.fType = MFT_SEPARATOR;
		InsertMenuItem(hmenu, -1, TRUE, &mii);

		/* cʃ[hB */
		mii.fType = MFT_STRING;
		mii.wID = ID_APP_VSCREEN;
		mii.dwTypeData = "cʃ[h\tV";
		mii.fState = MFS_ENABLED;
		if(g_vscreen) mii.fState |= MFS_CHECKED;
		InsertMenuItem(hmenu, -1, TRUE, &mii);

		/* 16K[hB */
		mii.fType = MFT_STRING;
		mii.wID = ID_APP_XCOLOR;
		mii.dwTypeData = "16K[h\tX";
		mii.fState = MFS_ENABLED;
		if(g_xcolor) mii.fState |= MFS_CHECKED;
		InsertMenuItem(hmenu, -1, TRUE, &mii);

		/* XvCgB */
		mii.fType = MFT_STRING;
		mii.wID = ID_APP_SPRITE;
		mii.dwTypeData = "XvCg";
		mii.fState = MFS_ENABLED;
		if(g_sprite) mii.fState |= MFS_CHECKED;
		InsertMenuItem(hmenu, -1, TRUE, &mii);

		/* ɍXVB */
		mii.fType = MFT_STRING;
		mii.wID = ID_APP_ALWAYS;
		mii.dwTypeData = "ANeBuXV";
		mii.fState = MFS_ENABLED;
		if(g_always) mii.fState |= MFS_CHECKED;
		InsertMenuItem(hmenu, -1, TRUE, &mii);

		/* 񓯊Lv`B */
		mii.fType = MFT_STRING;
		mii.wID = ID_APP_ASYNC;
		mii.dwTypeData = "񓯊Lv`";
		mii.fState = MFS_ENABLED;
		if(g_async) mii.fState |= MFS_CHECKED;
		InsertMenuItem(hmenu, -1, TRUE, &mii);

		/* ʊOɈړȂB */
		mii.fType = MFT_STRING;
		mii.wID = ID_APP_CLIP;
		mii.dwTypeData = "ʊOɈړȂ";
		mii.fState = MFS_ENABLED;
		if(g_clip) mii.fState |= MFS_CHECKED;
		InsertMenuItem(hmenu, -1, TRUE, &mii);

		/* BB */
		mii.fType = MFT_STRING;
		mii.wID = ID_APP_SHOW;
		mii.dwTypeData = "B\tEsc";
		mii.fState = MFS_ENABLED;
		InsertMenuItem(hmenu, -1, TRUE, &mii);
	} else {
		/* \B */
		mii.fType = MFT_STRING;
		mii.wID = ID_APP_SHOW;
		mii.dwTypeData = "\";
		mii.fState = MFS_ENABLED | MFS_DEFAULT;
		InsertMenuItem(hmenu, -1, TRUE, &mii);
	}
	/* o[WB */
	mii.fType = MFT_STRING;
	mii.wID = ID_APP_ABOUT;
	mii.dwTypeData = "o[W";
	mii.fState = MFS_ENABLED;
	InsertMenuItem(hmenu, -1, TRUE, &mii);
	mii.wID = -1;
	mii.fType = MFT_SEPARATOR;
	InsertMenuItem(hmenu, -1, TRUE, &mii);

	/* I */
	mii.fType = MFT_STRING;
	mii.wID = ID_APP_EXIT;
	mii.dwTypeData = visible ? "I\tF12" : "I" ;
	mii.fState = MFS_ENABLED;
	InsertMenuItem(hmenu, -1, TRUE, &mii);

	/* j[\܂B */
	GetCursorPos(&point);
	retval = TrackPopupMenu(hmenu,
		TPM_LEFTALIGN | TPM_TOPALIGN | TPM_RIGHTBUTTON | TPM_RETURNCMD,
		point.x, point.y,
		0,
		g_hwnd,
		NULL);

	/* j[폜܂B */
	DestroyMenu(hmenu);

	/* j[B */
	switch(retval) {
	case ID_APP_EXIT:
		DestroyWindow(g_hwnd);
		return;
	case ID_APP_VSCREEN:
		change_vscreen(!g_vscreen);
		return;
	case ID_APP_XCOLOR:
		g_xcolor = !g_xcolor;
		return;
	case ID_APP_SPRITE:
		g_sprite = !g_sprite;
		return;
	case ID_APP_ALWAYS:
		g_always = !g_always;
		return;
	case ID_APP_ASYNC:
		g_async = !g_async;
		return;
	case ID_APP_CLIP:
		g_clip = !g_clip;
		if(g_clip) move_resize();
		return;
	case ID_APP_SHOW:
		visible = !visible;
		show(visible);
		return;
	case ID_APP_ABOUT:
		MessageBox(g_hwnd,
			APPTITLE " " VERSION "\n" \
			"Copyright (C) 2002-2018 Naoyuki Sawa",
			APPTITLE,
			MB_ICONINFORMATION | MB_OK);
		return;
	case ID_SCALE_1:
	case ID_SCALE_2:
	case ID_SCALE_4:
		switch(retval) {
		case ID_SCALE_1: change_scale(1); break;
		case ID_SCALE_2: change_scale(2); break;
		case ID_SCALE_4: change_scale(4); break;
		}
		return;
	case ID_INTERVAL_10:
	case ID_INTERVAL_100:
	case ID_INTERVAL_1000:
		switch(retval) {
		case ID_INTERVAL_10:   change_interval(10  ); break;
		case ID_INTERVAL_100:  change_interval(100 ); break;
		case ID_INTERVAL_1000: change_interval(1000); break;
		}
		return;
	case ID_GRAPHIC:
		graphic_mode();
		return;
	case ID_SPRITE:
		sprite_mode();
		if(fram_addr == 0) {
			MessageBox(g_hwnd,
				"XvCg񂪌܂B",
				APPTITLE,
				MB_ICONEXCLAMATION | MB_OK);
		}
		return;
	}
}

/****************************************************************************
 *	show
 ****************************************************************************/

void
show(int visible)
{
	if(visible) {
		/* \B */
		Shell_NotifyIcon(NIM_DELETE, &g_nid);
		ShowWindow(g_hwnd, SW_SHOW);
		UpdateWindow(g_hwnd);
		SetTimer(g_hwnd, TIMER_ID, g_interval, NULL);
	} else {
		/* BB */
		KillTimer(g_hwnd, TIMER_ID);
		ShowWindow(g_hwnd, SW_HIDE);
		Shell_NotifyIcon(NIM_ADD, &g_nid);
	}
}

/****************************************************************************
 *	move_resize
 ****************************************************************************/

void
move_resize()
{
	int w, h;
	RECT rc;

	/* TCYvZB */
	if(!g_vscreen) { /*  */
		w = DISP_X * g_scale + GetSystemMetrics(SM_CXBORDER) * 2;
		h = DISP_Y * g_scale + GetSystemMetrics(SM_CYBORDER) * 2;
	} else { /* c */
		w = DISP_Y * g_scale + GetSystemMetrics(SM_CXBORDER) * 2;
		h = DISP_X * g_scale + GetSystemMetrics(SM_CYBORDER) * 2;
	}

	/* ݂͂`FbNB */
	SystemParametersInfo(SPI_GETWORKAREA, 0, &rc, 0);
	if(g_x_pos + w > rc.right ) g_x_pos = rc.right  - w;
	if(g_y_pos + h > rc.bottom) g_y_pos = rc.bottom - h;
	if(g_x_pos     < rc.left  ) g_x_pos = rc.left     ;
	if(g_y_pos     < rc.top   ) g_y_pos = rc.top      ;

	/* EChEړETCYB */
	MoveWindow(g_hwnd, g_x_pos, g_y_pos, w, h, TRUE/*FALSEɂƁAfXNgbvɃS~c܂B*/);

	/* ɋĕ`B */
	InvalidateRect(g_hwnd, NULL, FALSE); /* YȂ! */
	UpdateWindow(g_hwnd);
}

/****************************************************************************
 *	update
 ****************************************************************************/

/* vbuff[]->rbuff[c]։E90]B */
static void
rotbuf(unsigned char vbuff[DISP_X * DISP_Y], unsigned char rbuff[DISP_X * DISP_Y])
{
	unsigned char (*src)[DISP_X] = (unsigned char (*)[DISP_X])&vbuff[0];
	unsigned char (*dst)[DISP_Y] = (unsigned char (*)[DISP_Y])&rbuff[0];
	int x, y;

	for(y = 0; y < DISP_Y; y++) {
		for(x = 0; x < DISP_X; x++) {
			dst[x][(DISP_Y - 1) - y] = src[y][x];
		}
	}
}

void
update(HDC hdc, const RECT* rc)
{
	static unsigned char vbuff[DISP_X * DISP_Y];
	       unsigned char rbuff[DISP_X * DISP_Y];
	BITMAPINFO* bmi;
	int w, h;

	/* ANeBuԂɂāALv`̗LƃpbgIB */
	if(g_always || GetForegroundWindow() == g_hwnd) {
		if(capture(vbuff, sizeof vbuff) != 0) memset(vbuff, -1, sizeof vbuff);
		if(g_xcolor && !fram_addr) { /* 16K[hBXvCg[h͏4K */
			bmi = g_bmi_active16;
		} else {
			bmi = g_bmi_active;
		}
	} else {
		if(g_xcolor && !fram_addr) { /* 16K[hBXvCg[h͏4K */
			bmi = g_bmi_inactive16;
		} else {
			bmi = g_bmi_inactive;
		}
	}

	/* cʃ[hɂāA]TCYIƉ]B */
	if(!g_vscreen) {
		w = DISP_X;
		h = DISP_Y;
		memcpy(rbuff, vbuff, DISP_X * DISP_Y);
	} else {
		w = DISP_Y;
		h = DISP_X;
		rotbuf(vbuff, rbuff);
	}

	/* ʓ]B */
	bmi->bmiHeader.biWidth = w;
	bmi->bmiHeader.biHeight = -h; /* gbv_E */
	StretchDIBits(hdc,
		rc->left, rc->top, rc->right - rc->left, rc->bottom - rc->top,
		0, 0, w, h,
		rbuff,
		bmi,
		DIB_RGB_COLORS,
		SRCCOPY);
}

/****************************************************************************
 *	capture
 ****************************************************************************/

int
capture(unsigned char* vbuff, int len)
{
	int retval, stat, x, y, T0, T, dT;
	unsigned long pbuff;
	unsigned char fram[DISP_Y][2][DISP_X / 8];
	unsigned char* p;

	retval = ismInitEx(0, 0);
	if(retval != 0) goto ERR;

	/* * ismLCDCaptureScreen()́A|[Y҂[v20ms̃EFCgĂ܂B
	 *   Lv`ׂ̂́Aǂ炱ꂪ̂悤łB
	 * *  ismAppPause(1)sAxڂismLCDGetInfo()ł͂܂|[YĂ܂񂪁A
	 *   20msȂ葁^C~OŃ|[YꍇɂA
	 *   ismLCDCaptureScreen()͖20ms҂Ă܂܂B
	 *   ̂߁AP/ECE|[YԂ̂܂20ms҂Ă܂܂B
	 * * USBʐM̂P/ECEɂقǕׂȂ͂Ȃ̂ŁA
	 *   EFCgOÕ[v񂷂Ƃɂ܂B
//{{2018/07/14Rgǉ:񓯊Lv`łȂꍇɁAŋ߂̍PCƁAP/ECEɕׂ|߂C܂B
	 * * c[쐬(2002N)PC͒x̂ŁAS͂ŉ񂵂Ăǂ̂łA
	 *   ŋ(2018N)̑PCƁA[v߂P/ECEւUSB荞ݕׂ߂܂B
	 *   ׂ߂ƁAP/ECẼ|[YԂւ̈ڍsxALv`̃[gxȂ܂B
	 *   L̖邽߂ɁA1~b̃EFCg鎖ɂ܂B
	 *   EFCgԂ͒\łA0ł͌ʂA1ŏ\ʂL̂ŁA1ɂ܂B
	 *   ȀĆA'Wed Jul 19 18:18:33 JST 2017 Naoyuki Sawa'ɁAUfeSvrɑ΂čŝƁȀCƂȂ܂B
	 *   ڍׂɂẮA/clip/tool/ufesvr/ufesvr.ćA'Wed Jul 19 18:18:33 JST 2017 Naoyuki Sawa'̃RgQƂĉB
//}}2018/07/14Rgǉ:񓯊Lv`łȂꍇɁAŋ߂̍PCƁAP/ECEɕׂ|߂C܂B
	 */

	/* 񓯊Lv`łȂ΃|[Y܂B */
	if(!g_async) {
		retval = ismAppPause(1);
		if(retval != 0) goto ERR;
		/* AvP[V|[YԂɂȂ܂ő҂܂B */
		T0 = GetTickCount();
		for(;;) {
			retval = ismLCDGetInfo(&stat, &pbuff); /* ŎĝŉzVRAMAhX擾 */
			if(retval != 0) goto ERR;
			/* * ȑÕJ[ĺA
			 *	statbit0Ƀ|[YvtO
			 *	statbit1pceAppProcstO
			 *   ԂĂ̂ (stat & 3) == 1 ɂȂ܂ő҂Kv܂B
			 *   (ٍminiISD͂̍ɍ̂ŁAȂĂ܂)
			 * * BIOS1.18݂̃J[ĺA
			 *	stat=0:|[YvsĂȂA܂͗vsꂽ܂pceAppProcs
			 *	     1:|[YԂɓ
			 *   Ԃ悤ɂȂ̂ŁAPstat0ۂ𔻒f邾ł悭Ȃ܂B
			 * * ݂̃J[lłAȑO̔莮 (stat & 3) == 1 ͐܂A
			 *   ͂bit20ǂ𒲂ׂ͖̂ӖɂȂ̂(0)A
			 *   ͐VJ[lOƂfgƂɂ܂B
			 */
			if(stat) break;
//{{2018/07/14ύX:񓯊Lv`łȂꍇɁAŋ߂̍PCƁAP/ECEɕׂ|߂C܂B
//			/* * ɃEFCgĂA܂̂ƂSŉ񂷂Ƃɂ܂B
//			 *   ̊֐̐擪̃RgQƁB
//			 */
//			T = GetTickCount();
//			dT = T - T0;
//			if(dT >= 1000) { /* 1bŃ^CAEg */
//				retval = ismAppPause(0); /* |[Y */
//				goto ERR;
//			}
//2018/07/14ύX:񓯊Lv`łȂꍇɁAŋ߂̍PCƁAP/ECEɕׂ|߂C܂B
			/* * c[쐬(2002N)PC͒x̂ŁAS͂ŉ񂵂Ăǂ̂łA
			 *   ŋ(2018N)̑PCƁA[v߂P/ECEւUSB荞ݕׂ߂܂B
			 *   ׂ߂ƁAP/ECẼ|[YԂւ̈ڍsxALv`̃[gxȂ܂B
			 *   L̖邽߂ɁA1~b̃EFCg鎖ɂ܂B
			 *   EFCgԂ͒\łA0ł͌ʂA1ŏ\ʂL̂ŁA1ɂ܂B
			 *   ȀĆA'Wed Jul 19 18:18:33 JST 2017 Naoyuki Sawa'ɁAUfeSvrɑ΂čŝƁȀCƂȂ܂B
			 *   ڍׂɂẮA/clip/tool/ufesvr/ufesvr.ćA'Wed Jul 19 18:18:33 JST 2017 Naoyuki Sawa'̃RgQƂĉB
			 */
			T = GetTickCount();
			dT = T - T0;
			if(dT >= 1000) { /* 1bŃ^CAEg */
				retval = ismAppPause(0); /* |[Y */
				goto ERR;
			}
			Sleep(1/**/); /* P/ECEɕׂ|߂Ȃ悤AEFCgB */
//}}2018/07/14ύX:񓯊Lv`łȂꍇɁAŋ߂̍PCƁAP/ECEɕׂ|߂C܂B
		}
	}

	/* XvCg[h */
	if(fram_addr != 0) {
		/* XvCgCũt[obt@ǂݍ݂܂B */
		retval = ismReadMem((unsigned char*)fram, fram_addr, sizeof fram);
		if(retval != 0) {
			if(!g_async) ismAppPause(0); /* |[Y */
			goto ERR;
		}

	/* OtBbN[h */
	} else {
//{{2018/07/14ǉ:񓯊Lv`ɁAzVRAMAhX擾ĂȂoOC܂B
		/* 񓯊Lv`́A܂zVRAMAhX擾ĂȂ̂ŁAŎ擾B */
		if(g_async) {
			retval = ismLCDGetInfo(&stat, &pbuff); /* ŎĝŉzVRAMAhX擾 */
			if(retval != 0) goto ERR;
		}
//}}2018/07/14ǉ:񓯊Lv`ɁAzVRAMAhX擾ĂȂoOC܂B

		/* zVRAMǂݍ݂܂B
		 * * zVRAMAhX̓|[Y҂̂߂ismLCDGetInfo()łɎ擾ς݁I
		 *   悭lĂȂB
		 */
		retval = ismReadMem(vbuff, pbuff, len);
		if(retval != 0) {
			if(!g_async) ismAppPause(0); /* |[Y */
			goto ERR;
		}
	}

	/* 񓯊Lv`łȂ΃|[Y܂B */
	if(!g_async) ismAppPause(0);

	/* XvCg[hȂAt[obt@zVRAM`ɓWJ܂B
	 * P/ECẼ|[YԂłZ邽߁A|[Yɍs܂B
	 */
	if(fram_addr != 0) {
		p = vbuff;
		for(y = 0; y < DISP_Y; y++) {
			for(x = 0; x < DISP_X; x++) {
				*p++ = (fram[y][0][x / 8] >> x % 8 & 1) << 1 |
				       (fram[y][1][x / 8] >> x % 8 & 1);
			}
		}
	}

	/* FALL THRU */
ERR:
	ismExit();

	return retval;
}

/****************************************************************************
 *	change_scale
 ****************************************************************************/

void
change_scale(int scale)
{
	g_scale = scale;
	if(IsWindowVisible(g_hwnd)) {
		move_resize();
	}
}

/****************************************************************************
 *	change_interval
 ****************************************************************************/

void
change_interval(int interval)
{
	g_interval = interval;
	if(IsWindowVisible(g_hwnd)) {
		KillTimer(g_hwnd, TIMER_ID);
		SetTimer(g_hwnd, TIMER_ID, g_interval, NULL);
	}
}

/****************************************************************************
 *	change_vscreen
 ****************************************************************************/

void
change_vscreen(int vscreen)
{
	g_vscreen = vscreen;
	if(IsWindowVisible(g_hwnd)) {
		move_resize();
	}
}

/****************************************************************************
 *	graphic_mode
 ****************************************************************************/

void
graphic_mode()
{
	fram_addr = 0;
}

/****************************************************************************
 *	sprite_mode
 ****************************************************************************/

void
sprite_mode()
{
	HCURSOR old_cursor;
	old_cursor = SetCursor(LoadCursor(NULL, IDC_WAIT));
	fram_addr = fram_find();
	SetCursor(old_cursor);
	/* G[bZ[W\͌ĂяoōsĂB */
}
