/*	
 *	app.h
 *
 *	pcemon - P/ECE monitor
 *	Copyright (C) 2002 Naoyuki Sawa
 *
 *	* Mon Mar 25 07:00:00 JST 2002 Naoyuki Sawa
 *	- 쐬JnB
 */
#pragma once

#define STRICT
#include <windows.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "pieceif.h"
#pragma comment(lib,"pieceif.lib")

#include "resource.h"

/****************************************************************************
 *	`
 ****************************************************************************/

#define APPNAME			"PCEMON"
#define APPTITLE		"P/ECE monitor"
#define VERSION			"(20180714)"

#define DISP_X			128
#define DISP_Y			 88

#define WM_NOTIFY_ICON		(WM_APP + 1)
#define TIMER_ID		1

#define SEC_DEFAULT		"default"
#define KEY_INTERVAL		"interval"
#define KEY_ALWAYS		"always"
#define KEY_ASYNC		"async"
#define KEY_CLIP		"clip"
#define KEY_SCALE		"scale"
#define KEY_X_POS		"x_pos"
#define KEY_Y_POS		"y_pos"
#define KEY_SPRITE		"sprite"
#define KEY_VSCREEN		"vscreen"
#define KEY_XCOLOR		"xcolor"

#define INTERVAL_MIN		10
#define INTERVAL_MAX		1000
#define SCALE_MIN		1
#define SCALE_MAX		4

#define ID_APP_EXIT		101
#define ID_APP_VSCREEN		102
#define ID_APP_XCOLOR		103
#define ID_APP_SPRITE		104
#define ID_APP_ALWAYS		105
#define ID_APP_ASYNC		106
#define ID_APP_CLIP		107
#define ID_APP_SHOW		108
#define ID_APP_ABOUT		109

#define ID_SCALE_1		201
#define ID_SCALE_2		202
#define ID_SCALE_4		203

#define ID_INTERVAL_10		301
#define ID_INTERVAL_100		302
#define ID_INTERVAL_1000	303

#define ID_GRAPHIC		401
#define ID_SPRITE		402

/****************************************************************************
 *	O[oϐ
 ****************************************************************************/

extern char ini_path[_MAX_PATH];

extern HINSTANCE g_hinst;
extern BITMAPINFO* g_bmi_active;
extern BITMAPINFO* g_bmi_active16;
extern BITMAPINFO* g_bmi_inactive;
extern BITMAPINFO* g_bmi_inactive16;
extern HWND g_hwnd;
extern NOTIFYICONDATA g_nid;

extern int g_interval;
extern int g_always;
extern int g_async;
extern int g_clip;
extern int g_scale;
extern int g_x_pos;
extern int g_y_pos;
extern int g_sprite;
extern int g_vscreen;
extern int g_xcolor;

/****************************************************************************
 *	O[o֐
 ****************************************************************************/

/* main.cpp */
int PASCAL WinMain(HINSTANCE hInst, HINSTANCE hPrevInst, LPSTR lpCmdLine, int nCmdShow);
LRESULT CALLBACK WndProc(HWND hwnd, UINT msg, WPARAM wparam, LPARAM lparam);
void popup_menu();
void show(int visible);
void move_resize();
void update(HDC hdc, const RECT* rect);
int capture(unsigned char* vbuff, int len);
void change_scale(int scale);
void change_interval(int interval);
void change_vscreen(int vscreen);
void graphic_mode();
void sprite_mode();

/* sprite.cpp */
unsigned long fram_find();
int ismAppPause(int pausef);
int ismLCDGetInfo(int* pstat, unsigned long* pbuff);
