/*	
 *	main.cpp
 *
 *	dmalloc - malloc dump utility
 *	Copyright (C) 2002-2018 Naoyuki Sawa
 *
 *	* Tue Jul  2 21:24:00 JST 2002 Naoyuki Sawa
 *	- 쐬JnB
 *	* Tue Jul  3 21:11:00 JST 2002 Naoyuki Sawa
 *	- q[vT̈AAvP[Vwb_`BSSIAhX܂łɌB
 *	  ÕAvP[Ṽq[v񂪃NAꂸɎcĂꍇA
 *	  ԈČoĂ܂Ă肪A܂B
 *	* Sun Jul  7 07:00:00 JST 2002 Naoyuki Sawa
 *	- v̏o͂ǉB
 *	- o͐IvV̒ǉB
 *	- foCXI̒ǉB
 *	* Mon Jul 15 21:51:00 JST 2002 Naoyuki Sawa
 *	- SRAMǂݍݑÕ|[YvsAۂɃAvP[V|[YԂɂȂ̂҂ĂȂB
 *	  Ɋȃ^C~OŁA蓖ēr̕sȏԂSRAMeǂł܂\B
 *	  AvP[V|[YԂɂȂ̂҂悤ɏC܂B
 *	* Wed Jun 16 06:52:00 JST 2004 Naoyuki Sawa
 *	- P/ECE API pceHeapAlooc()pq[v\ǉ܂B
 *	  ܂ł́AEPSONCumalloc()pq[v񂾂\Ă܂B
 *	* Wed Dec 29 22:57:00 JST 2004 Naoyuki Sawa
 *	- X^bN\@\ǉ܂B
 *	  2004/12/29ȍ~CLiPCu𗘗pĂAvP[V́AX^bN\\łB
 *	* Wed Jan 05 06:00:00 JST 2005 Naoyuki Sawa
 *	- X^bNFRAM4̈֐؂ւ܂yield()ꍇ̂ŁAsspAusp̌O܂B
 *	  o[Wł́Aq̂悤ȏ󋵂ŁASTACKINFǑoɎsĂ܂B
 *	* Sun Jul 22 23:59:59 JST 2018 Naoyuki Sawa
 *	- 荞݃X^bNǉ܂B
 *	- AvP[VۂɃ|[YԂɂȂ܂ő҂AP/ECEɕׂ|߂āA^CAEgC܂B
 */
#define STRICT
#include <windows.h>

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include <pieceif.h>
#pragma comment(lib,"pieceif.lib")

#define VERSION		"20180722"

/****************************************************************************
 *	萔E^
 ****************************************************************************/

#define FRAM_TOP	0x0000	/* RAM擪AhX */
#define FRAM_END	0x2000	/* RAMI[AhX */

typedef struct tagSYSTEMINFO { /* piece.hQ */
	unsigned short size;
	unsigned short hard_ver;
	unsigned short bios_ver;
	unsigned short bios_date;
	unsigned long sys_clock;
	unsigned short vdde_voltage;
	unsigned short resv1;
	unsigned long sram_top;
	unsigned long sram_end;
	unsigned long pffs_top;
	unsigned long pffs_end;
} SYSTEMINFO;

typedef struct _pceAPPHEAD { /* piece.hQ */
	unsigned long signature;     /* 'pCeA'ŒBsJnAppInit()0NA܂ */
	unsigned short sysver;       /* VXeo[Wi[AڍׂȒl͉łȂj       */
	unsigned short resv1;        /* ݂̃X^[gAbvCuł0ŒiłȂj    */
	unsigned long initialize;    /* ֐AhXi[K{An[t[hACgj */
	unsigned long periodic_proc; /* ֐AhXi[K{An[t[hACgj */
	unsigned long pre_terminate; /* I֐AhXi[K{An[t[hACgj   */
	unsigned long notify_proc;   /* ʒm֐AhXi[K{An[t[hACgj   */
	unsigned long stack_size;    /* ݂̃X^[gAbvCuł0ŒiłȂj    */
	unsigned long bss_end;       /* BSS̏IAhXpceHeapAlloc()pq[vJnAhX      */
	                             /*i[BBIOS1.18̓[hACgz肵Ă邪A    */
	                             /* J-alignIvVŕύX\B肵ȂSj   */
} pceAPPHEAD;
#define APPSTARTPOS1	0x100000 /* ʏ̃AvP[Ṽwb_ʒu   */
#define APPSTARTPOS2	0x138000 /* ̂̃X^[gAbvVF̃wb_ʒu */

typedef struct tagHEAPMEM { /* piece.hQ */
	unsigned short mark;		/* VOl` (HEAPMEMMKŒ) */
	unsigned short owner;		/*  (0: / HMO_DEFAULT_USER:ʏ튄蓖 / HMO_SYSTEM:VXe\)          */
					/* PieceSystem1.20݁AHMO_SYSTEM͎gĂ܂B0܂HMO_DEFAULT_USERłB */
	//struct tagHEAPMEM* chain;
	unsigned long chain;		/* HEAPMEM̃AhX (NULL:I[) */
} HEAPMEM;
/* HEAPMEM.mark */
#define HEAPMEMMK		0xa431
/* HEAPMEM.owner */
#define HMO_DEFAULT_USER	1
#define HMO_SYSTEM		0xffff

typedef struct tagHEAPINFO { /* /use/piece/include/stdlib.hQ */
	unsigned long start_alloc; /* ansi_InitMalloc̑ێ  */
	unsigned long end_alloc;   /* ansi_InitMalloc̑ێ  */
	unsigned long nxt_alc_p;   /* 󂫗̈̐擪AhX         */
	unsigned long tbl_ptr;     /* 蓖ăe[u̐擪AhX */
	unsigned long row;         /* 蓖ăe[u̗vf       */
} HEAPINFO;

typedef struct tagBLKTBL { /*  */
	unsigned long ptr;	/* ̃ubN̐擪AhX   */
	unsigned long len:31;	/* ̃ubÑTCY[oCg] */
	unsigned long use: 1;	/* 0:/1:gp              */
} BLKTBL;

/* * ȂubNe[u͈vf]vŁA
 *	tbl_ptr = (BLKTBL*)end_alloc - (row + 1)
 *   ɂȂĂ܂B
 *   ԎႢAhX̃e[uvfɂ̓S~Ă܂B
 * * ׂ荇e[uvf̎wubNAhX͘AĂ܂B
 *	blktbl[n].ptr + blktbl[n].len = blktbl[n - 1].ptr
 *   ɐ܂B
 * * ʃAhX(13FFFF)̃e[uvf̕A
 *   ʃAhX(100000)̃e[uvfɊ蓖Ă̂ŁA
 *   ubNAhX̑ƃe[uvfAhX̑
 *   tł邱ƂɒӂĂB
 */

//{{2018/07/22ύX:荞݃X^bNǉ܂B
//typedef struct _STACKINFO { /* clip/clippce.h(2004/12/29_)Q */
//	char signature[8];			/* + 0,8: VOl`"STACKINF"Œ */
//	/* VXeX^bN */
//	/* int* */ unsigned long sysstack_top;	/* + 8,4: 擪AhX */
//	/* int* */ unsigned long sysstack_end;	/* +12,4: I[AhX */
//	/* [U[X^bN */
//	/* int* */ unsigned long usrstack_top;	/* +16,4: 擪AhX */
//	/* int* */ unsigned long usrstack_end;	/* +20,4: I[AhX */
//	/* X^bN|C^ */
//	/* int* */ unsigned long ssp;		/* +24,4: VXeX^bN|C^ */
//	/* int* */ unsigned long usp;		/* +28,4: [U[X^bN|C^ */
//} STACKINFO;					/* =32 */
//2018/07/22ύX:荞݃X^bNǉ܂B
typedef struct _STACKINFO { /* clip/clippce.h(2018/07/22_)Q */
	char signature[8];			/* + 0,8: VOl`"STACKINF"Œ */
	/* VXeX^bN */
	/* int* */ unsigned long sysstack_top;	/* + 8,4: 擪AhX */
	/* int* */ unsigned long sysstack_end;	/* +12,4: I[AhX */
	/* [U[X^bN */
	/* int* */ unsigned long usrstack_top;	/* +16,4: 擪AhX */
	/* int* */ unsigned long usrstack_end;	/* +20,4: I[AhX */
	/* 荞݃X^bN */
	/* int* */ unsigned long intstack_top;	/* +24,4: 擪AhX */			//NULLȂ΁A荞݃X^bNBNULL,,NULLƂ܂B
	/* int* */ unsigned long intstack_end;	/* +28,4: I[AhX */			//NULLȂ΁A荞݃X^bNBЕNULLɂ鎖͂܂B
	/* X^bN|C^ */
	/* int* */ unsigned long ssp;		/* +32,4: VXeX^bN|C^ */
	/* int* */ unsigned long usp;		/* +36,4: [U[X^bN|C^ */
	/* int* */ unsigned long isp;		/* +40,4: 荞݃X^bN|C^ */		//intstack_endƓlƂ܂B
	/* int* */ unsigned long save_sp;	/* +44,4: 荞݃X^bN؂ւO%sp */	//NULLȂ΁A܂؂ւĂȂB
} STACKINFO;					/* =48 */
//}}2018/07/22ύX:荞݃X^bNǉ܂B

/****************************************************************************
 *	ϐ
 ****************************************************************************/

char opt_heap;			/* q[vo͂܂   */
char opt_block;			/* ubNo͂܂ */
char opt_total;			/* vo͂܂     */
char opt_stack;			/* X^bNo͂܂ */

char devno;			/* P/ECEfoCXԍ        */

SYSTEMINFO sysinfo;		/* VXe                       */
char* mem;			/* RAM+SRAMC[W               */
int mem_len;			/* RAM+SRAMTCY                 */
int heaptop_addr;		/* pceHeapAlloc()pq[v擪AhX */
unsigned long apphead_addr;	/* AvP[Vwb_AhX     */

/****************************************************************************
 *	֐錾
 ****************************************************************************/

void usage();
int mem_read();
unsigned long apphead_find();
unsigned long epson_heapinfo_find(unsigned long heapinfo_addr, unsigned long end_addr);
unsigned long clip_stackinfo_find(unsigned long stackinfo_addr, unsigned long end_addr);
void piece_heap_dump();
void epson_heap_dump(unsigned long heapinfo_addr);
void clip_stack_dump(unsigned long heapinfo_addr);

/****************************************************************************
 *	usage()
 ****************************************************************************/

void
usage()
{
	fprintf(stderr, "dmalloc - malloc dump utility (%s)\n", VERSION);
	fprintf(stderr, "Copyright (C) 2002-2018 Naoyuki Sawa\n");
	fprintf(stderr, "\n");
	fprintf(stderr, "USAGE: dmalloc [options] [devno]\n");
	fprintf(stderr, "    devno   P/ECEfoCXԍ\n");
	fprintf(stderr, "            ȗ́A#0iڂP/ECEjɐڑ܂B\n");
	fprintf(stderr, "\n");
	fprintf(stderr, "OPTIONS:\n");
	fprintf(stderr, "    -h      q[vo͂܂B\n");
	fprintf(stderr, "    -b      ubNo͂܂B\n");
	fprintf(stderr, "    -t      vo͂܂B\n");
	fprintf(stderr, "    -s      X^bNo͂܂B\n");
	fprintf(stderr, "    -hA-bA-tA-sw肵Ȃ΁ASo͂܂B\n");
	abort();
}

/****************************************************************************
 *	main
 ****************************************************************************/

int
main(int argc, char* argv[])
{
#define N_MAX	1024

	int retval, i, n;
	char* p;
	unsigned long addr, addrs[N_MAX];
	pceAPPHEAD* apphead;

	/* R}hĆB */
	for(i = 1; i < argc; i++) {
		p = argv[i];
		if(p[0] == '-') {
			/* IvVw */
			switch(p[1]) {
			case 'h':
				if(opt_heap) usage(); /* dw */
				opt_heap = 1;
				break;
			case 'b':
				if(opt_block) usage(); /* dw */
				opt_block = 1;
				break;
			case 't':
				if(opt_total) usage(); /* dw */
				opt_total = 1;
				break;
			case 's':
				if(opt_stack) usage(); /* dw */
				opt_stack = 1;
				break;
			default:
				usage();
			}
		} else {
			/* foCXԍw */
			devno = (char)strtol(p, &p, 10);
			if(*p != '\0') usage(); /* ȊO̕ŏI[ */
		}
	}
	/* o͑IĂȂ΁AׂďóB */
	if(!opt_heap && !opt_block && !opt_total) {
		opt_heap = opt_block = opt_total = opt_stack = 1;
	}

	/* RAM+SRAMC[Wǂݍ݂܂B */
	retval = mem_read();
	if(retval != 0) abort();

	/* AvP[Vwb_T܂B */
	apphead_addr = apphead_find();
	if(apphead_addr == 0) {
		fprintf(stderr, "AvPVwb_܂B\n");
		abort();
	}
	apphead = (pceAPPHEAD*)&mem[apphead_addr];

	/***** P/ECE APIpceHeapAlloc()pq[v *****/
	printf("\n"); /* s󂯂 */
	printf("#### P/ECE API pceHeapAlloc() Heap ###\n");

	/* q[v\܂B */
	piece_heap_dump();

	/***** EPSONCumalloc()pq[v *****/
	/* q[vT܂B */
	n = 0;
	addr = apphead_addr + sizeof(pceAPPHEAD); /* AvP[Vwb_̒ォ... */
	while(n < N_MAX) {
		addr = epson_heapinfo_find(addr, apphead->bss_end); /* ...BSSIAhX܂ */
		if(addr == 0) break;
		addrs[n++] = addr;
		addr += 4;
	}
	if(n) {
		printf("\n"); /* s󂯂 */
		printf("##### EPSON Library malloc() Heap ####\n");

		if(n != 1) {
			fprintf(stderr, "### xĨq[v񂪌܂B\n");
			/* p */
		}

		/* q[v\܂B */
		for(i = 0; i < n; i++) {
			if(n != 1) printf("\n### %d\n\n", i + 1);
			epson_heap_dump(addrs[i]);
		}
	} else {
		/* malloc()pq[vȂ(ansi_InitMalloc()Ă΂ĂȂ)ꍇ́A\܂B */
	}

	/***** CLiPCũX^bN *****/
	/* X^bNT܂B */
	if(opt_stack) {
		n = 0;
		addr = apphead_addr + sizeof(pceAPPHEAD); /* AvP[Vwb_̒ォ... */
		while(n < N_MAX) {
			addr = clip_stackinfo_find(addr, apphead->bss_end); /* ...BSSIAhX܂ */
			if(addr == 0) break;
			addrs[n++] = addr;
			addr += 4;
		}
		if(n) {
			printf("\n"); /* s󂯂 */
			printf("####### CLiP Library Stack Info ######\n");

			if(n != 1) {
				fprintf(stderr, "### xĨX^bN񂪌܂B\n");
				/* p */
			}

			/* X^bN\܂B */
			for(i = 0; i < n; i++) {
				if(n != 1) printf("\n### %d\n\n", i + 1);
				clip_stack_dump(addrs[i]);
			}
		} else {
			/* X^bN񂪖ꍇ́A\܂B
			 * X^bŃACLiP Library 2004/12/29 ȍ~̃AvP[VɗL܂B
			 */
		}
	}

	return 0;

#undef N_MAX
}

/****************************************************************************
 *	mem_read
 ****************************************************************************/

static int
ismAppPause(int pausef)
{
	unsigned char tmp[2];
	tmp[0] = 16;
	tmp[1] = (unsigned char)pausef;
	return ismCmdW(tmp, 2, 0, 0);
}

static int
ismLCDGetInfo(int* pstat, unsigned long* pbuff)
{
	int retval;
	unsigned char tmp[12];
	tmp[0] = 17;
	retval = ismCmdR(tmp, 1, tmp, 12);
	if(retval == 0) {
		if(pstat != NULL) *pstat = tmp[0];
		if(pbuff != NULL) *pbuff = *(unsigned long*)(tmp + 8);
	}
	return retval;
}

int
mem_read()
{
	int result, retval, ofs, len, stat, T0, T, dT;

	result = -1;

	/* P/ECEɐڑ܂B */
	retval = ismInitEx(devno, 0);
	if(retval != 0) {
		fprintf(stderr, "P/ECEɐڑł܂B\n");
		goto L10;
	}

	/* VXe擾܂B */
	retval = ismGetVersion(&sysinfo, 1);
	if(retval == PIECE_INVALID_VERSION) {
		fprintf(stderr, "VXe񂪎擾ł܂B\n");
		goto L20;
	}

	/* RAM+SRAMŜǂݍނ߂̃mۂ܂B */
	mem_len = sysinfo.sram_end > FRAM_END ?
	          sysinfo.sram_end : FRAM_END;
	mem = (char*)malloc(mem_len);
	if(mem == NULL) {
		fprintf(stderr, "słB\n");
		goto L20;
	}

	/* ǂݍݒɓeςȂ悤A|[Y܂B */
	retval = ismAppPause(1);
	if(retval != 0) {
		fprintf(stderr, "AvP[V܂B\n");
		goto L20;
	}

	/* AvP[VۂɃ|[YԂɂȂ܂ő҂܂B */
	T0 = GetTickCount();
	for(;;) {
		retval = ismLCDGetInfo(&stat, NULL);
		if(retval != 0) goto L30;
		if(stat) break;
		T = GetTickCount();
		dT = T - T0;
		if(dT >= 1000) goto L30; /* 1bŃ^CAEg */
//{{2018/07/22ǉ:AvP[VۂɃ|[YԂɂȂ܂ő҂AP/ECEɕׂ|߂āA^CAEgC܂B
		/* * Sun Jul 22 23:59:59 JST 2018 Naoyuki Sawa
		 * - AvP[VۂɃ|[YԂɂȂ܂ő҂AP/ECEɕׂ|߂āA^CAEgC܂B
		 *   c[쐬(2005N)PC͒x̂ŁAS͂ŉ񂵂Ăǂ̂łA
		 *   ŋ(2018N)̑PCƁA[v߂P/ECEւUSB荞ݕׂ߂܂B
		 *   ׂ߂ƁAP/ECẼ|[YԂւ̈ڍsxAc[^CAEgĂ܂܂B
		 *   L̖邽߂ɁA1~b̃EFCg鎖ɂ܂B
		 *   EFCgԂ͒\łA0ł͌ʂA1ŏ\ʂL̂ŁA1ɂ܂B
		 *   ȀĆA'Wed Jul 19 18:18:33 JST 2017 Naoyuki Sawa'ɁAUfeSvrɑ΂čŝƁȀCƂȂ܂B
		 *   ڍׂɂẮA/clip/tool/ufesvr/ufesvr.ćA'Wed Jul 19 18:18:33 JST 2017 Naoyuki Sawa'̃RgQƂĉB
		 */
		Sleep(1/**/); /* P/ECEɕׂ|߂Ȃ悤AEFCgB */
//}}2018/07/22ǉ:AvP[VۂɃ|[YԂɂȂ܂ő҂AP/ECEɕׂ|߂āA^CAEgC܂B
	}

	/* RAMǂݍ݂܂B
	 * x̎MTCY64KB肩瓮sɂȂXA
	 *   P/ECEnOAbv邱Ƃ̂ŁAM邱Ƃɂ܂B
	 *   oN]̈STCY4KBƕƂ̂ŁA4KBɂ܂B
	 */
	ofs = FRAM_TOP;
	while(ofs < FRAM_END) {
		len = FRAM_END - ofs;
		if(len > 0x1000) len = 0x1000; /* 4KB */
		retval = ismReadMem(mem + ofs, ofs, len);
		if(retval != 0) {
			fprintf(stderr, "RAM̓ǂݍ݂Ɏs܂B\n");
			goto L30;
		}
		ofs += len;
	}

	/* SRAMǂݍ݂܂B
	 * x̎MTCY64KB肩瓮sɂȂXA
	 *   P/ECEnOAbv邱Ƃ̂ŁAM邱Ƃɂ܂B
	 *   oN]̈STCY4KBƕƂ̂ŁA4KBɂ܂B
	 */
	ofs = sysinfo.sram_top;
	while(ofs < (int)sysinfo.sram_end) {
		len = sysinfo.sram_end - ofs;
		if(len > 0x1000) len = 0x1000; /* 4KB */
		retval = ismReadMem(mem + ofs, ofs, len);
		if(retval != 0) {
			fprintf(stderr, "SRAM̓ǂݍ݂Ɏs܂B\n");
			goto L30;
		}
		ofs += len;
	}

	/* pceHeapAlloc()pq[v擪AhX擾܂B */
	retval = ismHeapGetAdrs(&heaptop_addr);
	if(retval != 0) {
		fprintf(stderr, "pceHeapAlloc()pq[v擪AhX擾ł܂B\n");
		goto L30;
	}

	result = 0; /* ǂݍݐ */

L30:
	/* |[Y܂B */
	ismAppPause(0);
L20:
	/* P/ECEؒf܂B */
	ismExit();
L10:
	return result;
}

/****************************************************************************
 *	apphead_find
 ****************************************************************************/

unsigned long
apphead_find()
{
	unsigned long addrs[] = { APPSTARTPOS1, APPSTARTPOS2 };
	unsigned long addr;
	int i;
	pceAPPHEAD* apphead;

	for(i = 0; i < sizeof addrs / sizeof *addrs; i++) {
		addr = addrs[i];
		if(addr < sysinfo.sram_top || sysinfo.sram_end < addr + sizeof(pceAPPHEAD)) continue; /* wb_SRAM͂ݏoĂ */
		apphead = (pceAPPHEAD*)&mem[addr];

		if(apphead->signature != 0) continue; /* VOl`NAĂȂ */
		if(apphead->sysver == 0) continue; /* VXeo[Wݒ肳ĂȂ */
		if(apphead->bss_end < sysinfo.sram_top || sysinfo.sram_end < apphead->bss_end) continue; /* BSSIAhXSRAMO */

		/* eGg|CǵA߂̂PoCgڂwĂ̂ŁAn[t[hACgĂ͂B
		 * ܂Asrft@C̃ZNVzúA{ pceAPPHEAD`codeZNV`dataZNV`bssZNV`bss_end } Ȃ̂ŁA
		 * eGg|CǵAȂƂApceAPPHEAD̒ォbss_end̊Ԃɂ͂łB
		 * ȏA̏Al̃Gg|Cgɑ΂Č܂B
		 */
		if(apphead->initialize    & 1 || apphead->initialize    < addr + sizeof(pceAPPHEAD) || apphead->bss_end <= apphead->initialize   ) continue;
		if(apphead->periodic_proc & 1 || apphead->periodic_proc < addr + sizeof(pceAPPHEAD) || apphead->bss_end <= apphead->periodic_proc) continue;
		if(apphead->pre_terminate & 1 || apphead->pre_terminate < addr + sizeof(pceAPPHEAD) || apphead->bss_end <= apphead->pre_terminate) continue;
		if(apphead->notify_proc   & 1 || apphead->notify_proc   < addr + sizeof(pceAPPHEAD) || apphead->bss_end <= apphead->notify_proc  ) continue;

		/* APPSTARTPOS1LȂAAPPSTARTPOS2ׂ͒܂Bʏ̃AvP[V́AAPPSTARTPOS1Ńqbg͂łB
		 * APPSTARTPOS2gĂ̂͂̃X^[gAbvVFŁAmalloc()gĂ܂B
		 * ʏ̃AvP[VAPPSTARTPOS2𒲂ׂĂAԈăS~Ƀqbg邾Ǝv܂B
		 */
		return addr;
	}

	return 0;
}

/****************************************************************************
 *	epson_heapinfo_find
 ****************************************************************************/

unsigned long
epson_heapinfo_find(unsigned long heapinfo_addr, unsigned long end_addr)
{
	int i;
	unsigned long blktbl_addr;
	unsigned long ptr;
	HEAPINFO hi;
	BLKTBL bt;

	for( ; heapinfo_addr <= end_addr - sizeof(HEAPINFO); heapinfo_addr += 4) {
		memcpy(&hi, &mem[heapinfo_addr], sizeof(HEAPINFO));

		/***** HEAPINFOPƂ̌ *****/

		if(hi.start_alloc & 3) continue; /* q[vJnAhX̃ACgG[ */
		if(hi.nxt_alc_p & 3) continue;   /* 󂫗̈擪AhX̃ACgG[ */
		if(hi.tbl_ptr & 3) continue;     /* 蓖ăe[u擪AhX̃ACgG[ */
		if(hi.end_alloc & 3) continue;   /* q[vIAhX̃ACgG[ */

		if(hi.start_alloc < sysinfo.sram_top) continue; /* SRAM擪`q[v擪   */
		if(hi.start_alloc > hi.nxt_alc_p) continue;     /*         `󂫗̈擪 */
		if(hi.nxt_alc_p > hi.tbl_ptr) continue;         /*         `e[u擪 */
		if(hi.tbl_ptr > hi.end_alloc) continue;         /*         `IAhX */
		if(hi.end_alloc > sysinfo.sram_end) continue;   /*         `SRAMI[ ̏ł邱 */

		if(hi.tbl_ptr != hi.end_alloc - sizeof(BLKTBL) * (hi.row + 1)) continue; /* u萔E^vZNṼRgQ */

		/* * HEAPINFOPƂ̌ŁAĂA͂Pɍi܂B
		 *   ̃ubN蓖ĂĂقǁÅm͍Ȃ܂A
		 *   ۂɂ́Aansi_InitMalloc()ŏłAP̐܂B
		 * * Ô߁AāAubNe[ǔsƂɂ܂B
		 */

		/***** BLKTBĽ *****/

		ptr = hi.start_alloc; /* ŏ̃ubN̓q[v擪ɂ͂ */
		for(i = 0; i < (int)hi.row; i++) {
			blktbl_addr = hi.end_alloc - sizeof(BLKTBL) * (i + 1);
			memcpy(&bt, &mem[blktbl_addr], sizeof(BLKTBL));
			if(bt.ptr != ptr) break; /* ÕubNƘAĂȂ     */
			if(bt.len & 3) break;    /* 蓖ĒPʂ̃ACgG[ */
			ptr += bt.len;           /* ̃ubNAhX߂Ă */
			if(ptr < hi.start_alloc || hi.end_alloc < ptr) break; /* ubNTCYG[ */
			/* ptr.use͌Ă͂܂BgpubNA邱Ƃ͂肦܂B
			 * AgpubN̂́Ał͂ȂA4A炢̎ɍs悤łB
			 */
		}
		if(i != (int)hi.row) continue; /* ubN̓rŌs */

		return heapinfo_addr; /* ̃q[v͐ */
	}

	return 0; /* Ȃ */
}

/****************************************************************************
 *	clip_stackinfo_find
 ****************************************************************************/

unsigned long
clip_stackinfo_find(unsigned long stackinfo_addr, unsigned long end_addr)
{
	STACKINFO si;

	for( ; stackinfo_addr <= end_addr - sizeof(STACKINFO); stackinfo_addr += 4) {
		memcpy(&si, &mem[stackinfo_addr], sizeof(STACKINFO));

		/***** STACKINFOPƂ̌ *****/

		if(memcmp(si.signature, "STACKINF", 8) != 0) continue;	/* VOl`G[ */
		if(si.sysstack_top & 3) continue;			/* VXeX^bN擪AhX̃ACgG[ */
		if(si.sysstack_end & 3) continue;			/* VXeX^bNI[AhX̃ACgG[ */
		if(si.usrstack_top & 3) continue;			/* [U[X^bN擪AhX̃ACgG[ */
		if(si.usrstack_end & 3) continue;			/* [U[X^bNI[AhX̃ACgG[ */
//{{2018/07/22ǉ:荞݃X^bNǉ܂B
		if(si.intstack_top & 3) continue;			/* 荞݃X^bN擪AhX̃ACgG[ */
		if(si.intstack_end & 3) continue;			/* 荞݃X^bNI[AhX̃ACgG[ */
//}}2018/07/22ǉ:荞݃X^bNǉ܂B
		if(si.ssp & 3) continue;				/* [U[X^bN|C^̃ACgG[ */
		if(si.usp & 3) continue;				/* [U[X^bN|C^̃ACgG[ */
//{{2018/07/22ǉ:荞݃X^bNǉ܂B
		if(si.isp & 3) continue;				/* 荞݃X^bN|C^̃ACgG[ */
//}}2018/07/22ǉ:荞݃X^bNǉ܂B

#if 0
//		if((FRAM_TOP <= si.sysstack_top &&		/* RAM擪`VXeX^bN擪     */
//		    si.sysstack_top <= si.ssp &&		/*            `VXeX^bN|C^ */
//		    si.ssp <= si.sysstack_end &&		/*            `VXeX^bNI[     */
//		    si.sysstack_end <= FRAM_END)		/*            `RAMI[       ܂ */
//		|| (sysinfo.sram_top <= si.sysstack_top &&	/* SRAM擪   `VXeX^bN擪     */
//		    si.sysstack_top <= si.ssp &&		/*            `VXeX^bN|C^ */
//		    si.ssp <= si.sysstack_end &&		/*            `VXeX^bNI[     */
//		    si.sysstack_end <= sysinfo.sram_end)) {	/*            `SRAMI[          Ȃ */
//			/** no job **/				/* p                                  */
//		} else {					/*                            Ȃ */
//			continue;				/* G[                                */
//		}
//
//		if((FRAM_TOP <= si.usrstack_top &&		/* RAM擪`[U[X^bN擪     */
//		    si.usrstack_top <= si.usp &&		/*            `[U[X^bN|C^ */
//		    si.usp <= si.usrstack_end &&		/*            `[U[X^bNI[     */
//		    si.usrstack_end <= FRAM_END)		/*            `RAMI[       ܂ */
//		|| (sysinfo.sram_top <= si.usrstack_top &&	/* SRAM擪   `[U[X^bN擪     */
//		    si.usrstack_top <= si.usp &&		/*            `[U[X^bN|C^ */
//		    si.usp <= si.usrstack_end &&		/*            `[U[X^bNI[     */
//		    si.usrstack_end <= sysinfo.sram_end)) {	/*            `SRAMI[          Ȃ */
//			/** no job **/				/* p                                  */
//		} else {					/*                            Ȃ */
//			continue;				/* G[                                */
//		}
#else //2005/01/05 X^bNFRAM4̈֐ؑւ܂yield()ꍇ̂ŁAsspAusp̌O܂B
		if((FRAM_TOP <= si.sysstack_top &&		/* RAM擪`VXeX^bN擪     */
		    si.sysstack_top  <= si.sysstack_end &&	/*            `VXeX^bNI[     */
		    si.sysstack_end  <= FRAM_END)		/*            `RAMI[       ܂ */
		|| (sysinfo.sram_top <= si.sysstack_top &&	/* SRAM擪   `VXeX^bN擪     */
		    si.sysstack_top  <= si.sysstack_end &&	/*            `VXeX^bNI[     */
		    si.sysstack_end  <= sysinfo.sram_end)) {	/*            `SRAMI[          Ȃ */
			/** no job **/				/* p                                  */
		} else {					/*                            Ȃ */
			continue;				/* G[                                */
		}

		if((FRAM_TOP <= si.usrstack_top &&		/* RAM擪`[U[X^bN擪     */
		    si.usrstack_top  <= si.usrstack_end &&	/*            `[U[X^bNI[     */
		    si.usrstack_end  <= FRAM_END)		/*            `RAMI[       ܂ */
		|| (sysinfo.sram_top <= si.usrstack_top &&	/* SRAM擪   `[U[X^bN擪     */
		    si.usrstack_top  <= si.usrstack_end &&	/*            `[U[X^bNI[     */
		    si.usrstack_end  <= sysinfo.sram_end)) {	/*            `SRAMI[          Ȃ */
			/** no job **/				/* p                                  */
		} else {					/*                            Ȃ */
			continue;				/* G[                                */
		}

//{{2018/07/22ǉ:荞݃X^bNǉ܂B
	    if(si.intstack_top || si.intstack_end) {		/* 荞݃X^bNLȂ΁c          */
		if((FRAM_TOP <= si.intstack_top &&		/* RAM擪`荞݃X^bN擪     */
		    si.intstack_top  <= si.intstack_end &&	/*            `荞݃X^bNI[     */
		    si.intstack_end  <= FRAM_END)		/*            `RAMI[       ܂ */
		|| (sysinfo.sram_top <= si.intstack_top &&	/* SRAM擪   `荞݃X^bN擪     */
		    si.intstack_top  <= si.intstack_end &&	/*            `荞݃X^bNI[     */
		    si.intstack_end  <= sysinfo.sram_end)) {	/*            `SRAMI[          Ȃ */
			/** no job **/				/* p                                  */
		} else {					/*                            Ȃ */
			continue;				/* G[                                */
		}
	    }
//}}2018/07/22ǉ:荞݃X^bNǉ܂B
#endif

		return stackinfo_addr; /* ̃X^bN͐ */
	}

	return 0; /* Ȃ */
}

/****************************************************************************
 *	piece_heap_dump
 ****************************************************************************/

void
piece_heap_dump()
{
	int i;
	unsigned long phm;
	unsigned long len;
	unsigned long free_cnt = 0;
	unsigned long free_sum = 0;
	unsigned long free_max = 0;
	unsigned long free_min = 0;
	unsigned long user_cnt = 0;
	unsigned long user_sum = 0;
	unsigned long user_max = 0;
	unsigned long user_min = 0;
	unsigned long system_cnt = 0;
	unsigned long system_sum = 0;
	unsigned long system_max = 0;
	unsigned long system_min = 0;
	unsigned long unknown_cnt = 0;
	unsigned long unknown_sum = 0;
	unsigned long unknown_max = 0;
	unsigned long unknown_min = 0;
	HEAPMEM hm;

	/***** q[v̕\ *****/

	if(opt_heap) {
		printf("============= q[v =============\n");
		printf("--------: heaptop           = %08x\n", heaptop_addr);
	}

	/***** ubN̕\ *****/

	if(opt_block) {
		printf("============ ubN ============\n");
		printf("Index     Address   Size      Status  \n");
	}
	phm = heaptop_addr;
	i = 0;
	for(;;) {
		/* ubN擾܂B */
		if(phm < sysinfo.sram_top || phm + sizeof(HEAPMEM) > sysinfo.sram_end) { /* O */
			fprintf(stderr, "### Heap broken !!\n");
			break;
		}
		memcpy(&hm, &mem[phm], sizeof(HEAPMEM));
		if(hm.mark != HEAPMEMMK) { /* VOl`s */
			fprintf(stderr, "### Heap broken !!\n");
			break;
		}
		if(!hm.chain) break;
		len = hm.chain - (phm + sizeof(HEAPMEM));
		if((long)len < 0) { /* TCYs */
			fprintf(stderr, "### Heap broken !!\n");
			break;
		}

		/* ubN\AvW܂B */
		switch(hm.owner) {
		case 0:
			if(opt_block) printf("%08x  %08x  %08x  %-8s\n", i, phm + sizeof(HEAPMEM), len, "FREE");
			free_cnt++;
			free_sum += len;
			if(free_cnt == 1 || len > free_max) free_max = len;
			if(free_cnt == 1 || len < free_min) free_min = len;
			break;
		case HMO_DEFAULT_USER:
			if(opt_block) printf("%08x  %08x  %08x  %-8s\n", i, phm + sizeof(HEAPMEM), len, "USER");
			user_cnt++;
			user_sum += len;
			if(user_cnt == 1 || len > user_max) user_max = len;
			if(user_cnt == 1 || len < user_min) user_min = len;
			break;
		case HMO_SYSTEM:
			if(opt_block) printf("%08x  %08x  %08x  %-8s\n", i, phm + sizeof(HEAPMEM), len, "SYSTEM");
			system_cnt++;
			system_sum += len;
			if(system_cnt == 1 || len > system_max) system_max = len;
			if(system_cnt == 1 || len < system_min) system_min = len;
			break;
		default:
			if(opt_block) printf("%08x  %08x  %08x  (%04x)\n", i, phm + sizeof(HEAPMEM), len, hm.owner);
			unknown_cnt++;
			unknown_sum += len;
			if(unknown_cnt == 1 || len > unknown_max) unknown_max = len;
			if(unknown_cnt == 1 || len < unknown_min) unknown_min = len;
			break;
		}

		/* ̃ubNցB */
		phm = hm.chain;
		i++;
	}

	/***** v̕\ *****/

	if(opt_total) {
		printf("============== v ==============\n");
		printf("               ŏ   ő   v \n");
		printf("USERubN %4d %6d %6d %6d\n", user_cnt,    user_min,    user_max,    user_sum   );
		printf("FREEubN %4d %6d %6d %6d\n", free_cnt,    free_min,    free_max,    free_sum   );
		if(system_cnt) {
			printf("SYSTEMubN%3d %6d %6d %6d\n", system_cnt,  system_min,  system_max,  system_sum );
		}
		if(unknown_cnt) {
			printf("subN %4d %6d %6d %6d\n", unknown_cnt, unknown_min, unknown_max, unknown_sum);
		}
	}
}

/****************************************************************************
 *	epson_heap_dump
 ****************************************************************************/

void
epson_heap_dump(unsigned long heapinfo_addr)
{
	int i;
	unsigned long blktbl_addr;
	unsigned long heap_mem = 0;
	unsigned long extd_mem = 0;
	unsigned long used_cnt = 0;
	unsigned long used_sum = 0;
	unsigned long used_max = 0;
	unsigned long used_min = 0;
	unsigned long free_cnt = 0;
	unsigned long free_sum = 0;
	unsigned long free_max = 0;
	unsigned long free_min = 0;
	HEAPINFO hi;
	BLKTBL bt;

	/***** q[v̕\ *****/

	memcpy(&hi, &mem[heapinfo_addr], sizeof(HEAPINFO));
	if(opt_heap) {
		printf("============= q[v =============\n");
		printf("%08x: ansi_ucStartAlloc = %08x\n", heapinfo_addr +  0, hi.start_alloc);
		printf("%08x: ansi_ucEndAlloc   = %08x\n", heapinfo_addr +  4, hi.end_alloc  );
		printf("%08x: ansi_ucNxtAlcP    = %08x\n", heapinfo_addr +  8, hi.nxt_alc_p  );
		printf("%08x: ansi_ucTblPtr     = %08x\n", heapinfo_addr + 12, hi.tbl_ptr    );
		printf("%08x: ansi_ulRow        = %08x\n", heapinfo_addr + 16, hi.row        );
	}

	/***** ubN̕\ *****/

	if(opt_block) {
		printf("============ ubN ============\n");
		printf("Index     Address   Size      Status  \n");
	}
	for(i = 0; i < (int)hi.row; i++) {
		blktbl_addr = hi.end_alloc - sizeof(BLKTBL) * (i + 1);
		memcpy(&bt, &mem[blktbl_addr], sizeof(BLKTBL));
		if(opt_block) {
			printf("%08x  %08x  %08x  %-8s\n", i, bt.ptr, bt.len, bt.use ? "USE" : "FREE");
		}

		/* v̎WB */
		if(bt.use) {
			used_cnt++;
			used_sum += bt.len;
			if(used_cnt == 1 || bt.len > used_max) used_max = bt.len;
			if(used_cnt == 1 || bt.len < used_min) used_min = bt.len;
		} else {
			free_cnt++;
			free_sum += bt.len;
			if(free_cnt == 1 || bt.len > free_max) free_max = bt.len;
			if(free_cnt == 1 || bt.len < free_min) free_min = bt.len;
		}
	}

	/***** v̕\ *****/

	/* q[v̈TCY߂܂B */
	heap_mem = hi.end_alloc - hi.start_alloc;

	/* gp̈TCY߂܂B
	 * * gp̈悩犄\ȍőubNTCÝAgp̈TCY-8oCg܂łłB
	 *   VubN蓖Ă邽߂ɁAe[ugp8oCg]vɕKvłB
	 * * ̃vÓA\TCY\̂ړIł͂ȂA
	 *   PɃubNTCY\̂ړIȂ̂ŁA8oCg͍lȂƂɂ܂B
	 */
	extd_mem = hi.tbl_ptr - hi.nxt_alc_p/* - 8*/;

	if(opt_total) {
		printf("============== v ==============\n");
		printf("               ŏ   ő   v \n");
		printf(" q[v̈   --    --     --   %6d\n", heap_mem);
		printf(" gp̈   --    --     --   %6d\n", extd_mem);
		printf("gpubN %4d %6d %6d %6d\n", used_cnt, used_min, used_max, used_sum);
		printf("󂫃ubN %4d %6d %6d %6d\n", free_cnt, free_min, free_max, free_sum);
	}
}

/****************************************************************************
 *	clip_stack_dump
 ****************************************************************************/

void
clip_stack_dump(unsigned long heapinfo_addr)
{
	STACKINFO si;
	int top;
	int end;
	int pos;
	int len;
	int use;
	int per;

	memcpy(&si, &mem[heapinfo_addr], sizeof(STACKINFO));

	printf("========= X^bNCAEg =========\n");
//{{2018/07/22ύX:荞݃X^bNǉ܂B
//	printf("%08x: sysstack_top      = %08x\n", heapinfo_addr +  8, si.sysstack_top);
//	printf("%08x: sysstack_end      = %08x\n", heapinfo_addr + 12, si.sysstack_end);
//	printf("%08x: usrstack_top      = %08x\n", heapinfo_addr + 16, si.usrstack_top);
//	printf("%08x: usrstack_end      = %08x\n", heapinfo_addr + 20, si.usrstack_end);
//	printf("%08x: ssp               = %08x\n", heapinfo_addr + 24, si.ssp);
//	printf("%08x: usp               = %08x\n", heapinfo_addr + 28, si.usp);
//2018/07/22ύX:荞݃X^bNǉ܂B
	printf("%08x: sysstack_top      = %08x\n", heapinfo_addr +  8, si.sysstack_top);
	printf("%08x: sysstack_end      = %08x\n", heapinfo_addr + 12, si.sysstack_end);
	printf("%08x: usrstack_top      = %08x\n", heapinfo_addr + 16, si.usrstack_top);
	printf("%08x: usrstack_end      = %08x\n", heapinfo_addr + 20, si.usrstack_end);
	printf("%08x: intstack_top      = %08x\n", heapinfo_addr + 24, si.intstack_top);
	printf("%08x: intstack_end      = %08x\n", heapinfo_addr + 28, si.intstack_end);
	printf("%08x: ssp               = %08x\n", heapinfo_addr + 32, si.ssp);
	printf("%08x: usp               = %08x\n", heapinfo_addr + 36, si.usp);
	printf("%08x: isp               = %08x\n", heapinfo_addr + 40, si.isp);
//}}2018/07/22ύX:荞݃X^bNǉ܂B

	printf("========== gpoCg ==========\n");
	printf("                 gp   e    \n");
	/* VXeX^bN */
	top = si.sysstack_top;
	end = si.sysstack_end;
	len = end - top;
	for(pos = top; pos < end; pos += sizeof(int)) {
		if(*(int*)&mem[pos] != pos) break;
	}
	use = end - pos;
	per = len ? use * 100 / len : 0;
	printf("VXeX^bN %6d / %6d (%3d)\n", use, len, per);
	/* [U[X^bN */
	top = si.usrstack_top;
	end = si.usrstack_end;
	len = end - top;
	for(pos = top; pos < end; pos += sizeof(int)) {
		if(*(int*)&mem[pos] != pos) break;
	}
	use = end - pos;
	per = len ? use * 100 / len : 0;
	printf("[U[X^bN %6d / %6d (%3d)\n", use, len, per);
//{{2018/07/22ǉ:荞݃X^bNǉ܂B
	/* 荞݃X^bN */
	top = si.intstack_top;
	end = si.intstack_end;
	len = end - top;
	for(pos = top; pos < end; pos += sizeof(int)) {
		if(*(int*)&mem[pos] != pos) break;
	}
	use = end - pos;
	per = len ? use * 100 / len : 0;
	printf("荞݃X^bN %6d / %6d (%3d)\n", use, len, per);
//}}2018/07/22ǉ:荞݃X^bNǉ܂B
}

