#include "winapp.h"
//-----------------------------------------------------------------------------
void* Bitmap_Load(const char* path) {
	wchar_t* wPath = strdup_ShiftJisToUnicode(path);
	Gdiplus::Bitmap* bitmap = new Gdiplus::Bitmap(wPath);
	if(bitmap->GetLastStatus()) {
		delete bitmap;
		bitmap = NULL;
	}
	free(wPath);
	return bitmap;
}
//-----------------------------------------------------------------------------
void Bitmap_Free(void* _bitmap) {
	Gdiplus::Bitmap* bitmap = (Gdiplus::Bitmap*)_bitmap;
	delete bitmap;
}
//-----------------------------------------------------------------------------
int Bitmap_GetWidth(void* _bitmap) {
	Gdiplus::Bitmap* bitmap = (Gdiplus::Bitmap*)_bitmap;
	int w = bitmap->GetWidth();
	if(bitmap->GetLastStatus()) { return -1; }
	return w;
}
//-----------------------------------------------------------------------------
int Bitmap_GetHeight(void* _bitmap) {
	Gdiplus::Bitmap* bitmap = (Gdiplus::Bitmap*)_bitmap;
	int h = bitmap->GetHeight();
	if(bitmap->GetLastStatus()) { return -1; }
	return h;
}
//-----------------------------------------------------------------------------
int Bitmap_GetPixel(void* _bitmap, int x, int y, int* r, int* g, int* b, int* a) {
	Gdiplus::Bitmap* bitmap = (Gdiplus::Bitmap*)_bitmap;
	Gdiplus::Color c;
	if(bitmap->GetPixel(x, y, &c)) { return -1; }
	if(r) { *r = c.GetRed(); }
	if(g) { *g = c.GetGreen(); }
	if(b) { *b = c.GetBlue(); }
	if(a) { *a = c.GetAlpha(); }
	return 0;
}
