/*
 *	app.c
 *
 *	dSnrSeqS.exe - ViIV[PTV~[^
 *	Copyright (C) 2017-2018 Naoyuki Sawa
 *
 *	* Sun Nov 05 23:33:59 JST 2017 Naoyuki Sawa
 *	- 1st [XB
 *	* Tue Nov 07 23:58:59 JST 2017 Naoyuki Sawa
 *	- ꎞtH_̎擾ɁAGetTempPath()ĝ߂āATMP,,TEMPϐ𒼐ڎQƂ悤ɕύX܂B
 *	  ŔAGetTempPath()WindowstH_Ԃ\L邩łB
 *	  QƎ:uWindows Dev Center - GetTempPath functionv(https://msdn.microsoft.com/en-us/library/windows/desktop/aa364992(v=vs.85).aspx)
 *	  Remarks
 *	  The GetTempPath function checks for the existence of environment variables in the following order and uses the first path found:
 *	  1. The path specified by the TMP environment variable.
 *	  2. The path specified by the TEMP environment variable.
 *	  3. The path specified by the USERPROFILE environment variable.
 *	  4. The Windows directory.	!!
 *	  ȂGetTempPath()WindowstH_Ԃ悤ȎdlɂȂĂ̂słAۂɎĂ݂mɂɂȂĂ悤łB
 *	  ̓Iɂ́ATMP,TEMP,USERPROFILEϐ𖢒`ɂGetTempPath()sƁA"C:\WINDOWS\"Ԃ܂B
 *	  GetTempPath()MpƁAWindowstH_Ɉꎞt@CɃS~t@CĂ܂ꂪAǂ܂B
 *	  ŁAGetTempPath()ĝ߂āATMP,,TEMPϐ𒼐ڎQƂāAꎞtH_擾鎖ɂ܂B
 *	  AUSERPROFILE("C:\Users\[U[\")ꎞtH_ƂēK؂ł͂ȂƎv̂ŁAUSERPROFILEQƂȂɂ܂B
 *	  TMPTEMPUSERPROFILE`ĂȂꍇ́AJgtH_gp鎖ɂ܂B
 *	* Thu Nov 09 23:57:54 JST 2017 Naoyuki Sawa
 *	- G[܂B
 *	  ܂ł́AG[ɑADIE()ŏIĂ̂łATclXNvg̃G[h肪L܂B
 *	  ŁAɗ́ATcl̃G[ƂĒʒm悤ɕύX܂B
 *	  TclXNvgcatch߂gĕߑ鎖o܂AߑȂꍇł܂łՂG[bZ[W\ďI܂B
 *	* Tue Nov 14 23:59:59 JST 2017 Naoyuki Sawa
 *	- /clip/cliptcl.c W[XVɔAc[rh܂B
 *	  c[̃\[X́AύXĂ܂B
 *	  ڍׂ́A/clip/cliptcl.c W[́ÃRgQƂĉB
 *	* Thu Nov 16 23:42:50 JST 2017 Naoyuki Sawa
 *	- /clip/cliptcl.c W[XVɔAc[rh܂B
 *	  c[̃\[X́AύXĂ܂B
 *	  ڍׂ́A/clip/cliptcl.c W[́ÃRgQƂĉB
 *	* Sat Nov 18 23:37:58 JST 2017 Naoyuki Sawa
 *	- /clip/cliptcl.c W[XVɔAc[rh܂B
 *	  c[̃\[X́AύXĂ܂B
 *	  ڍׂ́A/clip/cliptcl.c W[́ÃRgQƂĉB
 *	* Sun Nov 19 22:01:55 JST 2017 Naoyuki Sawa
 *	- /clip/cliptcl.c W[XVɔAc[rh܂B
 *	  c[̃\[X́AύXĂ܂B
 *	  ڍׂ́A/clip/cliptcl.c W[́ÃRgQƂĉB
 *	* Tue Nov 21 23:59:59 JST 2017 Naoyuki Sawa
 *	- /clip/clipsnrs.c W[XVɔAc[rh܂B
 *	  c[̃\[X́AύXĂ܂B
 *	  ڍׂ́A/clip/clipsnrs.c W[́ÃRgQƂĉB
 *	* Sat Nov 25 23:56:03 JST 2017 Naoyuki Sawa
 *	- '-q'IvVǉ܂B
 *	* Sat Apr 07 23:59:59 JST 2018 Naoyuki Sawa
 *	- 'blob_read_ber'R}hǉ܂B
 *	* Thu May 03 23:59:59 JST 2018 Naoyuki Sawa
 *	- Boehm GCCɔAc[rh܂B
 *	  ڍׂ́A/clip/tool/gc/README.TXT'Wed May 02 23:59:59 JST 2018 Naoyuki Sawa'̃RgQƂĉB
 */
#include "app.h"
#define VERSION		"20180503"	//ŏIXV
#include "app.h"
/****************************************************************************
 *	[J֐錾
 ****************************************************************************/
static int SehErrMsg();
static void CheckArgc(int n);
static int GetInt(const char* s, int lo, int hi);
static int GetSnrTblNo(const char* pTableName);
static int GetTrigNo(const char* pTrigName);
static const char* GetFuncName(int iSnrFnc);
/*--------------------------------------------------------------------------*/
static int AddressList_CompareFunc(const void* pAddress, const char* pName);
static char* AddressList_Register(void* pAddress);
static void* AddressList_Lookup(char* pName);
static void AddressList_Unregister(void* pAddress);
/*--------------------------------------------------------------------------*/
static int fnSnrSeq(struct _ST_SnrSeq* pSnrSeq, int iCh, int iSnrFnc, struct blob_reader* pArgs);
/*--------------------------------------------------------------------------*/
static int SnrSeq_NewCmd(Tcl_Interp* iPtr);
static int SnrSeq_InitCmd(Tcl_Interp* iPtr);
static int SnrSeq_FreeCmd(Tcl_Interp* iPtr);
static int SnrSeq_ExecCmd(Tcl_Interp* iPtr);
static int SnrSeqCh_ExecCmd(Tcl_Interp* iPtr);
static int SnrSeq_ClrTblCmd(Tcl_Interp* iPtr);
static int SnrSeqCh_SetTblCmd(Tcl_Interp* iPtr);
static int SnrSeq_SendTrigCmd(Tcl_Interp* iPtr);
static int SnrSeqCh_SendTrigCmd(Tcl_Interp* iPtr);
static int SnrSeq_UnlockCmd(Tcl_Interp* iPtr);
static int SnrSeqCh_UnlockCmd(Tcl_Interp* iPtr);
static int SnrSeq_StopCmd(Tcl_Interp* iPtr);
static int SnrSeqCh_StopCmd(Tcl_Interp* iPtr);
static int SnrSeq_GetStatCmd(Tcl_Interp* iPtr);
static int SnrSeqCh_GetStatCmd(Tcl_Interp* iPtr);
static int SnrSeqCh_SetTblNoCmd(Tcl_Interp* iPtr);
/*--------------------------------------------------------------------------*/
static int blob_reader_initCmd(Tcl_Interp* iPtr);
static int blob_read_bitCmd(Tcl_Interp* iPtr);
static int blob_read_byteCmd(Tcl_Interp* iPtr);
static int blob_read_halfCmd(Tcl_Interp* iPtr);
static int blob_read_exp10Cmd(Tcl_Interp* iPtr);
static int blob_read_wordCmd(Tcl_Interp* iPtr);
static int blob_read_berCmd(Tcl_Interp* iPtr);		//{{2018/04/07ǉ:'blob_read_ber'R}hǉ܂B}}
static int blob_read_fp16Cmd(Tcl_Interp* iPtr);
static int blob_read_fp32Cmd(Tcl_Interp* iPtr);
static int blob_read_fp64Cmd(Tcl_Interp* iPtr);
static int blob_read_stringCmd(Tcl_Interp* iPtr);
static int blob_read_dataCmd(Tcl_Interp* iPtr);
static int blob_copy_dataCmd(Tcl_Interp* iPtr);
static int blob_reader_get_bitsCmd(Tcl_Interp* iPtr);	//tB[hANZXp
static int blob_reader_get_posCmd(Tcl_Interp* iPtr);	//tB[hANZXp
static int blob_reader_set_posCmd(Tcl_Interp* iPtr);	//tB[hANZXp
/****************************************************************************
 *	main
 ****************************************************************************/
int main(int argc, char* argv[]) {
	int exitCode = EXIT_SUCCESS;
#ifdef  _DEBUG
	remove("syslog.out");			//񃍃O폜鎖ɂB
    #ifndef USE_JOB_DEBUG
	openlog(NULL, LOG_PERROR, LOG_USER);	//fobOrhł́AVXeOWG[ɂo͂BAfobOWugpꍇ́AfobOWucurses\ƏՓ˂Ȃ悤AWG[ɂ͏o͂ȂB
    #endif//USE_JOB_DEBUG
#else //_DEBUG
	setlogmask(LOG_UPTO(LOG_INFO));		//[Xrhł́ALOG_DEBUG}B
#endif//_DEBUG
#if     (defined(GC_H) && !defined(USE_BISON_FLEX))
//	putenv("GC_LOG_FILE=CON");//Oo͐w肷B
//	GC_set_find_leak(1);//[NoJnB
#endif//(defined(GC_H) && !defined(USE_BISON_FLEX))
#ifdef  __CLIP_SEH_H__
	SEH_init();
#endif//__CLIP_SEH_H__
	app_init(argc, argv);
	exitCode = app_main(argc, argv);
	app_exit();
#if     (defined(GC_H) && !defined(USE_BISON_FLEX))
//	CHECK_LEAKS();//[NoB
#endif//(defined(GC_H) && !defined(USE_BISON_FLEX))
	return exitCode;
}
/****************************************************************************
 *	usage
 ****************************************************************************/
__declspec(noreturn) static void usage() {
	fprintf(stderr, "dSnrSeqS.exe - ViIV[PTV~[^ (%s)\n", VERSION);
	fprintf(stderr, "Copyright (C) 2017-2018 Naoyuki Sawa\n");
	fprintf(stderr, "\n");
	fprintf(stderr, "OPTIONS:\n");
	fprintf(stderr, "  -q  i\}܂B\n");
	fprintf(stderr, "  -h  g\܂B\n");
	fprintf(stderr, "\n");
	fprintf(stderr, "USAGE:\n");
	fprintf(stderr, "  @dSnrSeqS.exe ViIt@C.bin hCot@C.tcl [ ...]\n");
	fprintf(stderr, "    'ViIt@C.bin'ǂݍ݁AhCot@C.tclŎs܂B\n");
	fprintf(stderr, "  AdSnrSeqS.exe ViIt@C.txt hCot@C.tcl [ ...]\n");
	fprintf(stderr, "    'ViIt@C.txt'ϊA'ViIt@C.bin'𐶐܂B\n");
	fprintf(stderr, "    'ViIt@C.bin'ǂݍ݁AhCot@C.tclŎs܂B\n");
	fprintf(stderr, "  ViIt@C̊gq'.bin'ȊOȂΑSāAA̓ƂȂ܂B\n");
	exit(EXIT_FAILURE);
}
/****************************************************************************
 *	
 ****************************************************************************/
void app_init(int argc, char* argv[]) {
//{{AvP[VL̏
	{
#if 0
		seed = GetTickCount();
		srand(seed);
		srand48(seed);
		WELL_init(&well, seed);
#endif
		//TclC^v^쐬B
		iPtr = Tcl_CreateInterp();
//{{KvɉāAŃAvP[VLTcl_CreateCommand()sĂB
		Tcl_CreateCommand(iPtr	,"SnrSeq_New"		,SnrSeq_NewCmd		,NULL);
		Tcl_CreateCommand(iPtr	,"SnrSeq_Init"		,SnrSeq_InitCmd		,NULL);
		Tcl_CreateCommand(iPtr	,"SnrSeq_Free"		,SnrSeq_FreeCmd		,NULL);
		Tcl_CreateCommand(iPtr	,"SnrSeq_Exec"		,SnrSeq_ExecCmd		,NULL);
		Tcl_CreateCommand(iPtr	,"SnrSeqCh_Exec"	,SnrSeqCh_ExecCmd	,NULL);
		Tcl_CreateCommand(iPtr	,"SnrSeq_ClrTbl"	,SnrSeq_ClrTblCmd	,NULL);
		Tcl_CreateCommand(iPtr	,"SnrSeqCh_SetTbl"	,SnrSeqCh_SetTblCmd	,NULL);
		Tcl_CreateCommand(iPtr	,"SnrSeq_SendTrig"	,SnrSeq_SendTrigCmd	,NULL);
		Tcl_CreateCommand(iPtr	,"SnrSeqCh_SendTrig"	,SnrSeqCh_SendTrigCmd	,NULL);
		Tcl_CreateCommand(iPtr	,"SnrSeq_Unlock"	,SnrSeq_UnlockCmd	,NULL);
		Tcl_CreateCommand(iPtr	,"SnrSeqCh_Unlock"	,SnrSeqCh_UnlockCmd	,NULL);
		Tcl_CreateCommand(iPtr	,"SnrSeq_Stop"		,SnrSeq_StopCmd		,NULL);
		Tcl_CreateCommand(iPtr	,"SnrSeqCh_Stop"	,SnrSeqCh_StopCmd	,NULL);
		Tcl_CreateCommand(iPtr	,"SnrSeq_GetStat"	,SnrSeq_GetStatCmd	,NULL);
		Tcl_CreateCommand(iPtr	,"SnrSeqCh_GetStat"	,SnrSeqCh_GetStatCmd	,NULL);
		Tcl_CreateCommand(iPtr	,"SnrSeqCh_SetTblNo"	,SnrSeqCh_SetTblNoCmd	,NULL);
		/*--------------------------------------------------------------------------*/
		Tcl_CreateCommand(iPtr	,"blob_reader_init"	,blob_reader_initCmd	,NULL);
		Tcl_CreateCommand(iPtr	,"blob_read_bit"	,blob_read_bitCmd	,NULL);
		Tcl_CreateCommand(iPtr	,"blob_read_byte"	,blob_read_byteCmd	,NULL);
		Tcl_CreateCommand(iPtr	,"blob_read_half"	,blob_read_halfCmd	,NULL);
		Tcl_CreateCommand(iPtr	,"blob_read_exp10"	,blob_read_exp10Cmd	,NULL);
		Tcl_CreateCommand(iPtr	,"blob_read_word"	,blob_read_wordCmd	,NULL);
		Tcl_CreateCommand(iPtr	,"blob_read_ber"	,blob_read_berCmd	,NULL);	//{{2018/04/07ǉ:'blob_read_ber'R}hǉ܂B}}
		Tcl_CreateCommand(iPtr	,"blob_read_fp16"	,blob_read_fp16Cmd	,NULL);
		Tcl_CreateCommand(iPtr	,"blob_read_fp32"	,blob_read_fp32Cmd	,NULL);
		Tcl_CreateCommand(iPtr	,"blob_read_fp64"	,blob_read_fp64Cmd	,NULL);
		Tcl_CreateCommand(iPtr	,"blob_read_string"	,blob_read_stringCmd	,NULL);
		Tcl_CreateCommand(iPtr	,"blob_read_data"	,blob_read_dataCmd	,NULL);
		Tcl_CreateCommand(iPtr	,"blob_copy_data"	,blob_copy_dataCmd	,NULL);
		Tcl_CreateCommand(iPtr	,"blob_reader_get_bits"	,blob_reader_get_bitsCmd,NULL);	//tB[hANZXp
		Tcl_CreateCommand(iPtr	,"blob_reader_get_pos"	,blob_reader_get_posCmd	,NULL);	//tB[hANZXp
		Tcl_CreateCommand(iPtr	,"blob_reader_set_pos"	,blob_reader_set_posCmd	,NULL);	//tB[hANZXp
//}}KvɉāAŃAvP[VLTcl_CreateCommand()sĂB
	}
//}}AvP[VL̏
}
/*--------------------------------------------------------------------------*/
void app_exit() {
//{{AvP[VL̏
	{
		//TODO:
	}
//}}AvP[VL̏
}
/*--------------------------------------------------------------------------*/
int app_main(int argc, char* argv[]) {
	int retCode;
	int opt_q = 0;
	{
		int opt;
		opterr = 0; //IvVG[͓vOŏ̂ŁAgetopt()ł̃G[\͕svB
		while((opt = getopt(argc, argv, "eqh")) != -1) {	//R}hCIvVB
			switch(opt) {
			case 'q':
				opt_q = 1;
				break;
			case 'h':
			default:
				usage();
			}
		}
		if((optind + 1/*snrFname*/ + 1/*tclFname*/) > argc) { usage(); }
	}
	{
		char* snrFname = argv[optind++];
		{
			char fname[_MAX_FNAME], ext[_MAX_EXT];
			splitpath(snrFname, NULL, NULL, fname, ext);
			if(strcasecmp(ext, ".bin")) {
//{{2017/11/07ύX:ꎞtH_̎擾ɁAGetTempPath()ĝ߂āATMP,,TEMPϐ𒼐ڎQƂ悤ɕύX܂B
//				char dir[_MAX_DIR], *binFname;
//				if(!GetTempPath(sizeof dir, dir)) { DIE(); }
//2017/11/07ύX:ꎞtH_̎擾ɁAGetTempPath()ĝ߂āATMP,,TEMPϐ𒼐ڎQƂ悤ɕύX܂B
				char *dir, *binFname;
				dir = getenv("TMP");
				if(!dir) { dir = getenv("TEMP"); }
			//sv	if(!dir) { dir = "."; }	//dir==NULLłJgtH_ƓӖɂȂ̂ł͕̏svłB
//}}2017/11/07ύX:ꎞtH_̎擾ɁAGetTempPath()ĝ߂āATMP,,TEMPϐ𒼐ڎQƂ悤ɕύX܂B
				binFname = strdup_makepath(NULL, dir, fname, ".bin");
				{
					GString* cmdLine = g_string_new("dSnrSeqC.exe");
					if(opt_q) { g_string_append_printf(cmdLine, " -q"); }	//dSnrSeqS.exeɑ΂'-q'IvVw肳ĂAdSnrSeqC.exeɑ΂Ă'-q'IvVw肵ăbZ[W}B
					g_string_append_printf(cmdLine, " -len");
					g_string_append_printf(cmdLine, " -o\"%s\"", binFname);
					g_string_append_printf(cmdLine, " \"%s\"", snrFname);
					g_string_append_printf(cmdLine, " >NUL");
					if(!opt_q) { fprintf(stderr, "%s\n", cmdLine->str); }	//dSnrSeqS.exeɑ΂'-q'IvVw肳ĂȂ΁AdSnrSeqC.exeNR}hC\B(Ղ̂)
					retCode = system(cmdLine->str);
					if(retCode) { error(retCode, 0, "%s (%s)", "compile error", snrFname); }
				}
				snrFname = binFname;
			}
		}
		{
			struct stat st;
			FILE* fp = fopen(snrFname, "rb");
			if(!fp) { error(EXIT_FAILURE, errno, "%s J܂B", snrFname); }
			if(fstat(fileno(fp), &st)) { DIE(); }
			if(!(TBL_SnrTblNo = malloc(st.st_size))) { DIE(); }
			if((int)fread(TBL_SnrTblNo, 1, st.st_size, fp) != (int)st.st_size) { DIE(); }	//fread()̖߂lunsigned^Cst.st_size(Ȃ)signed^Ȃ̂ŁÂ܂ܔrƌxoBx}ɂ͕ЕLXg邾łǂAՂ̂߂ɗLXgĔr鎖ɂB
			fclose(fp);
		}
	}
	{
		char* tclFname = argv[optind++];
		//tclsh ?fileName arg ...?
		//argc  argŎw肳ꂽ̐(Ȃ0)Ă܂Bɂ̓XNvgt@C͊܂܂܂B
		//argv  argŎw肳ꂽɕׂTcl̃XgĂ܂Bargňw肳Ȃɂ͋󕶎ɂȂ܂B
		//argv0 fileNamew肳Ă΂ꂪ܂BłȂtclshNꂽ̃R}h܂B
		if(!Tcl_SetVar(iPtr, "argv0", tclFname)) { DIE(); }
		if(!Tcl_SetVar(iPtr, "argv", strjoinv(" ", &argv[optind]))) { DIE(); }
		if(!Tcl_SetVar(iPtr, "argc", strdup_printf("%d", argc - optind))) { DIE(); }
		retCode = Tcl_EvalFile(iPtr, tclFname);
		if(retCode) { error(retCode, 0, "%s", iPtr->result); }
	}
	return retCode;
}
/****************************************************************************
 *	
 ****************************************************************************/
//Tcl̃R}h֐́ASEH_catchubN̂݁AĂяo\łB
static int SehErrMsg() {
//{{cliptcl.cTcl_Merge()
	char *s = strdup(""), *t, **argv = iPtr->argv;
	while((t = *argv++)) {
//{{cliptcl.cTcl_Escape()
		//vfGXP[vB
		t = strescape(t, " $;[]{}");	//GXP[vB
		if(!*t) { t = strdup("\\0"); }	//󕶎łꍇ́AIȋvf"\0"ɕϊB	//"\0"̑"{}"ł\܂BǂɂĂ삷͂łB
//}}cliptcl.cTcl_Escape()
//{{cliptcl.cTcl_AppendElement()
		//̕񂪋󕶎łȂ΁A̕ƃGXP[vvfA󔒕ŘAB
		//̕񂪋󕶎Ȃ΁AGXP[vvf̂܂ܕԂB擪ɁA󔒕͕t^ȂB
		s = *s ? strjoin(" ", s, t, NULL) : t;
//}}cliptcl.cTcl_AppendElement()
	}
//}}cliptcl.cTcl_Merge()
	iPtr->result = strdup_printf("%s:%d: %s: \"%s\""/*error_at_lineɍ킹*/,
	                             SEH_info.file ? basename((char*)SEH_info.file) : "",	//ݒ肳Ă͂Ô߁B
	                             SEH_info.line,
	                             SEH_info.msg ? SEH_info.msg : "",
	                             s);
	return TCL_ERROR;
}
/*--------------------------------------------------------------------------*/
//Tcl̃R}h֐́ASEH_tryubN̂݁AĂяo\łB
static void CheckArgc(int n) {
	if(iPtr->argc != n) {
		SEH_throw_msg(AppException, strdup_printf("expected %d args but got %d", n, iPtr->argc));
	}
}
/*--------------------------------------------------------------------------*/
//SEH_tryubN̂݁AĂяo\łB
static int GetInt(const char* s, int lo, int hi) {
	char* p = (char*)s;
//{{cliptcl.cTcl_GetInt()
	int i = strtol(p, &p, 0);		//l擾B
	while(*p && isspace(*p)) { p++; }	//ľ̋󔒂ǂݔ΂B
	if((p == s) || *p) {			//󕶎񂪎w肳ꂽ,,ľɋ󔒈ȊOL΃G[B
		SEH_throw_msg(AppException, strdup_printf("expected integer but got \"%s\"", s));
	}
//}}cliptcl.cTcl_GetInt()
	if(i < lo) { SEH_throw_msg(AppException, strdup_printf("expected not below %d but got %d", lo, i)); }
	if(i > hi) { SEH_throw_msg(AppException, strdup_printf("expected not above %d but got %d", hi, i)); }
	return i;
}
/*--------------------------------------------------------------------------*/
//SEH_tryubN̂݁AĂяo\łB
static int GetSnrTblNo(const char* pTableName) {	//pTableNaméAe[u("SnrTblNo_..."),,e[uԍ("1"`SnrTblNo_Max)Ŏw肵ĉB
	int iSnrTblNo;
	//"SnrTblNo_..."Ȃ΁Ae[uƌȂB
	if(str_has_prefix(pTableName, "SnrTblNo_")) {
		iSnrTblNo = SnrSeq_TryGetTableNo(TBL_SnrTblNo, pTableName + 9);
		if(iSnrTblNo == -1) {
			SEH_throw_msg(AppException, strdup_printf("unknown table name \"%s\"", pTableName));
		}
	//"SnrTblNo_..."ȊOȂ΁Ae[uԍƌȂB
	} else {
		iSnrTblNo = GetInt(pTableName, 1, (TBL_SnrTblNo[0]/*nSnrTblNo*/ - 1)/*SnrTblNo_Max*/);
	}
	return iSnrTblNo;
}
/*--------------------------------------------------------------------------*/
//SEH_tryubN̂݁AĂяo\łB
static int GetTrigNo(const char* pTrigName) {	//pTrigNaméAgK("SnrTrg_..."),,gKԍ("0"`"255")Ŏw肵ĉB
	int iSnrTrg;
	//"SnrTrg_..."Ȃ΁AgKƌȂB
	if(str_has_prefix(pTrigName, "SnrTrg_")) {
		iSnrTrg = SnrSeq_TryGetTrigNo(TBL_SnrTblNo, pTrigName + 7/*"SnrTrg_"*/);
		if(iSnrTrg == -1) {
			SEH_throw_msg(AppException, strdup_printf("unknown trigger name \"%s\"", pTrigName));
		}
	//"SnrTrg_..."ȊOȂ΁AgKԍƌȂB
	} else {
		iSnrTrg = GetInt(pTrigName, SnrTrg_set, SnrTrg_clr);
	}
	return iSnrTrg;
}
/*--------------------------------------------------------------------------*/
//SEH_tryubN̂݁AĂяo\łB
static const char* GetFuncName(int iSnrFnc) {
	const char* pFuncName = SnrSeq_TryGetFuncName(TBL_SnrTblNo, iSnrFnc);
	if(!pFuncName) {
		SEH_throw_msg(AppException, strdup_printf("unknown function number %d", iSnrFnc));
	}
	return strconcat("SnrFnc_", pFuncName, NULL);
}
/****************************************************************************
 *	
 ****************************************************************************/
static int AddressList_CompareFunc(const void* pAddress, const char* pName) {
	return strcmp(strdup_printf("%p", pAddress), pName);	//AhXlL[Ƃ邱ƂɂBӂsearchId쐬ړIłAhXlƂĉ߂邱Ƃ͖B
}
/*--------------------------------------------------------------------------*/
//SEH_tryubN̂݁AĂяo\łB
static char* AddressList_Register(void* pAddress) {
	char* pName = strdup_printf("%p", pAddress);		//AhXlL[Ƃ邱ƂɂBӂsearchId쐬ړIłAhXlƂĉ߂邱Ƃ͖B
	GSList* pLink = g_slist_find_custom(pAddressList, pName, AddressList_CompareFunc);
	if(pLink) { SEH_throw_msg(AppException, strdup_printf("AddressList_Register failed \"%s\"", pName)); }	//do^͕sB炭c[̃oOłBXNvgG[ł͔Ȃ͂łB
	pAddressList = g_slist_append(pAddressList, pAddress);
	return pName;
}
/*--------------------------------------------------------------------------*/
//SEH_tryubN̂݁AĂяo\łB
static void* AddressList_Lookup(char* pName) {
	GSList* pLink = g_slist_find_custom(pAddressList, pName, AddressList_CompareFunc);
	if(!pLink) { SEH_throw_msg(AppException, strdup_printf("AddressList_Lookup failed \"%s\"", pName)); }	//o^ĂȂBc[̃oO,,XNvgG[ɂĂ܂B
	return pLink->data;
}
/*--------------------------------------------------------------------------*/
//SEH_tryubN̂݁AĂяo\łB
static void AddressList_Unregister(void* pAddress) {
	char* pName = strdup_printf("%p", pAddress);		//AhXlL[Ƃ邱ƂɂBӂsearchId쐬ړIłAhXlƂĉ߂邱Ƃ͖B
	GSList* pLink = g_slist_find_custom(pAddressList, pName, AddressList_CompareFunc);
	if(!pLink) { SEH_throw_msg(AppException, strdup_printf("AddressList_Unregister failed \"%s\"", pName)); }	//o^ĂȂBc[̃oO,,XNvgG[ɂĂ܂B
	pAddressList = g_slist_delete_link(pAddressList, pLink);
}
/****************************************************************************
 *	
 ****************************************************************************/
static int fnSnrSeq(struct _ST_SnrSeq* pSnrSeq, int iCh, int iSnrFnc, struct blob_reader* pArgs) {
	int result = 0;
	SEH_try {
		char* pFunc = g_dataset_get_data(pSnrSeq, "pFunc");
		if(!pFunc) { DIE(); }	//o^ĂȂBŒ~瓖c[̃oOłB
		if(Tcl_EvalString(iPtr, strdup_printf("apply {%s} %s %d %s %s",
		                  pFunc,
		                  strdup_printf("%p", pSnrSeq),	//AhXlL[Ƃ邱ƂɂBӂsearchId쐬ړIłAhXlƂĉ߂邱Ƃ͖B
		                  iCh,
		                  GetFuncName(iSnrFnc),
		                  AddressList_Register(pArgs)))) {
			//ŗO𓊓ĉł܂Ƃ߂ď鎖\ł͂邪AiPtr->result̃bZ[WɗOӏ܂܂Ă\dɕ\ČhȂBh߂ɒڏI鎖ɂB
			error(EXIT_FAILURE, 0, "%s", iPtr->result);	//C^v^̃G[bZ[W(iPtr->result)\ďIBfnSnrSeq()Tcl̃R}h֐ł͂Ȃ̂TCL_ERRORԂČp鎖͏oȂB
		}
		AddressList_Unregister(pArgs);
		result = GetInt(iPtr->result, INT_MIN, INT_MAX);
	} SEH_catch(AppException) {
		error(EXIT_FAILURE, 0, "%s:%d: %s"/*error_at_lineɍ킹*/,	//ÕG[bZ[W(SEH_info.msg)\ďIBfnSnrSeq()Tcl̃R}h֐ł͂Ȃ̂TCL_ERRORԂČp鎖͏oȂB
		      SEH_info.file ? basename((char*)SEH_info.file) : "",	//ݒ肳Ă͂Ô߁B
		      SEH_info.line,
		      SEH_info.msg ? SEH_info.msg : "");
	} SEH_end
	return result;
}
/****************************************************************************
 *	
 ****************************************************************************/
//SnrSeq_New pFunc nCh nCtx	//pFunclambdaExpr`Ŏw肵ĉB
static int SnrSeq_NewCmd(Tcl_Interp* iPtr) {
	SEH_try {
		CheckArgc(4);
		{
			ST_SnrSeq* pSnrSeq = SnrSeq_New(fnSnrSeq,
				GetInt(iPtr->argv[2], 0, 255),
				GetInt(iPtr->argv[3], 0, 255));
			iPtr->result = AddressList_Register(pSnrSeq);
			g_dataset_set_data(pSnrSeq, "pFunc", iPtr->argv[1]);
		}
	} SEH_catch(AppException) {
		return SehErrMsg();
	} SEH_end
	return TCL_OK;
}
/*--------------------------------------------------------------------------*/
//SnrSeq_Init pSnrSeq pFunc nCh nCtx
static int SnrSeq_InitCmd(Tcl_Interp* iPtr) {
	SEH_try {
		SEH_throw_msg(AppException, "not implemented");	//Ή
	} SEH_catch(AppException) {
		return SehErrMsg();
	} SEH_end
	return TCL_OK;
}
/*--------------------------------------------------------------------------*/
//SnrSeq_Free pSnrSeq
static int SnrSeq_FreeCmd(Tcl_Interp* iPtr) {
	SEH_try {
		CheckArgc(2);
		{
			ST_SnrSeq* pSnrSeq = AddressList_Lookup(iPtr->argv[1]);
			AddressList_Unregister(pSnrSeq);
			g_dataset_destroy(pSnrSeq);
			SnrSeq_Free(pSnrSeq);
		}
	} SEH_catch(AppException) {
		return SehErrMsg();
	} SEH_end
	return TCL_OK;
}
/*--------------------------------------------------------------------------*/
//SnrSeq_Exec pSnrSeq
static int SnrSeq_ExecCmd(Tcl_Interp* iPtr) {
	SEH_try {
		CheckArgc(2);
		{
			ST_SnrSeq* pSnrSeq = AddressList_Lookup(iPtr->argv[1]);
			SnrSeq_Exec(pSnrSeq);
		}
	} SEH_catch(AppException) {
		return SehErrMsg();
	} SEH_end
	return TCL_OK;
}
/*--------------------------------------------------------------------------*/
//SnrSeqCh_Exec pSnrSeq iCh
static int SnrSeqCh_ExecCmd(Tcl_Interp* iPtr) {
	SEH_try {
		CheckArgc(3);
		{
			ST_SnrSeq* pSnrSeq = AddressList_Lookup(iPtr->argv[1]);
			SnrSeqCh_Exec(pSnrSeq,
				GetInt(iPtr->argv[2], 0, pSnrSeq->nCh - 1));
		}
	} SEH_catch(AppException) {
		return SehErrMsg();
	} SEH_end
	return TCL_OK;
}
/*--------------------------------------------------------------------------*/
//SnrSeq_ClrTbl pSnrSeq
static int SnrSeq_ClrTblCmd(Tcl_Interp* iPtr) {
	SEH_try {
		CheckArgc(2);
		{
			ST_SnrSeq* pSnrSeq = AddressList_Lookup(iPtr->argv[1]);
			SnrSeq_ClrTbl(pSnrSeq);
		}
	} SEH_catch(AppException) {
		return SehErrMsg();
	} SEH_end
	return TCL_OK;
}
/*--------------------------------------------------------------------------*/
//SnrSeqCh_SetTbl pSnrSeq iCh pSnrTbl	//pSnrTbl"NULL"̂ݑΉBȊOSnrSeqCh_SetTblNogpĉB
static int SnrSeqCh_SetTblCmd(Tcl_Interp* iPtr) {
	SEH_try {
		CheckArgc(4);
		{
			ST_SnrSeq* pSnrSeq = AddressList_Lookup(iPtr->argv[1]);
			if(strcmp(iPtr->argv[3], "NULL")) {
				SEH_throw_msg(AppException, strdup_printf("expected \"NULL\" but got \"%s\"", iPtr->argv[3]));
			}
			SnrSeqCh_SetTbl(pSnrSeq,
				GetInt(iPtr->argv[2], 0, pSnrSeq->nCh - 1),
				NULL);
		}
	} SEH_catch(AppException) {
		return SehErrMsg();
	} SEH_end
	return TCL_OK;
}
/*--------------------------------------------------------------------------*/
//SnrSeq_SendTrig pSnrSeq iTrig
static int SnrSeq_SendTrigCmd(Tcl_Interp* iPtr) {
	SEH_try {
		CheckArgc(3);
		{
			ST_SnrSeq* pSnrSeq = AddressList_Lookup(iPtr->argv[1]);
			SnrSeq_SendTrig(pSnrSeq,
				GetTrigNo(iPtr->argv[2]));
		}
	} SEH_catch(AppException) {
		return SehErrMsg();
	} SEH_end
	return TCL_OK;
}
/*--------------------------------------------------------------------------*/
//SnrSeqCh_SendTrig pSnrSeq iCh iTrig
static int SnrSeqCh_SendTrigCmd(Tcl_Interp* iPtr) {
	SEH_try {
		CheckArgc(4);
		{
			ST_SnrSeq* pSnrSeq = AddressList_Lookup(iPtr->argv[1]);
			SnrSeqCh_SendTrig(pSnrSeq,
				GetInt(iPtr->argv[2], 0, pSnrSeq->nCh - 1),
				GetTrigNo(iPtr->argv[3]));
		}
	} SEH_catch(AppException) {
		return SehErrMsg();
	} SEH_end
	return TCL_OK;
}
/*--------------------------------------------------------------------------*/
//SnrSeq_Unlock pSnrSeq
static int SnrSeq_UnlockCmd(Tcl_Interp* iPtr) {
	SEH_try {
		CheckArgc(2);
		{
			ST_SnrSeq* pSnrSeq = AddressList_Lookup(iPtr->argv[1]);
			SnrSeq_Unlock(pSnrSeq);
		}
	} SEH_catch(AppException) {
		return SehErrMsg();
	} SEH_end
	return TCL_OK;
}
/*--------------------------------------------------------------------------*/
//SnrSeqCh_Unlock pSnrSeq iCh
static int SnrSeqCh_UnlockCmd(Tcl_Interp* iPtr) {
	SEH_try {
		CheckArgc(3);
		{
			ST_SnrSeq* pSnrSeq = AddressList_Lookup(iPtr->argv[1]);
			SnrSeqCh_Unlock(pSnrSeq,
				GetInt(iPtr->argv[2], 0, pSnrSeq->nCh - 1));
		}
	} SEH_catch(AppException) {
		return SehErrMsg();
	} SEH_end
	return TCL_OK;
}
/*--------------------------------------------------------------------------*/
//SnrSeq_Stop pSnrSeq
static int SnrSeq_StopCmd(Tcl_Interp* iPtr) {
	SEH_try {
		CheckArgc(2);
		{
			ST_SnrSeq* pSnrSeq = AddressList_Lookup(iPtr->argv[1]);
			SnrSeq_Stop(pSnrSeq);
		}
	} SEH_catch(AppException) {
		return SehErrMsg();
	} SEH_end
	return TCL_OK;
}
/*--------------------------------------------------------------------------*/
//SnrSeqCh_Stop pSnrSeq iCh
static int SnrSeqCh_StopCmd(Tcl_Interp* iPtr) {
	SEH_try {
		CheckArgc(3);
		{
			ST_SnrSeq* pSnrSeq = AddressList_Lookup(iPtr->argv[1]);
			SnrSeqCh_Stop(pSnrSeq,
				GetInt(iPtr->argv[2], 0, pSnrSeq->nCh - 1));
		}
	} SEH_catch(AppException) {
		return SehErrMsg();
	} SEH_end
	return TCL_OK;
}
/*--------------------------------------------------------------------------*/
//SnrSeq_GetStat pSnrSeq
static int SnrSeq_GetStatCmd(Tcl_Interp* iPtr) {
	SEH_try {
		CheckArgc(2);
		{
			ST_SnrSeq* pSnrSeq = AddressList_Lookup(iPtr->argv[1]);
			iPtr->result = strdup_printf("%d", SnrSeq_GetStat(pSnrSeq));
		}
	} SEH_catch(AppException) {
		return SehErrMsg();
	} SEH_end
	return TCL_OK;
}
/*--------------------------------------------------------------------------*/
//SnrSeqCh_GetStat pSnrSeq iCh
static int SnrSeqCh_GetStatCmd(Tcl_Interp* iPtr) {
	SEH_try {
		CheckArgc(3);
		{
			ST_SnrSeq* pSnrSeq = AddressList_Lookup(iPtr->argv[1]);
			iPtr->result = strdup_printf("%d", SnrSeqCh_GetStat(pSnrSeq,
				GetInt(iPtr->argv[2], 0, pSnrSeq->nCh - 1)));
		}
	} SEH_catch(AppException) {
		return SehErrMsg();
	} SEH_end
	return TCL_OK;
}
/*--------------------------------------------------------------------------*/
//SnrSeqCh_SetTblNo pSnrSeq iCh pSnrSeqBin iSnrTblNo	//pSnrSeqBin"TBL_SnrTblNo"ŒB
static int SnrSeqCh_SetTblNoCmd(Tcl_Interp* iPtr) {
	SEH_try {
		CheckArgc(5);
		{
			ST_SnrSeq* pSnrSeq = AddressList_Lookup(iPtr->argv[1]);
			if(strcmp(iPtr->argv[3], "TBL_SnrTblNo")) {
				SEH_throw_msg(AppException, strdup_printf("expected \"TBL_SnrTblNo\" but got \"%s\"", iPtr->argv[3]));
			}
			SnrSeqCh_SetTblNo(pSnrSeq,
				GetInt(iPtr->argv[2], 0, pSnrSeq->nCh - 1),
				TBL_SnrTblNo,
				GetSnrTblNo(iPtr->argv[4]));
		}
	} SEH_catch(AppException) {
		return SehErrMsg();
	} SEH_end
	return TCL_OK;
}
/****************************************************************************
 *	
 ****************************************************************************/
//blob_reader_init reader data size
static int blob_reader_initCmd(Tcl_Interp* iPtr) {
	SEH_try {
		SEH_throw_msg(AppException, "not implemented");	//Ή
	} SEH_catch(AppException) {
		return SehErrMsg();
	} SEH_end
	return TCL_OK;
}
/*--------------------------------------------------------------------------*/
//blob_read_bit reader
static int blob_read_bitCmd(Tcl_Interp* iPtr) {
	SEH_try {
		CheckArgc(2);
		{
			struct blob_reader* reader = AddressList_Lookup(iPtr->argv[1]);
			if(reader->pos/*8N+0`7*/ >= reader->bits/*8N*/) { SEH_throw_msg(AppException, "end of args"); }
			iPtr->result = strdup_printf("%d", blob_read_bit(reader));
		}
	} SEH_catch(AppException) {
		return SehErrMsg();
	} SEH_end
	return TCL_OK;
}
/*--------------------------------------------------------------------------*/
//blob_read_byte reader
static int blob_read_byteCmd(Tcl_Interp* iPtr) {
	SEH_try {
		CheckArgc(2);
		{
			struct blob_reader* reader = AddressList_Lookup(iPtr->argv[1]);
			if(((reader->bits/*8N*/ - reader->pos/*8N+0`7*/) / 8) < 1/*byte*/) { SEH_throw_msg(AppException, "end of args"); }
			iPtr->result = strdup_printf("%d", blob_read_byte(reader));
		}
	} SEH_catch(AppException) {
		return SehErrMsg();
	} SEH_end
	return TCL_OK;
}
/*--------------------------------------------------------------------------*/
//blob_read_half reader
static int blob_read_halfCmd(Tcl_Interp* iPtr) {
	SEH_try {
		CheckArgc(2);
		{
			struct blob_reader* reader = AddressList_Lookup(iPtr->argv[1]);
			if(((reader->bits/*8N*/ - reader->pos/*8N+0`7*/) / 8) < 2/*half*/) { SEH_throw_msg(AppException, "end of args"); }
			iPtr->result = strdup_printf("%d", blob_read_half(reader));
		}
	} SEH_catch(AppException) {
		return SehErrMsg();
	} SEH_end
	return TCL_OK;
}
/*--------------------------------------------------------------------------*/
//blob_read_exp10 reader
static int blob_read_exp10Cmd(Tcl_Interp* iPtr) {
	SEH_try {
		CheckArgc(2);
		{
			struct blob_reader* reader = AddressList_Lookup(iPtr->argv[1]);
			if(((reader->bits/*8N*/ - reader->pos/*8N+0`7*/) / 8) < 2/*exp10*/) { SEH_throw_msg(AppException, "end of args"); }
			iPtr->result = strdup_printf("%d", blob_read_exp10(reader));
		}
	} SEH_catch(AppException) {
		return SehErrMsg();
	} SEH_end
	return TCL_OK;
}
/*--------------------------------------------------------------------------*/
//blob_read_word reader
static int blob_read_wordCmd(Tcl_Interp* iPtr) {
	SEH_try {
		CheckArgc(2);
		{
			struct blob_reader* reader = AddressList_Lookup(iPtr->argv[1]);
			if(((reader->bits/*8N*/ - reader->pos/*8N+0`7*/) / 8) < 4/*word*/) { SEH_throw_msg(AppException, "end of args"); }
			iPtr->result = strdup_printf("%d", blob_read_word(reader));
		}
	} SEH_catch(AppException) {
		return SehErrMsg();
	} SEH_end
	return TCL_OK;
}
/*--------------------------------------------------------------------------*/
//{{2018/04/07ǉ:'blob_read_ber'R}hǉ܂B
//blob_read_ber reader
static int blob_read_berCmd(Tcl_Interp* iPtr) {
	SEH_try {
		CheckArgc(2);
		{
			struct blob_reader* reader = AddressList_Lookup(iPtr->argv[1]);
			{
				int n = (reader->bits/*8N*/ - reader->pos/*8N+0`7*/) / 8;				//coCg߂B
				unsigned char* s = (unsigned char*)reader->data + ((reader->pos/*8N+0`7*/ + 7) / 8);	//BERk̐擪AhX߂B
				int t;
				if(n < BER_Decode(s, &t)) { SEH_throw_msg(AppException, "end of args"); }		//coCgBERk̃oCgȂ΃G[B
			}
			iPtr->result = strdup_printf("%d", blob_read_ber(reader));
		}
	} SEH_catch(AppException) {
		return SehErrMsg();
	} SEH_end
	return TCL_OK;
}
//}}2018/04/07ǉ:'blob_read_ber'R}hǉ܂B
/*--------------------------------------------------------------------------*/
//blob_read_fp16 reader
static int blob_read_fp16Cmd(Tcl_Interp* iPtr) {
	SEH_try {
		CheckArgc(2);
		{
			struct blob_reader* reader = AddressList_Lookup(iPtr->argv[1]);
			if(((reader->bits/*8N*/ - reader->pos/*8N+0`7*/) / 8) < 2/*fp16*/) { SEH_throw_msg(AppException, "end of args"); }
			iPtr->result = strdup_printf("%g", blob_read_fp16(reader));
//{{cliptcl.cTcl_ExprMakeString()
			//Tcl6.7̎ł́uset x [expr 1.0]vu1vƂȂ肻ȍ~ZĂ܂肪B΍ƂĈȉ̏Tcl7.0Tcl_PrintDouble()obN|[gďCB
			if(!strchr(iPtr->result, '.') && !strchr(iPtr->result, 'e')) { iPtr->result = strconcat(iPtr->result, ".0", NULL); }
//}}cliptcl.cTcl_ExprMakeString()
		}
	} SEH_catch(AppException) {
		return SehErrMsg();
	} SEH_end
	return TCL_OK;
}
/*--------------------------------------------------------------------------*/
//blob_read_fp32 reader
static int blob_read_fp32Cmd(Tcl_Interp* iPtr) {
	SEH_try {
		CheckArgc(2);
		{
			struct blob_reader* reader = AddressList_Lookup(iPtr->argv[1]);
			if(((reader->bits/*8N*/ - reader->pos/*8N+0`7*/) / 8) < 4/*fp32*/) { SEH_throw_msg(AppException, "end of args"); }
			iPtr->result = strdup_printf("%g", blob_read_fp32(reader));
//{{cliptcl.cTcl_ExprMakeString()
			//Tcl6.7̎ł́uset x [expr 1.0]vu1vƂȂ肻ȍ~ZĂ܂肪B΍ƂĈȉ̏Tcl7.0Tcl_PrintDouble()obN|[gďCB
			if(!strchr(iPtr->result, '.') && !strchr(iPtr->result, 'e')) { iPtr->result = strconcat(iPtr->result, ".0", NULL); }
//}}cliptcl.cTcl_ExprMakeString()
		}
	} SEH_catch(AppException) {
		return SehErrMsg();
	} SEH_end
	return TCL_OK;
}
/*--------------------------------------------------------------------------*/
//blob_read_fp64 reader
static int blob_read_fp64Cmd(Tcl_Interp* iPtr) {
	SEH_try {
		CheckArgc(2);
		{
			struct blob_reader* reader = AddressList_Lookup(iPtr->argv[1]);
			if(((reader->bits/*8N*/ - reader->pos/*8N+0`7*/) / 8) < 8/*fp64*/) { SEH_throw_msg(AppException, "end of args"); }
			iPtr->result = strdup_printf("%g", blob_read_fp64(reader));
//{{cliptcl.cTcl_ExprMakeString()
			//Tcl6.7̎ł́uset x [expr 1.0]vu1vƂȂ肻ȍ~ZĂ܂肪B΍ƂĈȉ̏Tcl7.0Tcl_PrintDouble()obN|[gďCB
			if(!strchr(iPtr->result, '.') && !strchr(iPtr->result, 'e')) { iPtr->result = strconcat(iPtr->result, ".0", NULL); }
//}}cliptcl.cTcl_ExprMakeString()
		}
	} SEH_catch(AppException) {
		return SehErrMsg();
	} SEH_end
	return TCL_OK;
}
/*--------------------------------------------------------------------------*/
//blob_read_string reader
static int blob_read_stringCmd(Tcl_Interp* iPtr) {
	SEH_try {
		CheckArgc(2);
		{
			struct blob_reader* reader = AddressList_Lookup(iPtr->argv[1]);
			{
				int n = (reader->bits/*8N*/ - reader->pos/*8N+0`7*/) / 8;			//coCg߂B
				char* s = (char*)reader->data + ((reader->pos/*8N+0`7*/ + 7) / 8);		//̐擪AhX߂B
				if(n <= (int)strnlen(s, n)) { SEH_throw_msg(AppException, "end of args"); }	//coCgȉȂ΃G[BłsBI[̃k܂߂ƒ߂邩B
			}
			iPtr->result = strdup_printf("%s", blob_read_string(reader));
		}
	} SEH_catch(AppException) {
		return SehErrMsg();
	} SEH_end
	return TCL_OK;
}
/*--------------------------------------------------------------------------*/
//blob_read_data reader size
static int blob_read_dataCmd(Tcl_Interp* iPtr) {
	SEH_try {
		SEH_throw_msg(AppException, "not implemented");	//Ή
	} SEH_catch(AppException) {
		return SehErrMsg();
	} SEH_end
	return TCL_OK;
}
/*--------------------------------------------------------------------------*/
//blob_copy_data reader p size
static int blob_copy_dataCmd(Tcl_Interp* iPtr) {
	SEH_try {
		SEH_throw_msg(AppException, "not implemented");	//Ή
	} SEH_catch(AppException) {
		return SehErrMsg();
	} SEH_end
	return TCL_OK;
}
/*--------------------------------------------------------------------------*/
//blob_reader_get_bits reader
static int blob_reader_get_bitsCmd(Tcl_Interp* iPtr) {	//tB[hANZXp
	SEH_try {
		CheckArgc(2);
		{
			struct blob_reader* reader = AddressList_Lookup(iPtr->argv[1]);
			iPtr->result = strdup_printf("%d", reader->bits);
		}
	} SEH_catch(AppException) {
		return SehErrMsg();
	} SEH_end
	return TCL_OK;
}
/*--------------------------------------------------------------------------*/
//blob_reader_get_pos reader
static int blob_reader_get_posCmd(Tcl_Interp* iPtr) {	//tB[hANZXp
	SEH_try {
		CheckArgc(2);
		{
			struct blob_reader* reader = AddressList_Lookup(iPtr->argv[1]);
			iPtr->result = strdup_printf("%d", reader->pos);
		}
	} SEH_catch(AppException) {
		return SehErrMsg();
	} SEH_end
	return TCL_OK;
}
/*--------------------------------------------------------------------------*/
//blob_reader_set_pos reader pos
static int blob_reader_set_posCmd(Tcl_Interp* iPtr) {	//tB[hANZXp
	SEH_try {
		CheckArgc(3);
		{
			struct blob_reader* reader = AddressList_Lookup(iPtr->argv[1]);
			reader->pos = GetInt(iPtr->argv[2], 0, reader->bits);
		}
	} SEH_catch(AppException) {
		return SehErrMsg();
	} SEH_end
	return TCL_OK;
}
