/*
 *	dSnrSeqD - ViIV[PTtRpC
 *	Copyright (C) 2017-2018 Naoyuki Sawa
 *
 *	* Sat Oct 14 22:22:29 JST 2017 Naoyuki Sawa
 *	- 1st [XB
 *	* Sun Oct 29 23:57:57 JST 2017 Naoyuki Sawa
 *	- 'wait for'߂'wait for not'߂ǉ܂B
 *	* Sat Nov 04 23:56:59 JST 2017 Naoyuki Sawa
 *	- '-l'IvVǉ܂B
 *	  ڍׂ́A/clip/tool/dSnrSeqC/winapp.h ̓̃RgQƂĉB
 *	* Sat Nov 11 23:59:59 JST 2017 Naoyuki Sawa
 *	- 'escape'߂ǉ܂B
 *	   ڍׂ́A/clip/clipsnrs.c ̓̃RgQƂĉB
 *	* Tue Nov 21 23:59:59 JST 2017 Naoyuki Sawa
 *	- 'on unlock','on exec','on unlock exec'߂ǉ܂B
 *	   ڍׂ́A/clip/clipsnrs.c ̓̃RgQƂĉB
 *	* Thu May 03 23:59:59 JST 2018 Naoyuki Sawa
 *	- Boehm GCCɔAc[rh܂B
 *	  ڍׂ́A/clip/tool/gc/README.TXT'Wed May 02 23:59:59 JST 2018 Naoyuki Sawa'̃RgQƂĉB
 */
#include "app.h"
#define VERSION		"20180503"	//ŏIXV
/****************************************************************************
 *	main
 ****************************************************************************/
int main(int argc, char* argv[]) {
	int exitCode = EXIT_SUCCESS;
#ifdef  _DEBUG
	remove("syslog.out");			//񃍃O폜鎖ɂB
    #ifndef USE_JOB_DEBUG
	openlog(NULL, LOG_PERROR, LOG_USER);	//fobOrhł́AVXeOWG[ɂo͂BAfobOWugpꍇ́AfobOWucurses\ƏՓ˂Ȃ悤AWG[ɂ͏o͂ȂB
    #endif//USE_JOB_DEBUG
#else //_DEBUG
	setlogmask(LOG_UPTO(LOG_INFO));		//[Xrhł́ALOG_DEBUG}B
#endif//_DEBUG
#if     (defined(GC_H) && !defined(USE_BISON_FLEX))
//	putenv("GC_LOG_FILE=CON");//Oo͐w肷B
//	GC_set_find_leak(1);//[NoJnB
#endif//(defined(GC_H) && !defined(USE_BISON_FLEX))
#ifdef  __CLIP_SEH_H__
	SEH_init();
#endif//__CLIP_SEH_H__
	app_init(argc, argv);
	exitCode = app_main(argc, argv);
	app_exit();
#if     (defined(GC_H) && !defined(USE_BISON_FLEX))
//	CHECK_LEAKS();//[NoB
#endif//(defined(GC_H) && !defined(USE_BISON_FLEX))
	return exitCode;
}
/****************************************************************************
 *	usage
 ****************************************************************************/
__declspec(noreturn) static void usage() {
	fprintf(stderr, "dSnrSeqD.exe - ViIV[PTtRpC (%s)\n", VERSION);
	fprintf(stderr, "Copyright (C) 2017-2018 Naoyuki Sawa\n");
	fprintf(stderr, "\n");
	fprintf(stderr, "USAGE:\n");
	fprintf(stderr, "  dSnrSeqD.exe [option ...] SnrSeq.bin\n");
	fprintf(stderr, "\n");
	fprintf(stderr, "OPTIONS:\n");
//{{2017/11/04ǉ:'-l'IvVǉ܂B
	fprintf(stderr, "  -l  xe[u擾xgp܂B\n");
	fprintf(stderr, "      ̃IvVw肵Ȃ΁Axgp܂B\n");
	fprintf(stderr, "      xe[ui[ĂȂꍇ́ÃIvV͖łB\n");
//}}2017/11/04ǉ:'-l'IvVǉ܂B
	fprintf(stderr, "  -s  ȗL@gp܂B\n");
	fprintf(stderr, "      ̃IvVw肵Ȃ΁AȗL@gp܂B\n");
	fprintf(stderr, "  -t  ViIe[uɏo͂܂B\n");
	fprintf(stderr, "      ̃IvVw肵Ȃ΁Aꊇŏo͂܂B\n");
	fprintf(stderr, "  -h  g\܂B\n");
	exit(EXIT_FAILURE);
}
/****************************************************************************
 *	
 ****************************************************************************/
void app_init(int argc, char* argv[]) {
	/** no job **/
}
/*--------------------------------------------------------------------------*/
void app_exit() {
	/** no job **/
}
/****************************************************************************
 *	
 ****************************************************************************/
static void printColumns(int indent, ...);
static const char* GetTrigName(int iSnrTrg);
static const char* GetFuncName(int iSnrFnc);
static const char* GetSnrTblName(int iSnrTbl);
static const char* GetSnrSeqName(unsigned char* pSnrSeq);
static const char* GetNakedArgs(unsigned char* pArgs);
static const char* GetParenthesizedArgs(unsigned char* pArgs);
static void DumpSnrTbl(int indent, unsigned char* pSnrTbl);
static void DumpSnrSeq(int indent, unsigned char* pSnrSeq);
/*--------------------------------------------------------------------------*/
//{{2017/11/04ǉ:'-l'IvVǉ܂B
static int opt_l = 0;	//0=xgp܂B1=xe[u擾xgp܂B
//}}2017/11/04ǉ:'-l'IvVǉ܂B
static int opt_s = 0;	//0=ȗL@gp܂B1=ȗL@gp܂B
static int opt_t = 0;	//0=ViIe[uɏo͂B1=ꊇŏo͂B
//{{2017/11/04ǉ:'-l'IvVǉ܂B
GPtrArray *array_pTableName, *array_pTrigName, *array_pFuncName;
//}}2017/11/04ǉ:'-l'IvVǉ܂B
GPtrArray* array_pSnrSeq;
/*--------------------------------------------------------------------------*/
int app_main(int argc, char* argv[]) {
	int* TBL_SnrTblNo;
	//R}hCIvVB
	{
		int opt;
		opterr = 0; //IvVG[͓vOŏ̂ŁAgetopt()ł̃G[\͕svB
		while((opt = getopt(argc, argv, "lsth")) != -1) {
			switch(opt) {
//{{2017/11/04ǉ:'-l'IvVǉ܂B
			case 'l':
				opt_l = 1;	//xe[u擾xgp܂B
				break;
//}}2017/11/04ǉ:'-l'IvVǉ܂B
			case 's':
				opt_s = 1;	//ȗL@gp܂B
				break;
			case 't':
				opt_t = 1;	//ViIe[uɏo͂B
				break;
			case 'h':
			default:
				usage();
			}
		}
		if(optind != (argc - 1)) { usage(); }	//̐s
	}
	//ViĨoCif[^ǂݍށB
	{
		FILE* fp;
		fp = fopen(argv[optind], "rb");
		if(!fp) { error(EXIT_FAILURE, errno, "%s J܂B", argv[optind]); }
		{
			struct stat st;
			if(fstat(fileno(fp), &st)) { DIE(); }
			if(!(TBL_SnrTblNo = malloc(st.st_size))) { DIE(); }
			if((int)fread(TBL_SnrTblNo, 1, st.st_size, fp) != (int)st.st_size) { DIE(); }	//fread()̖߂lunsigned^Cst.st_size(Ȃ)signed^Ȃ̂ŁÂ܂ܔrƌxoBx}ɂ͕ЕLXg邾łǂAՂ̂߂ɗLXgĔr鎖ɂB
			fread(TBL_SnrTblNo, 1, st.st_size, fp);
		}
		fclose(fp);
	}
//{{2017/11/04ǉ:'-l'IvVǉ܂B
	//xe[uǂݍށB
	if(opt_l) {
		const char* p = SnrSeq_GetLabelTable(TBL_SnrTblNo);
		//ViIe[u
		{
			array_pTableName = g_ptr_array_new();
			g_ptr_array_add(array_pTableName, NULL);	//0Ԃ̓_~[
			while(*p) {
				g_ptr_array_add(array_pTableName, iscsymf(*p) ? (char*)p : strconcat("`", p, NULL));	//ꕶڂCV{̐擪łȂ΁u`vt^BViIV[PTXNvg̏łB
				p = strchr(p, '\0') + 1/*'\0'*/;
			}
			p++;	//'\0'
		}
		//gK
		{
			array_pTrigName = g_ptr_array_new();
			g_ptr_array_add(array_pTrigName, NULL);		//0Ԃ̓_~[
			while(*p) {
				g_ptr_array_add(array_pTrigName, iscsymf(*p) ? (char*)p : strconcat("`", p, NULL));	//ꕶڂCV{̐擪łȂ΁u`vt^BViIV[PTXNvg̏łB
				p = strchr(p, '\0') + 1/*'\0'*/;
			}
			p++;	//'\0'
		}
		//֐
		{
			array_pFuncName = g_ptr_array_new();
			g_ptr_array_add(array_pFuncName, NULL);		//0Ԃ̓_~[
			while(*p) {
				g_ptr_array_add(array_pFuncName, iscsymf(*p) ? (char*)p : strconcat("`", p, NULL));	//ꕶڂCV{̐擪łȂ΁u`vt^BViIV[PTXNvg̏łB
				p = strchr(p, '\0') + 1/*'\0'*/;
			}
			p++;	//'\0'
		}
	}
//}}2017/11/04ǉ:'-l'IvVǉ܂B
	if(opt_t) {
		//ViIe[u_vB
		{
			int iSnrTblNo, nSnrTblNo = TBL_SnrTblNo[0];					//AhXe[u̐擪[0]ɗvfĂBvf͂ꎩg([0])܂ށB
			unsigned char* const TBL_SnrTbl = (unsigned char*)&TBL_SnrTblNo[nSnrTblNo];	//AhXe[u̒ォf[^{(BYTEz)JnB
			for(iSnrTblNo = 1; iSnrTblNo < nSnrTblNo; iSnrTblNo++) {
				array_pSnrSeq = g_ptr_array_new();
				puts("#//-----------------------------------------------------------------------------");
				if(opt_s) {
					printColumns(0,
						GetSnrTblName(iSnrTblNo),
						NULL);
				} else {
					printColumns(0,
						"def",
						GetSnrTblName(iSnrTblNo),
						NULL);
				}
				DumpSnrTbl(1, &TBL_SnrTbl[TBL_SnrTblNo[iSnrTblNo]]);
				printColumns(0,
					"end",
					NULL);
				//ViIV[PX_vB
				{
					int iSnrSeq;
					for(iSnrSeq = 0; iSnrSeq < array_pSnrSeq->len; iSnrSeq++) {
						unsigned char* pSnrSeq = array_pSnrSeq->pdata[iSnrSeq];
						puts("#//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -");
						if(opt_s) {
							printColumns(0,
								GetSnrSeqName(pSnrSeq),
								NULL);
						} else {
							printColumns(0,
								"def",
								GetSnrSeqName(pSnrSeq),
								NULL);
						}
						DumpSnrSeq(1, pSnrSeq);	//̒array_pSnrSeq->len\L܂B
						printColumns(0,
							"end",
							NULL);
					}
				}
			}
		}
	} else {
		//ViIe[u_vB
		puts("#//-----------------------------------------------------------------------------");
		{
			int iSnrTblNo, nSnrTblNo = TBL_SnrTblNo[0];					//AhXe[u̐擪[0]ɗvfĂBvf͂ꎩg([0])܂ށB
			unsigned char* const TBL_SnrTbl = (unsigned char*)&TBL_SnrTblNo[nSnrTblNo];	//AhXe[u̒ォf[^{(BYTEz)JnB
			array_pSnrSeq = g_ptr_array_new();
			for(iSnrTblNo = 1; iSnrTblNo < nSnrTblNo; iSnrTblNo++) {
				if(iSnrTblNo != 1) {
					puts("#//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -");
				}
				if(opt_s) {
					printColumns(0,
						GetSnrTblName(iSnrTblNo),
						NULL);
				} else {
					printColumns(0,
						"def",
						GetSnrTblName(iSnrTblNo),
						NULL);
				}
				DumpSnrTbl(1, &TBL_SnrTbl[TBL_SnrTblNo[iSnrTblNo]]);
				printColumns(0,
					"end",
					NULL);
			}
		}
		//ViIV[PX_vB
		puts("#//-----------------------------------------------------------------------------");
		{
			int iSnrSeq;
			for(iSnrSeq = 0; iSnrSeq < array_pSnrSeq->len; iSnrSeq++) {
				unsigned char* pSnrSeq = array_pSnrSeq->pdata[iSnrSeq];
				if(iSnrSeq != 0) {
					puts("#//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -");
				}
				if(opt_s) {
					printColumns(0,
						GetSnrSeqName(pSnrSeq),
						NULL);
				} else {
					printColumns(0,
						"def",
						GetSnrSeqName(pSnrSeq),
						NULL);
				}
				DumpSnrSeq(1, pSnrSeq);	//̒array_pSnrSeq->len\L܂B
				printColumns(0,
					"end",
					NULL);
			}
		}
	}
	return EXIT_SUCCESS;
}
/*--------------------------------------------------------------------------*/
static void printColumns(int indent, ...) {
	char **v = strv_new(NULL), *s;
	va_list ap;
	va_start(ap, indent);
	while(--indent >= 0) {
		strv_extend(&v, "");
	}
	while((s = va_arg(ap, char*)) != NULL) {
		strv_extend(&v, s);
	}
	s = strv_join(v, "\t");
	s = strchomp(s);
	puts(s);
}
/*--------------------------------------------------------------------------*/
static const char* GetTrigName(int iSnrTrg) {
	if(iSnrTrg == SnrTrg_set) { return "set"; }
	if(iSnrTrg == SnrTrg_clr) { return "clr"; }
//{{2017/11/04ǉ:'-l'IvVǉ܂B
	if(opt_l && ((iSnrTrg >= 1) && (iSnrTrg <= array_pTrigName->len - 1))) {
		return g_ptr_array_index(array_pTrigName, iSnrTrg);
	}
//}}2017/11/04ǉ:'-l'IvVǉ܂B
	return strdup_printf("Trg%d", iSnrTrg);
}
/*--------------------------------------------------------------------------*/
static const char* GetFuncName(int iSnrFnc) {
//{{2017/11/04ǉ:'-l'IvVǉ܂B
	if(opt_l && ((iSnrFnc >= 1) && (iSnrFnc <= array_pFuncName->len - 1))) {
		return g_ptr_array_index(array_pFuncName, iSnrFnc);
	}
//}}2017/11/04ǉ:'-l'IvVǉ܂B
	return strdup_printf("Fnc%d", iSnrFnc);
}
/*--------------------------------------------------------------------------*/
static const char* GetSnrTblName(int iSnrTblNo) {
//{{2017/11/04ǉ:'-l'IvVǉ܂B
	if(opt_l && ((iSnrTblNo >= 1) && (iSnrTblNo <= array_pTableName->len - 1))) {
		return g_ptr_array_index(array_pTableName, iSnrTblNo);
	}
//}}2017/11/04ǉ:'-l'IvVǉ܂B
	return strdup_printf("Tbl%d", iSnrTblNo);
}
/*--------------------------------------------------------------------------*/
static const char* GetSnrSeqName(unsigned char* pSnrSeq) {
	int iSnrSeq;
	for(iSnrSeq = 0; iSnrSeq < array_pSnrSeq->len; iSnrSeq++) {
		if(array_pSnrSeq->pdata[iSnrSeq] == pSnrSeq) { break; }
	}
	if(iSnrSeq == array_pSnrSeq->len) {
		g_ptr_array_add(array_pSnrSeq, pSnrSeq);
	}
	if(opt_t) {
		return strdup_printf(".Seq%d", iSnrSeq + 1);
	} else {
		return strdup_printf( "Seq%d", iSnrSeq + 1);
	}
}
/*--------------------------------------------------------------------------*/
static const char* GetNakedArgs(unsigned char* pArgs) {
	const char* s = "";
	int n = *pArgs++;
	if((intptr_t)pArgs & 3) { DIE(); }	//Xg̒l̕4NEɐ񂳂Ă͂(/clip/tool/dSprFntC/winapp.cArgs_CodeGen()̃RgQ)BŒ~f[^oOłB
	if(n) {
		s = strdup_printf("0x%02X", *pArgs++);
		while(--n) {
			s = strdup_printf("%s,0x%02X", s, *pArgs++);
		}
	}
	return s;
}
/*--------------------------------------------------------------------------*/
static const char* GetParenthesizedArgs(unsigned char* pArgs) {
	const char* s = GetNakedArgs(pArgs);
	if(*s || !opt_s) {
		s = strdup_printf("(%s)", s);
	}
	return s;
}
/*--------------------------------------------------------------------------*/
static void DumpSnrTbl(int indent, unsigned char* pSnrTbl) {
	for(;;) {
		int c = *pSnrTbl++;	//
		switch(c) {
		default:DIE();
		case SnrTbl_end:
			return;	//܂
		case SnrTbl_on_unlock:
			{
				int t;
				t = *pSnrTbl++;	//gKԍ
				if(opt_s) {
					printColumns(indent,
						GetTrigName(t),
						"unlock",
						NULL);
				} else {
					printColumns(indent,
						"on",
						GetTrigName(t),
						"unlock",
						NULL);
				}
			}
			break;
		case SnrTbl_on_goto:
		case SnrTbl_on_unlock_goto:
			{
				int t, s, l;
				t =            *pSnrTbl++;	//gKԍ
				s =      (char)*pSnrTbl++;	//ViIV[PXւ̑΋
				s = (s << 8) | *pSnrTbl++;
				s = (s << 8) | *pSnrTbl++;
				l =            *pSnrTbl++;	//bN(0=bN)
				l = (l << 8) | *pSnrTbl++;
				if(opt_s) {
					printColumns(indent,
						GetTrigName(t),
						(c == SnrTbl_on_unlock_goto) ? "unlock" : "",
						"",
						GetSnrSeqName(pSnrTbl + s),
						l ? strdup_printf("%d", l) : "",
						NULL);
				} else {
					printColumns(indent,
						"on",
						GetTrigName(t),
						(c == SnrTbl_on_unlock_goto) ? "unlock" : "",
						"goto",
						GetSnrSeqName(pSnrTbl + s),
						l ? strdup_printf("lock\t%d", l) : "",
						NULL);
				}
			}
			break;
		case SnrTbl_on_exec:
		case SnrTbl_on_unlock_exec:
			{
				int t, s, l;
				t =            *pSnrTbl++;	//gKԍ
				s =      (char)*pSnrTbl++;	//ViIV[PXւ̑΋
				s = (s << 8) | *pSnrTbl++;
				s = (s << 8) | *pSnrTbl++;
				l =            *pSnrTbl++;	//bN(0=bN)
				l = (l << 8) | *pSnrTbl++;
				if(opt_s) {
					printColumns(indent,
						GetTrigName(t),
						(c == SnrTbl_on_unlock_exec) ? "unlock" : "",
						"exec",
						GetSnrSeqName(pSnrTbl + s),
						l ? strdup_printf("%d", l) : "",
						NULL);
				} else {
					printColumns(indent,
						"on",
						GetTrigName(t),
						(c == SnrTbl_on_unlock_exec) ? "unlock" : "",
						"exec",
						GetSnrSeqName(pSnrTbl + s),
						l ? strdup_printf("lock\t%d", l) : "",
						NULL);
				}
			}
			break;
		}
	}
}
/*--------------------------------------------------------------------------*/
static void DumpSnrSeq(int indent, unsigned char* pSnrSeq) {
	for(;;) {
		int c = *pSnrSeq++;	//
		switch(c) {
		default:DIE();
		case SnrSeq_end:
			return;	//܂
		case SnrSeq_exit:
			{
				printColumns(indent,
					"exit",
					NULL);
			}
			break;
		case SnrSeq_escape:
			{
				printColumns(indent,
					"escape",
					NULL);
			}
			break;
		case SnrSeq_wait:
			{
				int w;
				w =            *pSnrSeq++;	//҂(0=G[)
				w = (w << 8) | *pSnrSeq++;
				if(!w) { DIE(); }
				if(opt_s) {
					printColumns(indent,
						"wait",
						(w == 1) ? "" : strdup_printf("%d", w),
						NULL);
				} else {
					printColumns(indent,
						"wait",
						strdup_printf("%d", w),
						NULL);
				}
			}
			break;
		case SnrSeq_wait_for:
		case SnrSeq_wait_for_not:
			{
				int f, a;
				f =            *pSnrSeq++;	//֐ԍ
				a =      (char)*pSnrSeq++;	//Xgւ̑΋
				a = (a << 8) | *pSnrSeq++;
				a = (a << 8) | *pSnrSeq++;
				if(opt_s) {
					printColumns(indent,
						"wait",
						(c == SnrSeq_wait_for_not) ? strdup_printf("not %s%s", GetFuncName(f), GetParenthesizedArgs(pSnrSeq + a))
						                           : strdup_printf(    "%s%s", GetFuncName(f), GetParenthesizedArgs(pSnrSeq + a)),
						NULL);
				} else {
					printColumns(indent,
						"wait for",
						(c == SnrSeq_wait_for_not) ? strdup_printf("not %s%s", GetFuncName(f), GetParenthesizedArgs(pSnrSeq + a))
						                           : strdup_printf(    "%s%s", GetFuncName(f), GetParenthesizedArgs(pSnrSeq + a)),
						NULL);
				}
			}
			break;
		case SnrSeq_fork:
			{
				int s;
				s =      (char)*pSnrSeq++;	//ViIV[PX{fBւ̑΋
				s = (s << 8) | *pSnrSeq++;
				s = (s << 8) | *pSnrSeq++;
				printColumns(indent,
					"fork",
					NULL);
				DumpSnrSeq(indent + 1, pSnrSeq + s);
				printColumns(indent,
					"end",
					NULL);
			}
			break;
		case SnrSeq_hide:
			{
				printColumns(indent,
					"hide",
					NULL);
			}
			break;
		case SnrSeq_join:
			{
				printColumns(indent,
					"join",
					NULL);
			}
			break;
		case SnrSeq_goto:
			{
				int s;
				s =      (char)*pSnrSeq++;	//ViIV[PX{fBւ̑΋
				s = (s << 8) | *pSnrSeq++;
				s = (s << 8) | *pSnrSeq++;
				printColumns(indent,
					"goto",
					GetSnrSeqName(pSnrSeq + s),
					NULL);
			}
			break;
		case SnrSeq_call:
			{
				int s;
				s =      (char)*pSnrSeq++;	//ViIV[PX{fBւ̑΋
				s = (s << 8) | *pSnrSeq++;
				s = (s << 8) | *pSnrSeq++;
				printColumns(indent,
					"call",
					GetSnrSeqName(pSnrSeq + s),
					NULL);
			}
			break;
		case SnrSeq_if:
		case SnrSeq_if_not:
			{
				int f, a, s;
				f =            *pSnrSeq++;	//֐ԍ
				a =      (char)*pSnrSeq++;	//Xgւ̑΋
				a = (a << 8) | *pSnrSeq++;
				a = (a << 8) | *pSnrSeq++;
				s =      (char)*pSnrSeq++;	//ViIV[PX{fBւ̑΋
				s = (s << 8) | *pSnrSeq++;
				s = (s << 8) | *pSnrSeq++;
				printColumns(indent,
					"if",
					(c == SnrSeq_if_not) ? strdup_printf("not %s%s", GetFuncName(f), GetParenthesizedArgs(pSnrSeq + a))
					                     : strdup_printf(    "%s%s", GetFuncName(f), GetParenthesizedArgs(pSnrSeq + a)),
					NULL);
				DumpSnrSeq(indent + 1, pSnrSeq + s);
				for(;;) {
					c = *pSnrSeq++;	//
					if((c == SnrSeq_elif) || (c == SnrSeq_elif_not)) {
						f =            *pSnrSeq++;	//֐ԍ
						a =      (char)*pSnrSeq++;	//Xgւ̑΋
						a = (a << 8) | *pSnrSeq++;
						a = (a << 8) | *pSnrSeq++;
						s =      (char)*pSnrSeq++;	//ViIV[PXւ̑΋
						s = (s << 8) | *pSnrSeq++;
						s = (s << 8) | *pSnrSeq++;
						printColumns(indent,
							"elif",
							(c == SnrSeq_elif_not) ? strdup_printf("not %s%s", GetFuncName(f), GetParenthesizedArgs(pSnrSeq + a))
							                       : strdup_printf(    "%s%s", GetFuncName(f), GetParenthesizedArgs(pSnrSeq + a)),
							NULL);
						DumpSnrSeq(indent + 1, pSnrSeq + s);
					} else if(c == SnrSeq_else) {
						s =      (char)*pSnrSeq++;	//ViIV[PX{fBւ̑΋
						s = (s << 8) | *pSnrSeq++;
						s = (s << 8) | *pSnrSeq++;
						printColumns(indent,
							"else",
							NULL);
						DumpSnrSeq(indent + 1, pSnrSeq + s);
					} else {
						pSnrSeq--;
						break;
					}
				}
				printColumns(indent,
					"end",
					NULL);
			}
			break;
		case SnrSeq_case:
			{
				int f, a, s, v;
				f =            *pSnrSeq++;	//֐ԍ
				a =      (char)*pSnrSeq++;	//Xgւ̑΋
				a = (a << 8) | *pSnrSeq++;
				a = (a << 8) | *pSnrSeq++;
				if(opt_s) {
					printColumns(indent,
						"case",
						strdup_printf("%s%s", GetFuncName(f), GetParenthesizedArgs(pSnrSeq + a)),
						NULL);
				} else {
					printColumns(indent,
						"case",
						strdup_printf("%s%s", GetFuncName(f), GetParenthesizedArgs(pSnrSeq + a)),
						"of",
						NULL);
				}
				if(*pSnrSeq != SnrSeq_of) { DIE(); }
				for(;;) {
					c = *pSnrSeq++;	//
					if(c == SnrSeq_of) {
						v =            *pSnrSeq++;	//l
						s =      (char)*pSnrSeq++;	//ViIV[PXւ̑΋
						s = (s << 8) | *pSnrSeq++;
						s = (s << 8) | *pSnrSeq++;
						printColumns(indent,
							strdup_printf("%d", v),
							NULL);
						DumpSnrSeq(indent + 1, pSnrSeq + s);
					} else if(c == SnrSeq_else) {
						s =      (char)*pSnrSeq++;	//ViIV[PX{fBւ̑΋
						s = (s << 8) | *pSnrSeq++;
						s = (s << 8) | *pSnrSeq++;
						printColumns(indent,
							"else",
							NULL);
						DumpSnrSeq(indent + 1, pSnrSeq + s);
					} else {
						pSnrSeq--;
						break;
					}
				}
				printColumns(indent,
					"end",
					NULL);
			}
			break;
		case SnrSeq_repeat:
			{
				int r, s;
				r =            *pSnrSeq++;	//JԂ(0=G[,65535=)
				r = (r << 8) | *pSnrSeq++;
				s =      (char)*pSnrSeq++;	//ViIV[PXւ̑΋
				s = (s << 8) | *pSnrSeq++;
				s = (s << 8) | *pSnrSeq++;
				if(!r) { DIE(); }
				printColumns(indent,
					"repeat",
					(r == 65535/**/) ? "" : strdup_printf("%d", r),
					NULL);
				DumpSnrSeq(indent + 1, pSnrSeq + s);
				printColumns(indent,
					"end",
					NULL);
			}
			break;
		case SnrSeq_break:
			{
				int n;
				n = *pSnrSeq++;	//lXgrepeat𔲂鐔(0=G[)
				if(!n) { DIE(); }
				if(opt_s) {
					printColumns(indent,
						"break",
						(n == 1) ? "" : strdup_printf("%d", n),
						NULL);
				} else {
					printColumns(indent,
						"break",
						strdup_printf("%d", n),
						NULL);
				}
			}
			break;
		case SnrSeq_while:
		case SnrSeq_while_not:
			{
				int f, a, s;
				f =            *pSnrSeq++;	//֐ԍ
				a =      (char)*pSnrSeq++;	//Xgւ̑΋
				a = (a << 8) | *pSnrSeq++;
				a = (a << 8) | *pSnrSeq++;
				s =      (char)*pSnrSeq++;	//ViIV[PXւ̑΋
				s = (s << 8) | *pSnrSeq++;
				s = (s << 8) | *pSnrSeq++;
				printColumns(indent,
					"while",
					(c == SnrSeq_while_not) ? strdup_printf("not %s%s", GetFuncName(f), GetParenthesizedArgs(pSnrSeq + a))
					                        : strdup_printf(    "%s%s", GetFuncName(f), GetParenthesizedArgs(pSnrSeq + a)),
					NULL);
				DumpSnrSeq(indent + 1, pSnrSeq + s);
				printColumns(indent,
					"end",
					NULL);
			}
			break;
		case SnrSeq_act:
		case SnrSeq_act_ensure:
			{
				int f, a;
				f =            *pSnrSeq++;	//֐ԍ
				a =      (char)*pSnrSeq++;	//Xgւ̑΋
				a = (a << 8) | *pSnrSeq++;
				a = (a << 8) | *pSnrSeq++;
				if(opt_s) {
					printColumns(indent,
						GetFuncName(f),
						GetNakedArgs(pSnrSeq + a),
						(c == SnrSeq_act_ensure) ? "ensure" : "",
						NULL);
				} else {
					printColumns(indent,
						"act",
						strdup_printf("%s%s", GetFuncName(f), GetParenthesizedArgs(pSnrSeq + a)),
						(c == SnrSeq_act_ensure) ? "ensure" : "",
						NULL);
				}
			}
			break;
		}
	}
}
