/*****************************************************************************
 * Bison/FlexvOeXg邽߂́AWindowsAvP[V̐^ *
 * rhEs@:                                                       *
 * "C:\Program Files (x86)\Microsoft Visual Studio\VC98\Bin\VCVARS32.BAT"  *
 * make -f winapp.mk run                                                   *
 *****************************************************************************/
#include "winapp.h"
//-----------------------------------------------------------------------------
//{{^R[h:winapp.c(擪)================================================
/*---------------------------------------------------------------------------*/
//G[Op
static char err_path[_MAX_PATH];	//'-e'IvVw肳ꂽAG[Ot@Ci[B
static FILE* fp_err;			//ŏ̃G[OL^鎞ɁAG[Ot@C쐬B
//{{2016/09/24ǉ:G[bZ[WɁA݂̍sԍłȂÃ݂t@C\悤ɂ܂B
typedef struct _ST_Location {
	const char*	path;					//push_location()ĂяoꂽÕt@C
	int		line;					//push_location()ĂяoꂽO̍sԍ
} ST_Location;
static ST_Location TBL_Location[16/**/];			//P[VX^bN
static nLocation;						//P[VX^bN̊i[
static const char* filename = "-";				//݂̃t@C(popen̓R}h)B݂̍sԍyylinenoQƂĉB
static void init_location(const char* path) {
	nLocation = 0;						//P[VX^bNɂB
	filename = strdup(path);				//݂̃t@CRs[ĕێB
	yylineno = 1;						//݂̍sԍB	yylex_init()łĂ̂ł̍s͖Ă\Ȃ̂AՂ̂߂ɂł鎖ɂB
}
void push_location(const char* path) {
	if(nLocation >= ARRAY_SIZE(TBL_Location)) { DIE(); }	//P[VX^bNtłȂmFB
	TBL_Location[nLocation].path = filename;		//݂̃t@CP[VX^bNɑޔB
	TBL_Location[nLocation].line = yylineno;		//݂̍sԍP[VX^bNɑޔB
	nLocation++;						//P[VX^bN̊i[𑝂₷B
	filename = strdup(path);				//݂̃t@CRs[ĕێB
	yylineno = 1;						//݂̍sԍB
}
void pop_location() {
	if(!nLocation) { DIE(); }				//P[VX^bNłȂmFB
	nLocation--;						//P[VX^bN̊i[炷B
	filename = TBL_Location[nLocation].path;		//݂̃t@CP[VX^bN畜B
	yylineno = TBL_Location[nLocation].line;		//݂̍sԍP[VX^bN畜B
}
//}}2016/09/24ǉ:G[bZ[WɁA݂̍sԍłȂÃ݂t@C\悤ɂ܂B
void yyerror(const char* fmt, ...) {	//{{2015/03/06:'-e'IvVΉ̂߂winapp.cړ܂B}}
	//'-e'IvVw肳ĂāAŏ̃G[OL^鎞Ȃ΁c
	if(*err_path && !fp_err) {
		//G[Ot@C쐬B
		fp_err = fopen(err_path, "w");
		if(!fp_err) { error(EXIT_FAILURE, errno, "%s 쐬ł܂B", err_path); }	//{{2016/09/21ύX:die(`)ŏIĂӏAerror(EXIT_FAILURE,`)ŏI悤ɕύX܂B}}	//{{2016/09/28ύX:error()̍̕Ōɗ]vȉstĂ̂폜܂B}}
		//G[Ot@C̏o̓Xg[́Aobt@OƂB
		// - die()ŏI(abort())ɁAobt@tbVȂ悤Ȃ̂ŁAĂKvLB
		//   ʂ̈ĂƂāẢ̏Ŗfflush()@L邪Aobt@OƂȒP낤B
		setbuf(fp_err, NULL);
	}
	//G[bZ[W(,y,G[O)o͂B
//{{2016/09/24ύX:G[bZ[WɁA݂̍sԍłȂÃ݂t@C\悤ɂ܂B
//	             fprintf(stderr, "### error at line %d : ", yylineno);	//G[bZ[W
//	if(fp_err) { fprintf(fp_err, "### error at line %d : ", yylineno); }	//G[O
//2016/09/24ύX:G[bZ[WɁA݂̍sԍłȂÃ݂t@C\悤ɂ܂B
	             fprintf(stderr, "%s(%d) : ", filename, yylineno);		//G[bZ[W
	if(fp_err) { fprintf(fp_err, "%s(%d) : ", filename, yylineno); }	//G[O
//}}2016/09/24ύX:G[bZ[WɁA݂̍sԍłȂÃ݂t@C\悤ɂ܂B
	{
		va_list ap;
		va_start(ap, fmt);
		             vfprintf(stderr, fmt, ap);		//G[bZ[W
		if(fp_err) { vfprintf(fp_err, fmt, ap); }	//G[O
		va_end(ap);
	}
	             fputc('\n', stderr);	//G[bZ[W
	if(fp_err) { fputc('\n', fp_err); }	//G[O
}
/*---------------------------------------------------------------------------*/
//}}^R[h:winapp.c(擪)================================================
//-----------------------------------------------------------------------------
//x`
enum {
	WARN_CAST,			//Öق̌^ϊŌ덷Ax\ŏIIɃG[I܂B̃IvVw肵Ȃ΁Ax\G[I܂B
};
static const char* const warn_tokens[]={
	"cast",				//Öق̌^ϊŌ덷Ax\ŏIIɃG[I܂B̃IvVw肵Ȃ΁Ax\G[I܂B
NULL};//I[
int warn;				//ex(WARN_*)ɂ(warn&(1<<WARN_*))ZbgĂ炻̌xOnł鎖܂B
/*---------------------------------------------------------------------------*/
//I
static char* opt_x = "c";		//"c"=C`,"cs"=C#`
/*---------------------------------------------------------------------------*/
//[Jϐ`
static GTree* tree_pSnrTbl;		//ViIe[ux(ST_SnrTbl*)
static GTree* tree_pSnrSeq;		//ViIV[PXx(ST_SnrSeq*)
static GTree* tree_pSnrSeq_Used;	//ViIV[PXx(ST_SnrSeq*)	2pXڂł̃}[NpB
static GTree* tree_pArg;		//(ST_Arg*)Pꉻēo^B
static GTree* tree_pArgList;		//(GSList*)Pꉻēo^B(GSList*)̗vf(ST_Arg*)łB
static GTree* tree_pArgs;		//(ST_Args*)Pꉻēo^B
static GTree* tree_pArgs_Used;		//(ST_Args*)Pꉻēo^B		2pXڂł̃}[NpB
static GTree* tree_pArgs_Blob;		//(ST_Args*)BLOBf[^			2pXڂłBLOB\zpB
static GTree* tree_pArgs_Code;		//(ST_Args*)(ST_Code*)			2pXڂł̃R[hpB
static GTree* tree_pFunc;		//(ST_Func*)Pꉻēo^B
static GTree* tree_pCond;		//(ST_Cond*)Pꉻēo^B
static GTree* tree_pCondSubs;		//(ST_CondSubs*)Pꉻēo^B
static GTree* tree_pCondSubsList;	//(GSList*)Pꉻēo^B(GSList*)̗vf(ST_CondSubs*)łB
static GTree* tree_pValueSubs;		//(ST_ValueSubs*)Pꉻēo^B
static GTree* tree_pValueSubsList;	//(GSList*)Pꉻēo^B(GSList*)̗vf(ST_ValueSubs*)łB
static GTree* tree_pSnrTblBody;		//(ST_SnrTblBody*)Pꉻēo^B
static GTree* tree_pSnrTblBody_Code;	//(ST_SnrTblBody*)(ST_Code*)			2pXڂł̃R[hpB
static GTree* tree_pSnrTblStmt;		//(ST_SnrTblStmt*)Pꉻēo^B
static GTree* tree_pSnrSeqBody;		//(ST_SnrSeqBody*)Pꉻēo^B
static GTree* tree_pSnrSeqBody_Used;	//(ST_SnrSeqBody*)Pꉻēo^B	2pXڂł̃}[NpB
static GTree* tree_pSnrSeqBody_Code;	//(ST_SnrSeqBody*)(ST_Code*)			2pXڂł̃R[hpB
static GTree* tree_pSnrSeqStmt;		//(ST_SnrSeqStmt*)Pꉻēo^B
static GTree* tree_pTrigName_No;	//gK˃gKԍ				1pXڂœo^܂BViIe[uċAIɒHȂViIe[uɊ܂܂ĂgKo͑ΏۂƂ邽߂łB
static GTree* tree_pFuncName_No;	//֐ˊ֐ԍ				1pXڂœo^܂BViIe[uċAIɒHȂViIV[PXɊ܂܂Ă֐o͑ΏۂƂ邽߂łB
static int endAddr;			//ŏIAhX
//[Jx
static int nAtmarkLocalLabel;			//'@'[Jx̏o		//'@@'oA'@%d'Ƃ`̓[JxɕϊB̌A+1BvɁAɏo'@@'̔ԍ\ĂƌȂ̂ŁA'@F'́AnAtmarkLocalLabelŎQƂłB'@B'́A(nAtmarkLocalLabel-1)ŎQƂłB
static const char* sDotLocalLabelPrefix = "";	//'.'[Jx̃vtBNX	//'.`'oA'%s.`'Ƃ`̓[JxɕϊBO[ox̒`oAsDotLocalLabelPrefixXVBʂƂāAO[ox``O[ox`̊Ԃł̃[JxƂȂB
//x̃\[g@
int (*fnLabCmp)(const void*, const void*) = strcmp;	//'n',,'nl'IvVw肳ꂽstrnatcmpɕύXB
//gK̃\[g@
int (*fnTrgCmp)(const void*, const void*) = strcmp;	//'n',,'nt'IvVw肳ꂽstrnatcmpɕύXB
//֐̃\[g@
int (*fnFncCmp)(const void*, const void*) = strcmp;	//'n',,'nf'IvVw肳ꂽstrnatcmpɕύXB
//{{i\p
static int opt_q;
static int newMsgLen, oldMsgLen = 0;
//}}i\p
/*---------------------------------------------------------------------------*/
//[J֐錾
__declspec(noreturn) static void usage();
static int subr(int argc, char* argv[]);
static void pass2(int bOptimize);
static void optimize();
static void output(const char* sBinOut, const char* sTblOut, int bLabTbl);
/*---------------------------------------------------------------------------*/
int main(int argc, char* argv[]) {
	int exitCode;
	SEH_init();
	exitCode = subr(argc, argv);
	return exitCode;
}
/*---------------------------------------------------------------------------*/
static int subr(int argc, char* argv[]) {
	int opt, bOptimize = 1;		//'-d'IvVw肳Ȃ΍œKsB
	const char* sBinOut = NULL;	//'-o'IvVw肳ꂽoCio̓t@Cݒ肷B
	const char* sTblOut = NULL;	//'-t'IvVw肳ꂽ֐e[ut@Cݒ肷B
	int bLabTbl = 0;		//0=xe[ui[ȂB1=xe[ui[B
#if     (YYDEBUG!=0)
//	yydebug = 1; //nonzero means print parse trace
#endif/*(YYDEBUG!=0)*/
	//R}hCIvVB
	opterr = 0; //IvVG[͓vOŏ̂ŁAgetopt()ł̃G[\͕svB
	while((opt = getopt(argc, argv, "do:t:len::w::x:qh")) != -1) {
		switch(opt) {
		case 'd':
			bOptimize = 0;		//œKsȂB
			break;
		case 'o':
			sBinOut = optarg;	//oCio̓t@Cݒ肷B
			break;
		case 't':
			sTblOut = optarg;	//֐e[ut@Cݒ肷B
			break;
		case 'l':
			bLabTbl = 1;		//xe[ui[B
			break;
		case 'e':
			{
				//G[Ot@C쐬B
				// - JgtH_'st@C.err'ƂOŐ鎖ɂB̓́A'lk33.exe'̎dlQlɂB
				char fname[_MAX_FNAME];
				_splitpath(argv[0], NULL, NULL, fname, NULL);
				_makepath(err_path, NULL, NULL, fname, ".err");
				//'-e'IvVw肳ꂽAŏɊmɁÃG[Ot@C폜ĂB
				//OɐG[OcĂāA񐶐G[Oƍ댯邽߂łB
				//A'-e'IvVw肳Ȃꍇ́ÃG[Ot@C폜鏈͍sȂB
				remove(err_path);
			}
			break;
		case 'n':
			if(optarg) {
				     if(!strcmp(optarg, "l")) { fnLabCmp = strnatcmp; }	//x̃\[gstrnatcmp()gpB
				else if(!strcmp(optarg, "t")) { fnTrgCmp = strnatcmp; }	//gK̃\[gstrnatcmp()gpB
				else if(!strcmp(optarg, "f")) { fnFncCmp = strnatcmp; }	//֐̃\[gstrnatcmp()gpB
				else { usage(); }
			} else {
				fnLabCmp = fnTrgCmp = fnFncCmp = strnatcmp;	//xƃgKƊ֐̃\[gstrnatcmp()gpB
			}
			break;
		case 'w':
			if(optarg) {
				char *optionp = optarg, *valuep;
				while(*optionp) {
					switch(getsubopt(&optionp, (char* const*)warn_tokens, &valuep)) {
					case WARN_CAST:
						if(valuep) { usage(); }
						warn |= (1<<WARN_CAST);
						break;
					default:
						usage();
					}
				}
			} else {
				warn = -1;
			}
			break;
		case 'x':
			opt_x = optarg;		//Iݒ肷B
			if(strcmp(opt_x, "c") && strcmp(opt_x, "cs")) { usage(); }
			break;
		case 'q':
			opt_q = 1;
			break;
		case 'h':
		default:
			usage();
		}
	}
	//쐬B
	tree_pSnrTbl		= g_tree_new(fnLabCmp);
	tree_pSnrSeq		= g_tree_new(fnLabCmp);
	tree_pSnrSeq_Used	= g_tree_new(fnLabCmp);
	tree_pArg		= g_tree_new(Arg_Compar);
	tree_pArgList		= g_tree_new(ArgList_Compar);
	tree_pArgs		= g_tree_new(Args_Compar);
	tree_pArgs_Used		= g_tree_new(Args_Compar);
	tree_pArgs_Blob		= g_tree_new(Args_Compar);
	tree_pArgs_Code		= g_tree_new(Args_Compar);
	tree_pFunc		= g_tree_new(Func_Compar);
	tree_pCond		= g_tree_new(Cond_Compar);
	tree_pCondSubs		= g_tree_new(CondSubs_Compar);
	tree_pCondSubsList	= g_tree_new(CondSubsList_Compar);
	tree_pValueSubs		= g_tree_new(ValueSubs_Compar);
	tree_pValueSubsList	= g_tree_new(ValueSubsList_Compar);
	tree_pSnrTblBody	= g_tree_new(SnrTblBody_Compar);
	tree_pSnrTblBody_Code	= g_tree_new(SnrTblBody_Compar);
	tree_pSnrTblStmt	= g_tree_new(SnrTblStmt_Compar);
	tree_pSnrSeqBody	= g_tree_new(SnrSeqBody_Compar);
	tree_pSnrSeqBody_Used	= g_tree_new(SnrSeqBody_Compar);
	tree_pSnrSeqBody_Code	= g_tree_new(SnrSeqBody_Compar);
	tree_pSnrSeqStmt	= g_tree_new(SnrSeqStmt_Compar);
	tree_pTrigName_No	= g_tree_new(TrigName_Compar);
	tree_pFuncName_No	= g_tree_new(fnFncCmp);
	//--- 1pXڂ̏ ---
	//t@Cw肳ĂȂ΁AW͂ǂݍށB
	if(optind == argc) {
		init_location("-");	//{{2016/09/24ǉ:G[bZ[WɁA݂̍sԍłȂÃ݂t@C\悤ɂ܂B}}
		yylex_init(stdin);
	    //{{2015/02/23C:vIȃG[ꍇ(yyparse()!=0)̂ݒfBZ}eBNXG[(yynerrs!=0)ȂΑSẴZ}eBNXG[񍐂邽߂ɌpB
	    //	if((yyparse() != 0) || (yynerrs != 0)) { die("G[܂B\n"); }
	    //2015/02/23C:vIȃG[ꍇ(yyparse()!=0)̂ݒfBZ}eBNXG[(yynerrs!=0)ȂΑSẴZ}eBNXG[񍐂邽߂ɌpB
		if((yyparse() != 0) /*|| (yynerrs != 0)*/) { error(EXIT_FAILURE, 0, "G[܂B"); }	//{{2016/09/21ύX:die(`)ŏIĂӏAerror(EXIT_FAILURE,`)ŏI悤ɕύX܂B}}	//{{2016/09/28ύX:error()̍̕Ōɗ]vȉstĂ̂폜܂B}}
	    //}}2015/02/23C:vIȃG[ꍇ(yyparse()!=0)̂ݒfBZ}eBNXG[(yynerrs!=0)ȂΑSẴZ}eBNXG[񍐂邽߂ɌpB
	//t@Cw肳ĂAet@CǂݍށB
	} else {
		int i;
		for(i = optind; i < argc; i++) {
			FILE* fp = fopen(argv[i], "r");
			if(!fp) { error(EXIT_FAILURE, errno, "%s J܂B", argv[i]); }	//{{2016/09/21ύX:die(`)ŏIĂӏAerror(EXIT_FAILURE,`)ŏI悤ɕύX܂B}}	//{{2016/09/28ύX:error()̍̕Ōɗ]vȉstĂ̂폜܂B}}
			init_location(argv[i]);	//{{2016/09/24ǉ:G[bZ[WɁA݂̍sԍłȂÃ݂t@C\悤ɂ܂B}}
			yylex_init(fp);
		    //{{2015/02/23C:vIȃG[ꍇ(yyparse()!=0)̂ݒfBZ}eBNXG[(yynerrs!=0)ȂΑSẴZ}eBNXG[񍐂邽߂ɌpB
		    //	if((yyparse() != 0) || (yynerrs != 0)) { die("%s: G[܂B\n", argv[i]); }
		    //2015/02/23C:vIȃG[ꍇ(yyparse()!=0)̂ݒfBZ}eBNXG[(yynerrs!=0)ȂΑSẴZ}eBNXG[񍐂邽߂ɌpB
//{{2017/03/16ύX:̓̓t@Cw肵ɁAŌȊÕt@CŃG[ꍇAc[̏IXe[^X0ɂȂĂoOC܂B
//			if((yyparse() != 0) /*|| (yynerrs != 0)*/) { error(EXIT_FAILURE, 0, "%s: G[܂B", argv[i]); }	//{{2016/09/21ύX:die(`)ŏIĂӏAerror(EXIT_FAILURE,`)ŏI悤ɕύX܂B}}	//{{2016/09/28ύX:error()̍̕Ōɗ]vȉstĂ̂폜܂B}}
//2017/03/16ύX:̓̓t@Cw肵ɁAŌȊÕt@CŃG[ꍇAc[̏IXe[^X0ɂȂĂoOC܂B
			{
				int save_yynerrs = yynerrs;	//yyparse()yynerrsNÂŁȂOɌ݂yynerrsۑĂB
				if((yyparse() != 0) /*|| (yynerrs != 0)*/) { error(EXIT_FAILURE, 0, "%s: G[܂B", argv[i]); }	//{{2016/09/21ύX:die(`)ŏIĂӏAerror(EXIT_FAILURE,`)ŏI悤ɕύX܂B}}	//{{2016/09/28ύX:error()̍̕Ōɗ]vȉstĂ̂폜܂B}}
				yynerrs += save_yynerrs;	//yyparse()0琔ł낤yynerrsɑ΂āAقǕۑĂyynerrs𑫂ށB
			}
//}}2017/03/16ύX:̓̓t@Cw肵ɁAŌȊÕt@CŃG[ꍇAc[̏IXe[^X0ɂȂĂoOC܂B
		    //}}2015/02/23C:vIȃG[ꍇ(yyparse()!=0)̂ݒfBZ}eBNXG[(yynerrs!=0)ȂΑSẴZ}eBNXG[񍐂邽߂ɌpB
			fclose(fp);
		}
	}
    //{{i\p
	if(!opt_q) {
		newMsgLen = fprintf(stderr, "\rpass1 ok");
		if(oldMsgLen > newMsgLen) { fprintf(stderr, "%*s", oldMsgLen - newMsgLen, ""); } putc('\n', stderr); oldMsgLen = 0;
	}
    //}}i\p
	//1pXڂ̏ŃG[ĂA2pXڂ̏sāASẴZ}eBNXG[񍐂B
	//--- 2pXڂ̏ ---
	//2pXڂ̏sB
	pass2(bOptimize);
    //{{i\p
	if(!opt_q) {
		newMsgLen = fprintf(stderr, "\rpass2 ok");
		if(oldMsgLen > newMsgLen) { fprintf(stderr, "%*s", oldMsgLen - newMsgLen, ""); } putc('\n', stderr); oldMsgLen = 0;
	}
    //}}i\p
	if(yynerrs != 0) { error(EXIT_FAILURE, 0, "G[܂B"); }	//1pX,,2pXڂ̏ŃG[ĂAo͏sȂB	//{{2016/09/21ύX:die(`)ŏIĂӏAerror(EXIT_FAILURE,`)ŏI悤ɕύX܂B}}	//{{2016/09/28ύX:error()̍̕Ōɗ]vȉstĂ̂폜܂B}}
	//--- o͏ ---
	//o͏sB
	output(sBinOut, sTblOut, bLabTbl);
	if(yynerrs != 0) { error(EXIT_FAILURE, 0, "G[܂B"); }	//{{2016/09/21ύX:die(`)ŏIĂӏAerror(EXIT_FAILURE,`)ŏI悤ɕύX܂B}}	//{{2016/09/28ύX:error()̍̕Ōɗ]vȉstĂ̂폜܂B}}
	return EXIT_SUCCESS;
}
/*---------------------------------------------------------------------------*/
//g\ďIB
__declspec(noreturn) static void usage() {
	fprintf(stderr, "dSnrSeqC - ViIV[PTRpC (%s)\n", VERSION);
	fprintf(stderr, "Copyright (C) 2017-2018 Naoyuki Sawa\n");
	fprintf(stderr, "\n");
	fprintf(stderr, "USAGE:\n");
	fprintf(stderr, "  dSnrSeqC [option ...] [filename ...] \n");
	fprintf(stderr, "  Efilenamew肵Ȃ΁AW͂ǂݍ݂܂B\n");
	fprintf(stderr, "  EfilenaméAChJ[hɂ镡w\łB\n");
	fprintf(stderr, "\n");
	fprintf(stderr, "OPTIONS:\n");
	fprintf(stderr, "  -d             œKs܂B\n");
	fprintf(stderr, "                 ̃IvVw肵Ȃ΁AœKs܂B\n");
	fprintf(stderr, "  -ot@C   ViĨoCif[^AoCi`Ńt@C֏o͂܂B\n");
	fprintf(stderr, "                 ̃IvVw肵Ȃ΁AC\[X`ŕWo͂֏o͂܂B\n");
	fprintf(stderr, "                 ̃IvV̎wɊւ炸Ax͏ɕWo͂֏o͂܂B\n");
	fprintf(stderr, "  -tt@C   ֐e[uC\[XAt@C֏o͂܂B\n");
	fprintf(stderr, "                 ̃IvVw肵Ȃ΁A֐ԍWo͂֏o͂܂B\n");
	fprintf(stderr, "  -l             ViIf[^ɁAxe[ui[܂B\n");
	fprintf(stderr, "                 ̃IvVw肵Ȃ΁Axe[ui[܂B\n");
	fprintf(stderr, "  -e             G[Ot@C𐶐܂B\n");
	fprintf(stderr, "                 ̃IvVw肵ĂAG[Ȃΐ܂B\n");
	fprintf(stderr, "  -n             xƃgKƊ֐̃\[gɁAstrnatcmp()gp܂B\n");
	fprintf(stderr, "  -nl            x̃\[gɁAstrnatcmp()gp܂B\n");
	fprintf(stderr, "  -nt            gK̃\[gɁAstrnatcmp()gp܂B\n");
	fprintf(stderr, "  -nf            ֐̃\[gɁAstrnatcmp()gp܂B\n");
	fprintf(stderr, "                 ̃IvVw肵Ȃ΁Astrcmp()gp܂B\n");
	fprintf(stderr, "  -w             SĂ̌xLɂ܂B\n");
	fprintf(stderr, "                 ̃IvVw肵Ȃ΁Aʂɐݒ肵x݂̂LɂȂ܂B\n");
	fprintf(stderr, "  -wcast         Öق̌^ϊŌ덷Ax\ŏIIɃG[I܂B\n");
	fprintf(stderr, "                 ̃IvVw肵Ȃ΁Ax\G[I܂B\n");
	fprintf(stderr, "  -xc            o̓\[XC`Ƃ܂B(l)\n");
	fprintf(stderr, "  -xcs           o̓\[XC#`Ƃ܂B\n");
	fprintf(stderr, "  -q             i\}܂B\n");
	fprintf(stderr, "  -h             g\܂B\n");
	fprintf(stderr, "\n");
	fprintf(stderr, "EXAMPLE:\n");
	fprintf(stderr, "  @dSnrSeqC.exe SnrSeq.txt > SnrSeq.c\n");
	fprintf(stderr, "  @SnrSeq.txtRpCāASnrSeq.c֏o͂܂B\n");
	fprintf(stderr, "  AdSnrSeqC.exe -oSnrSeq.bin SnrSeq.txt > SnrSeq.h\n");
	fprintf(stderr, "  @SnrSeq.txtRpCāAxSnrSeq.h֏o͂܂B\n");
	fprintf(stderr, "  @ViĨoCif[^ASnrSeq.bin֏o͂܂B\n");
	exit(EXIT_FAILURE);
}
/*---------------------------------------------------------------------------*/
//1pXڂ̏
/*- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -*/
int cast_dbl_to_int(double d) {
	int i = d;
	if(i != d) {
		if(warn & (1<<WARN_CAST)) {
			yyerror("؂̂Č덷܂: %f  %d", d, i);
			yynerrs++;	//Ăяo(main)ɒm点邽߂ɁB
			//SẴZ}eBNXG[񍐂邽߂ɌpB
		}
	}
	return i;
}
/*- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -*/
void addSnrTbl(ST_SnrTbl* pSnrTbl) {
	char* pSnrTblLabel = pSnrTbl->pSnrTblLabel;
    //{{i\p
	if(!opt_q) {
		newMsgLen = fprintf(stderr, "\rpass1 %s", pSnrTblLabel);
		if(oldMsgLen > newMsgLen) { fprintf(stderr, "%*s", oldMsgLen - newMsgLen, ""); } oldMsgLen = newMsgLen;
	}
    //}}i\p
	//̃ViIe[uo^B
	if(g_tree_lookup(tree_pSnrTbl, pSnrTblLabel)) {
		yyerror("ViIe[uxdĂ܂B(%s)", pSnrTblLabel);
		yynerrs++;	//Ăяo(main)ɒm点邽߂ɁB
		return;		//SẴZ}eBNXG[񍐂邽߂ɌpB
	}
	g_tree_insert(tree_pSnrTbl, pSnrTblLabel, pSnrTbl);
}
/*- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -*/
void addSnrSeq(ST_SnrSeq* pSnrSeq) {
	char* pSnrSeqLabel = pSnrSeq->pSnrSeqLabel;
    //{{i\p
	if(!opt_q) {
		newMsgLen = fprintf(stderr, "\rpass1 %s", pSnrSeqLabel);
		if(oldMsgLen > newMsgLen) { fprintf(stderr, "%*s", oldMsgLen - newMsgLen, ""); } oldMsgLen = newMsgLen;
	}
    //}}i\p
	//̃ViIV[PXo^B
	if(g_tree_lookup(tree_pSnrSeq, pSnrSeqLabel)) {
		yyerror("ViIV[PXxdĂ܂B(%s)", pSnrSeqLabel);
		yynerrs++;	//Ăяo(main)ɒm点邽߂ɁB
		return;		//SẴZ}eBNXG[񍐂邽߂ɌpB
	}
	g_tree_insert(tree_pSnrSeq, pSnrSeqLabel, pSnrSeq);
}
/*- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -*/
char* LabDef_New(char* pLabel) {
    //{{[Jx̏
	if(pLabel[0] == '@') {
		if(pLabel[1] == '@') {	//'@@'
			pLabel = strdup_printf("@%d", nAtmarkLocalLabel++);	//[JxɕϊB̌A+1B
		} else {		//'@B','@F'
			yyerror("x`słB(%s)", pLabel);
			return NULL;	//y.tab.y̏YYERRORsB
		}
	} else if(pLabel[0] == '.') {
		pLabel = strconcat(sDotLocalLabelPrefix, pLabel, NULL);		//[JxɕϊB
	} else {
		sDotLocalLabelPrefix = pLabel;					//O[ox̒`oAsDotLocalLabelPrefixXVB
	}
    //}}[Jx̏
	return pLabel;
}
/*- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -*/
char* LabRef_New(char* pLabel) {
    //{{[Jx̏
	if(pLabel[0] == '@') {
		if(pLabel[1] == 'B') {		//'@B'
			pLabel = strdup_printf("@%d", nAtmarkLocalLabel - 1);	//'@B'́A(nAtmarkLocalLabel-1)ŎQƂłB'@@'oO'@B'QƂꍇ-1ɂȂĂ܂A2pXڂɖ`xƂăG[oł͂łASłB
		} else if(pLabel[1] == 'F') {	//'@F'
			pLabel = strdup_printf("@%d", nAtmarkLocalLabel);	//'@F'́AnAtmarkLocalLabelŎQƂłB̌'@@'oȂΑ݂Ȃ[JxQƂĂ܂A2pXڂɖ`xƂăG[oł͂łASł
		} else {			//'@@'
			yyerror("xQƂsłB(%s)", pLabel);
			return NULL;	//y.tab.y̏YYERRORsB
		}
	} else if(pLabel[0] == '.') {
		pLabel = strconcat(sDotLocalLabelPrefix, pLabel, NULL);		//[JxɕϊB
	}
    //}}[Jx̏
	return pLabel;
}
/*- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -*/
int TrigName_Compar(const void* _a, const void* _b) {
	char* a = (char*)_a;
	char* b = (char*)_b;
	if((!strcmp(a, "set")) && ( strcmp(b, "set"))) { return -1; }	//((a=="set")&&(b!="set"))(a<b)
	if(( strcmp(a, "set")) && (!strcmp(b, "set"))) { return  1; }	//((a!="set")&&(b=="set"))(a>b)
	if((!strcmp(a, "clr")) && ( strcmp(b, "clr"))) { return  1; }	//((a=="clr")&&(b!="clr"))(a>b)
	if(( strcmp(a, "clr")) && (!strcmp(b, "clr"))) { return -1; }	//((a!="clr")&&(b=="clr"))(a<b)
	return (*fnTrgCmp)(a, b);
}
/*- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -*/
ST_Arg* Arg_NewBit(int n) {
	ST_Arg* pArg = calloc(1, sizeof(ST_Arg));
	if(!pArg) { DIE(); }
	if((unsigned)n > 1) {
		yyerror("bitl͈͊OłB(%d)", n);
		return NULL;	//y.tab.y̏YYERRORsB
	}
	pArg->iArgType		= ArgType_Bit;
	pArg->value.v_bit	= n;
	return pArg;
}
/*- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -*/
ST_Arg* Arg_NewByte(int n) {
	ST_Arg* pArg = calloc(1, sizeof(ST_Arg));
	if(!pArg) { DIE(); }
	if((unsigned)n > UINT8_MAX) {
		yyerror("bytel͈͊OłB(%d)", n);
		return NULL;	//y.tab.y̏YYERRORsB
	}
	pArg->iArgType		= ArgType_Byte;
	pArg->value.v_byte	= n;
	return pArg;
}
/*- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -*/
ST_Arg* Arg_NewHalf(int n) {
	ST_Arg* pArg = calloc(1, sizeof(ST_Arg));
	if(!pArg) { DIE(); }
	if((unsigned)n > UINT16_MAX) {
		yyerror("halfl͈͊OłB(%d)", n);
		return NULL;	//y.tab.y̏YYERRORsB
	}
	pArg->iArgType		= ArgType_Half;
	pArg->value.v_half	= n;
	return pArg;
}
/*- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -*/
ST_Arg* Arg_NewExp10(int n) {
	ST_Arg* pArg = calloc(1, sizeof(ST_Arg));
	if(!pArg) { DIE(); }
	if(Exp10_Encode(n) == -1) {
		yyerror("exp10l͈͊OłB(%d)", n);
		return NULL;	//y.tab.y̏YYERRORsB
	}
	pArg->iArgType		= ArgType_Exp10;
	pArg->value.v_exp10	= n;
	return pArg;
}
/*- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -*/
ST_Arg* Arg_NewWord(int n) {
	ST_Arg* pArg = calloc(1, sizeof(ST_Arg));
	if(!pArg) { DIE(); }
	pArg->iArgType		= ArgType_Word;
	pArg->value.v_word	= n;
	return pArg;
}
/*- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -*/
//{{2018/04/07ǉ:XgBERk܂߂悤ɂ܂B
ST_Arg* Arg_NewBer(int n) {
	ST_Arg* pArg = calloc(1, sizeof(ST_Arg));
	if(!pArg) { DIE(); }
	pArg->iArgType		= ArgType_Ber;
	pArg->value.v_ber	= n;
	return pArg;
}
//}}2018/04/07ǉ:XgBERk܂߂悤ɂ܂B
/*- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -*/
ST_Arg* Arg_NewFp16(double d) {
	ST_Arg* pArg = calloc(1, sizeof(ST_Arg));
	if(!pArg) { DIE(); }
	pArg->iArgType		= ArgType_Fp16;
	pArg->value.v_fp16	= d;
	return pArg;
}
/*- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -*/
ST_Arg* Arg_NewFp32(double d) {
	ST_Arg* pArg = calloc(1, sizeof(ST_Arg));
	if(!pArg) { DIE(); }
	pArg->iArgType		= ArgType_Fp32;
	pArg->value.v_fp32	= d;
	return pArg;
}
/*- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -*/
ST_Arg* Arg_NewFp64(double d) {
	ST_Arg* pArg = calloc(1, sizeof(ST_Arg));
	if(!pArg) { DIE(); }
	pArg->iArgType		= ArgType_Fp64;
	pArg->value.v_fp64	= d;
	return pArg;
}
/*- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -*/
ST_Arg* Arg_NewString(char* s) {
	ST_Arg* pArg = calloc(1, sizeof(ST_Arg));
	if(!pArg) { DIE(); }
	pArg->iArgType		= ArgType_String;
	pArg->value.v_string	= (char*)intern_string(s);			//|C^Ŕro悤ɁAPꉻĊi[B
	return pArg;
}
/*- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -*/
ST_Arg* Arg_NewFile(char* s) {
	ST_Arg* pArg = calloc(1, sizeof(ST_Arg));
	if(!pArg) { DIE(); }
	pArg->iArgType		= ArgType_File;
	pArg->value.v_file	= (char*)intern_string(s);			//|C^Ŕro悤ɁAPꉻĊi[B
	return pArg;
}
/*- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -*/
ST_Arg* Arg_NewTable(char* s) {
	ST_Arg* pArg = calloc(1, sizeof(ST_Arg));
	if(!pArg) { DIE(); }
	pArg->iArgType		= ArgType_Table;
	pArg->value.v_table	= (char*)intern_string(s);			//|C^Ŕro悤ɁAPꉻĊi[B
	return pArg;
}
/*- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -*/
ST_Arg* Arg_NewTrig(char* s) {
	ST_Arg* pArg = calloc(1, sizeof(ST_Arg));
	if(!pArg) { DIE(); }
	pArg->iArgType		= ArgType_Trig;
	pArg->value.v_trig	= (char*)intern_string(s);			//|C^Ŕro悤ɁAPꉻĊi[B
	return pArg;
}
/*- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -*/
ST_Arg* Arg_NewFunc(char* s) {
	ST_Arg* pArg = calloc(1, sizeof(ST_Arg));
	if(!pArg) { DIE(); }
	pArg->iArgType		= ArgType_Func;
	pArg->value.v_func	= (char*)intern_string(s);			//|C^Ŕro悤ɁAPꉻĊi[B
	return pArg;
}
/*- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -*/
ST_Arg* Arg_Intern(ST_Arg* pArg) {
	ST_Arg* pOldArg = g_tree_lookup(tree_pArg, pArg);
	if(pOldArg) { return pOldArg; }
	g_tree_insert(tree_pArg, pArg, pArg);
	return pArg;
}
/*- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -*/
int Arg_Compar(const void* _a, const void* _b) {
	ST_Arg* a = (ST_Arg*)_a;
	ST_Arg* b = (ST_Arg*)_b;
	return memcmp(a, b, sizeof(ST_Arg));
}
/*- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -*/
GSList* ArgList_AddArg(GSList* pArgList, ST_Arg* pArg) {
	return g_slist_append(pArgList, Arg_Intern(pArg));			//|C^Ŕro悤ɁAPꉻĒǉB
}
/*- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -*/
GSList* ArgList_Intern(GSList* pArgList) {
	GSList* pOldArgList = g_tree_lookup(tree_pArgList, pArgList);
	if(pOldArgList) { return pOldArgList; }
	g_tree_insert(tree_pArgList, pArgList, pArgList);
	return pArgList;
}
/*- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -*/
int ArgList_Compar(const void* _a, const void* _b) {
	GSList* a = (GSList*)_a;
	GSList* b = (GSList*)_b;
	return g_slist_compare_np(a, b);
}
/*- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -*/
ST_Args* Args_New(GSList* pArgList/*NULL*/) {
	ST_Args* pArgs = calloc(1, sizeof(ST_Args));
	if(!pArgs) { DIE(); }
    if(pArgList/*NULL*/) {
	pArgs->pArgList		= ArgList_Intern(pArgList);			//|C^Ŕro悤ɁAPꉻĊi[B
    }
	return pArgs;
}
/*- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -*/
ST_Args* Args_Intern(ST_Args* pArgs) {
	ST_Args* pOldArgs = g_tree_lookup(tree_pArgs, pArgs);
	if(pOldArgs) { return pOldArgs; }
	g_tree_insert(tree_pArgs, pArgs, pArgs);
	return pArgs;
}
/*- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -*/
int Args_Compar(const void* _a, const void* _b) {
	ST_Args* a = (ST_Args*)_a;
	ST_Args* b = (ST_Args*)_b;
	return memcmp(a, b, sizeof(ST_Args));
}
//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
ST_Func* Func_New(char* pFuncName, ST_Args* pArgs) {
	ST_Func* pFunc = calloc(1, sizeof(ST_Func));
	if(!pFunc) { DIE(); }
	pFunc->pFuncName	= (char*)intern_string(pFuncName);		//|C^Ŕro悤ɁAPꉻĊi[B
	pFunc->pArgs		= Args_Intern(pArgs);				//|C^Ŕro悤ɁAPꉻĊi[B
	g_tree_insert(tree_pFuncName_No, pFuncName, NULL/*_~[*/);		//1pXڂœo^܂BViIe[uċAIɒHȂViIV[PXɊ܂܂Ă֐o͑ΏۂƂ邽߂łB
	return pFunc;
}
/*- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -*/
ST_Func* Func_Intern(ST_Func* pFunc) {
	ST_Func* pOldFunc = g_tree_lookup(tree_pFunc, pFunc);
	if(pOldFunc) { return pOldFunc; }
	g_tree_insert(tree_pFunc, pFunc, pFunc);
	return pFunc;
}
/*- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -*/
int Func_Compar(const void* _a, const void* _b) {
	ST_Func* a = (ST_Func*)_a;
	ST_Func* b = (ST_Func*)_b;
	return memcmp(a, b, sizeof(ST_Func));
}
/*- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -*/
ST_Cond* Cond_New(int bNot, ST_Func* pFunc) {
	ST_Cond* pCond = calloc(1, sizeof(ST_Cond));
	if(!pCond) { DIE(); }
	pCond->bNot		= bNot;
	pCond->pFunc		= Func_Intern(pFunc);				//|C^Ŕro悤ɁAPꉻĊi[B
	return pCond;
}
/*- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -*/
ST_Cond* Cond_Intern(ST_Cond* pCond) {
	ST_Cond* pOldCond = g_tree_lookup(tree_pCond, pCond);
	if(pOldCond) { return pOldCond; }
	g_tree_insert(tree_pCond, pCond, pCond);
	return pCond;
}
/*- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -*/
int Cond_Compar(const void* _a, const void* _b) {
	ST_Cond* a = (ST_Cond*)_a;
	ST_Cond* b = (ST_Cond*)_b;
	return memcmp(a, b, sizeof(ST_Cond));
}
/*- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -*/
ST_CondSubs* IfSubs_New(ST_Cond* pCond, ST_SnrSeqBody* pSnrSeqBody) {
	ST_CondSubs* pCondSubs = calloc(1, sizeof(ST_CondSubs));
	if(!pCondSubs) { DIE(); }
	pCondSubs->pCond	= pCond;
	pCondSubs->pSnrSeqBody	= SnrSeqBody_Intern(pSnrSeqBody);		//|C^Ŕro悤ɁAPꉻĊi[B
	return pCondSubs;
}
/*- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -*/
ST_CondSubs* UnlessSubs_New(ST_Cond* pCond, ST_SnrSeqBody* pSnrSeqBody) {
	pCond = Cond_New(!pCond->bNot, pCond->pFunc);
	return IfSubs_New(pCond, pSnrSeqBody);
}
/*- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -*/
ST_CondSubs* ElifSubs_New(ST_Cond* pCond, ST_SnrSeqBody* pSnrSeqBody) {
	return IfSubs_New(pCond, pSnrSeqBody);
}
/*- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */
ST_CondSubs* CondSubs_Intern(ST_CondSubs* pCondSubs) {
	ST_CondSubs* pOldCondSubs = g_tree_lookup(tree_pCondSubs, pCondSubs);
	if(pOldCondSubs) { return pOldCondSubs; }
	g_tree_insert(tree_pCondSubs, pCondSubs, pCondSubs);
	return pCondSubs;
}
/*- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */
int CondSubs_Compar(const void* _a, const void* _b) {
	ST_CondSubs* a = (ST_CondSubs*)_a;
	ST_CondSubs* b = (ST_CondSubs*)_b;
	return memcmp(a, b, sizeof(ST_CondSubs));
}
/*- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */
GSList* CondSubsList_AddCondSubs(GSList* pCondSubsList, ST_CondSubs* pCondSubs) {
	return g_slist_append(pCondSubsList, CondSubs_Intern(pCondSubs));	//|C^Ŕro悤ɁAPꉻĒǉB
}
/*- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */
GSList* CondSubsList_Intern(GSList* pCondSubsList) {
	GSList* pOldCondSubsList = g_tree_lookup(tree_pCondSubsList, pCondSubsList);
	if(pOldCondSubsList) { return pOldCondSubsList; }
	g_tree_insert(tree_pCondSubsList, pCondSubsList, pCondSubsList);
	return pCondSubsList;
}
/*- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */
int CondSubsList_Compar(const void* _a, const void* _b) {
	GSList* a = (GSList*)_a;
	GSList* b = (GSList*)_b;
	return g_slist_compare_np(a, b);
}
/*- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */
ST_ValueSubs* OfSubs_New(int iValue, ST_SnrSeqBody* pSnrSeqBody) {
	ST_ValueSubs* pValueSubs = calloc(1, sizeof(ST_ValueSubs));
	if(!pValueSubs) { DIE(); }
	if((unsigned)iValue > UINT8_MAX) {
		yyerror("l͈͊OłB(%d)", iValue);
		yynerrs++;	//Ăяo(main)ɒm点邽߂ɁB
		return NULL;	//y.tab.y̏YYERRORsB
	}
	pValueSubs->iValue	= iValue;
	pValueSubs->pSnrSeqBody	= SnrSeqBody_Intern(pSnrSeqBody);		//|C^Ŕro悤ɁAPꉻĊi[B
	return pValueSubs;
}
/*- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */
ST_ValueSubs* ValueSubs_Intern(ST_ValueSubs* pValueSubs) {
	ST_ValueSubs* pOldValueSubs = g_tree_lookup(tree_pValueSubs, pValueSubs);
	if(pOldValueSubs) { return pOldValueSubs; }
	g_tree_insert(tree_pValueSubs, pValueSubs, pValueSubs);
	return pValueSubs;
}
/*- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */
int ValueSubs_Compar(const void* _a, const void* _b) {
	ST_ValueSubs* a = (ST_ValueSubs*)_a;
	ST_ValueSubs* b = (ST_ValueSubs*)_b;
	return memcmp(a, b, sizeof(ST_ValueSubs));
}
/*- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */
static int ValueSubsList_AddValueSubs_compar(const void* _a, const void* _b) {
	ST_ValueSubs* a = (ST_ValueSubs*)_a;
	ST_ValueSubs* b = (ST_ValueSubs*)_b;
	if(a->iValue < b->iValue) { return -1; }
	if(a->iValue > b->iValue) { return  1; }
	return 0;
}
GSList* ValueSubsList_AddValueSubs(GSList* pValueSubsList, ST_ValueSubs* pValueSubs) {
	if(g_slist_find_custom(pValueSubsList, pValueSubs, ValueSubsList_AddValueSubs_compar)) {	//pValueSubsListiValueɑ΂ďdAg_slist_insert_sorted()gĒǉB
		yyerror("ldĂ܂B(%d)", pValueSubs->iValue);
		return NULL;	//y.tab.y̏YYERRORsB
	}
	return g_slist_insert_sorted(pValueSubsList, ValueSubs_Intern(pValueSubs), ValueSubsList_AddValueSubs_compar);
}
/*- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */
GSList* ValueSubsList_Intern(GSList* pValueSubsList) {
	GSList* pOldValueSubsList = g_tree_lookup(tree_pValueSubsList, pValueSubsList);
	if(pOldValueSubsList) { return pOldValueSubsList; }
	g_tree_insert(tree_pValueSubsList, pValueSubsList, pValueSubsList);
	return pValueSubsList;
}
/*- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */
int ValueSubsList_Compar(const void* _a, const void* _b) {
	GSList* a = (GSList*)_a;
	GSList* b = (GSList*)_b;
	return g_slist_compare_np(a, b);
}
/*- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */
ST_SnrTbl* SnrTbl_New(char* pSnrTblLabel, ST_SnrTblBody* pSnrTblBody) {
	ST_SnrTbl* pSnrTbl = calloc(1, sizeof(ST_SnrTbl));
	if(!pSnrTbl) { DIE(); }
	pSnrTbl->pSnrTblLabel	= (char*)intern_string(pSnrTblLabel);		//K{ł͂ȂAPꉻĊi[B
	pSnrTbl->pSnrTblBody	= SnrTblBody_Intern(pSnrTblBody);		//œK̂߂ɁAPꉻĊi[B
	return pSnrTbl;
}
/*- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */
ST_SnrTblBody* SnrTblBody_New() {
	ST_SnrTblBody* pSnrTblBody = calloc(1, sizeof(ST_SnrTblBody));
	if(!pSnrTblBody) { DIE(); }
	return pSnrTblBody;
}
/*- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */
static char* SnrTblStmt_GetTrigName(ST_SnrTblStmt* pSnrTblStmt) {
	char* pTrigName;
	switch(pSnrTblStmt->iSnrTblStmtType) {
	default:DIE();	//Œ~瓖c[̃oOłB
	case SnrTblStmtType_OnUnlock:
		{
			ST_OnUnlockStmt* pOnUnlockStmt = &pSnrTblStmt->onUnlockStmt;
			{
				pTrigName = pOnUnlockStmt->pTrigName;
			}
		}
		break;
	case SnrTblStmtType_OnGoto:
		{
			ST_OnGotoStmt* pOnGotoStmt = &pSnrTblStmt->onGotoStmt;
			{
				pTrigName = pOnGotoStmt->pTrigName;
			}
		}
		break;
	case SnrTblStmtType_OnExec:
		{
			ST_OnExecStmt* pOnExecStmt = &pSnrTblStmt->onExecStmt;
			{
				pTrigName = pOnExecStmt->pTrigName;
			}
		}
		break;
	}
	return pTrigName;
}
static int SnrTblBody_AddSnrTblStmt_compar(const void* _a, const void* _b) {
	ST_SnrTblStmt* a = (ST_SnrTblStmt*)_a;
	ST_SnrTblStmt* b = (ST_SnrTblStmt*)_b;
	char* pTrigNameA = SnrTblStmt_GetTrigName(a);
	char* pTrigNameB = SnrTblStmt_GetTrigName(b);
	return TrigName_Compar(pTrigNameA, pTrigNameB);
}
ST_SnrTblBody* SnrTblBody_AddSnrTblStmt(ST_SnrTblBody* pSnrTblBody, ST_SnrTblStmt* pSnrTblStmt) {
	pSnrTblStmt = SnrTblStmt_Intern(pSnrTblStmt);				//pSnrTblStmtList͒PꉻȂApSnrTblStmtList̗vfpSnrTblStmtA|C^Ŕro悤ɒPꉻĒǉB
	if(g_slist_find_custom(pSnrTblBody->pSnrTblStmtList, pSnrTblStmt, SnrTblBody_AddSnrTblStmt_compar)) {	//pSnrTblStmtListpTrigNameɑ΂ďdAg_slist_insert_sorted()gĒǉB
		char* pTrigName = SnrTblStmt_GetTrigName(pSnrTblStmt);
		yyerror("gKdĂ܂B(%s)", pTrigName);
		return NULL;	//y.tab.y̏YYERRORsB
	}
	pSnrTblBody->pSnrTblStmtList = g_slist_insert_sorted(pSnrTblBody->pSnrTblStmtList, pSnrTblStmt, SnrTblBody_AddSnrTblStmt_compar);
	return pSnrTblBody;
}
/*- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */
ST_SnrTblBody* SnrTblBody_Intern(ST_SnrTblBody* pSnrTblBody) {
	ST_SnrTblBody* pOldSnrTblBody = g_tree_lookup(tree_pSnrTblBody, pSnrTblBody);
	if(pOldSnrTblBody) { return pOldSnrTblBody; }
	g_tree_insert(tree_pSnrTblBody, pSnrTblBody, pSnrTblBody);
	return pSnrTblBody;
}
/*- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */
int SnrTblBody_Compar(const void* _a, const void* _b) {
	ST_SnrTblBody* a = (ST_SnrTblBody*)_a;
	ST_SnrTblBody* b = (ST_SnrTblBody*)_b;
	return g_slist_compare_np(a->pSnrTblStmtList, b->pSnrTblStmtList);
}
/*- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */
ST_SnrTblStmt* OnUnlockStmt_New(char* pTrigName) {
	ST_OnUnlockStmt* pOnUnlockStmt = calloc(1, sizeof(ST_SnrTblStmt));		//SnrTblStmt_Compar()ɂ(ST_SnrTblStmt*)ƂĔr̂ŁAsizeof(ST_OnUnlockStmt)ł͂Ȃsizeof(ST_SnrTblStmt)̃TCYŊmۂKvLB
	if(!pOnUnlockStmt) { DIE(); }
	pOnUnlockStmt->iSnrTblStmtType	= SnrTblStmtType_OnUnlock;
	pOnUnlockStmt->pTrigName	= (char*)intern_string(pTrigName);		//|C^Ŕro悤ɁAPꉻĊi[B
	g_tree_insert(tree_pTrigName_No, pTrigName, NULL/*_~[*/);			//1pXڂœo^܂BViIe[uċAIɒHȂViIe[uɊ܂܂ĂgKo͑ΏۂƂ邽߂łB
	return (ST_SnrTblStmt*)pOnUnlockStmt;
}
/*- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */
ST_SnrTblStmt* OnGotoStmt_New(char* pTrigName, int bUnlock, char* pSnrSeqLabel, int nLock) {
	ST_OnGotoStmt* pOnGotoStmt = calloc(1, sizeof(ST_SnrTblStmt));			//SnrTblStmt_Compar()ɂ(ST_SnrTblStmt*)ƂĔr̂ŁAsizeof(ST_OnGotoStmt)ł͂Ȃsizeof(ST_SnrTblStmt)̃TCYŊmۂKvLB
	if(!pOnGotoStmt) { DIE(); }
	pOnGotoStmt->iSnrTblStmtType	= SnrTblStmtType_OnGoto;
	pOnGotoStmt->pTrigName		= (char*)intern_string(pTrigName);		//|C^Ŕro悤ɁAPꉻĊi[B
	pOnGotoStmt->bUnlock		= bUnlock;
	pOnGotoStmt->pSnrSeqLabel	= (char*)intern_string(pSnrSeqLabel);		//|C^Ŕro悤ɁAPꉻĊi[B
	pOnGotoStmt->nLock		= nLock;
	g_tree_insert(tree_pTrigName_No, pTrigName, NULL/*_~[*/);			//1pXڂœo^܂BViIe[uċAIɒHȂViIe[uɊ܂܂ĂgKo͑ΏۂƂ邽߂łB
	return (ST_SnrTblStmt*)pOnGotoStmt;
}
/*- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */
ST_SnrTblStmt* OnGotoStmt_NewInline(char* pTrigName, int bUnlock, int nLock, ST_SnrSeqBody* pSnrSeqBody) {
	ST_OnGotoStmt* pOnGotoStmt = calloc(1, sizeof(ST_SnrTblStmt));			//SnrTblStmt_Compar()ɂ(ST_SnrTblStmt*)ƂĔr̂ŁAsizeof(ST_OnGotoStmt)ł͂Ȃsizeof(ST_SnrTblStmt)̃TCYŊmۂKvLB
	if(!pOnGotoStmt) { DIE(); }
	{
		char *pLabDef, *pLabRef;
		ST_SnrSeq* pSnrSeq;
		{
			char* pSnrSeqLabel = strconcat(".", pTrigName, NULL);		//ɂēIɐViIV[PXx́A".gK"Ƃ[Jxɂ鎖ɂB̖t͕K{ł͂ȂBXNvgŖIɒ`郍[JxƁAՓ˂댯̒ႢOȂΉłǂB".gK"ƏՓ˂댯̒ႢOɂ鎖oA܂ŊI".gK"Ƃ[Jxgė̂ŁAՂ̂߂ɁAɂēIɐViIV[PXxɍ킹鎖ɂB
			if(!(pLabDef = LabDef_New(pSnrSeqLabel))) { return NULL; }	//y.tab.y̏YYERRORsB	//YȂ!!SnrSeq_New()ɒpSnrSeqLabelnȂ悤!!
			if(!(pLabRef = LabRef_New(pSnrSeqLabel))) { return NULL; }	//y.tab.y̏YYERRORsB	//YȂ!!OnGotoStmt_New()ɒpSnrSeqLabelnȂ悤!!
		}
		if(!(pSnrSeq = SnrSeq_New(pLabDef, pSnrSeqBody))) { return NULL; }	//y.tab.y̏YYERRORsB
		addSnrSeq(pSnrSeq);
		return OnGotoStmt_New(pTrigName, bUnlock, pLabRef, nLock);
	}
}
/*- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */
ST_SnrTblStmt* OnExecStmt_New(char* pTrigName, int bUnlock, char* pSnrSeqLabel, int nLock) {
	ST_OnExecStmt* pOnExecStmt = calloc(1, sizeof(ST_SnrTblStmt));			//SnrTblStmt_Compar()ɂ(ST_SnrTblStmt*)ƂĔr̂ŁAsizeof(ST_OnExecStmt)ł͂Ȃsizeof(ST_SnrTblStmt)̃TCYŊmۂKvLB
	if(!pOnExecStmt) { DIE(); }
	pOnExecStmt->iSnrTblStmtType	= SnrTblStmtType_OnExec;
	pOnExecStmt->pTrigName		= (char*)intern_string(pTrigName);		//|C^Ŕro悤ɁAPꉻĊi[B
	pOnExecStmt->bUnlock		= bUnlock;
	pOnExecStmt->pSnrSeqLabel	= (char*)intern_string(pSnrSeqLabel);		//|C^Ŕro悤ɁAPꉻĊi[B
	pOnExecStmt->nLock		= nLock;
	g_tree_insert(tree_pTrigName_No, pTrigName, NULL/*_~[*/);			//1pXڂœo^܂BViIe[uċAIɒHȂViIe[uɊ܂܂ĂgKo͑ΏۂƂ邽߂łB
	return (ST_SnrTblStmt*)pOnExecStmt;
}
/*- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */
ST_SnrTblStmt* OnExecStmt_NewInline(char* pTrigName, int bUnlock, int nLock, ST_SnrSeqBody* pSnrSeqBody) {
	ST_OnExecStmt* pOnExecStmt = calloc(1, sizeof(ST_SnrTblStmt));			//SnrTblStmt_Compar()ɂ(ST_SnrTblStmt*)ƂĔr̂ŁAsizeof(ST_OnExecStmt)ł͂Ȃsizeof(ST_SnrTblStmt)̃TCYŊmۂKvLB
	if(!pOnExecStmt) { DIE(); }
	{
		char *pLabDef, *pLabRef;
		ST_SnrSeq* pSnrSeq;
		{
			char* pSnrSeqLabel = strconcat(".", pTrigName, NULL);		//ɂēIɐViIV[PXx́A".gK"Ƃ[Jxɂ鎖ɂB̖t͕K{ł͂ȂBXNvgŖIɒ`郍[JxƁAՓ˂댯̒ႢOȂΉłǂB".gK"ƏՓ˂댯̒ႢOɂ鎖oA܂ŊI".gK"Ƃ[Jxgė̂ŁAՂ̂߂ɁAɂēIɐViIV[PXxɍ킹鎖ɂB
			if(!(pLabDef = LabDef_New(pSnrSeqLabel))) { return NULL; }	//y.tab.y̏YYERRORsB	//YȂ!!SnrSeq_New()ɒpSnrSeqLabelnȂ悤!!
			if(!(pLabRef = LabRef_New(pSnrSeqLabel))) { return NULL; }	//y.tab.y̏YYERRORsB	//YȂ!!OnExecStmt_New()ɒpSnrSeqLabelnȂ悤!!
		}
		if(!(pSnrSeq = SnrSeq_New(pLabDef, pSnrSeqBody))) { return NULL; }	//y.tab.y̏YYERRORsB
		addSnrSeq(pSnrSeq);
		return OnExecStmt_New(pTrigName, bUnlock, pLabRef, nLock);
	}
}
/*- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */
int Lock_New(int nLock) {
	if((nLock < 1) || (nLock > UINT16_MAX)) {
		yyerror("bNԂ͈͊OłB(%d)", nLock);
		yynerrs++;	//Ăяo(main)ɒm点邽߂ɁB
		return -1;	//y.tab.y̏YYERRORsB
	}
	return nLock;
}
/*- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */
ST_SnrTblStmt* SnrTblStmt_Intern(ST_SnrTblStmt* pSnrTblStmt) {
	ST_SnrTblStmt* pOldSnrTblStmt = g_tree_lookup(tree_pSnrTblStmt, pSnrTblStmt);
	if(pOldSnrTblStmt) { return pOldSnrTblStmt; }
	g_tree_insert(tree_pSnrTblStmt, pSnrTblStmt, pSnrTblStmt);
	return pSnrTblStmt;
}
/*- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */
int SnrTblStmt_Compar(const void* _a, const void* _b) {
	ST_SnrTblStmt* a = (ST_SnrTblStmt*)_a;
	ST_SnrTblStmt* b = (ST_SnrTblStmt*)_b;
	return memcmp(a, b, sizeof(ST_SnrTblStmt));
}
/*- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */
ST_SnrSeq* SnrSeq_New(char* pSnrSeqLabel, ST_SnrSeqBody* pSnrSeqBody) {
	ST_SnrSeq* pSnrSeq = calloc(1, sizeof(ST_SnrSeq));
	if(!pSnrSeq) { DIE(); }
	pSnrSeq->pSnrSeqLabel	= pSnrSeqLabel;					//K{ł͂ȂAPꉻĊi[B
	pSnrSeq->pSnrSeqBody	= SnrSeqBody_Intern(pSnrSeqBody);		//œK̂߂ɁAPꉻĊi[B
	return pSnrSeq;
}
/*- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */
ST_SnrSeqBody* SnrSeqBody_New() {
	ST_SnrSeqBody* pSnrSeqBody = calloc(1, sizeof(ST_SnrSeqBody));
	if(!pSnrSeqBody) { DIE(); }
	return pSnrSeqBody;
}
/*- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */
ST_SnrSeqBody* SnrSeqBody_AddSnrSeqStmt(ST_SnrSeqBody* pSnrSeqBody, ST_SnrSeqStmt* pSnrSeqStmt) {
	pSnrSeqStmt = SnrSeqStmt_Intern(pSnrSeqStmt);				//pSnrSeqStmtList͒PꉻȂApSnrSeqStmtList̗vfpSnrSeqStmtA|C^Ŕro悤ɒPꉻĒǉB
	pSnrSeqBody->pSnrSeqStmtList = g_slist_append(pSnrSeqBody->pSnrSeqStmtList, pSnrSeqStmt);
	return pSnrSeqBody;
}
/*- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */
ST_SnrSeqBody* SnrSeqBody_Intern(ST_SnrSeqBody* pSnrSeqBody) {
	ST_SnrSeqBody* pOldSnrSeqBody = g_tree_lookup(tree_pSnrSeqBody, pSnrSeqBody);
	if(pOldSnrSeqBody) { return pOldSnrSeqBody; }
	g_tree_insert(tree_pSnrSeqBody, pSnrSeqBody, pSnrSeqBody);
	return pSnrSeqBody;
}
/*- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */
int SnrSeqBody_Compar(const void* _a, const void* _b) {
	ST_SnrSeqBody* a = (ST_SnrSeqBody*)_a;
	ST_SnrSeqBody* b = (ST_SnrSeqBody*)_b;
	return g_slist_compare_np(a->pSnrSeqStmtList, b->pSnrSeqStmtList);
}
/*- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */
ST_SnrSeqStmt* ExitStmt_New() {
	ST_ExitStmt* pExitStmt = calloc(1, sizeof(ST_SnrSeqStmt));		//SnrSeqStmt_Compar()ɂ(ST_SnrSeqStmt*)ƂĔr̂ŁAsizeof(ST_ExitStmt)ł͂Ȃsizeof(ST_SnrSeqStmt)̃TCYŊmۂKvLB
	if(!pExitStmt) { DIE(); }
	pExitStmt->iSnrSeqStmtType	= SnrSeqStmtType_Exit;
	return (ST_SnrSeqStmt*)pExitStmt;
}
/*- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */
ST_SnrSeqStmt* EscapeStmt_New() {
	ST_EscapeStmt* pEscapeStmt = calloc(1, sizeof(ST_SnrSeqStmt));		//SnrSeqStmt_Compar()ɂ(ST_SnrSeqStmt*)ƂĔr̂ŁAsizeof(ST_EscapeStmt)ł͂Ȃsizeof(ST_SnrSeqStmt)̃TCYŊmۂKvLB
	if(!pEscapeStmt) { DIE(); }
	pEscapeStmt->iSnrSeqStmtType	= SnrSeqStmtType_Escape;
	return (ST_SnrSeqStmt*)pEscapeStmt;
}
/*- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */
ST_SnrSeqStmt* WaitStmt_New(int nWaitCnt) {
	ST_WaitStmt* pWaitStmt = calloc(1, sizeof(ST_SnrSeqStmt));		//SnrSeqStmt_Compar()ɂ(ST_SnrSeqStmt*)ƂĔr̂ŁAsizeof(ST_WaitStmt)ł͂Ȃsizeof(ST_SnrSeqStmt)̃TCYŊmۂKvLB
	if(!pWaitStmt) { DIE(); }
	pWaitStmt->iSnrSeqStmtType	= SnrSeqStmtType_Wait;
	pWaitStmt->nWaitCnt		= nWaitCnt;
	return (ST_SnrSeqStmt*)pWaitStmt;
}
/*- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */
ST_SnrSeqStmt* WaitForStmt_New(ST_Cond* pCond) {
	ST_WaitForStmt* pWaitForStmt = calloc(1, sizeof(ST_SnrSeqStmt));	//SnrSeqStmt_Compar()ɂ(ST_SnrSeqStmt*)ƂĔr̂ŁAsizeof(ST_WaitForStmt)ł͂Ȃsizeof(ST_SnrSeqStmt)̃TCYŊmۂKvLB
	if(!pWaitForStmt) { DIE(); }
	pWaitForStmt->iSnrSeqStmtType	= SnrSeqStmtType_WaitFor;
	pWaitForStmt->pCond		= Cond_Intern(pCond);			//|C^Ŕro悤ɁAPꉻĊi[B
	return (ST_SnrSeqStmt*)pWaitForStmt;
}
/*- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */
int WaitCnt_New(int nWaitCnt) {
	if((nWaitCnt < 1) || (nWaitCnt > UINT16_MAX)) {
		yyerror("҂Ԃ͈͊OłB(%d)", nWaitCnt);
		yynerrs++;	//Ăяo(main)ɒm点邽߂ɁB
		return -1;	//y.tab.y̏YYERRORsB
	}
	return nWaitCnt;
}
/*- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */
ST_SnrSeqStmt* ForkStmt_New(ST_SnrSeqBody* pSnrSeqBody) {
	ST_ForkStmt* pForkStmt = calloc(1, sizeof(ST_SnrSeqStmt));		//SnrSeqStmt_Compar()ɂ(ST_SnrSeqStmt*)ƂĔr̂ŁAsizeof(ST_ForkStmt)ł͂Ȃsizeof(ST_SnrSeqStmt)̃TCYŊmۂKvLB
	if(!pForkStmt) { DIE(); }
	pForkStmt->iSnrSeqStmtType	= SnrSeqStmtType_Fork;
	pForkStmt->pSnrSeqBody		= SnrSeqBody_Intern(pSnrSeqBody);	//|C^Ŕro悤ɁAPꉻĊi[B
	return (ST_SnrSeqStmt*)pForkStmt;
}
/*- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */
ST_SnrSeqStmt* HideStmt_New() {
	ST_HideStmt* pHideStmt = calloc(1, sizeof(ST_SnrSeqStmt));		//SnrSeqStmt_Compar()ɂ(ST_SnrSeqStmt*)ƂĔr̂ŁAsizeof(ST_HideStmt)ł͂Ȃsizeof(ST_SnrSeqStmt)̃TCYŊmۂKvLB
	if(!pHideStmt) { DIE(); }
	pHideStmt->iSnrSeqStmtType	= SnrSeqStmtType_Hide;
	return (ST_SnrSeqStmt*)pHideStmt;
}
/*- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */
ST_SnrSeqStmt* JoinStmt_New() {
	ST_JoinStmt* pJoinStmt = calloc(1, sizeof(ST_SnrSeqStmt));		//SnrSeqStmt_Compar()ɂ(ST_SnrSeqStmt*)ƂĔr̂ŁAsizeof(ST_JoinStmt)ł͂Ȃsizeof(ST_SnrSeqStmt)̃TCYŊmۂKvLB
	if(!pJoinStmt) { DIE(); }
	pJoinStmt->iSnrSeqStmtType	= SnrSeqStmtType_Join;
	return (ST_SnrSeqStmt*)pJoinStmt;
}
/*- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */
ST_SnrSeqStmt* GotoStmt_New(char* pSnrSeqLabel) {
	ST_GotoStmt* pGotoStmt = calloc(1, sizeof(ST_SnrSeqStmt));		//SnrSeqStmt_Compar()ɂ(ST_SnrSeqStmt*)ƂĔr̂ŁAsizeof(ST_GotoStmt)ł͂Ȃsizeof(ST_SnrSeqStmt)̃TCYŊmۂKvLB
	if(!pGotoStmt) { DIE(); }
	pGotoStmt->iSnrSeqStmtType	= SnrSeqStmtType_Goto;
	pGotoStmt->pSnrSeqLabel		= (char*)intern_string(pSnrSeqLabel);	//|C^Ŕro悤ɁAPꉻĊi[B
	return (ST_SnrSeqStmt*)pGotoStmt;
}
/*- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */
ST_SnrSeqStmt* CallStmt_New(char* pSnrSeqLabel) {
	ST_CallStmt* pCallStmt = calloc(1, sizeof(ST_SnrSeqStmt));		//SnrSeqStmt_Compar()ɂ(ST_SnrSeqStmt*)ƂĔr̂ŁAsizeof(ST_CallStmt)ł͂Ȃsizeof(ST_SnrSeqStmt)̃TCYŊmۂKvLB
	if(!pCallStmt) { DIE(); }
	pCallStmt->iSnrSeqStmtType	= SnrSeqStmtType_Call;
	pCallStmt->pSnrSeqLabel		= (char*)intern_string(pSnrSeqLabel);	//|C^Ŕro悤ɁAPꉻĊi[B
	return (ST_SnrSeqStmt*)pCallStmt;
}
/*- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */
ST_SnrSeqStmt* IfStmt_New(ST_CondSubs* pIfSubs, GSList* pElifSubsList/*NULL*/, ST_SnrSeqBody* pElseSubs/*NULL*/) {
	ST_IfStmt* pIfStmt = calloc(1, sizeof(ST_SnrSeqStmt));			//SnrSeqStmt_Compar()ɂ(ST_SnrSeqStmt*)ƂĔr̂ŁAsizeof(ST_IfStmt)ł͂Ȃsizeof(ST_SnrSeqStmt)̃TCYŊmۂKvLB
	if(!pIfStmt) { DIE(); }
	pIfStmt->iSnrSeqStmtType	= SnrSeqStmtType_If;
	pIfStmt->pIfSubs		= CondSubs_Intern(pIfSubs);		//|C^Ŕro悤ɁAPꉻĊi[B
    if(pElifSubsList/*NULL*/) {
	pIfStmt->pElifSubsList		= CondSubsList_Intern(pElifSubsList);	//pElifSubsList̗vfpCondSubsA|C^Ŕro悤ɒPꉻĒǉAŌɁApElifSubsListPꉻĊi[B
    }
    if(pElseSubs/*NULL*/) {
	pIfStmt->pElseSubs		= SnrSeqBody_Intern(pElseSubs);		//|C^Ŕro悤ɁAPꉻĊi[B
    }
	return (ST_SnrSeqStmt*)pIfStmt;
}
/*- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */
ST_SnrSeqStmt* UnlessStmt_New(ST_CondSubs* pUnlessSubs, ST_SnrSeqBody* pElseSubs/*NULL*/) {
	return IfStmt_New(pUnlessSubs, NULL, pElseSubs);	//pUnlessSubs->pCond->bNotUnlessSubs_New()ɂĔ]ς݂łB
}
/*- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */
ST_SnrSeqStmt* CaseStmt_New(ST_Func* pFunc, GSList* pOfSubsList, ST_SnrSeqBody* pElseSubs/*NULL*/) {
	ST_CaseStmt* pCaseStmt = calloc(1, sizeof(ST_SnrSeqStmt));		//SnrSeqStmt_Compar()ɂ(ST_SnrSeqStmt*)ƂĔr̂ŁAsizeof(ST_CaseStmt)ł͂Ȃsizeof(ST_SnrSeqStmt)̃TCYŊmۂKvLB
	if(!pCaseStmt) { DIE(); }
	pCaseStmt->iSnrSeqStmtType	= SnrSeqStmtType_Case;
	pCaseStmt->pFunc		= Func_Intern(pFunc);			//|C^Ŕro悤ɁAPꉻĊi[B
	pCaseStmt->pOfSubsList		= ValueSubsList_Intern(pOfSubsList);	//pOfSubsList̗vfpValueSubsA|C^Ŕro悤ɒPꉻĒǉAŌɁApOfSubsListPꉻĊi[B
    if(pElseSubs/*NULL*/) {
	pCaseStmt->pElseSubs		= SnrSeqBody_Intern(pElseSubs);		//|C^Ŕro悤ɁAPꉻĊi[B
    }
	return (ST_SnrSeqStmt*)pCaseStmt;
}
/*- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */
ST_SnrSeqStmt* RepeatStmt_New(int nRepeatCnt, ST_SnrSeqBody* pSnrSeqBody) {
	ST_RepeatStmt* pRepeatStmt = calloc(1, sizeof(ST_SnrSeqStmt));		//SnrSeqStmt_Compar()ɂ(ST_SnrSeqStmt*)ƂĔr̂ŁAsizeof(ST_RepeatStmt)ł͂Ȃsizeof(ST_SnrSeqStmt)̃TCYŊmۂKvLB
	if(!pRepeatStmt) { DIE(); }
	pRepeatStmt->iSnrSeqStmtType	= SnrSeqStmtType_Repeat;
	pRepeatStmt->nRepeatCnt		= nRepeatCnt;
	pRepeatStmt->pSnrSeqBody	= SnrSeqBody_Intern(pSnrSeqBody);	//|C^Ŕro悤ɁAPꉻĊi[B
	return (ST_SnrSeqStmt*)pRepeatStmt;
}
/*- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */
int RepeatCnt_New(int nRepeatCnt) {
	if((nRepeatCnt < 1) || (nRepeatCnt > (UINT16_MAX/**/ - 1))) {
		yyerror("JԂ񐔂͈͊OłB(%d)", nRepeatCnt);
		yynerrs++;	//Ăяo(main)ɒm点邽߂ɁB
		return -1;	//y.tab.y̏YYERRORsB
	}
	return nRepeatCnt;
}
/*- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */
ST_SnrSeqStmt* BreakStmt_New(int nBreakCnt) {
	ST_BreakStmt* pBreakStmt = calloc(1, sizeof(ST_SnrSeqStmt));		//SnrSeqStmt_Compar()ɂ(ST_SnrSeqStmt*)ƂĔr̂ŁAsizeof(ST_BreakStmt)ł͂Ȃsizeof(ST_SnrSeqStmt)̃TCYŊmۂKvLB
	if(!pBreakStmt) { DIE(); }
	pBreakStmt->iSnrSeqStmtType	= SnrSeqStmtType_Break;
	pBreakStmt->nBreakCnt		= nBreakCnt;
	return (ST_SnrSeqStmt*)pBreakStmt;
}
/*- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */
int BreakCnt_New(int nBreakCnt) {
	if((nBreakCnt < 1) || (nBreakCnt > UINT8_MAX)) {
		yyerror("lXgrepeat𔲂鐔͈͊OłB(%d)", nBreakCnt);
		yynerrs++;	//Ăяo(main)ɒm点邽߂ɁB
		return -1;	//y.tab.y̏YYERRORsB
	}
	return nBreakCnt;
}
/*- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */
ST_SnrSeqStmt* WhileStmt_New(ST_Cond* pCond, ST_SnrSeqBody* pSnrSeqBody) {
	ST_WhileStmt* pWhileStmt = calloc(1, sizeof(ST_SnrSeqStmt));		//SnrSeqStmt_Compar()ɂ(ST_SnrSeqStmt*)ƂĔr̂ŁAsizeof(ST_WhileStmt)ł͂Ȃsizeof(ST_SnrSeqStmt)̃TCYŊmۂKvLB
	if(!pWhileStmt) { DIE(); }
	pWhileStmt->iSnrSeqStmtType	= SnrSeqStmtType_While;
	pWhileStmt->pCond		= Cond_Intern(pCond);			//|C^Ŕro悤ɁAPꉻĊi[B
	pWhileStmt->pSnrSeqBody		= SnrSeqBody_Intern(pSnrSeqBody);	//|C^Ŕro悤ɁAPꉻĊi[B
	return (ST_SnrSeqStmt*)pWhileStmt;
}
/*- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */
ST_SnrSeqStmt* UntilStmt_New(ST_Cond* pCond, ST_SnrSeqBody* pSnrSeqBody) {
	pCond = Cond_New(!pCond->bNot, pCond->pFunc);
	return WhileStmt_New(pCond, pSnrSeqBody);
}
/*- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */
ST_SnrSeqStmt* ActStmt_New(ST_Func* pFunc, int bEnsure) {
	ST_ActStmt* pActStmt = calloc(1, sizeof(ST_SnrSeqStmt));		//SnrSeqStmt_Compar()ɂ(ST_SnrSeqStmt*)ƂĔr̂ŁAsizeof(ST_ActStmt)ł͂Ȃsizeof(ST_SnrSeqStmt)̃TCYŊmۂKvLB
	if(!pActStmt) { DIE(); }
	pActStmt->iSnrSeqStmtType	= SnrSeqStmtType_Act;
	pActStmt->pFunc			= Func_Intern(pFunc);			//|C^Ŕro悤ɁAPꉻĊi[B
	pActStmt->bEnsure		= bEnsure;
	return (ST_SnrSeqStmt*)pActStmt;
}
/*- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */
ST_SnrSeqStmt* SnrSeqStmt_Intern(ST_SnrSeqStmt* pSnrSeqStmt) {
	ST_SnrSeqStmt* pOldSnrSeqStmt = g_tree_lookup(tree_pSnrSeqStmt, pSnrSeqStmt);
	if(pOldSnrSeqStmt) { return pOldSnrSeqStmt; }
	g_tree_insert(tree_pSnrSeqStmt, pSnrSeqStmt, pSnrSeqStmt);
	return pSnrSeqStmt;
}
/*- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */
int SnrSeqStmt_Compar(const void* _a, const void* _b) {
	ST_SnrSeqStmt* a = (ST_SnrSeqStmt*)_a;
	ST_SnrSeqStmt* b = (ST_SnrSeqStmt*)_b;
	return memcmp(a, b, sizeof(ST_SnrSeqStmt));
}
/*- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -*/
ST_Code* Code_New(int addr) {
	ST_Code* pCode = calloc(1, sizeof(ST_Code));
	if(!pCode) { DIE(); }
	pCode->addr	= addr;
	pCode->code	= g_byte_array_new();
	return pCode;
}
/*- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -*/
int Code_AddValue(ST_Code* pCode, int value, int size) {
	switch(size) {
	default:DIE();
	case 4: Code_AddValue(pCode,  value >> 24, 1); /* FALLTHRU */	//4oCgrbOGfBA
	case 3: Code_AddValue(pCode,  value >> 16, 1); /* FALLTHRU */	//3oCgrbOGfBA
	case 2: Code_AddValue(pCode,  value >>  8, 1); /* FALLTHRU */	//2oCgrbOGfBA
	case 1: Code_AddData( pCode, &value,       1); break;		//1oCg
	}
	return size;
}
/*- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -*/
int Code_AddData(ST_Code* pCode, const void* data, int size) {
	g_byte_array_append(pCode->code, data, size);
	return size;
}
/*---------------------------------------------------------------------------*/
//2pXڂ̏
/*- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */
//XgBLOB\zB
static void* Args_BuildBlob(ST_Args* pArgs) {
	void* data = NULL;
	if(pArgs->pArgList/*NULL*/) {
		GSList* pArgList = pArgs->pArgList;
		while(pArgList) {
			ST_Arg* pArg = pArgList->data;
			switch(pArg->iArgType) {
			default:DIE();	//Œ~瓖c[̃oOłB
			case ArgType_Bit:
				{
					data = blob_add_bit(data, pArg->value.v_bit);
				}
				break;
			case ArgType_Byte:
				{
					data = blob_add_byte(data, pArg->value.v_byte);
				}
				break;
			case ArgType_Half:
				{
					data = blob_add_half(data, pArg->value.v_half);
				}
				break;
			case ArgType_Exp10:
				{
					data = blob_add_exp10(data, pArg->value.v_exp10);
				}
				break;
			case ArgType_Word:
				{
					data = blob_add_word(data, pArg->value.v_word);
				}
				break;
//{{2018/04/07ǉ:XgBERk܂߂悤ɂ܂B
			case ArgType_Ber:
				{
					data = blob_add_ber(data, pArg->value.v_ber);
				}
				break;
//}}2018/04/07ǉ:XgBERk܂߂悤ɂ܂B
			case ArgType_Fp16:
				{
					data = blob_add_fp16(data, pArg->value.v_fp16);
				}
				break;
			case ArgType_Fp32:
				{
					data = blob_add_fp32(data, pArg->value.v_fp32);
				}
				break;
			case ArgType_Fp64:
				{
					data = blob_add_fp64(data, pArg->value.v_fp64);
				}
				break;
			case ArgType_String:
				{
					data = blob_add_string(data, pArg->value.v_string);
				}
				break;
			case ArgType_File:
				{
					FILE* fp;
					struct stat st;
					void* buf;
					if(!(fp = fopen(pArg->value.v_file, "rb"))) {	//oCi[hŊJB
						yyerror("%s J܂B", pArg->value.v_file);
						yynerrs++;	//Ăяo(main)ɒm点邽߂ɁB
						break;		//SẴZ}eBNXG[񍐂邽߂ɌpB
					}
					if(fstat(fileno(fp), &st)) { DIE(); }
					if(!(buf = malloc(st.st_size))) { DIE(); }
					if((int)fread(buf, 1, st.st_size, fp) != (int)st.st_size) { DIE(); }	//fread()̖߂lunsigned^Cst.st_size(Ȃ)signed^Ȃ̂ŁÂ܂ܔrƌxoBx}ɂ͕ЕLXg邾łǂAՂ̂߂ɗLXgĔr鎖ɂB
					data = blob_add_data(data, buf, st.st_size);
					free(buf);
					fclose(fp);
				}
				break;
			case ArgType_Table:
				{
				
					ST_SnrTbl* pSnrTbl;
					if(!g_tree_lookup_extended(tree_pSnrTbl, pArg->value.v_table, NULL, &pSnrTbl)) {
						yyerror("ViIe[ux`Ă܂B(%s)", pArg->value.v_table);
						yynerrs++;	//Ăяo(main)ɒm点邽߂ɁB
						break;		//SẴZ}eBNXG[񍐂邽߂ɌpB
					}
					if((unsigned)pSnrTbl->iSnrTbl > UINT16_MAX) {
						yyerror("Xg̃ViIe[uԍ͈͊OłB(%d)", pSnrTbl->iSnrTbl);	//ViIe[u쐬鐔ɐ͗L܂񂪁AXgɎwoViIe[uԍ65535ȉɐ鎖ɂ܂Bf[^eʍ팸̂߂ɁAXgBLOB2oCglƂĊi[邽߂łBʓIɂ͂ŏ\Ǝv܂AŎۂɃG[~ꍇ́A4oCglŊi[悤ɕύX鎖ĉB
						yynerrs++;	//Ăяo(main)ɒm点邽߂ɁB
						break;		//SẴZ}eBNXG[񍐂邽߂ɌpB
					}
					if(!pSnrTbl->iSnrTbl) { DIE(); }	//ɃViIe[uxɃViIe[uԍ蓖čς݂ł͂BŒ~瓖c[̃oOłB
					data = blob_add_half(data, pSnrTbl->iSnrTbl);
				}
				break;
			case ArgType_Trig:
				{
					int iSnrTrg;
					if(!g_tree_lookup_extended(tree_pTrigName_No, pArg->value.v_trig, NULL, (void**)&iSnrTrg)) {	//łTrigName_GetNo()gpĂ͂܂BXgɂ݂͑ȂgKw肳\LȀꍇIł͂ȂK؂ȃG[bZ[W\e؂łB
						yyerror("gK`Ă܂B(%s)", pArg->value.v_trig);
						yynerrs++;	//Ăяo(main)ɒm点邽߂ɁB
						break;		//SẴZ}eBNXG[񍐂邽߂ɌpB
					}
					data = blob_add_byte(data, iSnrTrg);
				}
				break;
			case ArgType_Func:
				{
					int iSnrFnc;
					if(!g_tree_lookup_extended(tree_pFuncName_No, pArg->value.v_func, NULL, (void**)&iSnrFnc)) {	//łFuncName_GetNo()gpĂ͂܂BXgɂ݂͑ȂgKw肳\LȀꍇIł͂ȂK؂ȃG[bZ[W\e؂łB
						yyerror("֐`Ă܂B(%s)", pArg->value.v_func);
						yynerrs++;	//Ăяo(main)ɒm点邽߂ɁB
						break;		//SẴZ}eBNXG[񍐂邽߂ɌpB
					}
					data = blob_add_byte(data, iSnrFnc);
				}
				break;
			}
			pArgList = g_slist_next(pArgList);
		}
	}
	if(blob_get_size(data/*NULL*/) >= UINT8_MAX) {
		yyerror("Xg̃TCY߂܂B");
		yynerrs++;	//Ăяo(main)ɒm点邽߂ɁB
		//SẴZ}eBNXG[񍐂邽߂ɌpB
	}
	return data/*NULL*/;
}
/*- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -*/
//ViIV[PX{fB̎QƐ̃ViIV[PX݂鎖mFB
static void SnrSeqBody_Verify(ST_SnrSeqBody* pSnrSeqBody) {
	if(pSnrSeqBody->pSnrSeqStmtList/*NULL*/) {
		GSList* pSnrSeqStmtList = pSnrSeqBody->pSnrSeqStmtList;
		while(pSnrSeqStmtList) {
			ST_SnrSeqStmt* pSnrSeqStmt = pSnrSeqStmtList->data;
			switch(pSnrSeqStmt->iSnrSeqStmtType) {
			default:DIE();	//Œ~瓖c[̃oOłB
			case SnrSeqStmtType_Exit:
				{
					ST_ExitStmt* pExitStmt = &pSnrSeqStmt->exitStmt;
					/** no job **/
				}
				break;
			case SnrSeqStmtType_Escape:
				{
					ST_EscapeStmt* pEscapeStmt = &pSnrSeqStmt->escapeStmt;
					/** no job **/
				}
				break;
			case SnrSeqStmtType_Wait:
				{
					ST_WaitStmt* pWaitStmt = &pSnrSeqStmt->waitStmt;
					/** no job **/
				}
				break;
			case SnrSeqStmtType_WaitFor:
				{
					ST_WaitForStmt* pWaitForStmt = &pSnrSeqStmt->waitForStmt;
					/** no job **/
				}
				break;
			case SnrSeqStmtType_Fork:
				{
					ST_ForkStmt* pForkStmt = &pSnrSeqStmt->forkStmt;
					SnrSeqBody_Verify(pForkStmt->pSnrSeqBody);
				}
				break;
			case SnrSeqStmtType_Hide:
				{
					ST_HideStmt* pHideStmt = &pSnrSeqStmt->hideStmt;
					/** no job **/
				}
				break;
			case SnrSeqStmtType_Join:
				{
					ST_JoinStmt* pJoinStmt = &pSnrSeqStmt->joinStmt;
					/** no job **/
				}
				break;
			case SnrSeqStmtType_Goto:
				{
					ST_GotoStmt* pGotoStmt = &pSnrSeqStmt->gotoStmt;
					char* pSnrSeqLabel = pGotoStmt->pSnrSeqLabel;
					if(!g_tree_lookup(tree_pSnrSeq, pSnrSeqLabel)) {
						yyerror("ViIV[PXx`Ă܂B(%s)", pSnrSeqLabel);
						yynerrs++;	//Ăяo(main)ɒm点邽߂ɁB
						//SẴZ}eBNXG[񍐂邽߂ɌpB
					}
				}
				break;
			case SnrSeqStmtType_Call:
				{
					ST_CallStmt* pCallStmt = &pSnrSeqStmt->callStmt;
					char* pSnrSeqLabel = pCallStmt->pSnrSeqLabel;
					if(!g_tree_lookup(tree_pSnrSeq, pSnrSeqLabel)) {
						yyerror("ViIV[PXx`Ă܂B(%s)", pSnrSeqLabel);
						yynerrs++;	//Ăяo(main)ɒm点邽߂ɁB
						//SẴZ}eBNXG[񍐂邽߂ɌpB
					}
				}
				break;
			case SnrSeqStmtType_If:
				{
					ST_IfStmt* pIfStmt = &pSnrSeqStmt->ifStmt;
					SnrSeqBody_Verify(pIfStmt->pIfSubs->pSnrSeqBody);
					if(pIfStmt->pElifSubsList/*NULL*/) {
						GSList* pElifSubsList = pIfStmt->pElifSubsList;
						while(pElifSubsList) {
							ST_CondSubs* pElifSubs = pElifSubsList->data;
							SnrSeqBody_Verify(pElifSubs->pSnrSeqBody);
							pElifSubsList = g_slist_next(pElifSubsList);
						}
					}
					if(pIfStmt->pElseSubs/*NULL*/) {
						SnrSeqBody_Verify(pIfStmt->pElseSubs);
					}
				}
				break;
			case SnrSeqStmtType_Case:
				{
					ST_CaseStmt* pCaseStmt = &pSnrSeqStmt->caseStmt;
					{
						GSList* pOfSubsList = pCaseStmt->pOfSubsList;
						while(pOfSubsList) {
							ST_CondSubs* pOfSubs = pOfSubsList->data;
							SnrSeqBody_Verify(pOfSubs->pSnrSeqBody);
							pOfSubsList = g_slist_next(pOfSubsList);
						}
					}
					if(pCaseStmt->pElseSubs/*NULL*/) {
						SnrSeqBody_Verify(pCaseStmt->pElseSubs);
					}
				}
				break;
			case SnrSeqStmtType_Repeat:
				{
					ST_RepeatStmt* pRepeatStmt = &pSnrSeqStmt->repeatStmt;
					SnrSeqBody_Verify(pRepeatStmt->pSnrSeqBody);
				}
				break;
			case SnrSeqStmtType_Break:
				{
					ST_BreakStmt* pBreakStmt = &pSnrSeqStmt->breakStmt;
					/** no job **/
				}
				break;
			case SnrSeqStmtType_While:
				{
					ST_WhileStmt* pWhileStmt = &pSnrSeqStmt->whileStmt;
					SnrSeqBody_Verify(pWhileStmt->pSnrSeqBody);
				}
				break;
			case SnrSeqStmtType_Act:
				{
					ST_ActStmt* pActStmt = &pSnrSeqStmt->actStmt;
					/** no job **/
				}
				break;
			}
			pSnrSeqStmtList = g_slist_next(pSnrSeqStmtList);
		}
	}
}
/*- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */
//̃ViIV[PX{fB,y,̃ViIV[PX{fBHViIV[PX,ViIV[PX{fB,Xg}[NB
static void SnrSeqBody_Mark(ST_SnrSeqBody* pSnrSeqBody) {
	if(!g_tree_lookup(tree_pSnrSeqBody_Used, pSnrSeqBody)) {		//܂}[NĂȂ΁c
		g_tree_insert(tree_pSnrSeqBody_Used, pSnrSeqBody, pSnrSeqBody);	//}[NB
		if(pSnrSeqBody->pSnrSeqStmtList/*NULL*/) {
			GSList* pSnrSeqStmtList = pSnrSeqBody->pSnrSeqStmtList;
			while(pSnrSeqStmtList) {
				ST_SnrSeqStmt* pSnrSeqStmt = pSnrSeqStmtList->data;
				switch(pSnrSeqStmt->iSnrSeqStmtType) {
				default:DIE();	//Œ~瓖c[̃oOłB
				case SnrSeqStmtType_Exit:
					{
						ST_ExitStmt* pExitStmt = &pSnrSeqStmt->exitStmt;
						/** no job **/
					}
					break;
				case SnrSeqStmtType_Escape:
					{
						ST_EscapeStmt* pEscapeStmt = &pSnrSeqStmt->escapeStmt;
						/** no job **/
					}
					break;
				case SnrSeqStmtType_Wait:
					{
						ST_WaitStmt* pWaitStmt = &pSnrSeqStmt->waitStmt;
						/** no job **/
					}
					break;
				case SnrSeqStmtType_WaitFor:
					{
						ST_WaitForStmt* pWaitForStmt = &pSnrSeqStmt->waitForStmt;
						if(!g_tree_lookup(tree_pArgs_Used, pWaitForStmt->pCond->pFunc->pArgs)) {					//܂}[NĂȂ΁c
							g_tree_insert(tree_pArgs_Used, pWaitForStmt->pCond->pFunc->pArgs, pWaitForStmt->pCond->pFunc->pArgs);	//}[NB
						}
					}
					break;
				case SnrSeqStmtType_Fork:
					{
						ST_ForkStmt* pForkStmt = &pSnrSeqStmt->forkStmt;
						SnrSeqBody_Mark(pForkStmt->pSnrSeqBody);
					}
					break;
				case SnrSeqStmtType_Hide:
					{
						ST_HideStmt* pHideStmt = &pSnrSeqStmt->hideStmt;
						/** no job **/
					}
					break;
				case SnrSeqStmtType_Join:
					{
						ST_JoinStmt* pJoinStmt = &pSnrSeqStmt->joinStmt;
						/** no job **/
					}
					break;
				case SnrSeqStmtType_Goto:
					{
						ST_GotoStmt* pGotoStmt = &pSnrSeqStmt->gotoStmt;
						char* pSnrSeqLabel = pGotoStmt->pSnrSeqLabel;
						if(!g_tree_lookup(tree_pSnrSeq_Used, pSnrSeqLabel)) {			//܂}[NĂȂ΁c
							ST_SnrSeq* pSnrSeq = g_tree_lookup(tree_pSnrSeq, pSnrSeqLabel);	//}[NB
							if(!pSnrSeq) { DIE(); }	//ɃViIV[PX̎QƐ̃ViIV[PX݂鎖mF鎖mFς݂ł͂BŒ~瓖c[̃oOłB
							g_tree_insert(tree_pSnrSeq_Used, pSnrSeqLabel, pSnrSeq);
							SnrSeqBody_Mark(pSnrSeq->pSnrSeqBody);
						}
					}
					break;
				case SnrSeqStmtType_Call:
					{
						ST_CallStmt* pCallStmt = &pSnrSeqStmt->callStmt;
						char* pSnrSeqLabel = pCallStmt->pSnrSeqLabel;
						if(!g_tree_lookup(tree_pSnrSeq_Used, pSnrSeqLabel)) {			//܂}[NĂȂ΁c
							ST_SnrSeq* pSnrSeq = g_tree_lookup(tree_pSnrSeq, pSnrSeqLabel);	//}[NB
							if(!pSnrSeq) { DIE(); }	//ɃViIV[PX̎QƐ̃ViIV[PX݂鎖mF鎖mFς݂ł͂BŒ~瓖c[̃oOłB
							g_tree_insert(tree_pSnrSeq_Used, pSnrSeqLabel, pSnrSeq);
							SnrSeqBody_Mark(pSnrSeq->pSnrSeqBody);
						}
					}
					break;
				case SnrSeqStmtType_If:
					{
						ST_IfStmt* pIfStmt = &pSnrSeqStmt->ifStmt;
						if(!g_tree_lookup(tree_pArgs_Used, pIfStmt->pIfSubs->pCond->pFunc->pArgs)) {						//܂}[NĂȂ΁c
							g_tree_insert(tree_pArgs_Used, pIfStmt->pIfSubs->pCond->pFunc->pArgs, pIfStmt->pIfSubs->pCond->pFunc->pArgs);	//}[NB
						}
						SnrSeqBody_Mark(pIfStmt->pIfSubs->pSnrSeqBody);
						if(pIfStmt->pElifSubsList/*NULL*/) {
							GSList* pElifSubsList = pIfStmt->pElifSubsList;
							while(pElifSubsList) {
								ST_CondSubs* pElifSubs = pElifSubsList->data;
								if(!g_tree_lookup(tree_pArgs_Used, pElifSubs->pCond->pFunc->pArgs)) {					//܂}[NĂȂ΁c
									g_tree_insert(tree_pArgs_Used, pElifSubs->pCond->pFunc->pArgs, pElifSubs->pCond->pFunc->pArgs);	//}[NB
								}
								SnrSeqBody_Mark(pElifSubs->pSnrSeqBody);
								pElifSubsList = g_slist_next(pElifSubsList);
							}
						}
						if(pIfStmt->pElseSubs/*NULL*/) {
							SnrSeqBody_Mark(pIfStmt->pElseSubs);
						}
					}
					break;
				case SnrSeqStmtType_Case:
					{
						ST_CaseStmt* pCaseStmt = &pSnrSeqStmt->caseStmt;
						if(!g_tree_lookup(tree_pArgs_Used, pCaseStmt->pFunc->pArgs)) {					//܂}[NĂȂ΁c
							g_tree_insert(tree_pArgs_Used, pCaseStmt->pFunc->pArgs, pCaseStmt->pFunc->pArgs);	//}[NB
						}
						{
							GSList* pOfSubsList = pCaseStmt->pOfSubsList;
							while(pOfSubsList) {
								ST_ValueSubs* pOfSubs = pOfSubsList->data;
								SnrSeqBody_Mark(pOfSubs->pSnrSeqBody);
								pOfSubsList = g_slist_next(pOfSubsList);
							}
						}
						if(pCaseStmt->pElseSubs/*NULL*/) {
							SnrSeqBody_Mark(pCaseStmt->pElseSubs);
						}
					}
					break;
				case SnrSeqStmtType_Repeat:
					{
						ST_RepeatStmt* pRepeatStmt = &pSnrSeqStmt->repeatStmt;
						SnrSeqBody_Mark(pRepeatStmt->pSnrSeqBody);
					}
					break;
				case SnrSeqStmtType_Break:
					{
						ST_BreakStmt* pBreakStmt = &pSnrSeqStmt->breakStmt;
						/** no job **/
					}
					break;
				case SnrSeqStmtType_While:
					{
						ST_WhileStmt* pWhileStmt = &pSnrSeqStmt->whileStmt;
						if(!g_tree_lookup(tree_pArgs_Used, pWhileStmt->pCond->pFunc->pArgs)) {						//܂}[NĂȂ΁c
							g_tree_insert(tree_pArgs_Used, pWhileStmt->pCond->pFunc->pArgs, pWhileStmt->pCond->pFunc->pArgs);	//}[NB
						}
						SnrSeqBody_Mark(pWhileStmt->pSnrSeqBody);
					}
					break;
				case SnrSeqStmtType_Act:
					{
						ST_ActStmt* pActStmt = &pSnrSeqStmt->actStmt;
						if(!g_tree_lookup(tree_pArgs_Used, pActStmt->pFunc->pArgs)) {				//܂}[NĂȂ΁c
							g_tree_insert(tree_pArgs_Used, pActStmt->pFunc->pArgs, pActStmt->pFunc->pArgs);	//}[NB
						}
					}
					break;
				}
				pSnrSeqStmtList = g_slist_next(pSnrSeqStmtList);
			}
		}
	}
}
/*- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */
//̃ViIe[u{fBċAIɒHViIV[PX}[NB
static void SnrTblBody_Mark(ST_SnrTblBody* pSnrTblBody) {
	GSList* pSnrTblStmtList = pSnrTblBody->pSnrTblStmtList;
	while(pSnrTblStmtList) {
		ST_SnrTblStmt* pSnrTblStmt = pSnrTblStmtList->data;
		switch(pSnrTblStmt->iSnrTblStmtType) {
		default:DIE();	//Œ~瓖c[̃oOłB
		case SnrTblStmtType_OnUnlock:
			{
				ST_OnUnlockStmt* pOnUnlockStmt = &pSnrTblStmt->onUnlockStmt;
				{
					/** no job **/
				}
			}
			break;
		case SnrTblStmtType_OnGoto:
			{
				ST_OnGotoStmt* pOnGotoStmt = &pSnrTblStmt->onGotoStmt;
				{
					char* pSnrSeqLabel = pOnGotoStmt->pSnrSeqLabel;
					ST_SnrSeq* pSnrSeq = g_tree_lookup(tree_pSnrSeq, pSnrSeqLabel);
					if(pSnrSeq) {
						if(!g_tree_lookup(tree_pSnrSeq_Used, pSnrSeqLabel)) {	//܂}[NĂȂ΁c
							g_tree_insert(tree_pSnrSeq_Used, pSnrSeqLabel, pSnrSeq);
							SnrSeqBody_Mark(pSnrSeq->pSnrSeqBody);
						}
					} else {
						yyerror("ViIV[PXx`Ă܂B(%s)", pSnrSeqLabel);
						yynerrs++;	//Ăяo(main)ɒm点邽߂ɁB
						//SẴZ}eBNXG[񍐂邽߂ɌpB
					}
				}
			}
			break;
		case SnrTblStmtType_OnExec:
			{
				ST_OnExecStmt* pOnExecStmt = &pSnrTblStmt->onExecStmt;
				{
					char* pSnrSeqLabel = pOnExecStmt->pSnrSeqLabel;
					ST_SnrSeq* pSnrSeq = g_tree_lookup(tree_pSnrSeq, pSnrSeqLabel);
					if(pSnrSeq) {
						if(!g_tree_lookup(tree_pSnrSeq_Used, pSnrSeqLabel)) {	//܂}[NĂȂ΁c
							g_tree_insert(tree_pSnrSeq_Used, pSnrSeqLabel, pSnrSeq);
							SnrSeqBody_Mark(pSnrSeq->pSnrSeqBody);
						}
					} else {
						yyerror("ViIV[PXx`Ă܂B(%s)", pSnrSeqLabel);
						yynerrs++;	//Ăяo(main)ɒm点邽߂ɁB
						//SẴZ}eBNXG[񍐂邽߂ɌpB
					}
				}
			}
			break;
		}
		pSnrTblStmtList = g_slist_next(pSnrTblStmtList);
	}
}
/*- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */
//w肳ꂽAhXÄXg̐擪AhXւ́A΋߂B
//̈Xg܂}[NĂȂ΁A_~[ԂB
//ȂƂA2ڂ̏Ăяoꂽ_ł́A}[NĂ͂łB
static int Args_GetDist(ST_Args* pArgs, int addr) {
	ST_Code* pArgsCode = g_tree_lookup(tree_pArgs_Code, pArgs);
	int iArgsDist = pArgsCode ? (pArgsCode->addr - addr) : 0/*_~[*/;
	if((iArgsDist < INT24_MIN) || (iArgsDist > INT24_MAX)) {
		yyerror("Xg̑΋͈͊OłB");
		DIE();	//pĂʂȂ̂ŏIB
	}
	return iArgsDist;
}
/*- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */
//w肳ꂽAhXÃViIV[PX{fB̐擪AhXւ́A΋߂B
//̃ViIV[PX{fB܂}[NĂȂ΁A_~[ԂB
//ȂƂA2ڂ̏Ăяoꂽ_ł́A}[NĂ͂łB
static int SnrSeqBody_GetDist(ST_SnrSeqBody* pSnrSeqBody, int addr) {
	ST_Code* pSnrSeqBodyCode = g_tree_lookup(tree_pSnrSeqBody_Code, pSnrSeqBody);
	int iSnrSeqBodyDist = pSnrSeqBodyCode ? (pSnrSeqBodyCode->addr - addr) : 0/*_~[*/;
	if((iSnrSeqBodyDist < INT24_MIN) || (iSnrSeqBodyDist > INT24_MAX)) {
		yyerror("ViIV[PX{fB̑΋͈͊OłB");
		DIE();	//pĂʂȂ̂ŏIB
	}
	return iSnrSeqBodyDist;
}
/*- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */
//w肳ꂽAhXÃViIV[PX̐擪AhXւ́A΋߂B
//̃ViIV[PX܂}[NĂȂ΁A_~[ԂB
//ȂƂA2ڂ̏Ăяoꂽ_ł́A}[NĂ͂łB
static int SnrSeqLabel_GetDist(char* pSnrSeqLabel, int addr) {
	ST_SnrSeq* pSnrSeq = g_tree_lookup(tree_pSnrSeq_Used, pSnrSeqLabel);
	if(!pSnrSeq) { DIE(); }	//ɃViIe[u̎QƐ̃ViIV[PX݂鎖mF鎖mFς݂ł͂BŒ~瓖c[̃oOłB
	return SnrSeqBody_GetDist(pSnrSeq->pSnrSeqBody, addr);
}
/*- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */
//gKԍ擾B
static int TrigName_GetNo(char* pTrigName) {
	int iSnrTrg;
	if(!g_tree_lookup_extended(tree_pTrigName_No, pTrigName, NULL, (void**)&iSnrTrg)) { DIE(); }	//ɃgKɃgKԍ蓖čς݂ł͂BŒ~瓖c[̃oOłB
	return iSnrTrg;
}
/*- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */
//֐ԍ擾B
static int FuncName_GetNo(char* pFuncName) {
	int iSnrFnc;
	if(!g_tree_lookup_extended(tree_pFuncName_No, pFuncName, NULL, (void**)&iSnrFnc)) { DIE(); }	//Ɋ֐Ɋ֐ԍ蓖čς݂ł͂BŒ~瓖c[̃oOłB
	return iSnrFnc;
}
/*- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */
//ViIe[u{fB̃R[h𐶐B
//1:R[h𐶐ăAhX蓖ĂB
//2:{R[h𐶐B
static int SnrTblBody_CodeGen(ST_SnrTblBody* pSnrTblBody, int addr) {
	ST_Code* pCode = Code_New(addr);
	{
		GSList* pSnrTblStmtList = pSnrTblBody->pSnrTblStmtList;
		while(pSnrTblStmtList) {
			ST_SnrTblStmt* pSnrTblStmt = pSnrTblStmtList->data;
			switch(pSnrTblStmt->iSnrTblStmtType) {
			default:DIE();	//Œ~瓖c[̃oOłB
			case SnrTblStmtType_OnUnlock:
				{
					ST_OnUnlockStmt* pOnUnlockStmt = &pSnrTblStmt->onUnlockStmt;
					{
						int iSnrTrg = TrigName_GetNo(pOnUnlockStmt->pTrigName);
						addr += Code_AddValue(pCode, SnrTbl_on_unlock, 1);
						addr += Code_AddValue(pCode, iSnrTrg,          1);
					}
				}
				break;
			case SnrTblStmtType_OnGoto:
				{
					ST_OnGotoStmt* pOnGotoStmt = &pSnrTblStmt->onGotoStmt;
					{
						int iSnrTrg = TrigName_GetNo(pOnGotoStmt->pTrigName);
						int iSnrSeqBodyDist = SnrSeqLabel_GetDist(pOnGotoStmt->pSnrSeqLabel,             addr + 1 + 1 + 3 + 2);
						addr += Code_AddValue(pCode, pOnGotoStmt->bUnlock ? SnrTbl_on_unlock_goto : SnrTbl_on_goto, 1        );
						addr += Code_AddValue(pCode, iSnrTrg,                                                         1      );
						addr += Code_AddValue(pCode, iSnrSeqBodyDist,                                                     3  );
						addr += Code_AddValue(pCode, pOnGotoStmt->nLock,                                                    2);
					}
				}
				break;
			case SnrTblStmtType_OnExec:
				{
					ST_OnExecStmt* pOnExecStmt = &pSnrTblStmt->onExecStmt;
					{
						int iSnrTrg = TrigName_GetNo(pOnExecStmt->pTrigName);
						int iSnrSeqBodyDist = SnrSeqLabel_GetDist(pOnExecStmt->pSnrSeqLabel,             addr + 1 + 1 + 3 + 2);
						addr += Code_AddValue(pCode, pOnExecStmt->bUnlock ? SnrTbl_on_unlock_exec : SnrTbl_on_exec, 1        );
						addr += Code_AddValue(pCode, iSnrTrg,                                                         1      );
						addr += Code_AddValue(pCode, iSnrSeqBodyDist,                                                     3  );
						addr += Code_AddValue(pCode, pOnExecStmt->nLock,                                                    2);
					}
				}
				break;
			}
			pSnrTblStmtList = g_slist_next(pSnrTblStmtList);
		}
		addr += Code_AddValue(pCode, SnrTbl_end, 1);	//YȂ!!
	}
	{
		ST_Code* pOldCode = g_tree_lookup(tree_pSnrTblBody_Code, pSnrTblBody);
		if(pOldCode && ((pOldCode->addr != pCode->addr) || (pOldCode->code->len != pCode->code->len))) { DIE(); }	//1ڂ2ڂAhXƃR[hTCY͈v͂BŒ~瓖c[̃oOłB
		if(pCode->code->len != (addr - pCode->addr)) { DIE(); }	//R[h̃TCYƃAhX͈̑v͂BŒ~瓖c[̃oOłB
		g_tree_replace(tree_pSnrTblBody_Code, pSnrTblBody, pCode);
	}
	return addr;
}
/*- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */
//ViIV[PX{fB̃R[h𐶐B
//1:R[h𐶐ăAhX蓖ĂB
//2:{R[h𐶐B
static int SnrSeqBody_CodeGen(ST_SnrSeqBody* pSnrSeqBody, int addr) {
	ST_Code* pCode = Code_New(addr);
	{
		GSList* pSnrSeqStmtList = pSnrSeqBody->pSnrSeqStmtList;
		while(pSnrSeqStmtList) {
			ST_SnrSeqStmt* pSnrSeqStmt = pSnrSeqStmtList->data;
			switch(pSnrSeqStmt->iSnrSeqStmtType) {
			default:DIE();	//Œ~瓖c[̃oOłB
			case SnrSeqStmtType_Exit:
				{
					ST_ExitStmt* pExitStmt = &pSnrSeqStmt->exitStmt;
					{
						addr += Code_AddValue(pCode, SnrSeq_exit, 1);
					}
				}
				break;
			case SnrSeqStmtType_Escape:
				{
					ST_EscapeStmt* pEscapeStmt = &pSnrSeqStmt->escapeStmt;
					{
						addr += Code_AddValue(pCode, SnrSeq_escape, 1);
					}
				}
				break;
			case SnrSeqStmtType_Wait:
				{
					ST_WaitStmt* pWaitStmt = &pSnrSeqStmt->waitStmt;
					{
						addr += Code_AddValue(pCode, SnrSeq_wait,         1);
						addr += Code_AddValue(pCode, pWaitStmt->nWaitCnt, 2);
					}
				}
				break;
			case SnrSeqStmtType_WaitFor:
				{
					ST_WaitForStmt* pWaitForStmt = &pSnrSeqStmt->waitForStmt;
					{
						int iSnrFnc = FuncName_GetNo(pWaitForStmt->pCond->pFunc->pFuncName);
						int iArgsDist = Args_GetDist(pWaitForStmt->pCond->pFunc->pArgs,                          addr + 1 + 1 + 3);
						addr += Code_AddValue(pCode, pWaitForStmt->pCond->bNot ? SnrSeq_wait_for_not : SnrSeq_wait_for, 1        );
						addr += Code_AddValue(pCode, iSnrFnc,                                                               1    );
						addr += Code_AddValue(pCode, iArgsDist,                                                                 3);
					}
				}
				break;
			case SnrSeqStmtType_Fork:
				{
					ST_ForkStmt* pForkStmt = &pSnrSeqStmt->forkStmt;
					{
						int iSnrSeqBodyDist = SnrSeqBody_GetDist(pForkStmt->pSnrSeqBody, addr + 1 + 3);
						addr += Code_AddValue(pCode, SnrSeq_fork,                               1    );
						addr += Code_AddValue(pCode, iSnrSeqBodyDist,                               3);
					}
				}
				break;
			case SnrSeqStmtType_Hide:
				{
					ST_HideStmt* pHideStmt = &pSnrSeqStmt->hideStmt;
					{
						addr += Code_AddValue(pCode, SnrSeq_hide, 1);
					}
				}
				break;
			case SnrSeqStmtType_Join:
				{
					ST_JoinStmt* pJoinStmt = &pSnrSeqStmt->joinStmt;
					{
						addr += Code_AddValue(pCode, SnrSeq_join, 1);
					}
				}
				break;
			case SnrSeqStmtType_Goto:
				{
					ST_GotoStmt* pGotoStmt = &pSnrSeqStmt->gotoStmt;
					{
						int iSnrSeqBodyDist = SnrSeqLabel_GetDist(pGotoStmt->pSnrSeqLabel, addr + 1 + 3);
						addr += Code_AddValue(pCode, SnrSeq_goto,                                 1    );
						addr += Code_AddValue(pCode, iSnrSeqBodyDist,                                 3);
					}
				}
				break;
			case SnrSeqStmtType_Call:
				{
					ST_CallStmt* pCallStmt = &pSnrSeqStmt->callStmt;
					{
						int iSnrSeqBodyDist = SnrSeqLabel_GetDist(pCallStmt->pSnrSeqLabel, addr + 1 + 3);
						addr += Code_AddValue(pCode, SnrSeq_call,                                 1    );
						addr += Code_AddValue(pCode, iSnrSeqBodyDist,                                 3);
					}
				}
				break;
			case SnrSeqStmtType_If:
				{
					ST_IfStmt* pIfStmt = &pSnrSeqStmt->ifStmt;
					{
						{
							int iSnrFnc = FuncName_GetNo(pIfStmt->pIfSubs->pCond->pFunc->pFuncName);
							int iArgsDist = Args_GetDist(pIfStmt->pIfSubs->pCond->pFunc->pArgs,              addr + 1 + 1 + 3 + 3);
							int iSnrSeqBodyDist = SnrSeqBody_GetDist(pIfStmt->pIfSubs->pSnrSeqBody,          addr + 1 + 1 + 3 + 3);
							addr += Code_AddValue(pCode, pIfStmt->pIfSubs->pCond->bNot ? SnrSeq_if_not : SnrSeq_if, 1            );
							addr += Code_AddValue(pCode, iSnrFnc,                                                       1        );
							addr += Code_AddValue(pCode, iArgsDist,                                                         3    );
							addr += Code_AddValue(pCode, iSnrSeqBodyDist,                                                       3);
						}
						if(pIfStmt->pElifSubsList/*NULL*/) {
							GSList* pElifSubsList = pIfStmt->pElifSubsList;
							while(pElifSubsList) {
								ST_CondSubs* pElifSubs = pElifSubsList->data;
								{
									int iSnrFnc = FuncName_GetNo(pElifSubs->pCond->pFunc->pFuncName);
									int iArgsDist = Args_GetDist(pElifSubs->pCond->pFunc->pArgs,                  addr + 1 + 1 + 3 + 3);
									int iSnrSeqBodyDist = SnrSeqBody_GetDist(pElifSubs->pSnrSeqBody,              addr + 1 + 1 + 3 + 3);
									addr += Code_AddValue(pCode, pElifSubs->pCond->bNot ? SnrSeq_elif_not : SnrSeq_elif, 1            );
									addr += Code_AddValue(pCode, iSnrFnc,                                                    1        );
									addr += Code_AddValue(pCode, iArgsDist,                                                      3    );
									addr += Code_AddValue(pCode, iSnrSeqBodyDist,                                                    3);
								}
								pElifSubsList = g_slist_next(pElifSubsList);
							}
						}
						if(pIfStmt->pElseSubs/*NULL*/) {
							int iSnrSeqBodyDist = SnrSeqBody_GetDist(pIfStmt->pElseSubs, addr + 1 + 3);
							addr += Code_AddValue(pCode, SnrSeq_else,                           1    );
							addr += Code_AddValue(pCode, iSnrSeqBodyDist,                           3);
						}
					}
				}
				break;
			case SnrSeqStmtType_Case:
				{
					ST_CaseStmt* pCaseStmt = &pSnrSeqStmt->caseStmt;
					{
						{
							int iSnrFnc = FuncName_GetNo(pCaseStmt->pFunc->pFuncName);
							int iArgsDist = Args_GetDist(pCaseStmt->pFunc->pArgs, addr + 1 + 1 + 3);
							addr += Code_AddValue(pCode, SnrSeq_case,                    1        );
							addr += Code_AddValue(pCode, iSnrFnc,                            1    );
							addr += Code_AddValue(pCode, iArgsDist,                              3);
						}
						{
							GSList* pOfSubsList = pCaseStmt->pOfSubsList;
							while(pOfSubsList) {
								ST_ValueSubs* pOfSubs = pOfSubsList->data;
								{
									int iSnrSeqBodyDist = SnrSeqBody_GetDist(pOfSubs->pSnrSeqBody, addr + 1 + 1 + 3);
									addr += Code_AddValue(pCode, SnrSeq_of,                               1        );
									addr += Code_AddValue(pCode, pOfSubs->iValue,                             1    );
									addr += Code_AddValue(pCode, iSnrSeqBodyDist,                                 3);
								}
								pOfSubsList = g_slist_next(pOfSubsList);
							}
						}
						if(pCaseStmt->pElseSubs/*NULL*/) {
							int iSnrSeqBodyDist = SnrSeqBody_GetDist(pCaseStmt->pElseSubs, addr + 1 + 3);
							addr += Code_AddValue(pCode, SnrSeq_else,                             1    );
							addr += Code_AddValue(pCode, iSnrSeqBodyDist,                             3);
						}
					}
				}
				break;
			case SnrSeqStmtType_Repeat:
				{
					ST_RepeatStmt* pRepeatStmt = &pSnrSeqStmt->repeatStmt;
					{
						int iSnrSeqBodyDist = SnrSeqBody_GetDist(pRepeatStmt->pSnrSeqBody, addr + 1 + 2 + 3);
						addr += Code_AddValue(pCode, SnrSeq_repeat,                               1        );
						addr += Code_AddValue(pCode, pRepeatStmt->nRepeatCnt,                         2    );
						addr += Code_AddValue(pCode, iSnrSeqBodyDist,                                     3);
					}
				}
				break;
			case SnrSeqStmtType_Break:
				{
					ST_BreakStmt* pBreakStmt = &pSnrSeqStmt->breakStmt;
					{
						addr += Code_AddValue(pCode, SnrSeq_break,          1);
						addr += Code_AddValue(pCode, pBreakStmt->nBreakCnt, 1);
					}
				}
				break;
			case SnrSeqStmtType_While:
				{
					ST_WhileStmt* pWhileStmt = &pSnrSeqStmt->whileStmt;
					{
						int iSnrFnc = FuncName_GetNo(pWhileStmt->pCond->pFunc->pFuncName);
						int iArgsDist = Args_GetDist(pWhileStmt->pCond->pFunc->pArgs,                    addr + 1 + 1 + 3 + 3);
						int iSnrSeqBodyDist = SnrSeqBody_GetDist(pWhileStmt->pSnrSeqBody,                addr + 1 + 1 + 3 + 3);
						addr += Code_AddValue(pCode, pWhileStmt->pCond->bNot ? SnrSeq_while_not : SnrSeq_while, 1            );
						addr += Code_AddValue(pCode, iSnrFnc,                                                       1        );
						addr += Code_AddValue(pCode, iArgsDist,                                                         3    );
						addr += Code_AddValue(pCode, iSnrSeqBodyDist,                                                       3);
					}
				}
				break;
			case SnrSeqStmtType_Act:
				{
					ST_ActStmt* pActStmt = &pSnrSeqStmt->actStmt;
					{
						int iSnrFnc = FuncName_GetNo(pActStmt->pFunc->pFuncName);
						int iArgsDist = Args_GetDist(pActStmt->pFunc->pArgs,                      addr + 1 + 1 + 3);
						addr += Code_AddValue(pCode, pActStmt->bEnsure ? SnrSeq_act_ensure : SnrSeq_act, 1        );
						addr += Code_AddValue(pCode, iSnrFnc,                                                1    );
						addr += Code_AddValue(pCode, iArgsDist,                                                  3);
					}
				}
				break;
			}
			pSnrSeqStmtList = g_slist_next(pSnrSeqStmtList);
		}
		addr += Code_AddValue(pCode, SnrSeq_end, 1);	//YȂ!!
	}
	{
		ST_Code* pOldCode = g_tree_lookup(tree_pSnrSeqBody_Code, pSnrSeqBody);
		if(pOldCode && ((pOldCode->addr != pCode->addr) || (pOldCode->code->len != pCode->code->len))) { DIE(); }	//1ڂ2ڂAhXƃR[hTCY͈v͂BŒ~瓖c[̃oOłB
		if(pCode->code->len != (addr - pCode->addr)) { DIE(); }	//R[h̃TCYƃAhX͈̑v͂BŒ~瓖c[̃oOłB
		g_tree_replace(tree_pSnrSeqBody_Code, pSnrSeqBody, pCode);
	}
	return addr;
}
/*- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */
//Xg̃R[h𐶐B
//1:R[h𐶐ăAhX蓖ĂB
//2:{R[h𐶐B
static int Args_CodeGen(ST_Args* pArgs, int addr) {
	ST_Code* pCode = Code_New(addr |= 3);	//yӁzXg̒l̕4NEɐ񂷂邽߂ɁATCY̕(4N+3)Ɋi[悤ɃpfBOB
	{
		void* data/*NULL*/;
		int   size/*0*/;
		if(!g_tree_lookup_extended(tree_pArgs_Blob, pArgs, NULL, &data)) { DIE(); }	//ɈXgBLOB\zς݂ł͂BŒ~瓖c[̃oOłB
		size/*0*/ = blob_get_size( data/*NULL*/);
		addr += Code_AddValue(pCode,                 size/*0*/, 1);	//(4N+3) TCY̕
		addr += Code_AddData( pCode, data/*NULL*/, size/*0*/);	//4NE l̕
	}
	{
		ST_Code* pOldCode = g_tree_lookup(tree_pArgs_Code, pArgs);
		if(pOldCode && ((pOldCode->addr != pCode->addr) || (pOldCode->code->len != pCode->code->len))) { DIE(); }	//1ڂ2ڂAhXƃR[hTCY͈v͂BŒ~瓖c[̃oOłB
		if(pCode->code->len != (addr - pCode->addr)) { DIE(); }	//R[h̃TCYƃAhX͈̑v͂BŒ~瓖c[̃oOłB
		g_tree_replace(tree_pArgs_Code, pArgs, pCode);
	}
	return addr;
}
/*- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */
static void pass2(int bOptimize) {
	//ViIe[uxɃViIe[uԍ蓖ĂB
	{
		int iSnrTbl = 0;
		GTreeIteratorNP iter;
		char* pSnrTblLabel;
		ST_SnrTbl* pSnrTbl;
		if(g_tree_first_np(tree_pSnrTbl, &iter, &pSnrTblLabel, &pSnrTbl)) {
			do {
				pSnrTbl->iSnrTbl = ++iSnrTbl;	//ST_SnrTbl\͎̂̃L[ɂȂ̂ō쐬ɓeύXĖ薳B
			} while(g_tree_next_np(tree_pSnrTbl, &iter, &pSnrTblLabel, &pSnrTbl));
		}
	}
	//gKɃgKԍ蓖ĂB
	{
		int iSnrTrg = SnrTrg_set;
		GTreeIteratorNP iter;
		char* pTrigName;
		if(g_tree_first_np(tree_pTrigName_No, &iter, &pTrigName, NULL)) {
			do {
				if(!strcmp(pTrigName, "set")) {
					g_tree_replace(tree_pTrigName_No, pTrigName, (void*)SnrTrg_set);	//g_tree_insert()łÄӐ}𖾊mɂ邽߁Ag_tree_replace()gpB
				} else if(!strcmp(pTrigName, "clr")) {
					g_tree_replace(tree_pTrigName_No, pTrigName, (void*)SnrTrg_clr);	//g_tree_insert()łÄӐ}𖾊mɂ邽߁Ag_tree_replace()gpB
				} else {
					if(++iSnrTrg >= SnrTrg_clr) {
						yyerror("gK̐𒴂܂B");
						DIE();	//pĂʂȂ̂ŏIB
					}
					g_tree_replace(tree_pTrigName_No, pTrigName, (void*)iSnrTrg);		//g_tree_insert()łÄӐ}𖾊mɂ邽߁Ag_tree_replace()gpB
				}
			} while(g_tree_next_np(tree_pTrigName_No, &iter, &pTrigName, NULL));
		}
	}
	//֐Ɋ֐ԍ蓖ĂB
	{
		int iSnrFnc = 0;
		GTreeIteratorNP iter;
		char* pFuncName;
		if(g_tree_first_np(tree_pFuncName_No, &iter, &pFuncName, NULL)) {
			do {
				if(++iSnrFnc >= UINT8_MAX) {
					yyerror("֐̐𒴂܂B");
					DIE();	//pĂʂȂ̂ŏIB
				}
				g_tree_replace(tree_pFuncName_No, pFuncName, (void*)iSnrFnc);			//g_tree_insert()łÄӐ}𖾊mɂ邽߁Ag_tree_replace()gpB
			} while(g_tree_next_np(tree_pFuncName_No, &iter, &pFuncName, NULL));
		}
	}
	//XgBLOB\zB
	// - ̌ŃViIe[uċAIɒHȂXgO邪A͂OɍsɒӂB
	//   폜Xg̒ɕsȎQƂ܂񂾈XgLꍇAXNvgƂĂ̓G[ł邩łB
	{
		GTreeIteratorNP iter;
		ST_Args* pArgs;
		if(g_tree_first_np(tree_pArgs, &iter, &pArgs, NULL)) {
			do {
				void* data/*NULL*/ = Args_BuildBlob(pArgs);		//Xg󂾂ꍇAArgs_BuildBlob()NULLԂ܂EEE
				g_tree_insert(tree_pArgs_Blob, pArgs, data/*NULL*/);	//ght_hash_table_tƈāAGTreeɂNULL̒lo^ôŁANULLʈKv͗L܂B
			} while(g_tree_next_np(tree_pArgs, &iter, &pArgs, NULL));
		}
		if(yynerrs) { return; }	//G[ĂA܂ŁB
	}
	//ViIV[PX̎QƐ̃ViIV[PX݂鎖mFB
	// - ̌ŃViIe[uċAIɒHȂViIV[PXO邪A͂OɍsɒӂB
	//   폜ViIV[PX̒ɑ݂ȂViIV[PXLꍇAXNvgƂĂ̓G[ł邩łB
	{
		GTreeIteratorNP iter;
		ST_SnrSeq* pSnrSeq;
		if(g_tree_first_np(tree_pSnrSeq, &iter, NULL, &pSnrSeq)) {
			do {
				ST_SnrSeqBody* pSnrSeqBody = pSnrSeq->pSnrSeqBody;
				SnrSeqBody_Verify(pSnrSeqBody);
			} while(g_tree_next_np(tree_pSnrSeq, &iter, NULL, &pSnrSeq));
		}
		if(yynerrs) { return; }	//G[ĂA܂ŁB
	}
	//ViIe[uċAIɒHViIV[PX}[NB
	{
		GTreeIteratorNP iter;
		ST_SnrTbl* pSnrTbl;
		if(g_tree_first_np(tree_pSnrTbl, &iter, NULL, &pSnrTbl)) {
			do {
				ST_SnrTblBody* pSnrTblBody = pSnrTbl->pSnrTblBody;
				SnrTblBody_Mark(pSnrTblBody);
			} while(g_tree_next_np(tree_pSnrTbl, &iter, NULL, &pSnrTbl));
		}
		if(yynerrs) { return; }	//G[ĂA܂ŁB
	}
	//ȍ~AAL͎̎QƂȂB
	// - ̂܂܎cĂĂ\ȂAĎQƂꍇɂoO𔭌o悤ANULLŃNAĂɂB
	{
	//g	tree_pSnrTbl		= NULL;
		tree_pSnrSeq		= NULL;
	//g	tree_pSnrSeq_Used	= NULL;
		tree_pArg		= NULL;
		tree_pArgList		= NULL;
		tree_pArgs		= NULL;
	//g	tree_pArgs_Used		= NULL;
	//g	tree_pArgs_Blob		= NULL;
	//g	tree_pArgs_Code		= NULL;
		tree_pFunc		= NULL;
		tree_pCond		= NULL;
		tree_pCondSubs		= NULL;
		tree_pCondSubsList	= NULL;
		tree_pValueSubs		= NULL;
		tree_pValueSubsList	= NULL;
	//g	tree_pSnrTblBody	= NULL;
	//g	tree_pSnrTblBody_Code	= NULL;
		tree_pSnrTblStmt	= NULL;
		tree_pSnrSeqBody	= NULL;
	//g	tree_pSnrSeqBody_Used	= NULL;
	//g	tree_pSnrSeqBody_Code	= NULL;
		tree_pSnrSeqStmt	= NULL;
	//g	tree_pTrigName_No	= NULL;
	//g	tree_pFuncName_No	= NULL;
	}
	{
		//1:R[h𐶐ăAhX蓖ĂB
		//2:{R[h𐶐B
		int i;
		for(i = 0; i < 2; i++) {
			int addr = 0;
			//ViIe[u{fB
			{
				GTreeIteratorNP iter;
				ST_SnrTblBody* pSnrTblBody;
				if(g_tree_first_np(tree_pSnrTblBody, &iter, &pSnrTblBody, NULL)) {
					do {
						addr = SnrTblBody_CodeGen(pSnrTblBody, addr);
					} while(g_tree_next_np(tree_pSnrTblBody, &iter, &pSnrTblBody, NULL));
				}
			}
			//ViIV[PX{fB
			{
				GTreeIteratorNP iter;
				ST_SnrSeqBody* pSnrSeqBody;
				if(g_tree_first_np(tree_pSnrSeqBody_Used, &iter, &pSnrSeqBody, NULL)) {
					do {
						addr = SnrSeqBody_CodeGen(pSnrSeqBody, addr);
					} while(g_tree_next_np(tree_pSnrSeqBody_Used, &iter, &pSnrSeqBody, NULL));
				}
			}
			//Xg
			{
				GTreeIteratorNP iter;
				ST_Args* pArgs;
				if(g_tree_first_np(tree_pArgs_Used, &iter, &pArgs, NULL)) {
					do {
						addr = Args_CodeGen(pArgs, addr);
					} while(g_tree_next_np(tree_pArgs_Used, &iter, &pArgs, NULL));
				}
			}
			//ŏIAhXi[B
			if(i && (addr != endAddr)) { DIE(); }	//1ڂ2ڂŏIAhX͈v͂BŒ~瓖c[̃oOłB
			endAddr = addr;
		}
	}
	//œKsB
	if(bOptimize) { optimize(); }
}
/*---------------------------------------------------------------------------*/
//œK
/*- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -*/
static void optimize() {
	//œK͗L܂B
	//ʏ̏ŏd菜Ă̂ŁAʏ̏ōő̍œKsĂ͂łB
	//AœK@\ǉꍇ̂߂̃v[Xz_ƂāA֐̂ݗpӂėL܂B
	//݂̂Ƃ́AR}hCIvV'-d'w肵ĂȂĂႢ͗L܂B
}
/*---------------------------------------------------------------------------*/
//o͏
/*- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -*/
static void output(const char* sBinOut, const char* sTblOut, int bLabTbl) {
	g_tree_remove(tree_pTrigName_No, "set");										//"set""clr"̓CuŒ`Ă̂ŁAł͏o͑ΏۊOƂ邽߂Ɏ폜ĂB
	g_tree_remove(tree_pTrigName_No, "clr");										//tree_pTrigName_NoύX̂ŁAtree_pTrigName_NoQƂȂ悤ӂB
	//`o͂B
	{
		//C#`
		if(!strcmp(opt_x, "cs")) {
			puts("static partial class Const {");
		}
		//xWo͂ɏo͂B
		{
			GTreeIteratorNP iter;
			char* pSnrTblLabel;
			ST_SnrTbl* pSnrTbl;
			puts("//ViIe[u");
			if(g_tree_first_np(tree_pSnrTbl, &iter, &pSnrTblLabel, &pSnrTbl)) {
				do {
					//C`
					if(!strcmp(opt_x, "c")) {
						printf("#define SnrTblNo_%s %d\n", pSnrTblLabel, pSnrTbl->iSnrTbl);
					//C#`
					} else if(!strcmp(opt_x, "cs")) {
						printf("public const int SnrTblNo_%s = %d;\n", pSnrTblLabel, pSnrTbl->iSnrTbl);
					} else {
						DIE();	//oO
					}
				} while(g_tree_next_np(tree_pSnrTbl, &iter, &pSnrTblLabel, &pSnrTbl));
				//C`
				if(!strcmp(opt_x, "c")) {
					printf("#define SnrTblNo_Max %d\n", pSnrTbl->iSnrTbl);					//ViIe[u`Ăꍇ̂ݍőlo͂B
				//C#`
				} else if(!strcmp(opt_x, "cs")) {
					printf("public const int SnrTblNo_Max = %d;\n", pSnrTbl->iSnrTbl);			//ViIe[u`Ăꍇ̂ݍőlo͂B
				} else {
					DIE();	//oO
				}
			}
		}
		//gKԍWo͂ɏo͂B
		{
			GTreeIteratorNP iter;
			char* pTrigName;
			int iSnrTrg;
			if(g_tree_first_np(tree_pTrigName_No, &iter, &pTrigName, (void**)&iSnrTrg)) {
				puts("//gK");
				do {
					//C`
					if(!strcmp(opt_x, "c")) {
						printf("#define SnrTrg_%s %d\n", pTrigName, iSnrTrg);
					//C#`
					} else if(!strcmp(opt_x, "cs")) {
						printf("public const int SnrTrg_%s = %d;\n", pTrigName, iSnrTrg);
					} else {
						DIE();	//oO
					}
				} while(g_tree_next_np(tree_pTrigName_No, &iter, &pTrigName, (void**)&iSnrTrg));
				//C`
				if(!strcmp(opt_x, "c")) {
					printf("#define SnrTrg_Max %d\n", iSnrTrg);						//"set""clr"ȊÕgK`Ăꍇ̂ݍőlo͂B
				//C#`
				} else if(!strcmp(opt_x, "cs")) {
					printf("public const int SnrTrg_Max = %d;\n", iSnrTrg);					//"set""clr"ȊÕgK`Ăꍇ̂ݍőlo͂B
				} else {
					DIE();	//oO
				}
			}
		}
		//'-t'IvVw肳Ăc
		if(sTblOut) {
			FILE* fp = fopen(sTblOut, "w");
			if(!fp) { error(EXIT_FAILURE, errno, "%s 쐬ł܂B", sTblOut); }
			{
				GTreeIteratorNP iter;
				char* pFuncName;
				//C`
				if(!strcmp(opt_x, "c")) {
					//֐錾Wo͂ɏo͂B
					puts("//֐");
					if(g_tree_first_np(tree_pFuncName_No, &iter, &pFuncName, NULL)) {
						do {
							printf("#define SnrFnc_%s int SnrFnc_%s(struct _ST_SnrSeq* pSnrSeq, int iCh, int iSnrFnc, struct blob_reader* pArgs)\n", pFuncName, pFuncName);
						} while(g_tree_next_np(tree_pFuncName_No, &iter, &pFuncName, NULL));
						puts("#define SnrFnc_(name) SnrFnc_##name");										//֐`ĂȂ΁ASnrFnc_()}N͒`܂B֐`ĂȂ΁ASnrFnc_()}N̈Ɏw肷֐̂ŁASnrFnc_()}N`ĂʂłB
					}
					puts("#ifdef  __cplusplus");
					puts("extern \"C\" {");
					puts("#endif//__cplusplus");
					puts("struct _ST_SnrSeq;");		//P/ECEJCRpC(GNU C Compiler for E0C33 Ver 2.7.2 (Rev 1.5))ŁAxuwarning: `struct _ST_SnrSeq' declared inside parameter listvô邽߂ɕKvB
					puts("struct blob_reader;");		//P/ECEJCRpC(GNU C Compiler for E0C33 Ver 2.7.2 (Rev 1.5))ŁAxuwarning: `struct blob_reader' declared inside parameter listvô邽߂ɕKvB
					if(g_tree_first_np(tree_pFuncName_No, &iter, &pFuncName, NULL)) {
						do {
							printf("SnrFnc_(%s);\n", pFuncName);
						} while(g_tree_next_np(tree_pFuncName_No, &iter, &pFuncName, NULL));
					}
					puts("extern int (* const TBL_SnrFnc[])(struct _ST_SnrSeq* pSnrSeq, int iCh, int iSnrFnc, struct blob_reader* pArgs);");	//֐`ĂȂĂATBL_SnrFnc[]z͒`܂B֐̐0(=TBL_SnrFnc[]̗vf1)ł鎖AvP[VF邽߂ɁATBL_SnrFnc[]ǂݏoKvL邩łB
					puts("#ifdef  __cplusplus");
					puts("}//extern \"C\"");
					puts("#endif//__cplusplus");
					//֐e[ut@Cɏo͂B
					fprintf(fp, "struct _ST_SnrSeq;\n");	//P/ECEJCRpC(GNU C Compiler for E0C33 Ver 2.7.2 (Rev 1.5))ŁAxuwarning: `struct _ST_SnrSeq' declared inside parameter listvô邽߂ɕKvB
					fprintf(fp, "struct blob_reader;\n");	//P/ECEJCRpC(GNU C Compiler for E0C33 Ver 2.7.2 (Rev 1.5))ŁAxuwarning: `struct blob_reader' declared inside parameter listvô邽߂ɕKvB
					if(g_tree_first_np(tree_pFuncName_No, &iter, &pFuncName, NULL)) {
						do {
							fprintf(fp, "int SnrFnc_%s(struct _ST_SnrSeq* pSnrSeq, int iCh, int iSnrFnc, struct blob_reader* pArgs);\n", pFuncName);
						} while(g_tree_next_np(tree_pFuncName_No, &iter, &pFuncName, NULL));
					}
					fprintf(fp, "int (* const TBL_SnrFnc[])(struct _ST_SnrSeq* pSnrSeq, int iCh, int iSnrFnc, struct blob_reader* pArgs)={(void*)%d", g_tree_nnodes(tree_pFuncName_No) + 1);	//擪vfɊ֐z̗vfi[B
					if(g_tree_first_np(tree_pFuncName_No, &iter, &pFuncName, NULL)) {
						do {
							fprintf(fp, "\n,SnrFnc_%s", pFuncName);
						} while(g_tree_next_np(tree_pFuncName_No, &iter, &pFuncName, NULL));
					}
					fprintf(fp, "};\n");
				//C#`
				} else {
					//֐錾Wo͂ɏo͂B	C#ɂ̓wb_t@Cƃ\[Xt@C𕪗TÔ͖ŁA֐錾Wo͂ɏo͂鏈͕svłB
					/** no job **/
					//֐e[ut@Cɏo͂B
					error(EXIT_FAILURE, errno, "'-t'IvV'-xcs'IvV̕p͖łB");	//TODO:
				}
			}
			fclose(fp);
		//'-t'IvVw肳ĂȂ΁c
		} else {
			//֐ԍWo͂ɏo͂B
			{
				GTreeIteratorNP iter;
				char* pFuncName;
				int iSnrFnc;
				if(g_tree_first_np(tree_pFuncName_No, &iter, &pFuncName, (void**)&iSnrFnc)) {
					puts("//֐");
					do {
						//C`
						if(!strcmp(opt_x, "c")) {
							printf("#define SnrFnc_%s %d\n", pFuncName, iSnrFnc);
						//C#`
						} else if(!strcmp(opt_x, "cs")) {
							printf("public const int SnrFnc_%s = %d;\n", pFuncName, iSnrFnc);
						} else {
							DIE();	//oO
						}
					} while(g_tree_next_np(tree_pFuncName_No, &iter, &pFuncName, (void**)&iSnrFnc));
					//C`
					if(!strcmp(opt_x, "c")) {
						printf("#define SnrFnc_Max %d\n", iSnrFnc);						//֐`Ăꍇ̂ݍőlo͂B
					//C#`
					} else if(!strcmp(opt_x, "cs")) {
						printf("public const int SnrFnc_Max = %d;\n", iSnrFnc);					//֐`Ăꍇ̂ݍőlo͂B
					} else {
						DIE();	//oO
					}
				}
			}
		}
		//C#`
		if(!strcmp(opt_x, "cs")) {
			puts("}");
		}
	}
	//f[^o͂B
	{
		GByteArray* pLabTblArr;
		GArray*     pAddrTbl;
		GByteArray* pCodeArr;
		//oCi`ƃeLXg`̋ʏc
		{
			//xe[u̔z쐬B
			{
				pLabTblArr = g_byte_array_new();
				//ViIe[u
				{
					if(bLabTbl) {					//xe[ui[Ȃ΁c
						GTreeIteratorNP iter;
						char* pSnrTblLabel;
						if(g_tree_first_np(tree_pSnrTbl, &iter, &pSnrTblLabel, NULL)) {
							do {
								g_byte_array_append(pLabTblArr, pSnrTblLabel, strlen(pSnrTblLabel) + 1/*nul*/);
							} while(g_tree_next_np(tree_pSnrTbl, &iter, &pSnrTblLabel, NULL));
						}
					}
					g_byte_array_append(pLabTblArr, "", 1/*nul*/);	//xe[ui[ȂꍇI[nul͊i[鎖ɂBAvP[V̊ϓ_͋̃xe[uƂȂ\͓ƌȂăAvP[VՂȂ邩B(nul~3+pfBO)4oCg̃I[o[wbh邪薳낤B
				}
				//gK
				{
					if(bLabTbl) {					//xe[ui[Ȃ΁c
						GTreeIteratorNP iter;
						char* pTrigName;
						if(g_tree_first_np(tree_pTrigName_No, &iter, &pTrigName, NULL)) {
							do {
								g_byte_array_append(pLabTblArr, pTrigName, strlen(pTrigName) + 1/*nul*/);
							} while(g_tree_next_np(tree_pTrigName_No, &iter, &pTrigName, NULL));
						}
					}
					g_byte_array_append(pLabTblArr, "", 1/*nul*/);	//xe[ui[ȂꍇI[nul͊i[鎖ɂBAvP[V̊ϓ_͋̃xe[uƂȂ\͓ƌȂăAvP[VՂȂ邩B(nul~3+pfBO)4oCg̃I[o[wbh邪薳낤B
				}
				//֐
				{
					if(bLabTbl) {					//xe[ui[Ȃ΁c
						GTreeIteratorNP iter;
						char* pFuncName;
						if(g_tree_first_np(tree_pFuncName_No, &iter, &pFuncName, NULL)) {
							do {
								g_byte_array_append(pLabTblArr, pFuncName, strlen(pFuncName) + 1/*nul*/);
							} while(g_tree_next_np(tree_pFuncName_No, &iter, &pFuncName, NULL));
						}
					}
					g_byte_array_append(pLabTblArr, "", 1/*nul*/);	//xe[ui[ȂꍇI[nul͊i[鎖ɂBAvP[V̊ϓ_͋̃xe[uƂȂ\͓ƌȂăAvP[VՂȂ邩B(nul~3+pfBO)4oCg̃I[o[wbh邪薳낤B
				}
				//߃R[ḧXg̒l̕4NEւ̐́A߃R[h̐擪ɂčsĂ̂ŁA߃R[h̐擪4Nɐ񂵂ĂKvLB
				//]āAxe[u̔z̃TCY4N܂ŃpfBOB
				while(pLabTblArr->len & 3) { g_byte_array_append(pLabTblArr, "", 1/*nul*/); }
			}
			//AhXe[u̔z쐬B
			{
				pAddrTbl = g_array_new(1, 1, sizeof(int));
				{
					GTreeIteratorNP iter;
					ST_SnrTbl* pSnrTbl;
					int value = g_tree_nnodes(tree_pSnrTbl) + 1;	//TBL_SnrTblNo[0]=(SnrTblNo_Max+1)	x1x[XȂ̂+1鎖ɒӂB
					g_array_append_val(pAddrTbl, value);
					if(g_tree_first_np(tree_pSnrTbl, &iter, NULL, &pSnrTbl)) {
						do {
							ST_Code* pSnrTblBodyCode = g_tree_lookup(tree_pSnrTblBody_Code, pSnrTbl->pSnrTblBody);
							if(!pSnrTblBodyCode) { DIE(); }	//Œ~瓖c[̃oOłB
							value = pLabTblArr->len + pSnrTblBodyCode->addr;
							g_array_append_val(pAddrTbl, value);
						} while(g_tree_next_np(tree_pSnrTbl, &iter, NULL, &pSnrTbl));
					}
				}
			}
			//߃R[h̔z쐬B
			{
				pCodeArr = g_byte_array_new();
				//ViIe[u{fB
				{
					GTreeIteratorNP iter;
					ST_SnrTblBody* pSnrTblBody;
					if(g_tree_first_np(tree_pSnrTblBody, &iter, &pSnrTblBody, NULL)) {
						do {
							ST_Code* pSnrTblBodyCode;
							if(!(pSnrTblBodyCode = g_tree_lookup(tree_pSnrTblBody_Code, pSnrTblBody))) { DIE(); }	//Œ~瓖c[̃oOłB
							if(pCodeArr->len != pSnrTblBodyCode->addr) { DIE(); }	//Œ~瓖c[̃oOłB
							g_byte_array_append(pCodeArr, pSnrTblBodyCode->code->data, pSnrTblBodyCode->code->len);
						} while(g_tree_next_np(tree_pSnrTblBody, &iter, &pSnrTblBody, NULL));
					}
				}
				//ViIV[PX{fB
				{
					GTreeIteratorNP iter;
					ST_SnrSeqBody* pSnrSeqBody;
					if(g_tree_first_np(tree_pSnrSeqBody_Used, &iter, &pSnrSeqBody, NULL)) {
						do {
							ST_Code* pSnrSeqBodyCode;
							if(!(pSnrSeqBodyCode = g_tree_lookup(tree_pSnrSeqBody_Code, pSnrSeqBody))) { DIE(); }	//Œ~瓖c[̃oOłB
							if(pCodeArr->len != pSnrSeqBodyCode->addr) { DIE(); }	//Œ~瓖c[̃oOłB
							g_byte_array_append(pCodeArr, pSnrSeqBodyCode->code->data, pSnrSeqBodyCode->code->len);
						} while(g_tree_next_np(tree_pSnrSeqBody_Used, &iter, &pSnrSeqBody, NULL));
					}
				}
				//Xg
				{
					GTreeIteratorNP iter;
					ST_Args* pArgs;
					if(g_tree_first_np(tree_pArgs_Used, &iter, &pArgs, NULL)) {
						do {
							ST_Code* pArgsCode;
							if(!(pArgsCode = g_tree_lookup(tree_pArgs_Code, pArgs))) { DIE(); }	//Œ~瓖c[̃oOłB
							{ static const unsigned char padding[3]; g_byte_array_append(pCodeArr, padding, ~pCodeArr->len & 3); }	//yӁzXg̒l̕4NEɐ񂷂邽߂ɁATCY̕(4N+3)Ɋi[悤ɃpfBOB
							if(pCodeArr->len != pArgsCode->addr) { DIE(); }	//Œ~瓖c[̃oOłB
							g_byte_array_append(pCodeArr, pArgsCode->code->data, pArgsCode->code->len);
						} while(g_tree_next_np(tree_pArgs_Used, &iter, &pArgs, NULL));
					}
				}
				if(pCodeArr->len != endAddr) { DIE(); }	//Œ~瓖c[̃oOłB
			}
		}
		//oCi`̏ꍇc
		if(sBinOut) {
			FILE* fp = fopen(sBinOut, "wb");
			if(!fp) { error(EXIT_FAILURE, errno, "%s 쐬ł܂B", sBinOut); }
			//AhXe[uo͂B
			{
				fwrite(pAddrTbl->data, sizeof(int), pAddrTbl->len, fp);
			}
			//xe[uo͂B
			{
				fwrite(pLabTblArr->data, 1, pLabTblArr->len, fp);
			}
			//߃R[ho͂B
			{
				fwrite(pCodeArr->data, 1, pCodeArr->len, fp);
			}
			fclose(fp);
		//eLXg`̏ꍇc
		} else {
			//C#`
			if(!strcmp(opt_x, "cs")) {
				puts("static partial class Const {");
			}
			//AhXe[uo͂B
			{
				//C`
				if(!strcmp(opt_x, "c")) {
					printf("const int TBL_SnrTblNo[%d]={", pAddrTbl->len);
				//C#`
				} else if(!strcmp(opt_x, "cs")) {
					printf("public static readonly int[/*%d*/] TBL_SnrTblNo={", pAddrTbl->len);
				} else {
					DIE();	//oO
				}
				{
					int i;
					for(i = 0; i < pAddrTbl->len; i++) {
						if(!(i & 15)) { putchar('\n'); }
						printf("0x%08X", g_array_index(pAddrTbl, int, i));
						if(i != (pAddrTbl->len - 1)) { putchar(','); }
					}
				}
				puts("};");
			}
			//xe[uƖ߃R[ho͂B
			{
				//C`
				if(!strcmp(opt_x, "c")) {
					printf("const unsigned char TBL_SnrSeq[%d+%d]={", pLabTblArr->len, endAddr);
				//C#`
				} else if(!strcmp(opt_x, "cs")) {
					printf("public static readonly byte[/*%d+%d*/] TBL_SnrSeq={", pLabTblArr->len, endAddr);
				} else {
					DIE();	//oO
				}
				{
					int i;
					if(!pLabTblArr->len) { DIE(); }	//oO
					for(i = 0; i < pLabTblArr->len; i++) {
						if(!(i & 31)) { putchar('\n'); }
						printf("0x%02X", pLabTblArr->data[i]);
						if(i != (pLabTblArr->len - 1)) { putchar(','); }
					}
					if(pCodeArr->len) { putchar(','); }
					for(i = 0; i < pCodeArr->len; i++) {
						if(!(i & 31)) { putchar('\n'); }
						printf("0x%02X", pCodeArr->data[i]);
						if(i != (pCodeArr->len - 1)) { putchar(','); }
					}
				}
				puts("};");
			}
			//C#`
			if(!strcmp(opt_x, "cs")) {
				puts("}");
			}
		}
	}
}
