#include "app.h"
/****************************************************************************
 *	
 ****************************************************************************/
__declspec(noreturn) static void usage();
static void dumpKeyBody(int indent, const unsigned char* keyBody);
static void printIndent(int indent, const char* fmt, ...);
static void printIndent_nonewline(int indent, const char* fmt, ...);
//{{2017/09/16ǉ:xe[uɑΉ܂B
static char* getLabelSymbol(int nameOrValue);
//}}2017/09/16ǉ:xe[uɑΉ܂B
/****************************************************************************
 *	
 ****************************************************************************/
//{{2017/09/16ǉ:xe[uɑΉ܂B
static ght_hash_table_t* ht_labTbl;	//ux̐l˃x̖́v
//}}2017/09/16ǉ:xe[uɑΉ܂B
/****************************************************************************
 *	
 ****************************************************************************/
int main(int argc, char* argv[]) {
//{{2017/09/16ǉ:xe[uɑΉ܂B
	int opt_l = 0;	//0=x𐔒lŕ\B1=x𖼏̂ŕ\B
	int opt_t = 0;	//0=WXge[u_vB1=xe[u_vB
//}}2017/09/16ǉ:xe[uɑΉ܂B
	FILE* fp;
	void* buf;
	int opt, len;
	//R}hCIvVB
	opterr = 0; //IvVG[͓vOŏ̂ŁAgetopt()ł̃G[\͕svB
	while((opt = getopt(argc, argv, "lth")) != -1) {
		switch(opt) {
//{{2017/09/16ǉ:xe[uɑΉ܂B
		case 'l':
			if(opt_t) { usage(); }	//'-l'IvV'-t'IvV͕psB
			opt_l = 1;	//x𖼏̂ŕ\B
			break;
		case 't':
			if(opt_l) { usage(); }	//'-l'IvV'-t'IvV͕psB
			opt_t = 1;	//xe[u_vB
			break;
//}}2017/09/16ǉ:xe[uɑΉ܂B
		case 'h':
		default:
			usage();
		}
	}
	//WXge[ũoCif[^ǂݍށB
	if(optind != (argc - 1)) { usage(); }	//̐s
	fp = fopen(argv[optind], "rb");
//{{2016/05/28ǉ:t@CI[vG[YĂoOC܂B
	if(!fp) { error(EXIT_FAILURE, errno, "%s J܂B", argv[optind]); }
//}}2016/05/28ǉ:t@CI[vG[YĂoOC܂B
	fseek(fp, 0, SEEK_END);
	len = ftell(fp);
	rewind(fp);
	buf = malloc(len);
	if(!buf) { DIE(); }	//s
	fread(buf, 1, len, fp);
	fclose(fp);
//{{2017/09/16ǉ:xe[uɑΉ܂B
	//xe[u̗Lɂ炸Aux̐l˃x̖́v쐬B
	// - '-l'IvVw肳ĂȂ΋̂܂܂ƂȂAʓIɁAx𐔒lŕ\铮ƂȂ܂B
	//   ܂A'-t'IvVw肳Ăꍇ́AgpȂ̂ŖʂłA͖L܂B
	ght_set_rehash((ht_labTbl = ght_create(0)), 1);
	//'-l'IvV,,'-t'IvVw肳Ăc
	if(opt_l || opt_t) {
		//xe[u擾B
		// - xe[ui[ĂȂꍇ͖̓`łB
		//   炭Ac[ُI邩AsȌʂo͂܂B
		//   xe[ui[Ă邩𖾎Iɔf@̂ŁAނ܂B
		const unsigned char* labelTable = REG_get_label_table(buf);
	    //{{͈͕̔͂̏K{ł͂܂B
		{
			//Łuxe[ui[Ă邩𖾎Iɔf@vƏ܂Aꂾł͂܂Ȃ̂ŁAŔf鎖ɂ܂B
			//labelTable{Ƀxe[ułȂ΁c
			const unsigned char* keyBody = labelTable;
			int mask, n, dist;
			//maskǂݏo͂łB
			if((keyBody < (char*)buf) || ((keyBody + 1) > ((char*)buf + len))) { error(EXIT_FAILURE, 0, "xe[ui[Ă܂B"); }
			mask = *keyBody++;
			//xe[u͕0ȏ܂ł邾ŁAL[lBLOB܂łȂ͂łBAmask(1<<6)0ł͂łB		2017/09/16݂͐̒ʂȂ̂łAAドxe[u̍\ĕύXĕȊO܂߂悤ɂꍇ́A̍s͕̏ύXKvL鎖ɒӂĉB
			if(mask & ~(1<<5)) { error(EXIT_FAILURE, 0, "xe[ui[Ă܂B"); }
			//xe[u͕1ȏ܂łȂ΁c
			if(mask == (1<<5)) {
				//̗vfǂݏo͂łB
				if((keyBody < (char*)buf) || ((keyBody + 2) > ((char*)buf + len))) { error(EXIT_FAILURE, 0, "xe[ui[Ă܂B"); }
				n        =         *keyBody++;
				n      <<= 8;
				n       |=         *keyBody++;
				n++; //(vf-1)˗vfɕϊB
				keyBody += n * (2/*name*/+3/*data*/);
				//xe[ũwb_̌ɁAxe[ugւ̑΋i[Ă͂łB
				if((keyBody < (char*)buf) || ((keyBody + 3) > ((char*)buf + len))) { error(EXIT_FAILURE, 0, "xe[ui[Ă܂B"); }
				dist     = (int8_t)*keyBody++;
				dist   <<= 8;
				dist    |=         *keyBody++;
				dist   <<= 8;
				dist    |=         *keyBody++;
				keyBody += dist;
				if(keyBody != labelTable) { error(EXIT_FAILURE, 0, "xe[ui[Ă܂B"); }
			}
		}
	    //}}͈͕̔͂̏K{ł͂܂B
		//'-t'IvVw肳Ăc
		if(opt_t) {
			//xe[u_vB
			dumpKeyBody(0, labelTable);
			return EXIT_SUCCESS;	//܂
		}
		//ɁAux̐l˃x̖́vo^B
		{
			int i, labelName;
			const char* labelSymbol;
			for(i = 0; (labelSymbol = REG_get_nth_string(labelTable, i, &labelName)) != NULL; i++) {
				if(!iscsymf(labelSymbol[0])) { labelSymbol = strconcat("`", labelSymbol, NULL); }	//ꕶڂCV{̐擪łȂ΁u`vt^BWXgXNvg̏łB
				if(ght_insert(ht_labTbl, (void*)labelSymbol, sizeof(int), &labelName)) { DIE(); }
			}
		}
	}
//}}2017/09/16ǉ:xe[uɑΉ܂B
	//WXge[u_vB
	dumpKeyBody(0, buf);
	return EXIT_SUCCESS;
}
/*---------------------------------------------------------------------------*/
__declspec(noreturn) static void usage() {
	fprintf(stderr, "dRegTblD - WXge[utRpC (%s)\n", VERSION);
	fprintf(stderr, "Copyright (C) 2015-2018 Naoyuki Sawa\n");
	fprintf(stderr, "\n");
	fprintf(stderr, "USAGE:\n");
	fprintf(stderr, "  dRegTblD [option] RegTbl.bin\n");
	fprintf(stderr, "\n");
	fprintf(stderr, "OPTIONS:\n");
//{{2017/09/16ǉ:xe[uɑΉ܂B
	fprintf(stderr, "  -l  x𖼏̂ŕ\܂B\n");
	fprintf(stderr, "      ̃IvVw肵Ȃ΁Ax𐔒lŕ\܂B\n");
	fprintf(stderr, "      '-t'IvVƓɎw肷鎖͏o܂B\n");
	fprintf(stderr, "  -t  xe[u_v܂B\n");
	fprintf(stderr, "      ̃IvVw肵Ȃ΁AWXge[u_v܂B\n");
	fprintf(stderr, "      '-l'IvVƓɎw肷鎖͏o܂B\n");
//}}2017/09/16ǉ:xe[uɑΉ܂B
	fprintf(stderr, "  -h  g\܂B\n");
//}}2017/09/16ǉ:xe[uɑΉ܂B
	fprintf(stderr, "\n");
	fprintf(stderr, "NOTE:\n");
	fprintf(stderr, "  Exe[ui[ĂȂWXgf[^ɑ΂āA'-l',,'-t'w肵Ă͂܂B\n");
	fprintf(stderr, "    Aꍇ͖̓`łAc[NbVAԈʂ\܂B\n");
	fprintf(stderr, "  Exe[uɃWXgf[^i[ɂ́AdRegTblC.exe'-l'IvVw肵ĉB\n");
//{{2017/09/16ǉ:xe[uɑΉ܂B
	exit(EXIT_FAILURE);
}
/*--------------------------------------------------------------------------*/
static void dumpKeyBody(int indent, const unsigned char* keyBody) {
//{{2018/04/12ǉ:̃L[_v鎞ɁAuprevent-deletionvo͂悤ɂ܂B
	if(!REG_num_key(keyBody) &&
	   !REG_num_value(keyBody) &&
	   !REG_num_string(keyBody) &&
	   !REG_num_blob(keyBody)) {
		printIndent(indent, "prevent-deletion");
		return;	//܂
	}
//}}2018/04/12ǉ:̃L[_v鎞ɁAuprevent-deletionvo͂悤ɂ܂B
	//--- L[ ---
	{
		const unsigned char* keyBody2;
		int index, keyName;
		for(index = 0;
		   (keyBody2 = REG_open_nth_key(keyBody, index, &keyName)) != NULL;
		    index++) {
//{{2017/09/16ύX:xe[uɑΉ܂B
//			printIndent(indent, "%u", keyName);
//2017/09/16ύX:xe[uɑΉ܂B
			printIndent(indent, "%s", getLabelSymbol(keyName));
//}}2017/09/16ύX:xe[uɑΉ܂B
			dumpKeyBody(indent + 1, keyBody2);
			printIndent(indent, "end");
		}
	}
	//--- l ---
	{
		int index, valueName, valueData;
		for(index = 0;
		   (valueData = REG_get_nth_value(keyBody, index, &valueName)) != -1;
		    index++) {
//{{2017/09/16ύX:xe[uɑΉ܂B
//			printIndent(indent, "%u\t= %u", valueName, valueData);
//2017/09/16ύX:xe[uɑΉ܂B
			printIndent(indent, "%s\t= %s", getLabelSymbol(valueName), getLabelSymbol(valueData));
//}}2017/09/16ύX:xe[uɑΉ܂B
		}
	}
	//---  ---
	{
		const char* stringData;
		int index, stringName;
		for(index = 0;
		   (stringData = REG_get_nth_string(keyBody, index, &stringName)) != NULL;
		    index++) {
//{{2017/09/16ύX:xe[uɑΉ܂B
//			printIndent(indent, "%u\t= \"%s\"", stringName, stringData);
//2017/09/16ύX:xe[uɑΉ܂B
			printIndent(indent, "%s\t= \"%s\"", getLabelSymbol(stringName), stringData);
//}}2017/09/16ύX:xe[uɑΉ܂B
		}
	}
	//--- BLOB ---
	{
		const uint8_t* blobData;
		int index, blobName, blobSize, i;
		for(index = 0;
		   (blobData = REG_get_nth_blob(keyBody, index, &blobName)) != NULL;
		    index++) {
//{{2017/09/16ύX:xe[uɑΉ܂B
//			printIndent_nonewline(indent, "%u\t= {", blobName);
//2017/09/16ύX:xe[uɑΉ܂B
			printIndent_nonewline(indent, "%s\t= {", getLabelSymbol(blobName));
//}}2017/09/16ύX:xe[uɑΉ܂B
			blobSize = REG_get_blob_size(blobData);
			for(i = 0; i < blobSize; i++) {
				printf("0x%02X", blobData[i]);
				if(i < (blobSize - 1)) {
					putchar(',');
					if((i & 15) == 15) {	//BLOB͈s16oCgŉs鎖ɂ܂BύXĂ\܂B
						putchar('\n');
						printIndent_nonewline(indent, "\t   ");
					}
				}
			}
			printf("}\n");
		}
	}
}
/*--------------------------------------------------------------------------*/
static void printIndent(int indent, const char* fmt, ...) {
	va_list ap;
	while(--indent >= 0) { putchar('\t'); }
	va_start(ap, fmt);
	vprintf(fmt, ap);
	va_end(ap);
	putchar('\n');
}
static void printIndent_nonewline(int indent, const char* fmt, ...) {
	va_list ap;
	while(--indent >= 0) { putchar('\t'); }
	va_start(ap, fmt);
	vprintf(fmt, ap);
	va_end(ap);
}
/*--------------------------------------------------------------------------*/
//{{2017/09/16ǉ:xe[uɑΉ܂B
static char* getLabelSymbol(int nameOrValue) {
	//xȂ΁Ax̖̂Ԃ܂B(ꕶڂCV{̐擪łȂ΁u`vt^鏈́Aɓo^ɍsĂ̂łł͕svłB)
	//xłȂ΁Al𕶎ɂĕԂ܂B
	// - xe[uɓo^Ă鐔lȂ΃xłAxe[uɓo^ĂȂlȂ΃xł͂ȂƔfo܂B
	//   ȂȂAx̐lɂ́Af[^ƂĎgpĂȂl蓖ĂĂ邩łB
	//   ڍׂ́A/clip/tool/dRegTblC/winapp.cresolveLabel()́AuIȐlƂĎgpȂlxɊ蓖ĂṽRgQƂĉB
	char* label = ght_get(ht_labTbl, sizeof(int), &nameOrValue);
	if(!label) { label = strdup_printf("%u", nameOrValue); }
	return label;
}
//}}2017/09/16ǉ:xe[uɑΉ܂B
