#include "app.h"
/****************************************************************************
 *	
 ****************************************************************************/
__declspec(noreturn) static void usage();
/****************************************************************************
 *	
 ****************************************************************************/
int main(int argc, char* argv[]) {
	int opt_w = 80;
	{
		int opt;
		char* endptr;
		opterr = 0; //IvVG[͓vOŏ̂ŁAgetopt()ł̃G[\͕svB
		while((opt = getopt(argc, argv, "w:h")) != -1) {	//R}hCIvVB
			switch(opt) {
//{{AvP[VL̏
			case 'w':
				opt_w = strtoul(optarg, &endptr, 0);
				if(!opt_w || *endptr) { usage(); }
				break;
//}}AvP[VL̏
			case 'h':
			default:
				usage();
			}
		}
	}
	{
		char* glbuf = NULL;	//getline()pobt@
		int   glcap = 0;	//
		FILE* fp = stdin;	//̓t@Cw肳ĂȂ΁AW͂񏈗B
		do {
			if(optind < argc) {	//̓t@Cw肳Ăc
				fp = fopen(argv[optind], "r");		//̓t@CJB
				if(!fp) { error(EXIT_FAILURE, errno, "%s J܂B", argv[optind]); }
			}
			while(getline(&glbuf, &glcap, fp) != EOF) {	//sǂݍށBt@CI[łȂ΁c
//{{AvP[VL̏
				char** v = textwrap(strchomp(glbuf), opt_w);
				int i;		//  ~~~~~~~~܂ԂOɁẢs폜Btextwrap()͐R[hFȂ̂ŁAtextwrap()ɓnOɉs폜ĂKvLB
				for(i = 0; v[i]; i++) {
					puts(v[i]);
				}
				strfreev(v);
//}}AvP[VL̏
			}
			if(optind < argc) {	//̓t@Cw肳Ăc
				fclose(fp);	//̓t@CB
				optind++;	//̓̓t@C֐i߂B
			}
		} while(optind < argc);
		free(glbuf);	//getline()pobt@JB
	}
	return EXIT_SUCCESS;
}
/*---------------------------------------------------------------------------*/
__declspec(noreturn) static void usage() {
	fprintf(stderr, "TextWrap - VtgJIS܂Ԃc[ (%s)\n", VERSION);
	fprintf(stderr, "Copyright (C) 2016-2018 Naoyuki Sawa\n");
	fprintf(stderr, "\n");
	fprintf(stderr, "USAGE:\n");
	fprintf(stderr, "  TextWrap.exe [option] [filename ...]\n");
	fprintf(stderr, "  Efilenamew肵Ȃ΁AW͂ǂݍ݂܂B\n");
	fprintf(stderr, "  EfilenaméAChJ[hɂ镡w\łB\n");
	fprintf(stderr, "\n");
	fprintf(stderr, "OPTIONS:\n");
	fprintf(stderr, "  -w 1s̍őoCgw肵܂B\n");
	fprintf(stderr, "     ̃IvVw肵Ȃ΁A80oCgƂȂ܂B\n");
	fprintf(stderr, "  -h g\܂B\n");
	fprintf(stderr, "\n");
	fprintf(stderr, "EXAMPLE:\n");
	fprintf(stderr, "  C:\\UnxUtils\\usr\\local\\wbin\\expand.exe Sample.txt | TextWrap.exe -w76\n");
	fprintf(stderr, "    Sample.txtA1s̍ő76oCgŐ܂Ԃĕ\܂B\n");
	fprintf(stderr, "    TextWrap.exe̓^uWJȂ̂ŁAexpand.exeʂĂ܂B\n");
	fprintf(stderr, "\n");
	fprintf(stderr, "NOTE:\n");
	fprintf(stderr, "  c[̋@\́AUnixfoldR}hAnkf.exe'-f'IvVƓłB\n");
	fprintf(stderr, "  foldnkf.exe̕@\Ȃ̂ŁAēc[gpKv͗L܂B\n");
	fprintf(stderr, "  c[쐬ړÍAclipstr.cW[textwrap()̌؂̂߂łB\n");
	exit(EXIT_FAILURE);
}
