//	
//	DumpXlsx.cs
//	
//	DumpXlsx.exe - xlsx/xlsmファイルのシートデータをダンプするツール(.NET版)
//	Copyright (C) 2016-2018 Naoyuki Sawa
//	
//	* Sun Jul 17 21:03:07 JST 2016 Naoyuki Sawa
//	- 1st リリース。
//	  使用したツールは、以下の通りです:
//	  ・Microsoft Visual Studio Community 2015 Version 14.0.25123.00 Update 2
//	  ・Microsoft .NET Framework Version 4.6.01038
//	  ・Open XML SDK 2.5 (https://www.microsoft.com/en-us/download/details.aspx?id=30425)	┬Yahoo!ボックスの、/マイボックス/書類/archive/Tool/Office/OpenXML/ に保存しておきました。
//	  ・ClosedXML 0.76.0 (https://closedxml.codeplex.com/)					┘
//	  Open XML SDKは、上記からダウンロードしたインストーラでインストールしました。特に設定は行っていません。多分、Open XML SDKのインストーラがGACに登録する(?)か何かの設定を行ってくれているのだと思います。もしOpen XML SDKをインストールしていないPCでDumpXlsx.exeを実行する時は、C:\Program Files (x86)\Open XML SDK\V2.5\lib\DocumentFormat.OpenXml.dll も同じフォルダにコピーする必要が有るかも知れません。
//	  ClosedXMLは、インストーラは無いので、上記からダウンロードしたClosedXML.dllとClosedXML.XMLをC:/Home/Share/Piece/clip/tool/にコピーしました。他のPCでDumpXlsx.exeを実行する時は、ClosedXML.dllも同じフォルダにコピーする必要が有ると思います。
//	  VC++2015の参照設定に追加したdllは、ClosedXML.dllのみです。DocumentFormat.OpenXml.dllを明示的に参照設定に追加する必要は有りませんでした。
//	- 先日、同じ目的のツールをTclとtDOMで作成したのですが、当ツールで置き換える事にしました。
//	  TclとtDOMでXMLを直接パースするよりも、Open XML SDKとClosedXMLを使う方が確実だからです。
//	  実際に、前者の方法では稀に上手くパース出来ないxlsxが有ったのですが、後者の方法ならばパース出来るようになりました。
//	  尚、TclとtDOM版のツールはもう使いませんが、今後tDOMを使う時の参考のために、/clip/tool/フォルダ直下から、/clip/tool/DumpXlsx/old/サブフォルダへ移動して保存しておく事にしました。
//	* Sat Sep 24 21:37:23 JST 2016 Naoyuki Sawa
//	- '-c'オプションを追加しました。
//	  これまでは、当ツールが無条件に行コメントを削除していましたが、今後は、'-c'オプションが指定された場合のみ行コメントを削除するように変更しました。
//	  デフォルトの挙動を変えた理由は、垂直コメントの仕様として、行コメント内のセルに意味を持たせる仕様を追加した事に伴い、当ツールの段階で行コメントを削除しない方が望ましいからです。
//	  (詳細は、/clip/tool/DeleteVerticalComment.awkを参照して下さい。)
//	  だたし、垂直コメントの書式を使用しない事が判っている場合は、当ツールが行コメントを削除しても問題無いので、'-c'オプションとして行コメントを削除する機能も残す事にしました。
//	* Sun Apr 09 22:05:18 JST 2017 Naoyuki Sawa
//	- コンパイラを、VS2015⇒VS2017に更新しました。
//	  当ツールは.NETプロジェクトなので、自動変換すら無しで(/clip/libclip.x64/keep/README.TXTの同日のコメントを参照して下さい)、リビルドするだけでVS2015⇒VS2017へ移行出来ました。
//	* Tue Apr 18 21:46:46 JST 2017 Naoyuki Sawa
//	- Visual Studio 2017をバージョンアップした事に伴い、当モジュールもリビルドしました。
//	  当モジュールのソースコードには変更有りません。
//	- 使用したコンパイラとライブラリは、以下の通りです。
//	  │Microsoft Visual Studio Community 2017 Version 15.1 (26403.7) Release	←バージョンアップ
//	  │Open XML SDK 2.5								←前回と同じ
//	  │ClosedXML 0.76.0								←前回と同じ
//	* Thu May 11 22:16:11 JST 2017 Naoyuki Sawa
//	- Visual Studio 2017をバージョンアップした事に伴い、当モジュールもリビルドしました。
//	  当モジュールのソースコードには変更有りません。
//	- 使用したコンパイラとライブラリは、以下の通りです。
//	  │Microsoft Visual Studio Community 2017 Version 15.2 (26430.4) Release	←バージョンアップ
//	  │Open XML SDK 2.5								←前回と同じ
//	  │ClosedXML 0.76.0								←前回と同じ
//	* Sun May 14 23:23:22 JST 2017 Naoyuki Sawa
//	- Visual Studio 2017をバージョンアップした事に伴い、当モジュールもリビルドしました。
//	  当モジュールのソースコードには変更有りません。
//	- 使用したコンパイラとライブラリは、以下の通りです。
//	  │Microsoft Visual Studio Community 2017 Version 15.2 (26430.6) Release	←バージョンアップ
//	  │Open XML SDK 2.5								←前回と同じ
//	  │ClosedXML 0.76.0								←前回と同じ
//	* Wed May 31 23:20:14 JST 2017 Naoyuki Sawa
//	- Visual Studio 2017をバージョンアップした事に伴い、当モジュールもリビルドしました。
//	  当モジュールのソースコードには変更有りません。
//	- 使用したコンパイラとライブラリは、以下の通りです。
//	  │Microsoft Visual Studio Community 2017 Version 15.2 (26430.12) Release	←バージョンアップ
//	  │Open XML SDK 2.5								←前回と同じ
//	  │ClosedXML 0.76.0								←前回と同じ
//	* Thu Jun 15 22:19:44 JST 2017 Naoyuki Sawa
//	- Visual Studio 2017をバージョンアップした事に伴い、当モジュールもリビルドしました。
//	  当モジュールのソースコードには変更有りません。
//	- 使用したコンパイラとライブラリは、以下の通りです。
//	  │Microsoft Visual Studio Community 2017 Version 15.2 (26430.13) Release	←バージョンアップ
//	  │Open XML SDK 2.5								←前回と同じ
//	  │ClosedXML 0.76.0								←前回と同じ
//	* Thu Jun 22 22:38:07 JST 2017 Naoyuki Sawa
//	- Visual Studio 2017をバージョンアップした事に伴い、当モジュールもリビルドしました。
//	  当モジュールのソースコードには変更有りません。
//	- 使用したコンパイラとライブラリは、以下の通りです。
//	  │Microsoft Visual Studio Community 2017 Version 15.2 (26430.14) Release	←バージョンアップ
//	  │Open XML SDK 2.5								←前回と同じ
//	  │ClosedXML 0.76.0								←前回と同じ
//	* Sat Jul 08 21:16:30 JST 2017 Naoyuki Sawa
//	- Visual Studio 2017をバージョンアップした事に伴い、当モジュールもリビルドしました。
//	  当モジュールのソースコードには変更有りません。
//	- 使用したコンパイラとライブラリは、以下の通りです。
//	  │Microsoft Visual Studio Community 2017 Version 15.2 (26430.15) Release	←バージョンアップ
//	  │Open XML SDK 2.5								←前回と同じ
//	  │ClosedXML 0.76.0								←前回と同じ
//	* Tue Jul 18 21:42:10 JST 2017 Naoyuki Sawa
//	- Visual Studio 2017をバージョンアップした事に伴い、当モジュールもリビルドしました。
//	  当モジュールのソースコードには変更有りません。
//	- 使用したコンパイラとライブラリは、以下の通りです。
//	  │Microsoft Visual Studio Community 2017 Version 15.2 (26430.16) Release	←バージョンアップ
//	  │Open XML SDK 2.5								←前回と同じ
//	  │ClosedXML 0.76.0								←前回と同じ
//	* Thu Aug 17 23:46:06 JST 2017 Naoyuki Sawa
//	- Visual Studio 2017をバージョンアップした事に伴い、当モジュールもリビルドしました。
//	  当モジュールのソースコードには変更有りません。
//	- 使用したコンパイラとライブラリは、以下の通りです。
//	  │Microsoft Visual Studio Community 2017 Version 15.3.0			←バージョンアップ
//	  │Open XML SDK 2.5								←前回と同じ
//	  │ClosedXML 0.76.0								←前回と同じ
//	* Sat Aug 19 22:58:59 JST 2017 Naoyuki Sawa
//	- Visual Studio 2017をバージョンアップした事に伴い、当モジュールもリビルドしました。
//	  当モジュールのソースコードには変更有りません。
//	- 使用したコンパイラとライブラリは、以下の通りです。
//	  │Microsoft Visual Studio Community 2017 Version 15.3.1			←バージョンアップ
//	  │Open XML SDK 2.5								←前回と同じ
//	  │ClosedXML 0.76.0								←前回と同じ
//	* Wed Aug 23 21:05:20 JST 2017 Naoyuki Sawa
//	- Visual Studio 2017をバージョンアップした事に伴い、当モジュールもリビルドしました。
//	  当モジュールのソースコードには変更有りません。
//	- 使用したコンパイラとライブラリは、以下の通りです。
//	  │Microsoft Visual Studio Community 2017 Version 15.3.2			←バージョンアップ
//	  │Open XML SDK 2.5								←前回と同じ
//	  │ClosedXML 0.76.0								←前回と同じ
//	* Thu Aug 31 23:31:07 JST 2017 Naoyuki Sawa
//	- Visual Studio 2017をバージョンアップした事に伴い、当モジュールもリビルドしました。
//	  当モジュールのソースコードには変更有りません。
//	- 使用したコンパイラとライブラリは、以下の通りです。
//	  │Microsoft Visual Studio Community 2017 Version 15.3.3			←バージョンアップ
//	  │Open XML SDK 2.5								←前回と同じ
//	  │ClosedXML 0.76.0								←前回と同じ
//	* Sat Sep 16 23:20:12 JST 2017 Naoyuki Sawa
//	- Visual Studio 2017をバージョンアップした事に伴い、当モジュールもリビルドしました。
//	  当モジュールのソースコードには変更有りません。
//	- 使用したコンパイラとライブラリは、以下の通りです。
//	  │Microsoft Visual Studio Community 2017 Version 15.3.4			←バージョンアップ
//	  │Open XML SDK 2.5								←前回と同じ
//	  │ClosedXML 0.76.0								←前回と同じ
//	* Sat Sep 23 23:49:28 JST 2017 Naoyuki Sawa
//	- Visual Studio 2017をバージョンアップした事に伴い、当モジュールもリビルドしました。
//	  当モジュールのソースコードには変更有りません。
//	- 使用したコンパイラとライブラリは、以下の通りです。
//	  │Microsoft Visual Studio Community 2017 Version 15.3.5			←バージョンアップ
//	  │Open XML SDK 2.5								←前回と同じ
//	  │ClosedXML 0.76.0								←前回と同じ
//	* Sat Oct 14 22:22:29 JST 2017 Naoyuki Sawa
//	- Visual Studio 2017をバージョンアップした事に伴い、当モジュールもリビルドしました。
//	  当モジュールのソースコードには変更有りません。
//	- 使用したコンパイラとライブラリは、以下の通りです。
//	  │Microsoft Visual Studio Community 2017 Version 15.4.0			←バージョンアップ
//	  │Open XML SDK 2.5								←前回と同じ
//	  │ClosedXML 0.76.0								←前回と同じ
//	* Sat Oct 21 23:23:29 JST 2017 Naoyuki Sawa
//	- Visual Studio 2017をバージョンアップした事に伴い、当モジュールもリビルドしました。
//	  当モジュールのソースコードには変更有りません。
//	- 使用したコンパイラとライブラリは、以下の通りです。
//	  │Microsoft Visual Studio Community 2017 Version 15.4.1			←バージョンアップ
//	  │Open XML SDK 2.5								←前回と同じ
//	  │ClosedXML 0.76.0								←前回と同じ
//	* Thu Nov 02 23:33:49 JST 2017 Naoyuki Sawa
//	- Visual Studio 2017をバージョンアップした事に伴い、当モジュールもリビルドしました。
//	  当モジュールのソースコードには変更有りません。
//	- 使用したコンパイラとライブラリは、以下の通りです。
//	  │Microsoft Visual Studio Community 2017 Version 15.4.2			←バージョンアップ
//	  │Open XML SDK 2.5								←前回と同じ
//	  │ClosedXML 0.76.0								←前回と同じ
//	* Thu Nov 09 23:57:54 JST 2017 Naoyuki Sawa
//	- Visual Studio 2017をバージョンアップした事に伴い、当モジュールもリビルドしました。
//	  当モジュールのソースコードには変更有りません。
//	- 使用したコンパイラとライブラリは、以下の通りです。
//	  │Microsoft Visual Studio Community 2017 Version 15.4.3			←バージョンアップ
//	  │Open XML SDK 2.5								←前回と同じ
//	  │ClosedXML 0.76.0								←前回と同じ
//	* Sun Nov 19 22:01:55 JST 2017 Naoyuki Sawa
//	- Visual Studio 2017をバージョンアップした事に伴い、当モジュールもリビルドしました。
//	  当モジュールのソースコードには変更有りません。
//	- 使用したコンパイラとライブラリは、以下の通りです。
//	  │Microsoft Visual Studio Community 2017 Version 15.4.4			←バージョンアップ
//	  │Open XML SDK 2.5								←前回と同じ
//	  │ClosedXML 0.76.0								←前回と同じ
//	* Fri Dec 01 23:59:59 JST 2017 Naoyuki Sawa
//	- Visual Studio 2017をバージョンアップした事に伴い、当モジュールもリビルドしました。
//	  当モジュールのソースコードには変更有りません。
//	- 使用したコンパイラとライブラリは、以下の通りです。
//	  │Microsoft Visual Studio Community 2017 Version 15.4.5			←バージョンアップ
//	  │Open XML SDK 2.5								←前回と同じ
//	  │ClosedXML 0.76.0								←前回と同じ
//	* Thu Dec 07 23:59:59 JST 2017 Naoyuki Sawa
//	- Visual Studio 2017をバージョンアップした事に伴い、当モジュールもリビルドしました。
//	  当モジュールのソースコードには変更有りません。
//	- 使用したコンパイラとライブラリは、以下の通りです。
//	  │Microsoft Visual Studio Community 2017 Version 15.5.0			←バージョンアップ
//	  │Open XML SDK 2.5								←前回と同じ
//	  │ClosedXML 0.76.0								←前回と同じ
//	* Sat Dec 09 23:59:59 JST 2017 Naoyuki Sawa
//	- Visual Studio 2017をバージョンアップした事に伴い、当モジュールもリビルドしました。
//	  当モジュールのソースコードには変更有りません。
//	- 使用したコンパイラとライブラリは、以下の通りです。
//	  │Microsoft Visual Studio Community 2017 Version 15.5.1			←バージョンアップ
//	  │Open XML SDK 2.5								←前回と同じ
//	  │ClosedXML 0.76.0								←前回と同じ
//	* Wed Dec 13 22:00:00 JST 2017 Naoyuki Sawa
//	- ライブラリをバージョンアップしました。
//	  使用したコンパイラとライブラリは、以下の通りです。
//	  │Microsoft Visual Studio Community 2017 Version 15.5.1			←前回と同じ
//	  │Open XML SDK 2.7.2								←バージョンアップ
//	  │ClosedXML 0.90.0								←バージョンアップ
//	  │FastMember.Signed 1.1.0							←追加
//	  ライブラリをバージョンアップした理由は、以下の通りです。
//	- これまでのDumpXlsx.exeでは、特定のエクセルファイルを読み込んだ時に、実行時例外が発生する事が有りました。
//	  実行時例外が発生するエクセルファイルの条件が判らず、詳細な原因は解明出来ていません。
//	  実行時例外が発生するエクセルファイルのサンプルを、keep/DumpXlsxバージョン20171209までは実行時例外になっていたエクセル.xlsx に保存しておきました。
//	  実行時例外のメッセージは、以下の通りです。
//	  │ハンドルされていない例外: System.FormatException: 入力文字列の形式が正しくありません。
//	  │   場所 System.Number.StringToNumber(String str, NumberStyles options, NumberBuffer& number, NumberFormatInfo info, Boolean parseDecimal)
//	  │   場所 System.Number.ParseInt32(String s, NumberStyles style, NumberFormatInfo info)
//	  │   場所 ClosedXML.Excel.XLCell.GetA1Column(String columnPart, Int32 columnsToShift)
//	  │   場所 ClosedXML.Excel.XLCell.GetA1Address(String r1C1Address, Int32 rowsToShift, Int32 columnsToShift)
//	  │   場所 ClosedXML.Excel.XLCell.GetFormula(String strValue, FormulaConversionType conversionType, Int32 rowsToShift, Int32 columnsToShift)
//	  │   場所 ClosedXML.Excel.XLCell.get_FormulaA1()
//	  │   場所 ClosedXML.Excel.XLCell.get_InnerText()
//	  │   場所 ClosedXML.Excel.XLCell.IsEmpty(Boolean includeFormats)
//	  │   場所 ClosedXML.Excel.XLCells.<GetEnumerator>b__1(XLCell c)
//	  │   場所 System.Linq.Enumerable.WhereEnumerableIterator`1.MoveNext()
//	  │   場所 ClosedXML.Excel.XLCells.<GetEnumerator>d__d.MoveNext()
//	  │   場所 System.Linq.Enumerable.Any[TSource](IEnumerable`1 source, Func`2 predicate)
//	  │   場所 ClosedXML.Excel.XLRangeBase.IsEmpty(Boolean includeFormats)
//	  │   場所 ClosedXML.Excel.XLWorksheet.RowsUsed(Boolean includeFormats, Func`2 predicate)
//	  │   場所 DumpXlsx.ProcessFile(String bookPath)
//	  │   場所 DumpXlsx.Main(String[] args)
//	  どうやら、ClosedXMLライブラリが原因で実行時例外が発生しているようで、ClosedXMLライブラリを更新する必要が有ると思いました。
//	  これまで使っていたClosedXML 0.76.0はかなり古いものであり、2017/12/13現在の最新リリース版はClosedXML 0.90.0となっています。
//	  ＞https://github.com/ClosedXML/ClosedXML/releases/download/0.90.0/0.90.0_release.zip
//	  そこで、ClosedXML 0.90.0に更新する事にしました。
//	  しかし、単に上記のアーカイブをダウンロードして置き換えるだけでは、別の問題が生じました。(ここから述べる問題は、前述の実行時例外とは別の問題です。)
//	  ClosedXML 0.76.0はOpen XML SDK 2.5に依存していたのですが、ClosedXML 0.90.0はOpen XML SDK 2.7.2に依存しているからです。
//	  Open XML SDKを更新せずにClosedXMLだけを更新してDumpXlsx.exeを作成すると、常にエクセルファイルが開けないような挙動になってしまいます。
//	  なぜなら、DumpXlsx.exeが起動した時点では参照先のdllは読み込まれず、ワークブックを開く時点で参照先のdllを読み込みに行くからです。
//	  ワークブックを開く時点で参照先のdllを読み込みに行き、ClosedXML 0.90.0のdllは存在するが、Open XML SDK 2.7.2のdllは存在せず、実行時例外となります。
//	  ワークブックを開く処理はtry～catchで囲まれているため、単に「～が開けません。」というエラーメッセージが表示され、トレーススタックは表示されません。
//	  上記の問題を解決するために、Open XML SDK 2.7.2もインストールする事にしました。
//	  しかし、また別の問題があり、Open XML SDK 2.7.2は、以前のOpen XML SDK 2.5とは、配布方式が異なるようです。
//	  Open XML SDK 2.5は、'Sun Jul 17 21:03:07 JST 2016 Naoyuki Sawa'のコメントに記載したWebサイトからダウンロードしてインストールする方式でした。
//	  一方、Open XML SDK 2.7.2は、Webサイトからダウンロードする方法では提供されておらず、GitHubから取得するか(https://github.com/OfficeDev/Open-XML-SDK)、又は、NuGetで取得するしか無いようです。
//	  NuGetで取得する方が簡単なので、今回は、NuGetで取得する事にしました。
//	  尚、ClosedXML 0.90.0もNuGetで取得する事が出来るので、結局のところ、ClosedXML 0.90.0をNuGetで取得すれば、依存するdllもまとめて参照設定を更新する事が出来ました。
//	  具体的な手順は、以下の通りです。
//	  │1. 古い「Open XML SDK 2.5」「Open XML SDK Productivity 2.5 Tool」がインストールされている場合、アンインストールしてもしなくても構いません。
//	  │   今回は、アンインストールしない事にしました。
//	  │   上記には関数リファレンス等が含まれていますが、このあとNuGetで取得するOpen XML SDK 2.7.2には関数リファレンス等が含まれていないようなので、残しておく方が良いと思ったからです。
//	  │   関数リファレンスを参照するためだけであり、アプリケーションのビルドにはもう使用しませんので、アンインストールしても構いません。
//	  │   また、まだ「Open XML SDK 2.5」「Open XML SDK Productivity 2.5 Tool」をインストールしていない環境で、はじめてアプリケーションをビルドする場合は、あらためてそれらをインストールする必要はありません。
//	  │2. 古い「ClosedXML 0.76.0」の参照設定を削除します。
//	  │   具体的には、Visual Studio 2017でプロジェクトを開き、プロジェクト⇒参照の追加⇒参照⇒ClosedXML.dllのチェックを外します。
//	  │3. 古い「ClosedXML 0.76.0」を削除します。
//	  │   具体的には、「C:/Home/Share/Piece/clip/tool/ClosedXML.dll」と「C:/Home/Share/Piece/clip/tool/ClosedXML.XML」を削除します。
//	  │4. 新しい「ClosedXML 0.90.0」の参照設定を追加します。
//	  │   具体的には、Visual Studio 2017で、プロジェクト⇒NuGetパッケージの管理⇒参照⇒パッケージソースに'nuget.org'を選択し、検索ボックスに'ClosedXML'と入力します。
//	  │   一覧にClosedXMLが表示されたら、バージョンに'最新の安定版 0.90.0'(2017/12/13現在)を選択し、インストールボタンを押します。
//	  │   自動的に、「DocumentFormat.OpenXml 2.7.2」(Open XML SDK 2.7.2の事です)と、「FastMember.Signed 1.1.0」もインストールされて、参照設定に追加されます。
//	  │   「FastMember.Signed 1.1.0」はよく判らないのですが、どうやら「DocumentFormat.OpenXml 2.7.2」が依存するdllのようです。
//	  │5. ビルド⇒ソリューションのリビルドを実行します。
//	  │6. 「bin/Release/DumpXlsx.exe」「bin/Release/ClosedXML.dll」「bin/Release/DocumentFormat.OpenXml.dll」「bin/Release/FastMember.Signed.dll」を、「「C:/Home/Share/Piece/clip/tool/～」内にコピーします。
//	  │   尚、これまでは、ClosedXML.XMLもtoolフォルダ内にコピーしていたのですが、実行時には必要無いみたいなので、今後はコピーしない事にしました。
//	  今後、アプリケーションを更新する際は、1.～4.の手順は不要で、5.と6.の「bin/Release/DumpXlsx.exe」のコピーだけを行えば十分です。
//	  ClosedXML.dll、DocumentFormat.OpenXml.dll、FastMember.Signed.dllは(次回にライブラリを更新するまでは)同じなので、毎回上書きコピーする必要は無いからです。
//	  ビルド手順は以上なのですが、それに加えて、ライブラリのアーカイブ容量を削減するために、以下の変更も行いました。
//	  CLEAN.BATにて、ソリューションフォルダ内のpackagesフォルダを削除する処理を追加しました。
//	  NuGetからパッケージを取得すると、取得したパッケージはソリューションフォルダ内のpackagesフォルダに保存されるようなのですが、様々なバージョンのdllが取得され、かなり大きなサイズです。
//	  それらを全て含めてライブラリのアーカイブを作成すると、十数メガバイト～数十メガバイトぐらい増えてしまい、問題が有ります。
//	  幸い、ソリューションフォルダ内のpackagesフォルダを削除しても、ビルド時に自動的にネットワークからダウンロードされるようなので、packagesフォルダは削除する事にしました。
//	  (当ツールのビルドには、ネットワーク接続が必須になってしまいましたが・・・)
//	  今後、万一、ネットワーク接続の無い環境で当ツールをビルドする必要が生じたり、NuGetから上記のパッケージが削除された場合は、toolフォルダにコピーしてあるdllを直接参照設定すればビルド出来ると思います。(未確認)
//	* Wed Dec 13 23:59:59 JST 2017 Naoyuki Sawa
//	- 開かれているエクセルファイルも読み込めるようにしました。
//	  これまでは、エクセルで開いたままの状態のエクセルファイルを指定すると、実行時エラーになっていました。
//	  どうやら、ClosedXMLは、エクセルで開いたままの状態のエクセルファイルを読み込めないようです。
//	  Webで対策を検索したところ、下記のWebサイトに解決方法が載っていたので、その方法を使わせて頂きました。
//	  □参照資料:「C# と VB.NET の質問掲示板 - ClosedXMLで使用中のファイルを開く場合について」(http://bbs.wankuma.com/index.cgi?mode=al2&namber=80140&KLOG=136)
//	* Fri Dec 15 23:59:59 JST 2017 Naoyuki Sawa
//	- Visual Studio 2017をバージョンアップした事に伴い、当モジュールもリビルドしました。
//	  当モジュールのソースコードには変更有りません。
//	- 使用したコンパイラとライブラリは、以下の通りです。
//	  │Microsoft Visual Studio Community 2017 Version 15.5.2			←バージョンアップ
//	  │Open XML SDK 2.7.2								←前回と同じ
//	  │ClosedXML 0.90.0								←前回と同じ
//	  │FastMember.Signed 1.1.0							←前回と同じ
//	* Sun Jan 14 23:59:59 JST 2018 Naoyuki Sawa
//	- Visual Studio 2017をバージョンアップした事に伴い、当モジュールもリビルドしました。
//	  当モジュールのソースコードには変更有りません。
//	- 使用したコンパイラとライブラリは、以下の通りです。
//	  │Microsoft Visual Studio Community 2017 Version 15.5.3			←バージョンアップ
//	  │Open XML SDK 2.7.2								←前回と同じ
//	  │ClosedXML 0.90.0								←前回と同じ
//	  │FastMember.Signed 1.1.0							←前回と同じ
//	* Tue Jan 23 23:59:59 JST 2018 Naoyuki Sawa
//	- Visual Studio 2017をバージョンアップした事に伴い、当モジュールもリビルドしました。
//	  当モジュールのソースコードには変更有りません。
//	- 使用したコンパイラとライブラリは、以下の通りです。
//	  │Microsoft Visual Studio Community 2017 Version 15.5.4			←バージョンアップ
//	  │Open XML SDK 2.7.2								←前回と同じ
//	  │ClosedXML 0.90.0								←前回と同じ
//	  │FastMember.Signed 1.1.0							←前回と同じ
//	* Sun Jan 28 23:59:59 JST 2018 Naoyuki Sawa
//	- Visual Studio 2017をバージョンアップした事に伴い、当モジュールもリビルドしました。
//	  当モジュールのソースコードには変更有りません。
//	- 使用したコンパイラとライブラリは、以下の通りです。
//	  │Microsoft Visual Studio Community 2017 Version 15.5.5			←バージョンアップ
//	  │Open XML SDK 2.7.2								←前回と同じ
//	  │ClosedXML 0.90.0								←前回と同じ
//	  │FastMember.Signed 1.1.0							←前回と同じ
//	* Sat Feb 24 23:59:59 JST 2018 Naoyuki Sawa
//	- Visual Studio 2017をバージョンアップした事に伴い、当モジュールもリビルドしました。
//	  当モジュールのソースコードには変更有りません。
//	- 使用したコンパイラとライブラリは、以下の通りです。
//	  │Microsoft Visual Studio Community 2017 Version 15.5.7			←バージョンアップ
//	  │Open XML SDK 2.7.2								←前回と同じ
//	  │ClosedXML 0.90.0								←前回と同じ
//	  │FastMember.Signed 1.1.0							←前回と同じ
//	* Sat Mar 10 23:59:59 JST 2018 Naoyuki Sawa
//	- Visual Studio 2017をバージョンアップした事に伴い、当モジュールもリビルドしました。
//	  当モジュールのソースコードには変更有りません。
//	- 使用したコンパイラとライブラリは、以下の通りです。
//	  │Microsoft Visual Studio Community 2017 Version 15.6.1			←バージョンアップ
//	  │Open XML SDK 2.7.2								←前回と同じ
//	  │ClosedXML 0.90.0								←前回と同じ
//	  │FastMember.Signed 1.1.0							←前回と同じ
//	* Sat Mar 17 23:59:59 JST 2018 Naoyuki Sawa
//	- Visual Studio 2017をバージョンアップした事に伴い、当モジュールもリビルドしました。
//	  当モジュールのソースコードには変更有りません。
//	- 使用したコンパイラとライブラリは、以下の通りです。
//	  │Microsoft Visual Studio Community 2017 Version 15.6.2			←バージョンアップ
//	  │Open XML SDK 2.7.2								←前回と同じ
//	  │ClosedXML 0.90.0								←前回と同じ
//	  │FastMember.Signed 1.1.0							←前回と同じ
//	* Wed Mar 21 23:59:59 JST 2018 Naoyuki Sawa
//	- Visual Studio 2017をバージョンアップした事に伴い、当モジュールもリビルドしました。
//	  当モジュールのソースコードには変更有りません。
//	- 使用したコンパイラとライブラリは、以下の通りです。
//	  │Microsoft Visual Studio Community 2017 Version 15.6.3			←バージョンアップ
//	  │Open XML SDK 2.7.2								←前回と同じ
//	  │ClosedXML 0.90.0								←前回と同じ
//	  │FastMember.Signed 1.1.0							←前回と同じ
//	* Fri Mar 30 23:59:59 JST 2018 Naoyuki Sawa
//	- Visual Studio 2017をバージョンアップした事に伴い、当モジュールもリビルドしました。
//	  当モジュールのソースコードには変更有りません。
//	- 使用したコンパイラとライブラリは、以下の通りです。
//	  │Microsoft Visual Studio Community 2017 Version 15.6.4			←バージョンアップ
//	  │Open XML SDK 2.7.2								←前回と同じ
//	  │ClosedXML 0.90.0								←前回と同じ
//	  │FastMember.Signed 1.1.0							←前回と同じ
//	* Thu Apr 05 23:59:59 JST 2018 Naoyuki Sawa
//	- Visual Studio 2017をバージョンアップした事に伴い、当モジュールもリビルドしました。
//	  当モジュールのソースコードには変更有りません。
//	- 使用したコンパイラとライブラリは、以下の通りです。
//	  │Microsoft Visual Studio Community 2017 Version 15.6.5			←バージョンアップ
//	  │Open XML SDK 2.7.2								←前回と同じ
//	  │ClosedXML 0.90.0								←前回と同じ
//	  │FastMember.Signed 1.1.0							←前回と同じ
//	* Wed Apr 11 23:59:59 JST 2018 Naoyuki Sawa
//	- Visual Studio 2017をバージョンアップした事に伴い、当モジュールもリビルドしました。
//	  当モジュールのソースコードには変更有りません。
//	- 使用したコンパイラとライブラリは、以下の通りです。
//	  │Microsoft Visual Studio Community 2017 Version 15.6.6			←バージョンアップ
//	  │Open XML SDK 2.7.2								←前回と同じ
//	  │ClosedXML 0.90.0								←前回と同じ
//	  │FastMember.Signed 1.1.0							←前回と同じ
//	* Thu Apr 26 23:59:59 JST 2018 Naoyuki Sawa
//	- '-o'オプションを指定しなければ、標準出力へ出力するように変更しました。
//	* Fri Apr 27 23:59:59 JST 2018 Naoyuki Sawa
//	- Visual Studio 2017をバージョンアップした事に伴い、当モジュールもリビルドしました。
//	  当モジュールのソースコードには変更有りません。
//	- 使用したコンパイラとライブラリは、以下の通りです。
//	  │Microsoft Visual Studio Community 2017 Version 15.6.7			←バージョンアップ
//	  │Open XML SDK 2.7.2								←前回と同じ
//	  │ClosedXML 0.90.0								←前回と同じ
//	  │FastMember.Signed 1.1.0							←前回と同じ
//	* Tue May 08 23:59:59 JST 2018 Naoyuki Sawa
//	- Visual Studio 2017をバージョンアップした事に伴い、当モジュールもリビルドしました。
//	  当モジュールのソースコードには変更有りません。
//	- 使用したコンパイラとライブラリは、以下の通りです。
//	  │Microsoft Visual Studio Community 2017 Version 15.7.0			←バージョンアップ
//	  │Open XML SDK 2.7.2								←前回と同じ
//	  │ClosedXML 0.90.0								←前回と同じ
//	  │FastMember.Signed 1.1.0							←前回と同じ
//	* Thu May 10 23:59:59 JST 2018 Naoyuki Sawa
//	- Visual Studio 2017をバージョンアップした事に伴い、当モジュールもリビルドしました。
//	  当モジュールのソースコードには変更有りません。
//	- 使用したコンパイラとライブラリは、以下の通りです。
//	  │Microsoft Visual Studio Community 2017 Version 15.7.1			←バージョンアップ
//	  │Open XML SDK 2.7.2								←前回と同じ
//	  │ClosedXML 0.90.0								←前回と同じ
//	  │FastMember.Signed 1.1.0							←前回と同じ
//	* Wed May 23 23:59:59 JST 2018 Naoyuki Sawa
//	- Visual Studio 2017をバージョンアップした事に伴い、当モジュールもリビルドしました。
//	  当モジュールのソースコードには変更有りません。
//	- 使用したコンパイラとライブラリは、以下の通りです。
//	  │Microsoft Visual Studio Community 2017 Version 15.7.2			←バージョンアップ
//	  │Open XML SDK 2.7.2								←前回と同じ
//	  │ClosedXML 0.90.0								←前回と同じ
//	  │FastMember.Signed 1.1.0							←前回と同じ
//	* Sun Jun 03 23:59:59 JST 2018 Naoyuki Sawa
//	- Visual Studio 2017をバージョンアップした事に伴い、当モジュールもリビルドしました。
//	  当モジュールのソースコードには変更有りません。
//	- 使用したコンパイラとライブラリは、以下の通りです。
//	  │Microsoft Visual Studio Community 2017 Version 15.7.3			←バージョンアップ
//	  │Open XML SDK 2.7.2								←前回と同じ
//	  │ClosedXML 0.90.0								←前回と同じ
//	  │FastMember.Signed 1.1.0							←前回と同じ
//	* Sat Jun 09 23:59:59 JST 2018 Naoyuki Sawa
//	- ライブラリをバージョンアップしました。
//	  使用したコンパイラとライブラリは、以下の通りです。
//	  │Microsoft Visual Studio Community 2017 Version 15.7.3			←前回と同じ
//	  │Open XML SDK 2.7.2								←前回と同じ
//	  │ClosedXML 0.92.1								←バージョンアップ
//	  │FastMember.Signed 1.3.0							←バージョンアップ
//	  │ExcelNumberFormat 1.0.3							←追加			上記のバージョンアップを行うと、自動的に追加されました。(前回のバージョンアップ時に、既に追加されていたのかも知れません。)
//	- 「bin/Release/DumpXlsx.exe」「bin/Release/ClosedXML.dll」「bin/Release/FastMember.Signed.dll」「bin/Release/ExcelNumberFormat.dll」を、「「C:/Home/Share/Piece/clip/tool/～」内にコピーしました。
//	   詳細は、'Wed Dec 13 22:00:00 JST 2017 Naoyuki Sawa'のコメントを参照して下さい。
//	- '-e'オプションを追加しました。
//	   詳細は、Sample/README.TXT の同日のコメントを参照して下さい。
//	* Sat Jun 23 23:59:59 JST 2018 Naoyuki Sawa
//	- Visual Studio 2017をバージョンアップした事に伴い、当モジュールもリビルドしました。
//	  当モジュールのソースコードには変更有りません。
//	- 使用したコンパイラとライブラリは、以下の通りです。
//	  │Microsoft Visual Studio Community 2017 Version 15.7.4			←バージョンアップ
//	  │Open XML SDK 2.7.2								←前回と同じ
//	  │ClosedXML 0.92.1								←前回と同じ
//	  │FastMember.Signed 1.3.0							←前回と同じ
//	  │ExcelNumberFormat 1.0.3							←前回と同じ
//	- '-b'オプションを追加しました。
//	  これまでDumpXlsx.exeの用途は、抽選表のようなセルの文字列に数値やラベルしか入っていないケースを想定していたのですが、任意の文字列や改行コードを含むエクセルを扱う場合、これまでのDumpXlsx.exeの機能では不足でした。
//	  古い、ExcelSaveAsCsv.batとdpcsvcc.exeを組み合わせた方法ならば、任意の文字列や改行コードを含むエクセルも扱えていたのですが、DumpXlsx.exeではそれらのケースが扱えなくなっていました。
//	  任意の文字列や改行コードを含むエクセルもCSVとして出力するために、古いExcelSaveAsCsv.batと同じ方法(エクセルがCSVとして保存する形式と同じ方法)にする事も可能ではあるのですが、今回は、その方法取らない事にしました。
//	  DumpXlsx.exeは、アドレスを"～"で付与して出力するようにしているので、任意の文字列や改行コードを含むセルを"～"で囲って出力すると、アドレスと区別出来なくなるからです。(実際の所、任意の文字列や改行コードを含むエクセルをアドレス付きで出力したいケースは無いとは思いますが、一応。)
//	  そこで今回は、より汎用的で安定な方法として、セルの文字列をBase64文字列に変換して出力する機能を追加する事にしました。
//	  DumpXlsx.exeに'-b'オプション付きで出力したCSVを読み込む後段のツールは、CSVの各要素をBase64デコードして使用して下さい。(ただしアドレス部分はBase64変換しないので、アドレス部分はデコード不要です。アドレス出力を行う'-a'と、'-b'オプションを併用する事は無いとは思いますが、一応。)
//	  尚、後段のツールにはAwkスクリプトを使用する事が多いと思うのですが、Awkの標準機能ではBase64デコードが出来ないので、今回、Base64デコードを行うAwkスクリプト(C:/Home/Share/Piece/clip/tool/base64.awk)も用意しました。
//	  DumpXlsx.exeに'-b'オプション付きで出力したCSVの、各セルをデコードして表示する単純な例を、以下に示します。
//	  □sample.awk
//	  │@include C:/Home/Share/Piece/clip/tool/base64.awk
//	  │{ for(i = 1; i <= NF; i++) { print base64_decode($i) } }
//	  □以下のように実行する。
//	  │DumpXlsx.exe -b input.xlsx | igawk.exe -F, -f sample.awk
//	* Sat Jul 14 23:59:59 JST 2018 Naoyuki Sawa
//	- Visual Studio 2017をバージョンアップした事に伴い、当モジュールもリビルドしました。
//	  当モジュールのソースコードには変更有りません。
//	- 使用したコンパイラとライブラリは、以下の通りです。
//	  │Microsoft Visual Studio Community 2017 Version 15.7.5			←バージョンアップ
//	  │Open XML SDK 2.7.2								←前回と同じ
//	  │ClosedXML 0.92.1								←前回と同じ
//	  │FastMember.Signed 1.3.0							←前回と同じ
//	  │ExcelNumberFormat 1.0.3							←前回と同じ
//	
using System;
using System.IO;			//Path
using System.Text;			//StringBuilder
using System.Collections.Generic;	//List<T>
//using System.Diagnostics;		//Debug,Trace
using ClosedXML.Excel;
/****************************************************************************
 *	
 ****************************************************************************/
class DumpXlsx {
	const string	VERSION		= "20180714";	//最終更新日
	static int	opt_addr	= 0;		//0=アドレスを付与しない。1=「セル名」を付与する。2=「'シート名'!セル名」を付与する。3=「'[ブック名]シート名'!セル名」を付与する。4=「'パス名[ブック名]シート名'!セル名」を付与する。
//{{2018/06/23追加:'-b'オプションを追加しました。
	static bool	opt_base64	= false;	//false=セルの文字列を、制御文字,又は,',',又は,'"'を'?'に置き換え、それ以外の文字はそのまま出力する。true=セルの文字列を、Base64文字列に変換して出力する。
//}}2018/06/23追加:'-b'オプションを追加しました。
//{{2016/09/24追加:'-c'オプションを追加しました。
	static bool	opt_delCmt	= false;	//false=コメントを削除しない。true=コメントを削除する。
//}}2016/09/24追加:'-c'オプションを追加しました。
//{{2018/06/09追加:'-e'オプションを追加しました。
	static bool	opt_expStr	= false;	//false=「cell.GetString()」が投入した例外を捕捉しない。true=「cell.GetString()」が投入した例外を捕捉し、例外のクラス名に置き換えて出力する。
//}}2018/06/09追加:'-e'オプションを追加しました。
//{{2018/04/26変更:'-o'オプションを指定しなければ、標準出力へ出力するように変更しました。
//	static string	opt_outDir	= "out";	//ルート出力フォルダ名
//↓2018/04/26変更:'-o'オプションを指定しなければ、標準出力へ出力するように変更しました。
	static string	opt_outDir	= null;		//null以外=ルート出力フォルダ名。null=標準出力へ出力する。
//}}2018/04/26変更:'-o'オプションを指定しなければ、標準出力へ出力するように変更しました。
	/*--------------------------------------------------------------------------*/
	static void Main(string[] args) {
		int optind = 0;
		//コマンドラインオプションを解析する。
		while(optind < args.Length) {
			var s = args[optind];
			if((s.Length < 2) || (s[0] != '-')) { break; }
			var optopt = s[1];
			var optarg = s.Substring(2);
			switch(optopt) {
			default: Usage(); break;
			case 'a':
				if(optarg == "") { optarg = "4"; }
				if(!Int32.TryParse(optarg, out opt_addr) || ((uint)opt_addr > 4)) { Usage(); }
				break;
//{{2018/06/23追加:'-b'オプションを追加しました。
			case 'b':
				if(optarg != "") { Usage(); }
				opt_base64 = true;
				break;
//}}2018/06/23追加:'-b'オプションを追加しました。
//{{2016/09/24追加:'-c'オプションを追加しました。
			case 'c':
				if(optarg != "") { Usage(); }
				opt_delCmt = true;
				break;
//}}2016/09/24追加:'-c'オプションを追加しました。
//{{2018/06/09追加:'-e'オプションを追加しました。
			case 'e':
				opt_expStr = true;
				break;
//}}2018/06/09追加:'-e'オプションを追加しました。
			case 'o':
				if(optarg == "") { Usage(); }
				opt_outDir = optarg;
				break;
			}
			//コマンドライン引数を次へ進める。
			optind++;
		}
		if(optind == args.Length) { Usage(); }
		//コマンドライン引数で指定された各xlsx,及び,xlsmファイルについて…
		while(optind < args.Length) {
			var bookPath = args[optind];
			//このファイルを処理する。
			ProcessFile(bookPath);
			//コマンドライン引数を次へ進める。
			optind++;
		}
	}
	/*--------------------------------------------------------------------------*/
	static void Usage() {
		Console.Error.WriteLine("DumpXlsx.exe - xlsx/xlsmファイルのシートデータをダンプするツール(.NET版) ({0})", VERSION);
		Console.Error.WriteLine("Copyright (C) 2016-2018 Naoyuki Sawa");
		Console.Error.WriteLine("");
		Console.Error.WriteLine("USAGE:");
		Console.Error.WriteLine("  DumpXlsx.exe [option ...] filename [filename ...]");
		Console.Error.WriteLine("");
		Console.Error.WriteLine("OPTIONS:");
		Console.Error.WriteLine("  -a0          セルの文字列に、アドレスを付与しません。(デフォルト)");
		Console.Error.WriteLine("  -a1          セルの文字列に、「セル名」を付与します。");
		Console.Error.WriteLine("  -a2          セルの文字列に、「'シート名'!セル名」を付与します。");
		Console.Error.WriteLine("  -a3          セルの文字列に、「'[ブック名]シート名'!セル名」を付与します。");
		Console.Error.WriteLine("  -a4          セルの文字列に、「'パス名[ブック名]シート名'!セル名」を付与します。");
		Console.Error.WriteLine("  -a           -a4 と同じです。");
//{{2018/06/23追加:'-b'オプションを追加しました。
		Console.Error.WriteLine("  -b           セルの文字列を、Base64文字列に変換して出力します。");
		Console.Error.WriteLine("               このオプションを指定しなければ、制御文字,又は,',',又は,'\"'を'?'に置き換え、それ以外の文字はそのまま出力します。");
//}}2018/06/23追加:'-b'オプションを追加しました。
//{{2016/09/24追加:'-c'オプションを追加しました。
		Console.Error.WriteLine("  -c           セルの文字列が\"#\",又は,\"//\"で開始していたら、行コメントの開始と見なして、その行の、それ以降のセルを削除します。");
		Console.Error.WriteLine("               このオプションを指定しなければ、行コメントも削除せずに出力します。");
		Console.Error.WriteLine("               垂直コメント(=行コメント内の\"#～#\"でマークされた列を削除する)を使う場合は、このオプションを指定しないで下さい。");
		Console.Error.WriteLine("               ※垂直コメントを削除する機能は、DeleteVerticalComment.awkが提供する機能です。当ツールが提供する機能ではありません。");
//}}2016/09/24追加:'-c'オプションを追加しました。
//{{2018/06/09追加:'-e'オプションを追加しました。
		Console.Error.WriteLine("  -e           「cell.GetString()」が投入した例外を捕捉し、例外のクラス名に置き換えて出力します。");
		Console.Error.WriteLine("               このオプションを指定しなければ、「cell.GetString()」が投入した例外を捕捉しません。");
		Console.Error.WriteLine("               ※このオプションは、ClosedXML 0.92.1現在のバージョンでは、Excelの一部の機能(TRANSPOSE(配列)など)に未対応であるために発生する問題を、回避するためのものです。");
		Console.Error.WriteLine("               ※通常はこのオプションを指定せずに、エラーが発生して,且つ,そのエラーが不要な範囲のセルで発生している事が確認出来た場合のみ、このオプションを指定して下さい。");
//}}2018/06/09追加:'-e'オプションを追加しました。
//{{2018/04/26変更:'-o'オプションを指定しなければ、標準出力へ出力するように変更しました。
//		Console.Error.WriteLine("  -oフォルダ名 出力フォルダを設定します。");
//		Console.Error.WriteLine("               このオプションを指定しなければ、outフォルダに出力します。");
//↓2018/04/26変更:'-o'オプションを指定しなければ、標準出力へ出力するように変更しました。
		Console.Error.WriteLine("  -oフォルダ名 出力フォルダを指定します。");
		Console.Error.WriteLine("               このオプションを指定しなければ、標準出力へ出力します。");
//}}2018/04/26変更:'-o'オプションを指定しなければ、標準出力へ出力するように変更しました。
		Console.Error.WriteLine("");
		Console.Error.WriteLine("EXAMPLE:");
//{{2018/04/26変更:'-o'オプションを指定しなければ、標準出力へ出力するように変更しました。
//		Console.Error.WriteLine("  DumpXlsx.exe -a2 Sample1.xlsx Sample2.xlsm");
//		Console.Error.WriteLine("  Sample1.xlsxとSample2.xlsmを読み込んで、各シートのデータをoutフォルダに出力します。");
//		Console.Error.WriteLine("  同時に、「ブックのパス名(タブ)シート名」を、標準出力へ出力します。");
//↓2018/04/26変更:'-o'オプションを指定しなければ、標準出力へ出力するように変更しました。
		Console.Error.WriteLine("  ①DumpXlsx.exe Sample1.xlsx");
		Console.Error.WriteLine("  │Sample1.xlsxを読み込んで、各シートのデータを標準出力へ出力します。");
		Console.Error.WriteLine("  │セルの文字列に、アドレスを付与しません。");
		Console.Error.WriteLine("  ②DumpXlsx.exe -a2 -oout Sample1.xlsx Sample2.xlsm");
		Console.Error.WriteLine("  │Sample1.xlsxとSample2.xlsmを読み込んで、各シートのデータをoutフォルダに出力します。");
		Console.Error.WriteLine("  │同時に、「ブックのパス名(タブ)シート名」を、標準出力へ出力します。");
		Console.Error.WriteLine("  │セルの文字列に、「'シート名'!セル名」を付与します。");
//}}2018/04/26変更:'-o'オプションを指定しなければ、標準出力へ出力するように変更しました。
//{{2018/06/09追加:'-e'オプションを追加しました。
		Console.Error.WriteLine("  ③DumpXlsx.exe -e Sample1.xlsx");
		Console.Error.WriteLine("  │Sample1.xlsxを読み込んで、各シートのデータを標準出力へ出力します。");
		Console.Error.WriteLine("  │「cell.GetString()」が投入した例外を捕捉し、例外のクラス名に置き換えて出力します。");
//}}2018/06/09追加:'-e'オプションを追加しました。
		Environment.Exit(1);
	}
	/*--------------------------------------------------------------------------*/
	static void ProcessFile(string bookPath) {
		//ワークブックのドライブ名とフォルダ名を取得する。
		var bookDir = Path.GetDirectoryName(bookPath);
		if(bookDir != "") {			//ドライブ名とフォルダ名が空文字でなければ…
			if(!bookDir.EndsWith("\\") &&
			   !bookDir.EndsWith("/")) {
				bookDir += "\\";	//確実にパスセパレータを補う。Path.GetDirectoryName()は_splitpath()と違って、フォルダ名の末尾にパスセパレータを追加しないので、このように明示的に追加する必要が有る。Path.Combine()を使うだけならばこの処理は不要なのだが、「'パス名[ブック名]シート名'!セル名」で出力する場合にパス名の末尾にパスセパレータが必須なのでこの処理が必要です。
			}
		}
		//ワークブックのファイル名と拡張子を取得する。
		var bookFname = Path.GetFileName(bookPath);
		//ワークブックを開く。
		XLWorkbook book = null;	//警告抑制
		try {
//{{2017/12/13変更:開かれているエクセルファイルも読み込めるようにしました。
//			book = new XLWorkbook(bookPath, XLEventTracking.Disabled);
//↓2017/12/13変更:開かれているエクセルファイルも読み込めるようにしました。
			using(FileStream fs = new FileStream(bookPath, FileMode.Open, FileAccess.Read, FileShare.ReadWrite/*重要*/)) {
				book = new XLWorkbook(fs, XLEventTracking.Disabled);
			}
//}}2017/12/13変更:開かれているエクセルファイルも読み込めるようにしました。
		} catch(Exception) {
			Console.Error.WriteLine("{0}が開けません。", bookPath);
			Environment.Exit(1);
		}
		using(book) {
//{{2018/04/26変更:'-o'オプションを指定しなければ、標準出力へ出力するように変更しました。
//			//出力フォルダ名を作成する。
//			string outDir = Path.Combine(opt_outDir, Path.GetFileNameWithoutExtension(bookFname));	//出力フォルダ名は、「ルート出力フォルダ名\ワークブックのベース名」とする事にした。
//			//出力フォルダを確実に作成する。
//			try {
//				Directory.CreateDirectory(outDir);	//既に同じ名前のフォルダが存在していても、Directory.CreateDirectory()はエラーにならない。
//			} catch(Exception) {
//				Console.Error.WriteLine("{0}フォルダが作成出来ません。", outDir);
//				Environment.Exit(1);
//			}
//↓2018/04/26変更:'-o'オプションを指定しなければ、標準出力へ出力するように変更しました。
			string outDir = null;	//警告抑制
			//'-o'オプションが指定されていたら…
			if(opt_outDir != null) {
				//出力フォルダ名を作成する。
				outDir = Path.Combine(opt_outDir, Path.GetFileNameWithoutExtension(bookFname));	//出力フォルダ名は、「ルート出力フォルダ名\ワークブックのベース名」とする事にした。
				//出力フォルダを確実に作成する。
				try {
					Directory.CreateDirectory(outDir);	//既に同じ名前のフォルダが存在していても、Directory.CreateDirectory()はエラーにならない。
				} catch(Exception) {
					Console.Error.WriteLine("{0}フォルダが作成出来ません。", outDir);
					Environment.Exit(1);
				}
			}
//}}2018/04/26変更:'-o'オプションを指定しなければ、標準出力へ出力するように変更しました。
			//各ワークシートについて…
			foreach(var sheet in book.Worksheets) {
				//ワークシート名を取得する。
				var sheetName = sheet.Name;
//{{2018/04/26変更:'-o'オプションを指定しなければ、標準出力へ出力するように変更しました。
//				//標準出力に、「ワークブックのパス名(タブ)ワークシート名」を出力する。
//				Console.WriteLine(bookPath + "\t" + sheetName);
//				//出力ファイルのパス名を作成する。
//				var outPath = Path.Combine(outDir, Path.ChangeExtension(sheetName, ".txt"));	//出力パス名は、「出力フォルダ名\ワークシート名+.txt」とする事にした。
//				//出力ファイルを作成する。
//				StreamWriter writer = null;	//警告抑制
//				try {
//					writer = new StreamWriter(outPath, false, Encoding.Default/*シフトJIS*/);
//				} catch(Exception) {
//					Console.Error.WriteLine("{0}が作成出来ません。", outPath);
//					Environment.Exit(1);
//				}
//				using(writer) {
//↓2018/04/26変更:'-o'オプションを指定しなければ、標準出力へ出力するように変更しました。
				TextWriter writer = null;	//警告抑制
				//'-o'オプションが指定されていたら…
				if(opt_outDir != null) {
					//標準出力に、「ワークブックのパス名(タブ)ワークシート名」を出力する。
					Console.WriteLine(bookPath + "\t" + sheetName);
					//出力ファイルのパス名を作成する。
					var outPath = Path.Combine(outDir, Path.ChangeExtension(sheetName, ".txt"));	//出力パス名は、「出力フォルダ名\ワークシート名+.txt」とする事にした。
					//出力ファイルを作成する。
					try {
						writer = new StreamWriter(outPath, false, Encoding.Default/*シフトJIS*/);
					} catch(Exception) {
						Console.Error.WriteLine("{0}が作成出来ません。", outPath);
						Environment.Exit(1);
					}
				//'-o'オプションが指定されていなければ…
				} else {
					//出力先を、標準出力とする。
					writer = Console.Out;
				}
				/*using(writer)*/ {	//ここでは'using(writer)'を使えない。もし使うと'-o'オプションが指定されていない場合に標準出力を閉じてしまう事になるから。
//}}2018/04/26変更:'-o'オプションを指定しなければ、標準出力へ出力するように変更しました。
					//各行について…
					foreach(var row in sheet.RowsUsed()) {
						var list = new List<string>();	//各セルの出力文字列を格納するためのリスト
						var oldCol = 0;			//前のセルの列番号
						//各セルについて…
						foreach(var cell in row.CellsUsed()) {		//Cells()ではなくCellsUsed()を呼び出す事に注意せよ。Cells()でも動作はするが、Cells()はCellsUsed(true)と等価であり、書式だけ設定された不要なセルも列挙してしまう可能性が有る。
							//セルの文字列を取得する。
							var value = cell.ValueCached;		//まず、ValueではなくValueCachedを取得する事に注意せよ。もし無条件にValueを取得すると、式が含まれていた場合にClosedXMLが自力で再集計等を行うようで、極端に遅くなったり、式にエラーが有る場合例外が投入されたりする。
							if(value == null) {
//{{2018/06/09変更:'-e'オプションを追加しました。
//								value = cell.GetString();	//式でない場合は、(ValueCached==null) となっているようだ。その場合は、直値,又は,文字列を、cell.Valueから文字列として取得する。
//↓2018/06/09変更:'-e'オプションを追加しました。
								try {
									value = cell.GetString();	//式でない場合は、(ValueCached==null) となっているようだ。その場合は、直値,又は,文字列を、cell.Valueから文字列として取得する。
								} catch(Exception e) {			//「cell.GetString()」が例外を投入したら…
									if(!opt_expStr) { throw; }	//'-e'オプションが指定されていなければ、例外を捕捉せずに再投入する。
									value = e.GetType().Name;	//'-e'オプションが指定されていたら、例外のクラス名に置き換えて出力する。
								}
//}}2018/06/09変更:'-e'オプションを追加しました。
							}
							//セルの文字列の前後の空白を削除する。
							value = value.Trim();
//{{2016/09/24追加:'-c'オプションを追加しました。
//							//セルの文字列が"#",又は,"//"で開始していたら…
//							if(value.StartsWith("#") || value.StartsWith("//")) {
//								//この行の、これ以降のセルを無視する。
//								break;	//ここまで
//							}
//↓2016/09/24追加:'-c'オプションを追加しました。
							//'-c'オプションが指定されていたら…
							if(opt_delCmt) {
								//セルの文字列が"#",又は,"//"で開始していたら…
								if(value.StartsWith("#") || value.StartsWith("//")) {
									//この行の、これ以降のセルを無視する。
									break;	//ここまで
								}
							}
//}}2016/09/24追加:'-c'オプションを追加しました。
							//セルのアドレスを取得する。
							var addr = cell.Address;
							//列番号を取得する。
							var col = addr.ColumnNumber;
							//このセルの列番号が、前のセルの列番号以下である事は無いはず。
							if(oldCol >= col) { throw new ApplicationException(); }
							//列番号が連続していない場合は、空セルの出力文字列を挿入する。
							while(++oldCol < col) { list.Add(""); }
							//このセルの出力文字列を作成する。
							var sb = new StringBuilder();
							if(!String.IsNullOrEmpty(value)) {	//セルの文字列がnullでも""でもなければ…
//{{2018/06/23追加:'-b'オプションを追加しました。
								//'-b'オプションが指定されていたら…
								if(opt_base64) {
									//セルの文字列を、シフトJISバイト配列に変換する。
									var a = Encoding.Default/*シフトJIS*/.GetBytes(value);
									//シフトJISバイト配列を、Base64文字列に変換する。
									var t = Convert.ToBase64String(a);
									//Base64文字列を追加する。
									sb.Append(t);
								//'-b'オプションが指定されていなければ…
								} else {
//}}2018/06/23追加:'-b'オプションを追加しました。
									//セルの文字列の各文字について…
									foreach(var c in value) {
										var t = c;
										//制御文字,又は,',',又は,'"'ならば…
										if(Char.IsControl(t) || (t == ',') || (t == '"')) {
											//'?'に置き換える。
											t = '?';
										}
										//この文字を追加する。
										sb.Append(t);
									}
//{{2018/06/23追加:'-b'オプションを追加しました。
								}
//}}2018/06/23追加:'-b'オプションを追加しました。
								//セルの文字列が"0"でなければ…
								// - "0"でもアドレスを付与しても構いませんが、dLotTblC.exeが無視するので無駄です。
								//   出力サイズを減らすために、"0"ならばアドレスを付与しない事にしました。
								if(sb.ToString() != "0") {
									//opt_addr:1=「セル名」を付与する。
									if(opt_addr >= 1) {
										sb.Append(' ');
										sb.Append('"');
										//opt_addr:2=「'シート名'!セル名」を付与する。
										if(opt_addr >= 2) {
											sb.Append('\'');
											//opt_addr:3=「'[ブック名]シート名'!セル名」を付与する。
											if(opt_addr >= 3) {
												//opt_addr:4=「'パス名[ブック名]シート名'!セル名」を付与する。
												if(opt_addr >= 4) {
													sb.Append(bookDir);	//ワークブックのドライブ名とフォルダ名
												}
												sb.Append('[');
												sb.Append(bookFname);	//ワークブックのファイル名と拡張子
												sb.Append(']');
											}
											sb.Append(sheetName);	//ワークシート名
											sb.Append('\'');
											sb.Append('!');
										}
										sb.Append(addr.ToString());
										sb.Append('"');
									}
								}
							}
							//このセルの出力文字列を、リストに追加する。
							list.Add(sb.ToString());
						}
						//各セルの出力文字列を格納したリストを、カンマで区切って連結する。
						var s = String.Join(",", list);
						//行の末尾の、連続する空セルを削除する。
						s = s.TrimEnd(',');
						//空行でなければ…
						if(s != "") {
							//この行を出力する。
							writer.WriteLine(s);
						}
					}
				}
//{{2018/04/26追加:'-o'オプションを指定しなければ、標準出力へ出力するように変更しました。
				//'-o'オプションが指定されていたら…
				if(opt_outDir != null) {
					//出力ファイルを閉じる。
					writer.Close();
				}
//}}2018/04/26追加:'-o'オプションを指定しなければ、標準出力へ出力するように変更しました。
			}
		}
	}
}
