
;  GNU C 2.7.2 [AL 1.1, MM 40] RISC NEWS-OS compiled by CC

;  Cc1 defaults:
;  -mmemcpy

;  Cc1 arguments (-G value = 0, Cpu = 3000, ISA = 1):
;  -quiet -dumpbase -O2 -Wall -o

gcc2_compiled.:
__gnu_compiled_c:
	.code
	.align	2
inst:
	.word	i_square0
	.word	i_saw0
	.word	i_triangle0
	.word	i_square
	.word	i_saw
	.word	i_triangle
	.word	i_BD909
	.word	i_SDGATE
	.word	i_SD909
	.word	i_HO909
	.word	i_HC909
	.word	i_CYMBD
	.word	i_CYMBD
	.word	i_TOMH1
	.word	i_TOMM1
	.word	i_TOML1
	.word	i_HANDCLAP
	.align	2
TBL_expt:
	.half	32768
	.half	34716
	.half	36781
	.half	38968
	.half	41285
	.half	43740
	.half	46341
	.half	49097
	.half	52016
	.half	55109
	.half	58386
	.half	61858
	.half	65535
; APP

		.code
		.align		1
gexp:
		ld.ub		%r4, %r12		;//%r4  := (unsigned char)n
		sra		%r12, 8			;//%r12 :=  (n >> 8)
	ext	__divsi3@rm	; 		xcall.d		__divsi3		;//%r10 := ((n >> 8) / 12), %ahr := ((n >> 8) % 12)				//ksvec200.s__divsi3%ahrɏ]ԂɈˑB
	call.d	__divsi3@rl
		ld.w		%r13, 12		;//%r13 :=             12					*delay*
		ld.w		%r5, %ahr		;//%r5  := div12t1 = ((n >> 8) % 12)
		sla		%r5, 1			;//%r5  := div12t1 * 2
		ext		TBL_expt+0x0@ah		;//%r6  := expt = TBL_expt[div12t1 + 0]
		ext		TBL_expt+0x0@al		;//
		ld.uh		%r6, [%r5]		;//
		ext		TBL_expt+0x2@ah		;//%r5  :=        TBL_expt[div12t1 + 1]
		ext		TBL_expt+0x2@al		;//
		ld.uh		%r5, [%r5]		;//
	;//	sub		%r5, %r6		;//%r5  := expb = TBL_expt[div12t1 + 1] - expt		
		ld.w		%r7, 20			;//%r7  :=           20					@
		sub		%r7, %r10		;//%r7  := div12t2 = 20 - ((n >> 8) / 12)		@
		jrge.d		3			;//if(div12t2 < 0) {					@
		 sub		%r5, %r6		;//%r5  := expb = TBL_expt[div12t1 + 1] - expt			*delay*
		 ld.w		%r7, 0			;//  %r7  := div12t2 = 0 }
		mlt.h		%r5, %r4		;//%alr :=          (expb * (unsigned char)n)
		ld.w		%r10, %alr		;//%r10 :=          (expb * (unsigned char)n)
		sra		%r10, 8			;//%r10 :=          (expb * (unsigned char)n) >> 8
		add		%r10, %r6		;//%r10 := (expt + ((expb * (unsigned char)n) >> 8))
	    ;//{{%r7j󂵂Ăǂ̂xsraœK
	    ;//	xsra		%r10, %r7
	    ;//	ret
	    ;//%r7j󂵂Ăǂ̂xsraœK
		cmp		%r7, 8			;//
		jrle		4			;//
		sra		%r10, 8			;//@
		jp.d		-3			;//
		sub		%r7, 8			;//@								*delay*
		ret.d					;//
		sra		%r10, %r7		;//								*delay*
	    ;//}}%r7j󂵂Ăǂ̂xsraœK


		.code
		.align		1
MakeWave:
		ld.w		%r4, [%r12]+		;//%r4  := freqwk   = mp->freqwk
		ld.w		%r5, [%r12]+		;//%r5  := freq     = mp->freq
		ld.w		%r6, [%r12]+		;//%r6  := pData    = mp->pData
		ld.w		%r7, [%r12]+		;//%r7  := loop_end = mp->loop_end
		ld.w		%r9, [%r12]		;//%r9  := loop_w   = mp->loop_w
		sub		%r12, 16		;//%r12 :=            mp
		sra		%r14, 1			;//%r14 := v >>= 1
		ld.w		%r10, %r4		;//%r10 := x = freqwk			
MakeWave_LOOP:						;//do {					@
	srl	%r10,0x8	; 		xsrl		%r10, 14		;//  %r10 := x >>= 14			
	srl	%r10,0x6
		add		%r10, %r6		;//  %r10 :=     &pData[x]		@
		ld.b		%r10, [%r10]		;//  %r10 := d1 = pData[x]		@
		ld.w		%r11, [%r13]		;//  %r11 := t = *p			@	*anti-interlock*
		mlt.h		%r10, %r14		;//  %alr :=      (d1 * v)		@
		ld.w		%r10, %alr		;//  %r10 :=      (d1 * v)		@
		add		%r4, %r5		;//  %r4  := freqwk += freq		@
		cmp		%r4, %r7		;//  if(freqwk >= loop_end) {		@
		jrlt.d		MakeWave_NEXT		;//    					@
		sra		%r10, 7			;//  %r10 :=      (d1 * v) >> 7		@	*delay*
		cmp		%r9, 0			;//    if(!loop_w) { goto STOP }	@
		jreq		MakeWave_STOP		;//    					@
		sub		%r4, %r9		;//    %r4  := freqwk -= loop_w		@
MakeWave_NEXT:						;//  }					@
		add		%r11, %r10		;//  %r11 := t += (d1 * v) >> 7		@
		ld.w		[%r13]+, %r11		;//  *p++ =  t				@
		sub		%r15, 1			;//  %r15 := cnt--			@
		jrne.d		MakeWave_LOOP		;//} while(cnt)				@
		ld.w		%r10, %r4		;//%r10 := x = freqwk				*delay*
	ld.w	[%r12],%r4	; 		xld.w		[%r12+0x0], %r4		;//mp->freqwk = x
		ret					;//return
MakeWave_STOP:						;//
	ext	0x4		; 		xld.w		[%r12+0x4], %r8		;//mp->freq = 0
	ld.w	[%r12],%r8
		ret					;//return

; NO_APP
	.align	2
muslib_adpcm_tbl:
	.half	233
	.half	-29440
	.half	375
	.half	1793
	.half	233
	.half	29695
	.half	375
	.half	-1538
; APP

		.code
		.align		1
MakeWaveADPCM:
		pushn		%r3
		ld.w		%r0, [%r12]+		;//%r0  := freqwk   = mp->freqwk
		ld.w		%r1, [%r12]+		;//%r1  := freq     = mp->freq
		ld.w		%r2, [%r12]+		;//%r2  := pData    = mp->pData
		ld.w		%r3, [%r12]		;//%r3  := loop_end = mp->loop_end
		add		%r12, 8			;//%r12 :=           &mp->pcm									*anti-interlock*
	srl	%r3,0x8		; 		xsrl		%r3, 14			;//%r3  := loop_end >>= 14
	srl	%r3,0x6
		ld.h		%r4, [%r12]+		;//%r4  := pcm      = mp->pcm
		ld.h		%r5, [%r12]		;//%r5  := delta    = mp->delta
		ld.w		%r6, %r0		;//%r6  :=     freqwk
	srl	%r6,0x8		; 		xsrl		%r6, 14			;//%r6  := x = freqwk >> 14
	srl	%r6,0x6
	ext	muslib_adpcm_tbl+0x0@h	; 		xld.w		%r7, muslib_adpcm_tbl	;//%r7  := muslib_adpcm_tbl
	ext	muslib_adpcm_tbl+0x0@m
	ld.w	%r7,muslib_adpcm_tbl+0x0@l
;//{{2017/08/13ύX:MakeWaveADPCM()܂B
;//		sub		%r12, 22		;//%r12 :=            mp
;//2017/08/13ύX:MakeWaveADPCM()܂B
		ld.w		%r10, %r6		;//%r10 :=           x
		srl		%r10, 2			;//%r10 :=           x >> 2
		add		%r2, %r10		;//%r2  := pData += (x >> 2)
	ext	0x3		; 		xand		%r10, %r6, 3		;//%r10 :=             x & 3
	and	%r10,%r6
		jreq.d		6			;//if(                 x & 3) {		!(x&3)̏ꍇ%r9=data͂̌Ŏ擾̂łł͕slō\܂B
		 sub		%r12, 22		;//%r12 :=            mp									*delay*
		 ld.ub		%r9, [%r2]+		;//  %r9  := data = *pData++
		 sll		%r9, 2			;//  %r9  := data *= (sizeof(short) * 2)
		 srl		%r9, %r10		;//  %r9  := data >>= (x & 3)
		 srl		%r9, %r10		;//  %r9  := data >>= (x & 3) }
;//}}2017/08/13ύX:MakeWaveADPCM()܂B
		sra		%r14, 1			;//%r14 := v >>= 1
		;//%r0  := freqwk
		;//%r1  := freq
		;//%r2  := pData
		;//%r3  := loop_end
		;//%r4  := pcm
		;//%r5  := delta
		;//%r6  := x
		;//%r7  := muslib_adpcm_tbl
;//{{2017/08/13ǉ:MakeWaveADPCM()܂B
		;//%r9  := data
;//}}2017/08/13ǉ:MakeWaveADPCM()܂B
		;//%r12 := mp
		;//%r13 := p
		;//%r14 := v
		;//%r15 := cnt
;//{{2017/08/13ύX:MakeWaveADPCM()܂B
;//MakeWaveADPCM_L10:					;//do {
;//		add		%r0, %r1		;//  %r0  :=     freqwk += freq
;//2017/08/13ύX:MakeWaveADPCM()܂B
		add		%r0, %r1		;//  %r0  :=     freqwk += freq		
MakeWaveADPCM_L10:					;//do {											
	;//	add		%r0, %r1		;//  %r0  :=     freqwk += freq		
;//}}2017/08/13ύX:MakeWaveADPCM()܂B												
		ld.w		%r10, %r0		;//  %r10 :=     freqwk									
	srl	%r10,0x8	; 		xsrl		%r10, 14		;//  %r10 := y = freqwk >> 14								
	srl	%r10,0x6
		sub		%r10, %r6		;//  %r10 := y -= x									
		jreq		MakeWaveADPCM_L30	;//  if(y) {										
MakeWaveADPCM_L20:					;//    do {										
		cmp		%r6, %r3		;//      if(x >= loop_end) { goto STOP }						
		jruge		MakeWaveADPCM_STOP	;//      										
;//{{2017/08/13ύX:MakeWaveADPCM()܂B												
;//		ld.w		%r11, %r6		;//      %r11 :=                x							
;//		srl		%r11, 2			;//      %r11 :=                x >> 2							
;//		add		%r11, %r2		;//      %r11 :=         &pData[x >> 2]							
;//		ld.ub		%r11, [%r11]		;//      %r11 :=          pData[x >> 2]							
;//		xand		%r9, %r6, 3		;//      %r9  :=                             x & 3					
;//		srl		%r11, %r9		;//      %r11 :=          pData[x >> 2] >>  (x & 3)					
;//		srl		%r11, %r9		;//      %r11 :=          pData[x >> 2] >> ((x & 3) << 1)				
;//		and		%r11, 3			;//      %r11 := adpcm = (pData[x >> 2] >> ((x & 3) << 1)) & 3				
;//		sll		%r11, 2			;//      %r11 :=                                       adpcm * (sizeof(short) * 2)	
;//		add		%r11, %r7		;//      %r11 :=                     &muslib_adpcm_tbl[adpcm]				
;//		ld.w		%r11, [%r11]		;//      %r11 :=                      muslib_adpcm_tbl[adpcm]				
;//		mlt.h		%r5, %r11		;//      %alr :=         mlt_h(delta, muslib_adpcm_tbl[adpcm][0])				!INTERLOCK!
;//		ld.w		%r5, %alr		;//      %r5  :=         mlt_h(delta, muslib_adpcm_tbl[adpcm][0])			
;//		sra		%r5, 8			;//      %r5  := delta = mlt_h(delta, muslib_adpcm_tbl[adpcm][0]) >> 8			
;//		swap		%r11, %r11		;//      										
;//		mlt.h		%r5, %r11		;//      %alr :=         mlt_h(delta, muslib_adpcm_tbl[adpcm][1])			
;//		ld.w		%r11, %alr		;//      %r11 :=         mlt_h(delta, muslib_adpcm_tbl[adpcm][1])			
;//		sra		%r11, 8			;//      %r11 :=         mlt_h(delta, muslib_adpcm_tbl[adpcm][1]) >> 8			
;//		add		%r4, %r11		;//      %r4  := pcm  += mlt_h(delta, muslib_adpcm_tbl[adpcm][1]) >> 8			
;//		sub		%r10, 1			;//      %r10 := y--									
;//		jrne.d		MakeWaveADPCM_L20	;//    } while(  y)									
;//		add		%r6, 1			;//      %r6  := x++										*delay*
;//2017/08/13ύX:MakeWaveADPCM()܂B												
	ext	0x3		; 		xand		%r11, %r6, 3		;//      %r11 := x & 3									
	and	%r11,%r6
		jrne.d		4			;//      if(   !(x & 3)) {								
		 add		%r6, 1			;//      %r6  := x++										*delay*
		 ld.ub		%r9, [%r2]+		;//        %r9  := data = *pData++							
		 sll		%r9, 2			;//        %r9  := data *= (sizeof(short) * 2) }					
	ext	0xc		; 		xand		%r11, %r9, 0xc		;//      %r11 := adpcm = data & (3 * (sizeof(short) * 2))				
	and	%r11,%r9
		add		%r11, %r7		;//      %r11 :=                     &muslib_adpcm_tbl[adpcm]				
		ld.w		%r11, [%r11]		;//      %r11 :=                      muslib_adpcm_tbl[adpcm]				
		srl		%r9, 2			;//      %r9  := data >>= 2									*anti-interlock*
		mlt.h		%r5, %r11		;//      %alr :=         mlt_h(delta, muslib_adpcm_tbl[adpcm][0])			
		ld.w		%r5, %alr		;//      %r5  :=         mlt_h(delta, muslib_adpcm_tbl[adpcm][0])			
		sra		%r5, 8			;//      %r5  := delta = mlt_h(delta, muslib_adpcm_tbl[adpcm][0]) >> 8			
		swap		%r11, %r11		;//      										
		mlt.h		%r5, %r11		;//      %alr :=         mlt_h(delta, muslib_adpcm_tbl[adpcm][1])			
		ld.w		%r11, %alr		;//      %r11 :=         mlt_h(delta, muslib_adpcm_tbl[adpcm][1])			
		sra		%r11, 8			;//      %r11 :=         mlt_h(delta, muslib_adpcm_tbl[adpcm][1]) >> 8			
	;//	add		%r4, %r11		;//      %r4  := pcm  += mlt_h(delta, muslib_adpcm_tbl[adpcm][1]) >> 8		
		sub		%r10, 1			;//      %r10 := y--									
		jrne.d		MakeWaveADPCM_L20	;//    } while(  y)									
		add		%r4, %r11		;//      %r4  := pcm  += mlt_h(delta, muslib_adpcm_tbl[adpcm][1]) >> 8			*delay*
;//}}2017/08/13ύX:MakeWaveADPCM()܂B												
MakeWaveADPCM_L30:					;//  }											
		ld.w		%r10, [%r13]		;//  %r10 := c = *p									
		mlt.h		%r4, %r14		;//  %alr :=      mlt_h(pcm, v)								
		ld.w		%r11, %alr		;//  %r11 :=      mlt_h(pcm, v)								
		sra		%r11, 7			;//  %r11 :=      mlt_h(pcm, v) >> 7							
		add		%r10, %r11		;//  %r10 := c + (mlt_h(pcm, v) >> 7)							
		ld.w		[%r13]+, %r10		;//  *p++  = c										
		sub		%r15, 1			;//  %r15 := cnt--									
;//{{2017/08/13ύX:MakeWaveADPCM()܂B												
;//		jrne		MakeWaveADPCM_L10	;//} while(  cnt)									
;//2017/08/13ύX:MakeWaveADPCM()܂B												
		jrne.d		MakeWaveADPCM_L10	;//} while(  cnt)									
		add		%r0, %r1		;//  %r0  :=     freqwk += freq			*delay*
		sub		%r0, %r1		;//  %r0  :=     freqwk -= freq		Ō̈񑫂߂𑊎EB
;//}}2017/08/13ύX:MakeWaveADPCM()܂B
		ld.w		[%r12], %r0		;//         mp->freqwk = freqwk
		add		%r12, 20		;//%r12 := &mp->pcm
		ld.h		[%r12]+, %r4		;//         mp->pcm    = pcm
		ld.h		[%r12], %r5		;//         mp->delta  = delta
MakeWaveADPCM_RET:
		popn		%r3
		ret
MakeWaveADPCM_STOP:
	ext	0x4		; 		xld.w		[%r12+0x4], %r8		;//         mp->freq   = 0
	ld.w	[%r12],%r8
		jp		MakeWaveADPCM_RET	;//         return


		.code
		.align		1
MakeWaveSQR:
	ld.w	%r4,[%r12]	; 		xld.w		%r4, [%r12+0x0]		;//%r4  := x = mp->freqwk
	ext	0x4		; 		xld.w		%r5, [%r12+0x4]		;//%r5  := y = mp->freq		*anti-interlock*
	ld.w	%r5,[%r12]
	sla	%r4,0x8		; 		xsla		%r4, 16			;//%r4  := x <<= 16		*anti-interlock*
	sla	%r4,0x8
	sla	%r5,0x8		; 		xsla		%r5, 16			;//%r5  := y <<= 16
	sla	%r5,0x8
		ld.w		%r6, %r14		;//%r6  := w = v
		sra		%r6, 1			;//%r6  := w >>= 1
		add		%r4, %r5		;//%r4  := x += y	
MakeWaveSQR_LOOP:					;//do {			@
		ld.w		%r7, [%r13]		;//  %r7  := t = *p	@
		jrge.d		3			;//  if(x < 0) {		*anti-interlock*
		 add		%r7, %r6		;//  %r7  := t += w	@	*delay*
		 sub		%r7, %r14		;//    %r7  := t -= v	@
		ld.w		[%r13]+, %r7		;//  *p++  = t }	@
		sub		%r15, 1			;//  %r15 := cnt--	@
		jrne.d		MakeWaveSQR_LOOP	;//} while(cnt)		@
		add		%r4, %r5		;//%r4  := x += y		*delay*
;//{{2017/08/15ǉ:AZułMakeWaveSQRłɂāAxXbgɓĂ'x+=y'́AŌ̈񑫂߂𑊎E鏈sĂoOC܂B
		sub		%r4, %r5		;//%r4  := x += y	Ō̈񑫂߂𑊎EB
;//}}2017/08/15ǉ:AZułMakeWaveSQRłɂāAxXbgɓĂ'x+=y'́AŌ̈񑫂߂𑊎E鏈sĂoOC܂B
	sra	%r4,0x8		; 		xsra		%r4, 16			;//%r4  := x >>= 16
	sra	%r4,0x8
	ld.w	[%r12],%r4	; 		xld.w		[%r12+0x0], %r4		;//mp->freqwk = x
		ret					;//return


		.code
		.align		1
MakeWaveSAW:
	ld.w	%r4,[%r12]	; 		xld.w		%r4, [%r12+0x0]		;//%r4  := x = mp->freqwk
	ext	0x4		; 		xld.w		%r5, [%r12+0x4]		;//%r5  := y = mp->freq
	ld.w	%r5,[%r12]
		sra		%r14, 1			;//%r14 := v >>= 1
MakeWaveSAW_LOOP:					;//do {
		ld.w		%r6, [%r13]		;//  %r6  := t = *p
		mlt.h		%r4, %r14		;//  %alr :=      (x * v)
		ld.w		%r7, %alr		;//  %r7  :=      (x * v)
	sra	%r7,0x8		; 		xsra		%r7, 15			;//  %r7  :=      (x * v) >> 15
	sra	%r7,0x7
		add		%r6, %r7		;//  %r6  := t += (x * v) >> 15
		ld.w		[%r13]+, %r6		;//  *p++  = t
		sub		%r15, 1			;//  %r15 := cnt--
		jrne.d		MakeWaveSAW_LOOP	;//} while(cnt)
		add		%r4, %r5		;//%r4  := x += y	*delay*
	ld.w	[%r12],%r4	; 		xld.w		[%r12+0x0], %r4		;//mp->freqwk = x
		ret					;//return


		.code
		.align		1
MakeWaveTRI:
	ld.w	%r4,[%r12]	; 		xld.w		%r4, [%r12+0x0]		;//%r4  := x = mp->freqwk
	ext	0x4		; 		xld.w		%r5, [%r12+0x4]		;//%r5  := y = mp->freq
	ld.w	%r5,[%r12]
		sra		%r14, 1			;//%r14 := v >>= 1
MakeWaveTRI_LOOP:					;//do {
		ld.w		%r6, [%r13]		;//  %r6  := t = *p
		mlt.h		%r4, %r14		;//  %alr :=          (x * v)
		ld.w		%r7, %alr		;//  %r7  :=          (x * v)
		cmp		%r7, 0			;//  %r7  :=       abs(x * v)
		jrge.d		4			;//
		 sra		%r7, 8			;//  %r7  :=       abs(x * v) >> 8	*delay*
		 not		%r7, %r7		;//
		 add		%r7, 1			;//
		sra		%r7, 6			;//  %r7  :=       abs(x * v) >> 14
		sub		%r7, %r14		;//  %r7  :=      (abs(x * v) >> 14) - v
		add		%r6, %r7		;//  %r6  := t += (abs(x * v) >> 14) - v
		ld.w		[%r13]+, %r6		;//  *p++  = t
		sub		%r15, 1			;//  %r15 := cnt--
		jrne.d		MakeWaveTRI_LOOP	;//} while(cnt)
		add		%r4, %r5		;//%r4  := x += y			*delay*
	ld.w	[%r12],%r4	; 		xld.w		[%r12+0x0], %r4		;//mp->freqwk = x
		ret					;//return

; NO_APP
	.code
	.align	1
GenEnvR:
;	.frame	%sp,4,$31		# vars= 0, regs= 1/0, args= 0, extra= 0
;	.mask	0x80000000,-4
;	.fmask	0x00000000,0
	ext	0x28		; 	xld.w	%r10,[%r12+0x28]
	ld.w	%r10,[%r12]
	ext	0x3e		; 	xsub	%r10,%r10,4000
	sub	%r10,0x20
	ext	0x28		; 	xld.w	[%r12+0x28],%r10
	ld.w	[%r12],%r10
	ext	0x1e20		; 	xld.w	%r11,-30720			; 0xffff8800
	ld.w	%r11,0x0
	cmp	%r10,%r11
	jrge	__LX71		; 	xjrge	__L71
	ext	0x28		; 	xld.w	[%r12+0x28],%r11
	ld.w	[%r12],%r11
	ld.w	%r13,0x0
	ext	0x4		; 	xld.w	[%r12+0x4],%r13
	ld.w	[%r12],%r13
__LX71:				; __L71:
	ret
	.align	1
GenEnvS:
;	.frame	%sp,4,$31		# vars= 0, regs= 1/0, args= 0, extra= 0
;	.mask	0x80000000,-4
;	.fmask	0x00000000,0
	ext	0x28		; 	xld.w	%r10,[%r12+0x28]
	ld.w	%r10,[%r12]
	ext	0x38		; 	xld.w	%r11,[%r12+0x38]
	ld.w	%r11,[%r12]
	sub	%r10,%r11
	ext	0x28		; 	xld.w	[%r12+0x28],%r10
	ld.w	[%r12],%r10
	ext	0x1e20		; 	xld.w	%r11,-30720			; 0xffff8800
	ld.w	%r11,0x0
	cmp	%r10,%r11
	jrge	__LX73		; 	xjrge	__L73
	ext	0x28		; 	xld.w	[%r12+0x28],%r11
	ld.w	[%r12],%r11
	ld.w	%r13,0x0
	ext	0x4		; 	xld.w	[%r12+0x4],%r13
	ld.w	[%r12],%r13
__LX73:				; __L73:
	ret
	.align	1
GenEnvD:
;	.frame	%sp,4,$31		# vars= 0, regs= 1/0, args= 0, extra= 0
;	.mask	0x80000000,-4
;	.fmask	0x00000000,0
	ext	0x28		; 	xld.w	%r10,[%r12+0x28]
	ld.w	%r10,[%r12]
	ext	0x30		; 	xld.w	%r11,[%r12+0x30]
	ld.w	%r11,[%r12]
	sub	%r10,%r11
	ext	0x28		; 	xld.w	[%r12+0x28],%r10
	ld.w	[%r12],%r10
	ext	0x34		; 	xld.w	%r11,[%r12+0x34]
	ld.w	%r11,[%r12]
	cmp	%r10,%r11
	jrge	__LX75		; 	xjrge	__L75
	ext	GenEnvS+0x0@h	; 	xld.w	%r10,GenEnvS
	ext	GenEnvS+0x0@m
	ld.w	%r10,GenEnvS+0x0@l
	ext	0x54		; 	xld.w	[%r12+0x54],%r10
	ld.w	[%r12],%r10
__LX75:				; __L75:
	ret
	.align	1
GenEnvA:
;	.frame	%sp,4,$31		# vars= 0, regs= 1/0, args= 0, extra= 0
;	.mask	0x80000000,-4
;	.fmask	0x00000000,0
	ext	0x28		; 	xld.w	%r10,[%r12+0x28]
	ld.w	%r10,[%r12]
	ext	0x2c		; 	xld.w	%r11,[%r12+0x2c]
	ld.w	%r11,[%r12]
	add	%r10,%r11
	ext	0x28		; 	xld.w	[%r12+0x28],%r10
	ld.w	[%r12],%r10
	jrle	__LX77		; 	xjrle	__L77
	ld.w	%r13,0x0
	ext	0x28		; 	xld.w	[%r12+0x28],%r13
	ld.w	[%r12],%r13
	ext	GenEnvD+0x0@h	; 	xld.w	%r10,GenEnvD
	ext	GenEnvD+0x0@m
	ld.w	%r10,GenEnvD+0x0@l
	ext	0x54		; 	xld.w	[%r12+0x54],%r10
	ld.w	[%r12],%r10
__LX77:				; __L77:
	ret
	.align	1
GenEnvInit:
;	.frame	%sp,4,$31		# vars= 0, regs= 1/0, args= 0, extra= 0
;	.mask	0x80000000,-4
;	.fmask	0x00000000,0
	ext	0x2c		; 	xld.w	%r11,[%r12+0x2c]
	ld.w	%r11,[%r12]
	not	%r10,%r11
	add	%r10,1
	or	%r10,%r11
	sra	%r10,0x8	; 	xsra	%r10,31
	sra	%r10,0x8
	sra	%r10,0x8
	sra	%r10,0x7
	ext	0x1f40		; 	xand	%r10,%r10,0xffffd000
	and	%r10,0x0
	ext	0x28		; 	xld.w	[%r12+0x28],%r10
	ld.w	[%r12],%r10
	ext	GenEnvA+0x0@h	; 	xld.w	%r10,GenEnvA
	ext	GenEnvA+0x0@m
	ld.w	%r10,GenEnvA+0x0@l
	ext	0x54		; 	xld.w	[%r12+0x54],%r10
	ld.w	[%r12],%r10
	ret
	.align	1
SetEnvSpeed:
;	.frame	%sp,4,$31		# vars= 0, regs= 1/0, args= 0, extra= 0
;	.mask	0x80000000,-4
;	.fmask	0x00000000,0
	ext	0x3		; 	xld.w	%r10,0x000000c0		; 192
	ld.w	%r10,0x0
	mlt.w	%r12,%r10
	ld.w	%r12,%alr
	ext	0xc0		; 	xadd	%r12,%r12,12288
	add	%r12,0x0
	ext	gexp@rm		; 	xcall	gexp
	call	gexp@rl
	ret
	.align	1
SetEnv:
;	.frame	%sp,16,$31		# vars= 0, regs= 4/0, args= 0, extra= 0
;	.mask	0x80070000,-4
;	.fmask	0x00000000,0
	pushn	%r2
	ld.w	%r2,%r12
	ld.w	%r0,%r14
	ld.w	%r1,%r15
	ld.w	%r12,%r13
	call	SetEnvSpeed	; 	xcall	SetEnvSpeed
	ext	0x2c		; 	xld.w	[%r2+0x2c],%r10
	ld.w	[%r2],%r10
	ld.w	%r12,%r0
	call	SetEnvSpeed	; 	xcall	SetEnvSpeed
	ext	0x30		; 	xld.w	[%r2+0x30],%r10
	ld.w	[%r2],%r10
	ext	0x1		; 	xsub	%r1,%r1,127
	sub	%r1,0x3f
	jrle	__LX83		; 	xjrle	__L83
	ld.w	%r1,0x0
__LX83:				; __L83:
	ext	0x3		; 	xld.w	%r10,0x000000c0		; 192
	ld.w	%r10,0x0
	mlt.w	%r1,%r10
	ld.w	%r11,%alr
	ext	0x34		; 	xld.w	[%r2+0x34],%r11
	ld.w	[%r2],%r11
	ld.w	%r12,[%sp+0x4]	; 	xld.w	%r12,[%sp+0x10]
	call	SetEnvSpeed	; 	xcall	SetEnvSpeed
	ext	0x38		; 	xld.w	[%r2+0x38],%r10
	ld.w	[%r2],%r10
	popn	%r2
	ret
	.align	1
GenVibS2:
;	.frame	%sp,4,$31		# vars= 0, regs= 1/0, args= 0, extra= 0
;	.mask	0x80000000,-4
;	.fmask	0x00000000,0
	ext	0x44		; 	xld.uh	%r10,[%r12+0x44]
	ld.uh	%r10,[%r12]
	ext	0x46		; 	xld.uh	%r13,[%r12+0x46]
	ld.uh	%r13,[%r12]
	add	%r10,%r13
	ext	0x44		; 	xld.h	[%r12+0x44],%r10
	ld.h	[%r12],%r10
	ld.h	%r10,%r10
; APP
	cmp  %r10, 0
jrge 3
 not %r10, %r10
 add %r10, 1

; NO_APP
	ext	0x100		; 	xld.w	%r11,0x00004000		; 16384
	ld.w	%r11,0x0
	sub	%r11,%r10
	ext	0x4c		; 	xld.h	%r10,[%r12+0x4c]
	ld.h	%r10,[%r12]
	mlt.w	%r11,%r10
	ld.w	%r10,%alr
	sra	%r10,0x3	; 	xsra	%r10,3
	ext	0x24		; 	xld.w	[%r12+0x24],%r10
	ld.w	[%r12],%r10
	ret
	.align	1
GenVibS1:
;	.frame	%sp,4,$31		# vars= 0, regs= 1/0, args= 0, extra= 0
;	.mask	0x80000000,-4
;	.fmask	0x00000000,0
	ext	0x4c		; 	xld.uh	%r10,[%r12+0x4c]
	ld.uh	%r10,[%r12]
	ext	0x4a		; 	xld.uh	%r13,[%r12+0x4a]
	ld.uh	%r13,[%r12]
	add	%r10,%r13
	ext	0x4c		; 	xld.h	[%r12+0x4c],%r10
	ld.h	[%r12],%r10
	ld.h	%r10,%r10
	ext	0x4e		; 	xld.h	%r11,[%r12+0x4e]
	ld.h	%r11,[%r12]
	cmp	%r10,%r11
	jrlt	__LX86		; 	xjrlt	__L86
	ext	GenVibS2+0x0@h	; 	xld.w	%r10,GenVibS2
	ext	GenVibS2+0x0@m
	ld.w	%r10,GenVibS2+0x0@l
	ext	0x58		; 	xld.w	[%r12+0x58],%r10
	ld.w	[%r12],%r10
	ext	0x4e		; 	xld.uh	%r10,[%r12+0x4e]
	ld.uh	%r10,[%r12]
	ext	0x4c		; 	xld.h	[%r12+0x4c],%r10
	ld.h	[%r12],%r10
__LX86:				; __L86:
	call	GenVibS2	; 	xcall	GenVibS2
	ret
	.align	1
GenVibS0:
;	.frame	%sp,4,$31		# vars= 0, regs= 1/0, args= 0, extra= 0
;	.mask	0x80000000,-4
;	.fmask	0x00000000,0
	ext	0x4c		; 	xld.uh	%r10,[%r12+0x4c]
	ld.uh	%r10,[%r12]
	ext	0x48		; 	xld.uh	%r11,[%r12+0x48]
	ld.uh	%r11,[%r12]
	add	%r10,%r11
	ext	0x4c		; 	xld.h	[%r12+0x4c],%r10
	ld.h	[%r12],%r10
	ld.h	%r10,%r10
	cmp	%r10,0x0
	jrlt	__LX88		; 	xjrlt	__L88
	ext	GenVibS1+0x0@h	; 	xld.w	%r10,GenVibS1
	ext	GenVibS1+0x0@m
	ld.w	%r10,GenVibS1+0x0@l
	ext	0x58		; 	xld.w	[%r12+0x58],%r10
	ld.w	[%r12],%r10
	ld.w	%r11,0x0
	ext	0x44		; 	xld.h	[%r12+0x44],%r11
	ld.h	[%r12],%r11
	ext	0x4c		; 	xld.h	[%r12+0x4c],%r11
	ld.h	[%r12],%r11
__LX88:				; __L88:
	ret
	.align	1
GenVibInit:
;	.frame	%sp,4,$31		# vars= 0, regs= 1/0, args= 0, extra= 0
;	.mask	0x80000000,-4
;	.fmask	0x00000000,0
	ext	GenVibS0+0x0@h	; 	xld.w	%r10,GenVibS0
	ext	GenVibS0+0x0@m
	ld.w	%r10,GenVibS0+0x0@l
	ext	0x58		; 	xld.w	[%r12+0x58],%r10
	ld.w	[%r12],%r10
	ext	0x1f00		; 	xld.w	%r10,-16384			; 0xffffc000
	ld.w	%r10,0x0
	ext	0x4c		; 	xld.h	[%r12+0x4c],%r10
	ld.h	[%r12],%r10
	ret
	.align	1
SetVib:
;	.frame	%sp,20,$31		# vars= 0, regs= 5/0, args= 0, extra= 0
;	.mask	0x800f0000,-4
;	.fmask	0x00000000,0
	pushn	%r3
	ld.w	%r2,%r12
	ld.w	%r3,%r15
	ext	0x1		; 	xld.w	%r10,0x00000060		; 96
	ld.w	%r10,0x20
	mlt.w	%r13,%r10
	ld.w	%r11,%alr
	ext	0x4e		; 	xld.h	[%r2+0x4e],%r11
	ld.h	[%r2],%r11
	ext	0x3		; 	xld.w	%r1,0x000000c0		; 192
	ld.w	%r1,0x0
	mlt.w	%r14,%r1
	ext	0x180		; 	xld.w	%r0,0x00006000		; 24576
	ld.w	%r0,0x0
	ld.w	%r12,%alr
	add	%r12,%r0
	ext	gexp@rm		; 	xcall	gexp
	call	gexp@rl
	ext	0x46		; 	xld.h	[%r2+0x46],%r10
	ld.h	[%r2],%r10
	mlt.w	%r3,%r1
	ld.w	%r12,%alr
	add	%r12,%r0
	ext	gexp@rm		; 	xcall	gexp
	call	gexp@rl
	ext	0x48		; 	xld.h	[%r2+0x48],%r10
	ld.h	[%r2],%r10
	ld.w	%r11,[%sp+0x5]	; 	xld.w	%r11,[%sp+0x14]
	mlt.w	%r11,%r1
	ld.w	%r12,%alr
	add	%r12,%r0
	ext	gexp@rm		; 	xcall	gexp
	call	gexp@rl
	ext	0x4a		; 	xld.h	[%r2+0x4a],%r10
	ld.h	[%r2],%r10
	popn	%r3
	ret
	.code
	.align	2
TBL_genwave.90:
	.word	MakeWaveSQR
	.word	MakeWaveSAW
	.word	MakeWaveTRI
	.code
	.align	1
SetInst:
;	.frame	%sp,4,$31		# vars= 0, regs= 1/0, args= 0, extra= 0
;	.mask	0x80000000,-4
;	.fmask	0x00000000,0
	sll	%r13,0x2	; 	xsll	%r13,2
	ext	inst+0x0@h	; 	xld.w	%r13,[%r13+inst]
	ext	inst+0x0@m
	ld.w	%r9,inst+0x0@l
	add	%r9,%r13
	ld.w	%r13,[%r9]
	ld.w	%r14,0x0
	ext	0x4		; 	xld.w	[%r12+0x4],%r14
	ld.w	[%r12],%r14
	ext	0x8		; 	xld.w	%r10,[%r13+0x8]
	ld.w	%r10,[%r13]
	ext	0x8		; 	xld.w	[%r12+0x8],%r10
	ld.w	[%r12],%r10
	ext	0x10		; 	xld.w	%r11,[%r13+0x10]
	ld.w	%r11,[%r13]
	ext	0xc		; 	xld.w	[%r12+0xc],%r11
	ld.w	[%r12],%r11
	ld.ub	%r10,[%r13]	; 	xld.ub	%r10,[%r13]
	and	%r10,0x10	; 	xand	%r10,%r10,0x00000010
	jreq	__LX92		; 	xjreq	__L92
	ext	0xc		; 	xld.w	%r10,[%r13+0xc]
	ld.w	%r10,[%r13]
	sub	%r11,%r10
	ld.w	%r10,%r11
__LX92:				; __L92:
	ext	0x10		; 	xld.w	[%r12+0x10],%r10
	ld.w	[%r12],%r10
	ext	0x4		; 	xld.uh	%r10,[%r13+0x4]
	ld.uh	%r10,[%r13]
	ext	0x6		; 	xld.uh	%r11,[%r13+0x6]
	ld.uh	%r11,[%r13]
	sub	%r10,%r11
	ext	0x183		; 	xadd	%r10,%r10,24777
	add	%r10,0x9
	ext	0x18		; 	xld.w	[%r12+0x18],%r10
	ld.w	[%r12],%r10
	ld.w	%r14,0x0
	ext	0x2c		; 	xld.w	[%r12+0x2c],%r14
	ld.w	[%r12],%r14
	ld.ub	%r11,[%r13]	; 	xld.ub	%r11,[%r13]
	ld.w	%r10,%r11
	ext	0x2		; 	xand	%r10,%r10,0x00000080
	and	%r10,0x0
	jreq	__LX94		; 	xjreq	__L94
	ext	0x1		; 	xld.ub	%r10,[%r13+0x1]
	ld.ub	%r10,[%r13]
	sll	%r10,0x2	; 	xsll	%r10,2
	ext	TBL_genwave.90+0x0@h	; 	xld.w	%r10,[%r10+TBL_genwave.90]
	ext	TBL_genwave.90+0x0@m
	ld.w	%r9,TBL_genwave.90+0x0@l
	add	%r9,%r10
	ld.w	%r10,[%r9]
	jp	__LX98		; 	xjp	__L98
__LX94:				; __L94:
	ld.w	%r10,%r11
	ext	0x1		; 	xand	%r10,%r10,0x00000040
	and	%r10,0x0
	jreq	__LX96		; 	xjreq	__L96
	ext	MakeWaveADPCM+0x0@h	; 	xld.w	%r10,MakeWaveADPCM
	ext	MakeWaveADPCM+0x0@m
	ld.w	%r10,MakeWaveADPCM+0x0@l
	jp	__LX98		; 	xjp	__L98
__LX96:				; __L96:
	ext	MakeWave+0x0@h	; 	xld.w	%r10,MakeWave
	ext	MakeWave+0x0@m
	ld.w	%r10,MakeWave+0x0@l
__LX98:				; __L98:
	ext	0x50		; 	xld.w	[%r12+0x50],%r10
	ld.w	[%r12],%r10
	ret
	.align	1
SetVol:
;	.frame	%sp,4,$31		# vars= 0, regs= 1/0, args= 0, extra= 0
;	.mask	0x80000000,-4
;	.fmask	0x00000000,0
	ext	0x3		; 	xld.w	%r10,0x000000c0		; 192
	ld.w	%r10,0x0
	mlt.w	%r13,%r10
	ld.w	%r10,%alr
	ext	0x210		; 	xadd	%r10,%r10,33792
	add	%r10,0x0
	ext	0x3c		; 	xld.w	[%r12+0x3c],%r10
	ld.w	[%r12],%r10
	ld.w	%r11,0x0
	ext	0x40		; 	xld.w	[%r12+0x40],%r11
	ld.w	[%r12],%r11
	ret
	.align	1
SetExp:
;	.frame	%sp,4,$31		# vars= 0, regs= 1/0, args= 0, extra= 0
;	.mask	0x80000000,-4
;	.fmask	0x00000000,0
	ext	0x1		; 	xsub	%r13,%r13,127
	sub	%r13,0x3f
	ext	0x3		; 	xld.w	%r10,0x000000c0		; 192
	ld.w	%r10,0x0
	mlt.w	%r13,%r10
	ld.w	%r11,%alr
	ext	0x40		; 	xld.w	[%r12+0x40],%r11
	ld.w	[%r12],%r11
	ret
	.align	1
SetExpRel:
;	.frame	%sp,4,$31		# vars= 0, regs= 1/0, args= 0, extra= 0
;	.mask	0x80000000,-4
;	.fmask	0x00000000,0
	ext	0x3		; 	xld.w	%r10,0x000000c0		; 192
	ld.w	%r10,0x0
	mlt.w	%r13,%r10
	ext	0x40		; 	xld.w	%r10,[%r12+0x40]
	ld.w	%r10,[%r12]
	ld.w	%r11,%alr
	add	%r10,%r11
	ext	0x40		; 	xld.w	[%r12+0x40],%r10
	ld.w	[%r12],%r10
	ret
	.align	1
NoteOn:
;	.frame	%sp,8,$31		# vars= 0, regs= 2/0, args= 0, extra= 0
;	.mask	0x80010000,-4
;	.fmask	0x00000000,0
	pushn	%r0
	ld.w	%r0,%r12
	ld.w	%r11,0x0
	ld.w	[%r0],%r11	; 	xld.w	[%r0],%r11
	ld.w	%r10,0x1	; 	xld.w	%r10,0x00000001		; 1
	ext	0x4		; 	xld.w	[%r0+0x4],%r10
	ld.w	[%r0],%r10
	ext	0x18		; 	xld.w	%r10,[%r0+0x18]
	ld.w	%r10,[%r0]
	add	%r10,%r13
	ext	0x1c		; 	xld.w	[%r0+0x1c],%r10
	ld.w	[%r0],%r10
	ld.w	%r11,0x0
	ext	0x14		; 	xld.h	[%r0+0x14],%r11
	ld.h	[%r0],%r11
	ld.w	%r10,0x10	; 	xld.w	%r10,0x00000010		; 16
	ext	0x16		; 	xld.h	[%r0+0x16],%r10
	ld.h	[%r0],%r10
	ld.w	%r11,0x0
	ext	0x20		; 	xld.w	[%r0+0x20],%r11
	ld.w	[%r0],%r11
	ext	0x24		; 	xld.w	[%r0+0x24],%r11
	ld.w	[%r0],%r11
	ext	GenEnvInit@rm	; 	xcall	GenEnvInit
	call	GenEnvInit@rl
	ld.w	%r12,%r0
	ext	GenVibInit@rm	; 	xcall	GenVibInit
	call	GenVibInit@rl
	popn	%r0
	ret
	.align	1
NotePitch:
;	.frame	%sp,4,$31		# vars= 0, regs= 1/0, args= 0, extra= 0
;	.mask	0x80000000,-4
;	.fmask	0x00000000,0
	ext	0x18		; 	xld.w	%r10,[%r12+0x18]
	ld.w	%r10,[%r12]
	add	%r10,%r13
	ext	0x1c		; 	xld.w	[%r12+0x1c],%r10
	ld.w	[%r12],%r10
	ret
	.align	1
NoteOff:
;	.frame	%sp,4,$31		# vars= 0, regs= 1/0, args= 0, extra= 0
;	.mask	0x80000000,-4
;	.fmask	0x00000000,0
	ext	GenEnvR+0x0@h	; 	xld.w	%r10,GenEnvR
	ext	GenEnvR+0x0@m
	ld.w	%r10,GenEnvR+0x0@l
	ext	0x54		; 	xld.w	[%r12+0x54],%r10
	ld.w	[%r12],%r10
	ret
	.global	title
	.code
	.align	2
__LC0:
	.ascii	"\000"
	.data
	.align	2
title:
	.word	__LC0
	.global	title2
	.align	2
title2:
	.word	__LC0
	.global	music_wch
music_wch:
	.byte	0
using_wch:
	.byte	-1
; APP

		.code
		.align		1
getadrs:
		ld.ub		%r10, [%r12]+		;//%r10 := p[0]
		ld.ub		%r11, [%r12]		;//%r11 :=         p[1]
		sll		%r11, 8			;//%r11 :=         p[1] << 8		!INTERLOCK!
		ret.d					;//return  p[0] + (p[1] << 8)
		or		%r10, %r11		;//%r10 := p[0] + (p[1] << 8)		*delay*

; NO_APP
	.code
	.align	1
SeqNop:
;	.frame	%sp,4,$31		# vars= 0, regs= 1/0, args= 0, extra= 0
;	.mask	0x80000000,-4
;	.fmask	0x00000000,0
	ret
	.align	1
SeqNop1:
;	.frame	%sp,4,$31		# vars= 0, regs= 1/0, args= 0, extra= 0
;	.mask	0x80000000,-4
;	.fmask	0x00000000,0
	ext	0x5c		; 	xld.w	%r10,[%r12+0x5c]
	ld.w	%r10,[%r12]
	add	%r10,0x1	; 	xadd	%r10,%r10,1
	ext	0x5c		; 	xld.w	[%r12+0x5c],%r10
	ld.w	[%r12],%r10
	ret
	.align	1
SeqNop2:
;	.frame	%sp,4,$31		# vars= 0, regs= 1/0, args= 0, extra= 0
;	.mask	0x80000000,-4
;	.fmask	0x00000000,0
	ext	0x5c		; 	xld.w	%r10,[%r12+0x5c]
	ld.w	%r10,[%r12]
	add	%r10,0x2	; 	xadd	%r10,%r10,2
	ext	0x5c		; 	xld.w	[%r12+0x5c],%r10
	ld.w	[%r12],%r10
	ret
	.code
	.align	2
__LC1:
	.ascii	"muslib.$\000"
	.code
	.align	1
StartSeq:
;	.frame	%sp,20,$31		# vars= 0, regs= 5/0, args= 0, extra= 0
;	.mask	0x800f0000,-4
;	.fmask	0x00000000,0
	pushn	%r3
	ld.w	%r1,%r12
	ext	datatop+0x0@ah	; 	xld.w	[datatop],%r1
	ext	datatop+0x0@al
	ld.w	[%r8],%r1
	ext	0x1e		; 	xld.w	%r10,0x00000780		; 1920
	ld.w	%r10,0x0
	ext	tempo+0x0@ah	; 	xld.h	[tempo],%r10
	ext	tempo+0x0@al
	ld.h	[%r8],%r10
	ld.w	%r15,0x0
	ext	tempowk+0x0@ah	; 	xld.h	[tempowk],%r15
	ext	tempowk+0x0@al
	ld.h	[%r8],%r15
	ld.w	%r10,0x1	; 	xld.w	%r10,0x00000001		; 1
	ext	runf+0x0@ah	; 	xld.b	[runf],%r10
	ext	runf+0x0@al
	ld.b	[%r8],%r10
	ld.ub	%r3,[%r1]	; 	xld.ub	%r3,[%r1]
	add	%r1,0x1		; 	xadd	%r1,%r1,1
	cmp	%r3,0x0
	jrne	__LX109		; 	xjrne	__L109
	ld.ub	%r3,[%r1]	; 	xld.ub	%r3,[%r1]
	add	%r1,0x1		; 	xadd	%r1,%r1,1
__LX109:				; __L109:
	ext	0x1		; 	xsub	%r10,%r3,1
	sub	%r10,%r3
	cmp	%r10,0x5	; 	xcmp	%r10,5
	jrule	__LX110		; 	xjrule	__L110
	int	2
	.word	__LC1
	.half	0x0000042c
__LX110:				; __L110:
	ext	seqwk+0x0@h	; 	xld.w	%r12,seqwk
	ext	seqwk+0x0@m
	ld.w	%r12,seqwk+0x0@l
	ld.w	%r13,0x0
	ext	0xf		; 	xld.w	%r14,0x000003f0		; 1008
	ld.w	%r14,0x30
	ext	memset@rm	; 	xcall	memset
	call	memset@rl
	ld.w	%r2,0x0
	cmp	%r2,%r3
	jrge	__LX112		; 	xjrge	__L112
__LX114:				; __L114:
	ext	0x2		; 	xld.w	%r10,0x000000a8		; 168
	ld.w	%r10,0x28
	mlt.w	%r2,%r10
	ext	seqwk+0x0@h	; 	xld.w	%r0,seqwk
	ext	seqwk+0x0@m
	ld.w	%r0,seqwk+0x0@l
	ld.w	%r15,%alr
	add	%r15,%r0
	ld.w	%r0,%r15
	ld.w	%r12,%r1
	call	getadrs		; 	xcall	getadrs
	ext	datatop+0x0@ah	; 	xld.w	%r11,[datatop]
	ext	datatop+0x0@al
	ld.w	%r11,[%r8]
	add	%r11,%r10
	ext	0x5c		; 	xld.w	[%r0+0x5c],%r11
	ld.w	[%r0],%r11
	add	%r1,0x2		; 	xadd	%r1,%r1,2
	ext	0x0		; 	xld.w	%r10,0x00000029		; 41
	ld.w	%r10,0x29
	ext	0x6a		; 	xld.h	[%r0+0x6a],%r10
	ld.h	[%r0],%r10
	ld.w	%r10,0x1	; 	xld.w	%r10,0x00000001		; 1
	ext	0x6c		; 	xld.b	[%r0+0x6c],%r10
	ld.b	[%r0],%r10
	ext	SeqNop+0x0@h	; 	xld.w	%r10,SeqNop
	ext	SeqNop+0x0@m
	ld.w	%r10,SeqNop+0x0@l
	ext	0x74		; 	xld.w	[%r0+0x74],%r10
	ld.w	[%r0],%r10
	ld.w	%r12,%r0
	ld.w	%r13,0x0
	ext	SetInst@rm	; 	xcall	SetInst
	call	SetInst@rl
	ld.w	%r12,%r0
	ext	0x1		; 	xld.w	%r13,0x0000007f		; 127
	ld.w	%r13,0x3f
	ext	SetVol@rm	; 	xcall	SetVol
	call	SetVol@rl
	add	%r2,0x1		; 	xadd	%r2,%r2,1
	cmp	%r2,%r3
	jrlt	__LX114		; 	xjrlt	__L114
__LX112:				; __L112:
	ld.w	%r12,%r1
	call	getadrs		; 	xcall	getadrs
	ext	datatop+0x0@ah	; 	xld.w	%r11,[datatop]
	ext	datatop+0x0@al
	ld.w	%r11,[%r8]
	add	%r11,%r10
	ext	drumsbase+0x0@ah	; 	xld.w	[drumsbase],%r11
	ext	drumsbase+0x0@al
	ld.w	[%r8],%r11
	add	%r1,0x2		; 	xadd	%r1,%r1,2
	ld.w	%r12,%r1
	call	getadrs		; 	xcall	getadrs
	ext	datatop+0x0@ah	; 	xld.w	%r11,[datatop]
	ext	datatop+0x0@al
	ld.w	%r11,[%r8]
	add	%r11,%r10
	ext	title+0x0@ah	; 	xld.w	[title],%r11
	ext	title+0x0@al
	ld.w	[%r8],%r11
	ext	0x2		; 	xadd	%r12,%r1,2
	add	%r12,%r1
	ext	getadrs@rm	; 	xcall	getadrs
	call	getadrs@rl
	ext	datatop+0x0@ah	; 	xld.w	%r11,[datatop]
	ext	datatop+0x0@al
	ld.w	%r11,[%r8]
	add	%r11,%r10
	ext	title2+0x0@ah	; 	xld.w	[title2],%r11
	ext	title2+0x0@al
	ld.w	[%r8],%r11
	popn	%r3
	ret
	.align	1
SeqPortaExecP:
;	.frame	%sp,4,$31		# vars= 0, regs= 1/0, args= 0, extra= 0
;	.mask	0x80000000,-4
;	.fmask	0x00000000,0
	ext	0x20		; 	xld.w	%r10,[%r12+0x20]
	ld.w	%r10,[%r12]
	ext	0x60		; 	xld.w	%r11,[%r12+0x60]
	ld.w	%r11,[%r12]
	add	%r10,%r11
	ext	0x20		; 	xld.w	[%r12+0x20],%r10
	ld.w	[%r12],%r10
	jrlt	__LX117		; 	xjrlt	__L117
	ld.w	%r13,0x0
	ext	0x20		; 	xld.w	[%r12+0x20],%r13
	ld.w	[%r12],%r13
	ext	0x6f		; 	xbclr	[%r12+0x6f],0x1
	bclr	[%r12],0x1
__LX117:				; __L117:
	ret
	.align	1
SeqPortaExecN:
;	.frame	%sp,4,$31		# vars= 0, regs= 1/0, args= 0, extra= 0
;	.mask	0x80000000,-4
;	.fmask	0x00000000,0
	ext	0x20		; 	xld.w	%r10,[%r12+0x20]
	ld.w	%r10,[%r12]
	ext	0x60		; 	xld.w	%r11,[%r12+0x60]
	ld.w	%r11,[%r12]
	sub	%r10,%r11
	ext	0x20		; 	xld.w	[%r12+0x20],%r10
	ld.w	[%r12],%r10
	jrgt	__LX119		; 	xjrgt	__L119
	ld.w	%r13,0x0
	ext	0x20		; 	xld.w	[%r12+0x20],%r13
	ld.w	[%r12],%r13
	ext	0x6f		; 	xbclr	[%r12+0x6f],0x1
	bclr	[%r12],0x1
__LX119:				; __L119:
	ret
	.align	1
SeqNote:
;	.frame	%sp,12,$31		# vars= 0, regs= 3/0, args= 0, extra= 0
;	.mask	0x80030000,-4
;	.fmask	0x00000000,0
	pushn	%r1
	ld.w	%r0,%r12
	ld.w	%r1,%r13
	ext	0x70		; 	xld.b	%r10,[%r0+0x70]
	ld.b	%r10,[%r0]
	ld.w	%r14,%r1
	add	%r14,%r10
	ld.w	%r10,%r14
	sll	%r10,0x8	; 	xsll	%r10,8
	ext	0x71		; 	xld.b	%r11,[%r0+0x71]
	ld.b	%r11,[%r0]
	ld.w	%r13,%r10
	add	%r13,%r11
	ext	0x66		; 	xld.uh	%r10,[%r0+0x66]
	ld.uh	%r10,[%r0]
	ext	0x64		; 	xld.h	[%r0+0x64],%r10
	ld.h	[%r0],%r10
	ext	0x6c		; 	xld.w	%r10,[%r0+0x6c]
	ld.w	%r10,[%r0]
	ext	0x100		; 	xand	%r10,%r10,0x080000ff
	ext	0x3
	and	%r10,0x3f
	ext	0x100		; 	xcmp	%r10,134217730
	ext	0x0
	cmp	%r10,0x2
	jrne	__LX121		; 	xjrne	__L121
	ext	NotePitch@rm	; 	xcall	NotePitch
	call	NotePitch@rl
	jp	__LX122		; 	xjp	__L122
__LX121:				; __L121:
	ld.w	%r12,%r0
	ext	NoteOn@rm	; 	xcall	NoteOn
	call	NoteOn@rl
	ld.w	%r10,0x2	; 	xld.w	%r10,0x00000002		; 2
	ext	0x6c		; 	xld.b	[%r0+0x6c],%r10
	ld.b	[%r0],%r10
__LX122:				; __L122:
	ext	0x6f		; 	xld.ub	%r11,[%r0+0x6f]
	ld.ub	%r11,[%r0]
	ld.w	%r10,%r11
	and	%r10,0xc	; 	xand	%r10,%r10,0x0000000c
	cmp	%r10,0x8	; 	xcmp	%r10,8
	jrne	__LX123		; 	xjrne	__L123
	ld.w	%r10,%r11
	ext	0x3		; 	xand	%r10,%r10,0x000000f7
	and	%r10,0x37
	ext	0x6f		; 	xld.b	[%r0+0x6f],%r10
	ld.b	[%r0],%r10
__LX123:				; __L123:
	ext	0x6f		; 	xbtst	[%r0+0x6f],0x0
	btst	[%r0],0x0
	jreq	__LX124		; 	xjreq	__L124
	ext	0x72		; 	xld.b	%r11,[%r0+0x72]
	ld.b	%r11,[%r0]
	cmp	%r11,0x0
	jrne	__LX125		; 	xjrne	__L125
	ext	0x73		; 	xld.b	%r10,[%r0+0x73]
	ld.b	%r10,[%r0]
	ld.w	%r11,%r10
	sub	%r11,%r1
__LX125:				; __L125:
	ld.w	%r10,%r11
	sll	%r10,0x8	; 	xsll	%r10,18
	sll	%r10,0x8
	sll	%r10,0x2
	ext	0x20		; 	xld.w	[%r0+0x20],%r10
	ld.w	[%r0],%r10
	ext	SeqPortaExecN+0x0@h	; 	xld.w	%r10,SeqPortaExecN
	ext	SeqPortaExecN+0x0@m
	ld.w	%r10,SeqPortaExecN+0x0@l
	cmp	%r11,0x0
	jrge	__LX126		; 	xjrge	__L126
	ext	SeqPortaExecP+0x0@h	; 	xld.w	%r10,SeqPortaExecP
	ext	SeqPortaExecP+0x0@m
	ld.w	%r10,SeqPortaExecP+0x0@l
__LX126:				; __L126:
	ext	0x74		; 	xld.w	[%r0+0x74],%r10
	ld.w	[%r0],%r10
	ext	0x6f		; 	xbset	[%r0+0x6f],0x1
	bset	[%r0],0x1
__LX124:				; __L124:
	ext	0x73		; 	xld.b	[%r0+0x73],%r1
	ld.b	[%r0],%r1
	ld.w	%r11,0x0
	ext	0x6e		; 	xbtst	[%r0+0x6e],0x1
	btst	[%r0],0x1
	jrne	__LX128		; 	xjrne	__L128
	ext	0x66		; 	xld.h	%r12,[%r0+0x66]
	ld.h	%r12,[%r0]
	ext	0x6a		; 	xld.h	%r10,[%r0+0x6a]
	ld.h	%r10,[%r0]
	mlt.w	%r12,%r10
	ld.w	%r11,%alr
	sra	%r11,0x8	; 	xsra	%r11,12
	sra	%r11,0x4
	jrgt	__LX129		; 	xjrgt	__L129
	ld.w	%r11,0x1	; 	xld.w	%r11,0x00000001		; 1
__LX129:				; __L129:
	ext	0x1		; 	xsub	%r10,%r12,1
	sub	%r10,%r12
	cmp	%r11,%r10
	jrle	__LX128		; 	xjrle	__L128
	ld.w	%r11,%r10
__LX128:				; __L128:
	ext	0x68		; 	xld.h	[%r0+0x68],%r11
	ld.h	[%r0],%r11
	popn	%r1
	ret
	.align	1
SeqNote2:
;	.frame	%sp,4,$31		# vars= 0, regs= 1/0, args= 0, extra= 0
;	.mask	0x80000000,-4
;	.fmask	0x00000000,0
	ext	0x5c		; 	xld.w	%r11,[%r12+0x5c]
	ld.w	%r11,[%r12]
	ext	0x1		; 	xadd	%r10,%r11,1
	add	%r10,%r11
	ext	0x5c		; 	xld.w	[%r12+0x5c],%r10
	ld.w	[%r12],%r10
	ld.ub	%r13,[%r11]	; 	xld.ub	%r13,[%r11]
	ext	0x1		; 	xcmp	%r13,127
	cmp	%r13,0x3f
	jrle	__LX132		; 	xjrle	__L132
	ext	0x1		; 	xsub	%r13,%r13,116
	sub	%r13,0x34
__LX132:				; __L132:
	call	SeqNote		; 	xcall	SeqNote
	ret
	.align	1
SeqDrums:
;	.frame	%sp,20,$31		# vars= 8, regs= 3/0, args= 0, extra= 0
;	.mask	0x80030000,-4
;	.fmask	0x00000000,0
	pushn	%r1
	sub	%sp,0x2		; 	xsub	%sp,%sp,8
	ld.w	%r1,%r12
	ext	0x6d		; 	xld.ub	%r0,[%r1+0x6d]
	ld.ub	%r0,[%r1]
	sll	%r13,0x1	; 	xsll	%r13,1
	ext	drumsbase+0x0@ah	; 	xld.w	%r12,[drumsbase]
	ext	drumsbase+0x0@al
	ld.w	%r12,[%r8]
	add	%r12,%r13
	ext	getadrs@rm	; 	xcall	getadrs
	call	getadrs@rl
	ld.w	%r11,%r0
	sll	%r11,0x1	; 	xsll	%r11,1
	add	%r11,%r1
	ld.w	%r12,0x1	; 	xld.w	%r12,0x00000001		; 1
	ext	0x78		; 	xld.h	[%r11+0x78],%r12
	ld.h	[%r11],%r12
	add	%r0,0x1		; 	xadd	%r0,%r0,1
	ld.w	%r11,%r0
	sll	%r11,0x1	; 	xsll	%r11,1
	add	%r11,%r1
	ext	datatop+0x0@ah	; 	xld.w	%r13,[datatop]
	ext	datatop+0x0@al
	ld.w	%r13,[%r8]
	ext	0x5c		; 	xld.uh	%r12,[%r1+0x5c]
	ld.uh	%r12,[%r1]
	sub	%r12,%r13
	ext	0x78		; 	xld.h	[%r11+0x78],%r12
	ld.h	[%r11],%r12
	add	%r0,0x1		; 	xadd	%r0,%r0,1
	ld.w	%r11,%r0
	sll	%r11,0x1	; 	xsll	%r11,1
	add	%r11,%r1
	ext	0x78		; 	xld.h	[%r11+0x78],%r10
	ld.h	[%r11],%r10
	add	%r0,0x1		; 	xadd	%r0,%r0,1
	add	%r13,%r10
	ext	0x5c		; 	xld.w	[%r1+0x5c],%r13
	ld.w	[%r1],%r13
	ext	0x6d		; 	xld.b	[%r1+0x6d],%r0
	ld.b	[%r1],%r0
	add	%sp,0x2		; 	xadd	%sp,%sp,8
	popn	%r1
	ret
	.align	1
SeqRest:
;	.frame	%sp,8,$31		# vars= 0, regs= 2/0, args= 0, extra= 0
;	.mask	0x80010000,-4
;	.fmask	0x00000000,0
	pushn	%r0
	ld.w	%r0,%r12
	ext	0x6c		; 	xld.ub	%r10,[%r0+0x6c]
	ld.ub	%r10,[%r0]
	cmp	%r10,0x2	; 	xcmp	%r10,2
	jrne	__LX135		; 	xjrne	__L135
	ext	NoteOff@rm	; 	xcall	NoteOff
	call	NoteOff@rl
	ld.w	%r10,0x1	; 	xld.w	%r10,0x00000001		; 1
	ext	0x6c		; 	xld.b	[%r0+0x6c],%r10
	ld.b	[%r0],%r10
__LX135:				; __L135:
	ext	0x66		; 	xld.uh	%r10,[%r0+0x66]
	ld.uh	%r10,[%r0]
	ext	0x64		; 	xld.h	[%r0+0x64],%r10
	ld.h	[%r0],%r10
	popn	%r0
	ret
	.align	1
SeqInst:
;	.frame	%sp,4,$31		# vars= 0, regs= 1/0, args= 0, extra= 0
;	.mask	0x80000000,-4
;	.fmask	0x00000000,0
	ext	0x5c		; 	xld.w	%r11,[%r12+0x5c]
	ld.w	%r11,[%r12]
	ext	0x1		; 	xadd	%r10,%r11,1
	add	%r10,%r11
	ext	0x5c		; 	xld.w	[%r12+0x5c],%r10
	ld.w	[%r12],%r10
	ld.ub	%r13,[%r11]	; 	xld.ub	%r13,[%r11]
	ext	SetInst@rm	; 	xcall	SetInst
	call	SetInst@rl
	ret
	.align	1
SeqTempo:
;	.frame	%sp,4,$31		# vars= 0, regs= 1/0, args= 0, extra= 0
;	.mask	0x80000000,-4
;	.fmask	0x00000000,0
	ext	0x5c		; 	xld.w	%r11,[%r12+0x5c]
	ld.w	%r11,[%r12]
	ext	0x1		; 	xadd	%r10,%r11,1
	add	%r10,%r11
	ext	0x5c		; 	xld.w	[%r12+0x5c],%r10
	ld.w	[%r12],%r10
	ld.ub	%r10,[%r11]	; 	xld.ub	%r10,[%r11]
	sll	%r10,0x4	; 	xsll	%r10,4
	ext	tempo+0x0@ah	; 	xld.h	[tempo],%r10
	ext	tempo+0x0@al
	ld.h	[%r8],%r10
	ret
	.align	1
SeqEnd:
;	.frame	%sp,4,$31		# vars= 0, regs= 1/0, args= 0, extra= 0
;	.mask	0x80000000,-4
;	.fmask	0x00000000,0
	ext	0x6d		; 	xld.ub	%r14,[%r12+0x6d]
	ld.ub	%r14,[%r12]
	cmp	%r14,0x0
	jrne	__LX139		; 	xjrne	__L139
	ld.w	%r15,0x0
	ext	0x6c		; 	xld.b	[%r12+0x6c],%r15
	ld.b	[%r12],%r15
	jp	__LX138		; 	xjp	__L138
__LX139:				; __L139:
	sub	%r14,0x3	; 	xsub	%r14,%r14,3
	ld.w	%r10,%r14
	sll	%r10,0x1	; 	xsll	%r10,1
	ld.w	%r13,%r10
	add	%r13,%r12
	ext	0x78		; 	xadd	%r11,%r13,120
	add	%r11,%r13
	ld.uh	%r10,[%r11]	; 	xld.uh	%r10,[%r11]
	sub	%r10,0x1	; 	xsub	%r10,%r10,1
	ld.h	[%r11],%r10	; 	xld.h	[%r11],%r10
	ld.uh	%r10,%r10
	cmp	%r10,0x0
	jreq	__LX140		; 	xjreq	__L140
	ext	0x7c		; 	xld.uh	%r11,[%r13+0x7c]
	ld.uh	%r11,[%r13]
	ext	datatop+0x0@ah	; 	xld.w	%r10,[datatop]
	ext	datatop+0x0@al
	ld.w	%r10,[%r8]
	add	%r10,%r11
	ext	0x5c		; 	xld.w	[%r12+0x5c],%r10
	ld.w	[%r12],%r10
	jp	__LX138		; 	xjp	__L138
__LX140:				; __L140:
	ext	0x7a		; 	xld.uh	%r11,[%r13+0x7a]
	ld.uh	%r11,[%r13]
	ext	datatop+0x0@ah	; 	xld.w	%r10,[datatop]
	ext	datatop+0x0@al
	ld.w	%r10,[%r8]
	add	%r10,%r11
	ext	0x5c		; 	xld.w	[%r12+0x5c],%r10
	ld.w	[%r12],%r10
	ext	0x6d		; 	xld.b	[%r12+0x6d],%r14
	ld.b	[%r12],%r14
__LX138:				; __L138:
	ret
	.align	1
SeqGate:
;	.frame	%sp,4,$31		# vars= 0, regs= 1/0, args= 0, extra= 0
;	.mask	0x80000000,-4
;	.fmask	0x00000000,0
	ext	0x5c		; 	xld.w	%r11,[%r12+0x5c]
	ld.w	%r11,[%r12]
	ext	0x1		; 	xadd	%r10,%r11,1
	add	%r10,%r11
	ext	0x5c		; 	xld.w	[%r12+0x5c],%r10
	ld.w	[%r12],%r10
	ld.ub	%r11,[%r11]	; 	xld.ub	%r11,[%r11]
	ext	0x1		; 	xld.w	%r10,0x00000064		; 100
	ld.w	%r10,0x24
	sub	%r10,%r11
	ext	0x0		; 	xld.w	%r11,0x00000029		; 41
	ld.w	%r11,0x29
	mlt.w	%r10,%r11
	ld.w	%r13,%alr
	ext	0x6a		; 	xld.h	[%r12+0x6a],%r13
	ld.h	[%r12],%r13
	ret
	.align	1
SeqJump:
;	.frame	%sp,8,$31		# vars= 0, regs= 2/0, args= 0, extra= 0
;	.mask	0x80010000,-4
;	.fmask	0x00000000,0
	pushn	%r0
	ld.w	%r0,%r12
	ext	0x5c		; 	xld.w	%r12,[%r0+0x5c]
	ld.w	%r12,[%r0]
	ext	getadrs@rm	; 	xcall	getadrs
	call	getadrs@rl
	ext	datatop+0x0@ah	; 	xld.w	%r11,[datatop]
	ext	datatop+0x0@al
	ld.w	%r11,[%r8]
	add	%r11,%r10
	ext	0x5c		; 	xld.w	[%r0+0x5c],%r11
	ld.w	[%r0],%r11
	popn	%r0
	ret
	.align	1
SeqCall:
;	.frame	%sp,20,$31		# vars= 8, regs= 3/0, args= 0, extra= 0
;	.mask	0x80030000,-4
;	.fmask	0x00000000,0
	pushn	%r1
	sub	%sp,0x2		; 	xsub	%sp,%sp,8
	ld.w	%r1,%r12
	ext	0x6d		; 	xld.ub	%r0,[%r1+0x6d]
	ld.ub	%r0,[%r1]
	ext	0x5c		; 	xld.w	%r12,[%r1+0x5c]
	ld.w	%r12,[%r1]
	ext	getadrs@rm	; 	xcall	getadrs
	call	getadrs@rl
	ld.w	%r11,%r0
	sll	%r11,0x1	; 	xsll	%r11,1
	add	%r11,%r1
	ext	0x5c		; 	xld.w	%r12,[%r1+0x5c]
	ld.w	%r12,[%r1]
	ext	0x2		; 	xld.ub	%r12,[%r12+0x2]
	ld.ub	%r12,[%r12]
	ext	0x78		; 	xld.h	[%r11+0x78],%r12
	ld.h	[%r11],%r12
	add	%r0,0x1		; 	xadd	%r0,%r0,1
	ld.w	%r12,%r0
	sll	%r12,0x1	; 	xsll	%r12,1
	add	%r12,%r1
	ext	datatop+0x0@ah	; 	xld.w	%r13,[datatop]
	ext	datatop+0x0@al
	ld.w	%r13,[%r8]
	ext	0x3		; 	xsub	%r11,%r13,3
	sub	%r11,%r13
	ext	0x5c		; 	xld.uh	%r14,[%r1+0x5c]
	ld.uh	%r14,[%r1]
	sub	%r14,%r11
	ld.w	%r11,%r14
	ext	0x78		; 	xld.h	[%r12+0x78],%r11
	ld.h	[%r12],%r11
	add	%r0,0x1		; 	xadd	%r0,%r0,1
	ld.w	%r11,%r0
	sll	%r11,0x1	; 	xsll	%r11,1
	add	%r11,%r1
	ext	0x78		; 	xld.h	[%r11+0x78],%r10
	ld.h	[%r11],%r10
	add	%r0,0x1		; 	xadd	%r0,%r0,1
	add	%r13,%r10
	ext	0x5c		; 	xld.w	[%r1+0x5c],%r13
	ld.w	[%r1],%r13
	ext	0x6d		; 	xld.b	[%r1+0x6d],%r0
	ld.b	[%r1],%r0
	add	%sp,0x2		; 	xadd	%sp,%sp,8
	popn	%r1
	ret
	.align	1
SeqRept:
;	.frame	%sp,12,$31		# vars= 8, regs= 1/0, args= 0, extra= 0
;	.mask	0x80000000,-4
;	.fmask	0x00000000,0
	sub	%sp,0x2		; 	xsub	%sp,%sp,8
	ext	0x6d		; 	xld.ub	%r13,[%r12+0x6d]
	ld.ub	%r13,[%r12]
	ld.w	%r11,%r13
	sll	%r11,0x1	; 	xsll	%r11,1
	add	%r11,%r12
	ext	0x5c		; 	xld.w	%r14,[%r12+0x5c]
	ld.w	%r14,[%r12]
	ext	0x1		; 	xadd	%r10,%r14,1
	add	%r10,%r14
	ext	0x5c		; 	xld.w	[%r12+0x5c],%r10
	ld.w	[%r12],%r10
	ld.ub	%r10,[%r14]	; 	xld.ub	%r10,[%r14]
	ext	0x78		; 	xld.h	[%r11+0x78],%r10
	ld.h	[%r11],%r10
	add	%r13,0x1	; 	xadd	%r13,%r13,1
	ld.w	%r10,%r13
	sll	%r10,0x1	; 	xsll	%r10,1
	add	%r10,%r12
	ext	0x5c		; 	xld.uh	%r11,[%r12+0x5c]
	ld.uh	%r11,[%r12]
	ext	datatop+0x0@ah	; 	xld.uh	%r15,[datatop]
	ext	datatop+0x0@al
	ld.uh	%r15,[%r8]
	sub	%r11,%r15
	ext	0x78		; 	xld.h	[%r10+0x78],%r11
	ld.h	[%r10],%r11
	add	%r13,0x1	; 	xadd	%r13,%r13,1
	ld.w	%r10,%r13
	sll	%r10,0x1	; 	xsll	%r10,1
	add	%r10,%r12
	ld.w	%r15,0x0
	ext	0x78		; 	xld.h	[%r10+0x78],%r15
	ld.h	[%r10],%r15
	add	%r13,0x1	; 	xadd	%r13,%r13,1
	ext	0x6d		; 	xld.b	[%r12+0x6d],%r13
	ld.b	[%r12],%r13
	add	%sp,0x2		; 	xadd	%sp,%sp,8
	ret
	.align	1
SeqNext:
;	.frame	%sp,4,$31		# vars= 0, regs= 1/0, args= 0, extra= 0
;	.mask	0x80000000,-4
;	.fmask	0x00000000,0
	ext	0x6d		; 	xld.ub	%r10,[%r12+0x6d]
	ld.ub	%r10,[%r12]
	ext	0x3		; 	xsub	%r14,%r10,3
	sub	%r14,%r10
	ld.w	%r10,%r14
	sll	%r10,0x1	; 	xsll	%r10,1
	ld.w	%r13,%r10
	add	%r13,%r12
	ext	0x78		; 	xadd	%r11,%r13,120
	add	%r11,%r13
	ld.uh	%r10,[%r11]	; 	xld.uh	%r10,[%r11]
	sub	%r10,0x1	; 	xsub	%r10,%r10,1
	ld.h	[%r11],%r10	; 	xld.h	[%r11],%r10
	ld.uh	%r10,%r10
	cmp	%r10,0x0
	jreq	__LX147		; 	xjreq	__L147
	ext	datatop+0x0@ah	; 	xld.w	%r10,[datatop]
	ext	datatop+0x0@al
	ld.w	%r10,[%r8]
	ext	0x5c		; 	xld.uh	%r11,[%r12+0x5c]
	ld.uh	%r11,[%r12]
	sub	%r11,%r10
	ext	0x7c		; 	xld.h	[%r13+0x7c],%r11
	ld.h	[%r13],%r11
	ext	0x7a		; 	xld.uh	%r11,[%r13+0x7a]
	ld.uh	%r11,[%r13]
	add	%r10,%r11
	ext	0x5c		; 	xld.w	[%r12+0x5c],%r10
	ld.w	[%r12],%r10
	jp	__LX148		; 	xjp	__L148
__LX147:				; __L147:
	ext	0x6d		; 	xld.b	[%r12+0x6d],%r14
	ld.b	[%r12],%r14
__LX148:				; __L148:
	ret
	.align	1
SeqBreak:
;	.frame	%sp,4,$31		# vars= 0, regs= 1/0, args= 0, extra= 0
;	.mask	0x80000000,-4
;	.fmask	0x00000000,0
	ext	0x6d		; 	xld.ub	%r10,[%r12+0x6d]
	ld.ub	%r10,[%r12]
	ext	0x3		; 	xsub	%r13,%r10,3
	sub	%r13,%r10
	ld.w	%r10,%r13
	sll	%r10,0x1	; 	xsll	%r10,1
	ld.w	%r11,%r10
	add	%r11,%r12
	ext	0x78		; 	xld.uh	%r10,[%r11+0x78]
	ld.uh	%r10,[%r11]
	cmp	%r10,0x1	; 	xcmp	%r10,1
	jrne	__LX150		; 	xjrne	__L150
	ext	0x7c		; 	xld.uh	%r11,[%r11+0x7c]
	ld.uh	%r11,[%r11]
	ext	datatop+0x0@ah	; 	xld.w	%r10,[datatop]
	ext	datatop+0x0@al
	ld.w	%r10,[%r8]
	add	%r10,%r11
	ext	0x5c		; 	xld.w	[%r12+0x5c],%r10
	ld.w	[%r12],%r10
	ext	0x6d		; 	xld.b	[%r12+0x6d],%r13
	ld.b	[%r12],%r13
__LX150:				; __L150:
	ret
	.align	1
SeqTrs:
;	.frame	%sp,4,$31		# vars= 0, regs= 1/0, args= 0, extra= 0
;	.mask	0x80000000,-4
;	.fmask	0x00000000,0
	ext	0x5c		; 	xld.w	%r11,[%r12+0x5c]
	ld.w	%r11,[%r12]
	ext	0x1		; 	xadd	%r10,%r11,1
	add	%r10,%r11
	ext	0x5c		; 	xld.w	[%r12+0x5c],%r10
	ld.w	[%r12],%r10
	ld.ub	%r10,[%r11]	; 	xld.ub	%r10,[%r11]
	ext	0x70		; 	xld.b	[%r12+0x70],%r10
	ld.b	[%r12],%r10
	ret
	.align	1
SeqEnv:
;	.frame	%sp,12,$31		# vars= 0, regs= 2/0, args= 4, extra= 0
;	.mask	0x80010000,-4
;	.fmask	0x00000000,0
	pushn	%r0
	sub	%sp,0x1		; 	xsub	%sp,%sp,4
	ld.w	%r0,%r12
	ext	0x5c		; 	xld.w	%r10,[%r0+0x5c]
	ld.w	%r10,[%r0]
	ld.ub	%r13,[%r10]	; 	xld.ub	%r13,[%r10]
	ext	0x1		; 	xld.ub	%r14,[%r10+0x1]
	ld.ub	%r14,[%r10]
	ext	0x2		; 	xld.ub	%r15,[%r10+0x2]
	ld.ub	%r15,[%r10]
	ext	0x3		; 	xld.ub	%r10,[%r10+0x3]
	ld.ub	%r10,[%r10]
	ld.w	[%sp+0x0],%r10	; 	xld.w	[%sp],%r10
	ext	SetEnv@rm	; 	xcall	SetEnv
	call	SetEnv@rl
	ext	0x5c		; 	xld.w	%r10,[%r0+0x5c]
	ld.w	%r10,[%r0]
	add	%r10,0x4	; 	xadd	%r10,%r10,4
	ext	0x5c		; 	xld.w	[%r0+0x5c],%r10
	ld.w	[%r0],%r10
	add	%sp,0x1		; 	xadd	%sp,%sp,4
	popn	%r0
	ret
	.align	1
SeqVol:
;	.frame	%sp,4,$31		# vars= 0, regs= 1/0, args= 0, extra= 0
;	.mask	0x80000000,-4
;	.fmask	0x00000000,0
	ext	0x5c		; 	xld.w	%r11,[%r12+0x5c]
	ld.w	%r11,[%r12]
	ext	0x1		; 	xadd	%r10,%r11,1
	add	%r10,%r11
	ext	0x5c		; 	xld.w	[%r12+0x5c],%r10
	ld.w	[%r12],%r10
	ld.ub	%r13,[%r11]	; 	xld.ub	%r13,[%r11]
	ext	SetVol@rm	; 	xcall	SetVol
	call	SetVol@rl
	ret
	.align	1
SeqDtn:
;	.frame	%sp,4,$31		# vars= 0, regs= 1/0, args= 0, extra= 0
;	.mask	0x80000000,-4
;	.fmask	0x00000000,0
	ext	0x5c		; 	xld.w	%r11,[%r12+0x5c]
	ld.w	%r11,[%r12]
	ext	0x1		; 	xadd	%r10,%r11,1
	add	%r10,%r11
	ext	0x5c		; 	xld.w	[%r12+0x5c],%r10
	ld.w	[%r12],%r10
	ld.ub	%r10,[%r11]	; 	xld.ub	%r10,[%r11]
	ext	0x71		; 	xld.b	[%r12+0x71],%r10
	ld.b	[%r12],%r10
	ret
	.align	1
SeqPortaPara:
;	.frame	%sp,8,$31		# vars= 0, regs= 2/0, args= 0, extra= 0
;	.mask	0x80010000,-4
;	.fmask	0x00000000,0
	pushn	%r0
	ld.w	%r0,%r12
	ext	0x5c		; 	xld.w	%r11,[%r0+0x5c]
	ld.w	%r11,[%r0]
	ext	0x1		; 	xadd	%r10,%r11,1
	add	%r10,%r11
	ext	0x5c		; 	xld.w	[%r0+0x5c],%r10
	ld.w	[%r0],%r10
	ld.ub	%r10,[%r11]	; 	xld.ub	%r10,[%r11]
	ext	0x72		; 	xld.b	[%r0+0x72],%r10
	ld.b	[%r0],%r10
	ext	0x5c		; 	xld.w	%r11,[%r0+0x5c]
	ld.w	%r11,[%r0]
	ext	0x1		; 	xadd	%r10,%r11,1
	add	%r10,%r11
	ext	0x5c		; 	xld.w	[%r0+0x5c],%r10
	ld.w	[%r0],%r10
	ld.ub	%r11,[%r11]	; 	xld.ub	%r11,[%r11]
	ext	0x3		; 	xld.w	%r10,0x000000c0		; 192
	ld.w	%r10,0x0
	mlt.w	%r11,%r10
	ld.w	%r11,%alr
	ext	0x1		; 	xadd	%r12,%r11,15360
	ext	0x1c00
	add	%r12,%r11
	ext	gexp@rm		; 	xcall	gexp
	call	gexp@rl
	sll	%r10,0x8	; 	xsll	%r10,10
	sll	%r10,0x2
	ext	0x60		; 	xld.w	[%r0+0x60],%r10
	ld.w	[%r0],%r10
	ext	tempo+0x0@ah	; 	xld.h	%r11,[tempo]
	ext	tempo+0x0@al
	ld.h	%r11,[%r8]
	mlt.w	%r10,%r11
	ld.w	%r10,%alr
	ext	0x60		; 	xld.w	[%r0+0x60],%r10
	ld.w	[%r0],%r10
	ld.w	%r12,%r10
	ext	0x4e		; 	xld.w	%r13,0x00001388		; 5000
	ld.w	%r13,0x8
	ext	__divsi3@rm	; 	xcall	__divsi3
	call	__divsi3@rl
	ext	0x60		; 	xld.w	[%r0+0x60],%r10
	ld.w	[%r0],%r10
	popn	%r0
	ret
	.align	1
SeqPortaOn:
;	.frame	%sp,4,$31		# vars= 0, regs= 1/0, args= 0, extra= 0
;	.mask	0x80000000,-4
;	.fmask	0x00000000,0
	ext	0x6f		; 	xbset	[%r12+0x6f],0x0
	bset	[%r12],0x0
	ret
	.align	1
SeqPortaOff:
;	.frame	%sp,4,$31		# vars= 0, regs= 1/0, args= 0, extra= 0
;	.mask	0x80000000,-4
;	.fmask	0x00000000,0
	ext	0x6f		; 	xld.ub	%r10,[%r12+0x6f]
	ld.ub	%r10,[%r12]
	ext	0x3		; 	xand	%r10,%r10,0x000000fc
	and	%r10,0x3c
	ext	0x6f		; 	xld.b	[%r12+0x6f],%r10
	ld.b	[%r12],%r10
	ld.w	%r11,0x0
	ext	0x20		; 	xld.w	[%r12+0x20],%r11
	ld.w	[%r12],%r11
	ret
	.align	1
SeqTatt:
;	.frame	%sp,4,$31		# vars= 0, regs= 1/0, args= 0, extra= 0
;	.mask	0x80000000,-4
;	.fmask	0x00000000,0
	ext	0x5c		; 	xld.w	%r11,[%r12+0x5c]
	ld.w	%r11,[%r12]
	ext	0x1		; 	xadd	%r10,%r11,1
	add	%r10,%r11
	ext	0x5c		; 	xld.w	[%r12+0x5c],%r10
	ld.w	[%r12],%r10
	ld.ub	%r10,[%r11]	; 	xld.ub	%r10,[%r11]
	ext	0x6e		; 	xld.b	[%r12+0x6e],%r10
	ld.b	[%r12],%r10
	ret
	.align	1
SeqVibrato:
;	.frame	%sp,12,$31		# vars= 0, regs= 2/0, args= 4, extra= 0
;	.mask	0x80010000,-4
;	.fmask	0x00000000,0
	pushn	%r0
	sub	%sp,0x1		; 	xsub	%sp,%sp,4
	ld.w	%r0,%r12
	ext	0x5c		; 	xld.w	%r10,[%r0+0x5c]
	ld.w	%r10,[%r0]
	ld.ub	%r13,[%r10]	; 	xld.ub	%r13,[%r10]
	ext	0x1		; 	xld.ub	%r14,[%r10+0x1]
	ld.ub	%r14,[%r10]
	ext	0x2		; 	xld.ub	%r15,[%r10+0x2]
	ld.ub	%r15,[%r10]
	ext	0x3		; 	xld.ub	%r10,[%r10+0x3]
	ld.ub	%r10,[%r10]
	ld.w	[%sp+0x0],%r10	; 	xld.w	[%sp],%r10
	ext	SetVib@rm	; 	xcall	SetVib
	call	SetVib@rl
	ext	0x5c		; 	xld.w	%r10,[%r0+0x5c]
	ld.w	%r10,[%r0]
	add	%r10,0x4	; 	xadd	%r10,%r10,4
	ext	0x5c		; 	xld.w	[%r0+0x5c],%r10
	ld.w	[%r0],%r10
	add	%sp,0x1		; 	xadd	%sp,%sp,4
	popn	%r0
	ret
	.align	1
SeqLegOn:
;	.frame	%sp,4,$31		# vars= 0, regs= 1/0, args= 0, extra= 0
;	.mask	0x80000000,-4
;	.fmask	0x00000000,0
	ext	0x6f		; 	xld.ub	%r10,[%r12+0x6f]
	ld.ub	%r10,[%r12]
	or	%r10,0xc	; 	xoor	%r10,%r10,0x0000000c
	ext	0x6f		; 	xld.b	[%r12+0x6f],%r10
	ld.b	[%r12],%r10
	ret
	.align	1
SeqLegOff:
;	.frame	%sp,4,$31		# vars= 0, regs= 1/0, args= 0, extra= 0
;	.mask	0x80000000,-4
;	.fmask	0x00000000,0
	ext	0x6f		; 	xbclr	[%r12+0x6f],0x2
	bclr	[%r12],0x2
	ret
	.align	1
SeqExp:
;	.frame	%sp,4,$31		# vars= 0, regs= 1/0, args= 0, extra= 0
;	.mask	0x80000000,-4
;	.fmask	0x00000000,0
	ext	0x5c		; 	xld.w	%r11,[%r12+0x5c]
	ld.w	%r11,[%r12]
	ext	0x1		; 	xadd	%r10,%r11,1
	add	%r10,%r11
	ext	0x5c		; 	xld.w	[%r12+0x5c],%r10
	ld.w	[%r12],%r10
	ld.ub	%r13,[%r11]	; 	xld.ub	%r13,[%r11]
	ext	SetExp@rm	; 	xcall	SetExp
	call	SetExp@rl
	ret
	.align	1
SeqExpRel:
;	.frame	%sp,4,$31		# vars= 0, regs= 1/0, args= 0, extra= 0
;	.mask	0x80000000,-4
;	.fmask	0x00000000,0
	ext	0x5c		; 	xld.w	%r11,[%r12+0x5c]
	ld.w	%r11,[%r12]
	ext	0x1		; 	xadd	%r10,%r11,1
	add	%r10,%r11
	ext	0x5c		; 	xld.w	[%r12+0x5c],%r10
	ld.w	[%r12],%r10
	ld.b	%r13,[%r11]	; 	xld.b	%r13,[%r11]
	ext	SetExpRel@rm	; 	xcall	SetExpRel
	call	SetExpRel@rl
	ret
	.code
	.align	2
SeqCmd:
	.word	SeqRest
	.word	SeqGate
	.word	SeqJump
	.word	SeqCall
	.word	SeqRept
	.word	SeqNext
	.word	SeqTrs
	.word	SeqTempo
	.word	SeqInst
	.word	SeqVol
	.word	SeqEnv
	.word	SeqDtn
	.word	SeqNote2
	.word	SeqPortaPara
	.word	SeqPortaOn
	.word	SeqPortaOff
	.word	SeqTatt
	.word	SeqVibrato
	.word	SeqNop1
	.word	SeqNop2
	.word	SeqNop2
	.word	SeqNop2
	.word	SeqBreak
	.word	SeqNop
	.word	SeqLegOn
	.word	SeqLegOff
	.word	SeqExp
	.word	SeqExpRel
	.word	SeqNop
	.word	SeqNop
	.word	SeqNop
	.word	SeqNop
	.code
	.align	1
ProcSeq:
;	.frame	%sp,20,$31		# vars= 0, regs= 5/0, args= 0, extra= 0
;	.mask	0x800f0000,-4
;	.fmask	0x00000000,0
	pushn	%r3
	ld.w	%r1,0x0
__LX168:				; __L168:
	ext	0x2		; 	xld.w	%r10,0x000000a8		; 168
	ld.w	%r10,0x28
	mlt.w	%r1,%r10
	ext	seqwk+0x0@h	; 	xld.w	%r10,seqwk
	ext	seqwk+0x0@m
	ld.w	%r10,seqwk+0x0@l
	ld.w	%r12,%alr
	add	%r12,%r10
	ext	0x6c		; 	xld.ub	%r10,[%r12+0x6c]
	ld.ub	%r10,[%r12]
	cmp	%r10,0x0
	jreq	__LX167		; 	xjreq	__L167
	ext	0x6f		; 	xbtst	[%r12+0x6f],0x1
	btst	[%r12],0x1
	jreq	__LX167		; 	xjreq	__L167
	ext	0x74		; 	xld.w	%r10,[%r12+0x74]
	ld.w	%r10,[%r12]
	call	%r10
__LX167:				; __L167:
	add	%r1,0x1		; 	xadd	%r1,%r1,1
	cmp	%r1,0x5		; 	xcmp	%r1,5
	jrle	__LX168		; 	xjrle	__L168
	ext	tempowk+0x0@ah	; 	xld.uh	%r11,[tempowk]
	ext	tempowk+0x0@al
	ld.uh	%r11,[%r8]
	ext	tempo+0x0@ah	; 	xld.uh	%r14,[tempo]
	ext	tempo+0x0@al
	ld.uh	%r14,[%r8]
	sub	%r11,%r14
	ld.w	%r10,%r11
	ext	tempowk+0x0@ah	; 	xld.h	[tempowk],%r10
	ext	tempowk+0x0@al
	ld.h	[%r8],%r10
	ld.h	%r10,%r10
	cmp	%r10,0x0
	jrge	__LX164		; 	xjrge	__L164
	ext	0x1388		; 	xadd	%r10,%r11,5000
	add	%r10,%r11
	ext	tempowk+0x0@ah	; 	xld.h	[tempowk],%r10
	ext	tempowk+0x0@al
	ld.h	[%r8],%r10
	ld.w	%r14,0x0
	ext	runf+0x0@ah	; 	xld.b	[runf],%r14
	ext	runf+0x0@al
	ld.b	[%r8],%r14
	ld.w	%r1,0x0
	ld.w	%r3,0x1		; 	xld.w	%r3,0x00000001		; 1
	ext	0x1		; 	xld.w	%r2,0x0000007f		; 127
	ld.w	%r2,0x3f
__LX176:				; __L176:
	ext	0x2		; 	xld.w	%r10,0x000000a8		; 168
	ld.w	%r10,0x28
	mlt.w	%r1,%r10
	ext	seqwk+0x0@h	; 	xld.w	%r10,seqwk
	ext	seqwk+0x0@m
	ld.w	%r10,seqwk+0x0@l
	ld.w	%r0,%alr
	add	%r0,%r10
	ext	0x6c		; 	xld.ub	%r10,[%r0+0x6c]
	ld.ub	%r10,[%r0]
	cmp	%r10,0x0
	jreq	__LX175		; 	xjreq	__L175
	ext	runf+0x0@ah	; 	xld.b	[runf],%r3
	ext	runf+0x0@al
	ld.b	[%r8],%r3
	ext	0x64		; 	xld.uh	%r10,[%r0+0x64]
	ld.uh	%r10,[%r0]
	sub	%r10,0x1	; 	xsub	%r10,%r10,1
	ext	0x64		; 	xld.h	[%r0+0x64],%r10
	ld.h	[%r0],%r10
	ld.h	%r11,%r10
	cmp	%r11,0x0
	jrgt	__LX178		; 	xjrgt	__L178
__LX179:				; __L179:
	ext	0x5c		; 	xld.w	%r10,[%r0+0x5c]
	ld.w	%r10,[%r0]
	ext	0x1		; 	xadd	%r11,%r10,1
	add	%r11,%r10
	ext	0x5c		; 	xld.w	[%r0+0x5c],%r11
	ld.w	[%r0],%r11
	ld.ub	%r13,[%r10]	; 	xld.ub	%r13,[%r10]
	cmp	%r13,0x0
	jrne	__LX182		; 	xjrne	__L182
	ld.w	%r12,%r0
	ext	SeqEnd@rm	; 	xcall	SeqEnd
	call	SeqEnd@rl
	ext	0x6c		; 	xld.ub	%r10,[%r0+0x6c]
	ld.ub	%r10,[%r0]
	cmp	%r10,0x0
	jreq	__LX175		; 	xjreq	__L175
	jp	__LX181		; 	xjp	__L181
__LX182:				; __L182:
	cmp	%r13,%r2
	jrgt	__LX185		; 	xjrgt	__L185
	jrne	__LX186		; 	xjrne	__L186
	add	%r10,0x2	; 	xadd	%r10,%r10,2
	ext	0x5c		; 	xld.w	[%r0+0x5c],%r10
	ld.w	[%r0],%r10
	ld.ub	%r13,[%r11]	; 	xld.ub	%r13,[%r11]
	ext	0x1		; 	xcmp	%r13,126
	cmp	%r13,0x3e
	jrgt	__LX186		; 	xjrgt	__L186
	ext	0x4		; 	xadd	%r13,%r13,256
	add	%r13,0x0
__LX186:				; __L186:
	ext	0x66		; 	xld.h	[%r0+0x66],%r13
	ld.h	[%r0],%r13
	jp	__LX181		; 	xjp	__L181
__LX185:				; __L185:
	ext	0x3		; 	xcmp	%r13,223
	cmp	%r13,0x1f
	jrgt	__LX189		; 	xjrgt	__L189
	ext	0x6e		; 	xbtst	[%r0+0x6e],0x0
	btst	[%r0],0x0
	jreq	__LX190		; 	xjreq	__L190
	ld.w	%r12,%r0
	ext	0x2		; 	xsub	%r13,%r13,128
	sub	%r13,0x0
	ext	SeqDrums@rm	; 	xcall	SeqDrums
	call	SeqDrums@rl
	jp	__LX181		; 	xjp	__L181
__LX190:				; __L190:
	ld.w	%r12,%r0
	ext	0x1		; 	xsub	%r13,%r13,116
	sub	%r13,0x34
	ext	SeqNote@rm	; 	xcall	SeqNote
	call	SeqNote@rl
	jp	__LX181		; 	xjp	__L181
__LX189:				; __L189:
	ld.w	%r10,%r13
	sll	%r10,0x2	; 	xsll	%r10,2
	ext	SeqCmd-0x380@h	; 	xld.w	%r10,[%r10+SeqCmd-0x380]
	ext	SeqCmd-0x380@m
	ld.w	%r9,SeqCmd-0x380@l
	add	%r9,%r10
	ld.w	%r10,[%r9]
	ld.w	%r12,%r0
	call	%r10
__LX181:				; __L181:
	ext	0x64		; 	xld.h	%r10,[%r0+0x64]
	ld.h	%r10,[%r0]
	cmp	%r10,0x0
	jrle	__LX179		; 	xjrle	__L179
	jp	__LX175		; 	xjp	__L175
__LX178:				; __L178:
	ext	0x6c		; 	xld.ub	%r10,[%r0+0x6c]
	ld.ub	%r10,[%r0]
	cmp	%r10,0x2	; 	xcmp	%r10,2
	jrne	__LX175		; 	xjrne	__L175
	ext	0x68		; 	xld.h	%r10,[%r0+0x68]
	ld.h	%r10,[%r0]
	cmp	%r11,%r10
	jrgt	__LX175		; 	xjrgt	__L175
	ext	0x6f		; 	xbtst	[%r0+0x6f],0x2
	btst	[%r0],0x2
	jrne	__LX175		; 	xjrne	__L175
	ld.w	%r12,%r0
	ext	NoteOff@rm	; 	xcall	NoteOff
	call	NoteOff@rl
	ext	0x6c		; 	xld.b	[%r0+0x6c],%r3
	ld.b	[%r0],%r3
__LX175:				; __L175:
	add	%r1,0x1		; 	xadd	%r1,%r1,1
	cmp	%r1,0x5		; 	xcmp	%r1,5
	jrle	__LX176		; 	xjrle	__L176
__LX164:				; __L164:
	popn	%r3
	ret
; APP

		.code
		.align		1
BuffFree_Mix2:
		;//-------------------------------------------------------------;//
		;//%r12 = wbuff
		;//%r13 = mixbuf
	ext	0x2		; 		xld.w		%r4, 128					;//%r4     := i = BLKS
	ld.w	%r4,0x0
	ext	0x1ff		; 		xld.w		%r5, 32767					;//%r5     := SHRT_MAX
	ld.w	%r5,0x3f
		jp.d		BuffFree_Mix2_START				;//goto START
		not		%r6, %r5					;//%r6     := SHRT_MIN				*delay*		ŕK'%psr(Z)==0'ɂȂ̂ŁAWv'jrne.d'͕򂷂B
BuffFree_Mix2_L1:								;//do {					@@@
		cmp		%r7, %r5					;//  %psr    := x <=> SHRT_MAX		@@@
		jrle.d		3						;//  if(        x   > SHRT_MAX) {	@@@
		 cmp		%r7, %r6					;//  %psr    := x <=> SHRT_MIN		@	*delay*
		 ld.w		%r7, %r5					;//    %r7   := x  =  SHRT_MAX  }	@@
		jrge.d		3						;//  if(        x <   SHRT_MIN) {	@
		 sub		%r4, 1						;//  %r4     := i--			@	*delay*
		 ld.w		%r7, %r6					;//    %r7   := x  =  SHRT_MIN  }	@@
		ld.h		[%r12]+, %r7					;//  *wbuff++ = x			@@
BuffFree_Mix2_START:								;//					@@
		ld.w		%r7, [%r13]+					;//  %r7     := x  =  *mixbuf++		@@			Ō̈̓_~[ƂȂAmixbuf[]̍Ō̗vf̎̃AhXǂݏoĂ܂Bɂ͔zOǂݏoG[AP/ECE
		jrne.d		BuffFree_Mix2_L1				;//} while(   i)			
		sla		%r7, 2						;//  %r7     := x <<= 2		//EhlX()	*delay*		Ō̈̓_~[ƂȂB
		;//-------------------------------------------------------------;//
		ret

; NO_APP
	.align	1
BuffFill:
;	.frame	%sp,528,$31		# vars= 512, regs= 4/0, args= 0, extra= 0
;	.mask	0x80070000,-4
;	.fmask	0x00000000,0
	pushn	%r2
	sub	%sp,0x80	; 	xsub	%sp,%sp,512
	ld.w	%r2,%r12
	ld.w	%r12,%sp
	ld.w	%r13,0x0
	ext	0x8		; 	xld.w	%r14,0x00000200		; 512
	ld.w	%r14,0x0
	ext	memset@rm	; 	xcall	memset
	call	memset@rl
	ext	ProcSeq@rm	; 	xcall	ProcSeq
	call	ProcSeq@rl
	ld.w	%r1,0x0
__LX201:				; __L201:
	ext	0x2		; 	xld.w	%r10,0x000000a8		; 168
	ld.w	%r10,0x28
	mlt.w	%r1,%r10
	ext	seqwk+0x0@h	; 	xld.w	%r10,seqwk
	ext	seqwk+0x0@m
	ld.w	%r10,seqwk+0x0@l
	ld.w	%r12,%alr
	add	%r12,%r10
	ext	0x6c		; 	xld.ub	%r10,[%r12+0x6c]
	ld.ub	%r10,[%r12]
	cmp	%r10,0x0
	jreq	__LX200		; 	xjreq	__L200
	ld.w	%r0,%r12
	ext	0x4		; 	xld.w	%r10,[%r0+0x4]
	ld.w	%r10,[%r0]
	cmp	%r10,0x0
	jreq	__LX200		; 	xjreq	__L200
	ext	0x58		; 	xld.w	%r10,[%r0+0x58]
	ld.w	%r10,[%r0]
	call	%r10
	ext	0x20		; 	xld.w	%r10,[%r0+0x20]
	ld.w	%r10,[%r0]
	sra	%r10,0x8	; 	xsra	%r10,10
	sra	%r10,0x2
	ext	0x1c		; 	xld.w	%r11,[%r0+0x1c]
	ld.w	%r11,[%r0]
	add	%r11,%r10
	ext	0x24		; 	xld.w	%r12,[%r0+0x24]
	ld.w	%r12,[%r0]
	sra	%r12,0x8	; 	xsra	%r12,14
	sra	%r12,0x6
	add	%r11,%r12
	ld.w	%r12,%r11
	ext	gexp@rm		; 	xcall	gexp
	call	gexp@rl
	ext	0x4		; 	xld.w	[%r0+0x4],%r10
	ld.w	[%r0],%r10
	ext	0x54		; 	xld.w	%r10,[%r0+0x54]
	ld.w	%r10,[%r0]
	ld.w	%r12,%r0
	call	%r10
	ext	0x3c		; 	xld.w	%r11,[%r0+0x3c]
	ld.w	%r11,[%r0]
	ext	0x40		; 	xld.w	%r10,[%r0+0x40]
	ld.w	%r10,[%r0]
	add	%r11,%r10
	ext	0x28		; 	xld.w	%r10,[%r0+0x28]
	ld.w	%r10,[%r0]
	ld.w	%r14,%r11
	add	%r14,%r10
	cmp	%r14,0xb	; 	xcmp	%r14,11
	jrgt	__LX204		; 	xjrgt	__L204
	ld.w	%r14,0x0
	jp	__LX205		; 	xjp	__L205
__LX204:				; __L204:
	ld.w	%r12,%r14
	ext	gexp@rm		; 	xcall	gexp
	call	gexp@rl
	ld.w	%r14,%r10
__LX205:				; __L205:
	ext	0x50		; 	xld.w	%r10,[%r0+0x50]
	ld.w	%r10,[%r0]
	ld.w	%r12,%r0
	ld.w	%r13,%sp
	ext	0x2		; 	xld.w	%r15,0x00000080		; 128
	ld.w	%r15,0x0
	call	%r10
__LX200:				; __L200:
	add	%r1,0x1		; 	xadd	%r1,%r1,1
	cmp	%r1,0x5		; 	xcmp	%r1,5
	jrle	__LX201		; 	xjrle	__L201
	ld.w	%r12,%r2
	ld.w	%r13,%sp
	call	BuffFree_Mix2	; 	xcall	BuffFree_Mix2
	add	%sp,0x80	; 	xadd	%sp,%sp,512
	popn	%r2
	ret
	.align	1
BuffFree:
;	.frame	%sp,4,$31		# vars= 0, regs= 1/0, args= 0, extra= 0
;	.mask	0x80000000,-4
;	.fmask	0x00000000,0
	ext	0x4		; 	xld.w	%r12,[%r12+0x4]
	ld.w	%r12,[%r12]
	call	BuffFill	; 	xcall	BuffFill
	ret
	.align	1
	.global	InitMusic
InitMusic:
;	.frame	%sp,4,$31		# vars= 0, regs= 1/0, args= 0, extra= 0
;	.mask	0x80000000,-4
;	.fmask	0x00000000,0
	ld.w	%r12,0x0
	ld.w	%r15,0x14	; 	xld.w	%r15,0x00000014		; 20
	ext	waveinfo+0x0@h	; 	xld.w	%r14,waveinfo
	ext	waveinfo+0x0@m
	ld.w	%r14,waveinfo+0x0@l
	ld.w	%r4,0x1		; 	xld.w	%r4,0x00000001		; 1
__LX212:				; __L212:
	mlt.w	%r12,%r15
	ld.w	%r13,%alr
	add	%r13,%r14
	ext	0x1		; 	xld.b	[%r13+0x1],%r4
	ld.b	[%r13],%r4
	ld.w	%r10,%r12
	sll	%r10,0x8	; 	xsll	%r10,8
	ext	wavebuff+0x0@h	; 	xld.w	%r11,wavebuff
	ext	wavebuff+0x0@m
	ld.w	%r11,wavebuff+0x0@l
	add	%r10,%r11
	ext	0x4		; 	xld.w	[%r13+0x4],%r10
	ld.w	[%r13],%r10
	ext	0x2		; 	xld.w	%r10,0x00000080		; 128
	ld.w	%r10,0x0
	ext	0x8		; 	xld.w	[%r13+0x8],%r10
	ld.w	[%r13],%r10
	ext	0x1		; 	xadd	%r11,%r12,1
	add	%r11,%r12
	ld.w	%r10,%r11
	jrge	__LX213		; 	xjrge	__L213
	ext	0x4		; 	xadd	%r10,%r12,4
	add	%r10,%r12
__LX213:				; __L213:
	and	%r10,0x3c	; 	xand	%r10,%r10,0xfffffffc
	ld.w	%r5,%r11
	sub	%r5,%r10
	ld.w	%r10,%r5
	mlt.w	%r10,%r15
	ld.w	%r10,%alr
	add	%r10,%r14
	ext	0xc		; 	xld.w	[%r13+0xc],%r10
	ld.w	[%r13],%r10
	ext	BuffFree+0x0@h	; 	xld.w	%r10,BuffFree
	ext	BuffFree+0x0@m
	ld.w	%r10,BuffFree+0x0@l
	ext	0x10		; 	xld.w	[%r13+0x10],%r10
	ld.w	[%r13],%r10
	ld.w	%r12,%r11
	cmp	%r12,0x3	; 	xcmp	%r12,3
	jrle	__LX212		; 	xjrle	__L212
	ret
	.align	1
	.global	PlayMusic
PlayMusic:
;	.frame	%sp,16,$31		# vars= 0, regs= 4/0, args= 0, extra= 0
;	.mask	0x80070000,-4
;	.fmask	0x00000000,0
	pushn	%r2
	ld.w	%r0,%r12
	ext	EnterCS@rm	; 	xcall	EnterCS
	call	EnterCS@rl
	ld.w	%r2,%r10
	call	StopMusic	; 	xcall	StopMusic
	ld.w	%r12,%r0
	ext	StartSeq@rm	; 	xcall	StartSeq
	call	StartSeq@rl
	ld.w	%r1,0x0
	ext	wavebuff+0x0@h	; 	xld.w	%r0,wavebuff
	ext	wavebuff+0x0@m
	ld.w	%r0,wavebuff+0x0@l
__LX222:				; __L222:
	ld.w	%r12,%r0
	ext	BuffFill@rm	; 	xcall	BuffFill
	call	BuffFill@rl
	ext	0x4		; 	xadd	%r0,%r0,256
	add	%r0,0x0
	add	%r1,0x1		; 	xadd	%r1,%r1,1
	cmp	%r1,0x3		; 	xcmp	%r1,3
	jrle	__LX222		; 	xjrle	__L222
	ext	music_wch+0x0@ah	; 	xld.ub	%r12,[music_wch]
	ext	music_wch+0x0@al
	ld.ub	%r12,[%r8]
	ext	waveinfo+0x0@h	; 	xld.w	%r13,waveinfo
	ext	waveinfo+0x0@m
	ld.w	%r13,waveinfo+0x0@l
	ext	pceWaveDataOut@rm	; 	xcall	pceWaveDataOut
	call	pceWaveDataOut@rl
	ext	music_wch+0x0@ah	; 	xld.ub	%r10,[music_wch]
	ext	music_wch+0x0@al
	ld.ub	%r10,[%r8]
	ext	using_wch+0x0@ah	; 	xld.b	[using_wch],%r10
	ext	using_wch+0x0@al
	ld.b	[%r8],%r10
	ld.w	%r12,%r2
	ext	LeaveCS@rm	; 	xcall	LeaveCS
	call	LeaveCS@rl
	popn	%r2
	ret
	.align	1
	.global	StopMusic
StopMusic:
;	.frame	%sp,8,$31		# vars= 0, regs= 2/0, args= 0, extra= 0
;	.mask	0x80010000,-4
;	.fmask	0x00000000,0
	pushn	%r0
	ext	EnterCS@rm	; 	xcall	EnterCS
	call	EnterCS@rl
	ld.w	%r0,%r10
	ext	using_wch+0x0@ah	; 	xld.b	%r12,[using_wch]
	ext	using_wch+0x0@al
	ld.b	%r12,[%r8]
	cmp	%r12,0x0
	jrlt	__LX229		; 	xjrlt	__L229
	ext	pceWaveAbort@rm	; 	xcall	pceWaveAbort
	call	pceWaveAbort@rl
	ld.w	%r10,0x3f	; 	xld.w	%r10,-1			; 0xffffffff
	ext	using_wch+0x0@ah	; 	xld.b	[using_wch],%r10
	ext	using_wch+0x0@al
	ld.b	[%r8],%r10
__LX229:				; __L229:
	ext	seqwk+0x0@h	; 	xld.w	%r12,seqwk
	ext	seqwk+0x0@m
	ld.w	%r12,seqwk+0x0@l
	ld.w	%r13,0x0
	ext	0xf		; 	xld.w	%r14,0x000003f0		; 1008
	ld.w	%r14,0x30
	ext	memset@rm	; 	xcall	memset
	call	memset@rl
	ld.w	%r11,0x0
	ext	runf+0x0@ah	; 	xld.b	[runf],%r11
	ext	runf+0x0@al
	ld.b	[%r8],%r11
	ld.w	%r12,%r0
	ext	LeaveCS@rm	; 	xcall	LeaveCS
	call	LeaveCS@rl
	popn	%r0
	ret
	.align	1
	.global	MusicCheck
MusicCheck:
;	.frame	%sp,4,$31		# vars= 0, regs= 1/0, args= 0, extra= 0
;	.mask	0x80000000,-4
;	.fmask	0x00000000,0
	ld.w	%r11,0x0
	ext	runf+0x0@ah	; 	xld.b	%r10,[runf]
	ext	runf+0x0@al
	ld.b	%r10,[%r8]
	cmp	%r10,0x0
	jrne	__LX232		; 	xjrne	__L232
	ld.w	%r11,0x1	; 	xld.w	%r11,0x00000001		; 1
__LX232:				; __L232:
	ld.w	%r10,%r11
	ret
	.code
	.align	2
square:
	.byte	0
	.byte	127
	.byte	127
	.byte	127
	.byte	127
	.byte	127
	.byte	127
	.byte	127
	.byte	127
	.byte	127
	.byte	127
	.byte	127
	.byte	127
	.byte	127
	.byte	127
	.byte	127
	.byte	127
	.byte	0
	.byte	-127
	.byte	-127
	.byte	-127
	.byte	-127
	.byte	-127
	.byte	-127
	.byte	-127
	.byte	-127
	.byte	-127
	.byte	-127
	.byte	-127
	.byte	-127
	.byte	-127
	.byte	-127
	.byte	-127
	.byte	-127
	.align	2
saw:
	.byte	0
	.byte	31
	.byte	47
	.byte	63
	.byte	79
	.byte	95
	.byte	111
	.byte	127
	.byte	-127
	.byte	-111
	.byte	-95
	.byte	-79
	.byte	-63
	.byte	-47
	.byte	-31
	.align	2
triangle:
	.byte	0
	.byte	31
	.byte	63
	.byte	95
	.byte	127
	.byte	95
	.byte	63
	.byte	31
	.byte	0
	.byte	-31
	.byte	-63
	.byte	-95
	.byte	-127
	.byte	-95
	.byte	-63
	.byte	-31
	.global	i_square0
	.align	2
i_square0:
	.byte	128
	.byte	0
	.byte	0
	.byte	0
	.half	42903
	.half	36759
	.word	0
	.word	0
	.word	65536
	.global	i_saw0
	.align	2
i_saw0:
	.byte	128
	.byte	1
	.byte	0
	.byte	0
	.half	42903
	.half	36759
	.word	0
	.word	0
	.word	65536
	.global	i_triangle0
	.align	2
i_triangle0:
	.byte	128
	.byte	2
	.byte	0
	.byte	0
	.half	42903
	.half	36759
	.word	0
	.word	0
	.word	65536
	.global	i_square
	.align	2
i_square:
	.byte	16
	.byte	0
	.byte	0
	.byte	0
	.half	42903
	.half	27274
	.word	square
	.word	0
	.word	557056
	.global	i_saw
	.align	2
i_saw:
	.byte	16
	.byte	0
	.byte	0
	.byte	0
	.half	42903
	.half	30901
	.word	saw
	.word	0
	.word	245760
	.global	i_triangle
	.align	2
i_triangle:
	.byte	16
	.byte	0
	.byte	0
	.byte	0
	.half	42903
	.half	30615
	.word	triangle
	.word	0
	.word	262144
	.align	2
wdi_BD909:
	.byte	34
	.byte	34
	.byte	50
	.byte	57
	.byte	115
	.byte	152
	.byte	147
	.byte	231
	.byte	175
	.byte	63
	.byte	10
	.byte	34
	.byte	34
	.byte	81
	.byte	21
	.byte	68
	.byte	64
	.byte	16
	.byte	0
	.byte	32
	.byte	144
	.byte	57
	.byte	173
	.byte	239
	.byte	239
	.byte	234
	.byte	186
	.byte	174
	.byte	234
	.byte	162
	.byte	104
	.byte	68
	.byte	68
	.byte	21
	.byte	17
	.byte	16
	.byte	16
	.byte	4
	.byte	64
	.byte	8
	.byte	64
	.byte	182
	.byte	204
	.byte	204
	.byte	254
	.byte	238
	.byte	234
	.byte	186
	.byte	174
	.byte	174
	.byte	162
	.byte	234
	.byte	228
	.byte	68
	.byte	68
	.byte	20
	.byte	21
	.byte	1
	.byte	1
	.byte	1
	.byte	4
	.byte	4
	.byte	0
	.byte	16
	.byte	153
	.byte	57
	.byte	45
	.byte	51
	.byte	179
	.byte	251
	.byte	190
	.byte	238
	.byte	186
	.byte	171
	.byte	238
	.byte	170
	.byte	43
	.byte	58
	.byte	141
	.byte	147
	.byte	145
	.byte	145
	.byte	81
	.byte	20
	.byte	17
	.byte	4
	.byte	4
	.byte	16
	.byte	16
	.byte	64
	.byte	64
	.byte	0
	.byte	153
	.byte	153
	.byte	135
	.byte	141
	.byte	211
	.byte	56
	.byte	51
	.byte	187
	.byte	251
	.byte	238
	.byte	238
	.byte	190
	.byte	174
	.byte	235
	.byte	186
	.byte	186
	.byte	238
	.byte	76
	.byte	227
	.byte	228
	.byte	100
	.byte	100
	.byte	70
	.byte	70
	.byte	68
	.byte	81
	.byte	4
	.byte	65
	.byte	4
	.byte	64
	.byte	4
	.byte	4
	.byte	1
	.byte	17
	.byte	68
	.byte	100
	.byte	102
	.byte	230
	.byte	73
	.byte	54
	.byte	78
	.byte	206
	.byte	228
	.byte	204
	.byte	204
	.byte	238
	.byte	238
	.byte	238
	.byte	238
	.byte	238
	.byte	235
	.byte	235
	.byte	235
	.byte	235
	.byte	238
	.byte	238
	.byte	204
	.byte	52
	.byte	78
	.byte	78
	.byte	158
	.byte	100
	.byte	100
	.byte	102
	.byte	70
	.byte	70
	.byte	68
	.byte	84
	.byte	16
	.byte	4
	.byte	20
	.byte	16
	.byte	5
	.byte	68
	.byte	80
	.byte	80
	.byte	16
	.byte	17
	.byte	17
	.byte	153
	.byte	153
	.byte	135
	.byte	121
	.byte	152
	.byte	147
	.byte	141
	.byte	147
	.byte	211
	.byte	56
	.byte	45
	.byte	51
	.byte	173
	.byte	179
	.byte	179
	.byte	59
	.byte	187
	.byte	179
	.byte	187
	.byte	179
	.byte	187
	.byte	179
	.byte	187
	.byte	59
	.byte	59
	.byte	59
	.byte	51
	.byte	141
	.byte	147
	.byte	147
	.byte	147
	.byte	39
	.byte	121
	.byte	152
	.byte	153
	.byte	153
	.byte	25
	.byte	153
	.byte	17
	.byte	25
	.byte	81
	.byte	4
	.byte	69
	.byte	4
	.byte	5
	.byte	5
	.byte	5
	.byte	81
	.byte	16
	.byte	17
	.byte	17
	.byte	17
	.byte	145
	.byte	145
	.byte	145
	.byte	153
	.byte	135
	.byte	153
	.byte	147
	.byte	121
	.byte	146
	.byte	39
	.byte	57
	.byte	57
	.byte	39
	.byte	147
	.byte	211
	.byte	56
	.byte	211
	.byte	56
	.byte	51
	.byte	179
	.byte	51
	.byte	59
	.byte	51
	.byte	59
	.byte	59
	.byte	179
	.byte	51
	.byte	59
	.byte	179
	.byte	51
	.byte	59
	.byte	51
	.byte	179
	.byte	211
	.byte	50
	.byte	141
	.byte	147
	.byte	147
	.byte	39
	.byte	57
	.byte	153
	.byte	147
	.byte	153
	.byte	153
	.byte	153
	.byte	153
	.byte	153
	.byte	153
	.byte	153
	.byte	145
	.byte	17
	.byte	25
	.byte	17
	.byte	17
	.byte	17
	.byte	17
	.byte	17
	.byte	25
	.byte	17
	.byte	25
	.byte	25
	.byte	25
	.byte	25
	.byte	25
	.byte	153
	.byte	25
	.byte	153
	.byte	153
	.byte	121
	.byte	152
	.byte	135
	.byte	57
	.byte	153
	.byte	147
	.byte	57
	.byte	121
	.byte	146
	.byte	147
	.byte	147
	.byte	147
	.byte	211
	.byte	120
	.byte	50
	.byte	57
	.byte	141
	.byte	211
	.byte	56
	.byte	51
	.byte	141
	.byte	51
	.byte	51
	.byte	45
	.byte	51
	.byte	45
	.byte	51
	.byte	45
	.byte	51
	.byte	211
	.byte	50
	.byte	211
	.byte	50
	.byte	211
	.byte	56
	.byte	211
	.byte	56
	.byte	57
	.byte	57
	.byte	57
	.byte	121
	.byte	146
	.byte	39
	.byte	121
	.byte	146
	.byte	39
	.byte	153
	.byte	153
	.byte	135
	.byte	153
	.byte	153
	.byte	135
	.byte	153
	.byte	153
	.byte	153
	.byte	145
	.byte	153
	.byte	145
	.byte	145
	.byte	153
	.byte	145
	.byte	153
	.byte	145
	.byte	153
	.byte	153
	.byte	153
	.byte	145
	.byte	153
	.byte	7
	.byte	153
	.byte	121
	.byte	152
	.byte	153
	.byte	121
	.byte	152
	.byte	135
	.byte	57
	.byte	153
	.byte	39
	.byte	57
	.byte	153
	.byte	147
	.byte	39
	.byte	121
	.byte	210
	.byte	152
	.byte	147
	.byte	147
	.byte	147
	.byte	39
	.byte	39
	.byte	39
	.byte	39
	.byte	147
	.byte	147
	.byte	211
	.byte	56
	.byte	141
	.byte	147
	.byte	51
	.byte	57
	.byte	141
	.byte	211
	.byte	56
	.byte	57
	.byte	147
	.byte	211
	.byte	56
	.byte	141
	.byte	147
	.byte	115
	.byte	50
	.byte	57
	.byte	141
	.byte	39
	.byte	39
	.byte	57
	.byte	121
	.byte	146
	.byte	39
	.byte	57
	.byte	153
	.byte	39
	.byte	121
	.byte	146
	.byte	153
	.byte	39
	.byte	153
	.byte	135
	.byte	153
	.byte	135
	.byte	153
	.byte	135
	.byte	153
	.byte	153
	.byte	153
	.byte	153
	.byte	7
	.byte	153
	.byte	7
	.byte	121
	.byte	152
	.byte	153
	.byte	153
	.byte	135
	.byte	153
	.byte	121
	.byte	152
	.byte	121
	.byte	152
	.byte	121
	.byte	152
	.byte	135
	.byte	121
	.byte	152
	.byte	147
	.byte	121
	.byte	146
	.byte	39
	.byte	57
	.byte	153
	.byte	147
	.byte	57
	.byte	121
	.byte	146
	.byte	147
	.byte	39
	.byte	57
	.byte	121
	.byte	146
	.byte	147
	.byte	147
	.byte	141
	.byte	57
	.byte	57
	.byte	57
	.byte	57
	.byte	57
	.byte	57
	.byte	57
	.byte	57
	.byte	57
	.byte	57
	.byte	57
	.byte	57
	.byte	57
	.byte	57
	.byte	57
	.byte	57
	.byte	57
	.byte	57
	.byte	57
	.byte	141
	.byte	57
	.byte	57
	.byte	57
	.byte	121
	.byte	146
	.byte	147
	.byte	141
	.byte	121
	.byte	146
	.byte	39
	.byte	121
	.byte	146
	.byte	39
	.byte	153
	.byte	39
	.byte	153
	.byte	39
	.byte	153
	.byte	39
	.byte	153
	.byte	39
	.byte	153
	.byte	135
	.byte	153
	.byte	135
	.byte	153
	.byte	135
	.byte	153
	.byte	135
	.byte	153
	.byte	135
	.byte	121
	.byte	152
	.byte	121
	.byte	146
	.byte	121
	.byte	152
	.byte	39
	.byte	153
	.byte	135
	.byte	121
	.byte	146
	.byte	57
	.byte	153
	.byte	39
	.byte	121
	.byte	146
	.byte	39
	.byte	121
	.byte	146
	.byte	39
	.byte	57
	.byte	153
	.byte	147
	.byte	57
	.byte	121
	.byte	146
	.byte	147
	.byte	57
	.byte	121
	.byte	146
	.byte	147
	.byte	141
	.byte	57
	.byte	217
	.byte	152
	.byte	147
	.byte	39
	.byte	57
	.byte	57
	.byte	121
	.byte	146
	.byte	147
	.byte	147
	.byte	39
	.byte	141
	.byte	57
	.byte	57
	.byte	217
	.byte	152
	.byte	147
	.byte	147
	.byte	141
	.byte	57
	.byte	121
	.byte	146
	.byte	147
	.byte	39
	.byte	121
	.byte	146
	.byte	147
	.byte	57
	.byte	153
	.byte	147
	.byte	57
	.byte	153
	.byte	39
	.byte	121
	.byte	146
	.byte	57
	.byte	153
	.byte	39
	.byte	153
	.byte	147
	.byte	121
	.byte	152
	.byte	39
	.byte	153
	.byte	39
	.byte	153
	.byte	39
	.byte	153
	.byte	39
	.byte	153
	.byte	39
	.byte	153
	.byte	39
	.byte	153
	.byte	147
	.byte	121
	.byte	146
	.byte	57
	.byte	153
	.byte	39
	.byte	153
	.byte	147
	.byte	121
	.byte	146
	.byte	39
	.byte	121
	.byte	146
	.byte	39
	.byte	121
	.byte	146
	.byte	39
	.byte	121
	.byte	146
	.byte	147
	.byte	57
	.byte	153
	.byte	147
	.byte	141
	.byte	121
	.byte	146
	.byte	39
	.byte	57
	.byte	153
	.byte	147
	.byte	39
	.byte	57
	.byte	153
	.byte	147
	.byte	39
	.align	2
wdi_CYMBD:
	.byte	162
	.byte	100
	.byte	114
	.byte	218
	.byte	8
	.byte	154
	.byte	2
	.byte	211
	.byte	41
	.byte	154
	.byte	224
	.byte	105
	.byte	35
	.byte	136
	.byte	136
	.byte	200
	.byte	41
	.byte	130
	.byte	136
	.byte	52
	.byte	162
	.byte	116
	.byte	202
	.byte	137
	.byte	130
	.byte	128
	.byte	122
	.byte	167
	.byte	137
	.byte	168
	.byte	198
	.byte	137
	.byte	136
	.byte	184
	.byte	38
	.byte	152
	.byte	160
	.byte	178
	.byte	154
	.byte	136
	.byte	137
	.byte	50
	.byte	166
	.byte	129
	.byte	196
	.byte	9
	.byte	54
	.byte	130
	.byte	50
	.byte	160
	.byte	161
	.byte	160
	.byte	184
	.byte	136
	.byte	242
	.byte	45
	.byte	48
	.byte	194
	.byte	48
	.byte	140
	.byte	72
	.byte	114
	.byte	194
	.byte	160
	.byte	2
	.byte	73
	.byte	34
	.byte	200
	.byte	56
	.byte	200
	.byte	9
	.byte	3
	.byte	202
	.byte	41
	.byte	114
	.byte	35
	.byte	162
	.byte	32
	.byte	106
	.byte	154
	.byte	156
	.byte	98
	.byte	35
	.byte	136
	.byte	156
	.byte	130
	.byte	152
	.byte	8
	.byte	26
	.byte	167
	.byte	136
	.byte	224
	.byte	38
	.byte	136
	.byte	38
	.byte	154
	.byte	104
	.byte	138
	.byte	166
	.byte	162
	.byte	192
	.byte	13
	.byte	10
	.byte	163
	.byte	48
	.byte	194
	.byte	152
	.byte	39
	.byte	138
	.byte	13
	.byte	39
	.byte	34
	.byte	218
	.byte	32
	.byte	54
	.byte	130
	.byte	8
	.byte	162
	.byte	134
	.byte	200
	.byte	32
	.byte	176
	.byte	128
	.byte	182
	.byte	161
	.byte	141
	.byte	141
	.byte	8
	.byte	138
	.byte	152
	.byte	130
	.byte	130
	.byte	55
	.byte	162
	.byte	160
	.byte	152
	.byte	34
	.byte	114
	.byte	138
	.byte	205
	.byte	41
	.byte	41
	.byte	162
	.byte	72
	.byte	74
	.byte	74
	.byte	42
	.byte	104
	.byte	28
	.byte	30
	.byte	99
	.byte	131
	.byte	136
	.byte	136
	.byte	38
	.byte	131
	.byte	216
	.byte	32
	.byte	162
	.byte	160
	.byte	168
	.byte	49
	.byte	41
	.byte	162
	.byte	192
	.byte	112
	.byte	155
	.byte	40
	.byte	136
	.byte	200
	.byte	48
	.byte	130
	.byte	39
	.byte	167
	.byte	136
	.byte	48
	.byte	194
	.byte	41
	.byte	166
	.byte	41
	.byte	12
	.byte	138
	.byte	48
	.byte	156
	.byte	8
	.byte	35
	.byte	104
	.byte	35
	.byte	40
	.byte	8
	.byte	226
	.byte	9
	.byte	155
	.byte	8
	.byte	35
	.byte	48
	.byte	40
	.byte	200
	.byte	41
	.byte	210
	.byte	104
	.byte	34
	.byte	12
	.byte	162
	.byte	32
	.byte	12
	.byte	195
	.byte	41
	.byte	34
	.byte	140
	.byte	32
	.byte	12
	.byte	34
	.byte	219
	.byte	13
	.byte	50
	.byte	104
	.byte	10
	.byte	140
	.byte	136
	.byte	12
	.byte	10
	.byte	99
	.byte	10
	.byte	131
	.byte	156
	.byte	2
	.byte	35
	.byte	154
	.byte	54
	.byte	130
	.byte	166
	.byte	152
	.byte	130
	.byte	38
	.byte	131
	.byte	104
	.byte	131
	.byte	34
	.byte	160
	.byte	160
	.byte	201
	.byte	217
	.byte	160
	.byte	32
	.byte	10
	.byte	195
	.byte	41
	.byte	136
	.byte	152
	.byte	76
	.byte	131
	.byte	40
	.byte	168
	.byte	105
	.byte	194
	.byte	8
	.byte	131
	.byte	54
	.byte	136
	.byte	166
	.byte	48
	.byte	136
	.byte	136
	.byte	169
	.byte	41
	.byte	10
	.byte	55
	.byte	13
	.byte	162
	.byte	41
	.byte	218
	.byte	41
	.byte	40
	.byte	34
	.byte	130
	.byte	140
	.byte	13
	.byte	34
	.byte	138
	.byte	130
	.byte	18
	.byte	75
	.byte	35
	.byte	98
	.byte	106
	.byte	154
	.byte	130
	.byte	3
	.byte	158
	.byte	130
	.byte	130
	.byte	112
	.byte	218
	.byte	216
	.byte	32
	.byte	34
	.byte	50
	.byte	136
	.byte	200
	.byte	41
	.byte	104
	.byte	26
	.byte	195
	.byte	41
	.byte	40
	.byte	40
	.byte	54
	.byte	166
	.byte	8
	.byte	34
	.byte	98
	.byte	131
	.byte	104
	.byte	12
	.byte	167
	.byte	13
	.byte	138
	.byte	32
	.byte	218
	.byte	32
	.byte	194
	.byte	8
	.byte	10
	.byte	55
	.byte	38
	.byte	218
	.byte	32
	.byte	10
	.byte	162
	.byte	48
	.byte	168
	.byte	49
	.byte	34
	.byte	40
	.byte	141
	.byte	41
	.byte	12
	.byte	138
	.byte	48
	.byte	120
	.byte	12
	.byte	106
	.byte	10
	.byte	140
	.byte	41
	.byte	114
	.byte	34
	.byte	154
	.byte	12
	.byte	10
	.byte	131
	.byte	40
	.byte	130
	.byte	200
	.byte	13
	.byte	34
	.byte	34
	.byte	138
	.byte	13
	.byte	99
	.byte	167
	.byte	160
	.byte	160
	.byte	41
	.byte	200
	.byte	8
	.byte	140
	.byte	13
	.byte	10
	.byte	218
	.byte	128
	.byte	39
	.byte	114
	.byte	138
	.byte	32
	.byte	162
	.byte	152
	.byte	2
	.byte	195
	.byte	216
	.byte	8
	.byte	34
	.byte	39
	.byte	162
	.byte	160
	.byte	201
	.byte	32
	.byte	130
	.byte	156
	.byte	98
	.byte	50
	.byte	166
	.byte	41
	.byte	34
	.byte	167
	.byte	41
	.byte	34
	.byte	104
	.byte	162
	.byte	13
	.byte	34
	.byte	138
	.byte	157
	.byte	34
	.byte	104
	.byte	138
	.byte	141
	.byte	8
	.byte	10
	.byte	3
	.byte	27
	.byte	131
	.byte	98
	.byte	106
	.byte	131
	.byte	136
	.byte	8
	.byte	131
	.byte	147
	.byte	98
	.byte	131
	.byte	166
	.byte	141
	.byte	32
	.byte	162
	.byte	152
	.byte	34
	.byte	34
	.byte	156
	.byte	12
	.byte	99
	.byte	10
	.byte	195
	.byte	137
	.byte	98
	.byte	131
	.byte	40
	.byte	130
	.byte	200
	.byte	41
	.byte	130
	.byte	136
	.byte	48
	.byte	136
	.byte	162
	.byte	225
	.byte	105
	.byte	167
	.byte	136
	.byte	13
	.byte	114
	.byte	34
	.byte	50
	.byte	130
	.byte	136
	.byte	136
	.byte	32
	.byte	34
	.byte	221
	.byte	48
	.byte	104
	.byte	131
	.byte	210
	.byte	32
	.byte	131
	.byte	130
	.byte	216
	.byte	160
	.byte	52
	.byte	34
	.byte	140
	.byte	32
	.byte	162
	.byte	105
	.byte	10
	.byte	99
	.byte	138
	.byte	152
	.byte	34
	.byte	194
	.byte	105
	.byte	138
	.byte	8
	.byte	211
	.byte	8
	.byte	131
	.byte	210
	.byte	8
	.byte	10
	.byte	162
	.byte	52
	.byte	200
	.byte	152
	.byte	194
	.byte	152
	.byte	166
	.byte	48
	.byte	166
	.byte	48
	.byte	166
	.byte	136
	.byte	136
	.byte	201
	.byte	8
	.byte	131
	.byte	13
	.byte	131
	.byte	40
	.byte	200
	.byte	137
	.byte	40
	.byte	98
	.byte	50
	.byte	130
	.byte	54
	.byte	194
	.byte	137
	.byte	136
	.byte	194
	.byte	32
	.byte	167
	.byte	8
	.byte	162
	.byte	13
	.byte	34
	.byte	140
	.byte	136
	.byte	137
	.byte	48
	.byte	54
	.byte	13
	.byte	42
	.byte	13
	.byte	34
	.byte	74
	.byte	131
	.byte	40
	.byte	156
	.byte	40
	.byte	12
	.byte	50
	.byte	118
	.byte	10
	.byte	162
	.byte	13
	.byte	10
	.byte	138
	.byte	96
	.byte	154
	.byte	194
	.byte	8
	.byte	50
	.byte	130
	.byte	104
	.byte	140
	.byte	152
	.byte	98
	.byte	131
	.byte	130
	.byte	136
	.byte	198
	.byte	224
	.byte	41
	.byte	38
	.byte	99
	.byte	138
	.byte	141
	.byte	192
	.byte	8
	.byte	167
	.byte	48
	.byte	40
	.byte	48
	.byte	120
	.byte	34
	.byte	162
	.byte	41
	.byte	104
	.byte	138
	.byte	200
	.byte	13
	.byte	34
	.byte	120
	.byte	10
	.byte	114
	.byte	10
	.byte	34
	.byte	218
	.byte	13
	.byte	10
	.byte	162
	.byte	32
	.byte	154
	.byte	38
	.byte	10
	.byte	3
	.byte	35
	.byte	39
	.byte	154
	.byte	210
	.byte	136
	.byte	32
	.byte	99
	.byte	10
	.byte	138
	.byte	121
	.byte	154
	.byte	98
	.byte	34
	.byte	131
	.byte	156
	.byte	130
	.byte	40
	.byte	130
	.byte	166
	.byte	157
	.byte	34
	.byte	154
	.byte	136
	.byte	216
	.byte	160
	.byte	198
	.byte	152
	.byte	34
	.byte	166
	.byte	136
	.byte	48
	.byte	40
	.byte	136
	.byte	38
	.byte	230
	.byte	32
	.byte	210
	.byte	136
	.byte	177
	.byte	41
	.byte	104
	.byte	138
	.byte	13
	.byte	114
	.byte	10
	.byte	114
	.byte	138
	.byte	152
	.byte	40
	.byte	12
	.byte	10
	.byte	162
	.byte	77
	.byte	35
	.byte	130
	.byte	156
	.byte	130
	.byte	166
	.byte	136
	.byte	136
	.byte	52
	.byte	34
	.byte	54
	.byte	8
	.byte	158
	.byte	40
	.byte	104
	.byte	218
	.byte	160
	.byte	41
	.byte	130
	.byte	220
	.byte	41
	.byte	34
	.byte	98
	.byte	10
	.byte	99
	.byte	10
	.byte	26
	.byte	35
	.byte	220
	.byte	8
	.byte	10
	.byte	98
	.byte	131
	.byte	130
	.byte	2
	.byte	147
	.byte	131
	.byte	166
	.byte	136
	.byte	192
	.byte	41
	.byte	34
	.byte	210
	.byte	52
	.byte	34
	.byte	194
	.byte	160
	.byte	41
	.byte	48
	.byte	230
	.byte	137
	.byte	168
	.byte	105
	.byte	34
	.byte	39
	.byte	138
	.byte	137
	.byte	34
	.byte	104
	.byte	35
	.byte	130
	.byte	13
	.byte	154
	.byte	194
	.byte	112
	.byte	138
	.byte	32
	.byte	167
	.byte	160
	.byte	13
	.byte	34
	.byte	162
	.byte	192
	.byte	41
	.byte	34
	.byte	114
	.byte	39
	.byte	138
	.byte	41
	.byte	34
	.byte	48
	.byte	168
	.byte	105
	.byte	154
	.byte	40
	.byte	13
	.byte	99
	.byte	50
	.byte	136
	.byte	40
	.byte	220
	.byte	32
	.byte	34
	.byte	154
	.byte	104
	.byte	10
	.byte	98
	.byte	35
	.byte	114
	.byte	34
	.byte	154
	.byte	166
	.byte	160
	.byte	157
	.byte	130
	.byte	154
	.byte	152
	.byte	10
	.byte	166
	.byte	38
	.byte	194
	.byte	166
	.byte	41
	.byte	130
	.byte	57
	.byte	136
	.byte	221
	.byte	8
	.byte	34
	.byte	154
	.byte	166
	.byte	32
	.byte	226
	.byte	137
	.byte	136
	.byte	166
	.byte	8
	.byte	141
	.byte	136
	.byte	48
	.byte	38
	.byte	167
	.byte	160
	.byte	157
	.byte	166
	.byte	48
	.byte	104
	.byte	131
	.byte	34
	.byte	152
	.byte	218
	.byte	32
	.byte	34
	.byte	34
	.byte	54
	.byte	168
	.byte	137
	.byte	41
	.byte	34
	.byte	224
	.byte	13
	.byte	108
	.byte	54
	.byte	12
	.byte	34
	.byte	138
	.byte	13
	.byte	34
	.byte	34
	.byte	114
	.byte	154
	.byte	130
	.byte	136
	.byte	154
	.byte	38
	.byte	162
	.byte	41
	.byte	192
	.byte	220
	.byte	32
	.byte	166
	.byte	156
	.byte	166
	.byte	48
	.byte	40
	.byte	48
	.byte	40
	.byte	40
	.byte	140
	.byte	13
	.byte	98
	.byte	35
	.byte	38
	.byte	138
	.byte	137
	.byte	40
	.byte	120
	.byte	114
	.byte	138
	.byte	13
	.byte	34
	.byte	154
	.byte	72
	.byte	163
	.byte	137
	.byte	54
	.byte	40
	.byte	38
	.byte	131
	.byte	2
	.byte	131
	.byte	220
	.byte	192
	.byte	160
	.byte	136
	.byte	32
	.byte	54
	.byte	12
	.byte	114
	.byte	34
	.byte	10
	.byte	10
	.byte	131
	.byte	98
	.byte	211
	.byte	8
	.byte	154
	.byte	40
	.byte	156
	.byte	98
	.byte	154
	.byte	34
	.byte	39
	.byte	194
	.byte	136
	.byte	160
	.byte	224
	.byte	164
	.byte	160
	.byte	8
	.byte	54
	.byte	120
	.byte	34
	.byte	220
	.byte	137
	.byte	34
	.byte	136
	.byte	166
	.byte	48
	.byte	54
	.byte	8
	.byte	131
	.byte	168
	.byte	153
	.byte	98
	.byte	211
	.byte	160
	.byte	130
	.byte	52
	.byte	200
	.byte	201
	.byte	32
	.byte	162
	.byte	112
	.byte	162
	.byte	41
	.byte	34
	.byte	168
	.byte	49
	.byte	38
	.byte	114
	.byte	131
	.byte	136
	.byte	168
	.byte	157
	.byte	152
	.byte	162
	.byte	137
	.byte	40
	.byte	104
	.byte	138
	.byte	224
	.byte	77
	.byte	99
	.byte	35
	.byte	160
	.byte	8
	.byte	195
	.byte	32
	.byte	34
	.byte	104
	.byte	30
	.byte	195
	.byte	41
	.byte	98
	.byte	10
	.byte	131
	.byte	216
	.byte	136
	.byte	160
	.byte	13
	.byte	194
	.byte	32
	.byte	138
	.byte	104
	.byte	2
	.byte	55
	.byte	194
	.byte	32
	.byte	54
	.byte	130
	.byte	109
	.byte	154
	.byte	40
	.byte	12
	.byte	194
	.byte	8
	.byte	39
	.byte	74
	.byte	195
	.byte	32
	.byte	10
	.byte	39
	.byte	138
	.byte	160
	.byte	152
	.byte	38
	.byte	3
	.byte	195
	.byte	201
	.byte	136
	.byte	32
	.byte	54
	.byte	34
	.byte	104
	.byte	10
	.byte	162
	.byte	41
	.byte	38
	.byte	78
	.byte	39
	.byte	10
	.byte	138
	.byte	13
	.byte	34
	.byte	154
	.byte	140
	.byte	77
	.byte	131
	.byte	130
	.byte	34
	.byte	13
	.byte	218
	.byte	8
	.byte	34
	.byte	3
	.byte	99
	.byte	10
	.byte	154
	.byte	54
	.byte	130
	.byte	38
	.byte	154
	.byte	194
	.byte	160
	.byte	32
	.byte	162
	.byte	196
	.byte	72
	.byte	131
	.byte	167
	.byte	32
	.byte	162
	.byte	225
	.byte	137
	.byte	130
	.byte	210
	.byte	116
	.byte	138
	.byte	48
	.byte	194
	.byte	137
	.byte	38
	.byte	138
	.byte	32
	.byte	195
	.byte	105
	.byte	162
	.byte	166
	.byte	137
	.byte	200
	.byte	41
	.byte	166
	.byte	160
	.byte	112
	.byte	35
	.byte	216
	.byte	160
	.byte	136
	.byte	137
	.byte	34
	.byte	120
	.byte	162
	.byte	137
	.byte	104
	.byte	140
	.byte	141
	.byte	41
	.byte	98
	.byte	50
	.byte	38
	.byte	138
	.byte	13
	.byte	10
	.byte	34
	.byte	114
	.byte	98
	.byte	35
	.byte	194
	.byte	13
	.byte	154
	.byte	130
	.byte	136
	.byte	166
	.byte	160
	.byte	157
	.byte	194
	.byte	160
	.byte	137
	.byte	40
	.byte	98
	.byte	39
	.byte	131
	.byte	130
	.byte	8
	.byte	35
	.byte	104
	.byte	114
	.byte	138
	.byte	8
	.byte	154
	.byte	157
	.byte	156
	.byte	34
	.byte	34
	.byte	98
	.byte	154
	.byte	38
	.byte	131
	.byte	98
	.byte	154
	.byte	34
	.byte	104
	.byte	39
	.byte	167
	.byte	136
	.byte	152
	.byte	194
	.byte	201
	.byte	137
	.byte	34
	.byte	34
	.byte	130
	.byte	13
	.byte	10
	.byte	50
	.byte	40
	.byte	112
	.byte	99
	.byte	10
	.byte	114
	.byte	34
	.byte	106
	.byte	154
	.byte	194
	.byte	137
	.byte	156
	.byte	130
	.byte	166
	.byte	136
	.byte	152
	.byte	34
	.byte	12
	.byte	166
	.byte	48
	.byte	54
	.byte	38
	.byte	10
	.byte	162
	.byte	141
	.byte	13
	.byte	34
	.byte	12
	.byte	12
	.byte	10
	.byte	195
	.byte	137
	.byte	130
	.byte	130
	.byte	112
	.byte	99
	.byte	131
	.byte	136
	.byte	136
	.byte	166
	.byte	192
	.byte	32
	.byte	167
	.byte	52
	.byte	40
	.byte	168
	.byte	217
	.byte	141
	.byte	137
	.byte	130
	.byte	136
	.byte	98
	.byte	167
	.byte	216
	.byte	192
	.byte	48
	.byte	136
	.byte	54
	.byte	48
	.byte	34
	.byte	194
	.byte	32
	.byte	130
	.byte	200
	.byte	41
	.byte	52
	.byte	230
	.byte	41
	.byte	136
	.byte	216
	.byte	136
	.byte	96
	.byte	35
	.byte	112
	.byte	35
	.byte	40
	.byte	136
	.byte	48
	.byte	130
	.byte	54
	.byte	8
	.byte	55
	.byte	136
	.byte	141
	.byte	136
	.byte	157
	.byte	12
	.byte	34
	.byte	74
	.byte	10
	.byte	131
	.byte	118
	.byte	10
	.byte	10
	.byte	39
	.byte	162
	.byte	32
	.byte	131
	.byte	156
	.byte	130
	.byte	13
	.byte	154
	.byte	210
	.byte	160
	.byte	32
	.byte	131
	.byte	156
	.byte	130
	.byte	166
	.byte	105
	.byte	35
	.byte	130
	.byte	112
	.byte	138
	.byte	13
	.byte	154
	.byte	34
	.byte	166
	.byte	152
	.byte	136
	.byte	130
	.byte	141
	.byte	8
	.byte	12
	.byte	39
	.byte	39
	.byte	114
	.byte	162
	.byte	136
	.byte	201
	.byte	32
	.byte	194
	.byte	137
	.byte	130
	.byte	230
	.byte	105
	.byte	140
	.byte	136
	.byte	160
	.byte	41
	.byte	118
	.byte	138
	.byte	49
	.byte	120
	.byte	34
	.byte	10
	.byte	34
	.byte	40
	.byte	109
	.byte	12
	.byte	141
	.byte	136
	.byte	57
	.byte	13
	.byte	154
	.byte	156
	.byte	34
	.byte	136
	.byte	130
	.byte	152
	.byte	39
	.byte	39
	.byte	39
	.byte	138
	.byte	32
	.byte	182
	.byte	137
	.byte	160
	.byte	216
	.byte	32
	.byte	226
	.byte	137
	.byte	48
	.byte	168
	.byte	164
	.byte	192
	.byte	160
	.byte	152
	.byte	54
	.byte	200
	.byte	137
	.byte	176
	.byte	161
	.byte	224
	.byte	157
	.byte	166
	.byte	136
	.byte	41
	.byte	54
	.byte	136
	.byte	48
	.byte	12
	.byte	114
	.byte	138
	.byte	41
	.byte	40
	.byte	40
	.byte	216
	.byte	136
	.byte	157
	.byte	104
	.byte	114
	.byte	162
	.byte	104
	.byte	162
	.byte	41
	.byte	166
	.byte	41
	.byte	40
	.byte	104
	.byte	114
	.byte	162
	.byte	136
	.byte	105
	.byte	158
	.byte	136
	.byte	12
	.byte	114
	.byte	10
	.byte	34
	.byte	154
	.byte	8
	.byte	30
	.byte	3
	.byte	35
	.byte	2
	.byte	119
	.byte	131
	.byte	130
	.byte	130
	.byte	156
	.byte	8
	.byte	131
	.byte	166
	.byte	38
	.byte	194
	.byte	164
	.byte	200
	.byte	41
	.byte	38
	.byte	167
	.byte	137
	.byte	34
	.byte	200
	.byte	41
	.byte	40
	.byte	40
	.byte	41
	.byte	136
	.byte	117
	.byte	195
	.byte	13
	.byte	12
	.byte	10
	.byte	106
	.byte	39
	.byte	194
	.byte	160
	.byte	152
	.byte	156
	.byte	38
	.byte	162
	.byte	32
	.byte	55
	.byte	141
	.byte	160
	.byte	177
	.byte	105
	.byte	162
	.byte	32
	.byte	54
	.byte	130
	.byte	40
	.byte	57
	.byte	13
	.byte	34
	.byte	12
	.byte	114
	.byte	10
	.byte	30
	.byte	138
	.byte	105
	.byte	10
	.byte	39
	.byte	131
	.byte	152
	.byte	167
	.byte	128
	.byte	130
	.byte	216
	.byte	13
	.byte	130
	.byte	158
	.byte	102
	.byte	154
	.byte	154
	.byte	198
	.byte	8
	.byte	39
	.byte	131
	.byte	160
	.byte	38
	.byte	118
	.byte	194
	.byte	48
	.byte	130
	.byte	136
	.byte	192
	.byte	49
	.byte	130
	.byte	180
	.byte	137
	.byte	224
	.byte	49
	.byte	104
	.byte	162
	.byte	137
	.byte	108
	.byte	39
	.byte	194
	.byte	137
	.byte	130
	.byte	38
	.byte	147
	.byte	194
	.byte	128
	.byte	210
	.byte	96
	.byte	195
	.byte	192
	.byte	160
	.byte	137
	.byte	216
	.byte	192
	.byte	52
	.byte	54
	.byte	136
	.byte	48
	.byte	120
	.byte	140
	.byte	32
	.byte	10
	.byte	76
	.byte	35
	.byte	12
	.byte	12
	.byte	34
	.byte	74
	.byte	131
	.byte	210
	.byte	105
	.byte	131
	.byte	136
	.byte	104
	.byte	39
	.byte	10
	.byte	74
	.byte	131
	.byte	200
	.byte	9
	.byte	138
	.byte	54
	.byte	141
	.byte	32
	.byte	40
	.byte	28
	.byte	131
	.byte	156
	.byte	104
	.byte	35
	.byte	48
	.byte	38
	.byte	218
	.byte	41
	.byte	8
	.byte	10
	.byte	55
	.byte	13
	.byte	114
	.byte	34
	.byte	154
	.byte	136
	.byte	104
	.byte	140
	.byte	104
	.byte	114
	.byte	74
	.byte	218
	.byte	152
	.byte	136
	.byte	200
	.byte	41
	.byte	38
	.byte	218
	.byte	36
	.byte	138
	.byte	216
	.byte	52
	.byte	34
	.byte	166
	.byte	128
	.byte	39
	.byte	166
	.byte	201
	.byte	13
	.byte	34
	.byte	168
	.byte	105
	.byte	131
	.byte	224
	.byte	137
	.byte	8
	.byte	55
	.byte	48
	.byte	54
	.byte	40
	.byte	8
	.byte	154
	.byte	34
	.byte	141
	.byte	157
	.byte	40
	.byte	200
	.byte	137
	.byte	166
	.byte	13
	.byte	34
	.byte	12
	.byte	120
	.byte	194
	.byte	32
	.byte	39
	.byte	10
	.byte	39
	.byte	34
	.byte	218
	.byte	192
	.byte	41
	.byte	216
	.byte	160
	.byte	96
	.byte	131
	.byte	166
	.byte	137
	.byte	112
	.byte	131
	.byte	104
	.byte	162
	.byte	137
	.byte	104
	.byte	2
	.byte	231
	.byte	137
	.byte	29
	.byte	39
	.byte	154
	.byte	98
	.byte	106
	.byte	140
	.byte	201
	.byte	32
	.byte	118
	.byte	138
	.byte	8
	.byte	114
	.byte	34
	.byte	40
	.byte	105
	.byte	211
	.byte	8
	.byte	154
	.byte	156
	.byte	130
	.byte	38
	.byte	211
	.byte	32
	.byte	154
	.byte	160
	.byte	194
	.byte	105
	.byte	167
	.byte	32
	.byte	136
	.byte	52
	.byte	40
	.byte	166
	.byte	217
	.byte	105
	.byte	108
	.byte	40
	.byte	56
	.byte	157
	.byte	28
	.byte	99
	.byte	10
	.byte	10
	.byte	106
	.byte	146
	.byte	147
	.byte	210
	.byte	24
	.byte	131
	.byte	130
	.byte	210
	.byte	32
	.byte	39
	.byte	167
	.byte	192
	.byte	32
	.byte	166
	.byte	41
	.byte	224
	.byte	49
	.byte	166
	.byte	169
	.byte	137
	.byte	104
	.byte	54
	.byte	104
	.byte	12
	.byte	140
	.byte	8
	.byte	114
	.byte	26
	.byte	99
	.byte	26
	.byte	3
	.byte	154
	.byte	218
	.byte	0
	.byte	135
	.byte	199
	.byte	137
	.byte	116
	.byte	39
	.byte	34
	.byte	167
	.byte	32
	.byte	166
	.byte	113
	.byte	12
	.byte	57
	.byte	13
	.byte	49
	.byte	103
	.byte	158
	.byte	137
	.byte	13
	.byte	10
	.byte	76
	.byte	158
	.byte	212
	.byte	141
	.byte	32
	.byte	156
	.byte	38
	.byte	34
	.byte	166
	.byte	113
	.byte	166
	.byte	135
	.byte	135
	.byte	121
	.byte	50
	.byte	25
	.byte	45
	.byte	113
	.byte	146
	.byte	13
	.byte	27
	.byte	115
	.byte	120
	.byte	36
	.byte	39
	.byte	27
	.byte	157
	.byte	102
	.byte	155
	.byte	160
	.byte	192
	.byte	24
	.byte	211
	.byte	116
	.byte	154
	.byte	168
	.byte	33
	.byte	166
	.byte	177
	.byte	113
	.byte	120
	.byte	146
	.byte	199
	.byte	112
	.byte	156
	.byte	52
	.byte	12
	.byte	130
	.byte	18
	.byte	27
	.byte	215
	.byte	160
	.byte	169
	.byte	164
	.byte	49
	.byte	77
	.byte	131
	.byte	73
	.byte	67
	.byte	195
	.byte	116
	.byte	54
	.byte	136
	.byte	52
	.byte	8
	.byte	131
	.byte	105
	.byte	13
	.byte	26
	.byte	147
	.byte	211
	.byte	134
	.byte	217
	.byte	24
	.byte	231
	.byte	49
	.byte	32
	.byte	141
	.byte	77
	.byte	3
	.byte	158
	.byte	52
	.byte	157
	.byte	130
	.byte	48
	.byte	113
	.byte	50
	.byte	121
	.byte	24
	.byte	55
	.byte	13
	.byte	2
	.byte	195
	.byte	192
	.byte	112
	.byte	39
	.byte	104
	.byte	162
	.byte	113
	.byte	114
	.byte	146
	.byte	135
	.byte	141
	.byte	157
	.byte	224
	.byte	193
	.byte	228
	.byte	228
	.byte	105
	.byte	220
	.byte	9
	.byte	114
	.byte	34
	.byte	210
	.byte	32
	.byte	167
	.byte	209
	.byte	24
	.byte	219
	.byte	9
	.byte	118
	.byte	34
	.byte	199
	.byte	201
	.byte	0
	.byte	39
	.byte	13
	.byte	167
	.byte	229
	.byte	105
	.byte	194
	.byte	137
	.byte	52
	.byte	198
	.byte	228
	.byte	73
	.byte	230
	.byte	52
	.byte	141
	.byte	41
	.byte	201
	.byte	73
	.byte	30
	.byte	39
	.byte	156
	.byte	26
	.byte	119
	.byte	34
	.byte	54
	.byte	136
	.byte	104
	.byte	210
	.byte	201
	.byte	9
	.byte	131
	.byte	136
	.byte	157
	.byte	194
	.byte	113
	.byte	194
	.byte	13
	.byte	40
	.byte	105
	.byte	39
	.byte	54
	.byte	156
	.byte	136
	.byte	152
	.byte	13
	.byte	39
	.byte	157
	.byte	200
	.byte	196
	.byte	105
	.byte	76
	.byte	230
	.byte	105
	.byte	230
	.byte	193
	.byte	105
	.byte	230
	.byte	228
	.byte	116
	.byte	104
	.byte	35
	.byte	73
	.byte	195
	.byte	100
	.byte	158
	.byte	157
	.byte	130
	.byte	208
	.byte	12
	.byte	217
	.byte	120
	.byte	112
	.byte	166
	.byte	121
	.byte	39
	.byte	130
	.byte	230
	.byte	153
	.byte	118
	.byte	40
	.byte	141
	.byte	49
	.byte	121
	.byte	140
	.byte	153
	.byte	39
	.byte	49
	.byte	57
	.byte	153
	.byte	147
	.byte	57
	.byte	121
	.byte	156
	.byte	72
	.byte	76
	.byte	39
	.byte	146
	.byte	147
	.byte	13
	.byte	119
	.byte	74
	.byte	138
	.byte	64
	.byte	78
	.byte	30
	.byte	211
	.byte	72
	.byte	146
	.byte	199
	.byte	112
	.byte	210
	.byte	112
	.byte	56
	.byte	53
	.byte	98
	.byte	220
	.byte	152
	.byte	96
	.byte	78
	.byte	180
	.byte	228
	.byte	73
	.byte	78
	.byte	76
	.byte	30
	.byte	230
	.byte	73
	.byte	54
	.byte	211
	.byte	128
	.byte	103
	.byte	166
	.byte	121
	.byte	166
	.byte	153
	.byte	39
	.byte	13
	.byte	147
	.byte	121
	.byte	120
	.byte	198
	.byte	152
	.byte	157
	.byte	194
	.byte	105
	.byte	13
	.byte	39
	.byte	162
	.byte	68
	.byte	195
	.byte	228
	.byte	228
	.byte	225
	.byte	225
	.byte	217
	.byte	52
	.byte	48
	.byte	8
	.byte	226
	.byte	225
	.byte	100
	.byte	54
	.byte	76
	.byte	230
	.byte	73
	.byte	54
	.byte	30
	.byte	39
	.byte	210
	.byte	24
	.byte	147
	.byte	217
	.byte	198
	.byte	208
	.byte	112
	.byte	199
	.byte	136
	.byte	137
	.byte	32
	.byte	39
	.byte	216
	.byte	48
	.byte	49
	.byte	121
	.byte	166
	.byte	121
	.byte	48
	.byte	121
	.byte	54
	.byte	192
	.byte	228
	.byte	177
	.byte	97
	.byte	158
	.byte	49
	.byte	76
	.byte	156
	.byte	156
	.byte	105
	.byte	76
	.byte	54
	.byte	156
	.byte	228
	.byte	157
	.byte	8
	.byte	99
	.byte	98
	.byte	114
	.byte	210
	.byte	144
	.byte	83
	.byte	35
	.byte	198
	.byte	228
	.byte	73
	.byte	54
	.byte	230
	.byte	196
	.byte	52
	.byte	13
	.byte	48
	.byte	57
	.byte	49
	.byte	121
	.byte	120
	.byte	12
	.byte	57
	.byte	49
	.byte	13
	.byte	135
	.byte	13
	.byte	121
	.byte	114
	.byte	120
	.byte	146
	.byte	147
	.byte	121
	.byte	18
	.byte	147
	.byte	39
	.byte	57
	.byte	153
	.byte	39
	.byte	13
	.byte	147
	.byte	121
	.byte	146
	.byte	103
	.byte	210
	.byte	152
	.byte	13
	.byte	147
	.byte	13
	.byte	135
	.byte	103
	.byte	210
	.byte	112
	.byte	146
	.byte	39
	.byte	13
	.byte	57
	.byte	121
	.byte	166
	.byte	153
	.byte	147
	.byte	121
	.byte	12
	.byte	39
	.byte	121
	.byte	146
	.byte	19
	.byte	13
	.byte	147
	.byte	135
	.byte	135
	.byte	19
	.byte	147
	.byte	121
	.byte	146
	.byte	141
	.byte	135
	.byte	121
	.byte	146
	.byte	147
	.byte	135
	.byte	57
	.byte	49
	.byte	153
	.byte	147
	.byte	39
	.byte	121
	.byte	120
	.byte	216
	.byte	48
	.byte	49
	.byte	121
	.byte	146
	.byte	57
	.byte	217
	.byte	152
	.byte	13
	.byte	147
	.byte	217
	.byte	120
	.byte	152
	.byte	39
	.byte	217
	.byte	152
	.byte	19
	.byte	147
	.byte	135
	.byte	13
	.byte	141
	.byte	121
	.byte	146
	.byte	147
	.byte	121
	.byte	146
	.byte	39
	.byte	121
	.byte	210
	.byte	208
	.byte	112
	.byte	146
	.byte	39
	.byte	217
	.byte	216
	.byte	112
	.byte	216
	.byte	48
	.byte	49
	.byte	121
	.byte	216
	.byte	48
	.byte	113
	.byte	114
	.byte	216
	.byte	152
	.byte	135
	.byte	39
	.byte	121
	.byte	120
	.byte	146
	.byte	109
	.byte	152
	.byte	19
	.byte	147
	.byte	147
	.byte	121
	.byte	146
	.byte	39
	.byte	135
	.byte	57
	.byte	217
	.byte	112
	.byte	146
	.byte	135
	.byte	141
	.byte	217
	.byte	152
	.byte	39
	.byte	121
	.byte	146
	.byte	141
	.byte	121
	.byte	146
	.byte	121
	.byte	210
	.byte	152
	.byte	39
	.byte	121
	.byte	146
	.byte	57
	.byte	217
	.byte	112
	.byte	146
	.byte	39
	.byte	121
	.byte	114
	.byte	152
	.byte	39
	.byte	57
	.byte	153
	.byte	39
	.byte	121
	.byte	114
	.byte	152
	.byte	141
	.byte	13
	.byte	135
	.byte	13
	.byte	39
	.byte	135
	.byte	57
	.byte	153
	.byte	13
	.byte	39
	.byte	141
	.byte	121
	.byte	120
	.byte	152
	.byte	147
	.byte	57
	.byte	57
	.byte	153
	.byte	57
	.byte	121
	.byte	120
	.byte	120
	.byte	120
	.byte	216
	.byte	152
	.byte	39
	.byte	217
	.byte	112
	.byte	146
	.byte	19
	.byte	147
	.byte	103
	.byte	114
	.byte	156
	.byte	72
	.byte	195
	.byte	73
	.byte	230
	.byte	228
	.byte	225
	.byte	97
	.byte	99
	.byte	158
	.byte	228
	.byte	225
	.byte	73
	.byte	30
	.byte	230
	.byte	228
	.byte	73
	.byte	54
	.byte	230
	.byte	73
	.byte	54
	.byte	76
	.byte	230
	.byte	73
	.byte	78
	.byte	230
	.byte	100
	.byte	78
	.byte	230
	.byte	49
	.byte	28
	.byte	30
	.byte	158
	.byte	100
	.byte	99
	.byte	158
	.byte	100
	.byte	158
	.byte	228
	.byte	100
	.byte	195
	.byte	73
	.byte	158
	.byte	228
	.byte	73
	.byte	78
	.byte	230
	.byte	100
	.byte	158
	.byte	228
	.byte	228
	.byte	97
	.byte	54
	.byte	54
	.byte	228
	.byte	228
	.byte	225
	.byte	73
	.byte	54
	.byte	230
	.byte	73
	.byte	158
	.byte	100
	.byte	99
	.byte	158
	.byte	100
	.byte	78
	.byte	158
	.byte	100
	.byte	195
	.byte	100
	.byte	158
	.byte	228
	.byte	73
	.byte	67
	.byte	195
	.byte	100
	.byte	78
	.byte	230
	.byte	100
	.byte	158
	.byte	228
	.byte	100
	.byte	78
	.byte	54
	.byte	156
	.byte	228
	.byte	73
	.byte	230
	.byte	100
	.byte	195
	.byte	100
	.byte	78
	.byte	230
	.byte	73
	.byte	78
	.byte	230
	.byte	73
	.byte	78
	.byte	230
	.byte	100
	.byte	158
	.byte	228
	.byte	100
	.byte	78
	.byte	230
	.byte	100
	.byte	158
	.byte	228
	.align	2
wdi_HANDCLAP:
	.byte	130
	.byte	136
	.byte	3
	.byte	223
	.byte	101
	.byte	108
	.byte	139
	.byte	9
	.byte	168
	.byte	34
	.byte	40
	.byte	66
	.byte	56
	.byte	34
	.byte	161
	.byte	11
	.byte	192
	.byte	74
	.byte	32
	.byte	232
	.byte	108
	.byte	102
	.byte	230
	.byte	225
	.byte	94
	.byte	164
	.byte	155
	.byte	2
	.byte	112
	.byte	56
	.byte	151
	.byte	106
	.byte	225
	.byte	97
	.byte	125
	.byte	53
	.byte	174
	.byte	22
	.byte	172
	.byte	177
	.byte	0
	.byte	138
	.byte	192
	.byte	3
	.byte	42
	.byte	137
	.byte	34
	.byte	48
	.byte	34
	.byte	40
	.byte	34
	.byte	39
	.byte	4
	.byte	177
	.byte	223
	.byte	48
	.byte	2
	.byte	160
	.byte	176
	.byte	168
	.byte	16
	.byte	224
	.byte	138
	.byte	137
	.byte	128
	.byte	46
	.byte	17
	.byte	233
	.byte	108
	.byte	40
	.byte	58
	.byte	21
	.byte	62
	.byte	48
	.byte	34
	.byte	32
	.byte	194
	.byte	130
	.byte	8
	.byte	156
	.byte	140
	.byte	128
	.byte	133
	.byte	51
	.byte	34
	.byte	102
	.byte	10
	.byte	185
	.byte	164
	.byte	40
	.byte	148
	.byte	232
	.byte	36
	.byte	50
	.byte	192
	.byte	90
	.byte	225
	.byte	11
	.byte	153
	.byte	56
	.byte	16
	.byte	107
	.byte	187
	.byte	80
	.byte	225
	.byte	35
	.byte	137
	.byte	34
	.byte	10
	.byte	32
	.byte	74
	.byte	186
	.byte	128
	.byte	105
	.byte	176
	.byte	2
	.byte	176
	.byte	15
	.byte	105
	.byte	32
	.byte	163
	.byte	44
	.byte	24
	.byte	162
	.byte	48
	.byte	67
	.byte	56
	.byte	192
	.byte	138
	.byte	164
	.byte	34
	.byte	129
	.byte	40
	.byte	185
	.byte	9
	.byte	139
	.byte	52
	.byte	104
	.byte	132
	.byte	248
	.byte	8
	.byte	11
	.byte	193
	.byte	40
	.byte	148
	.byte	234
	.byte	4
	.byte	11
	.byte	98
	.byte	122
	.byte	185
	.byte	144
	.byte	34
	.byte	6
	.byte	216
	.byte	108
	.byte	138
	.byte	161
	.byte	3
	.byte	232
	.byte	137
	.byte	144
	.byte	162
	.byte	111
	.byte	137
	.byte	2
	.byte	102
	.byte	233
	.byte	46
	.byte	129
	.byte	12
	.byte	34
	.byte	144
	.byte	184
	.byte	15
	.byte	0
	.byte	40
	.byte	146
	.byte	44
	.byte	172
	.byte	82
	.byte	138
	.byte	37
	.byte	171
	.byte	136
	.byte	21
	.byte	172
	.byte	162
	.byte	0
	.byte	26
	.byte	137
	.byte	178
	.byte	36
	.byte	38
	.byte	141
	.byte	34
	.byte	192
	.byte	32
	.byte	52
	.byte	219
	.byte	66
	.byte	1
	.byte	254
	.byte	64
	.byte	181
	.byte	138
	.byte	1
	.byte	160
	.byte	251
	.byte	20
	.byte	176
	.byte	30
	.byte	153
	.byte	110
	.byte	83
	.byte	186
	.byte	86
	.byte	42
	.byte	172
	.byte	36
	.byte	20
	.byte	250
	.byte	108
	.byte	38
	.byte	18
	.byte	234
	.byte	74
	.byte	32
	.byte	14
	.byte	50
	.byte	2
	.byte	160
	.byte	154
	.byte	180
	.byte	192
	.byte	50
	.byte	132
	.byte	156
	.byte	40
	.byte	34
	.byte	44
	.byte	5
	.byte	238
	.byte	132
	.byte	56
	.byte	130
	.byte	36
	.byte	196
	.byte	110
	.byte	34
	.byte	129
	.byte	250
	.byte	36
	.byte	34
	.byte	148
	.byte	14
	.byte	50
	.byte	128
	.byte	122
	.byte	5
	.byte	190
	.byte	8
	.byte	24
	.byte	41
	.byte	208
	.byte	131
	.byte	76
	.byte	229
	.byte	154
	.byte	192
	.byte	105
	.byte	192
	.byte	18
	.byte	249
	.byte	3
	.byte	100
	.byte	195
	.byte	65
	.byte	143
	.byte	20
	.byte	11
	.byte	58
	.byte	89
	.byte	169
	.byte	230
	.byte	70
	.byte	78
	.byte	185
	.byte	84
	.byte	186
	.byte	82
	.byte	177
	.byte	10
	.byte	129
	.byte	56
	.byte	98
	.byte	182
	.byte	37
	.byte	152
	.byte	243
	.byte	90
	.byte	16
	.byte	19
	.byte	125
	.byte	131
	.byte	192
	.byte	136
	.byte	180
	.byte	21
	.byte	58
	.byte	154
	.byte	104
	.byte	162
	.byte	28
	.byte	20
	.byte	252
	.byte	132
	.byte	72
	.byte	110
	.byte	70
	.byte	204
	.byte	205
	.byte	6
	.byte	136
	.byte	67
	.byte	78
	.byte	228
	.byte	19
	.byte	185
	.byte	20
	.byte	236
	.byte	76
	.byte	196
	.byte	73
	.byte	107
	.byte	100
	.byte	7
	.byte	43
	.byte	70
	.byte	204
	.byte	54
	.byte	68
	.byte	220
	.byte	2
	.byte	145
	.byte	175
	.byte	87
	.byte	140
	.byte	34
	.byte	64
	.byte	28
	.byte	110
	.byte	102
	.byte	235
	.byte	5
	.byte	238
	.byte	17
	.byte	184
	.byte	75
	.byte	144
	.byte	10
	.byte	115
	.byte	193
	.byte	10
	.byte	209
	.byte	38
	.byte	39
	.byte	13
	.byte	121
	.byte	216
	.byte	208
	.byte	26
	.byte	185
	.byte	71
	.byte	56
	.byte	13
	.byte	57
	.byte	7
	.byte	141
	.byte	25
	.byte	211
	.byte	50
	.byte	49
	.byte	17
	.byte	185
	.byte	147
	.byte	145
	.byte	167
	.byte	27
	.byte	121
	.byte	48
	.byte	121
	.byte	26
	.byte	121
	.byte	146
	.byte	51
	.byte	25
	.byte	57
	.byte	115
	.byte	161
	.byte	158
	.byte	193
	.byte	228
	.byte	52
	.byte	100
	.byte	78
	.byte	198
	.byte	100
	.byte	235
	.byte	89
	.byte	34
	.byte	57
	.byte	121
	.byte	152
	.byte	167
	.byte	147
	.byte	23
	.byte	104
	.byte	107
	.byte	198
	.byte	201
	.byte	52
	.byte	68
	.byte	78
	.byte	99
	.byte	30
	.byte	182
	.byte	100
	.byte	76
	.byte	75
	.byte	52
	.byte	228
	.byte	156
	.byte	28
	.byte	228
	.byte	102
	.byte	230
	.byte	52
	.byte	100
	.byte	54
	.byte	204
	.byte	100
	.byte	230
	.byte	228
	.byte	145
	.byte	182
	.byte	28
	.byte	28
	.byte	78
	.byte	19
	.byte	108
	.byte	102
	.byte	110
	.byte	102
	.byte	195
	.byte	97
	.byte	75
	.byte	54
	.byte	228
	.byte	228
	.byte	196
	.byte	225
	.byte	100
	.byte	230
	.byte	228
	.byte	97
	.byte	75
	.byte	30
	.byte	54
	.byte	102
	.byte	230
	.byte	76
	.byte	28
	.byte	30
	.byte	230
	.byte	28
	.byte	198
	.byte	28
	.byte	76
	.byte	78
	.byte	102
	.byte	158
	.byte	228
	.byte	228
	.byte	73
	.byte	78
	.byte	102
	.byte	78
	.byte	78
	.byte	102
	.byte	78
	.byte	99
	.byte	198
	.byte	228
	.byte	100
	.byte	195
	.byte	100
	.byte	30
	.byte	230
	.byte	105
	.byte	30
	.byte	180
	.byte	102
	.byte	230
	.byte	201
	.byte	68
	.byte	78
	.byte	158
	.byte	228
	.byte	100
	.byte	230
	.byte	52
	.byte	228
	.byte	201
	.byte	97
	.byte	99
	.align	2
wdi_HC909:
	.byte	136
	.byte	136
	.byte	156
	.byte	216
	.byte	157
	.byte	156
	.byte	220
	.byte	41
	.byte	136
	.byte	104
	.byte	131
	.byte	166
	.byte	72
	.byte	195
	.byte	192
	.byte	136
	.byte	136
	.byte	136
	.byte	114
	.byte	10
	.byte	141
	.byte	120
	.byte	40
	.byte	156
	.byte	166
	.byte	136
	.byte	136
	.byte	32
	.byte	158
	.byte	34
	.byte	38
	.byte	50
	.byte	41
	.byte	10
	.byte	167
	.byte	48
	.byte	104
	.byte	162
	.byte	136
	.byte	52
	.byte	200
	.byte	32
	.byte	194
	.byte	166
	.byte	8
	.byte	167
	.byte	152
	.byte	130
	.byte	180
	.byte	32
	.byte	154
	.byte	2
	.byte	195
	.byte	8
	.byte	131
	.byte	136
	.byte	141
	.byte	32
	.byte	108
	.byte	162
	.byte	105
	.byte	99
	.byte	10
	.byte	34
	.byte	131
	.byte	156
	.byte	130
	.byte	200
	.byte	216
	.byte	41
	.byte	34
	.byte	40
	.byte	136
	.byte	167
	.byte	41
	.byte	34
	.byte	152
	.byte	131
	.byte	136
	.byte	104
	.byte	154
	.byte	48
	.byte	2
	.byte	195
	.byte	48
	.byte	40
	.byte	156
	.byte	130
	.byte	118
	.byte	138
	.byte	32
	.byte	131
	.byte	130
	.byte	98
	.byte	10
	.byte	10
	.byte	54
	.byte	48
	.byte	12
	.byte	195
	.byte	137
	.byte	136
	.byte	34
	.byte	154
	.byte	146
	.byte	162
	.byte	201
	.byte	105
	.byte	10
	.byte	131
	.byte	40
	.byte	57
	.byte	130
	.byte	152
	.byte	54
	.byte	34
	.byte	136
	.byte	154
	.byte	216
	.byte	136
	.byte	105
	.byte	138
	.byte	48
	.byte	166
	.byte	136
	.byte	157
	.byte	40
	.byte	130
	.byte	194
	.byte	32
	.byte	154
	.byte	34
	.byte	52
	.byte	114
	.byte	10
	.byte	138
	.byte	136
	.byte	137
	.byte	38
	.byte	154
	.byte	162
	.byte	116
	.byte	162
	.byte	13
	.byte	218
	.byte	160
	.byte	41
	.byte	98
	.byte	138
	.byte	8
	.byte	162
	.byte	221
	.byte	32
	.byte	162
	.byte	152
	.byte	34
	.byte	8
	.byte	211
	.byte	2
	.byte	140
	.byte	166
	.byte	13
	.byte	34
	.byte	154
	.byte	154
	.byte	40
	.byte	32
	.byte	167
	.byte	41
	.byte	34
	.byte	104
	.byte	131
	.byte	200
	.byte	157
	.byte	40
	.byte	34
	.byte	136
	.byte	40
	.byte	230
	.byte	73
	.byte	163
	.byte	32
	.byte	34
	.byte	121
	.byte	131
	.byte	38
	.byte	114
	.byte	10
	.byte	10
	.byte	211
	.byte	160
	.byte	8
	.byte	131
	.byte	200
	.byte	32
	.byte	162
	.byte	141
	.byte	137
	.byte	130
	.byte	160
	.byte	154
	.byte	116
	.byte	138
	.byte	54
	.byte	48
	.byte	130
	.byte	156
	.byte	166
	.byte	48
	.byte	156
	.byte	130
	.byte	34
	.byte	130
	.byte	40
	.byte	220
	.byte	32
	.byte	154
	.byte	136
	.byte	136
	.byte	198
	.byte	38
	.byte	10
	.byte	12
	.byte	12
	.byte	55
	.byte	130
	.byte	2
	.byte	163
	.byte	137
	.byte	224
	.byte	137
	.byte	8
	.byte	55
	.byte	34
	.byte	200
	.byte	152
	.byte	136
	.byte	40
	.byte	130
	.byte	160
	.byte	121
	.byte	211
	.byte	13
	.byte	138
	.byte	32
	.byte	34
	.byte	50
	.byte	112
	.byte	138
	.byte	32
	.byte	138
	.byte	102
	.byte	162
	.byte	157
	.byte	98
	.byte	162
	.byte	76
	.byte	55
	.byte	136
	.byte	40
	.byte	136
	.byte	130
	.byte	200
	.byte	137
	.byte	200
	.byte	13
	.byte	34
	.byte	34
	.byte	154
	.byte	64
	.byte	51
	.byte	34
	.byte	224
	.byte	217
	.byte	8
	.byte	54
	.byte	54
	.byte	130
	.byte	136
	.byte	130
	.byte	180
	.byte	13
	.byte	34
	.byte	194
	.byte	48
	.byte	200
	.byte	41
	.byte	136
	.byte	160
	.byte	217
	.byte	166
	.byte	32
	.byte	154
	.byte	38
	.byte	167
	.byte	112
	.byte	10
	.byte	138
	.byte	52
	.byte	34
	.byte	130
	.byte	141
	.byte	160
	.byte	13
	.byte	34
	.byte	194
	.byte	130
	.byte	38
	.byte	154
	.byte	216
	.byte	48
	.byte	200
	.byte	137
	.byte	8
	.byte	163
	.byte	41
	.byte	76
	.byte	10
	.byte	131
	.byte	54
	.byte	136
	.byte	130
	.byte	8
	.byte	39
	.byte	140
	.byte	136
	.byte	130
	.byte	137
	.byte	109
	.byte	166
	.byte	136
	.byte	160
	.byte	214
	.byte	141
	.byte	8
	.byte	162
	.byte	32
	.byte	109
	.byte	162
	.byte	128
	.byte	98
	.byte	40
	.byte	28
	.byte	102
	.byte	55
	.byte	136
	.byte	112
	.byte	146
	.byte	147
	.byte	57
	.byte	153
	.byte	141
	.align	2
wdi_HO909:
	.byte	130
	.byte	48
	.byte	38
	.byte	106
	.byte	109
	.byte	156
	.byte	130
	.byte	76
	.byte	42
	.byte	141
	.byte	41
	.byte	194
	.byte	220
	.byte	137
	.byte	130
	.byte	216
	.byte	160
	.byte	112
	.byte	162
	.byte	136
	.byte	2
	.byte	138
	.byte	13
	.byte	131
	.byte	48
	.byte	162
	.byte	49
	.byte	176
	.byte	192
	.byte	152
	.byte	34
	.byte	166
	.byte	136
	.byte	156
	.byte	137
	.byte	114
	.byte	131
	.byte	40
	.byte	12
	.byte	130
	.byte	220
	.byte	32
	.byte	138
	.byte	160
	.byte	52
	.byte	34
	.byte	34
	.byte	8
	.byte	140
	.byte	104
	.byte	167
	.byte	141
	.byte	32
	.byte	114
	.byte	138
	.byte	32
	.byte	34
	.byte	54
	.byte	168
	.byte	128
	.byte	49
	.byte	167
	.byte	136
	.byte	201
	.byte	152
	.byte	166
	.byte	38
	.byte	162
	.byte	201
	.byte	160
	.byte	136
	.byte	216
	.byte	137
	.byte	130
	.byte	130
	.byte	156
	.byte	130
	.byte	34
	.byte	194
	.byte	152
	.byte	156
	.byte	130
	.byte	136
	.byte	156
	.byte	98
	.byte	131
	.byte	54
	.byte	136
	.byte	130
	.byte	104
	.byte	162
	.byte	32
	.byte	167
	.byte	32
	.byte	2
	.byte	247
	.byte	9
	.byte	131
	.byte	136
	.byte	98
	.byte	99
	.byte	138
	.byte	152
	.byte	40
	.byte	34
	.byte	141
	.byte	166
	.byte	38
	.byte	140
	.byte	201
	.byte	8
	.byte	34
	.byte	3
	.byte	138
	.byte	156
	.byte	12
	.byte	34
	.byte	140
	.byte	105
	.byte	42
	.byte	48
	.byte	136
	.byte	120
	.byte	162
	.byte	201
	.byte	8
	.byte	40
	.byte	194
	.byte	32
	.byte	74
	.byte	163
	.byte	105
	.byte	138
	.byte	8
	.byte	108
	.byte	108
	.byte	34
	.byte	54
	.byte	136
	.byte	166
	.byte	48
	.byte	168
	.byte	201
	.byte	137
	.byte	130
	.byte	104
	.byte	131
	.byte	48
	.byte	34
	.byte	98
	.byte	162
	.byte	54
	.byte	136
	.byte	166
	.byte	137
	.byte	162
	.byte	161
	.byte	38
	.byte	162
	.byte	199
	.byte	152
	.byte	130
	.byte	146
	.byte	194
	.byte	156
	.byte	130
	.byte	12
	.byte	140
	.byte	160
	.byte	13
	.byte	34
	.byte	202
	.byte	137
	.byte	141
	.byte	160
	.byte	96
	.byte	131
	.byte	130
	.byte	54
	.byte	34
	.byte	130
	.byte	13
	.byte	34
	.byte	42
	.byte	104
	.byte	26
	.byte	55
	.byte	34
	.byte	38
	.byte	194
	.byte	130
	.byte	32
	.byte	99
	.byte	131
	.byte	2
	.byte	131
	.byte	39
	.byte	140
	.byte	8
	.byte	34
	.byte	195
	.byte	105
	.byte	154
	.byte	34
	.byte	34
	.byte	130
	.byte	138
	.byte	153
	.byte	78
	.byte	34
	.byte	106
	.byte	12
	.byte	114
	.byte	138
	.byte	136
	.byte	41
	.byte	54
	.byte	136
	.byte	141
	.byte	104
	.byte	34
	.byte	194
	.byte	72
	.byte	163
	.byte	41
	.byte	136
	.byte	141
	.byte	192
	.byte	8
	.byte	131
	.byte	166
	.byte	152
	.byte	154
	.byte	8
	.byte	35
	.byte	34
	.byte	8
	.byte	51
	.byte	8
	.byte	44
	.byte	118
	.byte	130
	.byte	42
	.byte	137
	.byte	54
	.byte	48
	.byte	98
	.byte	42
	.byte	8
	.byte	57
	.byte	118
	.byte	34
	.byte	138
	.byte	38
	.byte	140
	.byte	166
	.byte	105
	.byte	10
	.byte	35
	.byte	8
	.byte	140
	.byte	76
	.byte	35
	.byte	40
	.byte	8
	.byte	204
	.byte	156
	.byte	160
	.byte	8
	.byte	138
	.byte	169
	.byte	104
	.byte	41
	.byte	205
	.byte	41
	.byte	136
	.byte	48
	.byte	140
	.byte	48
	.byte	136
	.byte	32
	.byte	45
	.byte	130
	.byte	228
	.byte	52
	.byte	114
	.byte	162
	.byte	32
	.byte	166
	.byte	112
	.byte	138
	.byte	48
	.byte	38
	.byte	167
	.byte	8
	.byte	131
	.byte	48
	.byte	194
	.byte	32
	.byte	154
	.byte	130
	.byte	41
	.byte	131
	.byte	72
	.byte	27
	.byte	35
	.byte	136
	.byte	194
	.byte	32
	.byte	50
	.byte	54
	.byte	160
	.byte	141
	.byte	8
	.byte	154
	.byte	34
	.byte	156
	.byte	194
	.byte	48
	.byte	13
	.byte	138
	.byte	8
	.byte	34
	.byte	162
	.byte	152
	.byte	217
	.byte	98
	.byte	130
	.byte	138
	.byte	18
	.byte	3
	.byte	27
	.byte	3
	.byte	78
	.byte	11
	.byte	54
	.byte	104
	.byte	10
	.byte	34
	.byte	114
	.byte	106
	.byte	34
	.byte	106
	.byte	98
	.byte	50
	.byte	130
	.byte	136
	.byte	13
	.byte	99
	.byte	10
	.byte	10
	.byte	108
	.byte	34
	.byte	40
	.byte	141
	.byte	166
	.byte	41
	.byte	166
	.byte	192
	.byte	224
	.byte	128
	.byte	194
	.byte	198
	.byte	160
	.byte	152
	.byte	210
	.byte	136
	.byte	136
	.byte	112
	.byte	194
	.byte	166
	.byte	137
	.byte	168
	.byte	41
	.byte	166
	.byte	169
	.byte	144
	.byte	98
	.byte	158
	.byte	130
	.byte	13
	.byte	10
	.byte	106
	.byte	162
	.byte	41
	.byte	48
	.byte	40
	.byte	154
	.byte	166
	.byte	13
	.byte	34
	.byte	40
	.byte	166
	.byte	41
	.byte	42
	.byte	105
	.byte	147
	.byte	154
	.byte	96
	.byte	27
	.byte	155
	.byte	136
	.byte	34
	.byte	112
	.byte	131
	.byte	168
	.byte	9
	.byte	167
	.byte	8
	.byte	131
	.byte	8
	.byte	138
	.byte	169
	.byte	157
	.byte	40
	.byte	104
	.byte	154
	.byte	140
	.byte	201
	.byte	41
	.byte	34
	.byte	40
	.byte	216
	.byte	160
	.byte	201
	.byte	192
	.byte	160
	.byte	192
	.byte	130
	.byte	160
	.byte	39
	.byte	154
	.byte	54
	.byte	2
	.byte	167
	.byte	160
	.byte	102
	.byte	167
	.byte	136
	.byte	198
	.byte	32
	.byte	99
	.byte	131
	.byte	136
	.byte	146
	.byte	130
	.byte	218
	.byte	8
	.byte	12
	.byte	35
	.byte	160
	.byte	216
	.byte	8
	.byte	12
	.byte	99
	.byte	138
	.byte	137
	.byte	34
	.byte	39
	.byte	140
	.byte	192
	.byte	52
	.byte	34
	.byte	130
	.byte	220
	.byte	32
	.byte	10
	.byte	218
	.byte	32
	.byte	200
	.byte	48
	.byte	8
	.byte	195
	.byte	137
	.byte	40
	.byte	40
	.byte	56
	.byte	112
	.byte	34
	.byte	108
	.byte	140
	.byte	160
	.byte	41
	.byte	39
	.byte	104
	.byte	35
	.byte	200
	.byte	41
	.byte	98
	.byte	162
	.byte	141
	.byte	41
	.byte	200
	.byte	192
	.byte	32
	.byte	35
	.byte	38
	.byte	194
	.byte	200
	.byte	225
	.byte	52
	.byte	34
	.byte	130
	.byte	40
	.byte	2
	.byte	154
	.byte	210
	.byte	38
	.byte	166
	.byte	140
	.byte	152
	.byte	136
	.byte	38
	.byte	26
	.byte	155
	.byte	118
	.byte	138
	.byte	8
	.byte	10
	.byte	154
	.byte	141
	.byte	112
	.byte	50
	.byte	130
	.byte	136
	.byte	40
	.byte	38
	.byte	140
	.byte	169
	.byte	41
	.byte	166
	.byte	32
	.byte	194
	.byte	48
	.byte	136
	.byte	72
	.byte	158
	.byte	182
	.byte	41
	.byte	169
	.byte	41
	.byte	48
	.byte	104
	.byte	162
	.byte	216
	.byte	32
	.byte	138
	.byte	41
	.byte	48
	.byte	140
	.byte	160
	.byte	57
	.byte	41
	.byte	176
	.byte	41
	.byte	176
	.byte	137
	.byte	166
	.byte	160
	.byte	152
	.byte	48
	.byte	168
	.byte	177
	.byte	49
	.byte	200
	.byte	160
	.byte	41
	.byte	176
	.byte	208
	.byte	136
	.byte	66
	.byte	35
	.byte	194
	.byte	128
	.byte	162
	.byte	128
	.byte	210
	.byte	156
	.byte	166
	.byte	105
	.byte	106
	.byte	154
	.byte	130
	.byte	34
	.byte	28
	.byte	155
	.byte	166
	.byte	41
	.byte	34
	.byte	156
	.byte	130
	.byte	34
	.byte	136
	.byte	98
	.byte	158
	.byte	216
	.byte	8
	.byte	10
	.byte	26
	.byte	195
	.byte	166
	.byte	96
	.byte	10
	.byte	131
	.byte	48
	.byte	54
	.byte	136
	.byte	38
	.byte	35
	.byte	130
	.byte	72
	.byte	155
	.byte	8
	.byte	131
	.byte	98
	.byte	12
	.byte	195
	.byte	8
	.byte	54
	.byte	12
	.byte	140
	.byte	160
	.byte	48
	.byte	224
	.byte	41
	.byte	136
	.byte	54
	.byte	130
	.byte	136
	.byte	216
	.byte	192
	.byte	160
	.byte	112
	.byte	10
	.byte	131
	.byte	130
	.byte	224
	.byte	24
	.byte	131
	.byte	38
	.byte	27
	.byte	74
	.byte	11
	.byte	98
	.byte	154
	.byte	12
	.byte	74
	.byte	106
	.byte	138
	.byte	105
	.byte	106
	.byte	74
	.byte	10
	.byte	142
	.byte	137
	.byte	216
	.byte	160
	.byte	41
	.byte	54
	.byte	40
	.byte	13
	.byte	162
	.byte	160
	.byte	48
	.byte	156
	.byte	200
	.byte	32
	.byte	230
	.byte	137
	.byte	136
	.byte	104
	.byte	42
	.byte	49
	.byte	156
	.byte	194
	.byte	152
	.byte	166
	.byte	48
	.byte	136
	.byte	130
	.byte	38
	.byte	140
	.byte	136
	.byte	41
	.byte	54
	.byte	120
	.byte	12
	.byte	162
	.byte	52
	.byte	34
	.byte	168
	.byte	161
	.byte	201
	.byte	164
	.byte	160
	.byte	176
	.byte	198
	.byte	52
	.byte	40
	.byte	134
	.byte	195
	.byte	32
	.byte	40
	.byte	54
	.byte	8
	.byte	167
	.byte	48
	.byte	156
	.byte	130
	.byte	166
	.byte	152
	.byte	26
	.byte	155
	.byte	2
	.byte	35
	.byte	104
	.byte	74
	.byte	35
	.byte	40
	.byte	40
	.byte	109
	.byte	154
	.byte	40
	.byte	136
	.byte	112
	.byte	131
	.byte	130
	.byte	136
	.byte	2
	.byte	30
	.byte	155
	.byte	224
	.byte	105
	.byte	106
	.byte	154
	.byte	166
	.byte	160
	.byte	152
	.byte	2
	.byte	195
	.byte	41
	.byte	40
	.byte	39
	.byte	154
	.byte	34
	.byte	13
	.byte	10
	.byte	98
	.byte	195
	.byte	41
	.byte	130
	.byte	40
	.byte	200
	.byte	169
	.byte	9
	.byte	226
	.byte	137
	.byte	180
	.byte	41
	.byte	136
	.byte	200
	.byte	192
	.byte	52
	.byte	130
	.byte	136
	.byte	221
	.byte	160
	.byte	192
	.byte	160
	.byte	224
	.byte	36
	.byte	167
	.byte	8
	.byte	154
	.byte	130
	.byte	130
	.byte	220
	.byte	152
	.byte	34
	.byte	12
	.byte	12
	.byte	114
	.byte	162
	.byte	41
	.byte	104
	.byte	138
	.byte	169
	.byte	73
	.byte	35
	.byte	39
	.byte	50
	.byte	8
	.byte	162
	.byte	224
	.byte	201
	.byte	41
	.byte	38
	.byte	131
	.byte	130
	.byte	48
	.byte	48
	.byte	156
	.byte	194
	.byte	32
	.byte	12
	.byte	154
	.byte	154
	.byte	136
	.byte	112
	.byte	138
	.byte	198
	.byte	152
	.byte	136
	.byte	12
	.byte	74
	.byte	35
	.byte	48
	.byte	120
	.byte	140
	.byte	160
	.byte	41
	.byte	176
	.byte	41
	.byte	166
	.byte	164
	.byte	200
	.byte	105
	.byte	131
	.byte	130
	.byte	160
	.byte	48
	.byte	152
	.byte	210
	.byte	48
	.byte	54
	.byte	40
	.byte	198
	.byte	136
	.byte	32
	.byte	74
	.byte	155
	.byte	98
	.byte	34
	.byte	74
	.byte	78
	.byte	35
	.byte	34
	.byte	136
	.byte	104
	.byte	154
	.byte	136
	.byte	13
	.byte	10
	.byte	10
	.byte	39
	.byte	12
	.byte	13
	.byte	106
	.byte	202
	.byte	49
	.byte	40
	.byte	38
	.byte	156
	.byte	54
	.byte	136
	.byte	200
	.byte	152
	.byte	134
	.byte	131
	.byte	136
	.byte	221
	.byte	160
	.byte	32
	.byte	34
	.byte	13
	.byte	34
	.byte	218
	.byte	157
	.byte	130
	.byte	54
	.byte	130
	.byte	104
	.byte	34
	.byte	10
	.byte	109
	.byte	10
	.byte	114
	.byte	10
	.byte	56
	.byte	48
	.byte	168
	.byte	161
	.byte	166
	.byte	41
	.byte	48
	.byte	200
	.byte	224
	.byte	49
	.byte	136
	.byte	166
	.byte	49
	.byte	168
	.byte	137
	.byte	216
	.byte	192
	.byte	160
	.byte	38
	.byte	220
	.byte	152
	.byte	130
	.byte	8
	.byte	76
	.byte	27
	.byte	35
	.byte	141
	.byte	8
	.byte	138
	.byte	8
	.byte	12
	.byte	12
	.byte	130
	.byte	98
	.byte	219
	.byte	73
	.byte	131
	.byte	135
	.byte	162
	.byte	9
	.byte	42
	.byte	150
	.byte	119
	.byte	34
	.byte	12
	.byte	167
	.byte	72
	.byte	42
	.byte	105
	.byte	131
	.byte	38
	.byte	162
	.byte	72
	.byte	131
	.byte	154
	.byte	134
	.byte	104
	.byte	3
	.byte	211
	.byte	48
	.byte	136
	.byte	13
	.byte	10
	.byte	106
	.byte	166
	.byte	141
	.byte	137
	.byte	130
	.byte	136
	.byte	156
	.byte	52
	.byte	220
	.byte	32
	.byte	34
	.byte	114
	.byte	140
	.byte	160
	.byte	169
	.byte	137
	.byte	41
	.byte	54
	.byte	166
	.byte	152
	.byte	34
	.byte	200
	.byte	160
	.byte	157
	.byte	98
	.byte	10
	.byte	162
	.byte	152
	.byte	136
	.byte	166
	.byte	72
	.byte	218
	.byte	136
	.byte	201
	.byte	164
	.byte	52
	.byte	40
	.byte	98
	.byte	182
	.byte	137
	.byte	156
	.byte	98
	.byte	34
	.byte	34
	.byte	38
	.byte	3
	.byte	3
	.byte	163
	.byte	9
	.byte	120
	.byte	10
	.byte	98
	.byte	172
	.byte	153
	.byte	198
	.byte	8
	.byte	167
	.byte	32
	.byte	18
	.byte	167
	.byte	154
	.byte	13
	.byte	26
	.byte	35
	.byte	13
	.byte	138
	.byte	137
	.byte	194
	.byte	52
	.byte	200
	.byte	137
	.byte	194
	.byte	32
	.byte	141
	.byte	152
	.byte	104
	.byte	162
	.byte	48
	.byte	141
	.byte	9
	.byte	163
	.byte	192
	.byte	105
	.byte	162
	.byte	166
	.byte	225
	.byte	41
	.byte	136
	.byte	38
	.byte	138
	.byte	192
	.byte	157
	.byte	130
	.byte	8
	.byte	167
	.byte	41
	.byte	8
	.byte	167
	.byte	136
	.byte	121
	.byte	12
	.byte	131
	.byte	136
	.byte	8
	.byte	74
	.byte	211
	.byte	32
	.byte	98
	.byte	219
	.byte	137
	.byte	34
	.byte	48
	.byte	141
	.byte	8
	.byte	138
	.byte	128
	.byte	13
	.byte	154
	.byte	39
	.byte	194
	.byte	8
	.byte	156
	.byte	130
	.byte	198
	.byte	52
	.byte	12
	.byte	130
	.byte	194
	.byte	41
	.byte	200
	.byte	24
	.byte	182
	.byte	137
	.byte	160
	.byte	116
	.byte	131
	.byte	228
	.byte	41
	.byte	8
	.byte	147
	.byte	50
	.byte	8
	.byte	167
	.byte	128
	.byte	199
	.byte	112
	.byte	34
	.byte	40
	.byte	230
	.byte	105
	.byte	10
	.byte	39
	.byte	40
	.byte	54
	.byte	104
	.byte	218
	.byte	105
	.byte	226
	.byte	41
	.byte	8
	.byte	226
	.byte	137
	.byte	121
	.byte	34
	.byte	10
	.byte	50
	.byte	136
	.byte	216
	.byte	137
	.byte	54
	.byte	136
	.byte	136
	.byte	105
	.byte	131
	.byte	160
	.byte	28
	.byte	35
	.byte	216
	.byte	160
	.byte	41
	.byte	130
	.byte	48
	.byte	180
	.byte	53
	.byte	32
	.byte	211
	.byte	52
	.byte	130
	.byte	141
	.byte	152
	.byte	2
	.byte	131
	.byte	104
	.byte	74
	.byte	147
	.byte	98
	.byte	114
	.byte	74
	.byte	131
	.byte	166
	.byte	136
	.byte	128
	.byte	30
	.byte	167
	.byte	192
	.byte	112
	.byte	154
	.byte	130
	.byte	166
	.byte	8
	.byte	156
	.byte	38
	.byte	54
	.byte	136
	.byte	104
	.byte	146
	.byte	199
	.byte	32
	.byte	194
	.byte	156
	.byte	152
	.byte	48
	.byte	98
	.byte	162
	.byte	141
	.byte	198
	.byte	105
	.byte	10
	.byte	74
	.byte	131
	.byte	12
	.byte	156
	.byte	34
	.byte	8
	.byte	166
	.byte	52
	.byte	226
	.byte	217
	.byte	208
	.byte	52
	.byte	8
	.byte	131
	.byte	38
	.byte	131
	.byte	105
	.byte	3
	.byte	35
	.byte	12
	.byte	98
	.byte	10
	.byte	131
	.byte	105
	.byte	10
	.byte	3
	.byte	74
	.byte	99
	.byte	10
	.byte	130
	.byte	13
	.byte	103
	.byte	108
	.byte	108
	.byte	112
	.byte	176
	.byte	77
	.byte	141
	.byte	104
	.byte	40
	.byte	177
	.byte	153
	.byte	135
	.byte	199
	.byte	208
	.byte	41
	.byte	156
	.byte	228
	.byte	153
	.byte	141
	.byte	157
	.byte	48
	.byte	98
	.byte	194
	.byte	13
	.byte	194
	.byte	160
	.byte	128
	.byte	200
	.byte	73
	.byte	167
	.byte	13
	.byte	2
	.byte	118
	.byte	35
	.byte	32
	.byte	135
	.byte	147
	.byte	121
	.byte	182
	.byte	113
	.byte	140
	.byte	48
	.byte	112
	.byte	162
	.byte	137
	.byte	166
	.byte	160
	.byte	137
	.byte	41
	.byte	230
	.byte	198
	.byte	49
	.byte	100
	.byte	236
	.byte	53
	.byte	160
	.byte	102
	.byte	218
	.byte	208
	.byte	6
	.byte	103
	.byte	147
	.byte	130
	.byte	135
	.byte	157
	.byte	194
	.byte	97
	.byte	99
	.byte	30
	.byte	99
	.byte	30
	.byte	158
	.byte	113
	.byte	194
	.byte	152
	.byte	77
	.byte	167
	.byte	104
	.byte	130
	.byte	121
	.byte	216
	.byte	112
	.byte	210
	.byte	105
	.byte	131
	.byte	192
	.byte	152
	.byte	199
	.byte	9
	.byte	147
	.byte	102
	.byte	99
	.byte	158
	.byte	28
	.byte	39
	.byte	166
	.byte	217
	.byte	36
	.byte	147
	.byte	199
	.byte	105
	.byte	34
	.byte	121
	.byte	39
	.byte	40
	.byte	102
	.byte	30
	.byte	78
	.byte	54
	.byte	76
	.byte	54
	.byte	156
	.byte	201
	.byte	153
	.byte	228
	.byte	196
	.byte	156
	.byte	73
	.byte	54
	.byte	156
	.byte	198
	.byte	105
	.byte	76
	.byte	156
	.byte	102
	.byte	158
	.byte	228
	.byte	100
	.byte	158
	.byte	198
	.byte	100
	.byte	78
	.byte	30
	.byte	30
	.byte	230
	.byte	100
	.byte	78
	.byte	158
	.byte	28
	.byte	52
	.byte	102
	.byte	27
	.byte	158
	.byte	201
	.byte	73
	.byte	76
	.byte	99
	.byte	30
	.byte	54
	.byte	28
	.byte	158
	.byte	228
	.byte	73
	.byte	158
	.byte	228
	.byte	225
	.byte	73
	.byte	158
	.byte	105
	.byte	158
	.byte	100
	.byte	195
	.byte	73
	.byte	158
	.byte	228
	.byte	73
	.align	2
wdi_SD909:
	.byte	34
	.byte	130
	.byte	146
	.byte	147
	.byte	57
	.byte	121
	.byte	146
	.byte	39
	.byte	121
	.byte	146
	.byte	39
	.byte	121
	.byte	146
	.byte	39
	.byte	121
	.byte	216
	.byte	152
	.byte	7
	.byte	205
	.byte	153
	.byte	251
	.byte	171
	.byte	130
	.byte	112
	.byte	4
	.byte	145
	.byte	153
	.byte	136
	.byte	186
	.byte	140
	.byte	42
	.byte	35
	.byte	34
	.byte	0
	.byte	129
	.byte	113
	.byte	128
	.byte	88
	.byte	12
	.byte	161
	.byte	8
	.byte	235
	.byte	54
	.byte	162
	.byte	194
	.byte	10
	.byte	174
	.byte	138
	.byte	96
	.byte	29
	.byte	37
	.byte	1
	.byte	4
	.byte	145
	.byte	9
	.byte	12
	.byte	163
	.byte	232
	.byte	44
	.byte	51
	.byte	138
	.byte	12
	.byte	138
	.byte	32
	.byte	146
	.byte	129
	.byte	37
	.byte	153
	.byte	144
	.byte	32
	.byte	130
	.byte	102
	.byte	182
	.byte	140
	.byte	168
	.byte	120
	.byte	163
	.byte	168
	.byte	32
	.byte	24
	.byte	118
	.byte	131
	.byte	152
	.byte	8
	.byte	106
	.byte	38
	.byte	39
	.byte	38
	.byte	136
	.byte	49
	.byte	136
	.byte	104
	.byte	167
	.byte	8
	.byte	131
	.byte	162
	.byte	106
	.byte	203
	.byte	194
	.byte	140
	.byte	160
	.byte	41
	.byte	48
	.byte	152
	.byte	36
	.byte	24
	.byte	64
	.byte	72
	.byte	105
	.byte	130
	.byte	40
	.byte	184
	.byte	179
	.byte	202
	.byte	204
	.byte	140
	.byte	166
	.byte	10
	.byte	98
	.byte	106
	.byte	49
	.byte	192
	.byte	9
	.byte	96
	.byte	18
	.byte	156
	.byte	38
	.byte	130
	.byte	76
	.byte	35
	.byte	138
	.byte	54
	.byte	194
	.byte	162
	.byte	136
	.byte	99
	.byte	162
	.byte	157
	.byte	152
	.byte	156
	.byte	104
	.byte	10
	.byte	168
	.byte	153
	.byte	8
	.byte	160
	.byte	77
	.byte	166
	.byte	157
	.byte	34
	.byte	38
	.byte	10
	.byte	35
	.byte	168
	.byte	176
	.byte	168
	.byte	108
	.byte	163
	.byte	169
	.byte	105
	.byte	154
	.byte	156
	.byte	104
	.byte	130
	.byte	152
	.byte	160
	.byte	193
	.byte	128
	.byte	54
	.byte	130
	.byte	140
	.byte	138
	.byte	44
	.byte	227
	.byte	41
	.byte	226
	.byte	228
	.byte	160
	.byte	73
	.byte	131
	.byte	38
	.byte	32
	.byte	135
	.byte	72
	.byte	114
	.byte	114
	.byte	162
	.byte	152
	.byte	40
	.byte	54
	.byte	140
	.byte	169
	.byte	8
	.byte	42
	.byte	32
	.byte	131
	.byte	113
	.byte	35
	.byte	8
	.byte	210
	.byte	136
	.byte	137
	.byte	192
	.byte	217
	.byte	32
	.byte	152
	.byte	210
	.byte	137
	.byte	166
	.byte	134
	.byte	10
	.byte	162
	.byte	56
	.byte	50
	.byte	237
	.byte	50
	.byte	54
	.byte	48
	.byte	230
	.byte	41
	.byte	32
	.byte	76
	.byte	166
	.byte	137
	.byte	137
	.byte	9
	.byte	154
	.byte	41
	.byte	167
	.byte	52
	.byte	10
	.byte	42
	.byte	210
	.byte	26
	.byte	138
	.byte	216
	.byte	104
	.byte	12
	.byte	130
	.byte	146
	.byte	146
	.byte	156
	.byte	13
	.byte	34
	.byte	54
	.byte	32
	.byte	106
	.byte	50
	.byte	12
	.byte	10
	.byte	202
	.byte	160
	.byte	135
	.byte	39
	.byte	74
	.byte	35
	.byte	38
	.byte	10
	.byte	160
	.byte	53
	.byte	135
	.byte	194
	.byte	9
	.byte	12
	.byte	131
	.byte	8
	.byte	39
	.byte	154
	.byte	160
	.byte	140
	.byte	225
	.byte	48
	.byte	200
	.byte	241
	.byte	8
	.byte	155
	.byte	166
	.byte	105
	.byte	10
	.byte	194
	.byte	33
	.byte	72
	.byte	30
	.byte	146
	.byte	101
	.byte	158
	.byte	8
	.byte	195
	.byte	216
	.byte	160
	.byte	136
	.byte	226
	.byte	177
	.byte	100
	.byte	163
	.byte	128
	.byte	166
	.byte	25
	.byte	19
	.byte	135
	.byte	53
	.byte	6
	.byte	230
	.byte	49
	.byte	96
	.byte	218
	.byte	137
	.byte	167
	.byte	141
	.byte	157
	.byte	34
	.byte	54
	.byte	98
	.byte	34
	.byte	114
	.byte	34
	.byte	130
	.byte	214
	.byte	112
	.byte	162
	.byte	49
	.byte	130
	.byte	9
	.byte	131
	.byte	48
	.byte	13
	.byte	40
	.byte	166
	.byte	156
	.byte	48
	.byte	198
	.byte	156
	.byte	39
	.byte	167
	.byte	104
	.byte	146
	.byte	131
	.byte	41
	.byte	201
	.byte	53
	.byte	146
	.byte	8
	.byte	18
	.byte	153
	.byte	147
	.byte	77
	.byte	218
	.byte	141
	.byte	136
	.byte	52
	.byte	30
	.byte	99
	.byte	204
	.byte	105
	.byte	76
	.byte	230
	.byte	193
	.byte	196
	.byte	201
	.byte	97
	.byte	228
	.byte	196
	.byte	228
	.byte	73
	.byte	102
	.byte	78
	.byte	115
	.byte	10
	.byte	141
	.byte	141
	.byte	135
	.byte	45
	.byte	217
	.byte	112
	.byte	216
	.byte	112
	.byte	18
	.byte	211
	.byte	137
	.byte	153
	.byte	102
	.byte	76
	.byte	158
	.byte	105
	.byte	28
	.byte	39
	.byte	131
	.byte	52
	.byte	76
	.byte	30
	.byte	78
	.byte	78
	.byte	158
	.byte	228
	.byte	100
	.byte	99
	.byte	30
	.byte	230
	.byte	73
	.byte	76
	.byte	102
	.byte	230
	.byte	73
	.byte	158
	.byte	228
	.byte	228
	.byte	225
	.byte	52
	.byte	76
	.byte	54
	.byte	76
	.byte	30
	.byte	78
	.byte	230
	.byte	196
	.byte	73
	.byte	78
	.byte	102
	.byte	67
	.byte	30
	.byte	30
	.byte	30
	.byte	230
	.byte	201
	.byte	97
	.byte	78
	.byte	99
	.byte	78
	.byte	230
	.byte	100
	.byte	99
	.byte	54
	.byte	230
	.byte	73
	.byte	158
	.byte	228
	.byte	73
	.byte	230
	.byte	100
	.byte	158
	.byte	100
	.byte	158
	.byte	228
	.byte	73
	.byte	78
	.byte	230
	.byte	100
	.byte	78
	.byte	158
	.byte	228
	.byte	228
	.byte	228
	.byte	97
	.byte	99
	.byte	158
	.byte	228
	.byte	73
	.byte	230
	.byte	100
	.byte	230
	.byte	73
	.byte	230
	.byte	100
	.byte	78
	.byte	230
	.byte	228
	.byte	100
	.byte	99
	.byte	78
	.byte	230
	.byte	228
	.byte	73
	.byte	158
	.byte	228
	.byte	73
	.byte	230
	.byte	100
	.byte	158
	.byte	100
	.byte	78
	.byte	230
	.byte	100
	.byte	78
	.byte	230
	.byte	100
	.byte	78
	.byte	230
	.byte	100
	.byte	78
	.byte	230
	.byte	100
	.byte	78
	.byte	230
	.byte	100
	.byte	78
	.byte	230
	.byte	100
	.byte	78
	.byte	230
	.byte	100
	.byte	78
	.align	2
wdi_SDGATE:
	.byte	136
	.byte	136
	.byte	156
	.byte	216
	.byte	201
	.byte	221
	.byte	137
	.byte	118
	.byte	162
	.byte	2
	.byte	35
	.byte	54
	.byte	2
	.byte	163
	.byte	137
	.byte	112
	.byte	34
	.byte	162
	.byte	216
	.byte	136
	.byte	40
	.byte	38
	.byte	10
	.byte	140
	.byte	137
	.byte	35
	.byte	136
	.byte	9
	.byte	27
	.byte	140
	.byte	38
	.byte	42
	.byte	200
	.byte	41
	.byte	98
	.byte	114
	.byte	34
	.byte	136
	.byte	198
	.byte	160
	.byte	162
	.byte	136
	.byte	182
	.byte	120
	.byte	32
	.byte	138
	.byte	137
	.byte	50
	.byte	169
	.byte	164
	.byte	13
	.byte	166
	.byte	34
	.byte	137
	.byte	128
	.byte	196
	.byte	226
	.byte	98
	.byte	194
	.byte	161
	.byte	138
	.byte	32
	.byte	165
	.byte	131
	.byte	18
	.byte	72
	.byte	15
	.byte	131
	.byte	135
	.byte	42
	.byte	201
	.byte	130
	.byte	108
	.byte	192
	.byte	128
	.byte	2
	.byte	6
	.byte	194
	.byte	206
	.byte	54
	.byte	130
	.byte	72
	.byte	154
	.byte	164
	.byte	162
	.byte	122
	.byte	50
	.byte	8
	.byte	99
	.byte	140
	.byte	164
	.byte	128
	.byte	167
	.byte	168
	.byte	0
	.byte	167
	.byte	194
	.byte	154
	.byte	137
	.byte	36
	.byte	166
	.byte	160
	.byte	232
	.byte	9
	.byte	40
	.byte	44
	.byte	236
	.byte	96
	.byte	163
	.byte	96
	.byte	192
	.byte	54
	.byte	130
	.byte	8
	.byte	28
	.byte	163
	.byte	162
	.byte	156
	.byte	130
	.byte	9
	.byte	38
	.byte	8
	.byte	167
	.byte	36
	.byte	203
	.byte	52
	.byte	12
	.byte	34
	.byte	130
	.byte	38
	.byte	162
	.byte	39
	.byte	44
	.byte	136
	.byte	152
	.byte	11
	.byte	38
	.byte	78
	.byte	40
	.byte	130
	.byte	137
	.byte	131
	.byte	70
	.byte	162
	.byte	166
	.byte	35
	.byte	44
	.byte	146
	.byte	2
	.byte	160
	.byte	215
	.byte	72
	.byte	163
	.byte	136
	.byte	194
	.byte	104
	.byte	160
	.byte	161
	.byte	128
	.byte	135
	.byte	139
	.byte	158
	.byte	152
	.byte	8
	.byte	194
	.byte	0
	.byte	50
	.byte	136
	.byte	210
	.byte	44
	.byte	42
	.byte	54
	.byte	138
	.byte	16
	.byte	172
	.byte	105
	.byte	129
	.byte	136
	.byte	13
	.byte	44
	.byte	55
	.byte	162
	.byte	104
	.byte	14
	.byte	164
	.byte	0
	.byte	130
	.byte	105
	.byte	168
	.byte	219
	.byte	224
	.byte	136
	.byte	168
	.byte	192
	.byte	29
	.byte	34
	.byte	34
	.byte	57
	.byte	141
	.byte	160
	.byte	10
	.byte	12
	.byte	167
	.byte	33
	.byte	162
	.byte	224
	.byte	13
	.byte	154
	.byte	136
	.byte	136
	.byte	166
	.byte	224
	.byte	166
	.byte	27
	.byte	2
	.byte	40
	.byte	98
	.byte	210
	.byte	108
	.byte	154
	.byte	34
	.byte	232
	.byte	64
	.byte	167
	.byte	8
	.byte	160
	.byte	42
	.byte	141
	.byte	135
	.byte	57
	.byte	40
	.byte	98
	.byte	134
	.byte	137
	.byte	106
	.byte	202
	.byte	40
	.byte	67
	.byte	163
	.byte	41
	.byte	8
	.byte	104
	.byte	48
	.byte	161
	.byte	162
	.byte	54
	.byte	219
	.byte	40
	.byte	128
	.byte	18
	.byte	152
	.byte	10
	.byte	184
	.byte	53
	.byte	26
	.byte	3
	.byte	240
	.byte	160
	.byte	166
	.byte	169
	.byte	137
	.byte	8
	.byte	14
	.byte	164
	.byte	141
	.byte	166
	.byte	200
	.byte	32
	.byte	106
	.byte	140
	.byte	49
	.byte	2
	.byte	26
	.byte	35
	.byte	40
	.byte	178
	.byte	41
	.byte	112
	.byte	26
	.byte	35
	.byte	162
	.byte	168
	.byte	153
	.byte	168
	.byte	73
	.byte	34
	.byte	138
	.byte	138
	.byte	49
	.byte	54
	.byte	138
	.byte	41
	.byte	130
	.byte	120
	.byte	121
	.byte	136
	.byte	130
	.byte	169
	.byte	140
	.byte	130
	.byte	194
	.byte	38
	.byte	8
	.byte	27
	.byte	167
	.byte	32
	.byte	12
	.byte	48
	.byte	34
	.byte	45
	.byte	38
	.byte	142
	.byte	48
	.byte	166
	.byte	38
	.byte	72
	.byte	130
	.byte	170
	.byte	25
	.byte	75
	.byte	162
	.byte	42
	.byte	156
	.byte	48
	.byte	166
	.byte	168
	.byte	24
	.byte	54
	.byte	136
	.byte	52
	.byte	160
	.byte	160
	.byte	202
	.byte	89
	.byte	35
	.byte	168
	.byte	136
	.byte	106
	.byte	26
	.byte	14
	.byte	134
	.byte	163
	.byte	26
	.byte	13
	.byte	2
	.byte	146
	.byte	230
	.byte	176
	.byte	32
	.byte	12
	.byte	131
	.byte	38
	.byte	56
	.byte	141
	.byte	40
	.byte	134
	.byte	40
	.byte	198
	.byte	224
	.byte	128
	.byte	154
	.byte	198
	.byte	130
	.byte	8
	.byte	155
	.byte	38
	.byte	44
	.byte	128
	.byte	154
	.byte	104
	.byte	152
	.byte	50
	.byte	155
	.byte	136
	.byte	0
	.byte	10
	.byte	252
	.byte	105
	.byte	131
	.byte	160
	.byte	128
	.byte	104
	.byte	50
	.byte	106
	.byte	200
	.byte	158
	.byte	74
	.byte	162
	.byte	72
	.byte	2
	.byte	109
	.byte	40
	.byte	130
	.byte	152
	.byte	186
	.byte	146
	.byte	170
	.byte	80
	.byte	34
	.byte	27
	.byte	140
	.byte	32
	.byte	76
	.byte	240
	.byte	64
	.byte	140
	.byte	172
	.byte	152
	.byte	76
	.byte	162
	.byte	48
	.byte	66
	.byte	40
	.byte	50
	.byte	41
	.byte	139
	.byte	27
	.byte	162
	.byte	97
	.byte	2
	.byte	138
	.byte	140
	.byte	35
	.byte	14
	.byte	138
	.byte	182
	.byte	36
	.byte	90
	.byte	8
	.byte	210
	.byte	202
	.byte	128
	.byte	234
	.byte	80
	.byte	194
	.byte	52
	.byte	146
	.byte	42
	.byte	6
	.byte	138
	.byte	154
	.byte	140
	.byte	120
	.byte	56
	.byte	130
	.byte	26
	.byte	155
	.byte	196
	.byte	160
	.byte	192
	.byte	195
	.byte	48
	.byte	72
	.byte	34
	.byte	147
	.byte	34
	.byte	168
	.byte	0
	.byte	51
	.byte	50
	.byte	44
	.byte	147
	.byte	38
	.byte	32
	.byte	166
	.byte	12
	.byte	42
	.byte	167
	.byte	10
	.byte	57
	.byte	166
	.byte	96
	.byte	40
	.byte	40
	.byte	104
	.byte	98
	.byte	142
	.byte	105
	.byte	136
	.byte	210
	.byte	57
	.byte	200
	.byte	128
	.byte	35
	.byte	34
	.byte	30
	.byte	50
	.byte	2
	.byte	3
	.byte	135
	.byte	104
	.byte	56
	.byte	10
	.byte	110
	.byte	40
	.byte	152
	.byte	168
	.byte	49
	.byte	38
	.byte	56
	.byte	106
	.byte	26
	.byte	3
	.byte	184
	.byte	134
	.byte	156
	.byte	130
	.byte	38
	.byte	14
	.byte	32
	.byte	155
	.byte	120
	.byte	12
	.byte	10
	.byte	195
	.byte	32
	.byte	40
	.byte	3
	.byte	34
	.byte	154
	.byte	3
	.byte	35
	.byte	146
	.byte	26
	.byte	114
	.byte	166
	.byte	146
	.byte	42
	.byte	226
	.byte	24
	.byte	2
	.byte	56
	.byte	96
	.byte	227
	.byte	41
	.byte	32
	.byte	176
	.byte	120
	.byte	131
	.byte	26
	.byte	154
	.byte	130
	.byte	160
	.byte	198
	.byte	200
	.byte	128
	.byte	182
	.byte	8
	.byte	152
	.byte	32
	.byte	156
	.byte	66
	.byte	174
	.byte	217
	.byte	176
	.byte	33
	.byte	138
	.byte	224
	.byte	104
	.byte	146
	.byte	200
	.byte	146
	.byte	10
	.byte	170
	.byte	196
	.byte	9
	.byte	154
	.byte	52
	.byte	10
	.byte	32
	.byte	200
	.byte	147
	.byte	163
	.byte	8
	.byte	98
	.byte	166
	.byte	146
	.byte	13
	.byte	26
	.byte	10
	.byte	227
	.byte	8
	.byte	106
	.byte	162
	.byte	102
	.byte	104
	.byte	208
	.byte	130
	.byte	130
	.byte	144
	.byte	230
	.byte	30
	.byte	168
	.byte	131
	.byte	216
	.byte	32
	.byte	134
	.byte	140
	.byte	48
	.byte	40
	.byte	134
	.byte	131
	.byte	163
	.byte	161
	.byte	134
	.byte	176
	.byte	144
	.byte	136
	.byte	172
	.byte	39
	.byte	114
	.byte	82
	.byte	154
	.byte	130
	.byte	42
	.byte	172
	.byte	164
	.byte	114
	.byte	9
	.byte	184
	.byte	200
	.byte	130
	.byte	196
	.byte	32
	.byte	162
	.byte	53
	.byte	128
	.byte	182
	.byte	160
	.byte	173
	.byte	153
	.byte	166
	.byte	32
	.byte	13
	.byte	35
	.byte	8
	.byte	46
	.byte	130
	.byte	52
	.byte	12
	.byte	154
	.byte	160
	.byte	33
	.byte	46
	.byte	74
	.byte	138
	.byte	98
	.byte	196
	.byte	39
	.byte	136
	.byte	198
	.byte	32
	.byte	42
	.byte	155
	.byte	35
	.byte	176
	.byte	1
	.byte	35
	.byte	32
	.byte	201
	.byte	138
	.byte	177
	.byte	104
	.byte	194
	.byte	130
	.byte	9
	.byte	178
	.byte	132
	.byte	226
	.byte	97
	.byte	168
	.byte	166
	.byte	166
	.byte	172
	.byte	216
	.byte	52
	.byte	96
	.byte	162
	.byte	160
	.byte	137
	.byte	218
	.byte	38
	.byte	10
	.byte	162
	.byte	184
	.byte	16
	.byte	192
	.byte	100
	.byte	44
	.byte	136
	.byte	139
	.byte	38
	.byte	8
	.byte	9
	.byte	43
	.byte	77
	.byte	10
	.byte	40
	.byte	15
	.byte	2
	.byte	14
	.byte	106
	.byte	73
	.byte	169
	.byte	137
	.byte	152
	.byte	224
	.byte	140
	.byte	201
	.byte	50
	.byte	11
	.byte	176
	.byte	6
	.byte	82
	.byte	6
	.byte	26
	.byte	200
	.byte	167
	.byte	138
	.byte	58
	.byte	152
	.byte	18
	.byte	39
	.byte	105
	.byte	136
	.byte	114
	.byte	10
	.byte	130
	.byte	171
	.byte	142
	.byte	19
	.byte	131
	.byte	36
	.byte	216
	.byte	169
	.byte	128
	.byte	45
	.byte	33
	.byte	140
	.byte	12
	.byte	42
	.byte	10
	.byte	27
	.byte	144
	.byte	54
	.byte	200
	.byte	48
	.byte	38
	.byte	156
	.byte	40
	.byte	38
	.byte	99
	.byte	42
	.byte	41
	.byte	194
	.byte	54
	.byte	168
	.byte	192
	.byte	132
	.byte	134
	.byte	161
	.byte	196
	.byte	180
	.byte	152
	.byte	34
	.byte	50
	.byte	40
	.byte	147
	.byte	166
	.byte	108
	.byte	130
	.byte	18
	.byte	18
	.byte	173
	.byte	41
	.byte	194
	.byte	98
	.byte	24
	.byte	155
	.byte	40
	.byte	162
	.byte	36
	.byte	104
	.byte	57
	.byte	152
	.byte	170
	.byte	72
	.byte	26
	.byte	67
	.byte	105
	.byte	35
	.byte	168
	.byte	214
	.byte	144
	.byte	163
	.byte	42
	.byte	82
	.byte	24
	.byte	74
	.byte	106
	.byte	42
	.byte	57
	.byte	154
	.byte	224
	.byte	96
	.byte	108
	.byte	130
	.byte	164
	.byte	6
	.byte	58
	.byte	169
	.byte	40
	.byte	45
	.byte	174
	.byte	214
	.byte	160
	.byte	73
	.byte	34
	.byte	130
	.byte	176
	.byte	160
	.byte	10
	.byte	55
	.byte	232
	.byte	24
	.byte	33
	.byte	26
	.byte	140
	.byte	45
	.byte	106
	.byte	8
	.byte	204
	.byte	224
	.byte	3
	.byte	128
	.byte	67
	.byte	37
	.byte	50
	.byte	11
	.byte	138
	.byte	232
	.byte	40
	.byte	88
	.byte	72
	.byte	74
	.byte	26
	.byte	66
	.byte	108
	.byte	3
	.byte	139
	.byte	140
	.byte	224
	.byte	129
	.byte	6
	.byte	166
	.byte	51
	.byte	140
	.byte	160
	.byte	166
	.byte	128
	.byte	48
	.byte	105
	.byte	74
	.byte	161
	.byte	36
	.byte	27
	.byte	15
	.byte	162
	.byte	104
	.byte	78
	.byte	34
	.byte	34
	.byte	9
	.byte	44
	.byte	36
	.byte	32
	.byte	159
	.byte	138
	.byte	200
	.byte	201
	.byte	122
	.byte	130
	.byte	132
	.byte	66
	.byte	184
	.byte	24
	.byte	104
	.byte	169
	.byte	56
	.byte	124
	.byte	34
	.byte	128
	.byte	12
	.byte	121
	.byte	2
	.byte	226
	.byte	168
	.byte	240
	.byte	38
	.byte	46
	.byte	33
	.byte	73
	.byte	131
	.byte	24
	.byte	90
	.byte	42
	.byte	206
	.byte	72
	.byte	142
	.byte	6
	.byte	42
	.byte	68
	.byte	200
	.byte	3
	.byte	172
	.byte	160
	.byte	228
	.byte	177
	.byte	48
	.byte	40
	.byte	193
	.byte	144
	.byte	110
	.byte	41
	.byte	146
	.byte	10
	.byte	56
	.byte	168
	.byte	177
	.byte	166
	.byte	73
	.byte	40
	.byte	137
	.byte	131
	.byte	114
	.byte	42
	.byte	18
	.byte	76
	.byte	133
	.byte	58
	.byte	224
	.byte	202
	.byte	137
	.byte	35
	.byte	180
	.byte	128
	.byte	121
	.byte	0
	.byte	210
	.byte	34
	.byte	40
	.byte	129
	.byte	195
	.byte	167
	.byte	48
	.byte	136
	.byte	161
	.byte	201
	.byte	130
	.byte	64
	.byte	60
	.byte	198
	.byte	98
	.byte	12
	.byte	26
	.byte	26
	.byte	11
	.byte	42
	.byte	88
	.byte	150
	.byte	122
	.byte	114
	.byte	162
	.byte	48
	.byte	2
	.byte	135
	.byte	34
	.byte	22
	.byte	169
	.byte	166
	.byte	177
	.byte	98
	.byte	168
	.byte	46
	.byte	142
	.byte	137
	.byte	20
	.byte	6
	.byte	60
	.byte	136
	.byte	163
	.byte	73
	.byte	146
	.byte	106
	.byte	112
	.byte	200
	.byte	38
	.byte	10
	.byte	14
	.byte	159
	.byte	130
	.byte	134
	.byte	96
	.byte	224
	.byte	130
	.byte	164
	.byte	201
	.byte	136
	.byte	202
	.byte	211
	.byte	128
	.byte	32
	.byte	84
	.byte	131
	.byte	141
	.byte	168
	.byte	192
	.byte	128
	.byte	202
	.byte	232
	.byte	88
	.byte	48
	.byte	152
	.byte	146
	.byte	90
	.byte	48
	.byte	11
	.byte	232
	.byte	232
	.byte	161
	.byte	2
	.byte	16
	.byte	94
	.byte	162
	.byte	147
	.byte	2
	.byte	44
	.byte	142
	.byte	133
	.byte	162
	.byte	161
	.byte	240
	.byte	132
	.byte	162
	.byte	51
	.byte	198
	.byte	32
	.byte	155
	.byte	193
	.byte	160
	.byte	33
	.byte	35
	.byte	12
	.byte	99
	.byte	141
	.byte	166
	.byte	40
	.byte	18
	.byte	200
	.byte	164
	.byte	66
	.byte	138
	.byte	82
	.byte	51
	.byte	18
	.byte	131
	.byte	232
	.byte	10
	.byte	164
	.byte	121
	.byte	144
	.byte	12
	.byte	128
	.byte	47
	.byte	140
	.byte	57
	.byte	4
	.byte	170
	.byte	192
	.byte	9
	.byte	102
	.byte	142
	.byte	200
	.byte	72
	.byte	14
	.byte	40
	.byte	64
	.byte	83
	.byte	13
	.byte	152
	.byte	15
	.byte	10
	.byte	12
	.byte	105
	.byte	138
	.byte	14
	.byte	42
	.byte	117
	.byte	64
	.byte	74
	.byte	136
	.byte	44
	.byte	142
	.byte	15
	.byte	166
	.byte	98
	.byte	144
	.byte	128
	.byte	194
	.byte	121
	.byte	165
	.byte	192
	.byte	162
	.byte	188
	.byte	8
	.byte	112
	.byte	16
	.byte	113
	.byte	208
	.byte	131
	.byte	52
	.byte	76
	.byte	201
	.byte	97
	.byte	230
	.byte	177
	.byte	249
	.byte	225
	.byte	160
	.byte	148
	.byte	128
	.byte	156
	.byte	130
	.byte	243
	.byte	9
	.byte	78
	.byte	8
	.byte	176
	.byte	72
	.byte	108
	.byte	34
	.byte	234
	.byte	155
	.byte	34
	.byte	37
	.byte	144
	.byte	0
	.byte	188
	.byte	34
	.byte	122
	.byte	109
	.byte	192
	.byte	38
	.byte	42
	.byte	76
	.byte	66
	.byte	106
	.byte	140
	.byte	200
	.byte	132
	.byte	34
	.byte	90
	.byte	46
	.byte	184
	.byte	76
	.byte	84
	.byte	16
	.byte	155
	.byte	98
	.byte	58
	.byte	12
	.byte	106
	.byte	100
	.byte	70
	.byte	195
	.byte	13
	.byte	166
	.byte	19
	.byte	255
	.byte	0
	.byte	97
	.byte	137
	.byte	210
	.byte	134
	.byte	160
	.byte	196
	.byte	170
	.byte	76
	.byte	108
	.byte	151
	.byte	194
	.byte	2
	.byte	92
	.byte	11
	.byte	108
	.byte	36
	.byte	0
	.byte	62
	.byte	34
	.byte	126
	.byte	168
	.byte	64
	.byte	30
	.byte	23
	.byte	162
	.byte	29
	.byte	163
	.byte	161
	.byte	194
	.byte	72
	.byte	154
	.byte	96
	.byte	10
	.byte	184
	.byte	28
	.byte	31
	.byte	142
	.byte	132
	.byte	52
	.byte	38
	.byte	162
	.byte	34
	.byte	102
	.byte	28
	.byte	143
	.byte	54
	.byte	212
	.byte	32
	.byte	46
	.byte	1
	.byte	135
	.byte	178
	.byte	137
	.byte	224
	.byte	168
	.byte	57
	.byte	164
	.byte	164
	.byte	8
	.byte	105
	.byte	132
	.byte	180
	.byte	74
	.byte	168
	.byte	198
	.byte	244
	.byte	108
	.byte	160
	.byte	22
	.byte	224
	.byte	164
	.byte	228
	.byte	3
	.byte	138
	.byte	24
	.byte	3
	.byte	104
	.byte	56
	.byte	21
	.byte	104
	.byte	99
	.byte	252
	.byte	3
	.byte	138
	.byte	91
	.byte	208
	.byte	5
	.byte	184
	.byte	41
	.byte	177
	.byte	166
	.byte	160
	.byte	90
	.byte	2
	.byte	61
	.byte	131
	.byte	4
	.byte	81
	.byte	120
	.byte	176
	.byte	237
	.byte	50
	.byte	151
	.byte	33
	.byte	56
	.byte	57
	.byte	57
	.byte	5
	.byte	71
	.byte	250
	.byte	131
	.byte	45
	.byte	49
	.byte	33
	.byte	44
	.byte	200
	.byte	37
	.byte	24
	.byte	241
	.byte	37
	.byte	27
	.byte	50
	.byte	34
	.byte	139
	.byte	18
	.byte	62
	.byte	4
	.byte	35
	.byte	24
	.byte	146
	.byte	6
	.byte	163
	.byte	230
	.byte	34
	.byte	74
	.byte	4
	.byte	198
	.byte	41
	.byte	140
	.byte	224
	.byte	4
	.byte	75
	.byte	44
	.byte	162
	.byte	13
	.byte	161
	.byte	225
	.byte	133
	.byte	158
	.byte	226
	.byte	75
	.byte	148
	.byte	99
	.byte	67
	.byte	100
	.byte	206
	.byte	193
	.byte	68
	.byte	100
	.byte	243
	.byte	129
	.byte	139
	.byte	137
	.byte	162
	.byte	7
	.byte	25
	.byte	185
	.byte	199
	.byte	100
	.byte	4
	.byte	219
	.byte	211
	.byte	66
	.byte	34
	.byte	12
	.byte	104
	.byte	228
	.byte	185
	.byte	228
	.byte	86
	.byte	140
	.byte	166
	.byte	48
	.byte	109
	.byte	169
	.byte	198
	.byte	37
	.byte	16
	.byte	123
	.byte	216
	.byte	147
	.byte	2
	.byte	61
	.byte	64
	.byte	118
	.byte	164
	.byte	194
	.byte	147
	.byte	180
	.byte	110
	.byte	70
	.byte	91
	.byte	98
	.byte	57
	.byte	161
	.byte	26
	.byte	202
	.byte	225
	.byte	49
	.byte	28
	.byte	190
	.byte	193
	.byte	92
	.byte	2
	.byte	121
	.byte	225
	.byte	18
	.byte	234
	.byte	73
	.byte	198
	.byte	52
	.byte	180
	.byte	165
	.byte	146
	.byte	19
	.byte	115
	.byte	144
	.byte	147
	.byte	167
	.byte	57
	.byte	145
	.byte	147
	.byte	45
	.byte	17
	.byte	147
	.byte	147
	.byte	147
	.byte	51
	.byte	153
	.byte	151
	.byte	72
	.byte	52
	.byte	76
	.byte	99
	.byte	76
	.byte	78
	.byte	230
	.byte	100
	.byte	78
	.byte	102
	.byte	78
	.byte	54
	.byte	158
	.byte	228
	.byte	73
	.byte	76
	.byte	158
	.byte	76
	.byte	52
	.byte	52
	.byte	156
	.byte	228
	.byte	100
	.align	2
wdi_TOMH1:
	.byte	136
	.byte	8
	.byte	214
	.byte	189
	.byte	153
	.byte	105
	.byte	138
	.byte	137
	.byte	194
	.byte	40
	.byte	106
	.byte	35
	.byte	108
	.byte	162
	.byte	136
	.byte	136
	.byte	136
	.byte	97
	.byte	45
	.byte	169
	.byte	145
	.byte	34
	.byte	180
	.byte	137
	.byte	52
	.byte	168
	.byte	137
	.byte	168
	.byte	128
	.byte	50
	.byte	51
	.byte	194
	.byte	8
	.byte	138
	.byte	41
	.byte	168
	.byte	117
	.byte	34
	.byte	230
	.byte	137
	.byte	164
	.byte	136
	.byte	32
	.byte	39
	.byte	34
	.byte	50
	.byte	140
	.byte	200
	.byte	162
	.byte	128
	.byte	163
	.byte	2
	.byte	35
	.byte	130
	.byte	164
	.byte	100
	.byte	156
	.byte	113
	.byte	104
	.byte	34
	.byte	160
	.byte	9
	.byte	130
	.byte	40
	.byte	122
	.byte	47
	.byte	216
	.byte	140
	.byte	10
	.byte	42
	.byte	162
	.byte	8
	.byte	38
	.byte	150
	.byte	25
	.byte	39
	.byte	128
	.byte	193
	.byte	132
	.byte	72
	.byte	66
	.byte	154
	.byte	136
	.byte	163
	.byte	172
	.byte	226
	.byte	184
	.byte	43
	.byte	44
	.byte	227
	.byte	130
	.byte	0
	.byte	100
	.byte	65
	.byte	69
	.byte	96
	.byte	17
	.byte	82
	.byte	98
	.byte	152
	.byte	128
	.byte	164
	.byte	8
	.byte	207
	.byte	227
	.byte	200
	.byte	10
	.byte	43
	.byte	42
	.byte	170
	.byte	230
	.byte	212
	.byte	153
	.byte	144
	.byte	132
	.byte	132
	.byte	100
	.byte	24
	.byte	32
	.byte	70
	.byte	130
	.byte	97
	.byte	163
	.byte	168
	.byte	190
	.byte	204
	.byte	140
	.byte	131
	.byte	170
	.byte	130
	.byte	35
	.byte	112
	.byte	129
	.byte	84
	.byte	64
	.byte	101
	.byte	66
	.byte	72
	.byte	66
	.byte	144
	.byte	24
	.byte	136
	.byte	56
	.byte	203
	.byte	139
	.byte	203
	.byte	170
	.byte	218
	.byte	42
	.byte	139
	.byte	178
	.byte	64
	.byte	94
	.byte	9
	.byte	96
	.byte	65
	.byte	22
	.byte	164
	.byte	1
	.byte	6
	.byte	152
	.byte	49
	.byte	164
	.byte	136
	.byte	227
	.byte	204
	.byte	162
	.byte	56
	.byte	142
	.byte	138
	.byte	171
	.byte	140
	.byte	113
	.byte	88
	.byte	73
	.byte	66
	.byte	97
	.byte	145
	.byte	6
	.byte	104
	.byte	22
	.byte	10
	.byte	9
	.byte	12
	.byte	42
	.byte	250
	.byte	190
	.byte	234
	.byte	187
	.byte	235
	.byte	254
	.byte	194
	.byte	210
	.byte	12
	.byte	25
	.byte	89
	.byte	165
	.byte	64
	.byte	9
	.byte	6
	.byte	4
	.byte	148
	.byte	37
	.byte	66
	.byte	136
	.byte	73
	.byte	47
	.byte	171
	.byte	55
	.byte	179
	.byte	40
	.byte	142
	.byte	170
	.byte	182
	.byte	230
	.byte	25
	.byte	148
	.byte	20
	.byte	156
	.byte	81
	.byte	102
	.byte	36
	.byte	38
	.byte	64
	.byte	114
	.byte	130
	.byte	0
	.byte	222
	.byte	168
	.byte	35
	.byte	250
	.byte	179
	.byte	232
	.byte	60
	.byte	172
	.byte	166
	.byte	147
	.byte	121
	.byte	16
	.byte	71
	.byte	80
	.byte	24
	.byte	81
	.byte	22
	.byte	98
	.byte	68
	.byte	148
	.byte	68
	.byte	102
	.byte	78
	.byte	203
	.byte	243
	.byte	232
	.byte	248
	.byte	205
	.byte	200
	.byte	48
	.byte	138
	.byte	40
	.byte	153
	.byte	7
	.byte	89
	.byte	102
	.byte	112
	.byte	97
	.byte	8
	.byte	5
	.byte	151
	.byte	153
	.byte	32
	.byte	9
	.byte	233
	.byte	233
	.byte	244
	.byte	50
	.byte	172
	.byte	240
	.byte	56
	.byte	51
	.byte	59
	.byte	141
	.byte	135
	.byte	121
	.byte	144
	.byte	153
	.byte	101
	.byte	6
	.byte	217
	.byte	1
	.byte	92
	.byte	2
	.byte	17
	.byte	103
	.byte	24
	.byte	167
	.byte	141
	.byte	211
	.byte	206
	.byte	120
	.byte	43
	.byte	222
	.byte	40
	.byte	179
	.byte	57
	.byte	13
	.byte	13
	.byte	25
	.byte	135
	.byte	17
	.byte	113
	.byte	112
	.byte	16
	.byte	153
	.byte	209
	.byte	9
	.byte	100
	.byte	76
	.byte	198
	.byte	57
	.byte	182
	.byte	108
	.byte	179
	.byte	204
	.byte	230
	.byte	220
	.byte	104
	.byte	122
	.byte	154
	.byte	57
	.byte	25
	.byte	7
	.byte	153
	.byte	153
	.byte	71
	.byte	18
	.byte	153
	.byte	121
	.byte	144
	.byte	153
	.byte	153
	.byte	121
	.byte	12
	.byte	51
	.byte	57
	.byte	167
	.byte	219
	.byte	216
	.byte	50
	.byte	39
	.byte	115
	.byte	140
	.byte	141
	.byte	153
	.byte	135
	.byte	153
	.byte	153
	.byte	7
	.byte	49
	.byte	145
	.byte	121
	.byte	144
	.byte	7
	.byte	7
	.byte	135
	.byte	49
	.byte	217
	.byte	210
	.byte	120
	.byte	58
	.byte	57
	.byte	141
	.byte	211
	.byte	50
	.byte	57
	.byte	57
	.byte	57
	.byte	153
	.byte	121
	.byte	152
	.byte	121
	.byte	112
	.byte	152
	.byte	153
	.byte	135
	.byte	153
	.byte	153
	.byte	7
	.byte	39
	.byte	153
	.byte	57
	.byte	57
	.byte	57
	.byte	141
	.byte	147
	.byte	211
	.byte	216
	.byte	56
	.byte	57
	.byte	57
	.byte	57
	.byte	121
	.byte	152
	.byte	135
	.byte	153
	.byte	121
	.byte	146
	.byte	153
	.byte	135
	.byte	121
	.byte	112
	.byte	152
	.byte	135
	.byte	153
	.byte	19
	.byte	39
	.byte	141
	.byte	141
	.byte	39
	.byte	147
	.byte	39
	.byte	147
	.byte	147
	.byte	147
	.byte	147
	.byte	141
	.byte	121
	.byte	146
	.byte	135
	.byte	153
	.byte	135
	.byte	135
	.byte	153
	.byte	39
	.byte	153
	.byte	13
	.byte	121
	.byte	216
	.byte	112
	.byte	152
	.byte	135
	.byte	147
	.byte	39
	.byte	141
	.byte	141
	.byte	13
	.byte	147
	.byte	147
	.byte	147
	.byte	141
	.byte	57
	.byte	121
	.byte	146
	.byte	121
	.byte	146
	.byte	57
	.byte	153
	.byte	121
	.byte	146
	.byte	121
	.byte	146
	.byte	57
	.byte	153
	.byte	121
	.byte	146
	.byte	39
	.byte	217
	.byte	152
	.byte	147
	.byte	147
	.byte	39
	.byte	57
	.byte	121
	.byte	210
	.byte	152
	.byte	147
	.byte	39
	.byte	121
	.byte	146
	.byte	121
	.byte	146
	.byte	39
	.byte	153
	.byte	39
	.byte	121
	.byte	152
	.byte	39
	.byte	153
	.byte	147
	.byte	121
	.byte	146
	.byte	39
	.byte	217
	.byte	152
	.byte	147
	.byte	141
	.byte	57
	.byte	153
	.byte	147
	.byte	39
	.byte	57
	.byte	121
	.byte	146
	.byte	39
	.byte	121
	.byte	146
	.byte	57
	.byte	153
	.byte	39
	.byte	121
	.byte	152
	.byte	147
	.byte	57
	.byte	153
	.byte	39
	.byte	121
	.byte	146
	.byte	57
	.byte	153
	.byte	147
	.byte	39
	.byte	57
	.byte	153
	.byte	147
	.byte	57
	.byte	121
	.byte	146
	.byte	39
	.byte	57
	.byte	153
	.byte	147
	.align	2
wdi_TOML1:
	.byte	104
	.byte	245
	.byte	192
	.byte	10
	.byte	36
	.byte	147
	.byte	166
	.byte	146
	.byte	168
	.byte	52
	.byte	104
	.byte	10
	.byte	10
	.byte	178
	.byte	208
	.byte	130
	.byte	176
	.byte	72
	.byte	155
	.byte	130
	.byte	176
	.byte	8
	.byte	34
	.byte	168
	.byte	136
	.byte	136
	.byte	32
	.byte	146
	.byte	57
	.byte	25
	.byte	151
	.byte	153
	.byte	229
	.byte	194
	.byte	33
	.byte	155
	.byte	134
	.byte	208
	.byte	146
	.byte	34
	.byte	18
	.byte	139
	.byte	134
	.byte	166
	.byte	134
	.byte	26
	.byte	10
	.byte	58
	.byte	137
	.byte	136
	.byte	131
	.byte	167
	.byte	2
	.byte	166
	.byte	130
	.byte	140
	.byte	167
	.byte	40
	.byte	10
	.byte	177
	.byte	136
	.byte	8
	.byte	138
	.byte	136
	.byte	212
	.byte	130
	.byte	52
	.byte	40
	.byte	88
	.byte	67
	.byte	109
	.byte	41
	.byte	30
	.byte	44
	.byte	136
	.byte	224
	.byte	22
	.byte	42
	.byte	147
	.byte	130
	.byte	2
	.byte	34
	.byte	27
	.byte	162
	.byte	48
	.byte	48
	.byte	104
	.byte	170
	.byte	177
	.byte	41
	.byte	138
	.byte	198
	.byte	99
	.byte	138
	.byte	198
	.byte	160
	.byte	40
	.byte	168
	.byte	160
	.byte	212
	.byte	34
	.byte	136
	.byte	8
	.byte	50
	.byte	134
	.byte	180
	.byte	0
	.byte	98
	.byte	57
	.byte	229
	.byte	0
	.byte	3
	.byte	13
	.byte	3
	.byte	35
	.byte	8
	.byte	2
	.byte	56
	.byte	136
	.byte	7
	.byte	10
	.byte	40
	.byte	160
	.byte	76
	.byte	231
	.byte	78
	.byte	59
	.byte	42
	.byte	9
	.byte	246
	.byte	41
	.byte	131
	.byte	138
	.byte	130
	.byte	230
	.byte	160
	.byte	34
	.byte	48
	.byte	140
	.byte	105
	.byte	10
	.byte	40
	.byte	225
	.byte	101
	.byte	41
	.byte	37
	.byte	27
	.byte	34
	.byte	49
	.byte	41
	.byte	129
	.byte	178
	.byte	88
	.byte	200
	.byte	32
	.byte	72
	.byte	104
	.byte	0
	.byte	62
	.byte	33
	.byte	226
	.byte	164
	.byte	140
	.byte	44
	.byte	185
	.byte	48
	.byte	78
	.byte	14
	.byte	131
	.byte	35
	.byte	139
	.byte	8
	.byte	226
	.byte	166
	.byte	108
	.byte	140
	.byte	10
	.byte	130
	.byte	66
	.byte	105
	.byte	92
	.byte	3
	.byte	9
	.byte	147
	.byte	32
	.byte	36
	.byte	73
	.byte	66
	.byte	57
	.byte	97
	.byte	26
	.byte	146
	.byte	8
	.byte	78
	.byte	41
	.byte	160
	.byte	212
	.byte	32
	.byte	146
	.byte	40
	.byte	48
	.byte	76
	.byte	174
	.byte	230
	.byte	10
	.byte	188
	.byte	228
	.byte	176
	.byte	168
	.byte	8
	.byte	143
	.byte	11
	.byte	140
	.byte	74
	.byte	155
	.byte	162
	.byte	130
	.byte	57
	.byte	25
	.byte	185
	.byte	197
	.byte	4
	.byte	17
	.byte	199
	.byte	65
	.byte	161
	.byte	19
	.byte	198
	.byte	0
	.byte	76
	.byte	136
	.byte	132
	.byte	144
	.byte	104
	.byte	28
	.byte	104
	.byte	41
	.byte	136
	.byte	148
	.byte	134
	.byte	74
	.byte	186
	.byte	45
	.byte	56
	.byte	184
	.byte	178
	.byte	57
	.byte	44
	.byte	224
	.byte	130
	.byte	171
	.byte	36
	.byte	139
	.byte	195
	.byte	8
	.byte	138
	.byte	78
	.byte	91
	.byte	154
	.byte	66
	.byte	68
	.byte	76
	.byte	54
	.byte	81
	.byte	12
	.byte	64
	.byte	89
	.byte	18
	.byte	108
	.byte	144
	.byte	161
	.byte	80
	.byte	12
	.byte	64
	.byte	50
	.byte	165
	.byte	8
	.byte	146
	.byte	36
	.byte	130
	.byte	198
	.byte	26
	.byte	63
	.byte	185
	.byte	50
	.byte	194
	.byte	170
	.byte	249
	.byte	44
	.byte	139
	.byte	60
	.byte	185
	.byte	2
	.byte	15
	.byte	42
	.byte	227
	.byte	94
	.byte	142
	.byte	64
	.byte	19
	.byte	60
	.byte	20
	.byte	196
	.byte	148
	.byte	151
	.byte	18
	.byte	2
	.byte	150
	.byte	82
	.byte	196
	.byte	144
	.byte	48
	.byte	132
	.byte	134
	.byte	2
	.byte	80
	.byte	56
	.byte	164
	.byte	133
	.byte	26
	.byte	64
	.byte	56
	.byte	51
	.byte	177
	.byte	111
	.byte	45
	.byte	170
	.byte	203
	.byte	143
	.byte	44
	.byte	27
	.byte	143
	.byte	251
	.byte	184
	.byte	249
	.byte	176
	.byte	61
	.byte	56
	.byte	182
	.byte	156
	.byte	100
	.byte	30
	.byte	180
	.byte	133
	.byte	36
	.byte	25
	.byte	103
	.byte	76
	.byte	25
	.byte	98
	.byte	89
	.byte	166
	.byte	134
	.byte	64
	.byte	54
	.byte	26
	.byte	154
	.byte	36
	.byte	12
	.byte	130
	.byte	177
	.byte	0
	.byte	168
	.byte	144
	.byte	231
	.byte	48
	.byte	45
	.byte	179
	.byte	249
	.byte	62
	.byte	120
	.byte	188
	.byte	146
	.byte	138
	.byte	106
	.byte	238
	.byte	198
	.byte	59
	.byte	204
	.byte	49
	.byte	76
	.byte	110
	.byte	195
	.byte	196
	.byte	97
	.byte	28
	.byte	70
	.byte	19
	.byte	86
	.byte	44
	.byte	64
	.byte	76
	.byte	17
	.byte	83
	.byte	3
	.byte	41
	.byte	80
	.byte	138
	.byte	9
	.byte	165
	.byte	16
	.byte	106
	.byte	88
	.byte	90
	.byte	18
	.byte	147
	.byte	215
	.byte	38
	.byte	138
	.byte	98
	.byte	235
	.byte	54
	.byte	31
	.byte	11
	.byte	42
	.byte	62
	.byte	56
	.byte	31
	.byte	178
	.byte	40
	.byte	50
	.byte	45
	.byte	147
	.byte	45
	.byte	27
	.byte	147
	.byte	57
	.byte	145
	.byte	153
	.byte	25
	.byte	147
	.byte	145
	.byte	209
	.byte	166
	.byte	149
	.byte	150
	.byte	26
	.byte	26
	.byte	18
	.byte	130
	.byte	22
	.byte	66
	.byte	30
	.byte	89
	.byte	74
	.byte	99
	.byte	32
	.byte	209
	.byte	150
	.byte	66
	.byte	206
	.byte	225
	.byte	214
	.byte	131
	.byte	163
	.byte	160
	.byte	57
	.byte	47
	.byte	147
	.byte	59
	.byte	167
	.byte	185
	.byte	167
	.byte	51
	.byte	177
	.byte	51
	.byte	13
	.byte	115
	.byte	120
	.byte	166
	.byte	151
	.byte	72
	.byte	76
	.byte	196
	.byte	100
	.byte	28
	.byte	100
	.byte	70
	.byte	108
	.byte	68
	.byte	39
	.byte	148
	.byte	90
	.byte	32
	.byte	77
	.byte	30
	.byte	72
	.byte	13
	.byte	41
	.byte	37
	.byte	26
	.byte	25
	.byte	77
	.byte	26
	.byte	115
	.byte	154
	.byte	45
	.byte	173
	.byte	79
	.byte	60
	.byte	12
	.byte	186
	.byte	57
	.byte	61
	.byte	224
	.byte	204
	.byte	182
	.byte	180
	.byte	68
	.byte	143
	.byte	218
	.byte	48
	.byte	57
	.byte	135
	.byte	121
	.byte	152
	.byte	19
	.byte	153
	.byte	135
	.byte	29
	.byte	18
	.byte	182
	.byte	97
	.byte	28
	.byte	49
	.byte	73
	.byte	196
	.byte	100
	.byte	196
	.byte	89
	.byte	27
	.byte	34
	.byte	32
	.byte	49
	.byte	133
	.byte	45
	.byte	133
	.byte	135
	.byte	49
	.byte	45
	.byte	121
	.byte	218
	.byte	146
	.byte	123
	.byte	131
	.byte	67
	.byte	227
	.byte	206
	.byte	68
	.byte	235
	.byte	198
	.byte	230
	.byte	76
	.byte	110
	.byte	108
	.byte	75
	.byte	78
	.byte	230
	.byte	30
	.byte	76
	.byte	28
	.byte	30
	.byte	102
	.byte	76
	.byte	102
	.byte	198
	.byte	70
	.byte	28
	.byte	76
	.byte	228
	.byte	97
	.byte	52
	.byte	196
	.byte	193
	.byte	165
	.byte	16
	.byte	57
	.byte	25
	.byte	151
	.byte	64
	.byte	27
	.byte	94
	.byte	154
	.byte	134
	.byte	18
	.byte	51
	.byte	177
	.byte	135
	.byte	115
	.byte	56
	.byte	211
	.byte	184
	.byte	151
	.byte	3
	.byte	11
	.byte	75
	.byte	182
	.byte	233
	.byte	198
	.byte	198
	.byte	76
	.byte	75
	.byte	230
	.byte	230
	.byte	201
	.byte	193
	.byte	228
	.byte	193
	.byte	153
	.byte	196
	.byte	73
	.byte	230
	.byte	197
	.byte	18
	.byte	2
	.byte	19
	.byte	151
	.byte	194
	.byte	65
	.byte	70
	.byte	195
	.byte	148
	.byte	102
	.byte	180
	.byte	196
	.byte	68
	.byte	198
	.byte	97
	.byte	230
	.byte	100
	.byte	78
	.byte	180
	.byte	196
	.byte	195
	.byte	225
	.byte	76
	.byte	182
	.byte	52
	.byte	78
	.byte	238
	.byte	225
	.byte	156
	.byte	230
	.byte	201
	.byte	177
	.byte	233
	.byte	228
	.byte	28
	.byte	76
	.byte	67
	.byte	75
	.byte	195
	.byte	100
	.byte	158
	.byte	100
	.byte	67
	.byte	54
	.byte	116
	.byte	136
	.byte	7
	.byte	121
	.byte	152
	.byte	91
	.byte	152
	.byte	121
	.byte	18
	.byte	57
	.byte	145
	.byte	121
	.byte	146
	.byte	121
	.byte	152
	.byte	135
	.byte	25
	.byte	39
	.byte	217
	.byte	144
	.byte	19
	.byte	57
	.byte	135
	.byte	27
	.byte	51
	.byte	153
	.byte	147
	.byte	147
	.byte	167
	.byte	211
	.byte	56
	.byte	121
	.byte	184
	.byte	217
	.byte	48
	.byte	39
	.byte	147
	.byte	141
	.byte	147
	.byte	57
	.byte	57
	.byte	57
	.byte	153
	.byte	19
	.byte	135
	.byte	135
	.byte	135
	.byte	217
	.byte	144
	.byte	121
	.byte	146
	.byte	153
	.byte	121
	.byte	18
	.byte	147
	.byte	121
	.byte	208
	.byte	48
	.byte	113
	.byte	152
	.byte	121
	.byte	152
	.byte	121
	.byte	120
	.byte	152
	.byte	121
	.byte	120
	.byte	152
	.byte	13
	.byte	141
	.byte	57
	.byte	57
	.byte	121
	.byte	210
	.byte	146
	.byte	147
	.byte	155
	.byte	57
	.byte	57
	.byte	57
	.byte	57
	.byte	141
	.byte	57
	.byte	57
	.byte	141
	.byte	57
	.byte	121
	.byte	56
	.byte	57
	.byte	153
	.byte	147
	.byte	57
	.byte	153
	.byte	135
	.byte	135
	.byte	153
	.byte	19
	.byte	147
	.byte	121
	.byte	112
	.byte	120
	.byte	152
	.byte	135
	.byte	121
	.byte	152
	.byte	19
	.byte	13
	.byte	153
	.byte	147
	.byte	153
	.byte	19
	.byte	19
	.byte	135
	.byte	13
	.byte	135
	.byte	39
	.byte	209
	.byte	48
	.byte	217
	.byte	48
	.byte	121
	.byte	114
	.byte	26
	.byte	147
	.byte	147
	.byte	147
	.byte	147
	.byte	57
	.byte	135
	.byte	167
	.byte	217
	.byte	146
	.byte	147
	.byte	135
	.byte	147
	.byte	147
	.byte	57
	.byte	57
	.byte	121
	.byte	120
	.byte	146
	.byte	57
	.byte	153
	.byte	103
	.byte	146
	.byte	39
	.byte	153
	.byte	135
	.byte	121
	.byte	120
	.byte	152
	.byte	135
	.byte	135
	.byte	121
	.byte	146
	.byte	217
	.byte	152
	.byte	121
	.byte	152
	.byte	39
	.byte	153
	.byte	147
	.byte	153
	.byte	147
	.byte	217
	.byte	48
	.byte	153
	.byte	39
	.byte	57
	.byte	153
	.byte	147
	.byte	57
	.byte	57
	.byte	121
	.byte	50
	.byte	57
	.byte	217
	.byte	112
	.byte	154
	.byte	57
	.byte	57
	.byte	57
	.byte	153
	.byte	147
	.byte	147
	.byte	39
	.byte	57
	.byte	217
	.byte	48
	.byte	153
	.byte	147
	.byte	121
	.byte	146
	.byte	39
	.byte	153
	.byte	39
	.byte	153
	.byte	147
	.byte	217
	.byte	112
	.byte	146
	.byte	121
	.byte	146
	.byte	13
	.byte	13
	.byte	39
	.byte	217
	.byte	208
	.byte	144
	.byte	147
	.byte	121
	.byte	152
	.byte	39
	.byte	135
	.byte	121
	.byte	146
	.byte	57
	.byte	153
	.byte	39
	.byte	57
	.byte	121
	.byte	114
	.byte	216
	.byte	216
	.byte	48
	.byte	153
	.byte	147
	.byte	147
	.byte	135
	.byte	39
	.byte	57
	.byte	121
	.byte	146
	.byte	147
	.byte	39
	.byte	57
	.byte	153
	.byte	147
	.byte	39
	.byte	57
	.byte	153
	.byte	147
	.byte	121
	.byte	146
	.byte	135
	.byte	57
	.byte	153
	.byte	19
	.byte	147
	.byte	121
	.byte	152
	.byte	147
	.byte	153
	.byte	147
	.byte	57
	.byte	153
	.byte	39
	.byte	57
	.byte	49
	.byte	113
	.byte	146
	.byte	39
	.byte	217
	.byte	208
	.byte	112
	.byte	146
	.byte	39
	.byte	153
	.byte	147
	.byte	141
	.byte	121
	.byte	120
	.byte	146
	.byte	147
	.byte	39
	.byte	57
	.byte	153
	.byte	147
	.byte	147
	.byte	57
	.byte	153
	.byte	147
	.byte	147
	.byte	57
	.byte	217
	.byte	48
	.byte	153
	.byte	147
	.byte	39
	.byte	121
	.byte	146
	.byte	147
	.byte	57
	.byte	153
	.byte	39
	.byte	121
	.byte	120
	.byte	216
	.byte	112
	.byte	146
	.byte	13
	.byte	39
	.byte	121
	.byte	146
	.byte	57
	.byte	153
	.byte	39
	.byte	121
	.byte	152
	.byte	147
	.byte	57
	.byte	153
	.byte	39
	.byte	121
	.byte	146
	.byte	57
	.byte	153
	.byte	147
	.byte	121
	.byte	146
	.byte	39
	.byte	57
	.byte	153
	.byte	147
	.byte	57
	.byte	121
	.byte	146
	.byte	39
	.byte	57
	.byte	217
	.byte	48
	.byte	153
	.byte	147
	.byte	141
	.byte	121
	.byte	146
	.byte	147
	.byte	57
	.byte	153
	.byte	147
	.byte	141
	.byte	121
	.byte	146
	.byte	39
	.byte	121
	.byte	146
	.byte	39
	.byte	121
	.byte	152
	.byte	147
	.byte	57
	.byte	153
	.byte	39
	.byte	121
	.byte	146
	.byte	39
	.byte	121
	.byte	146
	.byte	57
	.byte	153
	.byte	147
	.byte	57
	.byte	153
	.byte	39
	.byte	121
	.byte	146
	.byte	39
	.byte	121
	.byte	146
	.byte	57
	.byte	153
	.byte	147
	.byte	57
	.byte	153
	.byte	147
	.byte	57
	.byte	217
	.byte	152
	.byte	39
	.byte	121
	.byte	146
	.byte	39
	.byte	57
	.byte	153
	.byte	147
	.byte	57
	.byte	217
	.byte	152
	.byte	39
	.byte	121
	.byte	146
	.byte	39
	.byte	121
	.byte	146
	.byte	147
	.byte	57
	.byte	153
	.byte	147
	.byte	57
	.byte	113
	.align	2
wdi_TOMM1:
	.byte	136
	.byte	216
	.byte	229
	.byte	240
	.byte	128
	.byte	100
	.byte	158
	.byte	104
	.byte	131
	.byte	166
	.byte	160
	.byte	48
	.byte	162
	.byte	160
	.byte	216
	.byte	141
	.byte	8
	.byte	138
	.byte	136
	.byte	136
	.byte	32
	.byte	66
	.byte	26
	.byte	45
	.byte	146
	.byte	99
	.byte	208
	.byte	48
	.byte	8
	.byte	99
	.byte	194
	.byte	160
	.byte	32
	.byte	158
	.byte	136
	.byte	50
	.byte	154
	.byte	41
	.byte	138
	.byte	166
	.byte	99
	.byte	140
	.byte	136
	.byte	130
	.byte	152
	.byte	34
	.byte	34
	.byte	198
	.byte	113
	.byte	138
	.byte	49
	.byte	136
	.byte	90
	.byte	42
	.byte	141
	.byte	128
	.byte	104
	.byte	34
	.byte	131
	.byte	136
	.byte	167
	.byte	136
	.byte	218
	.byte	130
	.byte	156
	.byte	168
	.byte	48
	.byte	34
	.byte	40
	.byte	40
	.byte	176
	.byte	33
	.byte	74
	.byte	18
	.byte	215
	.byte	160
	.byte	33
	.byte	166
	.byte	9
	.byte	2
	.byte	131
	.byte	134
	.byte	38
	.byte	138
	.byte	136
	.byte	219
	.byte	58
	.byte	96
	.byte	139
	.byte	226
	.byte	138
	.byte	57
	.byte	162
	.byte	41
	.byte	34
	.byte	152
	.byte	38
	.byte	73
	.byte	135
	.byte	2
	.byte	38
	.byte	29
	.byte	162
	.byte	150
	.byte	136
	.byte	24
	.byte	2
	.byte	108
	.byte	200
	.byte	160
	.byte	178
	.byte	169
	.byte	114
	.byte	139
	.byte	168
	.byte	139
	.byte	200
	.byte	50
	.byte	50
	.byte	35
	.byte	40
	.byte	137
	.byte	73
	.byte	192
	.byte	133
	.byte	16
	.byte	64
	.byte	89
	.byte	112
	.byte	134
	.byte	48
	.byte	9
	.byte	26
	.byte	130
	.byte	137
	.byte	40
	.byte	246
	.byte	182
	.byte	176
	.byte	48
	.byte	170
	.byte	200
	.byte	58
	.byte	232
	.byte	48
	.byte	162
	.byte	166
	.byte	16
	.byte	27
	.byte	37
	.byte	129
	.byte	84
	.byte	77
	.byte	38
	.byte	112
	.byte	136
	.byte	0
	.byte	136
	.byte	37
	.byte	9
	.byte	28
	.byte	130
	.byte	230
	.byte	140
	.byte	226
	.byte	35
	.byte	203
	.byte	176
	.byte	172
	.byte	224
	.byte	42
	.byte	35
	.byte	50
	.byte	27
	.byte	121
	.byte	20
	.byte	131
	.byte	84
	.byte	98
	.byte	128
	.byte	165
	.byte	4
	.byte	104
	.byte	153
	.byte	161
	.byte	165
	.byte	96
	.byte	130
	.byte	8
	.byte	142
	.byte	195
	.byte	43
	.byte	236
	.byte	56
	.byte	139
	.byte	106
	.byte	43
	.byte	142
	.byte	162
	.byte	155
	.byte	99
	.byte	68
	.byte	31
	.byte	32
	.byte	73
	.byte	18
	.byte	64
	.byte	68
	.byte	65
	.byte	117
	.byte	24
	.byte	2
	.byte	132
	.byte	102
	.byte	41
	.byte	1
	.byte	163
	.byte	176
	.byte	195
	.byte	232
	.byte	44
	.byte	42
	.byte	51
	.byte	58
	.byte	138
	.byte	227
	.byte	202
	.byte	50
	.byte	153
	.byte	13
	.byte	29
	.byte	164
	.byte	129
	.byte	92
	.byte	36
	.byte	25
	.byte	105
	.byte	66
	.byte	34
	.byte	88
	.byte	32
	.byte	64
	.byte	13
	.byte	137
	.byte	136
	.byte	99
	.byte	203
	.byte	243
	.byte	163
	.byte	248
	.byte	160
	.byte	46
	.byte	46
	.byte	63
	.byte	140
	.byte	120
	.byte	122
	.byte	146
	.byte	153
	.byte	153
	.byte	101
	.byte	49
	.byte	144
	.byte	145
	.byte	38
	.byte	96
	.byte	132
	.byte	102
	.byte	8
	.byte	41
	.byte	38
	.byte	137
	.byte	96
	.byte	131
	.byte	170
	.byte	243
	.byte	184
	.byte	173
	.byte	239
	.byte	182
	.byte	167
	.byte	162
	.byte	122
	.byte	35
	.byte	227
	.byte	73
	.byte	30
	.byte	100
	.byte	116
	.byte	146
	.byte	9
	.byte	135
	.byte	33
	.byte	24
	.byte	6
	.byte	24
	.byte	196
	.byte	21
	.byte	35
	.byte	0
	.byte	120
	.byte	24
	.byte	45
	.byte	219
	.byte	51
	.byte	162
	.byte	237
	.byte	142
	.byte	59
	.byte	231
	.byte	172
	.byte	199
	.byte	58
	.byte	57
	.byte	19
	.byte	147
	.byte	151
	.byte	144
	.byte	196
	.byte	65
	.byte	68
	.byte	19
	.byte	100
	.byte	25
	.byte	225
	.byte	97
	.byte	150
	.byte	53
	.byte	137
	.byte	0
	.byte	198
	.byte	41
	.byte	158
	.byte	182
	.byte	219
	.byte	34
	.byte	111
	.byte	178
	.byte	173
	.byte	207
	.byte	41
	.byte	108
	.byte	107
	.byte	227
	.byte	228
	.byte	97
	.byte	39
	.byte	132
	.byte	151
	.byte	137
	.byte	153
	.byte	36
	.byte	24
	.byte	76
	.byte	193
	.byte	65
	.byte	29
	.byte	130
	.byte	36
	.byte	151
	.byte	96
	.byte	54
	.byte	230
	.byte	158
	.byte	179
	.byte	76
	.byte	238
	.byte	30
	.byte	107
	.byte	206
	.byte	158
	.byte	182
	.byte	158
	.byte	156
	.byte	198
	.byte	100
	.byte	230
	.byte	97
	.byte	70
	.byte	94
	.byte	146
	.byte	192
	.byte	65
	.byte	135
	.byte	16
	.byte	83
	.byte	156
	.byte	9
	.byte	164
	.byte	113
	.byte	102
	.byte	152
	.byte	115
	.byte	140
	.byte	147
	.byte	59
	.byte	51
	.byte	109
	.byte	139
	.byte	180
	.byte	45
	.byte	156
	.byte	202
	.byte	156
	.byte	228
	.byte	28
	.byte	118
	.byte	2
	.byte	217
	.byte	144
	.byte	53
	.byte	64
	.byte	147
	.byte	73
	.byte	102
	.byte	100
	.byte	39
	.byte	208
	.byte	36
	.byte	145
	.byte	153
	.byte	13
	.byte	19
	.byte	147
	.byte	115
	.byte	44
	.byte	185
	.byte	185
	.byte	45
	.byte	51
	.byte	103
	.byte	195
	.byte	40
	.byte	115
	.byte	56
	.byte	57
	.byte	121
	.byte	152
	.byte	135
	.byte	153
	.byte	77
	.byte	120
	.byte	144
	.byte	121
	.byte	24
	.byte	7
	.byte	7
	.byte	153
	.byte	19
	.byte	49
	.byte	153
	.byte	153
	.byte	135
	.byte	153
	.byte	57
	.byte	57
	.byte	45
	.byte	57
	.byte	147
	.byte	219
	.byte	114
	.byte	210
	.byte	114
	.byte	218
	.byte	120
	.byte	50
	.byte	49
	.byte	147
	.byte	147
	.byte	153
	.byte	39
	.byte	153
	.byte	7
	.byte	153
	.byte	7
	.byte	39
	.byte	153
	.byte	113
	.byte	120
	.byte	144
	.byte	13
	.byte	153
	.byte	13
	.byte	121
	.byte	152
	.byte	57
	.byte	153
	.byte	147
	.byte	147
	.byte	115
	.byte	204
	.byte	112
	.byte	50
	.byte	141
	.byte	147
	.byte	211
	.byte	120
	.byte	114
	.byte	210
	.byte	120
	.byte	120
	.byte	146
	.byte	217
	.byte	144
	.byte	135
	.byte	121
	.byte	112
	.byte	146
	.byte	153
	.byte	13
	.byte	13
	.byte	153
	.byte	7
	.byte	121
	.byte	26
	.byte	121
	.byte	216
	.byte	144
	.byte	39
	.byte	57
	.byte	121
	.byte	50
	.byte	57
	.byte	57
	.byte	57
	.byte	13
	.byte	211
	.byte	120
	.byte	210
	.byte	48
	.byte	141
	.byte	57
	.byte	121
	.byte	146
	.byte	39
	.byte	153
	.byte	57
	.byte	153
	.byte	121
	.byte	146
	.byte	153
	.byte	19
	.byte	147
	.byte	153
	.byte	135
	.byte	153
	.byte	39
	.byte	153
	.byte	13
	.byte	135
	.byte	57
	.byte	49
	.byte	121
	.byte	56
	.byte	217
	.byte	120
	.byte	56
	.byte	141
	.byte	121
	.byte	50
	.byte	121
	.byte	50
	.byte	217
	.byte	152
	.byte	147
	.byte	141
	.byte	57
	.byte	153
	.byte	135
	.byte	135
	.byte	57
	.byte	113
	.byte	152
	.byte	147
	.byte	153
	.byte	135
	.byte	121
	.byte	146
	.byte	135
	.byte	153
	.byte	19
	.byte	39
	.byte	217
	.byte	112
	.byte	152
	.byte	147
	.byte	57
	.byte	57
	.byte	121
	.byte	146
	.byte	147
	.byte	147
	.byte	147
	.byte	39
	.byte	13
	.byte	147
	.byte	141
	.byte	57
	.byte	57
	.byte	153
	.byte	147
	.byte	121
	.byte	146
	.byte	57
	.byte	153
	.byte	39
	.byte	153
	.byte	39
	.byte	153
	.byte	147
	.byte	121
	.byte	152
	.byte	39
	.byte	217
	.byte	112
	.byte	120
	.byte	152
	.byte	147
	.byte	121
	.byte	146
	.byte	39
	.byte	57
	.byte	153
	.byte	147
	.byte	147
	.byte	39
	.byte	57
	.byte	153
	.byte	147
	.byte	147
	.byte	135
	.byte	39
	.byte	57
	.byte	217
	.byte	152
	.byte	39
	.byte	153
	.byte	147
	.byte	57
	.byte	153
	.byte	57
	.byte	153
	.byte	39
	.byte	121
	.byte	152
	.byte	147
	.byte	121
	.byte	146
	.byte	135
	.byte	57
	.byte	153
	.byte	39
	.byte	121
	.byte	146
	.byte	57
	.byte	121
	.byte	146
	.byte	147
	.byte	57
	.byte	121
	.byte	146
	.byte	147
	.byte	57
	.byte	121
	.byte	146
	.byte	147
	.byte	57
	.byte	121
	.byte	146
	.byte	39
	.byte	121
	.byte	146
	.byte	135
	.byte	57
	.byte	153
	.byte	39
	.byte	121
	.byte	146
	.byte	135
	.byte	135
	.byte	57
	.byte	153
	.byte	39
	.byte	121
	.byte	146
	.byte	39
	.byte	121
	.byte	152
	.byte	147
	.byte	57
	.byte	153
	.byte	147
	.byte	39
	.byte	121
	.byte	146
	.byte	147
	.byte	57
	.byte	153
	.byte	147
	.byte	39
	.byte	121
	.byte	146
	.byte	39
	.byte	57
	.byte	153
	.byte	147
	.byte	153
	.global	i_BD909
	.align	2
i_BD909:
	.byte	64
	.byte	0
	.byte	0
	.byte	0
	.half	42903
	.half	24672
	.word	wdi_BD909
	.word	0
	.word	41746432
	.global	i_CYMBD
	.align	2
i_CYMBD:
	.byte	64
	.byte	0
	.byte	0
	.byte	0
	.half	42903
	.half	24672
	.word	wdi_CYMBD
	.word	0
	.word	151126016
	.global	i_HANDCLAP
	.align	2
i_HANDCLAP:
	.byte	64
	.byte	0
	.byte	0
	.byte	0
	.half	42903
	.half	24672
	.word	wdi_HANDCLAP
	.word	0
	.word	33816576
	.global	i_HC909
	.align	2
i_HC909:
	.byte	64
	.byte	0
	.byte	0
	.byte	0
	.half	42903
	.half	24672
	.word	wdi_HC909
	.word	0
	.word	23068672
	.global	i_HO909
	.align	2
i_HO909:
	.byte	64
	.byte	0
	.byte	0
	.byte	0
	.half	42903
	.half	24672
	.word	wdi_HO909
	.word	0
	.word	90177536
	.global	i_SD909
	.align	2
i_SD909:
	.byte	64
	.byte	0
	.byte	0
	.byte	0
	.half	42903
	.half	24672
	.word	wdi_SD909
	.word	0
	.word	32833536
	.global	i_SDGATE
	.align	2
i_SDGATE:
	.byte	64
	.byte	0
	.byte	0
	.byte	0
	.half	42903
	.half	24672
	.word	wdi_SDGATE
	.word	0
	.word	94568448
	.global	i_TOMH1
	.align	2
i_TOMH1:
	.byte	64
	.byte	0
	.byte	0
	.byte	0
	.half	42903
	.half	24672
	.word	wdi_TOMH1
	.word	0
	.word	34734080
	.global	i_TOML1
	.align	2
i_TOML1:
	.byte	64
	.byte	0
	.byte	0
	.byte	0
	.half	42903
	.half	24672
	.word	wdi_TOML1
	.word	0
	.word	69271552
	.global	i_TOMM1
	.align	2
i_TOMM1:
	.byte	64
	.byte	0
	.byte	0
	.byte	0
	.half	42903
	.half	24672
	.word	wdi_TOMM1
	.word	0
	.word	46333952

	.lcomm	datatop 4

	.lcomm	drumsbase 4

	.lcomm	tempo 2

	.lcomm	tempowk 2

	.lcomm	runf 1

	.lcomm	seqwk 1008

	.lcomm	waveinfo 80

	.lcomm	wavebuff 1024

