/*	
 *	machine.h
 *
 *	CPUŗL̖
 *
 *	CLiP - Common Library for P/ECE
 *	Copyright (C) 2001-2018 Naoyuki Sawa
 *
 *	* Sun Mar 02 18:32:04 JST 2014 Naoyuki Sawa
 *	- 1st [XB
 *	  t@Cumachine.hv́ARenesasRpC(Hew)machine.hɕ킢܂B
 *	* Mon Mar 03 23:23:15 JST 2014 Naoyuki Sawa
 *	- Win32p̎ǉ܂B
 *	* Sat Aug 16 15:46:20 JST 2014 Naoyuki Sawa
 *	- get_psr(),set_psr()ǉ܂B
 *	* Wed Nov 18 21:37:53 JST 2015 Naoyuki Sawa
 *	- 'extern "C" {'`'}'ň݂͂܂B.cpp܂Win32vWFNgCN[ho悤ɂ邽߂łB
 *	* Sun Dec 25 23:57:41 JST 2016 Naoyuki Sawa
 *	- xscan0()xscan1()̍ŌɖʂsllL̂ō폜܂B
 *	* Mon Jul 23 23:59:59 JST 2018 Naoyuki Sawa
 *	- get_sp(),set_sp()ǉ܂B
 */
#ifndef __MACHINE_H__
#define __MACHINE_H__

#ifdef  __cplusplus
extern "C" {
#endif//__cplusplus

//gcc33ŒǉĂ郌WX^:
//"h" -> %ahr 
//"l" -> %alr 
//"x" -> %ahr or %alr

//uvolatilevtȂRɂ:
//CCAZuvZ̈ꕔƂėpꍇ́AuvolatilevtȂǂłB
//ȂȂAuvolatilevtƁAGCCAuCCAZus邱Ǝ̂ɈӖvƔfāAʏȂȂ邩łB(test1Q)
//uvolatilevtȂ΁AGCCAuCCAZǔʂgpĂȂꍇ́AʏƂăCCAZuvĂ܂B(test2Q)
//
//int test1(int x) {                                      // test1:
//  int a;                                                //   ld.w %r10,%r12
//  asm volatile ("mirror %0,%1" : "=r"(a) : "r"(x));     //   mirror %r11,%r10  ʃR[h
//  return x;                                             //   ret
//}
//int test2(int x) {                                      // test2:
//  int a;                                                //   ld.w %r10,%r12
//  asm /*volatile*/ ("mirror %0,%1" : "=r"(a) : "r"(x)); //                     œKď
//  return x;                                             //   ret
//}
//
//CCAZuvZ̈ꕔƂėpꍇ́AuCCAZus邱Ǝ̂ɈӖvP[X͋HƎv܂B
//̂悤ȏꍇ́AuvolatilevtȂǂł傤B
 //
//܂Ő[lɁuvolatilevtĂ̂łAꍇɂĎgǂłB
//܂Ƃ߂:
//ECCAZȕs邱Ǝ̂ɈӖꍇ˕KuvolatilevtB
//ECCAZǔʂgpꍇɈӖꍇˁuvolatilevtȂǂBtĂǂʃR[h\B

//==============================================================================
//	f[^]
//==============================================================================
#ifdef  PIECE
struct psr {
	unsigned n : 1; /* [    0] */
	unsigned z : 1; /* [    1] */
	unsigned v : 1; /* [    2] */
	unsigned c : 1; /* [    3] */
	unsigned ie: 1; /* [    4] */
	unsigned   : 1; /* [    5] */
	unsigned ds: 1; /* [    6] */
	unsigned mo: 1; /* [    7] */
	unsigned il: 4; /* [11: 8] */
	unsigned   :20; /* [31:12] */
};
#define get_psr() ({				\
	struct psr __x__;			\
	asm("ld.w %0,%%psr" :  "=r"(__x__));	\
	__x__; })
#define set_psr(x) ({				\
	struct psr __x__ = (x);			\
	asm("ld.w %%psr,%0" : : "r"(__x__)); })
//{{2018/07/23ǉ:get_sp(),set_sp()ǉ܂B
#define get_sp() ({				\
	void* __x__;				\
	asm("ld.w %0,%%sp" :  "=r"(__x__));	\
	__x__; })
#define set_sp(x) ({				\
	void* __x__ = (x);			\
	asm("ld.w %%sp,%0" : : "r"(__x__)); })
//}}2018/07/23ǉ:get_sp(),set_sp()ǉ܂B
#endif//PIECE

//==============================================================================
//	ZpZ
//==============================================================================
//mlt_hmltu_hɂ:
//CŏZsƁAƂshortϐm̏ZłĂAumlt(u).wvɓWJĂ܂܂B
//umlt(u).wv5TCN߂łAxłB
//16bitx16bit=32bitZő邱ƂĂꍇ́A1TCN߂́umlt(u).hvgǂłB
//S1C33CRpĆumlt(u).hv𐶐Ȃ̂ŁAɁAIɁumlt(u).hvg悤ɂ܂B
#ifdef  PIECE
#define mlt_h(x,y) ({									\
	int __x__ = (x), __y__ = (y);							\
	asm /*volatile*/ ("mlt.h %1,%2" : "=l"(__x__) : "r"(__x__),"r"(__y__));		\
	__x__; })
#define mltu_h(x,y) ({									\
	int __x__ = (x), __y__ = (y);							\
	asm /*volatile*/ ("mltu.h %1,%2" : "=l"(__x__) : "r"(__x__),"r"(__y__));	\
	__x__; })
#else //PIECE
static __inline int mlt_h(int x, int y) {
	return (short)x * (short)y;
}
static __inline int mltu_h(int x, int y) {
	return (unsigned short)x * (unsigned short)y;
}
#endif//PIECE

//==============================================================================
//	Vtg[e[g
//==============================================================================
//xrrxrl̎gp:
//a = xrr(x,y)         'xrr reg,reg'ɓWJ܂B
//a = xrr(x,23)        'xrr reg,imm'ɓWJ܂B c 'xrr reg,reg'̗ǂR[hɂȂ܂B̂߂ɃIyh'r'łȂ'g'gp܂B
//a = xrr(x,y+1)       'xrr reg,reg'ɓWJ܂B
//a = xrr(x,rand()%32) 'xrr reg,reg'ɓWJ܂B
#ifdef  PIECE
#define xrr(x,y) ({									\
	int __x__ = (x);								\
	asm /*volatile*/ ("xrr %0,%2" : "=r"(__x__) : "0"(__x__),"g"(y) : "cc","%r9");	\
	__x__; })
#define xrl(x,y) ({									\
	int __x__ = (x);								\
	asm /*volatile*/ ("xrl %0,%2" : "=r"(__x__) : "0"(__x__),"g"(y) : "cc","%r9");	\
	__x__; })
#else //PIECE
static __inline int xrr(int x, int y) {
	while(y--) { x = ((unsigned)x >> 1) | ((unsigned)x << 31); }
	return x;
}
static __inline int xrl(int x, int y) {
	while(y--) { x = ((unsigned)x << 1) | ((unsigned)x >> 31); }
	return x;
}
#endif//PIECE

//==============================================================================
//	̑
//==============================================================================
//xscan0xscan1ɂ:
//߃GNXe_(ext33.exe)ɂxscan0,xscan1͖̂ŁAuS1C33000RACPU}jAṽR[hQƂĎB
//%0%2ɓWX^蓖ĂȂ悤ɁACqu&vgp%0jIyhł邱ƂB
//%2͓̓Iyhł邪j󂳂̂ŁA__dummy__ϐpďo̓Iyh%1ƂĂw肷KvB
//Ql:uGCC̃CCAZȕ for x86v(http://d.hatena.ne.jp/wocota/20090628/1246188338)̃WX^IyhɊ蓖Ăƃ_~[ϐ
#ifdef  PIECE
//{{2016/12/25ύX:xscan0()xscan1()̍ŌɖʂsllL̂ō폜܂B
//#define xscan0(x) ({								\
//	int __x__ = (x), __dummy__;						\
//	asm /*volatile*/ (							\
//		"scan0   %0,%2 \n sll %2,  %0 \n"				\
//		"scan0 %%r9,%2 \n sll %2,%%r9 \n add %0,%%r9 \n"		\
//		"scan0 %%r9,%2 \n sll %2,%%r9 \n add %0,%%r9 \n"		\
//		"scan0 %%r9,%2 \n sll %2,%%r9 \n add %0,%%r9 \n"		\
//		: "=&r"(__x__),"=r"(__dummy__) : "1"(__x__) : "cc","%r9");	\
//	__x__; })
//#define xscan1(x) ({								\
//	int __x__ = (x), __dummy__;						\
//	asm /*volatile*/ (							\
//		"scan1   %0,%2 \n sll %2,  %0 \n"				\
//		"scan1 %%r9,%2 \n sll %2,%%r9 \n add %0,%%r9 \n"		\
//		"scan1 %%r9,%2 \n sll %2,%%r9 \n add %0,%%r9 \n"		\
//		"scan1 %%r9,%2 \n sll %2,%%r9 \n add %0,%%r9 \n"		\
//		: "=&r"(__x__),"=r"(__dummy__) : "1"(__x__) : "cc","%r9");	\
//	__x__; })
//2016/12/25ύX:xscan0()xscan1()̍ŌɖʂsllL̂ō폜܂B
// * Sun Dec 25 23:57:41 JST 2016 Naoyuki Sawa
// - xscan0()xscan1()̍ŌɖʂsllL̂ō폜܂B
//   33000Core-J.pdfp.142<>QlɂĎĂ̂łAL<>Xʂsll܂ł悤łB
//   Ōsll͌ʂɂ͊֌ŴŁAʂȏō폜\łB
#define xscan0(x) ({								\
	int __x__ = (x), __dummy__;						\
	asm /*volatile*/ (							\
		"scan0   %0,%2 \n sll %2,  %0 \n"				\
		"scan0 %%r9,%2 \n sll %2,%%r9 \n add %0,%%r9 \n"		\
		"scan0 %%r9,%2 \n sll %2,%%r9 \n add %0,%%r9 \n"		\
		"scan0 %%r9,%2 \n                add %0,%%r9 \n"		\
		: "=&r"(__x__),"=r"(__dummy__) : "1"(__x__) : "cc","%r9");	\
	__x__; })
#define xscan1(x) ({								\
	int __x__ = (x), __dummy__;						\
	asm /*volatile*/ (							\
		"scan1   %0,%2 \n sll %2,  %0 \n"				\
		"scan1 %%r9,%2 \n sll %2,%%r9 \n add %0,%%r9 \n"		\
		"scan1 %%r9,%2 \n sll %2,%%r9 \n add %0,%%r9 \n"		\
		"scan1 %%r9,%2 \n                add %0,%%r9 \n"		\
		: "=&r"(__x__),"=r"(__dummy__) : "1"(__x__) : "cc","%r9");	\
	__x__; })
//}}2016/12/25ύX:xscan0()xscan1()̍ŌɖʂsllL̂ō폜܂B
#define swap(x) ({							\
	int __x__ = (x);						\
	asm /*volatile*/ ("swap %0,%1" : "=r"(__x__) : "r"(__x__));	\
	__x__; })
#define mirror(x) ({							\
	int __x__ = (x);						\
	asm /*volatile*/ ("mirror %0,%1" : "=r"(__x__) : "r"(__x__));	\
	__x__; })
#else //PIECE
static __inline int xscan0(int x) {
	int i;
	for(i = 0; i < 32; i++, x <<= 1) { if(x >= 0) { break; } }
	return i;
}
static __inline int xscan1(int x) {
	int i;
	for(i = 0; i < 32; i++, x <<= 1) { if(x <  0) { break; } }
	return i;
}
static __inline int swap(int x) {
	return (((unsigned char)((unsigned)x >>  0)) << 24) |
	       (((unsigned char)((unsigned)x >>  8)) << 16) |
	       (((unsigned char)((unsigned)x >> 16)) <<  8) |
	       (((unsigned char)((unsigned)x >> 24)) <<  0);
}
static __inline int mirror(int x) {
	extern const unsigned char mirror_table[0x100];//clipmirr.c
	return (mirror_table[(unsigned char)((unsigned)x >>  0)] <<  0) |
	       (mirror_table[(unsigned char)((unsigned)x >>  8)] <<  8) |
	       (mirror_table[(unsigned char)((unsigned)x >> 16)] << 16) |
	       (mirror_table[(unsigned char)((unsigned)x >> 24)] << 24);
}
#endif//PIECE

#ifdef  __cplusplus
}//extern "C"
#endif//__cplusplus

#endif//__MACHINE_H__
