//
//	clipex10.cs
//
//	16ビットで大きな値を表現するための、指数表現
//
//	CLiP - Common Library for P/ECE
//	Copyright (C) 2018 Naoyuki Sawa
//
//	* Mon Apr 09 23:59:59 JST 2018 Naoyuki Sawa
//	- 1st リリース。
//	- Exp10_Decode()とExp10_Encode()を、cliplot.csからclipex10.csへ移動しました。
//	  詳細は、cliplot.cの同日のコメントを参照して下さい。
//
#define USE_LOT_EQUALLY
using System;
using System.Collections.Generic;
namespace org.piece_me {
	public static partial class libclip {
		//*****************************************************************************
		//	16ビットで大きな値を表現するための、指数表現
		//*****************************************************************************
		public static int Exp10_Decode(int _x) {
			uint x = (uint)_x, e;
			if(x > ushort.MaxValue) { throw new ApplicationException(); }	//呼び出し側のバグ
			//指数を求める。
			e = x % 6;			//0～5
			//仮数を求める。
			x = x / 6;			//0～10922
			//(仮数×10^指数)を求める。
			while(e-- != 0) { x *= 10; }	//0～1092100000(=0x41181FA0)
			return (int)x;
		}
		//-----------------------------------------------------------------------------
		public static int Exp10_Encode(int _x) {
			uint x = (uint)_x, e = 0;
			//指数を求める。
			while((x != 0) && ((x % 10) == 0) && (e < 5)) {
				x /= 10;
				e++;
			}
			//(仮数×6＋指数)を求める。
			if(x > ushort.MaxValue) { return -1; }	//エンコード値が16ビットを超えるならば、エンコード出来ない事を示す-1を返す。	「(x*6)+e」がオーバーフローする可能性が有るので、「(x*6)+e」の前でも調べる必要が有る事に注意せよ。
			x = (x * 6) + e;
			if(x > ushort.MaxValue) { return -1; }	//エンコード値が16ビットを超えるならば、エンコード出来ない事を示す-1を返す。
			return (int)x;
		}
	}
}
