//
//	ToolLib_Visible.cs
//
//	エディター共通処理 - ツールのGUI処理の表示・非表示管理
//
//	* Wed Apr 26 21:33:29 JST 2017 Naoyuki Sawa
//	- 1st リリース。
//	* Tue May 02 22:54:46 JST 2017 Naoyuki Sawa
//	- 各モジュール内のサイズ定義の倍率を一律で調整出来るように、ToolLib.csにTOOL_SCALEの定義を追加しました。
//	  詳細は、/clip/ToolLib/ToolLib.hの同日のコメントを参照して下さい。
//
using System;
namespace org.piece_me {
	public static partial class libclip {
		//*****************************************************************************
		//	定数、マクロ、構造体
		//*****************************************************************************
		//表示状態情報構造体
		public class SToolVisible {				//【C#版特有のコメント】C言語版ではopaque datatypeにしていたが、C#では出来ないので仕方無くpublicにした。
			public SToolVisible	ParentTVisible;		//親の表示状態情報。(親が居ない場合はnull)
			public bool		Visible;		//表示状態。
		}
		//*****************************************************************************
		//	ローカル変数
		//*****************************************************************************
		private static GSList	g_TVisible;
		//*****************************************************************************
		//	アプリケーション用関数
		//*****************************************************************************
		//表示状態情報を作成する。
		public static SToolVisible ToolVisible_Create() {
			SToolVisible TVisible;
			//新しい表示状態情報を格納するためのメモリの確保。
			TVisible = new SToolVisible();
			//確保したメモリ領域を保存。
			g_TVisible = g_slist_append(g_TVisible, TVisible);
			//情報を初期化。
		//不要	TVisible.ParentTVisible = null;
			TVisible.Visible        = true;	//【NOTE】オリジナル版のToolLibでは表示状態情報作成直後の初期状態は'非表示'となっていたが、当実装では使い易さのために初期状態を'表示'に変更した。各ウィジットの初期状態も'表示'なので、統一性の観点からもこの方が良いと思う。
			//表示状態情報を返す。
			return TVisible;
		}
		//-----------------------------------------------------------------------------
		//表示状態情報を削除する。
		public static void ToolVisible_Delete(SToolVisible TVisible) {
			//確保していたメモリを解放する。
			g_TVisible = g_slist_remove(g_TVisible, TVisible);
		}
		//-----------------------------------------------------------------------------
		//全ての表示状態情報を削除する。
		public static void ToolVisible_Delete_All() {
			//有効な全ての表示状態を削除する。
			while(g_TVisible != null) { ToolVisible_Delete((SToolVisible)g_TVisible.data); }
		}
		//-----------------------------------------------------------------------------
		//表示状態情報の表示状態を変更する。
		public static void ToolVisible_SetVisible(SToolVisible TVisible, bool Visible) {
			//新しい表示状態を保存。
			TVisible.Visible = Visible;
		}
		//-----------------------------------------------------------------------------
		//表示状態情報に親の表示状態情報を設定する。
		public static void ToolVisible_SetParent(SToolVisible TVisible, SToolVisible ParentTVisible) {
			//親となる表示状態情報を保存。
			TVisible.ParentTVisible = ParentTVisible;
		}
		//-----------------------------------------------------------------------------
		//表示状態情報の表示状態を取得する。(親の表示状態も考慮する)
		public static bool ToolVisible_GetVisible(SToolVisible TVisible) {
			//指定された表示状態情報,及び,親の表示状態情報を辿って、nullになるまで繰り返す。
			while(TVisible != null) {
				//表示フラグが倒れていたら0を返す。
				if(!TVisible.Visible) { return false; }
				//親の表示状態情報が有効な場合は親の表示状態も考慮する。
				TVisible = TVisible.ParentTVisible;
			}
			//ここにきたら非表示ではないということなので0以外を返す。
			return true;
		}
	}
}
