//
//	ToolLib_DxLib.cs
//
//	エディター共通処理 - DxLib用のバックエンド
//
//	* Wed Apr 26 21:33:29 JST 2017 Naoyuki Sawa
//	- 1st リリース。
//	* Tue May 02 22:54:46 JST 2017 Naoyuki Sawa
//	- 各モジュール内のサイズ定義の倍率を一律で調整出来るように、ToolLib.csにTOOL_SCALEの定義を追加しました。
//	  詳細は、/clip/ToolLib/ToolLib.hの同日のコメントを参照して下さい。
//
#if     !UNITY_5_3_OR_NEWER
using System;
using static DxLibDLL.DX;
namespace org.piece_me {
	public static partial class libclip {
		//*****************************************************************************
		//	アプリケーション用関数
		//*****************************************************************************
		public static SToolInfo ToolDxLib_GetDefault() {
			//SToolInfoから派生した、SToolDxLibInfoクラスの、唯一のインスタンスを返す。
			return     SToolDxLibInfo.GetDefault();
		}
		//*****************************************************************************
		//	ローカル関数
		//*****************************************************************************
		private class SToolDxLibInfo : SToolInfo, ICloneable {
			private static SToolDxLibInfo    Default;	//唯一のインスタンス。
			public  static SToolDxLibInfo GetDefault() {
				if(Default == null) {	//初回ならば、唯一のインスタンスを作成する。
					Default = new SToolDxLibInfo() {
						fnDrawBox			= _fnDrawBox,
						fnDrawStringToHandle		= _fnDrawStringToHandle,
						fnDrawTriangle			= _fnDrawTriangle,
						fnGetColor			= _fnGetColor,
						fnGetDrawScreenSize		= _fnGetDrawScreenSize,
						fnGetDrawStringWidthToHandle	= _fnGetDrawStringWidthToHandle,
						fnGetMouseInput			= _fnGetMouseInput,
						fnGetMousePoint			= _fnGetMousePoint,
						fnSetDrawArea			= _fnSetDrawArea,
						fnSetDrawAreaFull		= _fnSetDrawAreaFull,
						fnSetDrawBlendMode		= _fnSetDrawBlendMode,
						NormalFontHandle		= CreateFontToHandle(null, TOOL_FONT_HEIGHT, 0, DX_FONTTYPE_EDGE  ),
						ButtonFontHandle		= CreateFontToHandle(null, TOOL_FONT_HEIGHT, 0, DX_FONTTYPE_NORMAL),
					};
					if((Default.ButtonFontHandle == -1) ||
					   (Default.NormalFontHandle == -1)) { throw new ApplicationException(); }
				}
				return (SToolDxLibInfo)Default.Clone();
			}
			private static int _fnDrawBox(int x1, int y1, int x2, int y2, uint Color, bool FillFlag) { return DrawBox(x1, y1, x2, y2, Color, FillFlag ? 1 : 0); }
			private static int _fnDrawStringToHandle(int x, int y, string String, uint Color, int FontHandle/*, uint EdgeColor = 0, bool VerticalFlag = 0*/) { return DrawStringToHandle(x, y, String, Color, FontHandle); }
			private static int _fnDrawTriangle(int x1, int y1, int x2, int y2, int x3, int y3, uint Color, bool FillFlag) { return DrawTriangle(x1, y1, x2, y2, x3, y3, Color, FillFlag ? 1 : 0); }
			private static uint _fnGetColor(int Red, int Green, int Blue) { return GetColor(Red, Green, Blue); }
			private static int _fnGetDrawScreenSize(out int XBuf, out int YBuf) { return GetDrawScreenSize(out XBuf, out YBuf); }
			private static int _fnGetDrawStringWidthToHandle(string String, int StrLen, int FontHandle/*, bool VerticalFlag = 0*/) { return GetDrawStringWidthToHandle(String, StrLen, FontHandle); }
			private static int _fnGetMouseInput() { return GetMouseInput(); }
			private static int _fnGetMousePoint(out int XBuf, out int YBuf) { return GetMousePoint(out XBuf, out YBuf); }
			private static int _fnSetDrawArea(int x1, int y1, int x2, int y2) { return SetDrawArea(x1, y1, x2, y2); }
			private static int _fnSetDrawAreaFull() { return SetDrawAreaFull(); }
			private static int _fnSetDrawBlendMode(int BlendMode, int BlendParam) { return SetDrawBlendMode(BlendMode, BlendParam); }
			//-----------------------------------------------------------------------------
			//ICloneable
			public object Clone() { return MemberwiseClone(); }
		}
	}
}
#endif//!UNITY_5_3_OR_NEWER
