//
//	clipinp_uni.cs
//
//	アプリケーションの入力関数
//
//	CLiP - Common Library for P/ECE
//	Copyright (C) 2017 Naoyuki Sawa
//
//	* Wed Apr 19 22:11:14 JST 2017 Naoyuki Sawa
//	- 1st リリース。
//
#if     UNITY_5_3_OR_NEWER
using System;
using System.Collections;
using System.Linq;
using UnityEngine;
using static org.piece_me.libclip;
using static Const;
public static partial class Program {
	//*****************************************************************************
	//	構造体
	//*****************************************************************************
	public static class _Input {
		//マウス/タッチパネル
		public static bool		mouseStat, mouseTrig;
		public static int		mousePosX, mousePosY;
		//キーボード
		public static BitArray		keyStat, keyTrig;
	}
	//*****************************************************************************
	//	グローバル関数
	//*****************************************************************************
	//入力の初期化処理
	public static void Input_Init() {
		//マウス/タッチパネル
		{
			/** no job **/
		}
		//キーボード
		{
			int n = (int)Enumerable.Max(TBL_Input_KeyCode) + 1;
			_Input.keyStat = new BitArray(n);
			_Input.keyTrig = new BitArray(n);
		}
	}
	//-----------------------------------------------------------------------------
	//入力の終了処理
	public static void Input_Exit() {
		/** no job **/
	}
	//-----------------------------------------------------------------------------
	//入力の周期処理
	public static void Input_Exec() {
		//マウス/タッチパネル
		{
			//□参考資料:「UnityでiOS/Android/Editorの共通タッチ処理を実装する」(http://qiita.com/tempura/items/4a5482ff6247ec8873df)
			//Androidならば…
			if(Application.platform == RuntimePlatform.Android) {
				//タッチ数が0でなければ…
				if(Input.touchCount != 0) {
					//タッチ状態を表すオブジェクトを取得する。
					Touch touch = Input.GetTouch(0);
					//タッチの状態を取得する。
					TouchPhase phase = touch.phase;
					//タッチの状態によって…
					switch(phase) {
					default:throw new ApplicationException();
					case TouchPhase.Began:		//画面に指がタッチしました。
					case TouchPhase.Moved:		//画面上で指が動きました。
					case TouchPhase.Stationary:	//指が画面にタッチしているが動いてはいません。
						//タッチしたピクセル座標を取得する。
						Vector2 position = touch.position;	//【NOTE】C#はC/C++と違ってこんな場所でも変数を定義出来るみたいです。
						//メインカメラが有れば、スクリーン座標からワールド座標に変換する。
						if(Camera.main != null) { position = Camera.main.ScreenToWorldPoint(position); }
						//論理座標ゆ変換する。
						_Input.mousePosX = (int)((position.x * PPU) + (DISP_X / 2));
						_Input.mousePosY = (int)((DISP_Y / 2) - (position.y * PPU));
						//押下状態を格納する。
						_Input.mouseTrig = !_Input.mouseStat;
						_Input.mouseStat = true;
						break;
					case TouchPhase.Ended:		//画面から指が離れました。これは、タッチの最終段階です。
					case TouchPhase.Canceled:	//システムがタッチの追跡をキャンセルしました。
						//押下状態を格納する。
						_Input.mouseStat = false;
						_Input.mouseTrig = false;
						break;
					}
				//タッチ数が0ならば…
				} else {
					//押下状態を格納する。
					_Input.mouseStat = false;
					_Input.mouseTrig = false;
				}
			//Android以外ならば…
			} else {
				//左ボタンが押されていたら…
				if(Input.GetMouseButton(0)) {
					//現在のマウスの位置のピクセル座標を取得する。
					Vector2 position = Input.mousePosition;
					//メインカメラが有れば、スクリーン座標からワールド座標に変換する。
					if(Camera.main != null) { position = Camera.main.ScreenToWorldPoint(position); }
					//論理座標ゆ変換する。
					_Input.mousePosX = (int)((position.x * PPU) + (DISP_X / 2));
					_Input.mousePosY = (int)((DISP_Y / 2) - (position.y * PPU));
					//押下状態を格納する。
					_Input.mouseTrig = !_Input.mouseStat;
					_Input.mouseStat = true;
				//左ボタンが離されていたら…
				} else {
					//押下状態を格納する。
					_Input.mouseStat = false;
					_Input.mouseTrig = false;
				}
			}
		}
		//キーボード
		{
			foreach(KeyCode i in TBL_Input_KeyCode) {
				bool bStat = Input.GetKey(i);
				_Input.keyTrig[(int)i] = bStat && !_Input.keyStat[(int)i];
				_Input.keyStat[(int)i] = bStat;
			}
		}
	}
	//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	//全てのキーを検査すると時間が掛かるし無駄が多いので、下記の配列で定義されたキーだけを検査する事にしました。
	//※TODO:アプリケーションで使用するキーだけを有効にして下さい。
	private static readonly KeyCode[] TBL_Input_KeyCode={
	//	KeyCode.None,			//割り当てなし（キーストロークの結果として戻り値となることはありません）
		KeyCode.Backspace,		//backspace
	//	KeyCode.Delete,			//Delete
	//	KeyCode.Tab,			//Tab
	//	KeyCode.Clear,			//Clear
		KeyCode.Return,			//Return
	//	KeyCode.Pause,			//Pause
		KeyCode.Escape,			//Escape
		KeyCode.Space,			//Space
	//	KeyCode.Keypad0,		//テンキー0
	//	KeyCode.Keypad1,		//テンキー1
	//	KeyCode.Keypad2,		//テンキー2
	//	KeyCode.Keypad3,		//テンキー3
	//	KeyCode.Keypad4,		//テンキー4
	//	KeyCode.Keypad5,		//テンキー5
	//	KeyCode.Keypad6,		//テンキー6
	//	KeyCode.Keypad7,		//テンキー7
	//	KeyCode.Keypad8,		//テンキー8
	//	KeyCode.Keypad9,		//テンキー9
	//	KeyCode.KeypadPeriod,		//テンキーの.
	//	KeyCode.KeypadDivide,		//テンキーの/
	//	KeyCode.KeypadMultiply,		//テンキーの*
	//	KeyCode.KeypadMinus,		//テンキーの-
	//	KeyCode.KeypadPlus,		//テンキーの+
	//	KeyCode.KeypadEnter,		//テンキーのEnter
	//	KeyCode.KeypadEquals,		//テンキーの=
		KeyCode.UpArrow,		//上矢印キー
		KeyCode.DownArrow,		//下矢印キー
		KeyCode.RightArrow,		//右矢印キー
		KeyCode.LeftArrow,		//左矢印キー
	//	KeyCode.Insert,			//Inserｔ
	//	KeyCode.Home,			//Home
	//	KeyCode.End,			//End
	//	KeyCode.PageUp,			//Page up
	//	KeyCode.PageDown,		//Page down
		KeyCode.F1,			//F1
		KeyCode.F2,			//F2
		KeyCode.F3,			//F3
		KeyCode.F4,			//F4
		KeyCode.F5,			//F5
		KeyCode.F6,			//F6
		KeyCode.F7,			//F7
		KeyCode.F8,			//F8
		KeyCode.F9,			//F9
		KeyCode.F10,			//F10
		KeyCode.F11,			//F11
		KeyCode.F12,			//F12
		KeyCode.F13,			//F13
		KeyCode.F14,			//F14
		KeyCode.F15,			//F15
		KeyCode.Alpha0,			//キーボード上の0
		KeyCode.Alpha1,			//キーボード上の1
		KeyCode.Alpha2,			//キーボード上の2
		KeyCode.Alpha3,			//キーボード上の3
		KeyCode.Alpha4,			//キーボード上の4
		KeyCode.Alpha5,			//キーボード上の5
		KeyCode.Alpha6,			//キーボード上の6
		KeyCode.Alpha7,			//キーボード上の7
		KeyCode.Alpha8,			//キーボード上の8
		KeyCode.Alpha9,			//キーボード上の9
	//	KeyCode.Exclaim,		//!
	//	KeyCode.DoubleQuote,		//"
	//	KeyCode.Hash,			//#
	//	KeyCode.Dollar,			//＄
	//	KeyCode.Ampersand,		//&
	//	KeyCode.Quote,			//'
	//	KeyCode.LeftParen,		//(
	//	KeyCode.RightParen,		//)
	//	KeyCode.Asterisk,		//*
	//	KeyCode.Plus,			//+
	//	KeyCode.Comma,			//、
	//	KeyCode.Minus,			//-
	//	KeyCode.Period,			//.
	//	KeyCode.Slash,			///
	//	KeyCode.Colon,			//:
	//	KeyCode.Semicolon,		//;
	//	KeyCode.Less,			//<
	//	KeyCode.Equals,			//=
	//	KeyCode.Greater,		//>
	//	KeyCode.Question,		//?
	//	KeyCode.At,			//@
	//	KeyCode.LeftBracket,		//[
	//	KeyCode.Backslash,		//Backslash key '\'.
	//	KeyCode.RightBracket,		//]
	//	KeyCode.Caret,			//^
	//	KeyCode.Underscore,		//_
	//	KeyCode.BackQuote,		//`
		KeyCode.A,			//a
		KeyCode.B,			//b
		KeyCode.C,			//c
		KeyCode.D,			//d
		KeyCode.E,			//e
		KeyCode.F,			//f
		KeyCode.G,			//g
		KeyCode.H,			//h
		KeyCode.I,			//i
		KeyCode.J,			//j
		KeyCode.K,			//k
		KeyCode.L,			//l
		KeyCode.M,			//m
		KeyCode.N,			//n
		KeyCode.O,			//o
		KeyCode.P,			//p
		KeyCode.Q,			//q
		KeyCode.R,			//r
		KeyCode.S,			//s
		KeyCode.T,			//t
		KeyCode.U,			//u
		KeyCode.V,			//v
		KeyCode.W,			//w
		KeyCode.X,			//x
		KeyCode.Y,			//y
		KeyCode.Z,			//z
		KeyCode.Numlock,		//Numlock
		KeyCode.CapsLock,		//Capslock
		KeyCode.ScrollLock,		//Scroll Lock
		KeyCode.RightShift,		//Right Shift
		KeyCode.LeftShift,		//Left Shift
		KeyCode.RightControl,		//Right Control
		KeyCode.LeftControl,		//Left Control
		KeyCode.RightAlt,		//Right Alt
		KeyCode.LeftAlt,		//Left Alt
		KeyCode.LeftCommand,		//Left Command
		KeyCode.LeftApple,		//Left Command
		KeyCode.LeftWindows,		//Left Windows
		KeyCode.RightCommand,		//Right Command
		KeyCode.RightApple,		//Right Command
		KeyCode.RightWindows,		//Right Windows
		KeyCode.AltGr,			//Alt Gr
		KeyCode.Help,			//Help
		KeyCode.Print,			//Print
		KeyCode.SysReq,			//Sys Req
		KeyCode.Break,			//Break
		KeyCode.Menu,			//Menu
	//	KeyCode.Mouse0,			//1番目(primary)のマウスボタン
	//	KeyCode.Mouse1,			//2番目(secondary)のマウスボタン
	//	KeyCode.Mouse2,			//3番目のマウスボタン
	//	KeyCode.Mouse3,			//4番目のマウスボタン
	//	KeyCode.Mouse4,			//5番目のマウスボタン
	//	KeyCode.Mouse5,			//6番目のマウスボタン
	//	KeyCode.Mouse6,			//7番目のマウスボタン
	//	KeyCode.JoystickButton0,	//ジョイスティックの0ボタン
	//	KeyCode.JoystickButton1,	//ジョイスティックの1ボタン
	//	KeyCode.JoystickButton2,	//ジョイスティックの2ボタン
	//	KeyCode.JoystickButton3,	//ジョイスティックの3ボタン
	//	KeyCode.JoystickButton4,	//ジョイスティックの4ボタン
	//	KeyCode.JoystickButton5,	//ジョイスティックの5ボタン
	//	KeyCode.JoystickButton6,	//ジョイスティックの6ボタン
	//	KeyCode.JoystickButton7,	//ジョイスティックの7ボタン
	//	KeyCode.JoystickButton8,	//ジョイスティックの8ボタン
	//	KeyCode.JoystickButton9,	//ジョイスティックの9ボタン
	//	KeyCode.JoystickButton10,	//ジョイスティックの10ボタン
	//	KeyCode.JoystickButton11,	//ジョイスティックの11ボタン
	//	KeyCode.JoystickButton12,	//ジョイスティックの12ボタン
	//	KeyCode.JoystickButton13,	//ジョイスティックの13ボタン
	//	KeyCode.JoystickButton14,	//ジョイスティックの14ボタン
	//	KeyCode.JoystickButton15,	//ジョイスティックの15ボタン
	//	KeyCode.JoystickButton16,	//ジョイスティックの16ボタン
	//	KeyCode.JoystickButton17,	//ジョイスティックの17ボタン
	//	KeyCode.JoystickButton18,	//ジョイスティックの18ボタン
	//	KeyCode.JoystickButton19,	//ジョイスティックの19ボタン
	//	KeyCode.Joystick1Button0,	//ジョイスティック1の0ボタン
	//	KeyCode.Joystick1Button1,	//ジョイスティック1の1ボタン
	//	KeyCode.Joystick1Button2,	//ジョイスティック1の2ボタン
	//	KeyCode.Joystick1Button3,	//ジョイスティック1の3ボタン
	//	KeyCode.Joystick1Button4,	//ジョイスティック1の4ボタン
	//	KeyCode.Joystick1Button5,	//ジョイスティック1の5ボタン
	//	KeyCode.Joystick1Button6,	//ジョイスティック1の6ボタン
	//	KeyCode.Joystick1Button7,	//ジョイスティック1の7ボタン
	//	KeyCode.Joystick1Button8,	//ジョイスティック1の8ボタン
	//	KeyCode.Joystick1Button9,	//ジョイスティック1の9ボタン
	//	KeyCode.Joystick1Button10,	//ジョイスティック1の10ボタン
	//	KeyCode.Joystick1Button11,	//ジョイスティック1の11ボタン
	//	KeyCode.Joystick1Button12,	//ジョイスティック1の12ボタン
	//	KeyCode.Joystick1Button13,	//ジョイスティック1の13ボタン
	//	KeyCode.Joystick1Button14,	//ジョイスティック1の14ボタン
	//	KeyCode.Joystick1Button15,	//ジョイスティック1の15ボタン
	//	KeyCode.Joystick1Button16,	//ジョイスティック1の16ボタン
	//	KeyCode.Joystick1Button17,	//ジョイスティック1の17ボタン
	//	KeyCode.Joystick1Button18,	//ジョイスティック1の18ボタン
	//	KeyCode.Joystick1Button19,	//ジョイスティック1の19ボタン
	//	KeyCode.Joystick2Button0,	//ジョイスティック2の0ボタン
	//	KeyCode.Joystick2Button1,	//ジョイスティック2の1ボタン
	//	KeyCode.Joystick2Button2,	//ジョイスティック2の2ボタン
	//	KeyCode.Joystick2Button3,	//ジョイスティック2の3ボタン
	//	KeyCode.Joystick2Button4,	//ジョイスティック2の4ボタン
	//	KeyCode.Joystick2Button5,	//ジョイスティック2の5ボタン
	//	KeyCode.Joystick2Button6,	//ジョイスティック2の6ボタン
	//	KeyCode.Joystick2Button7,	//ジョイスティック2の7ボタン
	//	KeyCode.Joystick2Button8,	//ジョイスティック2の8ボタン
	//	KeyCode.Joystick2Button9,	//ジョイスティック2の9ボタン
	//	KeyCode.Joystick2Button10,	//ジョイスティック2の10ボタン
	//	KeyCode.Joystick2Button11,	//ジョイスティック2の11ボタン
	//	KeyCode.Joystick2Button12,	//ジョイスティック2の12ボタン
	//	KeyCode.Joystick2Button13,	//ジョイスティック2の13ボタン
	//	KeyCode.Joystick2Button14,	//ジョイスティック2の14ボタン
	//	KeyCode.Joystick2Button15,	//ジョイスティック2の15ボタン
	//	KeyCode.Joystick2Button16,	//ジョイスティック2の16ボタン
	//	KeyCode.Joystick2Button17,	//ジョイスティック2の17ボタン
	//	KeyCode.Joystick2Button18,	//ジョイスティック2の18ボタン
	//	KeyCode.Joystick2Button19,	//ジョイスティック2の19ボタン
	//	KeyCode.Joystick3Button0,	//ジョイスティック3の0ボタン
	//	KeyCode.Joystick3Button1,	//ジョイスティック3の1ボタン
	//	KeyCode.Joystick3Button2,	//ジョイスティック3の2ボタン
	//	KeyCode.Joystick3Button3,	//ジョイスティック3の3ボタン
	//	KeyCode.Joystick3Button4,	//ジョイスティック3の4ボタン
	//	KeyCode.Joystick3Button5,	//ジョイスティック3の5ボタン
	//	KeyCode.Joystick3Button6,	//ジョイスティック3の6ボタン
	//	KeyCode.Joystick3Button7,	//ジョイスティック3の7ボタン
	//	KeyCode.Joystick3Button8,	//ジョイスティック3の8ボタン
	//	KeyCode.Joystick3Button9,	//ジョイスティック3の9ボタン
	//	KeyCode.Joystick3Button10,	//ジョイスティック3の10ボタン
	//	KeyCode.Joystick3Button11,	//ジョイスティック3の11ボタン
	//	KeyCode.Joystick3Button12,	//ジョイスティック3の12ボタン
	//	KeyCode.Joystick3Button13,	//ジョイスティック3の13ボタン
	//	KeyCode.Joystick3Button14,	//ジョイスティック3の14ボタン
	//	KeyCode.Joystick3Button15,	//ジョイスティック3の15ボタン
	//	KeyCode.Joystick3Button16,	//ジョイスティック3の16ボタン
	//	KeyCode.Joystick3Button17,	//ジョイスティック3の17ボタン
	//	KeyCode.Joystick3Button18,	//ジョイスティック3の18ボタン
	//	KeyCode.Joystick3Button19,	//ジョイスティック3の19ボタン
	//	KeyCode.Joystick4Button0,	//ジョイスティック4の0ボタン
	//	KeyCode.Joystick4Button1,	//ジョイスティック4の1ボタン
	//	KeyCode.Joystick4Button2,	//ジョイスティック4の2ボタン
	//	KeyCode.Joystick4Button3,	//ジョイスティック4の3ボタン
	//	KeyCode.Joystick4Button4,	//ジョイスティック4の4ボタン
	//	KeyCode.Joystick4Button5,	//ジョイスティック4の5ボタン
	//	KeyCode.Joystick4Button6,	//ジョイスティック4の6ボタン
	//	KeyCode.Joystick4Button7,	//ジョイスティック4の7ボタン
	//	KeyCode.Joystick4Button8,	//ジョイスティック4の8ボタン
	//	KeyCode.Joystick4Button9,	//ジョイスティック4の9ボタン
	//	KeyCode.Joystick4Button10,	//ジョイスティック4の10ボタン
	//	KeyCode.Joystick4Button11,	//ジョイスティック4の11ボタン
	//	KeyCode.Joystick4Button12,	//ジョイスティック4の12ボタン
	//	KeyCode.Joystick4Button13,	//ジョイスティック4の13ボタン
	//	KeyCode.Joystick4Button14,	//ジョイスティック4の14ボタン
	//	KeyCode.Joystick4Button15,	//ジョイスティック4の15ボタン
	//	KeyCode.Joystick4Button16,	//ジョイスティック4の16ボタン
	//	KeyCode.Joystick4Button17,	//ジョイスティック4の17ボタン
	//	KeyCode.Joystick4Button18,	//ジョイスティック4の18ボタン
	//	KeyCode.Joystick4Button19,	//ジョイスティック4の19ボタン
	//	KeyCode.Joystick5Button0,	//ジョイスティック5の0ボタン
	//	KeyCode.Joystick5Button1,	//ジョイスティック4の1ボタン
	//	KeyCode.Joystick5Button2,	//ジョイスティック4の2ボタン
	//	KeyCode.Joystick5Button3,	//ジョイスティック4の3ボタン
	//	KeyCode.Joystick5Button4,	//ジョイスティック4の4ボタン
	//	KeyCode.Joystick5Button5,	//ジョイスティック4の5ボタン
	//	KeyCode.Joystick5Button6,	//ジョイスティック5の6ボタン
	//	KeyCode.Joystick5Button7,	//ジョイスティック5の7ボタン
	//	KeyCode.Joystick5Button8,	//ジョイスティック5の8ボタン
	//	KeyCode.Joystick5Button9,	//ジョイスティック5の9ボタン
	//	KeyCode.Joystick5Button10,	//ジョイスティック5の10ボタン
	//	KeyCode.Joystick5Button11,	//ジョイスティック5の11ボタン
	//	KeyCode.Joystick5Button12,	//ジョイスティック5の12ボタン
	//	KeyCode.Joystick5Button13,	//ジョイスティック5の13ボタン
	//	KeyCode.Joystick5Button14,	//ジョイスティック5の14ボタン
	//	KeyCode.Joystick5Button15,	//ジョイスティック5の15ボタン
	//	KeyCode.Joystick5Button16,	//ジョイスティック5の16ボタン
	//	KeyCode.Joystick5Button17,	//ジョイスティック5の17ボタン
	//	KeyCode.Joystick5Button18,	//ジョイスティック5の18ボタン
	//	KeyCode.Joystick5Button19,	//ジョイスティック5の19ボタン
	//	KeyCode.Joystick6Button0,	//ジョイスティック6の0ボタン
	//	KeyCode.Joystick6Button1,	//ジョイスティック6の1ボタン
	//	KeyCode.Joystick6Button2,	//ジョイスティック6の2ボタン
	//	KeyCode.Joystick6Button3,	//ジョイスティック6の3ボタン
	//	KeyCode.Joystick6Button4,	//ジョイスティック6の4ボタン
	//	KeyCode.Joystick6Button5,	//ジョイスティック6の5ボタン
	//	KeyCode.Joystick6Button6,	//ジョイスティック6の6ボタン
	//	KeyCode.Joystick6Button7,	//ジョイスティック6の7ボタン
	//	KeyCode.Joystick6Button8,	//ジョイスティック6の8ボタン
	//	KeyCode.Joystick6Button9,	//ジョイスティック6の9ボタン
	//	KeyCode.Joystick6Button10,	//ジョイスティック6の10ボタン
	//	KeyCode.Joystick6Button11,	//ジョイスティック6の11ボタン
	//	KeyCode.Joystick6Button12,	//ジョイスティック6の12ボタン
	//	KeyCode.Joystick6Button13,	//ジョイスティック6の13ボタン
	//	KeyCode.Joystick6Button14,	//ジョイスティック6の14ボタン
	//	KeyCode.Joystick6Button15,	//ジョイスティック6の15ボタン
	//	KeyCode.Joystick6Button16,	//ジョイスティック6の16ボタン
	//	KeyCode.Joystick6Button17,	//ジョイスティック6の17ボタン
	//	KeyCode.Joystick6Button18,	//ジョイスティック6の18ボタン
	//	KeyCode.Joystick6Button19,	//ジョイスティック6の19ボタン
	//	KeyCode.Joystick7Button0,	//ジョイスティック7の0ボタン
	//	KeyCode.Joystick7Button1,	//ジョイスティック7の1ボタン
	//	KeyCode.Joystick7Button2,	//ジョイスティック7の2ボタン
	//	KeyCode.Joystick7Button3,	//ジョイスティック7の3ボタン
	//	KeyCode.Joystick7Button4,	//ジョイスティック7の4ボタン
	//	KeyCode.Joystick7Button5,	//ジョイスティック7の5ボタン
	//	KeyCode.Joystick7Button6,	//ジョイスティック7の6ボタン
	//	KeyCode.Joystick7Button7,	//ジョイスティック7の7ボタン
	//	KeyCode.Joystick7Button8,	//ジョイスティック7の8ボタン
	//	KeyCode.Joystick7Button9,	//ジョイスティック7の9ボタン
	//	KeyCode.Joystick7Button10,	//ジョイスティック7の10ボタン
	//	KeyCode.Joystick7Button11,	//ジョイスティック7の11ボタン
	//	KeyCode.Joystick7Button12,	//ジョイスティック7の12ボタン
	//	KeyCode.Joystick7Button13,	//ジョイスティック7の13ボタン
	//	KeyCode.Joystick7Button14,	//ジョイスティック7の14ボタン
	//	KeyCode.Joystick7Button15,	//ジョイスティック7の15ボタン
	//	KeyCode.Joystick7Button16,	//ジョイスティック7の16ボタン
	//	KeyCode.Joystick7Button17,	//ジョイスティック7の17ボタン
	//	KeyCode.Joystick7Button18,	//ジョイスティック7の18ボタン
	//	KeyCode.Joystick7Button19,	//ジョイスティック7の19ボタン
	//	KeyCode.Joystick8Button0,	//ジョイスティック8の0ボタン
	//	KeyCode.Joystick8Button1,	//ジョイスティック8の1ボタン
	//	KeyCode.Joystick8Button2,	//ジョイスティック8の2ボタン
	//	KeyCode.Joystick8Button3,	//ジョイスティック8の3ボタン
	//	KeyCode.Joystick8Button4,	//ジョイスティック8の4ボタン
	//	KeyCode.Joystick8Button5,	//ジョイスティック8の5ボタン
	//	KeyCode.Joystick8Button6,	//ジョイスティック8の6ボタン
	//	KeyCode.Joystick8Button7,	//ジョイスティック8の7ボタン
	//	KeyCode.Joystick8Button8,	//ジョイスティック8の8ボタン
	//	KeyCode.Joystick8Button9,	//ジョイスティック8の9ボタン
	//	KeyCode.Joystick8Button10,	//ジョイスティック8の10ボタン
	//	KeyCode.Joystick8Button11,	//ジョイスティック8の11ボタン
	//	KeyCode.Joystick8Button12,	//ジョイスティック8の12ボタン
	//	KeyCode.Joystick8Button13,	//ジョイスティック8の13ボタン
	//	KeyCode.Joystick8Button14,	//ジョイスティック8の14ボタン
	//	KeyCode.Joystick8Button15,	//ジョイスティック8の15ボタン
	//	KeyCode.Joystick8Button16,	//ジョイスティック8の16ボタン
	//	KeyCode.Joystick8Button17,	//ジョイスティック8の17ボタン
	//	KeyCode.Joystick8Button18,	//ジョイスティック8の18ボタン
	//	KeyCode.Joystick8Button19,	//ジョイスティック8の19ボタン
	};
}
#endif//UNITY_5_3_OR_NEWER
