/*
 *	regexp.h
 *
 *	Bell V8 K\
 *
 *	* Mon Aug 22 21:52:16 JST 2016 Naoyuki Sawa
 *	- 1st [XB
 *	- Bell V8 K\łB(http://kaworu.jpn.org/doc/FreeBSD/jman/man3/regexp.3.php)
 *	  POSIX.2 K\ł͂܂B(http://linuxjm.osdn.jp/html/LDP_man-pages/man7/regex.7.html)
 *	  POSIX.2 K\͕GŃR[hTCY傫Ȃ̂ŁABell V8 K\ōς܂鎖ɂ܂B
 *	- MINIX 1.7.5 ̃\[X(http://download.minix3.org/previous-versions/gzipped/Intel-1.7.5.tar.gz)Ɋ܂܂ĂA
 *	  /Intel-1.7.5/SYS/src/lib/other/regexp.cɁA폜ĒPč쐬܂B
 *	* Mon Nov 13 23:52:13 JST 2017 Naoyuki Sawa
 *	- Ǝgstrdup_regsub_np()ǉ܂B
 *	  strdup_regsub_np()ǉŔAȉ̒ʂłB
 *	- Wdlregsub()ł́Ao̓obt@dest̗eʂwoȂ߁Aregsub()dest̗eʂ𒴂ĕi[鎖mɉ@L܂B
 *	  ̂߂܂ł́AAvP[Vő傫ȗeʂdestmۂregsub()Ăяo@ApāAKvȏɃĂ܂B
 *	  L̖邽߂ɁAstrdup_*()n̊֐ƓlɁAIɕKvȗeʂ̃obt@mۂāAʂi[֐ǉ鎖ɂ܂B
 *	  strdup_regsub_np()͓ƎgłABell V8 K\̕Wdlł͂Ȃ̂ŁA֐TtBbNX'np'('not portable')t^܂B
 *	* Thu Nov 16 23:42:50 JST 2017 Naoyuki Sawa
 *	- Ǝgregcaseexec_np()ǉ܂B
 *	  POSIX.2 K\Ȃ΁Aregcomp()cflagsREG_ICASEŎwôłABell V8 K\̊֐ɂ̓tOw肪̂ŁA֐𕪂܂B
 *	  regcomp()𕪂@l̂łAregexec()ł̃}b`Osɐ؂ւ֗Ǝv̂ŁAregexec()𕪂鎖ɂ܂B
 */
#ifndef __REGEXP_H__
#define __REGEXP_H__
#ifdef  __cplusplus
extern "C" {
#endif//__cplusplus
/*****************************************************************************
 *	
 *****************************************************************************/
//QƎuREGEXP(3) FreeBSD Cu֐}jA REGEXP(3)v(http://kaworu.jpn.org/doc/FreeBSD/jman/man3/regexp.3.php)
//
//		regcomp, regexec, regsub, regerror - K\nh
//
//Cu
//		݊Cu (libcompat, -lcompat)
//
//
//		#include <regexp.h>
//		regexp* regcomp(const char* exp);
//		int regexec(const regexp* prog, const char* string);
//		void regsub(const regexp* prog, const char* source, char* dest);
//
//
//		̃C^tF[X́Aregex(3)Œu܂B
//
//		regcomp(),regexec(),regsub(),regerror()egrep(1)X^C̐K\ƃT|[g@\Ă܂B
//
//		regcomp()́AK\regexp()^Cv̍\̂ɃRpCA̍\̂̃|C^߂܂B
//		Xy[Xmalloc(3)ŊUAfreeŉ܂B
//
//		regexec()֐́ANULLŏIstringprog̃RpCςݐK\Ɠ˂킹܂B
//		肪Ȃꍇ1߂A肪ꍇ0߂܂B
//		܂Aprogstartpendp(LQ)̓e𒲐܂B
//
//		regexp()\̂̃oɂ́AŒłȉKvłBԂ͊֌W܂B
//
//			char* startp[NSUBEXP];
//			char* endp[NSUBEXP];
//
//		NSUBEXṔAwb_t@C10ɒ`Ă܂B
//		regexp()gpregexec()ȂsƁAstartpendp̊eyÁAstring̃TuXgO\܂B
//		startp̓TuXgȎ1LN^wAendp̓TuXgO̎̑1LN^w܂B
//		0Ԗڂ̃TuXgÓAK\Ŝƈvstring̃TuXgOłB
//		̑́AK\̊ʂň͂܂ꂽ\ƈvTuXgOłB
//		ʂň͂܂ꂽ\ɂ́Aʂ̍E̎Ŕԍt܂B
//
//		regsub()֐́AproggpčŌɎsregexec()ɏ]ĒusȂȂAsourcedestɃRs[܂B
//		sourcée&f̊eCX^X́Astartp[0]endp[0]ŎTuXgOŒu܂B
//		e\nf̊eCX^X(n͐)́Astartp[n]endp[n]ŎTuXgOŒu܂B
//		ee&fe\nfdestɔzuɂ́ÃȇOɁe\fzu܂B
//		e&fe\nf̑OɃee\ftɂ́ȂOɁe\f1t܂B
//
//		regerror()֐́Aregcomp(),regexec(),regsub()ŃG[oƏɌĂяo܂B
//		ftHgregerror()́A̓K؂ȃCWP[^gpAXgOmsgWG[o͂ɏexit(3)Ăяo܂B
//		̑̃ANV]܂ꍇA[Uregerror()֐ʂ̂̂ƒu܂B
//
//K\V^bNX
//		K\́Ae|fŋ؂ꂽA0ȏ̃u`łB
//		u`1ƈv̂ƈv܂B
//
//		u`́A0ȏ̘As[XłB
//		ŏɈv̂ƈvŁAɈv̂ƈv܂B
//
//		s[X́Ae*f,e+f,e?fƂAgłB
//		e*fAǵAAg0ȏ̈ṽV[PXƈv܂B
//		e+fAǵAAg1ȏ̈ṽV[PXƈv܂B
//		e?fAǵAAg̈vA܂nullXgOƈv܂B
//
//		AǵAʂň͂܂ꂽK\(K\̈vƈv)A͈(LQ)Ae.f(1LN^ƈv)Ae^f(̓XgO̍ŏnullXgOƈv)A
//		e$f(̓XgO̍ŌnullXgOƈv)A1LN^e\f(̃LN^ƈv)Ȃ̈ӖȂ1LN^(̃LN^ƈv)łB
//
//		͈͂́Ae[]fň͂܂ꂽLN^̃V[PXłB
//		ʏ́ÃV[PX1LN^ƈv܂B
//		V[PXe^fŎn܂ꍇ́AV[PX̎c̃LN^ł͂Ȃ1LN^ƈv܂B
//		V[PX2̃LN^e-fŋ؂ĂꍇÁA2LN^ɋ܂ꂽASCIILN^̃Xg\܂(Ƃ΁e[0-9]f́ACӂ̏\iƈv܂)B
//		V[PXɃee]fgݍނɂ́Aŏ̃LN^ɂ܂(e^fꍇ͂̎̃LN^ɂ܂)B
//		ee-fgݍނɂ́AŏŌ̃LN^ɂ܂B
//
//܂
//		K\̓XgO2̕ƈvꍇ́Aŏ̂̂ƈv܂B
//		ꏊŎn܂Ă邪قȂꍇA܂͒ŕʁX̏ꏊŎn܂ĂꍇA͈ȉ̂悤ɕGɂȂ܂B
//
//		ʓIɁAu`̃Xg͍̎Eɍl܂B
//		e*f,e+f,e?f̎͒̂l܂B
//		lXgꂽRXgNg͊Ol܂B
//		AꂽRXgNg͍l܂B
//		Iv́Aŏ̑I̍ŏ̎gp̂ƂȂ܂B
//		Iꍇ́Aŏ̌ɏ]āA@(ŏ̎)ōsȂ܂B
//		c悤ɂȂ܂B
//
//		Ƃ΁e(ab|a)b*cfeabcfƈv@ɂ2܂B
//		ŏ̑ÍAeabfƁeaf̊ԂłB
//		eabfŁAȂvŜ[ĥŁAꂪI܂B
//		ebf͂łɑIĂ̂ŁAeb*f͍Ō̎(XgO)ƈv܂B
//		̑IlKv邩łB
//
//		e|f݂Ae*f,e+f,e?f1݂ꍇ́AłvI錋ʂƂȂ܂B
//		exabbbbyfŒ񋟂ꂽeab*f́Aeabbbbfƈv܂B
//		eab*fexabyabbbzfŎƁAŏ̂̂ÎŁAexf̌́eabfƈv邱ƂɒӂĂB
//		(ۂɂ́Avn߂ꏊ̌肪ŏ̑IȂ̂ŁȂIł́AD揇ʂႢĂ[hĂĂlKv܂B)
//
//߂l
//		regcomp()֐́AV^bNXG[AVXe̒zANULLIyhւ́e+fe*f̓KpȂǂ̃G[ꍇNULL߂܂(regerror()Jn܂)B
//
//֘A
//		ed(1), egrep(1), ex(1), expr(1), fgrep(1), grep(1), regex(3)
//
//j
//		regcomp(), regexec(), regsub(), regerror()̃R[hƃ}jAy[ẂAggwō쐬A4.3-TahoeBSDɒǉ܂B
//		Bell V8 regexp(3)ƌ݊ۂ悤ɂȂĂ܂ABellR[hĥł͂܂B
//
//oO
//		̃u`Ƌ̐K\́AV8ƌ݊͂܂B
//		NULLIyhɁe*fe+fKp邱Ƃɉۂ鐧́AVXePɂ邽߂̂̂łB
//		egrep̉sŋ؂ꂽu`̓T|[gĂ܂BV8 regexp(3)łT|[gĂ܂B
//		ȌƒP߁AقǑ܂BPȃP[X𑬂邱ƂɒӂĂ܂B
//
//FreeBSD 10.0 June 4, 1993 FreeBSD 10.0
/*****************************************************************************
 *	萔
 *****************************************************************************/
#define NSUBEXP		10
/*****************************************************************************
 *	\
 *****************************************************************************/
typedef struct regexp {
	char*		startp[NSUBEXP];
	char*		endp[NSUBEXP];
} regexp;
/*****************************************************************************
 *	O[o֐
 *****************************************************************************/
regexp* regcomp(const char* exp);
int regexec(regexp* prog, const char* string);
void regsub(const regexp* prog, const char* source, char* dest);
void regerror(const char* errmsg);
/*****************************************************************************
 *	fobOp
 *****************************************************************************/
#ifdef  DEBUG
extern int regnarrate;
void regdump(const regexp* prog);
#endif//DEBUG
/*****************************************************************************
 *	Ǝg
 *****************************************************************************/
char* strdup_regsub_np(const regexp* prog, const char* source);		//{{2017/11/13ǉ:Ǝgstrdup_regsub_np()ǉ܂B}}
int regcaseexec_np(regexp* prog, const char* string);			//{{2017/11/16ǉ:Ǝgregcaseexec_np()ǉ܂B}}
#ifdef  __cplusplus
}//extern "C"
#endif//__cplusplus
#endif//__REGEXP_H__
