	/********************************************************************/
	/*                                                                  */
	/*  math.h                                                          */
	/*       version 0          1992/08/31        K.Shinozuka           */
    	/*       modified	    1997/03/17	      T.Katahira	    */
    	/*		change function declaration to the ANSI style	    */
	/*                                                                  */
	/*  math.h contains followings.                                     */
	/*    extern declarations of math-functions                         */
	/*    extern declarations of special codes and useful numbers       */
	/*                                                                  */
	/*       modify for P/ECE   2015/07/25        Naoyuki Sawa          */
	/*		- /usr/PIECE/include ɂt@CÃt@CD悳悤Aclip.mkɂāACN[hpXݒ肵Ă܂B	*/
	/*		- log2()ǉ܂B́Acliplibc.cɂ܂Blog2()́AC99Œǉꂽ֐łBuLua 5.3.1vAgpĂ܂B	*/
	/*		  EPSONCuɂAVisual C++ 6.0ɂAlog2()͊܂܂Ă܂B								*/
	/*       modify for P/ECE   2015/11/18        Naoyuki Sawa          */
	/*		- 'extern "C" {'`'}'ň݂͂܂B.cpp܂Win32vWFNgCN[ho悤ɂ邽߂łB	*/
	/*       modify for P/ECE   2015/11/24        Naoyuki Sawa          */
	/*		- M_E,M_PI̒`Aclipfix.hmath.hֈړ܂B	*/
	/*       modify for P/ECE   2016/03/24        Naoyuki Sawa          */
	/*		- signbit(),copysign(),copysignf()ǉ܂B											*/
	/*		  C99Œǉꂽp̃}N,y,֐ŁA܂g͖Ǝv܂AoĂ߂ɎĂɂ܂B	*/
	/*		- round(),roundf(),nearbyint(),nearbyintf(),rint(),rintf(),lround(),lroundf(),lrint(),lrintf()ǉ܂B				*/
	/*		  C99Œǉꂽۂߊ֐ŁAɁAlround()֗Ǝv܂B									*/
	/*		  ܂܂ł'(int)((x>=0.0)?(x+0.5):(x-0.5))'̂悤ɏĂA'lround(x)'ōςނ悤ɂȂ܂B				*/
	/*		- 錾͑SāAinclude/math.hɗL܂B												*/
	/*		  {xo[W̊֐Acopysign(),lround(),lrint(),round(),nearbyint(),rint(),trunc()̎́Acliplibc.cɗL܂B		*/
	/*		  Pxo[W̊֐Acopysignf(),lroundf(),lrintf(),roundf(),nearbyintf(),rintf(),truncf()̎́Aframflt2.cɗL܂B		*/
	/*		  𕪂ŔAPxZCu(AvP[VgpĂȂ̂)ʂɃNāATCY鎖h߂łB	*/
	/*       modify for P/ECE   2016/03/28        Naoyuki Sawa          */
	/*		- fdim(),fdimf(),fmin(),fminf(),fmax(),fmaxf(),fma(),fmaf()ǉ܂B								*/
	/*		  C99Œǉꂽ֐łB													*/
	/*		  fdim()́AɎĝǂȂ̂łAoĂ߂ɎĂɂ܂B	{{2016/03/29RgǋLQƂ}}	*/
	/*		  fmin(),fmax()́Amin(),max()}N^𖾎o邵p̂ŁA֗ɎgpoƎv܂B				*/
	/*		  fma()́AϘaZZEՂ̂ŁA(gʂ͏ȂƎv܂)g͗LƎv܂B					*/
	/*		- 錾͑SāAinclude/math.hɗL܂B												*/
	/*		  {xo[W̊֐Afdim(),fmin(),fmax(),fma()̎́Acliplibc.cɗL܂B							*/
	/*		  Pxo[W̊֐Afdimf(),fminf(),fmaxf(),fmaf()̎́Aframflt2.cɗL܂B						*/
	/*		  𕪂ŔAPxZCu(AvP[VgpĂȂ̂)ʂɃNāATCY鎖h߂łB	*/
	/*		//{{2016/03/29RgǋL																		*/
	/*		  fdim()̎g݂܂B																	*/
	/*		  ݂ɃJEgAbvJE^iCntŃtF[hAEgǗꍇAȉ̂悤fdim()gƊȒP1.00.0ɕω0.0ŖOaalpha𓾂鎖o܂B	*/
	/*		  int iCnt = 0;																			*/
	/*		  for(;;) {																				*/
	/*		    if(kbhit()) { iCnt = 1; }																		*/
	/*		    double alpha = fdim(1.0, (double)iCnt / (double)SEC(3.0)); //iCnt=0Ȃalpha=1.0AiCnt=1SEC(3.0)alpha=0.96660.0AiCntSEC(3.0)łalpha=0.0ێB	*/
	/*		    `(x, y, XvCgԍ, alpha);																*/
	/*		    if(iCnt) { iCnt++; }																		*/
	/*		  }																					*/
	/*		  {iCntSEC(3.0)Ŏ~܂lɏΗǂȂ̂łAvO쐬ɈꎞIɎ蔲ȂǂɊȒPɏ͕̂֗Ǝv܂B			*/
	/*		//}}2016/03/29RgǋL																		*/
	/*                                                                  */
	/********************************************************************/

#ifndef MATH_H 
#define MATH_H

#ifdef UNIX
#include "errno.h"
#else
#include <errno.h>
#endif

#ifdef  __cplusplus
extern "C" {
#endif//__cplusplus

//{{2015/11/24ǉ:M_E,M_PI̒`Aclipfix.hmath.hֈړ܂B
// * Tue Nov 24 21:15:16 JST 2015 Naoyuki Sawa
// - M_E,M_PI̒`Aclipfix.hmath.hֈړ܂B
// - ꕔ̃V{Borland C++POSIXƂňĂ鎖ɋCt̂ŁÃV{Œ`鎖ɂ܂B
//   ܂AXcodẽ}jAƂĂV{L鎖ɋCt̂ŁÃV{Œ`鎖ɂ܂B
//QƎ:
//uThe Open Group Base Specifications Issue 7 IEEE Std 1003.1, 2013 Edition - math.h - mathematical declarationsv
//(http://pubs.opengroup.org/onlinepubs/9699919799/basedefs/math.h.html)
#define M_E		2.71828182845904523536		//				POSIX
#define M_LOG2E		1.44269504088896340736		//logQ()			POSIX
#define M_LOG10E	0.434294481903251827651		//log10()			POSIX
#define M_LN2		0.693147180559945309417		//log(Q)			POSIX
#define M_LN10		2.30258509299404568402		//log(10)			POSIX
#define M_PI		3.14159265358979323846		//				POSIX
#define M_PI_2		1.57079632679489661923		//΁^Q			POSIX
#define M_PI_4		0.785398163397448309616		//΁^S			POSIX
#define M_1_PI		0.318309886183790671538		//P^			POSIX
#define M_2_PI		0.636619772367581343076		//Q^			POSIX
#define M_1_SQRTPI	0.564189583547756286948		//P^()			Borland C++ Compiler 5.5 <math.h> L? POSIXXcodeł͒`ĂȂ悤łB
#define M_2_SQRTPI	1.12837916709551257390		//Q^()			POSIX
#define M_SQRT2		1.41421356237309504880		//    (Q)			POSIX
#define M_SQRT1_2	0.707106781186547524401		//P^(Q) = (P^Q)	POSIX
#define M_SQRT_2	M_SQRT1_2			//()			Borland C++ Compiler 5.5 <math.h> ł̖͂OɂȂĂ܂B
#define M_SQRT_1_2	M_SQRT1_2			//()			Xcode Tools version 5.0 <math.h> ł̖͂OɂȂĂ悤łB	QƎ:uOS X Man Pages - M_PIvhttps://developer.apple.com/library/mac/documentation/Darwin/Reference/ManPages/man3/M_SQRT_1_2.3.html
//}}2015/11/24ǉ:M_E,M_PI̒`Aclipfix.hmath.hֈړ܂B

extern double acos( double );
extern double asin( double );
extern double atan( double );
extern double atan2( double, double );
extern double ceil( double );
extern double cos( double );
extern double cosh( double );
extern double exp( double );
extern double fabs( double );
extern double floor( double );
extern double fmod( double, double );
extern double frexp( double, int * );
extern double ldexp( double, int );
extern double log( double );
extern double log10( double );
extern double modf( double, double * );
extern double pow( double, double );
extern double sin( double );
extern double sinh( double );
extern double sqrt( double );
extern double tan( double );
extern double tanh( double );

#ifndef DBL_LNG_TYPE 

#define DBL_LNG_TYPE 

typedef union {
    struct {
#ifdef BIG_ENDIAN
        unsigned long _LL;
        unsigned long _LH;
#else  
        unsigned long _LH;
        unsigned long _LL;
#endif 
    } st;
    double _D;
} DBL_LNG;

#endif

//{{2015/07/25ǉ:log2()ǉ܂B́Acliplibc.cɂ܂Blog2()́AC99Œǉꂽ֐łBuLua 5.3.1vAgpĂ܂B
double log2(double x);
//}}2015/07/25ǉ:log2()ǉ܂B́Acliplibc.cɂ܂Blog2()́AC99Œǉꂽ֐łBuLua 5.3.1vAgpĂ܂B

//{{2016/03/24ǉ:signbit(),copysign(),copysignf()ǉ܂Bround(),roundf(),nearbyint(),nearbyintf(),rint(),rintf(),lround(),lroundf(),lrint(),lrintf()ǉ܂B
//uLinux Programmer's Manual - SIGNBITv(http://linuxjm.osdn.jp/html/LDP_man-pages/man3/signbit.3.html)p:
//signbit()́Aނ̕_ɑ΂ēKp\ȔėpIȃ}NłBx̒l̕rbgZbgĂꍇA0̒lԂB
//̃}Nx<0.0ƑSł͂ȂBȂȂAIEEE754̕_\ł0łB-0.0<0.0Ƃrʂ͋U(false)Asignbit(-0.0)͔0̒lԂB	ƏĂ邪AȒPɎ邽߂((x)<0)ƂBp͂łxᖳƎvAۂ̏}NgCBAfloatɑ΂ĂKp\L鎖lāA]vfloatdoubleϊ𔭐Ȃ߂ɁA((x)<0.0)ł͂Ȃ((x)<0)ƂĂɂB
//NaNƖɂ͕rbgB
#define signbit(x) ((x)<0)
//uLinux Programmer's Manual - COPYSIGNv(http://linuxjm.osdn.jp/html/LDP_man-pages/man3/copysign.3.html)p:
//֐copysign(),copysignf(),copysignl()͐ΒlxɓArbgyɓlԂB
double copysign(double x, double y);				//cliplibc.c
float copysignf(float x, float y);				//framflt2.c
//long double copysignl(long double x, long double y);		//Ή
//uLinux Programmer's Manual - ROUNDv(http://linuxjm.osdn.jp/html/LDP_man-pages/man3/round.3.html)p:
//̊֐xł߂lɊۂ߂B
//2̐̒Ԓl̏ꍇ́Arint()̂悤ɍł߂Ɋۂ߂肹ɁA(݂̊ۂߕɊ֌WȂ)0牓Ɋۂ߂(ۂߕɂĂfenv()Q)B
double round(double x);						//cliplibc.c
float roundf(float x);						//framflt2.c
//long double roundl(long double x);				//Ή
//uLinux Programmer's Manual - RINTv(http://linuxjm.osdn.jp/html/LDP_man-pages/man3/rint.3.html)p:
//֐nearbyint(),nearbyintf(),andnearbyintl()́Å݂ۂߕ(fesetround()Q)ň𕂓_`̐Ɋۂ߂BinexactOoȂB
//֐rint(),rintf(),andrintl()悤ȓ邪AʂƈقȂꍇinexactO(FE_INEXACT)o(̗Ofetestexcept()oRŊmF\)B
double nearbyint(double x);					//cliplibc.c
float nearbyintf(float x);					//framflt2.c
//long double nearbyintl(long double x);			//Ή
double rint(double x);						//cliplibc.c
float rintf(float x);						//framflt2.c
//long double rintl(long double x);				//Ή
//uLinux Programmer's Manual - LROUNDv(http://linuxjm.osdn.jp/html/LDP_man-pages/man3/lround.3.html)p:
//̊֐͍ł߂Ɉۂ߂B݂̊ۂߕɊ֌WȂA0牓̍ł߂Ɉ͊ۂ߂(݂̊ۂߕɂĂfenv()Q)B
//֐round(),ceil()ƈႢÅ֐̕Ԃľ^͈̌^ƈقȂ_ɒӂ邱ƁB
long lround(double x);						//cliplibc.c
long lroundf(float x);						//framflt2.c
//long lroundl(long double x);					//Ή
//long long llround(double x);					//Ή
//long long llroundf(float x);					//Ή
//long long llroundl(long double x);				//Ή
//uLinux Programmer's Manual - LRINTv(http://linuxjm.osdn.jp/html/LDP_man-pages/man3/lrint.3.html)p:
//̊֐́Å݂ۂߕɊÂAł߂Ɉۂ߂(݂̊ۂߕɂĂfesetround()Q)B
//rint()n̊֐ƈႢÅ֐̕Ԃľ^͈̌^ƈقȂ_ɒӂ邱ƁB
long lrint(double x);						//cliplibc.c
long lrintf(float x);						//framflt2.c
//long lrintl(long double x);					//Ή
//long long llrint(double x);					//Ή
//long long llrintf(float x);					//Ή
//long long llrintl(long double x);				//Ή
//uLinux Programmer's Manual - TRUNCv(http://linuxjm.osdn.jp/html/LDP_man-pages/man3/trunc.3.html)p:
//̊֐͐Βlx菬ԋ߂lxۂ߂B
double trunc(double x);						//cliplibc.c
float truncf(float x);						//framflt2.c
//long double truncl(long double x);				//Ή
//}}2016/03/24ǉ:signbit(),copysign(),copysignf()ǉ܂Bround(),roundf(),nearbyint(),nearbyintf(),rint(),rintf(),lround(),lroundf(),lrint(),lrintf()ǉ܂B

//{{2016/03/28ǉ:fdim(),fdimf(),fmin(),fminf(),fmax(),fmaxf(),fma(),fmaf()ǉ܂B
//uLinux Programmer's Manual - FDIMv(https://linuxjm.osdn.jp/html/LDP_man-pages/man3/fdim.3.html)p:
//̊֐́A̈Ԃ̐̍max(x-y,0)ԂB
double fdim(double x, double y);					//cliplibc.c
float fdimf(float x, float y);						//framflt2.c
//long double fdiml(long double x, long double y);			//Ή
//uLinux Programmer's Manual - FMINv(https://linuxjm.osdn.jp/html/LDP_man-pages/man3/fmin.3.html)p:
//̊֐xŷ̒lԂB
double fmin(double x, double y);					//cliplibc.c
float fminf(float x, float y);						//framflt2.c
//long double fminl(long double x, long double y);			//Ή
//uLinux Programmer's Manual - FMAXv(https://linuxjm.osdn.jp/html/LDP_man-pages/man3/fmax.3.html)p:
//̊֐xŷ傫̒lԂB
double fmax(double x, double y);					//cliplibc.c
float fmaxf(float x, float y);						//framflt2.c
//long double fmaxl(long double x, long double y);			//Ή
//uLinux Programmer's Manual - FMAv(https://linuxjm.osdn.jp/html/LDP_man-pages/man3/fma.3.html)p:
//fma()֐x*y+zvZBʂ́A̎OZƂČ݂̊ۂ߃[hɂĊۂ߂(fenv()Q)B
double fma(double x, double y, double z);				//cliplibc.c
float fmaf(float x, float y, float z);					//framflt2.c
//long double fmal(long double x, long double y, long double z);	//Ή
//}}2016/03/28ǉ:fdim(),fdimf(),fmin(),fminf(),fmax(),fmaxf(),fma(),fmaf()ǉ܂B

#ifdef  __cplusplus
}//extern "C"
#endif//__cplusplus

#endif
