/*
 *	inttypes.h
 *
 *	^̏̕ϊ(C99ǉ)
 *
 *	CLiP - Common Library for P/ECE
 *	Copyright (C) 2018 Naoyuki Sawa
 *
 *	* Sat Feb 10 23:59:59 JST 2018 Naoyuki Sawa
 *	- 1st [XB
 *	- imaxabs(),imaxdiv(),strtoimax(),strtoumax(),wcstoimax(),wcstoumax()͖łB
 *	- 2018/02/10݂clipprnt.cł'hh'^Cq͖ΉłÂ߂ɓwb_t@CPRI?8}Nł'hh'^CqgpĂ܂B
 *	  _łclipprnt.cΉȂ̂ŁAPRI?8}NgpƐo܂B
 *	- 2018/02/10݂clipscan.cł'hh'^Cq͖ΉłÂ߂ɓwb_t@CSCN?8}Nł'hh'^CqgpĂ܂B
 *	  _łclipscan.cΉȂ̂ŁASCN?8}NgpƐo܂B
 *	- 2018/02/10݂clipscan.cł'll'^Cq͖ΉłÂ߂ɓwb_t@CSCN?64}Nł'll'^CqgpĂ܂B
 *	  _łclipscan.cΉȂ̂ŁASCN?64}NgpƐo܂B
 *	* Sun Feb 11 23:59:59 JST 2018 Naoyuki Sawa
 *	- clipprnt.cɂ'hh'^CqΉ̂ŁAPRI?8}Ng悤ɂȂ܂B
 *	- clipscan.cɂ'hh'^CqΉ̂ŁASCN?8}Ng悤ɂȂ܂B
 *	- clipscan.cɂ'll'^CqΉ̂ŁASCN?64}Ng悤ɂȂ܂B
 */
#ifndef __INTTYPES_H__
#define __INTTYPES_H__
#ifdef  __cplusplus
extern "C" {
#endif//__cplusplus
//*****************************************************************************
//	
//*****************************************************************************
#define PRId8		"hhd"
#define PRIi8		"hhi"
#define PRIo8		"hho"
#define PRIu8		"hhu"
#define PRIx8		"hhx"
#define PRIX8		"hhX"
//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
#define PRId16		"hd"
#define PRIi16		"hi"
#define PRIo16		"ho"
#define PRIu16		"hu"
#define PRIx16		"hx"
#define PRIX16		"hX"
//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
#define PRId32		"d"
#define PRIi32		"i"
#define PRIo32		"o"
#define PRIu32		"u"
#define PRIx32		"x"
#define PRIX32		"X"
//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
#define PRId64		"lld"
#define PRIi64		"lli"
#define PRIo64		"llo"
#define PRIu64		"llu"
#define PRIx64		"llx"
#define PRIX64		"llX"
//-----------------------------------------------------------------------------
#define PRIdLEAST8	PRId8
#define PRIiLEAST8	PRIi8
#define PRIoLEAST8	PRIo8
#define PRIuLEAST8	PRIu8
#define PRIxLEAST8	PRIx8
#define PRIXLEAST8	PRIX8
//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
#define PRIdLEAST16	PRId16
#define PRIiLEAST16	PRIi16
#define PRIoLEAST16	PRIo16
#define PRIuLEAST16	PRIu16
#define PRIxLEAST16	PRIx16
#define PRIXLEAST16	PRIX16
//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
#define PRIdLEAST32	PRId32
#define PRIiLEAST32	PRIi32
#define PRIoLEAST32	PRIo32
#define PRIuLEAST32	PRIu32
#define PRIxLEAST32	PRIx32
#define PRIXLEAST32	PRIX32
//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
#define PRIdLEAST64	PRId64
#define PRIiLEAST64	PRIi64
#define PRIoLEAST64	PRIo64
#define PRIuLEAST64	PRIu64
#define PRIxLEAST64	PRIx64
#define PRIXLEAST64	PRIX64
//-----------------------------------------------------------------------------
#define PRIdFAST8	PRId8
#define PRIiFAST8	PRIi8
#define PRIoFAST8	PRIo8
#define PRIuFAST8	PRIu8
#define PRIxFAST8	PRIx8
#define PRIXFAST8	PRIX8
//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
#define PRIdFAST16	PRId16
#define PRIiFAST16	PRIi16
#define PRIoFAST16	PRIo16
#define PRIuFAST16	PRIu16
#define PRIxFAST16	PRIx16
#define PRIXFAST16	PRIX16
//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
#define PRIdFAST32	PRId32
#define PRIiFAST32	PRIi32
#define PRIoFAST32	PRIo32
#define PRIuFAST32	PRIu32
#define PRIxFAST32	PRIx32
#define PRIXFAST32	PRIX32
//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
#define PRIdFAST64	PRId64
#define PRIiFAST64	PRIi64
#define PRIoFAST64	PRIo64
#define PRIuFAST64	PRIu64
#define PRIxFAST64	PRIx64
#define PRIXFAST64	PRIX64
//-----------------------------------------------------------------------------
#define PRIdPTR		"td"
#define PRIiPTR		"ti"
#define PRIoPTR		"to"
#define PRIuPTR		"tu"
#define PRIxPTR		"tx"
#define PRIXPTR		"tX"
//-----------------------------------------------------------------------------
#define PRIdMAX		"jd"
#define PRIiMAX		"ji"
#define PRIoMAX		"jo"
#define PRIuMAX		"ju"
#define PRIxMAX		"jx"
#define PRIXMAX		"jX"
//*****************************************************************************
//	
//*****************************************************************************
#define SCNd8		"hhd"
#define SCNi8		"hhi"
#define SCNu8		"hhu"
#define SCNo8		"hho"
#define SCNx8		"hhx"
//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
#define SCNd16		"hd"
#define SCNi16		"hi"
#define SCNu16		"hu"
#define SCNo16		"ho"
#define SCNx16		"hx"
//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
#define SCNd32		"d"
#define SCNi32		"i"
#define SCNu32		"u"
#define SCNo32		"o"
#define SCNx32		"x"
//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
#define SCNd64		"lld"
#define SCNi64		"lli"
#define SCNu64		"llu"
#define SCNo64		"llo"
#define SCNx64		"llx"
//-----------------------------------------------------------------------------
#define SCNdLEAST8	SCNd8
#define SCNiLEAST8	SCNi8
#define SCNuLEAST8	SCNu8
#define SCNoLEAST8	SCNo8
#define SCNxLEAST8	SCNx8
//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
#define SCNdLEAST16	SCNd16
#define SCNiLEAST16	SCNi16
#define SCNuLEAST16	SCNu16
#define SCNoLEAST16	SCNo16
#define SCNxLEAST16	SCNx16
//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
#define SCNdLEAST32	SCNd32
#define SCNiLEAST32	SCNi32
#define SCNuLEAST32	SCNu32
#define SCNoLEAST32	SCNo32
#define SCNxLEAST32	SCNx32
//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
#define SCNdLEAST64	SCNd64
#define SCNiLEAST64	SCNi64
#define SCNuLEAST64	SCNu64
#define SCNoLEAST64	SCNo64
#define SCNxLEAST64	SCNx64
//-----------------------------------------------------------------------------
#define SCNdFAST8	SCNd8
#define SCNiFAST8	SCNi8
#define SCNuFAST8	SCNu8
#define SCNoFAST8	SCNo8
#define SCNxFAST8	SCNx8
//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
#define SCNdFAST16	SCNd16
#define SCNiFAST16	SCNi16
#define SCNuFAST16	SCNu16
#define SCNoFAST16	SCNo16
#define SCNxFAST16	SCNx16
//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
#define SCNdFAST32	SCNd32
#define SCNiFAST32	SCNi32
#define SCNuFAST32	SCNu32
#define SCNoFAST32	SCNo32
#define SCNxFAST32	SCNx32
//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
#define SCNdFAST64	SCNd64
#define SCNiFAST64	SCNi64
#define SCNuFAST64	SCNu64
#define SCNoFAST64	SCNo64
#define SCNxFAST64	SCNx64
//-----------------------------------------------------------------------------
#define SCNdPTR		"td"
#define SCNiPTR		"ti"
#define SCNoPTR		"tu"
#define SCNuPTR		"to"
#define SCNxPTR		"tx"
//-----------------------------------------------------------------------------
#define SCNdMAX		"jd"
#define SCNiMAX		"ji"
#define SCNoMAX		"ju"
#define SCNuMAX		"jo"
#define SCNxMAX		"jx"
//*****************************************************************************
//	
//*****************************************************************************
#ifndef _WCHAR_T
#define _WCHAR_T
typedef unsigned short wchar_t;
#endif//_WCHAR_T
typedef struct { intmax_t quot, rem; } imaxdiv_t;
//-----------------------------------------------------------------------------
intmax_t  imaxabs(intmax_t j);						//
imaxdiv_t imaxdiv(intmax_t numerator, intmax_t denominator);		//
intmax_t  strtoimax(const char* nptr, char** endptr, int base);		//
uintmax_t strtoumax(const char* nptr, char** endptr, int base);		//
intmax_t  wcstoimax(const wchar_t* nptr, wchar_t** endptr, int base);	//
uintmax_t wcstoumax(const wchar_t* nptr, wchar_t** endptr, int base);	//
#ifdef  __cplusplus
}//extern "C"
#endif//__cplusplus
#endif//__INTTYPES_H__
