/*
 *	gdataset.h
 *
 *	Keyed Data Lists, Datasets
 *
 *	* Tue May 31 22:28:49 JST 2016 Naoyuki Sawa
 *	- 1st [XB
 *	- GLibKeyed Data List(https://developer.gnome.org/glib/stable/glib-Keyed-Data-Lists.html),y,Datasets(https://developer.gnome.org/glib/stable/glib-Datasets.html)Qlɂ܂B
 *	  ֐dl̓IWiłƓłA͓ƎŁAȃPȎD悵܂B
 *	- IWił͒PȔzpďȃD悵ĎĂ܂Ałght_hash_table𗘗pĒPȎD悵܂B
 *	  IWiłGObject(GLib̊NX)Ŏgp邽߂ɏȃŗDƂĂ悤łACuł̓[eBeBƂĎg\Ȃ̂ŏȃ͂قǏdvł͂ȂłB
 *	* Wed Jun 01 21:34:08 JST 2016 Naoyuki Sawa
 *	- gdataset.c̈ԉɁAf[^Zbg̎gpǋL܂B
 *	  f[^Xg̎gp͏Ă܂B
 *	  ۂɃf[^Xg𒼐ڎgp鎖͂قƂǖAf[^Zbgėp鎖Ǝv̂ŁAf[^Xg̎gp͕svƎv܂B
 *	  f[^Xg̎gpႪKvȏꍇ́Af[^Zbg̎f[^Xg𗘗pĂ镔QƂĉB
 */
#ifndef __G_DATASET_H__
#define __G_DATASET_H__
#ifdef	__cplusplus
extern "C" {
#endif//__cplusplus
/*****************************************************************************
 *	Keyed Data Lists - lists of data elements which are accessible by a string or GQuark identifier
 *****************************************************************************/
typedef struct _GData GData;		//The GData struct is an opaque data structure to represent a Keyed Data List. It should only be accessed via the following functions.
#define G_DATALIST_FLAGS_MASK 3		//A bitmask that restricts the possible flags passed to g_datalist_set_flags(). Passing a flags value where flags & ~G_DATALIST_FLAGS_MASK != 0 is an error.
/*--------------------------------------------------------------------------*/
void g_datalist_init(GData** datalist);
#define g_datalist_id_set_data(dl,q,d)		g_datalist_id_set_data_full((dl),(q),(d),NULL)
void g_datalist_id_set_data_full(GData** datalist, /*GQuark*/int key_id, void* data, void (*destroy_func)(void* data));
void* g_datalist_id_get_data(GData** datalist, /*GQuark*/int key_id);
#define g_datalist_id_remove_data(dl,q)		g_datalist_id_set_data((dl),(q),NULL)
void* g_datalist_id_remove_no_notify(GData** datalist, /*GQuark*/int key_id);
void* g_datalist_id_dup_data(GData** datalist, /*GQuark*/int key_id, void* (*dup_func)(void* data, void* user_data), void* user_data);
int g_datalist_id_replace_data(GData** datalist, /*GQuark*/int key_id, void* oldval, void* newval, void (*destroy)(void* data), void (**old_destroy)(void* data));
#define g_datalist_set_data(dl,k,d)		g_datalist_set_data_full((dl),(k),(d),NULL)
#define g_datalist_set_data_full(dl,k,d,f)	g_datalist_id_set_data_full((dl),quark_from_string(k),(d),(f))
#define g_datalist_get_data(dl,k)		g_datalist_id_get_data(dl,quark_from_string(k))			//IWiłł͕ł̓ꂾ̂֐ƂĎĂAƂ̑Ώ̐̂߂ɂ}NŎ̂ǂƎv̂ŁAł̓}NƂ鎖ɂB
#define g_datalist_remove_data(dl,k)		g_datalist_id_set_data((dl),quark_from_string(k),NULL)		//IWiłłg_quark_try_string()gpĂAłquark_from_string()gp鎖ɂBg_quark_try_string()NULLԂ悤ȃP[Xł́ÃNH[N͂܂݂Ȃ,,̕ɑΉf[^o^ł͂AǂɂĂʂNULLɂȂ͂łB҂̈Ⴂ͖ʂȃNH[N̓o^邩ǂłAp̖͑ʂȃNH[N̓o^Ăxᖳ낤B
#define g_datalist_remove_no_notify(dl,k)	g_datalist_id_remove_no_notify((dl),quark_from_string(k))	//IWiłłg_quark_try_string()gpĂAłquark_from_string()gp鎖ɂBg_quark_try_string()NULLԂ悤ȃP[Xł́ÃNH[N͂܂݂Ȃ,,̕ɑΉf[^o^ł͂AǂɂĂʂNULLɂȂ͂łB҂̈Ⴂ͖ʂȃNH[N̓o^邩ǂłAp̖͑ʂȃNH[N̓o^Ăxᖳ낤B
void g_datalist_foreach(GData** datalist, void (*func)(/*GQuark*/int key_id, void* data, void* user_data), void* user_data);
void g_datalist_clear(GData** datalist);
void g_datalist_set_flags(GData** datalist, int flags);
void g_datalist_unset_flags(GData** datalist, int flags);
int g_datalist_get_flags(GData** datalist);
/*****************************************************************************
 *	Datasets - associate groups of data elements with particular memory locations
 *****************************************************************************/
#define g_dataset_id_set_data(l,k,d)		g_dataset_id_set_data_full((l),(k),(d),NULL)
void g_dataset_id_set_data_full(const void* dataset_location, /*GQuark*/int key_id, void* data, void (*destroy_func)(void* data));
void* g_dataset_id_get_data(const void* dataset_location, /*GQuark*/int key_id);
#define g_dataset_id_remove_data(l,k)		g_dataset_id_set_data((l),(k),NULL)
void* g_dataset_id_remove_no_notify(const void* dataset_location, /*GQuark*/int key_id);
#define g_dataset_set_data(l,k,d)		g_dataset_set_data_full((l),(k),(d),NULL)
#define g_dataset_set_data_full(l,k,d,f)	g_dataset_id_set_data_full((l),quark_from_string(k),(d),(f))
#define g_dataset_get_data(l,k)			g_dataset_id_get_data((l),quark_from_string(k))			//IWiłłg_quark_try_string()gpĂAłquark_from_string()gp鎖ɂBg_quark_try_string()NULLԂ悤ȃP[Xł́ÃNH[N͂܂݂Ȃ,,̕ɑΉf[^o^ł͂AǂɂĂʂNULLɂȂ͂łB҂̈Ⴂ͖ʂȃNH[N̓o^邩ǂłAp̖͑ʂȃNH[N̓o^Ăxᖳ낤B
#define g_dataset_remove_data(l,k)		g_dataset_id_set_data((l),quark_from_string(k),NULL)		//IWiłłg_quark_try_string()gpĂAłquark_from_string()gp鎖ɂBg_quark_try_string()NULLԂ悤ȃP[Xł́ÃNH[N͂܂݂Ȃ,,̕ɑΉf[^o^ł͂AǂɂĂʂNULLɂȂ͂łB҂̈Ⴂ͖ʂȃNH[N̓o^邩ǂłAp̖͑ʂȃNH[N̓o^Ăxᖳ낤B
#define g_dataset_remove_no_notify(l,k)		g_dataset_id_remove_no_notify((l),quark_from_string(k))		//IWiłłg_quark_try_string()gpĂAłquark_from_string()gp鎖ɂBg_quark_try_string()NULLԂ悤ȃP[Xł́ÃNH[N͂܂݂Ȃ,,̕ɑΉf[^o^ł͂AǂɂĂʂNULLɂȂ͂łB҂̈Ⴂ͖ʂȃNH[N̓o^邩ǂłAp̖͑ʂȃNH[N̓o^Ăxᖳ낤B
void g_dataset_foreach(const void* dataset_location, void (*func)(/*GQuark*/int key_id, void* data, void* user_data), void* user_data);
void g_dataset_destroy(const void* dataset_location);
#ifdef	__cplusplus
}//extern "C"
#endif//__cplusplus
#endif//__G_DATASET_H__
