/*
 *	garray.c
 *
 *	Arrays - arrays of arbitrary elements which grow automatically as elements are added
 *
 *	* Mon Apr 18 21:50:41 JST 2016 Naoyuki Sawa
 *	- 1st [XB
 *	- GLibArrays(http://developer.gnome.org/glib/stable/glib-Arrays.html)Qlɂ܂B
 *	  ֐dl̓IWiłƓłA͓ƎŁAxeʍ팸D悵܂B
 *	* Tue Apr 19 21:31:14 JST 2016 Naoyuki Sawa
 *	- GPtrArray(https://developer.gnome.org/glib/stable/glib-Pointer-Arrays.html)ƁA
 *	  GByteArray(https://developer.gnome.org/glib/stable/glib-Byte-Arrays.html)ǉ܂B
 *	  ֐dl̓IWiłƓłA͓ƎŁAxeʍ팸D悵܂B
 *	* Wed Apr 20 10:51:26 JST 2016 Naoyuki Sawa
 *	- g_array_set_clear_func()ɏǉAvf폜֐(AvP[V`)Ƃfree֐̃AhXw肳ꂽꍇ̓G[~悤ɂ܂B
 *	  Ⴆ΁Aȉ̂悤ȌĂяo̓oOłAo邽߂łB
 *	  void test() {
 *	    GPtrArray* array = g_ptr_array_new_with_free_func(free);
 *	    g_ptr_array_add(array, strdup("FOO"));
 *	    g_ptr_array_unref(array);		ňُ퓮ƂȂB
 *	  }
 *	  ȂȂ΁Astrdup()̌Ăяo'gc/leak_detector.h'̃}N֐`ɂGC_debug_strdup()ɒu܂A
 *	  g_ptr_array_new_with_free_func()Ɉnfree͊֐Ăяo`ł͂Ȃ̂Ń}N֐̒uΏۂƂ͂Ȃ炸AGC_debug_free̊֐AhXł͂Ȃ{free̊֐AhXɂȂĂ܂łB
 *	  ʂƂāAGC_debug_strdup()Ŋmۂ{free()ŊJ悤ƂĂ܂Aُ퓮ƂȂ܂B
 *	- Ă̈́A'gc/leak_detector.h'̃}N֐`āA}N֐ł͂ȂV{łu悤ɂĂ܂łA͓܂B
 *	  'gc/leak_detector.h'CN[h'gc/gc.h'A}N֐ɒǉ̈GC_EXTRASnĂAV{Œu}NɏƂꂪoȂȂ邩łB
 *	- d̂ŁAAvP[VɓߓIȉĂ͂߂āAAvP[VL̂悤ȃR[hĂ܂ɑG[~Čo@鎖ɂ܂B
 *	  ŃG[~ꍇAAvP[VOq̂悤ȏsĂ\̂ŁAToĈȉ̂悤ɕύXĉB
 *	  static void user_free(void* ptr) { free(ptr);//̓}N֐ƂĒuB }
 *	  void test() {
 *	    GPtrArray* array = g_ptr_array_new_with_free_func(user_free);
 *	    g_ptr_array_add(array, strdup("FOO"));
 *	    g_ptr_array_unref(array);
 *	  }
 *	* Tue May 24 23:59:14 JST 2016 Naoyuki Sawa
 *	- GRealArray\̂́Aalloc_bytestB[helt_sizetB[h̏ւ܂B
 *	  gstring.hW[GString\̂́Astr,len,allocated_len̕тɍ킹邽߂łB
 *	- garray.cW[́AGRealArray\̂alloc_bytestB[helt_sizetB[h̏ɈˑĂȂ̂ŁA̕ύXɂe͗L܂B
 *	  AvP[V̊ϓ_AXGRealArray\̂alloc_bytestB[helt_sizetB[h͔ĴŁA̕ύXɂe͗L܂B
 *	* Sat Jun 25 21:55:36 JST 2016 Naoyuki Sawa
 *	- _g_array_index()ւindexwA܂ł(len)܂łĂ܂łA(len)܂ŋ悤ɕύX܂B
 *	  ύXŔAz̖̃AhX擾L܂A܂ł̏̂܂܂ł́u&g_array_index(a,int,a->len)v̂悤Ɏw肵ɃAT[gĂ܂ĂłB
 *	  ύX́AL̎wAT[gɓ삷悤ɂȂ܂B
 *	  Az̖ɑ΂Ď擾ėǂ̂͂܂łAhXłAl擾Ɨ\oȂɂȂ鎖ɒӂĉB
 *	  AGLib̃IWił̎ł͌Xindex͈̔͂ĂȂ̂ŁA̕ύXɂăIWiłS鎖͗L܂B
 */
#include "clip.h"
/*****************************************************************************
 *	GArray
 *****************************************************************************/
//GRealArray.array_type
#define ARRAY_TYPE_G_ARRAY		0
#define ARRAY_TYPE_G_PTR_ARRAY		1
#define ARRAY_TYPE_G_BYTE_ARRAY		2
/*****************************************************************************
 *	\
 *****************************************************************************/
typedef struct _GRealArray {
//public:
	char*		data;				//A pointer to the element data. The data may be moved as elements are added to the GArray.	GArray.data		GPtrArray.pdata	GByteArray.data	GString.str
	int		len;				//The number of elements in the GArray not including the possible terminating zero element.	GArray.len		GPtrArray.len		GByteArray.len	GString.len
//private:																											GString.allocated_len
	int		alloc_bytes;			//mۍς݃̃oCgB	vfł͂ȂɒӂB
	int		elt_size;			//vf̃oCgB
//sv	unsigned	zero_terminated		:1;	ˏɃ[I[鎖ɂ̂ł̃tB[h͕svɂȂ܂B[I[svłꍇ͏eʂ̖ʂ邪ĂяoӎKv͗L܂B
//sv	unsigned	clear			:1;	g_array_set_size()ŊgvfɃ[NA鎖ɂ̂ł̃tB[h͕svɂȂ܂B[NAsvłꍇ͏̖ʂ邪ĂяoӎKv͗L܂B
	unsigned short	ref_count;			//QƃJEgB\[Xł32rbglAł16rbglɕύXăߖ񂷂鎖ɂBʂ̎gŎQƃJEg(2^16)ȏɂȂ鎖͂܂Ǝv̂ŁAŏ[ƎvB
	unsigned short	array_type;			//z̎ށBARRAY_TYPE_G_ARRAY,,ARRAY_TYPE_G_PTR_ARRAY,,ARRAY_TYPE_G_BYTE_ARRAYB2016/04/20݂g_array_on_remove_element()ŎQƂĂBAz̎ނɂēς鏈ǉꍇ́ÃtB[hQƂB
	void		(*clear_func)(void* data);	//vf폜֐(AvP[V`)Bg_array_set_clear_func(),,g_ptr_array_set_free_func()ɂăZbgBg_array_on_remove_element()oRŌĂяoBڌĂяoȂŔAGArrayȂΗvf̃AhXƂČĂяoAGPtrArrayȂΗvf̒lƂČĂяoKvL邩łBg_array_on_remove_element()̈ႢzB
} GRealArray;
/*****************************************************************************
 *	[J֐
 *****************************************************************************/
//KvȃoCgAۂɊmۂoCg߂B
//ۂɊmۂoCǵAKvȃoCgȏ,,ŏ(2^N)ƂB
static int g_array_pow2_alloc_bytes(int want_alloc) {
	int actual_alloc = 1;	//ۂɊmۂoCg̍ŏlłBƑ傫Ȓln߂Ă\܂B\[Xł16ƂȂĂ܂ȈӖ̂lł͂ȂƎv܂B̕pɂȍĊ蓖Ăɂ鐫\ቺɂȂ鎖͏ȂƎv̂œł͒P1Ƃ܂B
	while((unsigned)actual_alloc < (unsigned)want_alloc) {
		if(!(actual_alloc <<= 1)) { DIE(); }	//want_alloc傫߂B
	}
	return actual_alloc;
}
/*--------------------------------------------------------------------------*/
//((݂̗vf)+(len)+([I[))̃mۂB
static GRealArray* g_array_maybe_expand(GRealArray* rarray, int len) {
	int new_alloc_bytes;
	if(len < 0) { DIE(); }
	//Kvȃ̃oCg߂B
	new_alloc_bytes = rarray->elt_size * (rarray->len + len + 1/*[I[*/);
	//Kvȃ̃oCgAmۍς݃̃oCg傫΁c
	if((unsigned)new_alloc_bytes > (unsigned)rarray->alloc_bytes) {
		//KvȃoCgAۂɊmۂoCg߂B
		new_alloc_bytes = g_array_pow2_alloc_bytes(new_alloc_bytes);
		//m,,gB
		rarray->data = realloc(rarray->data, new_alloc_bytes);
		if(!rarray->data) { DIE(); }	//s
		//Vmۂvf[NAB
		memset(&rarray->data[rarray->alloc_bytes], 0, (new_alloc_bytes - rarray->alloc_bytes));
		//mۍς݃̃oCgi[B
		rarray->alloc_bytes = new_alloc_bytes;
	}
	return rarray;
}
/*--------------------------------------------------------------------------*/
//mۍς݃̔𒴂镔]Ȃ΁AkB
// - \[X̎ł́AUmۂꂽ́Az폜܂ŊJȂ悤łB
//   Avf̑傫Auvfɒ[ɑ㌸鎖ꍇAʂȃԑ݂Ă܂肪܂B
//   L̖邽߂ɁAł́Ag_array_remove_`()sɁAzmۍς݃̔𒴂閳ʂĂAk鎖ɂ܂B
// - ̕ύXɂ镾QƂāAg_array_sized_new()gĈӐ}I(Ԃ)ʂȃ\񂵂z쐬ꍇA̒g_array_remove_`()ĂяoƁA\񂵂kĂ܂܂B
//   ȂĂ쌋ʂɂ͖L܂񂪁A\ቺN\L܂B
//   ۂɂ́Â悤ȎNP[X͏ȂƎv܂B
//   g_array_sized_new()gĈӐ}I(Ԃ)ʂȃ\񂵂z쐬ꍇA̒g_array_remove_`()Ăяo͏ȂƎvłB
//   g_array_sized_new()gꍇǍɍśAAIg_array_append_`()ł鎖قƂǂƎv܂B
//   g_array_maybe_reduce()Ăяôg_array_remove_`(),y,(ԐړI)g_array_set_size()łAg_array_append_`()ĂяoĂk鑀͍s܂B
static GRealArray* g_array_maybe_reduce(GRealArray* rarray) {
	int new_alloc_bytes;
	//Kvȃ̃oCg߂B
	new_alloc_bytes = rarray->elt_size * (rarray->len + 1/*[I[*/);
	//KvȃoCgAۂɊmۂoCg߂B
	new_alloc_bytes = g_array_pow2_alloc_bytes(new_alloc_bytes);
	//mۍς݃̃oCgAۂɊmۂoCg2{/**/𒴉߂Ăc
	if((unsigned)rarray->alloc_bytes > (unsigned)(new_alloc_bytes << 1/**/)) {
		//kB
		rarray->data = realloc(rarray->data, new_alloc_bytes);
		if(!rarray->data) { DIE(); }	//krealloc()s鎖͖͂B
		//mۍς݃̃oCgi[B
		rarray->alloc_bytes = new_alloc_bytes;
	}
	return rarray;
}
/*--------------------------------------------------------------------------*/
//vf폜鎞ɌĂяo[J֐B
static void g_array_on_remove_element(GRealArray* rarray, int index) {
	//vf폜֐(AvP[V`)ZbgĂc
	if(rarray->clear_func) {
		//vf̃AhX擾B
		void* data = &rarray->data[rarray->elt_size * index];
		//z̎ނɂāc
		switch(rarray->array_type) {
		default:DIE();	//oO
		case ARRAY_TYPE_G_ARRAY:
			//GArrayȂ΁Avf̃AhXƂėvf폜֐(AvP[V`)ŝŁAdata͂̂܂܂ŗǂB
			/** no job **/
			break;
		case ARRAY_TYPE_G_PTR_ARRAY:
			//GPtrArrayȂ΁Avf̒lƂėvf폜֐(AvP[V`)ŝŁAdatawloB
			data = *(void**)data;
			break;
	    //	case ARRAY_TYPE_G_BYTE_ARRAY:
	    //		//GByteArrayȂ΁Ararray->clear_funcNULLɂȂ鎖͖͂łBNULLȂdefault:߂ŃG[~B
		}
		//vf̃AhX,,vf̒lƂāAvf폜֐(AvP[V`)sB
		(*rarray->clear_func)(data);
	}
}
/*****************************************************************************
 *	O[o֐
 *****************************************************************************/
//Creates a new GArray with a reference count of 1.
//Parameters
//		zero_terminated		TRUE if the array should have an extra element at the end which is set to 0.
//		clear			TRUE if GArray elements should be automatically cleared to 0 when they are allocated.
//		element_size		The size of each element in bytes.
//Returns
//		The new GArray.
GArray* g_array_new(int zero_terminated, int clear, int element_size) {
	return g_array_sized_new(zero_terminated, clear, element_size, 0);
}
/*--------------------------------------------------------------------------*/
//Creates a new GArray with reserved_size elements preallocated and a reference count of 1.
//This avoids frequent reallocation, if you are going to add many elements to the array.
//Note however that the size of the array is still 0.
//Parameters
//		zero_terminated		TRUE if the array should have an extra element at the end with all bits cleared.	˓ł͎͂̈QƂ܂B
//		clear			TRUE if all bits in the array should be cleared to 0 on allocation.			˓ł͎͂̈QƂ܂B
//		element_size		Size of each element in the array.
//		reserved_size		Number of elements preallocated.
//Returns
//		The new GArray.
GArray* g_array_sized_new(int zero_terminated, int clear, int element_size, int reserved_size) {
	GRealArray* rarray;
	if((element_size < 0) /*|| (reserved_size < 0)*/) { DIE(); }	//(reserved_size<0)g_array_maybe_expand()Ō̂łł͌svłB
	//\̂̃mۂB
	rarray = calloc(1, sizeof(GRealArray));		//elt_sizeȊÕtB[h0ɏ邽߂ɁAmalloc()łȂcalloc()K{łB
	if(!rarray) { DIE(); }
	//\̂̃tB[hB
	rarray->elt_size   = element_size;
	rarray->ref_count  = 1;
//sv	rarray->array_type = ARRAY_TYPE_G_ARRAY;	//z̎ނi[B
	//mۂB
	return (GArray*)g_array_maybe_expand(rarray, reserved_size);
}
/*--------------------------------------------------------------------------*/
//Atomically increments the reference count of array by one.
//This function is MT-safe and may be called from any thread.									˓ł̓XbhZ[tł͂܂B̃XbhQƂ鎖͖ƎvłBۂ̏g_array_ref()/g_array_unref()XbhZ[tɂĂ̊֐XbhZ[tłȂ΂܂Ӗ͖Ǝv܂B
//Parameters
//		array			A GArray.
//Returns
//		The passed in GArray.
GArray* g_array_ref(GArray* array) {
	GRealArray* rarray = (GRealArray*)array;
	if(!rarray->ref_count || (rarray->ref_count > (USHRT_MAX-1))) { DIE(); }
	//QƃJEg𑝂₷B
	rarray->ref_count++;
	return (GArray*)rarray;
}
/*--------------------------------------------------------------------------*/
//Atomically decrements the reference count of array by one.
//If the reference count drops to 0, all memory allocated by the array is released.
//This function is MT-safe and may be called from any thread.									˓ł̓XbhZ[tł͂܂B̃XbhQƂ鎖͖ƎvłBۂ̏g_array_ref()/g_array_unref()XbhZ[tɂĂ̊֐XbhZ[tłȂ΂܂Ӗ͖Ǝv܂B
//Parameters
//		array			A GArray.
void g_array_unref(GArray* array) {
	GRealArray* rarray = (GRealArray*)array;
	if(!rarray->ref_count /*|| (rarray->ref_count > USHRT_MAX)*/) { DIE(); }
	//Ō̎QƂłȂ΁c
	if(rarray->ref_count != 1) {
		//QƃJEg炷B
		rarray->ref_count--;
	//Ō̎QƂȂ΁c
	// - ŎQƃJEg炳Ȃ悤ӂB
	//   Ō̎QƃJEg炷g_array_free()sB
	} else {
		//\̂ƃf[^̃JB
		g_array_free((GArray*)rarray, 1);
	}
}
/*--------------------------------------------------------------------------*/
//Gets the size of the elements in array.
//Returns
//		Size of each element, in bytes.
int g_array_get_element_size(GArray* array) {
	GRealArray* rarray = (GRealArray*)array;
	return rarray->elt_size;
}
/*--------------------------------------------------------------------------*/
//Adds len elements onto the end of the array.
//Parameters
//		array			A GArray.
//		data			A pointer to the elements to append to the end of the array.	[not nullable]
//		len			The number of elements to append.
//Returns
//		The GArray.
GArray* g_array_append_vals(GArray* array, const void* data, int len) {
	return g_array_insert_vals(array, array->len, data, len);
}
/*--------------------------------------------------------------------------*/
//Adds len elements onto the start of the array.
//This operation is slower than g_array_append_vals() since the existing elements in the array have to be moved to make space for the new elements.
//Parameters
//		array			A GArray.
//		data			A pointer to the elements to prepend to the start of the array.	[not nullable]
//		len			The number of elements to prepend.
//Returns
//		The GArray.
GArray* g_array_prepend_vals(GArray* array, const void* data, int len) {
	return g_array_insert_vals(array, 0, data, len);
}
/*--------------------------------------------------------------------------*/
//Inserts len elements into a GArray at the given index.
//Parameters
//		array			A GArray.
//		index			The index to place the elements at.
//		data			A pointer to the elements to insert.	[not nullable]
//		len			The number of elements to insert.
//Returns
//		The GArray.
GArray* g_array_insert_vals(GArray* array, int index, const void* data, int len) {
	GRealArray* rarray = (GRealArray*)array;
	if((unsigned)index > (unsigned)rarray->len) { DIE(); }
	//KvȃmۂB
	g_array_maybe_expand(rarray, len);
	//̃f[^ւ炷B
	// - (index==rarray->len)ꍇ_~[ƂȂSłB
	memmove(&rarray->data[rarray->elt_size * (index + len)],
	        &rarray->data[rarray->elt_size * index],
	        (rarray->elt_size * (rarray->len - index)));
	//Vf[^i[B
	memcpy(&rarray->data[rarray->elt_size * index], data, (rarray->elt_size * len));
	//vf𑝂₷B
	rarray->len += len;
	return (GArray*)rarray;
}
/*--------------------------------------------------------------------------*/
//Removes the element at the given index from a GArray.
//The following elements are moved down one place.
//Parameters
//		array			A GArray.
//		index			The index of the element to remove.
//Returns
//		The GArray.
GArray* g_array_remove_index(GArray* array, int index) {
	return g_array_remove_range(array, index, 1);
}
/*--------------------------------------------------------------------------*/
//Removes the element at the given index from a GArray.
//The last element in the array is used to fill in the space, so this function does not preserve the order of the GArray.
//But it is faster than g_array_remove_index().
//Parameters
//		array			A GArray.
//		index			The index of the element to remove.
//Returns
//		The GArray.
GArray* g_array_remove_index_fast(GArray* array, int index) {
	GRealArray* rarray = (GRealArray*)array;
	if((unsigned)index >= (unsigned)rarray->len) { DIE(); }
	//vf폜鎞ɌĂяo[J֐sB
	g_array_on_remove_element(rarray, index);
	//폜vf̈ʒuɁAŌ̗vfRs[B
	// - (index==(rarray->len-1))ꍇ_~[ƂȂSłB
	memcpy(&rarray->data[rarray->elt_size * index],
	       &rarray->data[rarray->elt_size * (rarray->len - 1)],
	       rarray->elt_size);
	//vf炷B
	rarray->len--;
	//󂢂[NAB
	memset(&rarray->data[rarray->elt_size * rarray->len], 0, rarray->elt_size);
	//]ȃJB
	return (GArray*)g_array_maybe_reduce(rarray);
}
/*--------------------------------------------------------------------------*/
//Removes the given number of elements starting at the given index from a GArray.
//The following elements are moved to close the gap.
//Parameters
//		array			a GArray
//		index			the index of the first element to remove
//		length			the number of elements to remove
//Returns
//		The GArray.
GArray* g_array_remove_range(GArray* array, int index, int length) {
	GRealArray* rarray = (GRealArray*)array;
	int i;
	if(((unsigned)(index         ) > (unsigned)rarray->len) ||
	   ((unsigned)(index + length) > (unsigned)rarray->len) || (length < 0)) { DIE(); }
	//vf폜鎞ɌĂяo[J֐sB
	for(i = 0; i < length; i++) {
		g_array_on_remove_element(rarray, index + i);
	}
	//̃f[^Oւ炷B
	memmove(&rarray->data[rarray->elt_size * index],
	        &rarray->data[rarray->elt_size * (index + length)],
	        rarray->elt_size * (rarray->len - (index + length)));
	//vf炷B
	rarray->len -= length;
	//󂢂[NAB
	memset(&rarray->data[rarray->elt_size * rarray->len], 0, (rarray->elt_size * length));
	//]ȃJB
	return (GArray*)g_array_maybe_reduce(rarray);
}
/*--------------------------------------------------------------------------*/
//Sorts a GArray using compare_func which should be a qsort()-style comparison function (returns less than zero for first arg is less than second arg, zero for equal, greater zero if first arg is greater than second arg).
//This is guaranteed to be a stable sort since version 2.32.									˓ł͈\[gł͂܂B
//Parameters
//		array			A GArray.
//		compare_func		Comparison function.
void g_array_sort(GArray* array, int (*compare_func)(const void* a, const void* b)) {
	g_array_sort_with_data(array, (int (*)(const void*,const void*,void*))compare_func, NULL);
}
/*--------------------------------------------------------------------------*/
//Like g_array_sort(), but the comparison function receives an extra user data argument.
//This is guaranteed to be a stable sort since version 2.32.									˓ł͈\[gł͂܂B
//There used to be a comment here about making the sort stable by using the addresses of the elements in the comparison function.
//This did not actually work, so any such code should be removed.
//		array			A GArray.
//		compare_func		Comparison function.
//		user_data		Data to pass to compare_func.
void g_array_sort_with_data(GArray* array, int (*compare_func)(const void* a, const void* b, void* user_data), void* user_data) {
	GRealArray* rarray = (GRealArray*)array;
	qsort_r(rarray->data, rarray->len, rarray->elt_size, compare_func, user_data);
}
/*--------------------------------------------------------------------------*/
//Sets the size of the array, expanding it if necessary.
//If the array was created with clear_ set to TRUE, the new elements are set to 0.
//Parameters
//		array			A GArray.
//		length			The new size of the GArray.
//Returns
//		The GArray.
GArray* g_array_set_size(GArray* array, int length) {
	GRealArray* rarray = (GRealArray*)array;
	if(length < 0) { DIE(); }
	//Ȃ΁c
	if(length > rarray->len) {
		g_array_maybe_expand(rarray, length - rarray->len);
		rarray->len = length;
	//,,ωȂȂ΁c
	} else {
		g_array_remove_range((GArray*)rarray, length, rarray->len - length);	//(length==rarray->len)ꍇ̏ĂяoĈSłB
	}
	return (GArray*)rarray;
}
/*--------------------------------------------------------------------------*/
//Sets a function to clear an element of array.
//The clear_func will be called when an element in the array data segment is removed and when the array is freed and data segment is deallocated as well.
//Note that in contrast with other uses of GDestroyNotify functions, clear_func is expected to clear the contents of the array element it is given, but not free the element itself.
//Parameters
//		array			A GArray.
//		clear_func		A function to clear an element of array.
void g_array_set_clear_func(GArray* array, void (*clear_func)(void* data)) {
	GRealArray* rarray = (GRealArray*)array;
//{{2016/04/20ǉ:g_array_set_clear_func()ɏǉAvf폜֐(AvP[V`)Ƃfree֐̃AhXw肳ꂽꍇ̓G[~悤ɂ܂B
#ifdef  GC_LEAK_DETECTOR_H
	// * Wed Apr 20 10:51:26 JST 2016 Naoyuki Sawa
	// - g_array_set_clear_func()ɏǉAvf폜֐(AvP[V`)Ƃfree֐̃AhXw肳ꂽꍇ̓G[~悤ɂ܂B
	//   Ⴆ΁Aȉ̂悤ȌĂяo̓oOłAo邽߂łB
	//   void test() {
	//     GPtrArray* array = g_ptr_array_new_with_free_func(free);
	//     g_ptr_array_add(array, strdup("FOO"));
	//     g_ptr_array_unref(array);	ňُ퓮ƂȂB
	//   }
	//   ȂȂ΁Astrdup()̌Ăяo'gc/leak_detector.h'̃}N֐`ɂGC_debug_strdup()ɒu܂A
	//   g_ptr_array_new_with_free_func()Ɉnfree͊֐Ăяo`ł͂Ȃ̂Ń}N֐̒uΏۂƂ͂Ȃ炸AGC_debug_free̊֐AhXł͂Ȃ{free̊֐AhXɂȂĂ܂łB
	//   ʂƂāAGC_debug_strdup()Ŋmۂ{free()ŊJ悤ƂĂ܂Aُ퓮ƂȂ܂B
	// - Ă̈́A'gc/leak_detector.h'̃}N֐`āA}N֐ł͂ȂV{łu悤ɂĂ܂łA͓܂B
	//   'gc/leak_detector.h'CN[h'gc/gc.h'A}N֐ɒǉ̈GC_EXTRASnĂAV{Œu}NɏƂꂪoȂȂ邩łB
	// - d̂ŁAAvP[VɓߓIȉĂ͂߂āAAvP[VL̂悤ȃR[hĂ܂ɑG[~Čo@鎖ɂ܂B
	//   ŃG[~ꍇAAvP[VOq̂悤ȏsĂ\̂ŁAToĈȉ̂悤ɕύXĉB
	//   static void user_free(void* ptr) { free(ptr);//̓}N֐ƂĒuB }
	//   void test() {
	//     GPtrArray* array = g_ptr_array_new_with_free_func(user_free);
	//     g_ptr_array_add(array, strdup("FOO"));
	//     g_ptr_array_unref(array);
	//   }
	if(clear_func == free) { DIE(); }
#endif//GC_LEAK_DETECTOR_H
//}}2016/04/20ǉ:g_array_set_clear_func()ɏǉAvf폜֐(AvP[V`)Ƃfree֐̃AhXw肳ꂽꍇ̓G[~悤ɂ܂B
	rarray->clear_func = clear_func;
}
/*--------------------------------------------------------------------------*/
//Frees the memory allocated for the GArray.
//If free_segment is TRUE it frees the memory block holding the elements as well and also each element if array has a element_free_func set.
//Pass FALSE if you want to free the GArray wrapper but preserve the underlying array for use elsewhere.
//If the reference count of array is greater than one, the GArray wrapper is preserved but the size of array will be set to zero.
//Parameters
//		array			A GArray.
//		free_segment		If TRUE the actual element data is freed as well.
//Returns
//		The element data if free_segment is FALSE, otherwise NULL.
//		The element data should be freed using g_free().
char* g_array_free(GArray* array, int free_segment) {
	GRealArray* rarray = (GRealArray*)array;
	char* segment;
	if(!rarray->ref_count /*|| (rarray->ref_count > USHRT_MAX)*/) { DIE(); }
	//߂lf[^̃ƂĂB
	segment = rarray->data;
	//f[^̃JȂ΁c
	if(free_segment) {
		int i;
		//vf폜鎞ɌĂяo[J֐sB
		for(i = 0; i < rarray->len; i++) {
			g_array_on_remove_element(rarray, i);
		}
		//f[^̃JB
		free(rarray->data);
		//߂lNULLɕύXB
		segment = NULL;
	}
	//ɂĂAȉ̃tB[h̓NAĂB
	// - QƂcĂꍇ́A̍\̂A'f[^̃mۂĂȂvf0̔z'ƂĎgp邽߂łB
	// - ȀԂł́A[I[݂ȂɒӂĂB
	//   cĂQƂoRg_array_append_val()ĂяoāA߂ăf[^̃mۂ܂ŁȀԂ̂܂܂łB
	//   ʏ́AcĂQƂf[^QƂɁAg_array_free(),,g_array_unref()ĂяoƎv܂Af[^QƂ悤Ƃꍇ́A[I[݂ȂƂقL܂B
	//   ̋́A\[X(glib-2.48.0)łłB
	rarray->data        = NULL;
	rarray->len         = 0;
	rarray->alloc_bytes = 0;
	//QƃJEg炵AŌ̎QƂȂ΁c
	if(!--rarray->ref_count) {
		//\̂̃JB
		free(rarray);
	}
	return segment;
}
/*****************************************************************************
 *	J֐
 *****************************************************************************/
//\[Xłg_array_index()̓}Nō쐬Ă邪Ał̓}NƊ֐gč쐬鎖ɂB
//֐gɂŔAg_array_index()͎gppx̂ŁAg_array_index()index͈̔͌sŁAoOoo@ƎvłB
void* _g_array_index(GArray* array, int type_size, int index) {
	GRealArray* rarray = (GRealArray*)array;
	if((type_size != rarray->elt_size) ||				//ԂAg_array_index()}N̑Ɏw肵^ԈĂB
//{{2016/06/25ύX:_g_array_index()ւindexwA܂ł(len)܂łĂ܂łA(len)܂ŋ悤ɕύX܂B
//	  ((unsigned)index >= (unsigned)rarray->len)) { DIE(); }	//g_array_index()}N̑OɎw肵CfNXԈĂB
//2016/06/25ύX:_g_array_index()ւindexwA܂ł(len)܂łĂ܂łA(len)܂ŋ悤ɕύX܂B
	  ((unsigned)index >  (unsigned)rarray->len)) { DIE(); }	//g_array_index()}N̑OɎw肵CfNXԈĂB
//}}2016/06/25ύX:_g_array_index()ւindexwA܂ł(len)܂łĂ܂łA(len)܂ŋ悤ɕύX܂B
	return &rarray->data[type_size * index];
}
/*****************************************************************************
 *	GPtrArray
 *****************************************************************************/
/*****************************************************************************
 *	O[o֐
 *****************************************************************************/
//Creates a new GPtrArray with a reference count of 1.
//Returns
//		The new GPtrArray.
GPtrArray* g_ptr_array_new() {
	return g_ptr_array_new_full(0, NULL);
}
/*--------------------------------------------------------------------------*/
//Creates a new GPtrArray with reserved_size pointers preallocated and a reference count of 1.
//This avoids frequent reallocation, if you are going to add many pointers to the array.
//Note however that the size of the array is still 0.
//Parameters
//		reserved_size		Number of pointers preallocated.
//Returns
//		The new GPtrArray.
GPtrArray* g_ptr_array_sized_new(int reserved_size) {
	return g_ptr_array_new_full(reserved_size, NULL);
}
/*--------------------------------------------------------------------------*/
//Creates a new GPtrArray with a reference count of 1 and use element_free_func for freeing each element when the array is destroyed either via g_ptr_array_unref(), when g_ptr_array_free() is called with free_segment set to TRUE or when removing elements.
//Parameters
//		element_free_func	A function to free elements with destroy array or NULL.		[allow-none]
//Returns
//		The new GPtrArray.
GPtrArray* g_ptr_array_new_with_free_func(void (*element_free_func)(void* data)) {
	return g_ptr_array_new_full(0, element_free_func);
}
/*--------------------------------------------------------------------------*/
//Creates a new GPtrArray with reserved_size pointers preallocated and a reference count of 1.
//This avoids frequent reallocation, if you are going to add many pointers to the array.
//Note however that the size of the array is still 0.
//It also set element_free_func for freeing each element when the array is destroyed either via g_ptr_array_unref(), when g_ptr_array_free() is called with free_segment set to TRUE or when removing elements.
//Parameters
//		reserved_size		Number of pointers preallocated.
//		element_free_func	A function to free elements with destroy array or NULL.		[allow-none]
//Returns
//		The new GPtrArray.
GPtrArray* g_ptr_array_new_full(int reserved_size, void (*element_free_func)(void* data)) {
	GPtrArray* array = (GPtrArray*)g_array_sized_new(0, 0, sizeof(void*), reserved_size);
	((GRealArray*)array)->array_type = ARRAY_TYPE_G_PTR_ARRAY;	//z̎ނi[B
	g_ptr_array_set_free_func(array, element_free_func);
	return array;
}
/*--------------------------------------------------------------------------*/
//Sets a function for freeing each element when array is destroyed either via g_ptr_array_unref(), when g_ptr_array_free() is called with free_segment set to TRUE or when removing elements.
//Parameters
//		array			A GPtrArray.
//		element_free_func	A function to free elements with destroy array or NULL.		[allow-none]
void g_ptr_array_set_free_func(GPtrArray* array, void (*element_free_func)(void* data)) {
	g_array_set_clear_func((GArray*)array, element_free_func);
}
/*--------------------------------------------------------------------------*/
//Atomically increments the reference count of array by one.
//This function is thread-safe and may be called from any thread.								˓ł̓XbhZ[tł͂܂B̃XbhQƂ鎖͖ƎvłBۂ̏g_array_ref()/g_array_unref()XbhZ[tɂĂ̊֐XbhZ[tłȂ΂܂Ӗ͖Ǝv܂B
//Parameters
//		array			A GPtrArray.
//Returns
//		The passed in GPtrArray.
GPtrArray* g_ptr_array_ref(GPtrArray* array) {
	return (GPtrArray*)g_array_ref((GArray*)array);
}
/*--------------------------------------------------------------------------*/
//Atomically decrements the reference count of array by one.
//If the reference count drops to 0, the effect is the same as calling g_ptr_array_free() with free_segment set to TRUE.
//This function is MT-safe and may be called from any thread.
//Parameters
//		array			A GPtrArray.
void g_ptr_array_unref(GPtrArray* array) {
	g_array_unref((GArray*)array);
}
/*--------------------------------------------------------------------------*/
//Adds a pointer to the end of the pointer array.
//The array will grow in size automatically if necessary.
//Parameters
//		array			A GPtrArray.
//		data			The pointer to add.
void g_ptr_array_add(GPtrArray* array, void* data) {
	g_array_append_val((GArray*)array, data);
}
/*--------------------------------------------------------------------------*/
//Inserts an element into the pointer array at the given index.
//The array will grow in size automatically if necessary.
//Parameters
//		array			A GPtrArray.
//		index			The index to place the new element at, or -1 to append.					//g_array_insert_`()index-1woȂAg_ptr_array_insert()index-1woƂGLib̊֐dlłB̂dlȂ̂svcȂ̂łAGLib̊֐dlɏ]Ăɂ܂B
//		data			The pointer to add.
void g_ptr_array_insert(GPtrArray* array, int index, void* data) {
	if(index == -1) {
		g_array_append_val((GArray*)array, data);
	} else {
		g_array_insert_val((GArray*)array, index, data);
	}
}
/*--------------------------------------------------------------------------*/
//Removes the first occurrence of the given pointer from the pointer array.
//The following elements are moved down one place.
//If array has a non-NULL GDestroyNotify function it is called for the removed element.
//It returns TRUE if the pointer was removed, or FALSE if the pointer was not found.
//Parameters
//		array			A GPtrArray.
//		data			The pointer to remove.
//Returns
//		TRUE if the pointer is removed, FALSE if the pointer is not found in the array.
int g_ptr_array_remove(GPtrArray* array, void* data) {
	int i;
	for(i = 0; i < array->len; i++) {
		if(array->pdata[i] == data) {
			g_ptr_array_remove_index(array, i);
			return 1;
		}
	}
	return 0;
}
/*--------------------------------------------------------------------------*/
//Removes the pointer at the given index from the pointer array.
//The following elements are moved down one place.
//If array has a non-NULL GDestroyNotify function it is called for the removed element.
//Parameters
//		array			A GPtrArray.
//		index			The index of the pointer to remove.
//Returns
//		The pointer which was removed.
void* g_ptr_array_remove_index(GPtrArray* array, int index) {
	void* result = g_ptr_array_index((GArray*)array, index);
	g_array_remove_index((GArray*)array, index);
	return result;
}
/*--------------------------------------------------------------------------*/
//Removes the first occurrence of the given pointer from the pointer array.
//The last element in the array is used to fill in the space, so this function does not preserve the order of the array.
//But it is faster than g_ptr_array_remove().
//If array has a non-NULL GDestroyNotify function it is called for the removed element.
//It returns TRUE if the pointer was removed, or FALSE if the pointer was not found.
//Parameters
//		array			A GPtrArray.
//		data			The pointer to remove.
//Returns
//		TRUE if the pointer was found in the array.
int g_ptr_array_remove_fast(GPtrArray* array, void* data) {
	int i;
	for(i = 0; i < array->len; i++) {
		if(array->pdata[i] == data) {
			g_ptr_array_remove_index_fast(array, i);
			return 1;
		}
	}
	return 0;
}
/*--------------------------------------------------------------------------*/
//Removes the pointer at the given index from the pointer array.
//The last element in the array is used to fill in the space, so this function does not preserve the order of the array.
//But it is faster than g_ptr_array_remove_index().
//If array has a non-NULL GDestroyNotify function it is called for the removed element.
//Parameters
//		array			A GPtrArray.
//		index			The index of the pointer to remove.
//Returns
//		The pointer which was removed.
void* g_ptr_array_remove_index_fast(GPtrArray* array, int index) {
	void* result = g_ptr_array_index((GArray*)array, index);
	g_array_remove_index_fast((GArray*)array, index);
	return result;
}
/*--------------------------------------------------------------------------*/
//Removes the given number of pointers starting at the given index from a GPtrArray.
//The following elements are moved to close the gap.
//If array has a non-NULL GDestroyNotify function it is called for the removed elements.
//Parameters
//		array			A GPtrArray.
//		index			The index of the first pointer to remove.
//		length			The number of pointers to remove.
//Returns
//		The array.
GPtrArray* g_ptr_array_remove_range(GPtrArray* array, int index, int length) {
	return (GPtrArray*)g_array_remove_range((GArray*)array, index, length);
}
/*--------------------------------------------------------------------------*/
//Sorts the array, using compare_func which should be a qsort()-style comparison function (returns less than zero for first arg is less than second arg, zero for equal, greater than zero if irst arg is greater than second arg).
//Note that the comparison function for g_ptr_array_sort() doesn't take the pointers from the array as arguments, it takes pointers to the pointers in the array.		dv!!r֐ɂ̓|C^n̂ł͂ȂA|C^ւ̃|C^ndlł鎖ɒӂĉBႦ΁A|C^i[z\[gہAr֐Ƃstrcmp()w肷鎖͏o܂B
//This is guaranteed to be a stable sort since version 2.32.									˓ł͈\[gł͂܂B
//Parameters
//		array			A GPtrArray.
//		compare_func		Comparison function.
void g_ptr_array_sort(GPtrArray* array, int (*compare_func)(const void* a, const void* b)) {
	g_array_sort((GArray*)array, compare_func);
}
/*--------------------------------------------------------------------------*/
//Like g_ptr_array_sort(), but the comparison function has an extra user data argument.
//Note that the comparison function for g_ptr_array_sort_with_data() doesn't take the pointers from the array as arguments, it takes pointers to the pointers in the array.	dv!!r֐ɂ̓|C^n̂ł͂ȂA|C^ւ̃|C^ndlł鎖ɒӂĉBႦ΁A|C^i[z\[gہAr֐Ƃstrcmp()w肷鎖͏o܂B
//This is guaranteed to be a stable sort since version 2.32.									˓ł͈\[gł͂܂B
//Parameters
//		array			A GPtrArray.
//		compare_func		Comparison function.
//		user_data		Data to pass to compare_func.
void g_ptr_array_sort_with_data(GPtrArray* array, int (*compare_func)(const void* a, const void* b, void* user_data), void* user_data) {
	g_array_sort_with_data((GArray*)array, compare_func, user_data);
}
/*--------------------------------------------------------------------------*/
//Sets the size of the array.
//When making the array larger, newly-added elements will be set to NULL.
//When making it smaller, if array has a non-NULL GDestroyNotify function then it will be called for the removed elements.
//Parameters
//		array			A GPtrArray.
//		length			The new length of the pointer array.
void g_ptr_array_set_size(GPtrArray* array, int length) {
	g_array_set_size((GArray*)array, length);
}
/*--------------------------------------------------------------------------*/
//Frees the memory allocated for the GPtrArray.
//If free_seg is TRUE it frees the memory block holding the elements as well.
//Pass FALSE if you want to free the GPtrArray wrapper but preserve the underlying array for use elsewhere.
//If the reference count of array is greater than one, the GPtrArray wrapper is preserved but the size of array will be set to zero.
//If array contents point to dynamically-allocated memory, they should be freed separately if free_seg is TRUE and no GDestroyNotify function has been set for array.
//Parameters
//		array			A GPtrArray.
//		free_seg		If TRUE the actual pointer array is freed as well.
//Returns
//		The pointer array if free_seg is FALSE, otherwise NULL.
//		The pointer array should be freed using g_free().
void** g_ptr_array_free(GPtrArray* array, int free_seg) {
	return (void**)g_array_free((GArray*)array, free_seg);
}
/*--------------------------------------------------------------------------*/
//Calls a function for each element of a GPtrArray.
//Parameters
//		array			A GPtrArray.
//		func			The function to call for each array element.
//		user_data		User data to pass to the function.
void g_ptr_array_foreach(GPtrArray* array, void (*func)(void* data, void* user_data), void* user_data) {
	int i;
	for(i = 0; i < array->len; i++) {
		(*func)(array->pdata[i], user_data);
	}
}
/*****************************************************************************
 *	GByteArray
 *****************************************************************************/
/*****************************************************************************
 *	O[o֐
 *****************************************************************************/
//Creates a new GByteArray with a reference count of 1.
//Returns
//		The new GByteArray.	[transfer full]										//[transfer full]Ƃ'Free data after the code is done.'̎ł(https://developer.gnome.org/glib/stable/annotation-glossary.html)BAhttps://developer.gnome.org/glib/stable/glib-Byte-Arrays.html ̐ł͂ǂ[transfer full]̎wɈѐ悤ȋĈŁA܂CɂȂǂm܂Bǂ߂ΒNJ邩͑̒ϒʂłB
GByteArray* g_byte_array_new() {
	return g_byte_array_sized_new(0);
}
/*--------------------------------------------------------------------------*/
//Create byte array containing the data.
//The data will be owned by the array and will be freed with g_free(), i.e. it could be allocated using g_strdup().
//Parameters
//		data			Byte data for the array.	[transfer full][array length=len]
//		len			Length of data.
//Returns
//		A new GByteArray.	[transfer full]
GByteArray* g_byte_array_new_take(uint8_t* data, int len) {
	GRealArray* rarray = (GRealArray*)g_byte_array_new();
	free(rarray->data);
	rarray->data        = data;
	rarray->len         = len;
	rarray->alloc_bytes = len;
	return (GByteArray*)rarray;
}
/*--------------------------------------------------------------------------*/
//Creates a new GByteArray with reserved_size bytes preallocated.
//This avoids frequent reallocation, if you are going to add many bytes to the array.
//Note however that the size of the array is still 0.
//Parameters
//		reserved_size		Number of bytes preallocated.
//Returns
//		The new GByteArray.
GByteArray* g_byte_array_sized_new(int reserved_size) {
	GByteArray* array = (GByteArray*)g_array_sized_new(0, 0, 1, reserved_size);
	((GRealArray*)array)->array_type = ARRAY_TYPE_G_BYTE_ARRAY;	//z̎ނi[B
	return array;
}
/*--------------------------------------------------------------------------*/
//Atomically increments the reference count of array by one.
//This function is thread-safe and may be called from any thread.
//Parameters
//		array			A GByteArray.
//Returns
//		The passed in GByteArray.
GByteArray* g_byte_array_ref(GByteArray* array) {
	return (GByteArray*)g_array_ref((GArray*)array);
}
/*--------------------------------------------------------------------------*/
//Atomically decrements the reference count of array by one.
//If the reference count drops to 0, all memory allocated by the array is released.
//This function is thread-safe and may be called from any thread.
//Parameters
//		array			A GByteArray.
void g_byte_array_unref(GByteArray* array) {
	g_array_unref((GArray*)array);
}
/*--------------------------------------------------------------------------*/
//Adds the given bytes to the end of the GByteArray.
//The array will grow in size automatically if necessary.
//Parameters
//		array			A GByteArray.
//		data			The byte data to be added.
//		len			the number of bytes to add.
//Returns
//		The GByteArray.
GByteArray* g_byte_array_append(GByteArray* array, const uint8_t* data, int len) {
	return (GByteArray*)g_array_append_vals((GArray*)array, data, len);
}
/*--------------------------------------------------------------------------*/
//Adds the given data to the start of the GByteArray.
//The array will grow in size automatically if necessary.
//Parameters
//		array			A GByteArray.
//		data			The byte data to be added.
//		len			The number of bytes to add.
//Returns
//		The GByteArray.
GByteArray* g_byte_array_prepend(GByteArray* array, const uint8_t* data, int len) {
	return (GByteArray*)g_array_prepend_vals((GArray*)array, data, len);
}
/*--------------------------------------------------------------------------*/
//Removes the byte at the given index from a GByteArray.
//The following bytes are moved down one place.
//Parameters
//		array			A GByteArray.
//		index			The index of the byte to remove.
//Returns
//		The GByteArray.
GByteArray* g_byte_array_remove_index(GByteArray* array, int index) {
	return (GByteArray*)g_array_remove_index((GArray*)array, index);
}
/*--------------------------------------------------------------------------*/
//Removes the byte at the given index from a GByteArray.
//The last element in the array is used to fill in the space, so this function does not preserve the order of the GByteArray.
//But it is faster than g_byte_array_remove_index().
//Parameters
//		array			A GByteArray.
//		index			The index of the byte to remove.
//Returns
//		The GByteArray.
GByteArray* g_byte_array_remove_index_fast(GByteArray* array, int index) {
	return (GByteArray*)g_array_remove_index_fast((GArray*)array, index);
}
/*--------------------------------------------------------------------------*/
//Removes the given number of bytes starting at the given index from a GByteArray.
//The following elements are moved to close the gap.
//Parameters
//		array			A GByteArray.
//		index			The index of the first byte to remove.
//		length			The number of bytes to remove.
//Returns
//		The GByteArray.
GByteArray* g_byte_array_remove_range(GByteArray* array, int index, int length) {
	return (GByteArray*)g_array_remove_range((GArray*)array, index, length);
}
/*--------------------------------------------------------------------------*/
//Sorts a byte array, using compare_func which should be a qsort()-style comparison function (returns less than zero for first arg is less than second arg, zero for equal, greater than zero if first arg is greater than second arg).
//If two array elements compare equal, their order in the sorted array is undefined.
//If you want equal elements to keep their order (i.e. you want a stable sort) you can write a comparison function that, if two elements would otherwise compare equal, compares them by their addresses.
//Parameters
//		array			A GByteArray.
//		compare_func		Comparison function.
void g_byte_array_sort(GByteArray* array, int (*compare_func)(const void* a, const void* b)) {
	g_array_sort((GArray*)array, compare_func);
}
/*--------------------------------------------------------------------------*/
//Like g_byte_array_sort(), but the comparison function takes an extra user data argument.
//Parameters
//		array			A GByteArray.
//		compare_func		Comparison function.
//		user_data		data to pass to compare_func.
void g_byte_array_sort_with_data(GByteArray* array, int (*compare_func)(const void* a, const void* b, void* user_data), void* user_data) {
	g_array_sort_with_data((GArray*)array, compare_func, user_data);
}
/*--------------------------------------------------------------------------*/
//Sets the size of the GByteArray, expanding it if necessary.
//Parameters
//		array			A GByteArray
//		length			The new size of the GByteArray
//Returns
//		The GByteArray.
GByteArray* g_byte_array_set_size(GByteArray* array, int length) {
	return (GByteArray*)g_array_set_size((GArray*)array, length);
}
/*--------------------------------------------------------------------------*/
//Frees the memory allocated by the GByteArray.
//If free_segment is TRUE it frees the actual byte data.
//If the reference count of array is greater than one, the GByteArray wrapper is preserved but the size of array will be set to zero.
//Parameters
//		array			A GByteArray.
//		free_segment		If TRUE the actual byte data is freed as well.
//Returns
//		The element data if free_segment is FALSE, otherwise NULL.
//		The element data should be freed using g_free().
uint8_t* g_byte_array_free(GByteArray* array, int free_segment) {
	return (uint8_t*)g_array_free((GArray*)array, free_segment);
}
