;
;	framdmga.s
;
;	P/ECE DMG-CPU Emulator
;
;	CLiP - Common Library for P/ECE
;	Copyright (C) 2001-2004 Naoyuki Sawa
;
;	* Thu Jan 15 20:09:00 JST 2004 Naoyuki Sawa
;	- 쐬JnB
;
;#include "clipdmga.h"
;/
;/	clipdmga.h
;/
;/	P/ECE DMG-CPU Emulator
;/
;/	CLiP - Common Library for P/ECE
;/	Copyright (C) 2001-2004 Naoyuki Sawa
;/
;/	* Thu Jan 15 20:09:00 JST 2004 Naoyuki Sawa
;/	- 쐬JnB
;/

;/ ̃t@CC/AZu\[XQƂ܂B
;/ CL̒`܂߂Ă͂܂B

;/ ̃V{`ƁAAZuR[hgp܂B
;/ ̃V{`Ȃ΁AbR[hgp܂B
;#define DMG_ASM
;#ifdef DMG_ASM

	.code
	.align 1

;****************************************************************************
;
;****************************************************************************

;
;	DMG\
;
;===== WX^ =====
;#define F	 0
;#define A	 1
;#define C	 2
;#define B	 3
;#define E	 4
;#define D	 5
;#define L	 6
;#define H	 7
;#define AF	 0
;#define BC	 2
;#define DE	 4
;#define HL	 6
;#define SP	 8
;#define PC	10
;=====  =====
;#define IME	12
;#define HALT	13
;#define CYCLE	20
;===== O֐ =====
;#define READ	24
;#define WRITE	28

;
;	C33=>DMGtOϊ\
;
;	!!
;	C33NtO͕tOADMGNtO͉ZtOłAʕłB
;	DMG͕tOĂ܂B
;
				; C33(C,V,Z,N) => DMG(Z,-,-,C)
				; ====C33====     ====DMG====
dmg_FLAG_CONV:			; ----CVZN        ZNHC----
	.byte	0x00		; 00000000 00     00000000 00
	.byte	0x00		; 00000001 01     00000000 00
	.byte	0x80		; 00000010 02     10000000 80
	.byte	0x80		; 00000011 03     10000000 80
	.byte	0x00		; 00000100 04     00000000 00
	.byte	0x00		; 00000101 05     00000000 00
	.byte	0x80		; 00000110 06     10000000 80
	.byte	0x80		; 00000111 07     10000000 80
	.byte	0x10		; 00001000 08     00010000 10
	.byte	0x10		; 00001001 09     00010000 10
	.byte	0x90		; 00001010 0a     10010000 90
	.byte	0x90		; 00001011 0b     10010000 90
	.byte	0x10		; 00001100 0c     00010000 10
	.byte	0x10		; 00001101 0d     00010000 10
	.byte	0x90		; 00001110 0e     10010000 90
	.byte	0x90		; 00001111 0f     10010000 90

;****************************************************************************
;
;****************************************************************************

	.global dmg_run
dmg_run:
	pushn %r3
	sub	%sp,0x1		; 	xsub %sp, %sp, 4
	;
	ld.w %r0, %r12			; dmg
	ext	0x18		; 	xld.w %r3, [%r0+0x18]		; dmg->read
	ld.w	%r3,[%r0]
	ext	0x14		; 	xld.w [%r0+0x14], %r13		; CYCLE
	ld.w	[%r0],%r13
	cmp	%r13,0x0	; 	xcmp %r13, 0			; if(CYCLE <= 0) break
	jrle	dmg_run_EXIT	; 	xjrle dmg_run_EXIT
	;
dmg_run_LOOP:
	ext	0xd		; 	xld.ub %r10, [%r0+0xd]		; if(HALT) break
	ld.ub	%r10,[%r0]
	ext	0xa		; 	xld.uh %r1, [%r0+0xa]		; PC *anti-interlock*
	ld.uh	%r1,[%r0]
	cmp	%r10,0x0	; 	xcmp %r10, 0
	jrne	dmg_run_EXIT	; 	xjrne dmg_run_EXIT
	;
	ld.w %r12, %r0			; code = dmg->read(dmg, PC++)
	ld.uh %r13, %r1
	call.d %r3
	add %r1, 1			; *delay*
	ld.w %r13, %r10
	;
	ext	dmg_op_table+0x0@h	; 	xld.w %r2, dmg_op_table		; op = &dmg_op_table[code]
	ext	dmg_op_table+0x0@m
	ld.w	%r2,dmg_op_table+0x0@l
	sll	%r10,0x3	; 	xsll %r10, 3
	add %r2, %r10
	;
	ext	0x4		; 	xld.ub %r10, [%r2+0x4]		; argc == 0 ?
	ld.ub	%r10,[%r2]
	cmp	%r10,0x0	; 	xcmp %r10, 0
	jreq	dmg_run_L10	; 	xjreq dmg_run_L10
	ld.b	[%sp+0x0],%r13	; 	xld.b [%sp+0x0], %r13		; (save code)
	;
	ld.w %r12, %r0			; LO(arg) = dmg->read(dmg, PC++)
	ld.uh %r13, %r1
	call.d %r3
	add %r1, 1			; *delay*
	ld.w %r14, %r10
	;
	ext	0x4		; 	xld.ub %r10, [%r2+0x4]		; argc == 1 ?
	ld.ub	%r10,[%r2]
	cmp	%r10,0x1	; 	xcmp %r10, 1
	jreq	dmg_run_L20	; 	xjreq dmg_run_L20
	ld.b	[%sp+0x1],%r14	; 	xld.b [%sp+0x1], %r14		; (save LO(arg))
	;
	ld.w %r12, %r0			; HI(arg) = dmg->read(dmg, PC++)
	ld.w %r13, %r1
	call.d %r3
	add %r1, 1			; *delay*
	;
	ld.ub	%r14,[%sp+0x1]	; 	xld.ub %r14, [%sp+0x1]		; (restore LO(arg))
	sll	%r10,0x8	; 	xsll %r10, 8			; *anti-interlock*
	or %r14, %r10			; arg = LO(arg) | HI(arg) << 8
dmg_run_L20:
	ld.ub	%r13,[%sp+0x0]	; 	xld.ub %r13, [%sp+0x0]		; (restore code)
dmg_run_L10:
	;
	ld.w	%r10,[%r2]	; 	xld.w %r10, [%r2+0x0]		; op->proc(dmg, code, arg1, arg2)
	ext	0xa		; 	xld.h [%r0+0xa], %r1		; PC *anti-interlock*
	ld.h	[%r0],%r1
	call.d %r10
	ld.w %r12, %r0			; *delay*
	;
	ext	0x14		; 	xld.w %r10, [%r0+0x14]		; CYCLE -= op->cycle
	ld.w	%r10,[%r0]
	ext	0x5		; 	xld.ub %r11, [%r2+0x5]
	ld.ub	%r11,[%r2]
	sub %r10, %r11
	ext	0x14		; 	xld.w [%r0+0x14], %r10
	ld.w	[%r0],%r10
	jrgt	dmg_run_LOOP	; 	xjrgt dmg_run_LOOP		; if(CYCLE <= 0) break
dmg_run_EXIT:
	;
	add	%sp,0x1		; 	xadd %sp, %sp, 4
	popn %r3
	ret

	.global dmgop_CB
dmgop_CB:
	pushn %r2
	;
	ld.w %r0, %r12			; dmg
	ext	0xa		; 	xld.uh %r1, [%r0+0xa]		; PC
	ld.uh	%r1,[%r0]
	;
	ext	0x18		; 	xld.w %r11, [%r0+0x18]		; code = dmg->read(dmg, PC++)
	ld.w	%r11,[%r0]
	ld.w %r12, %r0
	ld.uh %r13, %r1
	call.d %r11
	add %r1, 1			; *delay*
	ld.w %r13, %r10
	;
	ext	dmg_op_table_CB+0x0@h	; 	xld.w %r2, dmg_op_table_CB	; op = &dmg_op_table_CB[code]
	ext	dmg_op_table_CB+0x0@m
	ld.w	%r2,dmg_op_table_CB+0x0@l
	sll	%r10,0x3	; 	xsll %r10, 3
	add %r2, %r10
	;
	ld.w	%r10,[%r2]	; 	xld.w %r10, [%r2+0x0]		; op->proc(dmg, code, arg1, arg2)
	ext	0xa		; 	xld.h [%r0+0xa], %r1		; PC *anti-interlock*
	ld.h	[%r0],%r1
	call.d %r10
	ld.w %r12, %r0			; *delay*
	;
	ext	0x14		; 	xld.w %r10, [%r0+0x14]		; CYCLE -= op->cycle
	ld.w	%r10,[%r0]
	ext	0x5		; 	xld.ub %r11, [%r2+0x5]
	ld.ub	%r11,[%r2]
	sub %r10, %r11
	ext	0x14		; 	xld.w [%r0+0x14], %r10
	ld.w	[%r0],%r10
	;
	popn %r2
	ret

;****************************************************************************
;	8-Bit Loads
;****************************************************************************

;#macro LD_r_r $1, $2
;	xld.ub %r10, [%r12+$2]
;	xld.b [%r12+$1], %r10
;	ret
;#endm

;#macro LD_r_IrrI $1, $2
;	pushn %r0
	;
;	xld.w %r10, [%r12+READ]
;	xld.uh %r13, [%r12+$2]		; *anti-interlock*
;	call.d %r10
;	ld.w %r0, %r12			; *delay*
;	xld.b [%r0+$1], %r10
	;
;	popn %r0
;	ret
;#endm

;#macro LD_IrrI_r $1, $2
;	xld.w %r10, [%r12+WRITE]
;	xld.uh %r13, [%r12+$1]
;	xld.ub %r14, [%r12+$2]
;	call %r10
;	ret
;#endm

;#macro LD_r_n $1
;	xld.b [%r12+$1], %r14
;	ret
;#endm

;#macro LD_IrrI_n $1
;	xld.w %r10, [%r12+WRITE]
;	xld.uh %r13, [%r12+$1]		; *anti-interlock*
;	call %r10
;	ret
;#endm

;****************************************************************************

	.global dmgop_LD_B_B
dmgop_LD_B_B:
	ext	0x3		; 	xld.ub %r10, [%r12+0x3]	; 	LD_r_r B, B
	ld.ub	%r10,[%r12]
	ext	0x3		; 	xld.b [%r12+0x3], %r10
	ld.b	[%r12],%r10
	ret
	.global dmgop_LD_B_C
dmgop_LD_B_C:
	ext	0x2		; 	xld.ub %r10, [%r12+0x2]	; 	LD_r_r B, C
	ld.ub	%r10,[%r12]
	ext	0x3		; 	xld.b [%r12+0x3], %r10
	ld.b	[%r12],%r10
	ret
	.global dmgop_LD_B_D
dmgop_LD_B_D:
	ext	0x5		; 	xld.ub %r10, [%r12+0x5]	; 	LD_r_r B, D
	ld.ub	%r10,[%r12]
	ext	0x3		; 	xld.b [%r12+0x3], %r10
	ld.b	[%r12],%r10
	ret
	.global dmgop_LD_B_E
dmgop_LD_B_E:
	ext	0x4		; 	xld.ub %r10, [%r12+0x4]	; 	LD_r_r B, E
	ld.ub	%r10,[%r12]
	ext	0x3		; 	xld.b [%r12+0x3], %r10
	ld.b	[%r12],%r10
	ret
	.global dmgop_LD_B_H
dmgop_LD_B_H:
	ext	0x7		; 	xld.ub %r10, [%r12+0x7]	; 	LD_r_r B, H
	ld.ub	%r10,[%r12]
	ext	0x3		; 	xld.b [%r12+0x3], %r10
	ld.b	[%r12],%r10
	ret
	.global dmgop_LD_B_L
dmgop_LD_B_L:
	ext	0x6		; 	xld.ub %r10, [%r12+0x6]	; 	LD_r_r B, L
	ld.ub	%r10,[%r12]
	ext	0x3		; 	xld.b [%r12+0x3], %r10
	ld.b	[%r12],%r10
	ret
	.global dmgop_LD_B_IHLI
dmgop_LD_B_IHLI:
	pushn %r0	; 	LD_r_IrrI B, HL
	;
	ext	0x18		; 	xld.w %r10, [%r12+0x18]
	ld.w	%r10,[%r12]
	ext	0x6		; 	xld.uh %r13, [%r12+0x6]		; *anti-interlock*
	ld.uh	%r13,[%r12]
	call.d %r10
	ld.w %r0, %r12			; *delay*
	ext	0x3		; 	xld.b [%r0+0x3], %r10
	ld.b	[%r0],%r10
	;
	popn %r0
	ret
	.global dmgop_LD_B_A
dmgop_LD_B_A:
	ext	0x1		; 	xld.ub %r10, [%r12+0x1]	; 	LD_r_r B, A
	ld.ub	%r10,[%r12]
	ext	0x3		; 	xld.b [%r12+0x3], %r10
	ld.b	[%r12],%r10
	ret

	.global dmgop_LD_C_B
dmgop_LD_C_B:
	ext	0x3		; 	xld.ub %r10, [%r12+0x3]	; 	LD_r_r C, B
	ld.ub	%r10,[%r12]
	ext	0x2		; 	xld.b [%r12+0x2], %r10
	ld.b	[%r12],%r10
	ret
	.global dmgop_LD_C_C
dmgop_LD_C_C:
	ext	0x2		; 	xld.ub %r10, [%r12+0x2]	; 	LD_r_r C, C
	ld.ub	%r10,[%r12]
	ext	0x2		; 	xld.b [%r12+0x2], %r10
	ld.b	[%r12],%r10
	ret
	.global dmgop_LD_C_D
dmgop_LD_C_D:
	ext	0x5		; 	xld.ub %r10, [%r12+0x5]	; 	LD_r_r C, D
	ld.ub	%r10,[%r12]
	ext	0x2		; 	xld.b [%r12+0x2], %r10
	ld.b	[%r12],%r10
	ret
	.global dmgop_LD_C_E
dmgop_LD_C_E:
	ext	0x4		; 	xld.ub %r10, [%r12+0x4]	; 	LD_r_r C, E
	ld.ub	%r10,[%r12]
	ext	0x2		; 	xld.b [%r12+0x2], %r10
	ld.b	[%r12],%r10
	ret
	.global dmgop_LD_C_H
dmgop_LD_C_H:
	ext	0x7		; 	xld.ub %r10, [%r12+0x7]	; 	LD_r_r C, H
	ld.ub	%r10,[%r12]
	ext	0x2		; 	xld.b [%r12+0x2], %r10
	ld.b	[%r12],%r10
	ret
	.global dmgop_LD_C_L
dmgop_LD_C_L:
	ext	0x6		; 	xld.ub %r10, [%r12+0x6]	; 	LD_r_r C, L
	ld.ub	%r10,[%r12]
	ext	0x2		; 	xld.b [%r12+0x2], %r10
	ld.b	[%r12],%r10
	ret
	.global dmgop_LD_C_IHLI
dmgop_LD_C_IHLI:
	pushn %r0	; 	LD_r_IrrI C, HL
	;
	ext	0x18		; 	xld.w %r10, [%r12+0x18]
	ld.w	%r10,[%r12]
	ext	0x6		; 	xld.uh %r13, [%r12+0x6]		; *anti-interlock*
	ld.uh	%r13,[%r12]
	call.d %r10
	ld.w %r0, %r12			; *delay*
	ext	0x2		; 	xld.b [%r0+0x2], %r10
	ld.b	[%r0],%r10
	;
	popn %r0
	ret
	.global dmgop_LD_C_A
dmgop_LD_C_A:
	ext	0x1		; 	xld.ub %r10, [%r12+0x1]	; 	LD_r_r C, A
	ld.ub	%r10,[%r12]
	ext	0x2		; 	xld.b [%r12+0x2], %r10
	ld.b	[%r12],%r10
	ret

	.global dmgop_LD_D_B
dmgop_LD_D_B:
	ext	0x3		; 	xld.ub %r10, [%r12+0x3]	; 	LD_r_r D, B
	ld.ub	%r10,[%r12]
	ext	0x5		; 	xld.b [%r12+0x5], %r10
	ld.b	[%r12],%r10
	ret
	.global dmgop_LD_D_C
dmgop_LD_D_C:
	ext	0x2		; 	xld.ub %r10, [%r12+0x2]	; 	LD_r_r D, C
	ld.ub	%r10,[%r12]
	ext	0x5		; 	xld.b [%r12+0x5], %r10
	ld.b	[%r12],%r10
	ret
	.global dmgop_LD_D_D
dmgop_LD_D_D:
	ext	0x5		; 	xld.ub %r10, [%r12+0x5]	; 	LD_r_r D, D
	ld.ub	%r10,[%r12]
	ext	0x5		; 	xld.b [%r12+0x5], %r10
	ld.b	[%r12],%r10
	ret
	.global dmgop_LD_D_E
dmgop_LD_D_E:
	ext	0x4		; 	xld.ub %r10, [%r12+0x4]	; 	LD_r_r D, E
	ld.ub	%r10,[%r12]
	ext	0x5		; 	xld.b [%r12+0x5], %r10
	ld.b	[%r12],%r10
	ret
	.global dmgop_LD_D_H
dmgop_LD_D_H:
	ext	0x7		; 	xld.ub %r10, [%r12+0x7]	; 	LD_r_r D, H
	ld.ub	%r10,[%r12]
	ext	0x5		; 	xld.b [%r12+0x5], %r10
	ld.b	[%r12],%r10
	ret
	.global dmgop_LD_D_L
dmgop_LD_D_L:
	ext	0x6		; 	xld.ub %r10, [%r12+0x6]	; 	LD_r_r D, L
	ld.ub	%r10,[%r12]
	ext	0x5		; 	xld.b [%r12+0x5], %r10
	ld.b	[%r12],%r10
	ret
	.global dmgop_LD_D_IHLI
dmgop_LD_D_IHLI:
	pushn %r0	; 	LD_r_IrrI D, HL
	;
	ext	0x18		; 	xld.w %r10, [%r12+0x18]
	ld.w	%r10,[%r12]
	ext	0x6		; 	xld.uh %r13, [%r12+0x6]		; *anti-interlock*
	ld.uh	%r13,[%r12]
	call.d %r10
	ld.w %r0, %r12			; *delay*
	ext	0x5		; 	xld.b [%r0+0x5], %r10
	ld.b	[%r0],%r10
	;
	popn %r0
	ret
	.global dmgop_LD_D_A
dmgop_LD_D_A:
	ext	0x1		; 	xld.ub %r10, [%r12+0x1]	; 	LD_r_r D, A
	ld.ub	%r10,[%r12]
	ext	0x5		; 	xld.b [%r12+0x5], %r10
	ld.b	[%r12],%r10
	ret

	.global dmgop_LD_E_B
dmgop_LD_E_B:
	ext	0x3		; 	xld.ub %r10, [%r12+0x3]	; 	LD_r_r E, B
	ld.ub	%r10,[%r12]
	ext	0x4		; 	xld.b [%r12+0x4], %r10
	ld.b	[%r12],%r10
	ret
	.global dmgop_LD_E_C
dmgop_LD_E_C:
	ext	0x2		; 	xld.ub %r10, [%r12+0x2]	; 	LD_r_r E, C
	ld.ub	%r10,[%r12]
	ext	0x4		; 	xld.b [%r12+0x4], %r10
	ld.b	[%r12],%r10
	ret
	.global dmgop_LD_E_D
dmgop_LD_E_D:
	ext	0x5		; 	xld.ub %r10, [%r12+0x5]	; 	LD_r_r E, D
	ld.ub	%r10,[%r12]
	ext	0x4		; 	xld.b [%r12+0x4], %r10
	ld.b	[%r12],%r10
	ret
	.global dmgop_LD_E_E
dmgop_LD_E_E:
	ext	0x4		; 	xld.ub %r10, [%r12+0x4]	; 	LD_r_r E, E
	ld.ub	%r10,[%r12]
	ext	0x4		; 	xld.b [%r12+0x4], %r10
	ld.b	[%r12],%r10
	ret
	.global dmgop_LD_E_H
dmgop_LD_E_H:
	ext	0x7		; 	xld.ub %r10, [%r12+0x7]	; 	LD_r_r E, H
	ld.ub	%r10,[%r12]
	ext	0x4		; 	xld.b [%r12+0x4], %r10
	ld.b	[%r12],%r10
	ret
	.global dmgop_LD_E_L
dmgop_LD_E_L:
	ext	0x6		; 	xld.ub %r10, [%r12+0x6]	; 	LD_r_r E, L
	ld.ub	%r10,[%r12]
	ext	0x4		; 	xld.b [%r12+0x4], %r10
	ld.b	[%r12],%r10
	ret
	.global dmgop_LD_E_IHLI
dmgop_LD_E_IHLI:
	pushn %r0	; 	LD_r_IrrI E, HL
	;
	ext	0x18		; 	xld.w %r10, [%r12+0x18]
	ld.w	%r10,[%r12]
	ext	0x6		; 	xld.uh %r13, [%r12+0x6]		; *anti-interlock*
	ld.uh	%r13,[%r12]
	call.d %r10
	ld.w %r0, %r12			; *delay*
	ext	0x4		; 	xld.b [%r0+0x4], %r10
	ld.b	[%r0],%r10
	;
	popn %r0
	ret
	.global dmgop_LD_E_A
dmgop_LD_E_A:
	ext	0x1		; 	xld.ub %r10, [%r12+0x1]	; 	LD_r_r E, A
	ld.ub	%r10,[%r12]
	ext	0x4		; 	xld.b [%r12+0x4], %r10
	ld.b	[%r12],%r10
	ret

	.global dmgop_LD_H_B
dmgop_LD_H_B:
	ext	0x3		; 	xld.ub %r10, [%r12+0x3]	; 	LD_r_r H, B
	ld.ub	%r10,[%r12]
	ext	0x7		; 	xld.b [%r12+0x7], %r10
	ld.b	[%r12],%r10
	ret
	.global dmgop_LD_H_C
dmgop_LD_H_C:
	ext	0x2		; 	xld.ub %r10, [%r12+0x2]	; 	LD_r_r H, C
	ld.ub	%r10,[%r12]
	ext	0x7		; 	xld.b [%r12+0x7], %r10
	ld.b	[%r12],%r10
	ret
	.global dmgop_LD_H_D
dmgop_LD_H_D:
	ext	0x5		; 	xld.ub %r10, [%r12+0x5]	; 	LD_r_r H, D
	ld.ub	%r10,[%r12]
	ext	0x7		; 	xld.b [%r12+0x7], %r10
	ld.b	[%r12],%r10
	ret
	.global dmgop_LD_H_E
dmgop_LD_H_E:
	ext	0x4		; 	xld.ub %r10, [%r12+0x4]	; 	LD_r_r H, E
	ld.ub	%r10,[%r12]
	ext	0x7		; 	xld.b [%r12+0x7], %r10
	ld.b	[%r12],%r10
	ret
	.global dmgop_LD_H_H
dmgop_LD_H_H:
	ext	0x7		; 	xld.ub %r10, [%r12+0x7]	; 	LD_r_r H, H
	ld.ub	%r10,[%r12]
	ext	0x7		; 	xld.b [%r12+0x7], %r10
	ld.b	[%r12],%r10
	ret
	.global dmgop_LD_H_L
dmgop_LD_H_L:
	ext	0x6		; 	xld.ub %r10, [%r12+0x6]	; 	LD_r_r H, L
	ld.ub	%r10,[%r12]
	ext	0x7		; 	xld.b [%r12+0x7], %r10
	ld.b	[%r12],%r10
	ret
	.global dmgop_LD_H_IHLI
dmgop_LD_H_IHLI:
	pushn %r0	; 	LD_r_IrrI H, HL
	;
	ext	0x18		; 	xld.w %r10, [%r12+0x18]
	ld.w	%r10,[%r12]
	ext	0x6		; 	xld.uh %r13, [%r12+0x6]		; *anti-interlock*
	ld.uh	%r13,[%r12]
	call.d %r10
	ld.w %r0, %r12			; *delay*
	ext	0x7		; 	xld.b [%r0+0x7], %r10
	ld.b	[%r0],%r10
	;
	popn %r0
	ret
	.global dmgop_LD_H_A
dmgop_LD_H_A:
	ext	0x1		; 	xld.ub %r10, [%r12+0x1]	; 	LD_r_r H, A
	ld.ub	%r10,[%r12]
	ext	0x7		; 	xld.b [%r12+0x7], %r10
	ld.b	[%r12],%r10
	ret

	.global dmgop_LD_L_B
dmgop_LD_L_B:
	ext	0x3		; 	xld.ub %r10, [%r12+0x3]	; 	LD_r_r L, B
	ld.ub	%r10,[%r12]
	ext	0x6		; 	xld.b [%r12+0x6], %r10
	ld.b	[%r12],%r10
	ret
	.global dmgop_LD_L_C
dmgop_LD_L_C:
	ext	0x2		; 	xld.ub %r10, [%r12+0x2]	; 	LD_r_r L, C
	ld.ub	%r10,[%r12]
	ext	0x6		; 	xld.b [%r12+0x6], %r10
	ld.b	[%r12],%r10
	ret
	.global dmgop_LD_L_D
dmgop_LD_L_D:
	ext	0x5		; 	xld.ub %r10, [%r12+0x5]	; 	LD_r_r L, D
	ld.ub	%r10,[%r12]
	ext	0x6		; 	xld.b [%r12+0x6], %r10
	ld.b	[%r12],%r10
	ret
	.global dmgop_LD_L_E
dmgop_LD_L_E:
	ext	0x4		; 	xld.ub %r10, [%r12+0x4]	; 	LD_r_r L, E
	ld.ub	%r10,[%r12]
	ext	0x6		; 	xld.b [%r12+0x6], %r10
	ld.b	[%r12],%r10
	ret
	.global dmgop_LD_L_H
dmgop_LD_L_H:
	ext	0x7		; 	xld.ub %r10, [%r12+0x7]	; 	LD_r_r L, H
	ld.ub	%r10,[%r12]
	ext	0x6		; 	xld.b [%r12+0x6], %r10
	ld.b	[%r12],%r10
	ret
	.global dmgop_LD_L_L
dmgop_LD_L_L:
	ext	0x6		; 	xld.ub %r10, [%r12+0x6]	; 	LD_r_r L, L
	ld.ub	%r10,[%r12]
	ext	0x6		; 	xld.b [%r12+0x6], %r10
	ld.b	[%r12],%r10
	ret
	.global dmgop_LD_L_IHLI
dmgop_LD_L_IHLI:
	pushn %r0	; 	LD_r_IrrI L, HL
	;
	ext	0x18		; 	xld.w %r10, [%r12+0x18]
	ld.w	%r10,[%r12]
	ext	0x6		; 	xld.uh %r13, [%r12+0x6]		; *anti-interlock*
	ld.uh	%r13,[%r12]
	call.d %r10
	ld.w %r0, %r12			; *delay*
	ext	0x6		; 	xld.b [%r0+0x6], %r10
	ld.b	[%r0],%r10
	;
	popn %r0
	ret
	.global dmgop_LD_L_A
dmgop_LD_L_A:
	ext	0x1		; 	xld.ub %r10, [%r12+0x1]	; 	LD_r_r L, A
	ld.ub	%r10,[%r12]
	ext	0x6		; 	xld.b [%r12+0x6], %r10
	ld.b	[%r12],%r10
	ret

	.global dmgop_LD_IHLI_B
dmgop_LD_IHLI_B:
	ext	0x1c		; 	xld.w %r10, [%r12+0x1c]	; 	LD_IrrI_r HL, B
	ld.w	%r10,[%r12]
	ext	0x6		; 	xld.uh %r13, [%r12+0x6]
	ld.uh	%r13,[%r12]
	ext	0x3		; 	xld.ub %r14, [%r12+0x3]
	ld.ub	%r14,[%r12]
	call %r10
	ret
	.global dmgop_LD_IHLI_C
dmgop_LD_IHLI_C:
	ext	0x1c		; 	xld.w %r10, [%r12+0x1c]	; 	LD_IrrI_r HL, C
	ld.w	%r10,[%r12]
	ext	0x6		; 	xld.uh %r13, [%r12+0x6]
	ld.uh	%r13,[%r12]
	ext	0x2		; 	xld.ub %r14, [%r12+0x2]
	ld.ub	%r14,[%r12]
	call %r10
	ret
	.global dmgop_LD_IHLI_D
dmgop_LD_IHLI_D:
	ext	0x1c		; 	xld.w %r10, [%r12+0x1c]	; 	LD_IrrI_r HL, D
	ld.w	%r10,[%r12]
	ext	0x6		; 	xld.uh %r13, [%r12+0x6]
	ld.uh	%r13,[%r12]
	ext	0x5		; 	xld.ub %r14, [%r12+0x5]
	ld.ub	%r14,[%r12]
	call %r10
	ret
	.global dmgop_LD_IHLI_E
dmgop_LD_IHLI_E:
	ext	0x1c		; 	xld.w %r10, [%r12+0x1c]	; 	LD_IrrI_r HL, E
	ld.w	%r10,[%r12]
	ext	0x6		; 	xld.uh %r13, [%r12+0x6]
	ld.uh	%r13,[%r12]
	ext	0x4		; 	xld.ub %r14, [%r12+0x4]
	ld.ub	%r14,[%r12]
	call %r10
	ret
	.global dmgop_LD_IHLI_H
dmgop_LD_IHLI_H:
	ext	0x1c		; 	xld.w %r10, [%r12+0x1c]	; 	LD_IrrI_r HL, H
	ld.w	%r10,[%r12]
	ext	0x6		; 	xld.uh %r13, [%r12+0x6]
	ld.uh	%r13,[%r12]
	ext	0x7		; 	xld.ub %r14, [%r12+0x7]
	ld.ub	%r14,[%r12]
	call %r10
	ret
	.global dmgop_LD_IHLI_L
dmgop_LD_IHLI_L:
	ext	0x1c		; 	xld.w %r10, [%r12+0x1c]	; 	LD_IrrI_r HL, L
	ld.w	%r10,[%r12]
	ext	0x6		; 	xld.uh %r13, [%r12+0x6]
	ld.uh	%r13,[%r12]
	ext	0x6		; 	xld.ub %r14, [%r12+0x6]
	ld.ub	%r14,[%r12]
	call %r10
	ret
	.global dmgop_LD_IHLI_A
dmgop_LD_IHLI_A:
	ext	0x1c		; 	xld.w %r10, [%r12+0x1c]	; 	LD_IrrI_r HL, A
	ld.w	%r10,[%r12]
	ext	0x6		; 	xld.uh %r13, [%r12+0x6]
	ld.uh	%r13,[%r12]
	ext	0x1		; 	xld.ub %r14, [%r12+0x1]
	ld.ub	%r14,[%r12]
	call %r10
	ret

	.global dmgop_LD_A_B
dmgop_LD_A_B:
	ext	0x3		; 	xld.ub %r10, [%r12+0x3]	; 	LD_r_r A, B
	ld.ub	%r10,[%r12]
	ext	0x1		; 	xld.b [%r12+0x1], %r10
	ld.b	[%r12],%r10
	ret
	.global dmgop_LD_A_C
dmgop_LD_A_C:
	ext	0x2		; 	xld.ub %r10, [%r12+0x2]	; 	LD_r_r A, C
	ld.ub	%r10,[%r12]
	ext	0x1		; 	xld.b [%r12+0x1], %r10
	ld.b	[%r12],%r10
	ret
	.global dmgop_LD_A_D
dmgop_LD_A_D:
	ext	0x5		; 	xld.ub %r10, [%r12+0x5]	; 	LD_r_r A, D
	ld.ub	%r10,[%r12]
	ext	0x1		; 	xld.b [%r12+0x1], %r10
	ld.b	[%r12],%r10
	ret
	.global dmgop_LD_A_E
dmgop_LD_A_E:
	ext	0x4		; 	xld.ub %r10, [%r12+0x4]	; 	LD_r_r A, E
	ld.ub	%r10,[%r12]
	ext	0x1		; 	xld.b [%r12+0x1], %r10
	ld.b	[%r12],%r10
	ret
	.global dmgop_LD_A_H
dmgop_LD_A_H:
	ext	0x7		; 	xld.ub %r10, [%r12+0x7]	; 	LD_r_r A, H
	ld.ub	%r10,[%r12]
	ext	0x1		; 	xld.b [%r12+0x1], %r10
	ld.b	[%r12],%r10
	ret
	.global dmgop_LD_A_L
dmgop_LD_A_L:
	ext	0x6		; 	xld.ub %r10, [%r12+0x6]	; 	LD_r_r A, L
	ld.ub	%r10,[%r12]
	ext	0x1		; 	xld.b [%r12+0x1], %r10
	ld.b	[%r12],%r10
	ret
	.global dmgop_LD_A_IHLI
dmgop_LD_A_IHLI:
	pushn %r0	; 	LD_r_IrrI A, HL
	;
	ext	0x18		; 	xld.w %r10, [%r12+0x18]
	ld.w	%r10,[%r12]
	ext	0x6		; 	xld.uh %r13, [%r12+0x6]		; *anti-interlock*
	ld.uh	%r13,[%r12]
	call.d %r10
	ld.w %r0, %r12			; *delay*
	ext	0x1		; 	xld.b [%r0+0x1], %r10
	ld.b	[%r0],%r10
	;
	popn %r0
	ret
	.global dmgop_LD_A_A
dmgop_LD_A_A:
	ext	0x1		; 	xld.ub %r10, [%r12+0x1]	; 	LD_r_r A, A
	ld.ub	%r10,[%r12]
	ext	0x1		; 	xld.b [%r12+0x1], %r10
	ld.b	[%r12],%r10
	ret

	.global dmgop_LD_B_n
dmgop_LD_B_n:
	ext	0x3		; 	xld.b [%r12+0x3], %r14	; 	LD_r_n B
	ld.b	[%r12],%r14
	ret
	.global dmgop_LD_C_n
dmgop_LD_C_n:
	ext	0x2		; 	xld.b [%r12+0x2], %r14	; 	LD_r_n C
	ld.b	[%r12],%r14
	ret
	.global dmgop_LD_D_n
dmgop_LD_D_n:
	ext	0x5		; 	xld.b [%r12+0x5], %r14	; 	LD_r_n D
	ld.b	[%r12],%r14
	ret
	.global dmgop_LD_E_n
dmgop_LD_E_n:
	ext	0x4		; 	xld.b [%r12+0x4], %r14	; 	LD_r_n E
	ld.b	[%r12],%r14
	ret
	.global dmgop_LD_H_n
dmgop_LD_H_n:
	ext	0x7		; 	xld.b [%r12+0x7], %r14	; 	LD_r_n H
	ld.b	[%r12],%r14
	ret
	.global dmgop_LD_L_n
dmgop_LD_L_n:
	ext	0x6		; 	xld.b [%r12+0x6], %r14	; 	LD_r_n L
	ld.b	[%r12],%r14
	ret
	.global dmgop_LD_IHLI_n
dmgop_LD_IHLI_n:
	ext	0x1c		; 	xld.w %r10, [%r12+0x1c]	; 	LD_IrrI_n HL
	ld.w	%r10,[%r12]
	ext	0x6		; 	xld.uh %r13, [%r12+0x6]		; *anti-interlock*
	ld.uh	%r13,[%r12]
	call %r10
	ret
	.global dmgop_LD_A_n
dmgop_LD_A_n:
	ext	0x1		; 	xld.b [%r12+0x1], %r14	; 	LD_r_n A
	ld.b	[%r12],%r14
	ret

	.global dmgop_LD_IBCI_A
dmgop_LD_IBCI_A:
	ext	0x1c		; 	xld.w %r10, [%r12+0x1c]	; 	LD_IrrI_r BC, A
	ld.w	%r10,[%r12]
	ext	0x2		; 	xld.uh %r13, [%r12+0x2]
	ld.uh	%r13,[%r12]
	ext	0x1		; 	xld.ub %r14, [%r12+0x1]
	ld.ub	%r14,[%r12]
	call %r10
	ret
	.global dmgop_LD_A_IBCI
dmgop_LD_A_IBCI:
	pushn %r0	; 	LD_r_IrrI A, BC
	;
	ext	0x18		; 	xld.w %r10, [%r12+0x18]
	ld.w	%r10,[%r12]
	ext	0x2		; 	xld.uh %r13, [%r12+0x2]		; *anti-interlock*
	ld.uh	%r13,[%r12]
	call.d %r10
	ld.w %r0, %r12			; *delay*
	ext	0x1		; 	xld.b [%r0+0x1], %r10
	ld.b	[%r0],%r10
	;
	popn %r0
	ret
	.global dmgop_LD_IDEI_A
dmgop_LD_IDEI_A:
	ext	0x1c		; 	xld.w %r10, [%r12+0x1c]	; 	LD_IrrI_r DE, A
	ld.w	%r10,[%r12]
	ext	0x4		; 	xld.uh %r13, [%r12+0x4]
	ld.uh	%r13,[%r12]
	ext	0x1		; 	xld.ub %r14, [%r12+0x1]
	ld.ub	%r14,[%r12]
	call %r10
	ret
	.global dmgop_LD_A_IDEI
dmgop_LD_A_IDEI:
	pushn %r0	; 	LD_r_IrrI A, DE
	;
	ext	0x18		; 	xld.w %r10, [%r12+0x18]
	ld.w	%r10,[%r12]
	ext	0x4		; 	xld.uh %r13, [%r12+0x4]		; *anti-interlock*
	ld.uh	%r13,[%r12]
	call.d %r10
	ld.w %r0, %r12			; *delay*
	ext	0x1		; 	xld.b [%r0+0x1], %r10
	ld.b	[%r0],%r10
	;
	popn %r0
	ret

;****************************************************************************
;	16-Bit Loads
;****************************************************************************

;#macro LD_rr_nn $1
;	xld.h [%r12+$1], %r14
;	ret
;#endm

;#macro PUSH_rr $1
;	pushn %r1
	;
;	xld.uh %r1, [%r12+SP]		; SP
	;
;	xld.w %r10, [%r12+WRITE]
;	xsub %r1, %r1, 1		; SP--
;	ld.uh %r13, %r1
;	xld.ub %r14, [%r12+($1+1)]	; HI
;	call.d %r10
;	ld.w %r0, %r12			; *delay*
	;
;	xld.w %r10, [%r0+WRITE]
;	xsub %r1, %r1, 1		; SP--
;	ld.uh %r13, %r1
;	xld.ub %r14, [%r0+($1+0)]	; LO
;	call.d %r10
;	ld.w %r12, %r0			; *delay*
	;
;	xld.h [%r0+SP], %r1		; SP
	;
;	popn %r1
;	ret
;#endm

;#macro POP_rr $1
;	pushn %r1
	;
;	xld.uh %r1, [%r12+SP]		; SP
	;
;	xld.w %r10, [%r12+READ]
;	ld.uh %r13, %r1			; *anti-interlock*
;	call.d %r10
;	ld.w %r0, %r12			; *delay*
;	xld.b [%r0+($1+0)], %r10	; LO
;	xadd %r1, %r1, 1		; SP++
	;
;	xld.w %r10, [%r0+READ]
;	ld.uh %r13, %r1			; *anti-interlock*
;	call.d %r10
;	ld.w %r12, %r0			; *delay*
;	xld.b [%r0+($1+1)], %r10	; HI
;	xadd %r1, %r1, 1		; SP++
	;
;	xld.h [%r0+SP], %r1		; SP
	;
;	popn %r1
;	ret
;#endm

;****************************************************************************

	.global dmgop_LD_BC_nn
dmgop_LD_BC_nn:
	ext	0x2		; 	xld.h [%r12+0x2], %r14	; 	LD_rr_nn BC
	ld.h	[%r12],%r14
	ret
	.global dmgop_LD_DE_nn
dmgop_LD_DE_nn:
	ext	0x4		; 	xld.h [%r12+0x4], %r14	; 	LD_rr_nn DE
	ld.h	[%r12],%r14
	ret
	.global dmgop_LD_HL_nn
dmgop_LD_HL_nn:
	ext	0x6		; 	xld.h [%r12+0x6], %r14	; 	LD_rr_nn HL
	ld.h	[%r12],%r14
	ret
	.global dmgop_LD_SP_nn
dmgop_LD_SP_nn:
	ext	0x8		; 	xld.h [%r12+0x8], %r14	; 	LD_rr_nn SP
	ld.h	[%r12],%r14
	ret

	.global dmgop_PUSH_AF
dmgop_PUSH_AF:
	pushn %r1	; 	PUSH_rr AF
	;
	ext	0x8		; 	xld.uh %r1, [%r12+0x8]		; SP
	ld.uh	%r1,[%r12]
	;
	ext	0x1c		; 	xld.w %r10, [%r12+0x1c]
	ld.w	%r10,[%r12]
	sub	%r1,0x1		; 	xsub %r1, %r1, 1		; SP--
	ld.uh %r13, %r1
	ext	0x1		; 	xld.ub %r14, [%r12+0x1]	; HI
	ld.ub	%r14,[%r12]
	call.d %r10
	ld.w %r0, %r12			; *delay*
	;
	ext	0x1c		; 	xld.w %r10, [%r0+0x1c]
	ld.w	%r10,[%r0]
	sub	%r1,0x1		; 	xsub %r1, %r1, 1		; SP--
	ld.uh %r13, %r1
	ld.ub	%r14,[%r0]	; 	xld.ub %r14, [%r0+0x0]	; LO
	call.d %r10
	ld.w %r12, %r0			; *delay*
	;
	ext	0x8		; 	xld.h [%r0+0x8], %r1		; SP
	ld.h	[%r0],%r1
	;
	popn %r1
	ret
	.global dmgop_PUSH_BC
dmgop_PUSH_BC:
	pushn %r1	; 	PUSH_rr BC
	;
	ext	0x8		; 	xld.uh %r1, [%r12+0x8]		; SP
	ld.uh	%r1,[%r12]
	;
	ext	0x1c		; 	xld.w %r10, [%r12+0x1c]
	ld.w	%r10,[%r12]
	sub	%r1,0x1		; 	xsub %r1, %r1, 1		; SP--
	ld.uh %r13, %r1
	ext	0x3		; 	xld.ub %r14, [%r12+0x3]	; HI
	ld.ub	%r14,[%r12]
	call.d %r10
	ld.w %r0, %r12			; *delay*
	;
	ext	0x1c		; 	xld.w %r10, [%r0+0x1c]
	ld.w	%r10,[%r0]
	sub	%r1,0x1		; 	xsub %r1, %r1, 1		; SP--
	ld.uh %r13, %r1
	ext	0x2		; 	xld.ub %r14, [%r0+0x2]	; LO
	ld.ub	%r14,[%r0]
	call.d %r10
	ld.w %r12, %r0			; *delay*
	;
	ext	0x8		; 	xld.h [%r0+0x8], %r1		; SP
	ld.h	[%r0],%r1
	;
	popn %r1
	ret
	.global dmgop_PUSH_DE
dmgop_PUSH_DE:
	pushn %r1	; 	PUSH_rr DE
	;
	ext	0x8		; 	xld.uh %r1, [%r12+0x8]		; SP
	ld.uh	%r1,[%r12]
	;
	ext	0x1c		; 	xld.w %r10, [%r12+0x1c]
	ld.w	%r10,[%r12]
	sub	%r1,0x1		; 	xsub %r1, %r1, 1		; SP--
	ld.uh %r13, %r1
	ext	0x5		; 	xld.ub %r14, [%r12+0x5]	; HI
	ld.ub	%r14,[%r12]
	call.d %r10
	ld.w %r0, %r12			; *delay*
	;
	ext	0x1c		; 	xld.w %r10, [%r0+0x1c]
	ld.w	%r10,[%r0]
	sub	%r1,0x1		; 	xsub %r1, %r1, 1		; SP--
	ld.uh %r13, %r1
	ext	0x4		; 	xld.ub %r14, [%r0+0x4]	; LO
	ld.ub	%r14,[%r0]
	call.d %r10
	ld.w %r12, %r0			; *delay*
	;
	ext	0x8		; 	xld.h [%r0+0x8], %r1		; SP
	ld.h	[%r0],%r1
	;
	popn %r1
	ret
	.global dmgop_PUSH_HL
dmgop_PUSH_HL:
	pushn %r1	; 	PUSH_rr HL
	;
	ext	0x8		; 	xld.uh %r1, [%r12+0x8]		; SP
	ld.uh	%r1,[%r12]
	;
	ext	0x1c		; 	xld.w %r10, [%r12+0x1c]
	ld.w	%r10,[%r12]
	sub	%r1,0x1		; 	xsub %r1, %r1, 1		; SP--
	ld.uh %r13, %r1
	ext	0x7		; 	xld.ub %r14, [%r12+0x7]	; HI
	ld.ub	%r14,[%r12]
	call.d %r10
	ld.w %r0, %r12			; *delay*
	;
	ext	0x1c		; 	xld.w %r10, [%r0+0x1c]
	ld.w	%r10,[%r0]
	sub	%r1,0x1		; 	xsub %r1, %r1, 1		; SP--
	ld.uh %r13, %r1
	ext	0x6		; 	xld.ub %r14, [%r0+0x6]	; LO
	ld.ub	%r14,[%r0]
	call.d %r10
	ld.w %r12, %r0			; *delay*
	;
	ext	0x8		; 	xld.h [%r0+0x8], %r1		; SP
	ld.h	[%r0],%r1
	;
	popn %r1
	ret

	.global dmgop_POP_AF
dmgop_POP_AF:
	pushn %r1	; 	POP_rr AF
	;
	ext	0x8		; 	xld.uh %r1, [%r12+0x8]		; SP
	ld.uh	%r1,[%r12]
	;
	ext	0x18		; 	xld.w %r10, [%r12+0x18]
	ld.w	%r10,[%r12]
	ld.uh %r13, %r1			; *anti-interlock*
	call.d %r10
	ld.w %r0, %r12			; *delay*
	ld.b	[%r0],%r10	; 	xld.b [%r0+0x0], %r10	; LO
	add	%r1,0x1		; 	xadd %r1, %r1, 1		; SP++
	;
	ext	0x18		; 	xld.w %r10, [%r0+0x18]
	ld.w	%r10,[%r0]
	ld.uh %r13, %r1			; *anti-interlock*
	call.d %r10
	ld.w %r12, %r0			; *delay*
	ext	0x1		; 	xld.b [%r0+0x1], %r10	; HI
	ld.b	[%r0],%r10
	add	%r1,0x1		; 	xadd %r1, %r1, 1		; SP++
	;
	ext	0x8		; 	xld.h [%r0+0x8], %r1		; SP
	ld.h	[%r0],%r1
	;
	popn %r1
	ret
	.global dmgop_POP_BC
dmgop_POP_BC:
	pushn %r1	; 	POP_rr BC
	;
	ext	0x8		; 	xld.uh %r1, [%r12+0x8]		; SP
	ld.uh	%r1,[%r12]
	;
	ext	0x18		; 	xld.w %r10, [%r12+0x18]
	ld.w	%r10,[%r12]
	ld.uh %r13, %r1			; *anti-interlock*
	call.d %r10
	ld.w %r0, %r12			; *delay*
	ext	0x2		; 	xld.b [%r0+0x2], %r10	; LO
	ld.b	[%r0],%r10
	add	%r1,0x1		; 	xadd %r1, %r1, 1		; SP++
	;
	ext	0x18		; 	xld.w %r10, [%r0+0x18]
	ld.w	%r10,[%r0]
	ld.uh %r13, %r1			; *anti-interlock*
	call.d %r10
	ld.w %r12, %r0			; *delay*
	ext	0x3		; 	xld.b [%r0+0x3], %r10	; HI
	ld.b	[%r0],%r10
	add	%r1,0x1		; 	xadd %r1, %r1, 1		; SP++
	;
	ext	0x8		; 	xld.h [%r0+0x8], %r1		; SP
	ld.h	[%r0],%r1
	;
	popn %r1
	ret
	.global dmgop_POP_DE
dmgop_POP_DE:
	pushn %r1	; 	POP_rr DE
	;
	ext	0x8		; 	xld.uh %r1, [%r12+0x8]		; SP
	ld.uh	%r1,[%r12]
	;
	ext	0x18		; 	xld.w %r10, [%r12+0x18]
	ld.w	%r10,[%r12]
	ld.uh %r13, %r1			; *anti-interlock*
	call.d %r10
	ld.w %r0, %r12			; *delay*
	ext	0x4		; 	xld.b [%r0+0x4], %r10	; LO
	ld.b	[%r0],%r10
	add	%r1,0x1		; 	xadd %r1, %r1, 1		; SP++
	;
	ext	0x18		; 	xld.w %r10, [%r0+0x18]
	ld.w	%r10,[%r0]
	ld.uh %r13, %r1			; *anti-interlock*
	call.d %r10
	ld.w %r12, %r0			; *delay*
	ext	0x5		; 	xld.b [%r0+0x5], %r10	; HI
	ld.b	[%r0],%r10
	add	%r1,0x1		; 	xadd %r1, %r1, 1		; SP++
	;
	ext	0x8		; 	xld.h [%r0+0x8], %r1		; SP
	ld.h	[%r0],%r1
	;
	popn %r1
	ret
	.global dmgop_POP_HL
dmgop_POP_HL:
	pushn %r1	; 	POP_rr HL
	;
	ext	0x8		; 	xld.uh %r1, [%r12+0x8]		; SP
	ld.uh	%r1,[%r12]
	;
	ext	0x18		; 	xld.w %r10, [%r12+0x18]
	ld.w	%r10,[%r12]
	ld.uh %r13, %r1			; *anti-interlock*
	call.d %r10
	ld.w %r0, %r12			; *delay*
	ext	0x6		; 	xld.b [%r0+0x6], %r10	; LO
	ld.b	[%r0],%r10
	add	%r1,0x1		; 	xadd %r1, %r1, 1		; SP++
	;
	ext	0x18		; 	xld.w %r10, [%r0+0x18]
	ld.w	%r10,[%r0]
	ld.uh %r13, %r1			; *anti-interlock*
	call.d %r10
	ld.w %r12, %r0			; *delay*
	ext	0x7		; 	xld.b [%r0+0x7], %r10	; HI
	ld.b	[%r0],%r10
	add	%r1,0x1		; 	xadd %r1, %r1, 1		; SP++
	;
	ext	0x8		; 	xld.h [%r0+0x8], %r1		; SP
	ld.h	[%r0],%r1
	;
	popn %r1
	ret

;****************************************************************************
;	8-Bit ALU
;****************************************************************************

	.global dmg_ADD
dmg_ADD:
	ext	0x1		; 	xld.ub %r14, [%r12+0x1]			; A
	ld.ub	%r14,[%r12]
	swap %r11, %r13				; *anti-interlock*
	swap %r10, %r14
	add %r10, %r11
	;
	ld.w %r11, %psr				; F(Z,C)
	and	%r11,0xa	; 	xand %r11, %r11, 0xa
	ext	dmg_FLAG_CONV+0x0@h	; 	xld.ub %r11, [%r11+dmg_FLAG_CONV]
	ext	dmg_FLAG_CONV+0x0@m
	ld.w	%r9,dmg_FLAG_CONV+0x0@l
	add	%r9,%r11
	ld.ub	%r11,[%r9]
	;
	swap %r10, %r10				; A
	ext	0x1		; 	xld.b [%r12+0x1], %r10
	ld.b	[%r12],%r10
	;
	and	%r14,0xf	; 	xand %r14, %r14, 0xf			; F(H)
	and	%r13,0xf	; 	xand %r13, %r13, 0xf
	add %r14, %r13
	and	%r14,0x10	; 	xand %r14, %r14, 0x10
	sll	%r14,0x1	; 	xsll %r14, 1
	or %r11, %r14
	;
	ld.b	[%r12],%r11	; 	xld.b [%r12+0x0], %r11			; F
	;
	ret

	.global dmg_ADC
dmg_ADC:
	ld.ub	%r15,[%r12]	; 	xld.ub %r15, [%r12+0x0]			; F(C)
	ext	0x1		; 	xld.ub %r14, [%r12+0x1]			; A *anti-interlock*
	ld.ub	%r14,[%r12]
	srl	%r15,0x4	; 	xsrl %r15, 4
	and	%r15,0x1	; 	xand %r15, %r15, 1
	;
	swap %r10, %r14				; A + n
	swap %r11, %r13
	add %r10, %r11
	;
	ld.w %r11, %psr				; %psr(C1)
	and	%r11,0x8	; 	xand %r11, %r11, 0x8
	;
	swap %r4, %r15				; A + n + c
	add %r10, %r4
	;
	ld.w %r4, %psr				; %psr(C1|C2,Z2)
	and	%r4,0xa		; 	xand %r4, %r4, 0xa
	or %r11, %r4
	ext	dmg_FLAG_CONV+0x0@h	; 	xld.ub %r11, [%r11+dmg_FLAG_CONV]	; F(Z,C)
	ext	dmg_FLAG_CONV+0x0@m
	ld.w	%r9,dmg_FLAG_CONV+0x0@l
	add	%r9,%r11
	ld.ub	%r11,[%r9]
	;
	swap %r10, %r10				; A
	ext	0x1		; 	xld.b [%r12+0x1], %r10
	ld.b	[%r12],%r10
	;
	and	%r14,0xf	; 	xand %r14, %r14, 0xf			; F(H)
	and	%r13,0xf	; 	xand %r13, %r13, 0xf
	add %r14, %r13
	add %r14, %r15
	and	%r14,0x10	; 	xand %r14, %r14, 0x10
	sll	%r14,0x1	; 	xsll %r14, 1
	or %r11, %r14
	;
	ld.b	[%r12],%r11	; 	xld.b [%r12+0x0], %r11			; F
	;
	ret

	.global dmg_SUB
dmg_SUB:
	ext	0x1		; 	xld.ub %r14, [%r12+0x1]			; A
	ld.ub	%r14,[%r12]
	swap %r11, %r13				; *anti-interlock*
	swap %r10, %r14
	sub %r10, %r11
	;
	ld.w %r11, %psr				; F(Z,C)
	and	%r11,0xa	; 	xand %r11, %r11, 0xa
	ext	dmg_FLAG_CONV+0x0@h	; 	xld.ub %r11, [%r11+dmg_FLAG_CONV]
	ext	dmg_FLAG_CONV+0x0@m
	ld.w	%r9,dmg_FLAG_CONV+0x0@l
	add	%r9,%r11
	ld.ub	%r11,[%r9]
	;
	swap %r10, %r10				; A
	ext	0x1		; 	xld.b [%r12+0x1], %r10
	ld.b	[%r12],%r10
	;
	and	%r14,0xf	; 	xand %r14, %r14, 0xf			; F(H)
	and	%r13,0xf	; 	xand %r13, %r13, 0xf
	sub %r14, %r13
	and	%r14,0x10	; 	xand %r14, %r14, 0x10
	sll	%r14,0x1	; 	xsll %r14, 1
	or %r11, %r14
	;
	ext	0x1		; 	xoor %r11, %r11, 0x40			; F(N)
	or	%r11,0x0
	;
	ld.b	[%r12],%r11	; 	xld.b [%r12+0x0], %r11			; F
	;
	ret

	.global dmg_SBC
dmg_SBC:
	ld.ub	%r15,[%r12]	; 	xld.ub %r15, [%r12+0x0]			; F(C)
	ext	0x1		; 	xld.ub %r14, [%r12+0x1]			; A *anti-interlock*
	ld.ub	%r14,[%r12]
	srl	%r15,0x4	; 	xsrl %r15, 4
	and	%r15,0x1	; 	xand %r15, %r15, 1
	;
	swap %r10, %r14				; A - n
	swap %r11, %r13
	sub %r10, %r11
	;
	ld.w %r11, %psr				; %psr(C1)
	and	%r11,0x8	; 	xand %r11, %r11, 0x8
	;
	swap %r4, %r15				; A - n - c
	sub %r10, %r4
	;
	ld.w %r4, %psr				; %psr(C1|C2,Z2)
	and	%r4,0xa		; 	xand %r4, %r4, 0xa
	or %r11, %r4
	ext	dmg_FLAG_CONV+0x0@h	; 	xld.ub %r11, [%r11+dmg_FLAG_CONV]	; F(Z,C)
	ext	dmg_FLAG_CONV+0x0@m
	ld.w	%r9,dmg_FLAG_CONV+0x0@l
	add	%r9,%r11
	ld.ub	%r11,[%r9]
	;
	swap %r10, %r10				; A
	ext	0x1		; 	xld.b [%r12+0x1], %r10
	ld.b	[%r12],%r10
	;
	and	%r14,0xf	; 	xand %r14, %r14, 0xf			; F(H)
	and	%r13,0xf	; 	xand %r13, %r13, 0xf
	sub %r14, %r13
	sub %r14, %r15
	and	%r14,0x10	; 	xand %r14, %r14, 0x10
	sll	%r14,0x1	; 	xsll %r14, 1
	or %r11, %r14
	;
	ext	0x1		; 	xoor %r11, %r11, 0x40			; F(N)
	or	%r11,0x0
	;
	ld.b	[%r12],%r11	; 	xld.b [%r12+0x0], %r11			; F
	;
	ret

	.global dmg_AND
dmg_AND:
	ext	0x1		; 	xld.ub %r10, [%r12+0x1]			; A
	ld.ub	%r10,[%r12]
	ext	0x0		; 	xld.w %r11, 0x20			; F(H) *anti-interlock*
	ld.w	%r11,0x20
	and %r10, %r13				; A & n
	jrne	dmg_AND_L10	; 	xjrne dmg_AND_L10			; !NO-DELAY!
	ext	0x2		; 	xoor %r11, %r11, 0x80			; F(Z)
	or	%r11,0x0
dmg_AND_L10:
	ext	0x1		; 	xld.b [%r12+0x1], %r10			; A
	ld.b	[%r12],%r10
	ld.b	[%r12],%r11	; 	xld.b [%r12+0x0], %r11			; F
	ret

	.global dmg_XOR
dmg_XOR:
	ext	0x1		; 	xld.ub %r10, [%r12+0x1]			; A
	ld.ub	%r10,[%r12]
	xor %r10, %r13				; A ^ n !INTERLOCK!
	jrne.d	dmg_XOR_L10	; 	xjrne.d dmg_XOR_L10
	ld.w %r11, 0				; *delay*
	ext	0x2		; 	xoor %r11, %r11, 0x80			; F(Z)
	or	%r11,0x0
dmg_XOR_L10:
	ext	0x1		; 	xld.b [%r12+0x1], %r10			; A
	ld.b	[%r12],%r10
	ld.b	[%r12],%r11	; 	xld.b [%r12+0x0], %r11			; F
	ret

	.global dmg_OR
dmg_OR:
	ext	0x1		; 	xld.ub %r10, [%r12+0x1]			; A
	ld.ub	%r10,[%r12]
	or %r10, %r13				; A | n !INTERLOCK!
	jrne.d	dmg_OR_L10	; 	xjrne.d dmg_OR_L10
	ld.w %r11, 0				; *delay*
	ext	0x2		; 	xoor %r11, %r11, 0x80			; F(Z)
	or	%r11,0x0
dmg_OR_L10:
	ext	0x1		; 	xld.b [%r12+0x1], %r10			; A
	ld.b	[%r12],%r10
	ld.b	[%r12],%r11	; 	xld.b [%r12+0x0], %r11			; F
	ret

	.global dmg_CP
dmg_CP:
	ext	0x1		; 	xld.ub %r14, [%r12+0x1]			; A
	ld.ub	%r14,[%r12]
	swap %r11, %r13				; *anti-interlock*
	swap %r10, %r14
	cmp %r10, %r11
	;
	ld.w %r11, %psr				; F(Z,C)
	and	%r11,0xa	; 	xand %r11, %r11, 0xa
	ext	dmg_FLAG_CONV+0x0@h	; 	xld.ub %r11, [%r11+dmg_FLAG_CONV]
	ext	dmg_FLAG_CONV+0x0@m
	ld.w	%r9,dmg_FLAG_CONV+0x0@l
	add	%r9,%r11
	ld.ub	%r11,[%r9]
	;
	and	%r14,0xf	; 	xand %r14, %r14, 0xf			; F(H)
	and	%r13,0xf	; 	xand %r13, %r13, 0xf
	sub %r14, %r13
	ext	0x0		; 	xand %r14, %r14, 0x20
	and	%r14,0x20
	or %r11, %r14
	;
	ext	0x1		; 	xoor %r11, %r11, 0x40			; F(N)
	or	%r11,0x0
	;
	ld.b	[%r12],%r11	; 	xld.b [%r12+0x0], %r11			; F
	;
	ret

	;;;;;;;;;;;;;;;;;;;;;;;;
	; F(C) = KEEP
	; n++
	; n &= 0xff
	; if(n == 0x?0) {
	;   F(H) = SET
	;   if(n == 0x00) {
	;     F(Z) = SET
	;   }
	; }
	;;;;;;;;;;;;;;;;;;;;;;;;
	.global dmg_INC
dmg_INC:
	ld.ub	%r11,[%r12]	; 	xld.ub %r11, [%r12+0x0]
	add	%r13,0x1	; 	xadd %r13, %r13, 1			; n + 1 *anti-interlock*
	and	%r11,0x10	; 	xand %r11, %r11, 0x10			; F(C)
	ld.ub %r10, %r13
	;
	and	%r13,0xf	; 	xand %r13, %r13, 0xf			; Z != 0x?0 => 
	jrne	dmg_INC_L10	; 	xjrne dmg_INC_L10
	ext	0x0		; 	xoor %r11, %r11, 0x20			; F(H)
	or	%r11,0x20
	cmp %r10, 0				; Z != 0x00 => 
	jrne	dmg_INC_L10	; 	xjrne dmg_INC_L10
	ext	0x2		; 	xoor %r11, %r11, 0x80			; F(Z)
	or	%r11,0x0
dmg_INC_L10:
	;
	ld.b	[%r12],%r11	; 	xld.b [%r12+0x0], %r11			; F
	ret

	;;;;;;;;;;;;;;;;;;;;;;;;
	; F(C) = KEEP
	; n--
	; if(n == 0x00) {
	;   F(Z) = SET
	; } else {
	;   n &= 0xff
	;   if(n == 0x?f) {
	;     F(H) = SET
	;   }
	; }
	; F(N) = SET
	;;;;;;;;;;;;;;;;;;;;;;;;
	.global dmg_DEC
dmg_DEC:
	ld.ub	%r11,[%r12]	; 	xld.ub %r11, [%r12+0x0]
	sub	%r13,0x1	; 	xsub %r13, %r13, 1			; n - 1
	jrne.d	dmg_DEC_L10	; 	xjrne.d dmg_DEC_L10			; Z != 0x00 => 
	and %r11, 0x10				; F(C) *delay*
	;
	ext	0x2		; 	xoor %r11, %r11, 0x80			; F(Z)
	or	%r11,0x0
	jp.d	dmg_DEC_L20	; 	xjp.d dmg_DEC_L20
	ld.w %r10, %r13				; *delay*
	;
dmg_DEC_L10:
	ld.ub %r10, %r13
	and	%r13,0xf	; 	xand %r13, %r13, 0xf
	cmp	%r13,0xf	; 	xcmp %r13, 0xf
	jrne	dmg_DEC_L20	; 	xjrne dmg_DEC_L20			; Z != 0x?0 => 
	ext	0x0		; 	xoor %r11, %r11, 0x20			; F(H)
	or	%r11,0x20
	;
dmg_DEC_L20:
	ext	0x1		; 	xoor %r11, %r11, 0x40			; F(N)
	or	%r11,0x0
	ld.b	[%r12],%r11	; 	xld.b [%r12+0x0], %r11			; F
	ret

;****************************************************************************
;	16-Bit Arithmetic
;****************************************************************************

;****************************************************************************

	.global dmg_ADDW
dmg_ADDW:
	ld.ub	%r11,[%r12]	; 	xld.ub %r11, [%r12+0x0]			; F(Z)
	ext	0x6		; 	xld.uh %r14, [%r12+0x6]			; HL *anti-interlock*
	ld.uh	%r14,[%r12]
	ext	0x2		; 	xand %r11, %r11, 0x80
	and	%r11,0x0
	;
	ld.w %r10, %r13				; HL + nn
	add %r10, %r14
	ext	0x6		; 	xld.h [%r12+0x6], %r10			; HL
	ld.h	[%r12],%r10
	srl	%r10,0x8	; 	xsrl %r10, 12				; F(C)
	srl	%r10,0x4
	and	%r10,0x10	; 	xand %r10, %r10, 0x10
	or %r11, %r10
dmg_ADDW_L10:
	;
	ext	0x3f		; 	xand %r13, %r13, 0xfff			; F(H)
	and	%r13,0x3f
	ext	0x3f		; 	xand %r14, %r14, 0xfff
	and	%r14,0x3f
	add %r13, %r14
	srl	%r13,0x7	; 	xsrl %r13, 7
	ext	0x0		; 	xand %r13, %r13, 0x20
	and	%r13,0x20
	or %r11, %r13
	;
	ld.b	[%r12],%r11	; 	xld.b [%r12+0x0], %r11			; F
	;
	ret

;****************************************************************************

;#macro INC_rr $1
;	xld.uh %r10, [%r12+$1]
;	xadd %r10, %r10, 1
;	xld.h [%r12+$1], %r10
;	ret
;#endm

;#macro DEC_rr $1
;	xld.uh %r10, [%r12+$1]
;	xsub %r10, %r10, 1
;	xld.h [%r12+$1], %r10
;	ret
;#endm

;****************************************************************************

	.global dmgop_INC_BC
dmgop_INC_BC:
	ext	0x2		; 	xld.uh %r10, [%r12+0x2]	; 	INC_rr BC
	ld.uh	%r10,[%r12]
	add	%r10,0x1	; 	xadd %r10, %r10, 1
	ext	0x2		; 	xld.h [%r12+0x2], %r10
	ld.h	[%r12],%r10
	ret
	.global dmgop_INC_DE
dmgop_INC_DE:
	ext	0x4		; 	xld.uh %r10, [%r12+0x4]	; 	INC_rr DE
	ld.uh	%r10,[%r12]
	add	%r10,0x1	; 	xadd %r10, %r10, 1
	ext	0x4		; 	xld.h [%r12+0x4], %r10
	ld.h	[%r12],%r10
	ret
	.global dmgop_INC_HL
dmgop_INC_HL:
	ext	0x6		; 	xld.uh %r10, [%r12+0x6]	; 	INC_rr HL
	ld.uh	%r10,[%r12]
	add	%r10,0x1	; 	xadd %r10, %r10, 1
	ext	0x6		; 	xld.h [%r12+0x6], %r10
	ld.h	[%r12],%r10
	ret
	.global dmgop_INC_SP
dmgop_INC_SP:
	ext	0x8		; 	xld.uh %r10, [%r12+0x8]	; 	INC_rr SP
	ld.uh	%r10,[%r12]
	add	%r10,0x1	; 	xadd %r10, %r10, 1
	ext	0x8		; 	xld.h [%r12+0x8], %r10
	ld.h	[%r12],%r10
	ret

	.global dmgop_DEC_BC
dmgop_DEC_BC:
	ext	0x2		; 	xld.uh %r10, [%r12+0x2]	; 	DEC_rr BC
	ld.uh	%r10,[%r12]
	sub	%r10,0x1	; 	xsub %r10, %r10, 1
	ext	0x2		; 	xld.h [%r12+0x2], %r10
	ld.h	[%r12],%r10
	ret
	.global dmgop_DEC_DE
dmgop_DEC_DE:
	ext	0x4		; 	xld.uh %r10, [%r12+0x4]	; 	DEC_rr DE
	ld.uh	%r10,[%r12]
	sub	%r10,0x1	; 	xsub %r10, %r10, 1
	ext	0x4		; 	xld.h [%r12+0x4], %r10
	ld.h	[%r12],%r10
	ret
	.global dmgop_DEC_HL
dmgop_DEC_HL:
	ext	0x6		; 	xld.uh %r10, [%r12+0x6]	; 	DEC_rr HL
	ld.uh	%r10,[%r12]
	sub	%r10,0x1	; 	xsub %r10, %r10, 1
	ext	0x6		; 	xld.h [%r12+0x6], %r10
	ld.h	[%r12],%r10
	ret
	.global dmgop_DEC_SP
dmgop_DEC_SP:
	ext	0x8		; 	xld.uh %r10, [%r12+0x8]	; 	DEC_rr SP
	ld.uh	%r10,[%r12]
	sub	%r10,0x1	; 	xsub %r10, %r10, 1
	ext	0x8		; 	xld.h [%r12+0x8], %r10
	ld.h	[%r12],%r10
	ret

;****************************************************************************
;	Jumps
;****************************************************************************

;#macro JP_rr $1
;	xld.uh %r10, [%r12+$1]
;	xld.h [%r12+PC], %r10		; PC !INTERLOCK!
;	ret
;#endm

;#macro JP_cc_nn $1
;	xbtst [%r12+F], $1
;	xjreq $$1
	;
;	xld.w %r10, [%r12+CYCLE]	; CYCLE -= 4
;	xld.h [%r12+PC], %r14		; PC *anti-interlock*
;	xsub %r10, %r10, 4
;	xld.w [%r12+CYCLE], %r10
;$$1:
;	ret
;#endm

;#macro JP_Ncc_nn $1
;	xbtst [%r12+F], $1
;	xjrne $$1
	;
;	xld.w %r10, [%r12+CYCLE]	; CYCLE -= 4
;	xld.h [%r12+PC], %r14		; PC *anti-interlock*
;	xsub %r10, %r10, 4
;	xld.w [%r12+CYCLE], %r10
;$$1:
;	ret
;#endm

;#macro JR_e
;	xld.uh %r10, [%r12+PC]		; PC+e
;	ld.b %r14, %r14			; *anti-interlock*
;	add %r14, %r10
;	xld.h [%r12+PC], %r14		; PC
;	ret
;#endm

;#macro JR_c_e $1
;	xbtst [%r12+F], $1
;	xjreq $$1
	;
;	xld.uh %r10, [%r12+PC]		; PC+e
;	ld.b %r14, %r14			; *anti-interlock*
;	add %r14, %r10
	;
;	xld.w %r10, [%r12+CYCLE]	; CYCLE -= 4
;	xld.h [%r12+PC], %r14		; PC *anti-interlock*
;	xsub %r10, %r10, 4
;	xld.w [%r12+CYCLE], %r10
;$$1:
;	ret
;#endm

;#macro JR_Nc_e $1
;	xbtst [%r12+F], $1
;	xjrne $$1
	;
;	xld.uh %r10, [%r12+PC]		; PC+e
;	ld.b %r14, %r14			; *anti-interlock*
;	add %r14, %r10
	;
;	xld.w %r10, [%r12+CYCLE]	; CYCLE -= 4
;	xld.h [%r12+PC], %r14		; PC *anti-interlock*
;	xsub %r10, %r10, 4
;	xld.w [%r12+CYCLE], %r10
;$$1:
;	ret
;#endm

;****************************************************************************

	.global dmgop_JP_IHLI
dmgop_JP_IHLI:
	ext	0x6		; 	xld.uh %r10, [%r12+0x6]	; 	JP_rr HL
	ld.uh	%r10,[%r12]
	ext	0xa		; 	xld.h [%r12+0xa], %r10		; PC !INTERLOCK!
	ld.h	[%r12],%r10
	ret
	.global dmgop_JP_nn
dmgop_JP_nn:
	ext	0xa		; 	xld.h [%r12+0xa], %r14	; 	LD_rr_nn PC
	ld.h	[%r12],%r14
	ret

	.global dmgop_JP_NZ_nn
dmgop_JP_NZ_nn:
	btst	[%r12],0x7	; 	xbtst [%r12+0x0], 0x7	; 	JP_Ncc_nn 7
	jrne	__LX0001	; 	xjrne __L0001
	;
	ext	0x14		; 	xld.w %r10, [%r12+0x14]	; CYCLE -= 4
	ld.w	%r10,[%r12]
	ext	0xa		; 	xld.h [%r12+0xa], %r14		; PC *anti-interlock*
	ld.h	[%r12],%r14
	sub	%r10,0x4	; 	xsub %r10, %r10, 4
	ext	0x14		; 	xld.w [%r12+0x14], %r10
	ld.w	[%r12],%r10
__LX0001:				; __L0001:
	ret
	.global dmgop_JP_Z_nn
dmgop_JP_Z_nn:
	btst	[%r12],0x7	; 	xbtst [%r12+0x0], 0x7	; 	JP_cc_nn 7
	jreq	__LX0002	; 	xjreq __L0002
	;
	ext	0x14		; 	xld.w %r10, [%r12+0x14]	; CYCLE -= 4
	ld.w	%r10,[%r12]
	ext	0xa		; 	xld.h [%r12+0xa], %r14		; PC *anti-interlock*
	ld.h	[%r12],%r14
	sub	%r10,0x4	; 	xsub %r10, %r10, 4
	ext	0x14		; 	xld.w [%r12+0x14], %r10
	ld.w	[%r12],%r10
__LX0002:				; __L0002:
	ret
	.global dmgop_JP_NC_nn
dmgop_JP_NC_nn:
	btst	[%r12],0x4	; 	xbtst [%r12+0x0], 0x4	; 	JP_Ncc_nn 4
	jrne	__LX0003	; 	xjrne __L0003
	;
	ext	0x14		; 	xld.w %r10, [%r12+0x14]	; CYCLE -= 4
	ld.w	%r10,[%r12]
	ext	0xa		; 	xld.h [%r12+0xa], %r14		; PC *anti-interlock*
	ld.h	[%r12],%r14
	sub	%r10,0x4	; 	xsub %r10, %r10, 4
	ext	0x14		; 	xld.w [%r12+0x14], %r10
	ld.w	[%r12],%r10
__LX0003:				; __L0003:
	ret
	.global dmgop_JP_C_nn
dmgop_JP_C_nn:
	btst	[%r12],0x4	; 	xbtst [%r12+0x0], 0x4	; 	JP_cc_nn 4
	jreq	__LX0004	; 	xjreq __L0004
	;
	ext	0x14		; 	xld.w %r10, [%r12+0x14]	; CYCLE -= 4
	ld.w	%r10,[%r12]
	ext	0xa		; 	xld.h [%r12+0xa], %r14		; PC *anti-interlock*
	ld.h	[%r12],%r14
	sub	%r10,0x4	; 	xsub %r10, %r10, 4
	ext	0x14		; 	xld.w [%r12+0x14], %r10
	ld.w	[%r12],%r10
__LX0004:				; __L0004:
	ret

	.global dmgop_JR_e
dmgop_JR_e:
	ext	0xa		; 	xld.uh %r10, [%r12+0xa]		; PC+e	; 	JR_e
	ld.uh	%r10,[%r12]
	ld.b %r14, %r14			; *anti-interlock*
	add %r14, %r10
	ext	0xa		; 	xld.h [%r12+0xa], %r14		; PC
	ld.h	[%r12],%r14
	ret

	.global dmgop_JR_NZ_e
dmgop_JR_NZ_e:
	btst	[%r12],0x7	; 	xbtst [%r12+0x0], 0x7	; 	JR_Nc_e 7
	jrne	__LX0005	; 	xjrne __L0005
	;
	ext	0xa		; 	xld.uh %r10, [%r12+0xa]		; PC+e
	ld.uh	%r10,[%r12]
	ld.b %r14, %r14			; *anti-interlock*
	add %r14, %r10
	;
	ext	0x14		; 	xld.w %r10, [%r12+0x14]	; CYCLE -= 4
	ld.w	%r10,[%r12]
	ext	0xa		; 	xld.h [%r12+0xa], %r14		; PC *anti-interlock*
	ld.h	[%r12],%r14
	sub	%r10,0x4	; 	xsub %r10, %r10, 4
	ext	0x14		; 	xld.w [%r12+0x14], %r10
	ld.w	[%r12],%r10
__LX0005:				; __L0005:
	ret
	.global dmgop_JR_Z_e
dmgop_JR_Z_e:
	btst	[%r12],0x7	; 	xbtst [%r12+0x0], 0x7	; 	JR_c_e 7
	jreq	__LX0006	; 	xjreq __L0006
	;
	ext	0xa		; 	xld.uh %r10, [%r12+0xa]		; PC+e
	ld.uh	%r10,[%r12]
	ld.b %r14, %r14			; *anti-interlock*
	add %r14, %r10
	;
	ext	0x14		; 	xld.w %r10, [%r12+0x14]	; CYCLE -= 4
	ld.w	%r10,[%r12]
	ext	0xa		; 	xld.h [%r12+0xa], %r14		; PC *anti-interlock*
	ld.h	[%r12],%r14
	sub	%r10,0x4	; 	xsub %r10, %r10, 4
	ext	0x14		; 	xld.w [%r12+0x14], %r10
	ld.w	[%r12],%r10
__LX0006:				; __L0006:
	ret
	.global dmgop_JR_NC_e
dmgop_JR_NC_e:
	btst	[%r12],0x4	; 	xbtst [%r12+0x0], 0x4	; 	JR_Nc_e 4
	jrne	__LX0007	; 	xjrne __L0007
	;
	ext	0xa		; 	xld.uh %r10, [%r12+0xa]		; PC+e
	ld.uh	%r10,[%r12]
	ld.b %r14, %r14			; *anti-interlock*
	add %r14, %r10
	;
	ext	0x14		; 	xld.w %r10, [%r12+0x14]	; CYCLE -= 4
	ld.w	%r10,[%r12]
	ext	0xa		; 	xld.h [%r12+0xa], %r14		; PC *anti-interlock*
	ld.h	[%r12],%r14
	sub	%r10,0x4	; 	xsub %r10, %r10, 4
	ext	0x14		; 	xld.w [%r12+0x14], %r10
	ld.w	[%r12],%r10
__LX0007:				; __L0007:
	ret
	.global dmgop_JR_C_e
dmgop_JR_C_e:
	btst	[%r12],0x4	; 	xbtst [%r12+0x0], 0x4	; 	JR_c_e 4
	jreq	__LX0008	; 	xjreq __L0008
	;
	ext	0xa		; 	xld.uh %r10, [%r12+0xa]		; PC+e
	ld.uh	%r10,[%r12]
	ld.b %r14, %r14			; *anti-interlock*
	add %r14, %r10
	;
	ext	0x14		; 	xld.w %r10, [%r12+0x14]	; CYCLE -= 4
	ld.w	%r10,[%r12]
	ext	0xa		; 	xld.h [%r12+0xa], %r14		; PC *anti-interlock*
	ld.h	[%r12],%r14
	sub	%r10,0x4	; 	xsub %r10, %r10, 4
	ext	0x14		; 	xld.w [%r12+0x14], %r10
	ld.w	[%r12],%r10
__LX0008:				; __L0008:
	ret

;****************************************************************************
;	Calls
;****************************************************************************

;#macro CALL_nn
;	pushn %r2
	;
;	ld.w %r2, %r14			; nn
	;
;	xld.uh %r1, [%r12+SP]		; SP
	;
;	xld.w %r10, [%r12+WRITE]
;	xsub %r1, %r1, 1		; SP--
;	ld.uh %r13, %r1
;	xld.ub %r14, [%r12+(PC+1)]	; HI(PC)
;	call.d %r10
;	ld.w %r0, %r12			; *delay*
	;
;	xld.w %r10, [%r0+WRITE]
;	xsub %r1, %r1, 1		; SP--
;	ld.uh %r13, %r1
;	xld.ub %r14, [%r0+(PC+0)]	; LO(PC)
;	call.d %r10
;	ld.w %r12, %r0			; *delay*
	;
;	xld.h [%r0+SP], %r1		; SP
	;
;	xld.h [%r0+PC], %r2		; PC
	;
;	popn %r2
;	ret
;#endm

;#macro CALL_c_nn $1
;	xbtst [%r12+F], $1
;	xjreq $$1
	;
;	pushn %r2
	;
;	ld.w %r2, %r14			; nn
	;
;	xld.uh %r1, [%r12+SP]		; SP
	;
;	xld.w %r10, [%r12+WRITE]
;	xsub %r1, %r1, 1		; SP--
;	ld.uh %r13, %r1
;	xld.ub %r14, [%r12+(PC+1)]	; HI(PC)
;	call.d %r10
;	ld.w %r0, %r12			; *delay*
	;
;	xld.w %r10, [%r0+WRITE]
;	xsub %r1, %r1, 1		; SP--
;	ld.uh %r13, %r1
;	xld.ub %r14, [%r0+(PC+0)]	; LO(PC)
;	call.d %r10
;	ld.w %r12, %r0			; *delay*
	;
;	xld.h [%r0+SP], %r1		; SP
	;
;	xld.w %r10, [%r0+CYCLE]		; CYCLE -= 12
;	xld.h [%r0+PC], %r2		; PC *anti-interlock*
;	xsub %r10, %r10, 12
;	xld.w [%r0+CYCLE], %r10
	;
;	popn %r2
;$$1:
;	ret
;#endm

;#macro CALL_Nc_nn $1
;	xbtst [%r12+F], $1
;	xjrne $$1
	;
;	pushn %r2
	;
;	ld.w %r2, %r14			; nn
	;
;	xld.uh %r1, [%r12+SP]		; SP
	;
;	xld.w %r10, [%r12+WRITE]
;	xsub %r1, %r1, 1		; SP--
;	ld.uh %r13, %r1
;	xld.ub %r14, [%r12+(PC+1)]	; HI(PC)
;	call.d %r10
;	ld.w %r0, %r12			; *delay*
	;
;	xld.w %r10, [%r0+WRITE]
;	xsub %r1, %r1, 1		; SP--
;	ld.uh %r13, %r1
;	xld.ub %r14, [%r0+(PC+0)]	; LO(PC)
;	call.d %r10
;	ld.w %r12, %r0			; *delay*
	;
;	xld.h [%r0+SP], %r1		; SP
	;
;	xld.w %r10, [%r0+CYCLE]		; CYCLE -= 12
;	xld.h [%r0+PC], %r2		; PC *anti-interlock*
;	xsub %r10, %r10, 12
;	xld.w [%r0+CYCLE], %r10
	;
;	popn %r2
;$$1:
;	ret
;#endm

;****************************************************************************

	.global dmgop_CALL_nn
dmgop_CALL_nn:
	pushn %r2	; 	CALL_nn
	;
	ld.w %r2, %r14			; nn
	;
	ext	0x8		; 	xld.uh %r1, [%r12+0x8]		; SP
	ld.uh	%r1,[%r12]
	;
	ext	0x1c		; 	xld.w %r10, [%r12+0x1c]
	ld.w	%r10,[%r12]
	sub	%r1,0x1		; 	xsub %r1, %r1, 1		; SP--
	ld.uh %r13, %r1
	ext	0xb		; 	xld.ub %r14, [%r12+0xb]	; HI(PC)
	ld.ub	%r14,[%r12]
	call.d %r10
	ld.w %r0, %r12			; *delay*
	;
	ext	0x1c		; 	xld.w %r10, [%r0+0x1c]
	ld.w	%r10,[%r0]
	sub	%r1,0x1		; 	xsub %r1, %r1, 1		; SP--
	ld.uh %r13, %r1
	ext	0xa		; 	xld.ub %r14, [%r0+0xa]	; LO(PC)
	ld.ub	%r14,[%r0]
	call.d %r10
	ld.w %r12, %r0			; *delay*
	;
	ext	0x8		; 	xld.h [%r0+0x8], %r1		; SP
	ld.h	[%r0],%r1
	;
	ext	0xa		; 	xld.h [%r0+0xa], %r2		; PC
	ld.h	[%r0],%r2
	;
	popn %r2
	ret

	.global dmgop_CALL_NZ_nn
dmgop_CALL_NZ_nn:
	btst	[%r12],0x7	; 	xbtst [%r12+0x0], 0x7	; 	CALL_Nc_nn 7
	jrne	__LX0009	; 	xjrne __L0009
	;
	pushn %r2
	;
	ld.w %r2, %r14			; nn
	;
	ext	0x8		; 	xld.uh %r1, [%r12+0x8]		; SP
	ld.uh	%r1,[%r12]
	;
	ext	0x1c		; 	xld.w %r10, [%r12+0x1c]
	ld.w	%r10,[%r12]
	sub	%r1,0x1		; 	xsub %r1, %r1, 1		; SP--
	ld.uh %r13, %r1
	ext	0xb		; 	xld.ub %r14, [%r12+0xb]	; HI(PC)
	ld.ub	%r14,[%r12]
	call.d %r10
	ld.w %r0, %r12			; *delay*
	;
	ext	0x1c		; 	xld.w %r10, [%r0+0x1c]
	ld.w	%r10,[%r0]
	sub	%r1,0x1		; 	xsub %r1, %r1, 1		; SP--
	ld.uh %r13, %r1
	ext	0xa		; 	xld.ub %r14, [%r0+0xa]	; LO(PC)
	ld.ub	%r14,[%r0]
	call.d %r10
	ld.w %r12, %r0			; *delay*
	;
	ext	0x8		; 	xld.h [%r0+0x8], %r1		; SP
	ld.h	[%r0],%r1
	;
	ext	0x14		; 	xld.w %r10, [%r0+0x14]		; CYCLE -= 12
	ld.w	%r10,[%r0]
	ext	0xa		; 	xld.h [%r0+0xa], %r2		; PC *anti-interlock*
	ld.h	[%r0],%r2
	sub	%r10,0xc	; 	xsub %r10, %r10, 12
	ext	0x14		; 	xld.w [%r0+0x14], %r10
	ld.w	[%r0],%r10
	;
	popn %r2
__LX0009:				; __L0009:
	ret
	.global dmgop_CALL_Z_nn
dmgop_CALL_Z_nn:
	btst	[%r12],0x7	; 	xbtst [%r12+0x0], 0x7	; 	CALL_c_nn 7
	jreq	__LX0010	; 	xjreq __L0010
	;
	pushn %r2
	;
	ld.w %r2, %r14			; nn
	;
	ext	0x8		; 	xld.uh %r1, [%r12+0x8]		; SP
	ld.uh	%r1,[%r12]
	;
	ext	0x1c		; 	xld.w %r10, [%r12+0x1c]
	ld.w	%r10,[%r12]
	sub	%r1,0x1		; 	xsub %r1, %r1, 1		; SP--
	ld.uh %r13, %r1
	ext	0xb		; 	xld.ub %r14, [%r12+0xb]	; HI(PC)
	ld.ub	%r14,[%r12]
	call.d %r10
	ld.w %r0, %r12			; *delay*
	;
	ext	0x1c		; 	xld.w %r10, [%r0+0x1c]
	ld.w	%r10,[%r0]
	sub	%r1,0x1		; 	xsub %r1, %r1, 1		; SP--
	ld.uh %r13, %r1
	ext	0xa		; 	xld.ub %r14, [%r0+0xa]	; LO(PC)
	ld.ub	%r14,[%r0]
	call.d %r10
	ld.w %r12, %r0			; *delay*
	;
	ext	0x8		; 	xld.h [%r0+0x8], %r1		; SP
	ld.h	[%r0],%r1
	;
	ext	0x14		; 	xld.w %r10, [%r0+0x14]		; CYCLE -= 12
	ld.w	%r10,[%r0]
	ext	0xa		; 	xld.h [%r0+0xa], %r2		; PC *anti-interlock*
	ld.h	[%r0],%r2
	sub	%r10,0xc	; 	xsub %r10, %r10, 12
	ext	0x14		; 	xld.w [%r0+0x14], %r10
	ld.w	[%r0],%r10
	;
	popn %r2
__LX0010:				; __L0010:
	ret
	.global dmgop_CALL_NC_nn
dmgop_CALL_NC_nn:
	btst	[%r12],0x4	; 	xbtst [%r12+0x0], 0x4	; 	CALL_Nc_nn 4
	jrne	__LX0011	; 	xjrne __L0011
	;
	pushn %r2
	;
	ld.w %r2, %r14			; nn
	;
	ext	0x8		; 	xld.uh %r1, [%r12+0x8]		; SP
	ld.uh	%r1,[%r12]
	;
	ext	0x1c		; 	xld.w %r10, [%r12+0x1c]
	ld.w	%r10,[%r12]
	sub	%r1,0x1		; 	xsub %r1, %r1, 1		; SP--
	ld.uh %r13, %r1
	ext	0xb		; 	xld.ub %r14, [%r12+0xb]	; HI(PC)
	ld.ub	%r14,[%r12]
	call.d %r10
	ld.w %r0, %r12			; *delay*
	;
	ext	0x1c		; 	xld.w %r10, [%r0+0x1c]
	ld.w	%r10,[%r0]
	sub	%r1,0x1		; 	xsub %r1, %r1, 1		; SP--
	ld.uh %r13, %r1
	ext	0xa		; 	xld.ub %r14, [%r0+0xa]	; LO(PC)
	ld.ub	%r14,[%r0]
	call.d %r10
	ld.w %r12, %r0			; *delay*
	;
	ext	0x8		; 	xld.h [%r0+0x8], %r1		; SP
	ld.h	[%r0],%r1
	;
	ext	0x14		; 	xld.w %r10, [%r0+0x14]		; CYCLE -= 12
	ld.w	%r10,[%r0]
	ext	0xa		; 	xld.h [%r0+0xa], %r2		; PC *anti-interlock*
	ld.h	[%r0],%r2
	sub	%r10,0xc	; 	xsub %r10, %r10, 12
	ext	0x14		; 	xld.w [%r0+0x14], %r10
	ld.w	[%r0],%r10
	;
	popn %r2
__LX0011:				; __L0011:
	ret
	.global dmgop_CALL_C_nn
dmgop_CALL_C_nn:
	btst	[%r12],0x4	; 	xbtst [%r12+0x0], 0x4	; 	CALL_c_nn 4
	jreq	__LX0012	; 	xjreq __L0012
	;
	pushn %r2
	;
	ld.w %r2, %r14			; nn
	;
	ext	0x8		; 	xld.uh %r1, [%r12+0x8]		; SP
	ld.uh	%r1,[%r12]
	;
	ext	0x1c		; 	xld.w %r10, [%r12+0x1c]
	ld.w	%r10,[%r12]
	sub	%r1,0x1		; 	xsub %r1, %r1, 1		; SP--
	ld.uh %r13, %r1
	ext	0xb		; 	xld.ub %r14, [%r12+0xb]	; HI(PC)
	ld.ub	%r14,[%r12]
	call.d %r10
	ld.w %r0, %r12			; *delay*
	;
	ext	0x1c		; 	xld.w %r10, [%r0+0x1c]
	ld.w	%r10,[%r0]
	sub	%r1,0x1		; 	xsub %r1, %r1, 1		; SP--
	ld.uh %r13, %r1
	ext	0xa		; 	xld.ub %r14, [%r0+0xa]	; LO(PC)
	ld.ub	%r14,[%r0]
	call.d %r10
	ld.w %r12, %r0			; *delay*
	;
	ext	0x8		; 	xld.h [%r0+0x8], %r1		; SP
	ld.h	[%r0],%r1
	;
	ext	0x14		; 	xld.w %r10, [%r0+0x14]		; CYCLE -= 12
	ld.w	%r10,[%r0]
	ext	0xa		; 	xld.h [%r0+0xa], %r2		; PC *anti-interlock*
	ld.h	[%r0],%r2
	sub	%r10,0xc	; 	xsub %r10, %r10, 12
	ext	0x14		; 	xld.w [%r0+0x14], %r10
	ld.w	[%r0],%r10
	;
	popn %r2
__LX0012:				; __L0012:
	ret

;****************************************************************************
;	Returns
;****************************************************************************

;#macro RET
;	pushn %r1
	;
;	xld.uh %r1, [%r12+SP]		; SP
	;
;	xld.w %r10, [%r12+READ]
;	ld.uh %r13, %r1			; *anti-interlock*
;	call.d %r10
;	ld.w %r0, %r12			; *delay*
;	xld.b [%r0+(PC+0)], %r10	; LO(PC)
;	xadd %r1, %r1, 1		; SP++
	;
;	xld.w %r10, [%r0+READ]
;	ld.uh %r13, %r1			; *anti-interlock*
;	call.d %r10
;	ld.w %r12, %r0			; *delay*
;	xld.b [%r0+(PC+1)], %r10	; HI(PC)
;	xadd %r1, %r1, 1		; SP++
	;
;	xld.h [%r0+SP], %r1		; SP
	;
;	popn %r1
;	ret
;#endm

;#macro RET_c $1
;	xbtst [%r12+F], $1
;	xjreq $$1
	;
;	pushn %r1
	;
;	xld.uh %r1, [%r12+SP]		; SP
	;
;	xld.w %r10, [%r12+READ]
;	ld.uh %r13, %r1			; *anti-interlock*
;	call.d %r10
;	ld.w %r0, %r12			; *delay*
;	xld.b [%r0+(PC+0)], %r10	; LO(PC)
;	xadd %r1, %r1, 1		; SP++
	;
;	xld.w %r10, [%r0+READ]
;	ld.uh %r13, %r1			; *anti-interlock*
;	call.d %r10
;	ld.w %r12, %r0			; *delay*
;	xld.b [%r0+(PC+1)], %r10	; HI(PC)
;	xadd %r1, %r1, 1		; SP++
	;
;	xld.w %r10, [%r0+CYCLE]		; CYCLE -= 12
;	xld.h [%r0+SP], %r1		; SP *anti-interlock*
;	xsub %r10, %r10, 12
;	xld.w [%r0+CYCLE], %r10
	;
;	popn %r1
;$$1:
;	ret
;#endm

;#macro RET_Nc $1
;	xbtst [%r12+F], $1
;	xjrne $$1
	;
;	pushn %r1
	;
;	xld.uh %r1, [%r12+SP]		; SP
	;
;	xld.w %r10, [%r12+READ]
;	ld.uh %r13, %r1			; *anti-interlock*
;	call.d %r10
;	ld.w %r0, %r12			; *delay*
;	xld.b [%r0+(PC+0)], %r10	; LO(PC)
;	xadd %r1, %r1, 1		; SP++
	;
;	xld.w %r10, [%r0+READ]
;	ld.uh %r13, %r1			; *anti-interlock*
;	call.d %r10
;	ld.w %r12, %r0			; *delay*
;	xld.b [%r0+(PC+1)], %r10	; HI(PC)
;	xadd %r1, %r1, 1		; SP++
	;
;	xld.w %r10, [%r0+CYCLE]		; CYCLE -= 12
;	xld.h [%r0+SP], %r1		; SP *anti-interlock*
;	xsub %r10, %r10, 12
;	xld.w [%r0+CYCLE], %r10
	;
;	popn %r1
;$$1:
;	ret
;#endm

;****************************************************************************

	.global dmgop_RET
dmgop_RET:
	pushn %r1	; 	RET
	;
	ext	0x8		; 	xld.uh %r1, [%r12+0x8]		; SP
	ld.uh	%r1,[%r12]
	;
	ext	0x18		; 	xld.w %r10, [%r12+0x18]
	ld.w	%r10,[%r12]
	ld.uh %r13, %r1			; *anti-interlock*
	call.d %r10
	ld.w %r0, %r12			; *delay*
	ext	0xa		; 	xld.b [%r0+0xa], %r10	; LO(PC)
	ld.b	[%r0],%r10
	add	%r1,0x1		; 	xadd %r1, %r1, 1		; SP++
	;
	ext	0x18		; 	xld.w %r10, [%r0+0x18]
	ld.w	%r10,[%r0]
	ld.uh %r13, %r1			; *anti-interlock*
	call.d %r10
	ld.w %r12, %r0			; *delay*
	ext	0xb		; 	xld.b [%r0+0xb], %r10	; HI(PC)
	ld.b	[%r0],%r10
	add	%r1,0x1		; 	xadd %r1, %r1, 1		; SP++
	;
	ext	0x8		; 	xld.h [%r0+0x8], %r1		; SP
	ld.h	[%r0],%r1
	;
	popn %r1
	ret

	.global dmgop_RET_NZ
dmgop_RET_NZ:
	btst	[%r12],0x7	; 	xbtst [%r12+0x0], 0x7	; 	RET_Nc 7
	jrne	__LX0013	; 	xjrne __L0013
	;
	pushn %r1
	;
	ext	0x8		; 	xld.uh %r1, [%r12+0x8]		; SP
	ld.uh	%r1,[%r12]
	;
	ext	0x18		; 	xld.w %r10, [%r12+0x18]
	ld.w	%r10,[%r12]
	ld.uh %r13, %r1			; *anti-interlock*
	call.d %r10
	ld.w %r0, %r12			; *delay*
	ext	0xa		; 	xld.b [%r0+0xa], %r10	; LO(PC)
	ld.b	[%r0],%r10
	add	%r1,0x1		; 	xadd %r1, %r1, 1		; SP++
	;
	ext	0x18		; 	xld.w %r10, [%r0+0x18]
	ld.w	%r10,[%r0]
	ld.uh %r13, %r1			; *anti-interlock*
	call.d %r10
	ld.w %r12, %r0			; *delay*
	ext	0xb		; 	xld.b [%r0+0xb], %r10	; HI(PC)
	ld.b	[%r0],%r10
	add	%r1,0x1		; 	xadd %r1, %r1, 1		; SP++
	;
	ext	0x14		; 	xld.w %r10, [%r0+0x14]		; CYCLE -= 12
	ld.w	%r10,[%r0]
	ext	0x8		; 	xld.h [%r0+0x8], %r1		; SP *anti-interlock*
	ld.h	[%r0],%r1
	sub	%r10,0xc	; 	xsub %r10, %r10, 12
	ext	0x14		; 	xld.w [%r0+0x14], %r10
	ld.w	[%r0],%r10
	;
	popn %r1
__LX0013:				; __L0013:
	ret
	.global dmgop_RET_Z
dmgop_RET_Z:
	btst	[%r12],0x7	; 	xbtst [%r12+0x0], 0x7	; 	RET_c 7
	jreq	__LX0014	; 	xjreq __L0014
	;
	pushn %r1
	;
	ext	0x8		; 	xld.uh %r1, [%r12+0x8]		; SP
	ld.uh	%r1,[%r12]
	;
	ext	0x18		; 	xld.w %r10, [%r12+0x18]
	ld.w	%r10,[%r12]
	ld.uh %r13, %r1			; *anti-interlock*
	call.d %r10
	ld.w %r0, %r12			; *delay*
	ext	0xa		; 	xld.b [%r0+0xa], %r10	; LO(PC)
	ld.b	[%r0],%r10
	add	%r1,0x1		; 	xadd %r1, %r1, 1		; SP++
	;
	ext	0x18		; 	xld.w %r10, [%r0+0x18]
	ld.w	%r10,[%r0]
	ld.uh %r13, %r1			; *anti-interlock*
	call.d %r10
	ld.w %r12, %r0			; *delay*
	ext	0xb		; 	xld.b [%r0+0xb], %r10	; HI(PC)
	ld.b	[%r0],%r10
	add	%r1,0x1		; 	xadd %r1, %r1, 1		; SP++
	;
	ext	0x14		; 	xld.w %r10, [%r0+0x14]		; CYCLE -= 12
	ld.w	%r10,[%r0]
	ext	0x8		; 	xld.h [%r0+0x8], %r1		; SP *anti-interlock*
	ld.h	[%r0],%r1
	sub	%r10,0xc	; 	xsub %r10, %r10, 12
	ext	0x14		; 	xld.w [%r0+0x14], %r10
	ld.w	[%r0],%r10
	;
	popn %r1
__LX0014:				; __L0014:
	ret
	.global dmgop_RET_NC
dmgop_RET_NC:
	btst	[%r12],0x4	; 	xbtst [%r12+0x0], 0x4	; 	RET_Nc 4
	jrne	__LX0015	; 	xjrne __L0015
	;
	pushn %r1
	;
	ext	0x8		; 	xld.uh %r1, [%r12+0x8]		; SP
	ld.uh	%r1,[%r12]
	;
	ext	0x18		; 	xld.w %r10, [%r12+0x18]
	ld.w	%r10,[%r12]
	ld.uh %r13, %r1			; *anti-interlock*
	call.d %r10
	ld.w %r0, %r12			; *delay*
	ext	0xa		; 	xld.b [%r0+0xa], %r10	; LO(PC)
	ld.b	[%r0],%r10
	add	%r1,0x1		; 	xadd %r1, %r1, 1		; SP++
	;
	ext	0x18		; 	xld.w %r10, [%r0+0x18]
	ld.w	%r10,[%r0]
	ld.uh %r13, %r1			; *anti-interlock*
	call.d %r10
	ld.w %r12, %r0			; *delay*
	ext	0xb		; 	xld.b [%r0+0xb], %r10	; HI(PC)
	ld.b	[%r0],%r10
	add	%r1,0x1		; 	xadd %r1, %r1, 1		; SP++
	;
	ext	0x14		; 	xld.w %r10, [%r0+0x14]		; CYCLE -= 12
	ld.w	%r10,[%r0]
	ext	0x8		; 	xld.h [%r0+0x8], %r1		; SP *anti-interlock*
	ld.h	[%r0],%r1
	sub	%r10,0xc	; 	xsub %r10, %r10, 12
	ext	0x14		; 	xld.w [%r0+0x14], %r10
	ld.w	[%r0],%r10
	;
	popn %r1
__LX0015:				; __L0015:
	ret
	.global dmgop_RET_C
dmgop_RET_C:
	btst	[%r12],0x4	; 	xbtst [%r12+0x0], 0x4	; 	RET_c 4
	jreq	__LX0016	; 	xjreq __L0016
	;
	pushn %r1
	;
	ext	0x8		; 	xld.uh %r1, [%r12+0x8]		; SP
	ld.uh	%r1,[%r12]
	;
	ext	0x18		; 	xld.w %r10, [%r12+0x18]
	ld.w	%r10,[%r12]
	ld.uh %r13, %r1			; *anti-interlock*
	call.d %r10
	ld.w %r0, %r12			; *delay*
	ext	0xa		; 	xld.b [%r0+0xa], %r10	; LO(PC)
	ld.b	[%r0],%r10
	add	%r1,0x1		; 	xadd %r1, %r1, 1		; SP++
	;
	ext	0x18		; 	xld.w %r10, [%r0+0x18]
	ld.w	%r10,[%r0]
	ld.uh %r13, %r1			; *anti-interlock*
	call.d %r10
	ld.w %r12, %r0			; *delay*
	ext	0xb		; 	xld.b [%r0+0xb], %r10	; HI(PC)
	ld.b	[%r0],%r10
	add	%r1,0x1		; 	xadd %r1, %r1, 1		; SP++
	;
	ext	0x14		; 	xld.w %r10, [%r0+0x14]		; CYCLE -= 12
	ld.w	%r10,[%r0]
	ext	0x8		; 	xld.h [%r0+0x8], %r1		; SP *anti-interlock*
	ld.h	[%r0],%r1
	sub	%r10,0xc	; 	xsub %r10, %r10, 12
	ext	0x14		; 	xld.w [%r0+0x14], %r10
	ld.w	[%r0],%r10
	;
	popn %r1
__LX0016:				; __L0016:
	ret

;****************************************************************************
;
;****************************************************************************

;#endif /*DMG_ASM*/
