/*	
 *	clipwin.c
 *
 *	Windowsp[`W߂܂B
 *
 *	CLiP - Common Library for P/ECE
 *	Copyright (C) 2017 Naoyuki Sawa
 *
 *	* Wed Aug 16 22:59:27 JST 2017 Naoyuki Sawa
 *	- clipwin.h,clipwin.cjāAOőSʂ̃W[ƂāAclipwin.h,clipwin.c쐬Jn܂B
 *	  ڍׂ́Aȉ̒ʂłB
 *	- clipwin.h,clipwin.ćA2002NɁAP/ECE APIƌ݊APIWindowsŎړIō쐬Ă̂łB
 *	  ̌AقƂǍ쐬i܂Ȃ܂܁AĂ܂B
 *	  ܂AۂWindowspvOɂĂAP/ECE APIƌ݊APIWindowsŎgpʂ́AL܂łB
 *	  ȂȂAP/ECE API̎dlł͒ᐅ̋@\߂āAWindowspvOŎgpɂ͏XghłB
 *	  ǁAclipwin.h,clipwin.ćAgp,libclipɂ܂߂,RpCɁAcĂłB
 *	- ۂ̏AP/ECE APIƌ݊APIAclippce.cW[ɑ݂P/ECEL̋@\WindowsŎgpP[X̕łB
 *	  ŁAclippce.cW[ɑ݂P/ECEL̋@\̓AWindowsŎgp@\郂W[ƂāAclipwin.h,clipwin.cʒut鎖ɂ܂B
 *	- ݂̏AɁAWindowsŎgp@\́Astream_play(),stream_stop()łB
 *	  stream_play(),stream_stop()gpo΁AɈˑTEhhCo(clipmod.cclipadp.cȂ)AWindowsłg悤ɂȂ鎖ҏo邩łB
 *	  ܂́Astream_play(),stream_stop()ǍAclippce.ĉ̑̋@\̓Ag@\AKvɉāAW[ɎčsƎv܂B
 *	- AύXJnOɁAclipwin.h,clipwin.cAu22_clipwin_h_clipwin_c_prύXOۑ.20170816vɕۑĂ܂B
 *	  Oq̒ʂAclipwin.h,clipwin.c͂܂łgĂȂ̂ŁAQƂKv鎖͖Ǝv܂AÔ߂łB
 *	  ܂lɁAclip.dsp,clip.dswgĂȂ̂ŁAu22_clipwin_h_clipwin_c_prύXOۑ.20170816vɕۑĂ܂B
 *	  clip.dsp,clip.dsẃA2002NCLiPCuWindowspɃrh邽߂ɈꎞgpĂVC++6.0pvWFNgłǍシɎgpȂȂ蒷ԃeiXĂ炸gȂȂĂ܂B
 *	  ݂́AWindowspCLiPCũrh́Alibclip/,libclip.x64/,libclip.net/ōsĂAclip.dsp,clip.dswgp鎖͂L܂B
 *	  Aclip.dsp,clip.dswQƂKv鎖͖Ǝv܂AÔ߁AL̃tH_ɕۑĂɂ܂B
 */
#include "clip.h"
//*****************************************************************************
//	[eBeBFXg[Đ
//*****************************************************************************
#define BLKN			4		//ubNFA2ȏBP/ECEł2ŏ[AWindowsł2ł͉؂ꂪBAP/ECE̊荞݂AWindows̃ReLXgXCb`̕AԂ|邩炾ƎvB3ł肬ԂɍA]T4ɂ鎖ɂB
//-----------------------------------------------------------------------------
typedef struct _STREAMINFO {
	volatile unsigned char	playing;	//ĐtO
	HWAVEOUT		hwo;		//EF[utH[I[fBIo̓foCX̃nh			P/ECEṒApceWaveDataOut()̏ochɑB
	int			BLKS;		//R[obN񓖂̓WJTv
	WAVEHDR			wh[BLKN];	//EF[utH[I[fBIf[^ubNʂWAVEHDR\	P/ECEṒAPCEWAVEINFOɑB
	STREAMCALLBACK*		callback;	//TvWJR[obN
	intptr_t		param;		//R[obNւ̔CӃp[^
} STREAMINFO;
static STREAMINFO		stream_info;
static STREAMFILTER*		stream_filter;
//-----------------------------------------------------------------------------
static void stream_fill(WAVEHDR* pwh) {		//stream_fill()́AP/ECEł͑SĂ̋󂫃ubNɃf[^𖞂֐łAWindowsł͎w肳ꂽ̋󂫃ubNɃf[^𖞂֐łB
	STREAMINFO* const si = &stream_info;
	//R[obNĂяoāATvWJ܂B
	short* wbuff = (short*)pwh->lpData;
	if(!(*si->callback)(wbuff, si->param)) {
		//WJɐAXg[tB^֐΁As܂B
		if(stream_filter) { (*stream_filter)(wbuff, si->BLKS); }
	} else {
		//WJɎsAɂ܂B(tIorf[^ĂH)
		memset(wbuff, 0, sizeof(short) * si->BLKS);
	}
}
//-----------------------------------------------------------------------------
static void CALLBACK waveOutProc(HWAVEOUT hwo, UINT uMsg, DWORD_PTR dwInstance, DWORD_PTR dwParam1, DWORD_PTR dwParam2) {
	//WOM_DONEAWOM_OPEN,WOM_CLOSE͖܂B
	if(uMsg == WOM_DONE) {
		STREAMINFO* const si = (STREAMINFO*)dwInstance;
		WAVEHDR* const pwh = (WAVEHDR*)dwParam1;
		MMRESULT hr;
		//ĐtONAĂA܂B
		if(!si->playing) { return; }
		//̃ubNɃf[^𖞂܂B
		stream_fill(pwh);
		//̃ubNAēxAo܂B
		hr = waveOutWrite(hwo, pwh, sizeof(WAVEHDR));
		if(hr) { DIE(); }
	}
}
//-----------------------------------------------------------------------------
void stream_play(int BLKS, STREAMCALLBACK* callback, intptr_t param, int flags/*Windowsłł͎w肵Ă܂*/) {
	STREAMINFO* const si = &stream_info;
	MMRESULT hr;
	int i;
	//܂Amɒ~܂B
	stream_stop();
	//ŜNA܂B
	memset(si, 0, sizeof(STREAMINFO));
	//WAVEobt@TCYAR[obNAp[^i[܂B
	if(BLKS % 64 != 0) { DIE(); }	//P/ECEpceWave*()ŃXg[ĐsƂ́Aobt@64̔{ɂȂƗ܂BWindowswaveOut*()ɂ͂̐͂܂񂪁A݊̂߂Windowsłۂɂ܂B
	si->BLKS = BLKS;
	si->callback = callback;
	si->param = param;
	//񋟂ꂽEF[utH[I[fBIo̓foCXAĐ̂߂ɃI[v܂B
	{
		WAVEFORMATEX wfx;
		memset(&wfx, 0, sizeof(WAVEFORMATEX));
		wfx.wFormatTag      = WAVE_FORMAT_PCM;
		wfx.nChannels       = 1;
		wfx.nSamplesPerSec  =                 SPEAKER_FREQUENCY;
		wfx.nAvgBytesPerSec = sizeof(short) * SPEAKER_FREQUENCY;
		wfx.nBlockAlign     = sizeof(short);
		wfx.wBitsPerSample  = sizeof(short) * 8;
		hr = waveOutOpen(&si->hwo, WAVE_MAPPER, &wfx, (DWORD_PTR)waveOutProc, (DWORD_PTR)si, CALLBACK_FUNCTION);
		if(hr) { DIE(); }
	}
	//WAVEwb_܂BWAVEobt@mۂ܂B
	for(i = 0; i < BLKN; i++) {
		WAVEHDR* pwh = &si->wh[i];
		pwh->dwBufferLength = sizeof(short) * BLKS;
		pwh->lpData = malloc( sizeof(short) * BLKS);
		if(!pwh->lpData) { DIE(); }
		hr = waveOutPrepareHeader(si->hwo, pwh, sizeof(WAVEHDR));
		if(hr) { DIE(); }
	}
	//ĐJnOɁASubNɃf[^𖞂Ă܂B
	for(i = 0; i < BLKN; i++) {
		WAVEHDR* pwh = &si->wh[i];
		stream_fill(pwh);
	}
	//ĐtOZbg܂B
	si->playing = 1;
	//̏ԕK{łBwaveOutWrite()ĂяoォWOM_DONER[obN\͗LA̎_ōĐtOZbgĂȂƑosȂoOɂȂ܂B
	//WaveĐJn܂B
	for(i = 0; i < BLKN; i++) {
		WAVEHDR* pwh = &si->wh[i];
		hr = waveOutWrite(si->hwo, pwh, sizeof(WAVEHDR));
		if(hr) { DIE(); }
	}
}
//-----------------------------------------------------------------------------
void stream_stop() {
	STREAMINFO* const si = &stream_info;
	MMRESULT hr;
	int i;
	//ĐłȂΉ܂B
	if(!stream_stat()) { return; }
	//ĐtONA܂B
	si->playing = 0;
	//̏ԕK{łBwaveOutReset()̒Ŗ̃ubNꂼɑ΂WOM_DONER[obNAĐtONAĂȂƍēxoĒ~ȂoOɂȂ܂B
	//WAVEĐ~܂B
	hr = waveOutReset(si->hwo);	//̒ŁÃubNꂼɑ΂WOM_DONER[obN܂AĐtONAĂ̂waveOutWrite()Ăяo܂B
	if(hr) { DIE(); }
	//WAVEobt@J܂B
	for(i = 0; i < BLKN; i++) {
		WAVEHDR* pwh = &si->wh[i];
		hr = waveOutUnprepareHeader(si->hwo, pwh, sizeof(WAVEHDR));
		if(hr) { DIE(); }
		free(pwh->lpData);
	}
	//񋟂ꂽEF[utH[I[fBIo̓foCXN[Y܂B
	hr = waveOutClose(si->hwo);
	if(hr) { DIE(); }
}
//-----------------------------------------------------------------------------
int stream_stat() {
	//ĐȂ1A~Ȃ0Ԃ܂B
	return stream_info.playing;
}
//-----------------------------------------------------------------------------
void stream_filter_install(STREAMFILTER* filter) {
	//Xg[tB^֐i[܂B
	stream_filter = filter;
}
