/*	
 *	clipvgm.h
 *
 *	P/ECE VGM Driver
 *
 *	CLiP - Common Library for P/ECE
 *	Copyright (C) 2001-2017 Naoyuki Sawa
 *
 *	* Mon Jan 12 18:00:00 JST 2004 Naoyuki Sawa
 *	- 쐬JnB
 *	* Wed Nov 18 21:37:53 JST 2015 Naoyuki Sawa
 *	- 'extern "C" {'`'}'ň݂͂܂B.cpp܂Win32vWFNgCN[ho悤ɂ邽߂łB
 *	* Wed Aug 16 22:59:27 JST 2017 Naoyuki Sawa
 *	- 64rbgΉ̂߂ɁASTREAMCALLBACKparam̌^Aintintptr_tɕύX܂B
 */
#ifndef __CLIP_VGM_H__
#define __CLIP_VGM_H__

#ifdef  __cplusplus
extern "C" {
#endif//__cplusplus

/****************************************************************************
 *	VGMt@Cdl
 ****************************************************************************/

/*
 *	VGMt@Cwb_
 */
typedef struct _VGMHEADER {
	char signature[4];	/* +0x00,0x04: "Vgm "Œ */
	int eof_offset;		/* +0x04,0x04: (t@CTCY-0x04)ƏĂ邪Aۂɂ̓TCY҂? dls */
	int version;		/* +0x08,0x04: 0x00000101Œ */
	int psg_clock;		/* +0x0c,0x04: PSG̓NbN(:3579545[Hz])BPSG̏ꍇ0 */
	int fm_clock;		/* +0x10,0x04: FM ̓NbN(:3579545[Hz])BFM ̏ꍇ0 */
	int gd3_offset;		/* +0x14,0x04: GD3^Oʒuւ̑΃ItZbg(==Έʒu-0x14)BGD3^Ȍꍇ0 */
	int total_samples;	/* +0x18,0x04: Ŝ̏o̓Tv */
	int loop_offset;	/* +0x1c,0x04: [vJnʒuւ̑΃ItZbg(==Έʒu-0x1c)B[v̏ꍇ0 */
	int loop_samples;	/* +0x20,0x04: [v̏o̓Tv */
	int rate_recording;	/* +0x24,0x04: ^(50:PALorSECAM/60:NTSC/0:s?)B(ʏ̍Đɂ͕svȏł) */
	int padding[6];		/* +0x28,0x18: (\) */
} VGMHEADER;			/* =0x40     : ̌ɃV[PXR}h܂B */

/*
 *	V[PXR}h
 */
/***** `bvR}h *****/
#define VGM_GGPSG_dd		0x4f	/* Game Gear PSG stereo, write dd to port 0x06 */
#define VGM_SN76489_dd		0x50	/* PSG (SN76496) write value dd */
#define VGM_YM2413_aa_dd	0x51	/* YM2413, write value dd to register aa */
#define VGM_YM2612P0_aa_dd	0x52	/* YM2612 port 0, write value dd to register aa */
#define VGM_YM2612P1_aa_dd	0x53	/* YM2612 port 1, write value dd to register aa */
#define VGM_YM2151_aa_dd	0x54	/* YM2151, write value dd to register aa */
//#define VGM_RESERVED_aa_dd	0x5?	/* reserved for other chips/future, ignore */
/***** V[PTR}h (WAITPʂ1/44100[b]ł) *****/
#define VGM_WAIT_nn_nn		0x61	/* wait n samples, n can range from 0 to 65535 (approx 1.49 seconds) */
					/* Longer pauses than this are represented by multiple wait commands. */
#define VGM_WAIT_735		0x62	/* wait 735 samples (60th of a second), a shortcut for 0x61 0xdf 0x02 */
#define VGM_WAIT_882		0x63	/* wait 882 samples (50th of a second), a shortcut for 0x61 0x72 0x03 */
#define VGM_END			0x66	/* end of sound data */

/****************************************************************************
 *	VGMhCo
 ****************************************************************************/

#define VGMBUFLEN 320 /* =16000/50 c 1[tick](=1/50[sec])̃Tv */

#define VGMSAMPLERATE	44100	/* VGMt@C̃Tv[g(44.1KHzŒ) */

/*
 *	VGMhCo
 */
typedef struct _VGMDRIVER {
	gzFile file;		/* gzioXg[ (VGZ`̏ꍇ) */
				/* 񈳏kVGM`̏ꍇgzio֐Q߂Ă̂ŁAʕsvłB */
	VGMHEADER header;	/* VGMt@Cwb_ */
	//
	SN76489 sn76489;	/* SN76489 Chip */
	//
	int progress;		/* isJE^ */
	int stop;		/* 0:t/1:tI */
} VGMDRIVER;

/*
 *	VGMhCo֐
 */
int vgm_init(VGMDRIVER* vgm, const char* fname);
void vgm_free(VGMDRIVER* vgm);
int vgm_mix(VGMDRIVER* vgm, short wbuff[/*VGMBUFLEN*/]);
//{{2017/08/16ύX:64rbgΉ̂߂ɁASTREAMCALLBACKparam̌^Aintintptr_tɕύX܂B
//int vgm_stream_callback(short* wbuff, int param);
//2017/08/16ύX:64rbgΉ̂߂ɁASTREAMCALLBACKparam̌^Aintintptr_tɕύX܂B
int vgm_stream_callback(short* wbuff, intptr_t param);
//}}2017/08/16ύX:64rbgΉ̂߂ɁASTREAMCALLBACKparam̌^Aintintptr_tɕύX܂B

/****************************************************************************
 *	AvP[Vp֐
 ****************************************************************************/

/* VGM/VGZt@C̍ĐJn܂B
 * [in]
 *	fname		VGM/VGZt@CB
 * [out]
 *	߂l		ĐJnɐA 0Ԃ܂B
 *			ĐJnłȂ΁A-1Ԃ܂B
 * [note]
 *	* ̊֐͓stream_play()ĂяoĂ܂B
 *	* stream_play()ĂԂƁATEh荞݃xN^tbN܂B
 *	  vOIOɕKvgm_stop()ĂŁAxN^𕜌ĂB
 */
int vgm_play(const char* fname);

/* VGMt@C̍Đ~܂B
 * [note]
 *	* ĐłȂ΁Å֐͉܂B
 */
void vgm_stop();

#ifdef  __cplusplus
}//extern "C"
#endif//__cplusplus

#endif /*__CLIP_VGM_H__*/
