/*	
 *	clipusar.c
 *
 *	UnityScript Array
 *
 *	CLiP - Common Library for P/ECE
 *	Copyright (C) 2017 Naoyuki Sawa
 *
 *	* Sat Jan 21 21:05:34 JST 2017 Naoyuki Sawa
 *	- 1st [XB
 *	- UnityScriptArrayNX̎dl׋邽߂ɁACŎdl݊̊֐Ă݂܂B
 *	  ́AGPtrArray𗘗pĂ܂B
 *	  ׋̂߂ɍ̂ŁAۂ̃AvP[VœW[𗘗p闘_͗L܂B
 *	  WebuEUJavaScriptArrayƓdlłA֐̈ꕶڂ啶A֐Ȃ(?)ႢL݂łB
 *	  XAUnityScriptƁAWebuEUJavaScript͕ʕȂ̂ŁAArrayNX̎dlʕƍlĎgSƎv܂B
 *	  QƎ:uUnity DOCUMENTATION - Version: 5.5 (switch to 5.6b) - Scripting API - Arrayv(https://docs.unity3d.com/ScriptReference/Array.html)
 */
#include "clip.h"
/****************************************************************************
 *	
 ****************************************************************************/
//Array.Array(int)
//Description
//  Creates an Array of a fixed size.
//  The Array class is only available in Javascript.
//  var arr = new Array(5);
//  print(arr.length);
//  Note: This is javascript only.
//        C# does not use this feature.
//[note]
//	- {new Array()ł́AArray.Array(int)`̑ɂAArray.Array()`Array.Array(value,value,...)`L܂B
//	  ł́AArray.Array()`݂̂鎖ɂ܂B
struct UnityScriptArray* UnityScriptArray_New() {
	GPtrArray* array = g_ptr_array_new();
	return (struct UnityScriptArray*)array;
}
/*- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */
//[note]
//	- {Arraył̓K[x[WRNVɂĔj܂Ał͖IɔjKvL܂B
//	  KvɉāA֐ĂяoOɁAz̗vfIɔjĉB
void UnityScriptArray_Free(struct UnityScriptArray* pArray) {
	GPtrArray* array = (GPtrArray*)pArray;
	g_ptr_array_unref(array);
}
/*- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */
//[note]
//	- {Arraył́A'value=array[index]'ɑ܂B
void* UnityScriptArray_GetAt(struct UnityScriptArray* pArray, int iIndex) {
	GPtrArray* array = (GPtrArray*)pArray;
	return g_ptr_array_index(array, iIndex);
}
/*- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */
//[note]
//	- {Arraył́A'array[index]=value'ɑ܂B
void UnityScriptArray_SetAt(struct UnityScriptArray* pArray, int iIndex, void* pValue) {
	GPtrArray* array = (GPtrArray*)pArray;
	g_ptr_array_index(array, iIndex) = pValue;
}
/*--------------------------------------------------------------------------*/
//Array.length
//Description
//  The length property of the array that returns or sets the number of elements in array.
//  The Array.length controls how JS can access or set the size of the array.
//  The example JS script below shows that the length property of the array starts with a lower-case "l".
//  Note: This page includes a c-sharp script example.
//        The use of two array styles and their use of length are shown.
//  function Start() {
//    var arr = Array("Hello", "World");
//    print(arr.length); //Prints "2"
//    arr.length = 5; //resizes the array to a size of 5
//  }
//[note]
//	- {Arraył́A'n=array.length'ɑ܂B
int UnityScriptArray_GetLength(struct UnityScriptArray* pArray) {
	GPtrArray* array = (GPtrArray*)pArray;
	return array->len;
}
/*- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */
//[note]
//	- {Arraył́A'array.length=n'ɑ܂B
void UnityScriptArray_SetLength(struct UnityScriptArray* pArray, int nLength) {
	GPtrArray* array = (GPtrArray*)pArray;
	g_ptr_array_set_size(array, nLength);
}
/*--------------------------------------------------------------------------*/
//Array.Add()
//Description
//  Adds value to the end of the array.
//  var arr = new Array("Hello");
//  arr.Add("World");
//  print(arr); //prints "Hello", "World"
//  Note: This is javascript only.
//        C# does not use this feature.
//[note]
//	- {Array.Add()͈xɕ̒lǉ鎖o܂Ał͈Âǉ鎖ɂ܂B
//	  NULLI[̉ψɂĂ܂ƁANULLlǉoȂȂĂ܂łB
void UnityScriptArray_Add(struct UnityScriptArray* pArray, void* pValue) {
	GPtrArray* array = (GPtrArray*)pArray;
	g_ptr_array_add(array, pValue);
}
/*--------------------------------------------------------------------------*/
//Array.RemoveAt()
//Description
//  Removes the element at index from the array.
//  var arr = new Array("Hello", "and good morning", "World");
//  arr.RemoveAt(1); //remove "and good morning"
//  print(arr); //Prints "Hello,World"
//  Note: This is javascript only.
//        C# does not use this feature.
//[note]
//	- iIndexɗvfȏ̒lw肵Ă͂܂B
//	  {Array.RemoveAt()łdlłB
void UnityScriptArray_RemoveAt(struct UnityScriptArray* pArray, int iIndex) {
	GPtrArray* array = (GPtrArray*)pArray;
	g_ptr_array_remove_index(array, iIndex);
}
/*--------------------------------------------------------------------------*/
//Array.Clear()
//Description
//  Empties the array.
//  The length of the array will be zero.
//  var hello = new Array("Hello", "World");
//  hello.Clear(); //hello now contains zero elements
//  Note: This is javascript only.
//        C# does not use this feature.
void UnityScriptArray_Clear(struct UnityScriptArray* pArray) {
	GPtrArray* array = (GPtrArray*)pArray;
	g_ptr_array_set_size(array, 0);
}
/*--------------------------------------------------------------------------*/
//Array.Push()
//Description
//  Adds value to the end of the array.
//  And returns the new length of the array.
//  var arr = new Array("Hello");
//  arr.Push("World");
//  print(arr); //Prints "Hello", "World"
//  Note: This is javascript only.
//        C# does not use this feature.
//[note]
//	- Array.Add()Array.Push()̈Ⴂ́AArray.Add()͖߂lL܂񂪁AArray.Push()͒ǉ̗vfԂƂ_݂̂łB
//	- {Array.Push()͈xɕ̒lǉ鎖o܂Ał͈Âǉ鎖ɂ܂B
//	  NULLI[̉ψɂĂ܂ƁANULLlǉoȂȂĂ܂łB
int UnityScriptArray_Push(struct UnityScriptArray* pArray, void* pValue) {
	GPtrArray* array = (GPtrArray*)pArray;
	g_ptr_array_add(array, pValue);
	return array->len;
}
/*--------------------------------------------------------------------------*/
//Array.Pop()
//Description
//  Removes the last element of the array and returns it.
//  var arr = new Array("Hello", "World");
//  arr.Pop();
//  print(arr); //Prints only "Hello"
//  Note: This is javascript only.
//        C# does not use this feature.
//[note]
//	- Arrayɑ΂ē֐ĂяoĂ͂܂B
//	  {Array.Pop()łdlłB
void* UnityScriptArray_Pop(struct UnityScriptArray* pArray) {
	GPtrArray* array = (GPtrArray*)pArray;
	return g_ptr_array_remove_index(array, array->len - 1);
}
/*--------------------------------------------------------------------------*/
//Array.Shift()
//Description
//  Removes the first element of the array and returns it.
//  var arr = new Array("Hello", "World");
//  arr.Shift(); //arr now only contains "World"
//  print("World");
//  Note: This is javascript only.
//        C# does not use this feature.
void* UnityScriptArray_Shift(struct UnityScriptArray* pArray) {
	GPtrArray* array = (GPtrArray*)pArray;
	return g_ptr_array_remove_index(array, 0);
}
/*--------------------------------------------------------------------------*/
//Array.Unshift()
//Description
//  Unshift adds one or more elements to the beginning of an array and returns the new length of the array.
//  var arr = new Array("Hello", "World");
//  arr.Unshift("This", "is");
//  print(arr); //Prints This, is, Hello, World
//  Note: This is javascript only.
//        C# does not use this feature.
//[note]
//	- {Array.Unshift()͈xɕ̒lǉ鎖o܂Ał͈Âǉ鎖ɂ܂B
//	  NULLI[̉ψɂĂ܂ƁANULLlǉoȂȂĂ܂łB
int UnityScriptArray_Unshift(struct UnityScriptArray* pArray, void* pValue) {
	GPtrArray* array = (GPtrArray*)pArray;
	g_ptr_array_insert(array, 0, pValue);
	return array->len;
}
/*--------------------------------------------------------------------------*/
//Array.Sort()
//Description
//  Sorts all Array elements.
//  Var hello = new Array("c", "a", "b");
//  hello.Sort();
//  print(hello); //prints a, b, c.
//  Note: This is javascript only.
//        C# does not use this feature.
//[note]
//	- ֐́ApArraỹIuWFNggύXāÃIuWFNgg߂lƂ܂B
//	  {Array.RemoveAt()łdlłB
//	- ͈pArrayɎw肳ꂽz̗vfSĕłƑz肵Ĕr܂B
//	  łȂvf܂łƐ삵܂B
static int UnityScriptArray_Sort_compar(const void* a, const void* b) { return strcmp(*(char**)a, *(char**)b); }
struct UnityScriptArray* UnityScriptArray_Sort(struct UnityScriptArray* pArray) {
	GPtrArray* array = (GPtrArray*)pArray;
	g_ptr_array_sort(array, UnityScriptArray_Sort_compar);
	return pArray;
}
/*--------------------------------------------------------------------------*/
//Array.Concat()
//Description
//  Concat joins two or more arrays.
//  The method does not change the existing arrays and returns a copy of the joined array.
//  function Start() {
//    var arr = new Array("Hello", "World");
//    var arr2 = new Array("!");
//    var joined = arr.Concat(arr2); //joined now contains all 3 strings
//    print(joined); //prints "Hello","World","!"
//  }
//  Note: This is javascript only.
//        C# does not use this feature.
//[note]
//	- {Array.Join()͔z̊evfItoString()܂A͈pArrayɎw肳ꂽz̗vfSĕłƑz肵܂B
//	  łȂvf܂łƐ삵܂B
//	- ߂l̔źAĂяoɂUnityScriptArray_Free()ŉĉB
struct UnityScriptArray* UnityScriptArray_Concat(struct UnityScriptArray* pArray/*NULL*/, ... /*,NULL*/) {
	struct UnityScriptArray* pNewArray = UnityScriptArray_New();
	{
		va_list ap;
		va_start(ap, pArray);
		while(pArray) {
			int iIndex, nLength = UnityScriptArray_GetLength(pArray);
			for(iIndex = 0; iIndex < nLength; iIndex++) {
				void* pValue = UnityScriptArray_GetAt(pArray, iIndex);
				UnityScriptArray_Add(pNewArray, pValue);
			}
			pArray = va_arg(ap, struct UnityScriptArray*);
		}
	}
	return pNewArray;
}
/*--------------------------------------------------------------------------*/
//Array.Join()
//Description
//  Joins the contents of an array into one string.
//  The elements are seperated by the seperator string and returns a copy of the joined array.
//  function Start() {
//    var arr = new Array("Hello", "World");
//    //Prints "Hello, World"
//    print(arr.join(", "));
//  }
//  Note: This is javascript only.
//        C# does not use this feature.
//[note]
//	- {Array.Join()͔z̊evfItoString()܂A͈pArrayɎw肳ꂽz̗vfSĕłƑz肵܂B
//	  łȂvf܂łƐ삵܂B
//	- ߂ĺ̕AĂяoɂfree()ŉĉB
char* UnityScriptArray_Join(struct UnityScriptArray* pArray, const char* pSeperator) {
	GPtrArray* array = (GPtrArray*)pArray;
	return strjoinv(pSeperator, (char**)array->pdata);	//Cugarray.c̎ł͏(zero_terminated=1)ɑ\ɂȂĂÂ܂܂strv`ƌȂ鎖𗘗pĂ܂B
}
/****************************************************************************
 *	eXgXC[g
 ****************************************************************************/
#if 0
int app_main(int argc, char* argv[]) {
	struct UnityScriptArray *a1,*a2;
	char* s;
	a1 = UnityScriptArray_New();
	UnityScriptArray_Add(a1,"Alpha");				//		["Echo"]
	UnityScriptArray_Clear(a1);					//		[]
	UnityScriptArray_Add(a1,"Alpha");				//		["Alpha"]
	printf("%d\n",UnityScriptArray_Push(a1,"Delta"));		//2		["Alpha","Delta"]
	UnityScriptArray_SetAt(a1,1,"Bravo");				//		["Alpha","Bravo"]
	printf("%d\n",UnityScriptArray_Unshift(a1,"Charlie"));		//3		["Charlie","Alpha","Bravo"]
	if(UnityScriptArray_Sort(a1) != a1) { DIE(); }			//		["Alpha","Bravo","Charlie"]
	s = UnityScriptArray_Join(a1,","); printf("%s\n",s); free(s);	//"Alpha,Bravo,Charlie"
	a2 = UnityScriptArray_Concat(a1,a1,a1,NULL);			//		["Alpha","Bravo","Charlie","Alpha","Bravo","Charlie","Alpha","Bravo","Charlie"]
	UnityScriptArray_SetLength(a2,5);				//		["Alpha","Bravo","Charlie","Alpha","Bravo"]
	printf("%d\n",UnityScriptArray_GetLength(a2));			//5
	printf("%s\n",UnityScriptArray_GetAt(a2,1));			//"Bravo"
	printf("%s\n",UnityScriptArray_GetAt(a2,3));			//"Alpha"
	printf("%s\n",UnityScriptArray_Pop(a2));			//"Bravo"	["Alpha","Bravo","Charlie","Alpha"]
	printf("%s\n",UnityScriptArray_Shift(a2));			//"Alpha"	["Bravo","Charlie","Alpha"]
	UnityScriptArray_RemoveAt(a2,1);				//		["Bravo","Alpha"]
	UnityScriptArray_Free(a1);
	UnityScriptArray_Free(a2);
	return 0;
}
#endif
