/*
 *	clipufe.c
 *
 *	CLiP - Common Library for P/ECE
 *	Copyright (C) 2001-2018 Naoyuki Sawa
 *
 *	UFE - P/ECE USB File System Emulation
 *	Copyright (C) 2005 Naoyuki Sawa
 *
 *	* Wed Jun 08 20:00:00 JST 2005 Naoyuki Sawa
 *	- VK쐬B
 *	* Wed Jun 26 19:31:00 JST 2005 Naoyuki Sawa
 *	- ܂ŒP̃CûACLiPCuɑgݍ݂܂B
 *	* Wed Dec 31 17:37:43 JST 2014 Naoyuki Sawa
 *	- cstart.cpceAppInit00()pceLCDDispStart()ĂяoAtʂ̕\Jn悤ɂ܂B
 *	  ̕ύXɔAufe_setup()pceLCDDispStart()Ăяo͕svɂȂA폜܂B
 *	* Thu May 24 23:59:59 JST 2018 Naoyuki Sawa
 *	- PFFSUFE̗D揇ʂwo悤ɂ܂B
 *	- pceFileDelete()ɂΉ܂B
 */
#include "clip.h"

/* TODO:
 *   pceFile*()́AG[̎ނɉĈقȂG[R[hԂ܂A
 *   ufeFile*()́ASẴG[ɂ-1ԂĂ܂B(2005/06/26)
 *   ߂l0()0ȊO(s)𔻒fĂAvP[VȂΖ肠܂񂪁A
 *   G[̎ނ𔻒fĂAvP[Vł͐삵Ȃ\܂B
 *   AufeFile*()̃G[R[hpceFile*()݊Ƃ悤ACKv肻łB
 */

/*****************************************************************************
 *	[Jϐ
 *****************************************************************************/

static UFE ufe;

//{{2018/05/24ǉ:PFFSUFE̗D揇ʂwo悤ɂ܂B
static int order = UFEORDER_PFFS_UFE;	//܂ł̓Ƃ̌݊̂߂ɁAlPFFSUFȄƂB
//}}2018/05/24ǉ:PFFSUFE̗D揇ʂwo悤ɂ܂B

static int (*pffsFileFindOpen)(FILEINFO* pfi);
static int (*pffsFileFindNext)(FILEINFO* pfi);
static int (*pffsFileFindClose)(FILEINFO* pfi);
static int (*pffsFileOpen)(FILEACC* pfa, const char* fname, int mode);
static int (*pffsFileReadSct)(FILEACC* pfa, void* ptr, int sct, int len);
static int (*pffsFileWriteSct)(FILEACC* pfa, const void* ptr, int sct, int len);
static int (*pffsFileClose)(FILEACC* pfa);
static int (*pffsFileCreate)(const char* fname, unsigned long size);
//{{2018/05/24ǉ:pceFileDelete()ɂΉ܂B
static int (*pffsFileDelete)(const char* fname);
//}}2018/05/24ǉ:pceFileDelete()ɂΉ܂B

/*****************************************************************************
 *	[J֐
 *****************************************************************************/

/* dv!!
 * * ufe_exec()A荞݋֎~̏ԂĂяoĂ͂܂!!
 *   ufe_exec()́APCւ̃T[rXvi[AT[rX|[Oő҂܂B
 *   PC̃t@CT[rX́AUSBʐMɂPC݂̏ɂčs܂B
 *   USB荞݂󂯕tȂԂł́APC̃t@CT[rXsꂸA
 *   |[OɂT[rX҂iv[vɂȂĂ܂܂!!
 * * ]āAUFE𗘗pĂƂ́A荞݋֎~Ԃt@CAPIpł܂B
 *   Ƃ΁A荞݃T[rX[`̒t@C̓ǂݍ݂sĂ͂܂B
 */
static int
ufe_exec(int ksno)
{
	/* J[lT[rXԍi[܂B
	 * ꂪAt@CT[oւ̃T[rXvʒmƂȂ܂B
	 * up[^i[J[lT[rXԍi[v̏Ԃ炵ĂB
	 */
	ufe.ksno = ksno;

	/* t@CT[õT[rX҂܂B
	 * t@CT[óAT[rXƃJ[lT[rXԍNA܂B
	 */
	while(ufe.ksno) {
		/* t@CT[oƂ̐ڑؒfĂ܂AG[Ƃ܂B */
		if(!(pceUSBCOMGetStat() & UCS_PCSTAT)) {
			return -1;
		}
	}
	return ufe.result;
}

/*---------------------------------------------------------------------------*/

static int
ufeFileFindOpen(FILEINFO* pfi)
{
	ufe.api.find_open.pfi = pfi;
	return ufe_exec(KSNO_FileFindOpen);
}

static int
ufeFileFindNext(FILEINFO* pfi)
{
	ufe.api.find_next.pfi = pfi;
	return ufe_exec(KSNO_FileFindNext);
}

static int
ufeFileFindClose(FILEINFO* pfi)
{
	ufe.api.find_close.pfi = pfi;
	return ufe_exec(KSNO_FileFindClose);
}

static int
ufeFileOpen(FILEACC* pfa, const char* fname, int mode)
{
	ufe.api.open.pfa = pfa;
	ufe.api.open.fname = fname;
	ufe.api.open.mode = mode;
	return ufe_exec(KSNO_FileOpen);
}

static int
ufeFileReadSct(FILEACC* pfa, void* ptr, int sct, int len)
{
	ufe.api.read_sct.pfa = pfa;
	ufe.api.read_sct.ptr = ptr;
	ufe.api.read_sct.sct = sct;
	ufe.api.read_sct.len = len;
	return ufe_exec(KSNO_FileReadSct);
}

static int
ufeFileWriteSct(FILEACC* pfa, const void* ptr, int sct, int len)
{
	ufe.api.write_sct.pfa = pfa;
	ufe.api.write_sct.ptr = ptr;
	ufe.api.write_sct.sct = sct;
	ufe.api.write_sct.len = len;
	return ufe_exec(KSNO_FileWriteSct);
}

static int
ufeFileClose(FILEACC* pfa)
{
	ufe.api.close.pfa = pfa;
	return ufe_exec(KSNO_FileClose);
}

static int
ufeFileCreate(const char* fname, unsigned long size)
{
	ufe.api.create.fname = fname;
	ufe.api.create.size = size;
	return ufe_exec(KSNO_FileCreate);
}

//{{2018/05/24ǉ:pceFileDelete()ɂΉ܂B
static int
ufeFileDelete(const char* fname)
{
	ufe.api.delete.fname = fname;
	return ufe_exec(KSNO_FileDelete);
}
//}}2018/05/24ǉ:pceFileDelete()ɂΉ܂B

/*---------------------------------------------------------------------------*/

static int
myFileFindOpen(FILEINFO* pfi)
{
	int retval;

//{{2018/05/24ύX:PFFSUFE̗D揇ʂwo悤ɂ܂B
//	retval = pffsFileFindOpen(pfi);
//	if(retval == 0) {
//		pfi->works[15] = FILEINFO_PFFS;
//	} else {
//		retval = ufeFileFindOpen(pfi);
//		if(retval == 0) {
//			pfi->works[15] = FILEINFO_UFE;
//		} else {
//			memset(pfi, 0, sizeof(FILEINFO));
//		}
//	}
//2018/05/24ύX:PFFSUFE̗D揇ʂwo悤ɂ܂B
	switch(order) {
	default:DIE();
	case UFEORDER_PFFS:
	case UFEORDER_PFFS_UFE:
		retval = pffsFileFindOpen(pfi);
		if(retval == 0) {
			pfi->works[15] = FILEINFO_PFFS;
		} else if(order == UFEORDER_PFFS_UFE) {
			retval = ufeFileFindOpen(pfi);
			if(retval == 0) {
				pfi->works[15] = FILEINFO_UFE;
			} else {
				memset(pfi, 0, sizeof(FILEINFO));
			}
		}
		break;
	case UFEORDER_UFE:
	case UFEORDER_UFE_PFFS:
		retval = ufeFileFindOpen(pfi);
		if(retval == 0) {
			pfi->works[15] = FILEINFO_UFE;
		} else if(order == UFEORDER_UFE_PFFS) {
			retval = pffsFileFindOpen(pfi);
			if(retval == 0) {
				pfi->works[15] = FILEINFO_PFFS;
			} else {
				memset(pfi, 0, sizeof(FILEINFO));
			}
		}
		break;
	}
//}}2018/05/24ύX:PFFSUFE̗D揇ʂwo悤ɂ܂B

	return retval;
}

static int
myFileFindNext(FILEINFO* pfi)
{
	int retval = 0;

//{{2018/05/24ύX:PFFSUFE̗D揇ʂwo悤ɂ܂B
//	if(pfi->works[15] == FILEINFO_PFFS) {
//		retval = pffsFileFindNext(pfi);
//		if(!retval) {
//			pffsFileFindClose(pfi);
//			if(ufeFileFindOpen(pfi) == 0) {
//				pfi->works[15] = FILEINFO_UFE;
//			} else {
//				memset(pfi, 0, sizeof(FILEINFO));
//			}
//		}
//	}
//	if(pfi->works[15] == FILEINFO_UFE) {
//		retval = ufeFileFindNext(pfi);
//	}
//2018/05/24ύX:PFFSUFE̗D揇ʂwo悤ɂ܂B
	switch(order) {
	default:DIE();
	case UFEORDER_PFFS:
	case UFEORDER_PFFS_UFE:
		if(pfi->works[15] == FILEINFO_PFFS) {
			retval = pffsFileFindNext(pfi);
			if(!retval) {
				pffsFileFindClose(pfi);
				if(order == UFEORDER_PFFS_UFE) {
					if(ufeFileFindOpen(pfi) == 0) {
						pfi->works[15] = FILEINFO_UFE;
					} else {
						memset(pfi, 0, sizeof(FILEINFO));
					}
				}
			}
		}
		if(pfi->works[15] == FILEINFO_UFE) {
			retval = ufeFileFindNext(pfi);
		}
		break;
	case UFEORDER_UFE:
	case UFEORDER_UFE_PFFS:
		if(pfi->works[15] == FILEINFO_UFE) {
			retval = ufeFileFindOpen(pfi);
			if(!retval) {
				ufeFileFindClose(pfi);
				if(order == UFEORDER_UFE_PFFS) {
					if(pffsFileFindNext(pfi) == 0) {
						pfi->works[15] = FILEINFO_PFFS;
					} else {
						memset(pfi, 0, sizeof(FILEINFO));
					}
				}
			}
		}
		if(pfi->works[15] == FILEINFO_PFFS) {
			retval = pffsFileFindNext(pfi);
		}
		break;
	}
//}}2018/05/24ύX:PFFSUFE̗D揇ʂwo悤ɂ܂B

	return retval;
}

static int
myFileFindClose(FILEINFO* pfi)
{
	int retval;

	switch(pfi->works[15]) {
	case FILEINFO_PFFS:
		retval = pffsFileFindClose(pfi);
		break;
	case FILEINFO_UFE:
		retval = ufeFileFindClose(pfi);
		break;
	default:
		retval = -1;
		break;
	}
	if(retval == 0) {
		memset(pfi, 0, sizeof(FILEINFO));
	}

	return retval;
}

static int
myFileOpen(FILEACC* pfa, const char* fname, int mode)
{
	int retval;

//{{2018/05/24ύX:PFFSUFE̗D揇ʂwo悤ɂ܂B
//	retval = pffsFileOpen(pfa, fname, mode);
//	if(retval != 0) {
//		retval = ufeFileOpen(pfa, fname, mode);
//		if(retval != 0) {
//			memset(pfa, 0, sizeof(FILEACC));
//		}
//	}
//2018/05/24ύX:PFFSUFE̗D揇ʂwo悤ɂ܂B
	switch(order) {
	default:DIE();
	case UFEORDER_PFFS:
	case UFEORDER_PFFS_UFE:
		retval = pffsFileOpen(pfa, fname, mode);
		if(retval != 0) {
			if(order == UFEORDER_PFFS_UFE) {
				retval = ufeFileOpen(pfa, fname, mode);
				if(retval != 0) {
					memset(pfa, 0, sizeof(FILEACC));
				}
			}
		}
		break;
	case UFEORDER_UFE:
	case UFEORDER_UFE_PFFS:
		retval = ufeFileOpen(pfa, fname, mode);
		if(retval != 0) {
			if(order == UFEORDER_UFE_PFFS) {
				retval = pffsFileOpen(pfa, fname, mode);
				if(retval != 0) {
					memset(pfa, 0, sizeof(FILEACC));
				}
			}
		}
		break;
	}
//}}2018/05/24ύX:PFFSUFE̗D揇ʂwo悤ɂ܂B

	return retval;
}

static int
myFileReadSct(FILEACC* pfa, void* ptr, int sct, int len)
{
	int retval;

	switch(pfa->valid) {
	case FILEACC_PFFS:
		retval = pffsFileReadSct(pfa, ptr, sct, len);
		break;
	case FILEACC_UFE:
		retval = ufeFileReadSct(pfa, ptr, sct, len);
		break;
	default:
		retval = 0;
		break;
	}

	return retval;
}

static int
myFileWriteSct(FILEACC* pfa, const void* ptr, int sct, int len)
{
	int retval;

	switch(pfa->valid) {
	case FILEACC_PFFS:
		retval = pffsFileWriteSct(pfa, ptr, sct, len);
		break;
	case FILEACC_UFE:
		retval = ufeFileWriteSct(pfa, ptr, sct, len);
		break;
	default:
		retval = 0;
		break;
	}

	return retval;
}

static int
myFileClose(FILEACC* pfa)
{
	int retval;

	switch(pfa->valid) {
	case FILEACC_PFFS:
		retval = pffsFileClose(pfa);
		break;
	case FILEACC_UFE:
		retval = ufeFileClose(pfa);
		break;
	default:
		retval = -1;
		break;
	}
	if(retval == 0) {
		memset(pfa, 0, sizeof(FILEACC));
	}

	return retval;
}

static int
myFileCreate(const char* fname, unsigned long size)
{
	int retval;

//{{2018/05/24ύX:PFFSUFE̗D揇ʂwo悤ɂ܂B
//	retval = pffsFileCreate(fname, size);
//	if(retval != 0) {
//		retval = ufeFileCreate(fname, size);
//	}
//2018/05/24ύX:PFFSUFE̗D揇ʂwo悤ɂ܂B
	switch(order) {
	default:DIE();
	case UFEORDER_PFFS:
	case UFEORDER_PFFS_UFE:
		retval = pffsFileCreate(fname, size);
		if(retval != 0) {
			if(order == UFEORDER_PFFS_UFE) {
				retval = ufeFileCreate(fname, size);
			}
		}
		break;
	case UFEORDER_UFE:
	case UFEORDER_UFE_PFFS:
		retval = ufeFileCreate(fname, size);
		if(retval != 0) {
			if(order == UFEORDER_UFE_PFFS) {
				retval = pffsFileCreate(fname, size);
			}
		}
		break;
	}
//}}2018/05/24ύX:PFFSUFE̗D揇ʂwo悤ɂ܂B

	return retval;
}

//{{2018/05/24ǉ:pceFileDelete()ɂΉ܂B
static int
myFileDelete(const char* fname)
{
	int retval;

	switch(order) {
	default:DIE();
	case UFEORDER_PFFS:
	case UFEORDER_PFFS_UFE:
		retval = pffsFileDelete(fname);
		if(retval != 0) {
			if(order == UFEORDER_PFFS_UFE) {
				retval = ufeFileDelete(fname);
			}
		}
		break;
	case UFEORDER_UFE:
	case UFEORDER_UFE_PFFS:
		retval = ufeFileDelete(fname);
		if(retval != 0) {
			if(order == UFEORDER_UFE_PFFS) {
				retval = pffsFileDelete(fname);
			}
		}
		break;
	}

	return retval;
}
//}}2018/05/24ǉ:pceFileDelete()ɂΉ܂B

/*---------------------------------------------------------------------------*/

static void
ufe_hook()
{
	if(!pffsFileFindOpen) {
		pffsFileFindOpen  = pceVectorSetKs(KSNO_FileFindOpen , myFileFindOpen );
		pffsFileFindNext  = pceVectorSetKs(KSNO_FileFindNext , myFileFindNext );
		pffsFileFindClose = pceVectorSetKs(KSNO_FileFindClose, myFileFindClose);
		pffsFileOpen      = pceVectorSetKs(KSNO_FileOpen     , myFileOpen     );
		pffsFileReadSct   = pceVectorSetKs(KSNO_FileReadSct  , myFileReadSct  );
		pffsFileWriteSct  = pceVectorSetKs(KSNO_FileWriteSct , myFileWriteSct );
		pffsFileClose     = pceVectorSetKs(KSNO_FileClose    , myFileClose    );
		pffsFileCreate    = pceVectorSetKs(KSNO_FileCreate   , myFileCreate   );
//{{2018/05/24ǉ:pceFileDelete()ɂΉ܂B
		pffsFileDelete    = pceVectorSetKs(KSNO_FileDelete   , myFileDelete   );
//}}2018/05/24ǉ:pceFileDelete()ɂΉ܂B
	}
}

static void
ufe_unhook()
{
	if(pffsFileFindOpen) {
		pceVectorSetKs(KSNO_FileFindOpen , pffsFileFindOpen ); pffsFileFindOpen  = NULL;
		pceVectorSetKs(KSNO_FileFindNext , pffsFileFindNext ); pffsFileFindNext  = NULL;
		pceVectorSetKs(KSNO_FileFindClose, pffsFileFindClose); pffsFileFindClose = NULL;
		pceVectorSetKs(KSNO_FileOpen     , pffsFileOpen     ); pffsFileOpen      = NULL;
		pceVectorSetKs(KSNO_FileReadSct  , pffsFileReadSct  ); pffsFileReadSct   = NULL;
		pceVectorSetKs(KSNO_FileWriteSct , pffsFileWriteSct ); pffsFileWriteSct  = NULL;
		pceVectorSetKs(KSNO_FileClose    , pffsFileClose    ); pffsFileClose     = NULL;
		pceVectorSetKs(KSNO_FileCreate   , pffsFileCreate   ); pffsFileCreate    = NULL;
//{{2018/05/24ǉ:pceFileDelete()ɂΉ܂B
		pceVectorSetKs(KSNO_FileDelete   , pffsFileDelete   ); pffsFileDelete    = NULL;
//}}2018/05/24ǉ:pceFileDelete()ɂΉ܂B
	}
}

/*****************************************************************************
 *	O[o֐
 *****************************************************************************/

int
ufe_setup(int timeout)
{
	USBCOMINFO uci;
	unsigned char* old_vbuff;
	int ucs;
	int T0;
	int T1;

	/* ܂AmɐؒfĂ܂B */
	ufe_stop();

	/* USBCOMAt@CT[o̐ڑ҂܂B
	 * USBCOMVOl`̏́ÂƂłB
	 *	+0- 3:	"UFE1"
	 *	+4- 7:	UFE\̂̃AhX
	 *	+8-15:	gp
	 */
	memset(&uci, 0, sizeof uci);
	memcpy(&uci.signature[0], "UFE1", 4);
	*(int*)&uci.signature[4] = (int)&ufe;
	pceUSBCOMSetup(&uci);

	/* ڑ҂bZ[W\܂B */
	old_vbuff = pceLCDSetBuffer(_def_vbuff);
//sv	pceLCDDispStart();	//{{2014/12/31폜:cstart.cpceAppInit00()pceLCDDispStart()ĂяoAtʂ̕\Jn悤ɂ܂B}}
	pceFontSetType(0x80);
	pceFontSetTxColor(3);
	pceFontSetBkColor(0);
	pceFontSetPos(0, (DISP_Y - 10 * 5) / 2);
	/*             OPQRSTUVWXOPQ */
	pceFontPutStr(" +----------------------+\n"
	              " | t@CT[o |\n"
	              " | ڑ҂Ă܂c |\n"
	              " |(`{^ŃLZ)|\n"
	              " +----------------------+");
	pceLCDTrans();

	/* t@CT[o̐ڑA܂̓LZ҂܂B */
	while(pcePadGetDirect() & PAD_A) { /* J҂*/ }
	T0 = pceTimerGetCount();
	while(!((ucs = pceUSBCOMGetStat()) & UCS_PCSTAT)) {
		if(pcePadGetDirect() & PAD_A) {
			break; /* LZ */
		}
		if(timeout >= 0) {
			T1 = timeout * 1000 - (pceTimerGetCount() - T0);
			if(T1 <= 0) {
				break; /* ^CAEg */
			}
			pceFontSetPos((DISP_X - 5 * 9) / 2, DISP_Y - 16);
			/*             012345678 */
			pceFontPrintf("%3db", (T1 + 999) / 1000);
			pceLCDTrans();
		}
	}
	while(pcePadGetDirect() & PAD_A) { /* J҂*/ }

	/* zʂɖ߂܂B */
	pceLCDSetBuffer(old_vbuff);

	/* ڑȂ΁At@CAPItbNA0Ԃ܂B */
	if(ucs & UCS_PCSTAT) {
		ufe_hook();
		return 0;
	}

	/* ڑsȂ΁A-1Ԃ܂B
	 * ԍŐڑĂ܂Ă\̂ŁAmUSBCOMI܂B
	 */
	ufe_stop();
	return -1;
}

void
ufe_stop()
{
	USBCOMINFO uci;

	/* t@CAPItbNĂA܂B */
	ufe_unhook();

	/* pceUSBCOMStop()̓VOl`NAȂ̂ŁAIɃNA܂B */
	memset(&uci, 0, sizeof uci);
	pceUSBCOMSetup(&uci);

	/* USBCOMI܂B */
	pceUSBCOMStop();
}

//{{2018/05/24ǉ:PFFSUFE̗D揇ʂwo悤ɂ܂B
void
ufe_order(int _order)
{
	order = _order;
}
