/*
 *	cliptimm.c
 *
 *	^C}Ǘ
 *
 *	CLiP - Common Library for P/ECE
 *	Copyright (C) 2001-2017 Naoyuki Sawa
 *
 *	* Sat May 30 00:59:40 JST 2015 Naoyuki Sawa
 *	- 1st [XB
 *	* Tue Aug 02 22:11:15 JST 2016 Naoyuki Sawa
 *	- ST_TimMgrFunc.fn ̊֐vg^CvύX܂B
 *	  ST_TimMgrFunc.argtB[hǉ܂B
 *	  ܂ł́A֐^C}ɓo^邽߂ɂ́Ap֐oRKvL܂B
 *	  ̕ύXɂāA֐ځA^C}ɓo^鎖o悤ɂȂ܂B
 *	* Mon Aug 28 23:20:51 JST 2017 Naoyuki Sawa
 *	- 'TimMgrCh_1exec'ǉ܂B
 *	  oߎԂɊ֌WATimMgr_Exec()Ăяo񖈂Ɉs铯^C}́A^C}Ǘ`lԍłB
 *	  'TimMgrCh_1exec'ǉ鎖ɂŔAȉ̒ʂłB
 *	- lXȃW[̎̌ĂяoAꌳǗƎvL܂B
 *	  AvP[Vschedule()֐疾IɌĂяoĂł͂̂łAꌳǗՂƎvłB
 *	  ŁA^C}ǗW[(W[)̊TimMgr_Exec()֐ɁA̖S킳鎖ɂ܂B
 *	  A^C}ǗW[̊֐dlɂ͈ؕύX͖AVȃ^C}Ǘ`lƂ'TimMgrCh_1exec'ǉłB
 *	- Ȃ݂ɕʂ̈ĂƂāA^C}Ǘ`lǉɁA'TimMgrCh_1f'gp@l܂A͊ԈႢłB
 *	  ȂȂATimMgrCh_1f`l͌oߎԂɈˑ̂ŁATimMgr_Exec()Ăяo񖈂ɈsƂ͌ȂłB
 *	  AvP[ṼC[v1fPʂŉ񂵂ĂĂAȏԂ̂ɂāATimMgr_Exec()̌ĂяoԊu1f1f߂ɂȂ\L܂B
 *	  TimMgrCh_1fgpĂƁAC[v̂ł͎ĂяoȂAł͓ȏĂяoꂽ肵āAӐ}ƈقȂ铮ɂȂ܂B
 *	  L̖邽߂ɁAAvP[ṼC[vɕK`lƂāAV'TimMgrCh_1exec'݂܂B
 *	- ܂ŁAAvP[Vschedule()֐疾IɌĂяoẮÁA^C}ǗW['TimMgrCh_1exec'`lɓo^o܂B
 *	  K{ł͂ȂA܂ŒʂAvP[Vschedule()֐疾IɌĂяoĂ\܂񂪁AՂ̂߂ɁAȂׂL̕@𗘗pĉB
 *	  !!
 *	  L͂܂łAAvP[Vschedule()֐̒ŁA񂾂TimMgr_Exec()ĂяoĂ\̃AvP[VɂĂłB
 *	  AvP[Vschedule()֐̒ŁAoߎԂ|[OȂ牽xTimMgr_Exec()ĂяoĂ\̃AvP[Vɂ́AKpo܂B
 *	  ̓Iɂ́A2017/08/28݂/clip/test.win/cpp.cpp̍\͌҂ł邽߁Ȁ݂AWindowsAvP[V̐`łTimMgrCh_1execgpo܂B
 *	  ҂̂悤ȍ\̃AvP[VɂẮA܂ŒʂATimMgrCh_1fgpĉB
 *	* Mon Aug 28 23:46:08 JST 2017 Naoyuki Sawa
 *	- TimMgr_AddFunc_New(),TimMgrFunc_New(),TimMgrFunc_Init()ǉ܂B
 *	  XAW[͑gݍ݊z肵Ă̂ŁAĂяoɂST_TimMgrFunc\̂ÓIɊmۂ鎖z肵ĂATimMgr_AddFunc()̊֐dlgh肪L܂B
 *	  ŁAIȃmۂeՂȊł͂ƊȒPɎg悤ɁAL̊֐ǉ܂B
 *	  ̓IȎgṕAcliptimm.ćugpv́uST_TimMgrFunc\̂𓮓IɊmۂēo^BP/ECEWindowsœIȃmۂeՂȏꍇ͂BṽR[hQƂĉB
 */
#include "clip.h"
/****************************************************************************
 *	[J֐錾
 ****************************************************************************/
#ifndef PIECE
static void TimMgr_Invoke(ST_TimMgrCh* pCh);
#else //PIECE
/*static*/ void TimMgr_Invoke(ST_TimMgrCh* pCh);
#endif//PIECE
/****************************************************************************
 *	
 ****************************************************************************/
void TimMgr_Init(ST_TimMgr* pTimMgr, int uFps) {
	ST_TimMgrCh* pCh;
	//t[[g1~65͈̔͊OȂ΁AG[~B
	if((uFps < 1) || (uFps > (USHRT_MAX/1000))) { DIE(); }
	//\̂NAB
	memset(pTimMgr, 0, sizeof(ST_TimMgr));
	//Zlݒ肷B
	pTimMgr->uAdd = uFps;
	//Zlݒ肷B
	pCh = pTimMgr->TBL_TimMgrCh;
	pCh->uSub =         1000;   pCh++;	//1f
	pCh->uSub = (uFps *= 10);   pCh++;	//10ms
	pCh->uSub = (uFps *= 10);   pCh++;	//100ms
	pCh->uSub = (uFps *= 10); /*pCh++;*/	//1s
//{{2017/08/28RgύX:'TimMgrCh_1exec'ǉ܂B
// //sv	pCh->uSub = 0;				//1ms
//2017/08/28RgύX:'TimMgrCh_1exec'ǉ܂B
 //sv	pCh->uSub = 0;            /*pCh++;*/	//1ms
 //sv	pCh->uSub = 0;				//1exec
//}}2017/08/28RgύX:'TimMgrCh_1exec'ǉ܂B
}
/*--------------------------------------------------------------------------*/
void TimMgr_AddFunc(ST_TimMgr* pTimMgr, int iCh, ST_TimMgrFunc* pFunc) {
	ST_TimMgrCh* pCh;
	ST_TimMgrFunc** ppNext;
	//`lԍ͈͊O,,֐m[h̊֐Ɗ֐C^[oݒȂ΁AG[~B
	if(((unsigned)iCh >= TimMgrCh_SIZE) || !pFunc->fn || !pFunc->uItv) { DIE(); }
    //{{̏ŏ΁AɃ^C}JnĂĂA荞݋֎~svłB
	//w肳ꂽ`ĺA֐`FC̏I[|C^́AϐAhX߂B
	pCh = &pTimMgr->TBL_TimMgrCh[iCh];
	for(ppNext = &pCh->pNext; *ppNext; ppNext = &(*ppNext)->pNext) {
		//֐m[ho^悤ƂAG[~B
		if(*ppNext == pFunc) { DIE(); }
	}
	//ǉ֐m[h̊֐JE^NAA|C^I[ɂB
	pFunc->uCnt  = 0;
	pFunc->pNext = NULL;
	//֐m[hǉB
	*ppNext = pFunc;
    //}}̏ŏ΁AɃ^C}JnĂĂA荞݋֎~svłB
}
/*--------------------------------------------------------------------------*/
//{{2017/08/28ǉ:TimMgr_AddFunc_New(),TimMgrFunc_New(),TimMgrFunc_Init()ǉ܂B
//[eBeB֐FST_TimMgrFunc\̂𓮓IɊmۂāA^C}Ǘɓo^B
ST_TimMgrFunc* TimMgr_AddFunc_New(ST_TimMgr* pTimMgr, int iCh, void (*fn)(void* arg), void* arg, int uItv) {
	ST_TimMgrFunc* pFunc = TimMgrFunc_New(fn, arg, uItv);
	TimMgr_AddFunc(pTimMgr, iCh, pFunc);
	return pFunc;	//IɊmۂēo^ST_TimMgrFunc\̂Ԃ܂B^C}Ǘ̏IɓIɊmۂST_TimMgrFunc\̂Jꍇ͂̃|C^oĂĉBʏ͖č\܂(ʏ̓^C}Ǘ̏IƃAv̏IłOS̃ɔC邩)B
}
/*- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */
//[eBeB֐FST_TimMgrFunc\̂𓮓IɊmۂB
ST_TimMgrFunc* TimMgrFunc_New(void (*fn)(void* arg), void* arg, int uItv) {
	ST_TimMgrFunc* pFunc = malloc(sizeof(ST_TimMgrFunc));
	if(!pFunc) { DIE(); }	//s
	TimMgrFunc_Init(pFunc, fn, arg, uItv);
	return pFunc;
}
/*- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */
//[eBeB֐FST_TimMgrFunc\̂ÓIɏB
void TimMgrFunc_Init(ST_TimMgrFunc* pFunc, void (*fn)(void* arg), void* arg, int uItv) {
	pFunc->fn    = fn;
	pFunc->arg   = arg;
	pFunc->uItv  = uItv;
//sv	pFunc->uCnt  = 0;	//TimMgr_AddFunc()o^ɃNÂŁAł̓NAsvłB
//sv	pFunc->pNext = NULL;	//
}
//}}2017/08/28ǉ:TimMgr_AddFunc_New(),TimMgrFunc_New(),TimMgrFunc_Init()ǉ܂B
/*--------------------------------------------------------------------------*/
int TimMgr_GetCnt(ST_TimMgr* pTimMgr, int iCh) {
	//`lԍ͈͊OȂ΁AG[~B
	if((unsigned)iCh >= TimMgrCh_SIZE) { DIE(); }
	//`lJE^ԂB
	return pTimMgr->TBL_TimMgrCh[iCh].uCnt;
}
/*--------------------------------------------------------------------------*/
void TimMgr_Exec(ST_TimMgr* pTimMgr) {
	ST_TimMgrCh* pCh;
	int uErr;
	for(pCh = pTimMgr->TBL_TimMgrCh; pCh->uSub; pCh++) {	//1ms`l(pCh->uSub=0)͊܂߂ȂB
		//ȉ̏ŌZłԁAJԂB
		// - [vɊ荞݂pCh->uErrĂSłB
		for(;;) {
ENTER_CS;
			//`l덷ZlȏȂ΁AZB
			if((uErr = pCh->uErr - pCh->uSub) >= 0) { pCh->uErr = uErr; }
LEAVE_CS;
			//ZłȂ΁AB
			if(uErr < 0) { break; }
			//֐ĂяoB
			TimMgr_Invoke(pCh);
		}
	}
//{{2017/08/28ǉ:'TimMgrCh_1exec'ǉ܂B
	//̃[v𔲂ApCh1ms`lwĂ̂ŁAi߂1exec`lw悤ɂB
	pCh++;
	//1exec`l̊֐ĂяoB
	TimMgr_Invoke(pCh);
//}}2017/08/28ǉ:'TimMgrCh_1exec'ǉ܂B
}
/*--------------------------------------------------------------------------*/
#ifndef PIECE
void TimMgr_Intr(ST_TimMgr* pTimMgr) {
	ST_TimMgrCh* pCh;
	int uErr;
	//e`lɂāc
	for(pCh = pTimMgr->TBL_TimMgrCh; pCh->uSub; pCh++) {	//1ms`l(pCh->uSub=0)͊܂߂ȂB
		//`l덷ɁAZlB
		uErr = pCh->uErr + pTimMgr->uAdd;
		if(uErr > USHRT_MAX) { uErr = USHRT_MAX; }	//Oa
		pCh->uErr = uErr;
	}
	//1ms`l̂݁A荞ݓŎsB
	TimMgr_Invoke(pCh);
//{{2017/08/28Rgǉ:'TimMgrCh_1exec'ǉ܂B
	//1ms`ľ1exec`l݂Ă܂ATimMgr_Intr()ł1exec`lɑ΂ĉsKv͗L܂B
	//1exec`ĺAoߎԂɊ֌WTimMgr_Exec()疾IɌĂяôŁA`l덷𑝂₷Kv͖łB
//}}2017/08/28Rgǉ:'TimMgrCh_1exec'ǉ܂B
}
static void TimMgr_Invoke(ST_TimMgrCh* pCh) {
	ST_TimMgrFunc* pFunc;
	//`lJE^'1'i߂B
	pCh->uCnt++;
	//֐`FC̏I[ɓB܂Łc
	for(pFunc = pCh->pNext; pFunc; pFunc = pFunc->pNext) {
		//֐JE^'1'₵A֐C^[oɓBc
		if(++pFunc->uCnt >= pFunc->uItv) {
			//֐JE^ZbgB
			pFunc->uCnt = 0;
			//֐ĂяoB
			(*pFunc->fn)(pFunc->arg);
		}
	}
}
#else //PIECE
void TimMgr_Intr(ST_TimMgr* pTimMgr);
/*static*/ void TimMgr_Invoke(ST_TimMgrCh* pCh);
asm("
		.code
		.align		1
		.global		TimMgr_Intr
TimMgr_Intr:
		;//%r12 := pTimMgr
		xld.w		%r4, 65535			;//%r4  := USHRT_MAX
		ld.ub		%r5, [%r12]			;//%r5  := uAdd = pTimMgr->uAdd
		add		%r12, 4				;//%r12 := pCh = pTimMgr->TBL_TimMgrCh
TimMgr_Intr_LOOP:						;//for(;;) {
		ld.uh		%r6, [%r12]+			;//  %r6  := uSub = pCh->uSub, %r12 := &pCh->uErr
		cmp		%r6, 0				;//  if(!uSub) { break }
		jreq		TimMgr_Intr_1MS			;//  
		ld.uh		%r7, [%r12]			;//  %r7  := uErr = pCh->uErr
		add		%r7, %r5			;//  %r7  := uErr += uAdd
		cmp		%r7, %r4			;//  if(uErr > USHRT_MAX) {
		jrle		2				;//     uErr = USHRT_MAX
		 ld.w		%r7, %r4			;//  }
		ld.h		[%r12], %r7			;//  pCh->uErr = uErr
		jp.d		TimMgr_Intr_LOOP		;//}
		add		%r12, 10			;//  %r12 := pCh++	2Byteił̂Ŏc10Bytei߂B	*delay*
TimMgr_Intr_1MS:						;//
		sub		%r12, 2				;//%r12 := pCh		pCh=&pTimMgr->TBL_TimMgrCh[TimMgrCh_1ms]
TimMgr_Invoke:
		;//%r12 := pCh
		pushn		%r1				;//
		add		%r12, 4				;//%r12     :=               &pCh->uCnt
		ld.w		%r4, [%r12]			;//%r4      := uCnt        =  pCh->uCnt
		add		%r4, 1				;//%r4      := uCnt++							!INTERLOCK!
		ld.w		[%r12]+, %r4			;//pCh->uCnt = uCnt, %r12 := &pCh->pNext
		jp.d		TimMgr_Invoke_START		;//goto L_START
		ld.w		%r0, %r12			;//%r0      := ppNext      = &pCh->pNext				*delay*
TimMgr_Invoke_LOOP:						;//do {
		ld.w		%r4, [%r0]+			;//  %r4    := fn   = pFunc->fn   , %r0  := &pFunc->arg
		ld.w		%r12, [%r0]+			;//  %r12   := arg  = pFunc->arg  , %r0  := &pFunc->uItv
		ld.uh		%r5, [%r0]+			;//  %r5    := uItv = pFunc->uItv , %r0  := &pFunc->uCnt
		ld.uh		%r1, [%r0]			;//  %r1    := uCnt = pFunc->uCnt
		add		%r1, 1				;//  %r1    := uCnt++							!INTERLOCK!
		cmp		%r1, %r5			;//  if(uCnt >= uItv) {
		jrlt		3				;//    %r1  := uCnt = 0
		 call.d		%r4				;//    (*fn)(arg)
		 ld.w		%r1, 0				;//  }									*delay*
		ld.h		[%r0]+, %r1			;//  pFunc->uCnt = uCnt           , %r0  := ppNext = &pFunc->pNext
TimMgr_Invoke_START:						;//  
		ld.w		%r0, [%r0]			;//  %r0    := pFunc = *ppNext
		cmp		%r0, 0				;//} while(pFunc)							!INTERLOCK!
		jrne		TimMgr_Invoke_LOOP		;//
		popn		%r1				;//
		ret						;//
");
#endif//PIECE
/****************************************************************************
 *	gp
 ****************************************************************************/
#if 0
ST_TimMgr stTimMgr;
int cnt3ms,cnt100ms,cnt1f,cnt5f;
void   myFunc3ms(void* arg){  cnt3ms++;}//荞ݓŌĂяoB
void myFunc100ms(void* arg){cnt100ms++;}//
void    myFunc1f(void* arg){   cnt1f++;}//荞݊OŌĂяoB
void    myFunc5f(void* arg){   cnt5f++;}//
void init(){
#if 0
  //ÓIɊmۂST_TimMgrFunc\̂o^Bgݍ݊œIȃmۂꍇ͂B
  static ST_TimMgrFunc stFunc3ms  ={myFunc3ms  ,NULL,3};
  static ST_TimMgrFunc stFunc100ms={myFunc100ms,NULL,1};
  static ST_TimMgrFunc stFunc1f   ={myFunc1f   ,NULL,1};
  static ST_TimMgrFunc stFunc5f   ={myFunc5f   ,NULL,5};
  TimMgr_AddFunc(&stTimMgr,TimMgrCh_1ms  ,&stFunc3ms);
  TimMgr_AddFunc(&stTimMgr,TimMgrCh_100ms,&stFunc100ms);
  TimMgr_AddFunc(&stTimMgr,TimMgrCh_1f   ,&stFunc1f);
  TimMgr_AddFunc(&stTimMgr,TimMgrCh_1f   ,&stFunc5f);
#else
  //ST_TimMgrFunc\̂𓮓IɊmۂēo^BP/ECEWindowsœIȃmۂeՂȏꍇ͂B
  TimMgr_AddFunc_New(&stTimMgr,TimMgrCh_1ms  ,myFunc3ms  ,NULL,3);
  TimMgr_AddFunc_New(&stTimMgr,TimMgrCh_100ms,myFunc100ms,NULL,1);
  TimMgr_AddFunc_New(&stTimMgr,TimMgrCh_1f   ,myFunc1f   ,NULL,1);
  TimMgr_AddFunc_New(&stTimMgr,TimMgrCh_1f   ,myFunc5f   ,NULL,5);
#endif
}
int app_main(int argc, char* argv[]) {
  TimMgr_Init(&stTimMgr,30);
  timer_start(1,(void (*)(void*))TimMgr_Intr,&stTimMgr);
  init();
  for(;;){
    schedule();
    surface_clear(&surface,0);
    TimMgr_Exec(&stTimMgr);
    render_printf(&render,10,10,0,3,"%6d",TimMgr_GetCnt(&stTimMgr,TimMgrCh_1f));
    render_printf(&render,10,20,0,3,"%6d",TimMgr_GetCnt(&stTimMgr,TimMgrCh_10ms));
    render_printf(&render,10,30,0,3,"%6d",TimMgr_GetCnt(&stTimMgr,TimMgrCh_100ms));
    render_printf(&render,10,40,0,3,"%6d",TimMgr_GetCnt(&stTimMgr,TimMgrCh_1s));
    render_printf(&render,10,50,0,3,"%6d",TimMgr_GetCnt(&stTimMgr,TimMgrCh_1ms));
    render_printf(&render,50,10,0,3,"%6d %6d",cnt1f,cnt5f);
    render_printf(&render,50,30,0,3,"%6d"    ,cnt100ms);
    render_printf(&render,50,50,0,3,"%6d"    ,cnt3ms);
  }
  return 0;
}
#endif
