/*
 *	clipseh.h
 *
 *	\O (Structured Exception Handling)
 *
 *	CLiP - Common Library for P/ECE
 *	Copyright (C) 2015-2018 Naoyuki Sawa
 *
 *	* Fri Jul 03 01:00:00 JST 2015 Naoyuki Sawa
 *	- 1st [XB
 *	* Fri Jul 03 21:00:32 JST 2015 Naoyuki Sawa
 *	- clipseh.cɁugpvǋL܂B
 *	* Sun Oct 11 10:36:38 JST 2015 Naoyuki Sawa
 *	- gcc]vȌx△ʂȃR[h𐶐鎖L܂B
 *	  ڍׂclipseh.ću2015/10/11ɍsCeɂĂ̐vQƂĉB
 *	* Sun Oct 11 13:00:37 JST 2015 Naoyuki Sawa
 *	- ȉ_̋@\ǉ܂B
 *	  ̒ǉ@\́AP/ECEJ(GCC)łWindows(VC++6.0)łgpo܂B
 *	  1. O[oϐSEH_infoǉ܂B
 *	     OubN̒ŁAO𓊓\[XR[ḧʒuQƏo悤ɂȂ܂B
 *	  2. }NSEH_DIE()ǉ܂B
 *	     OubN̒ŉ񕜏oȂɁAO𓊓\[XR[ḧʒu\Ē~o悤ɂȂ܂B
 *	* Sun Oct 11 16:11:49 JST 2015 Naoyuki Sawa
 *	- [eBeB}NSEH_VERIFY()ǉ܂B
 *	* Tue Oct 13 22:12:29 JST 2015 Naoyuki Sawa
 *	- [eBeB}NSEH_use_shared,SEH_try_shared,SEH_VERIFY_SHARED()ǉ܂B
 *	* Wed Oct 14 21:50:46 JST 2015 Naoyuki Sawa
 *	- SEH_info\̂ɁA'msg'tB[hǉ܂B
 *	  ɔASEH_throw_msg()ǉ܂B
 *	- SEH_die()\t@CA܂ł̓tpX̂Ax[XɕύX܂B
 *	  SEH_throw()ŗO𓊓͎̂샂W[̃\[Xt@CłAtpXɂȂĂo邩łB
 *	  tpXŕ\ƒ߂ČĥŁAx[X\鎖ɂ܂B
 *	- SEH_die()ɁASEH_info.msg̕\ǉ܂B
 *	* Wed Nov 18 21:37:53 JST 2015 Naoyuki Sawa
 *	- 'extern "C" {'`'}'ň݂͂܂B.cpp܂Win32vWFNgCN[ho悤ɂ邽߂łB
 *	* Sat Jan 16 21:34:44 JST 2016 Naoyuki Sawa
 *	- Win32ŃfobKsꂽꍇ́Aŏʂ̗Ot[Ȃ悤ɂ܂B
 *	  ύXÓAIȗOt[ŗOꂽAŏʂ̗Ot[܂Ŋ߂ĕߑĂ܂A
 *	  ́AIȗOt[ŗOꂽȀŃu[N悤ɂȂ܂B(fobOŝ)
 *	  ڍׂ́ASEH_init()̃RgQƂĉB
 *	- ̕ύXɔA}N̍\啝ɕύX܂B
 *	  }N̍\啝ɕύX܂AR[h͏L̓_ȊOςĂȂ͂łB
 *	  ɁAWin32ȊÕvbgtH[ɑ΂āA̕ύXɂe͈ؖ͂łB
 *	  肪ꍇ́AO܂ł̃A[JCũ\[XR[hƔrĉB
 *	* Sun Apr 15 08:39:49 JST 2018 Naoyuki Sawa
 *	- SEH_return̎gɂďdvȒӓ_ɋCt̂ŁARgǋL܂B
 *	  ڍׂ́Aclipseh.hSEH_return̒`̏̃RgQƂĉB
 */
#ifndef __CLIP_SEH_H__
#define __CLIP_SEH_H__
#ifdef  __cplusplus
extern "C" {
#endif//__cplusplus
/****************************************************************************
 *	O[oϐ
 ****************************************************************************/
//AvP[VڎQƂȂŉB
extern jmp_buf* SEH_root;
//ŌɗO𓊓\[XR[ḧʒuB
//OubN̒ŃAvP[VڎQƏo܂B
extern struct SEH_info { const char* file; int line; char* msg; } SEH_info;
/****************************************************************************
 *	p֐,p}N
 ****************************************************************************/
//AvP[VڎgpȂŉB
#if     defined(PIECE)
  //P/ECE
  void SEH_die(const char* file, int line, int code) __attribute__((noreturn));
  int SEH_setjmp(jmp_buf node);
  void SEH_longjmp(int code) __attribute__((noreturn));
#elif   defined(WIN32)
  //Win32
  __declspec(noreturn) void SEH_die(const char* file, int line, int code);
  #define SEH_setjmp(__node__)						\
    setjmp(*(SEH_root = &(__node__)))
  #define SEH_longjmp(__code__)						\
    do { if(!SEH_root) { SEH_die(__FILE__, __LINE__, (__code__)); }	\
         longjmp((*SEH_root), (__code__)); } while(0)
#else //!defined(PIECE) && !defined(WIN32)
  //Generic
  void SEH_die(const char* file, int line, int code);
  #define SEH_setjmp(__node__)						\
    setjmp(*(SEH_root = &(__node__)))
  #define SEH_longjmp(__code__)						\
    longjmp((*SEH_root), (__code__))
#endif//!defined(PIECE) && !defined(WIN32)
/****************************************************************************
 *	AvP[Vp}N
 ****************************************************************************/
//OubN̒ŉ񕜏oȂɌĂяoĉB
#define SEH_DIE()							\
  SEH_die(__FILE__, __LINE__, SEH_code)
/*--------------------------------------------------------------------------*/
//ߑȂOߑăG[bZ[W\邽߂́AOt[܂B
//K{ł͗L܂񂪁A}NsɗOߑȂꍇ́Aُ퓮ƂȂ܂B
//AvP[V̎sɔjȂReLXgŁA}NsĂB
//ʓIɂ́AAvP[VGg|Cg(main֐)̐擪ŎŝK؂łB
// - Win32ŃfobKsꍇ́AOt[SEH_rootNULL̂܂܂ɂ܂B
//   SEH_throw,,SEH_throw_lastŗOꂽɁASEH_rootNULLȂ(=ߑOt[)̏Ńu[N܂B
//   ŔAŏʂ̗Ot[܂Ŋ߂ău[NAO𓊓ӏŃu[NfobOՂłB
// - L̓́AWin32ŃfobKsꍇ̂ݓKp܂BfobOrh[Xrh͊֌WL܂B
//   Win32ȊÕvbgtH[AWin32łexe𒼐ڎsꍇ́A܂Œʂŏʂ̗Ot[ŕߑ܂B
#ifdef  WIN32
  //Win32
  #define SEH_init()							\
    if(!IsDebuggerPresent()) { jmp_buf __SEH_node__;			\
         const int SEH_code = SEH_setjmp(__SEH_node__);			\
         if(SEH_code) { SEH_DIE(); } }
#else //WIN32
  //P/ECE,Generic
  #define SEH_init()							\
    do { jmp_buf __SEH_node__;						\
         const int SEH_code = SEH_setjmp(__SEH_node__);			\
         if(SEH_code) { SEH_DIE(); } } while(0)
#endif//WIN32
/*--------------------------------------------------------------------------*/
//OubNJn܂B
#define SEH_try								\
  { jmp_buf __SEH_node__, * const __SEH_save__ = SEH_root;		\
    const int SEH_code = SEH_setjmp(__SEH_node__);			\
    if(!SEH_code) {
/*--------------------------------------------------------------------------*/
//Ŏw肵OR[ĥ݂ߑ܂B
#define SEH_catch(__code__)						\
      SEH_root = __SEH_save__;						\
    } else if(SEH_code == (int)(__code__)) {				\
      SEH_root = __SEH_save__;
/*--------------------------------------------------------------------------*/
//SĂ̗OR[hߑ܂B
#define SEH_catch_all							\
    SEH_catch(SEH_code)
/*--------------------------------------------------------------------------*/
//OubNI܂B
#define SEH_end								\
      SEH_root = __SEH_save__;						\
    } else {								\
      SEH_root = __SEH_save__;						\
      SEH_throw_last;							\
  } }
/*--------------------------------------------------------------------------*/
//O𓊓܂B
//̎AŌɗO𓊓\[XR[ḧʒu(SEH_info)ݒ肵܂B
// - SEH_throw()́AbZ[W߂ɁASEH_info.msgNULLi[܂B
//   SEH_throw_msg()́Aw肳ꂽbZ[WASEH_info.msgɊi[܂B
// - SEH_info.msgɊi[镶́A{Iɂ́A萔łB
//   Iɐi[鎖\łAꍇAAvP[VSEH_info.msg̃ǗsĉB
//   Garbage collector삵ĂȂ΁AɈӎ鎖Astrdup_printf()œIɐi[o܂B
#define SEH_throw(__code__)						\
  SEH_throw_msg(__code__, NULL)
#define SEH_throw_msg(__code__, __msg__)				\
  do { SEH_info.file = __FILE__;					\
       SEH_info.line = __LINE__;					\
       SEH_info.msg  = (char*)(__msg__);				\
       SEH_longjmp((int)(__code__)); } while(0)
/*--------------------------------------------------------------------------*/
//catchubN̒ŎgpAߑOR[hʂ̗Ot[֍ē܂B
//̎AŌɗO𓊓\[XR[ḧʒu(SEH_info)ύX܂B
#define SEH_throw_last							\
  SEH_longjmp(SEH_code)
/*--------------------------------------------------------------------------*/
//tryubN̒֐𔲂ꍇ́Areturn̑SEH_returngĂB
//֐̖߂lwo܂B
// * Sun Apr 15 08:39:49 JST 2018 Naoyuki Sawa
// - SEH_return̎gɂďdvȒӓ_ɋCt̂ŁARgǋL܂B
//   ڍׂ́Aȉ̒ʂłB
// - yӁz
//   SEH_return̖߂lw肷ꍇAO𓊓\̂֐Ăяo𒼐ڎw肵Ă͂܂B
//     ~̗
//     int caller() {
//       SEH_try {
//         SEH_return callee();	//Ӑ}uSEH_root = __SEH_save__; return callee();vƓWJ܂Bcallee()ĂяoOɗOt[߂Ă܂Acallee()O𓊓ĂLb`o܂B
//       } SEH_catch(SelectException) {
//         return -1;
//       } SEH_end
//     }
//     int callee() {
//       for(;;) {
//          if(joy & TRG_A) { return 0; }
//          if(joy & TRG_B) { return 1; }
//          if(joy & TRG_SELECT) { SEH_throw(SelectException); }
//       }
//     }
//   SEH_return̖߂lɂ́AeϐO𓊓\̖֐Ăяow肵ĉB
//     
//     int caller() {
//       SEH_try {
//         int tmp = callee();	//uint tmp = callee(); SEH_root = __SEH_save__; return tmp;vƓWJ܂Bcallee()߂܂ł͗Ot[߂ꂸAcallee()OLb`o܂B
//         SEH_return tmp;
//       } SEH_catch(SelectException) {
//         return -1;
//       } SEH_end
//     }
//     int callee() {
//       for(;;) {
//          if(joy & TRG_A) { return 0; }
//          if(joy & TRG_B) { return 1; }
//          if(joy & TRG_SELECT) { SEH_throw(SelectException); }
//       }
//     }
#define SEH_return							\
  SEH_root = __SEH_save__; return
/****************************************************************************
 *	[eBeB}N
 ****************************************************************************/
//̊֐̒SEH_trygpꍇ́ASEH_try̑ɉL̃}NgpƃX^bNߖo܂B
// - ̊֐̒SEH_try𕡐gpƁAP/ECEJGCC͊eubN__SEH_node__̃ʂɊmۂĂ܂悤łB
//   SEH_try𐔉gpxȂΓɖ͗L܂񂪁A\gpꍇ̓X^bN̈悪mۂāAX^bNӂ邨ꂪ܂B
//   
//   SEH_try {		@	
//       `				
//   } SEH_end			@̃ubN𔲂@̃ubNŒ`__SEH_node__͂svłB
//   SEH_try {		A	ÃubN𔲂ÃubNŒ`__SEH_node__͂svłB
//       `				]āA@ƇAƇB__SEH_node__̓X^bNœ̈ɊmۏôARpC͂ꂪ킩炸ɌʂɊmۂĂ܂B
//   } SEH_end			
//   SEH_try {		B	
//       `
//   } SEH_end
//   ȉ̂悤ȃR[h܂B
//   
//   pushn %r0
//   xsub  %sp,%sp,72		@ABʂɊmۂĂ܂ĂBʁB{'xsub %sp,%sp,24'ŗǂB
//       `
//   ld.w  %r12,%sp		@
//   xcall SEH_setjmp
//       `
//   xadd  %r12,%sp,24	A					ʁB{'ld.w %r12,%sp'ŗǂB
//   xcall SEH_setjmp
//       `
//   xadd  %r12,%sp,48	B					ʁB{'ld.w %r12,%sp'ŗǂB
//   xcall SEH_setjmp
//       `
//   xadd  %sp,%sp,72
//   popn  %r0
//   ret
//   NOTE:P/ECEJGCC(ver2.7.2)ƁAVC++6.0ł́AL̂Ƃ薳ʂȃX^bN̈mۂR[h܂Bő̍œKw肵ĂʂłB
//        ŐVx86pGCC(ver4.8.1)Ȃ΁AœKw肵ȂĂA@ABœX^bN̈gpR[h܂BŐVGCCł͉PĂ悤łB
// - L̖邽߂ɁA֐̐擪__SEH_node_shared__`ĂA֐ł͂ėp}Npӂ܂B
//   ȉ̂悤ɎgpĉB
//   
//   SEH_use_shared;
//   SEH_try_shared {
//       `
//   } SEH_end
//   SEH_try_shared {
//       `
//   } SEH_end
//   SEH_try_shared {
//       `
//   } SEH_end
//   ȉ̂悤ȃR[h܂B
//   
//   pushn %r0
//   xsub  %sp,%sp,24
//       `
//   ld.w  %r12,%sp
//   xcall SEH_setjmp
//       `
//   ld.w  %r12,%sp
//   xcall SEH_setjmp
//       `
//   ld.w  %r12,%sp
//   xcall SEH_setjmp
//       `
//   xadd  %sp,%sp,24
//   popn  %r0
//   ret
// - !!ӓ_!!
//   OubNlXgĂꍇ́Ã[eBeB}NgpĂ͂܂B
//   ȉ̎gp@͌łB
//   ~
//   SEH_use_shared;
//   SEH_try_shared {		@
//       `
//     SEH_try_shared {	B__SEH_node_shared__͇@̃ubN܂gpȂ̂ɁAōėpĂ܂ĂB
//         `
//     } SEH_end
//       `
//   } SEH_end
#define SEH_use_shared							\
  jmp_buf __SEH_node_shared__
#define SEH_try_shared							\
  { jmp_buf* const __SEH_save__ = SEH_root;				\
    const int SEH_code = SEH_setjmp(__SEH_node_shared__);		\
    if(!SEH_code) {
/*--------------------------------------------------------------------------*/
//'action'̒ŔCӂ̗OꂽAOꂽʒuƁAĂяo(̃}NLqʒu)\āAG[~܂B
//̃[eBeB}N̎gp͕K{ł͗L܂BAvP[VIɗOߑăG[~鎖ƓʂɂȂ܂B
// - <gp>
//   
//   SEH_VERIFY(dVal=PrpHdr_fget_l(phApp,PrpVar_x,-1));
//   SEH_VERIFY(PrpHdr_fset_l(phApp,1.23,PrpVar_y,-1);
//              PrpHdr_fset_l(phApp,4.56,PrpVar_z,-1));
// - !!ӓ_!!
//   ̊֐SEH_VERIFY()gpƁAX^bNӂ邨ꂪ܂B
//   ̃}N̗pړIlāA̊֐SEH_VERIFY()gp鎖͗L蓾Ǝv̂ŁAӂĂB
//   X^bNӂȂ悤ɂɂ́ASEH_VERIFY()̑SEH_VERIFY_SHARED()gpĉB
#define SEH_VERIFY(action)						\
  SEH_try {								\
    action;								\
  } SEH_catch_all {							\
    SEH_DIE();								\
  } SEH_end
//SEH_VERIFY()̃X^bNߖłłB
//ڍׂ́ASEH_use_shared,SEH_try_shared̐QƂĉB
// - <gp>
//  
//  SEH_use_shared;
//  SEH_VERIFY_SHARED(dVal=PrpHdr_fget_l(phApp,PrpVar_x,-1));
//  SEH_VERIFY_SHARED(dVal=PrpHdr_fget_l(phApp,PrpVar_x,-1));
//  SEH_VERIFY_SHARED(PrpHdr_fset_l(phApp,1.23,PrpVar_y,-1);
//                    PrpHdr_fset_l(phApp,4.56,PrpVar_z,-1));
#define SEH_VERIFY_SHARED(action)					\
  SEH_try_shared {							\
    action;								\
  } SEH_catch_all {							\
    SEH_DIE();								\
  } SEH_end
#ifdef  __cplusplus
}//extern "C"
#endif//__cplusplus
#endif//__CLIP_SEH_H__
