/*	
 *	clipsap.c
 *
 *	P/ECE SAP Driver
 *
 *	CLiP - Common Library for P/ECE
 *	Copyright (C) 2001-2017 Naoyuki Sawa
 *
 *	* Mon Jan 26 06:00:00 JST 2004 Naoyuki Sawa
 *	- 쐬JnB
 *	* Wed Aug 16 22:59:27 JST 2017 Naoyuki Sawa
 *	- 64rbgΉ̂߂ɁASTREAMCALLBACKparam̌^Aintintptr_tɕύX܂B
 */
#include "clip.h"

/****************************************************************************
 *	M6502G~[VpO֐
 ****************************************************************************/

#ifdef SAP_IO_READ /* I/O READΉ̂ */
unsigned char
sap_m6502_in(M6502* m6502, unsigned short addr)
{
	SAPDRIVER* sap = (SAPDRIVER*)m6502;
	unsigned char* mem = sap->mem;
	POKEY* pokey = &sap->pokey;

	/* 0xd200-0xd20f: POKEY */
	if(addr >= 0xd200 && addr <= 0xd20f) {
		return pokey_read(pokey, addr - 0xd200);
	}

	return mem[addr];
}
#endif /*SAP_IO_READ*/

void
sap_m6502_out(M6502* m6502, unsigned short addr, unsigned char data)
{
	SAPDRIVER* sap = (SAPDRIVER*)m6502;
	unsigned char* mem = sap->mem;
	POKEY* pokey = &sap->pokey;

	/* 0xd200-0xd20f: POKEY */
	if(addr >= 0xd200 && addr <= 0xd20f) {
		pokey_write(pokey, addr - 0xd200, data);
		return;
	}

	mem[addr] = data;
}

/****************************************************************************
 *	SAPhCo֐
 ****************************************************************************/

/* [`/t[`̌ĂяovO */
static const unsigned char sap_program[] = {
	'\x20',		/* +0: JSR Absolute */
	'\x00',		/* +1: ɌĂяoAhX̉ʃoCgZbg */
	'\x00',		/* +2: ɌĂяoAhX̏ʃoCgZbg */
	'\xcb',		/* +3: WAI */
};			/* =4 */
/* ĂяovO]AhX
 * Operating System ROM area(0xf000`0xffff)̖߂A
 * xN^e[u(0xfffa`0xffff)̒O߂ɒuƂɂ܂B
 */
#define SAP_PROGRAM_ADDRESS	0xfff0 /*  */
/* Ăяo([`/t[`)AhXZbgAhX
 * ĂяovÓuJSR Absolutev߂̃IyhƂȂ܂B
 */
#define SAP_RUN_PC_ADDRESS	(SAP_PROGRAM_ADDRESS + 1)

void
sap_m6502_setup(SAPDRIVER* sap, int a, int x, int y, int pc)
{
	M6502* m6502 = &sap->m6502;
	unsigned char* mem = sap->mem;

	/* ĂяovOoRŁAĂяovOĂяo܂B */
	mem[SAP_RUN_PC_ADDRESS + 0] = pc & 0xff;
	mem[SAP_RUN_PC_ADDRESS + 1] = pc >> 8;
	m6502->a = a;
	m6502->x = x;
	m6502->y = y;
	m6502->pc = SAP_PROGRAM_ADDRESS;
	m6502->sp = 0xff;
	m6502->wait = 0;  /* Kv!! */
	m6502->cycle = 0; /* Kv!! */
}

int
sap_init(SAPDRIVER* sap, const void* _data, int len, int i_song)
{
	M6502* m6502 = &sap->m6502;
	unsigned char* mem = sap->mem;
	POKEY* pokey = &sap->pokey;
	SAPHEADER* header = &sap->header;
	//
	const unsigned char* data = (const unsigned char*)_data;
	const unsigned char* data_end = data + len; /* SAPf[^I[AhX */
	unsigned short load_addr;
	unsigned short end_addr;
	int load_size;

	/* ܂NA܂B */
	memset(sap, 0, sizeof(SAPDRIVER));

	/* [`/t[`ĂяovO]܂B */
	memcpy(&mem[SAP_PROGRAM_ADDRESS], sap_program, sizeof sap_program);

	/* t@Cwb_͂܂B */
	data = (const unsigned char*)sap_init_header(header, data);
	if(!data) return -1; /* t@Cwb_s */

	/* v!![hubN͕܂!! */
	while(data < data_end) {
		/* [hAhX͈͂擾܂B */
		load_addr = data[0] | data[1] << 8; data += 2;	/* [hubN擪AhX */
		end_addr  = data[0] | data[1] << 8; data += 2;	/* [hubNI[AhX(ŏIoCgwĂ܂) */
		load_size = (end_addr - load_addr) + 1;		/* [hubNTCY */

		//if(load_size < 0) return -1; /* [hAhXs */
		//if(data + load_size > data_end) return -1; /* [hubNSAPf[^I[𒴉߂Ă */
		//2004/01/29 Naoyuki Sawa
		//HɃ[hubNt@CI[𒴉߂Ă܂ĂSAPt@C܂B
		//G[łƎv̂łASAPvC[ł͉tłĂ̂ŁA
		//[hTCYt@CI[܂łɏCċ~ς邱Ƃɂ܂B
		if(data + load_size > data_end) load_size = data_end - data;
		if(load_size < 0) return -1; /* [hAhXs */

		/* vO[h܂B */
		memcpy(&mem[load_addr], data, load_size);
		data += load_size;
	}

	/* tȔԍ肵܂B */
	if(i_song < 0) i_song = header->defsong; /* ɂȔԍw薳(i_song<0)ȂADEFSONGgp */
	if(i_song < 0 || header->songs - 1 < i_song) return -1;

	/* CPUZbgB */
#ifdef SAP_IO_READ /* I/O READΉ̂ */
	m6502_reset(m6502, sap_m6502_read, sap_m6502_write);
#else /*SAP_IO_READ*/
	m6502_reset(m6502, NULL, sap_m6502_write);
#endif /*SAP_IO_READ*/

	/* POKEYZbgB */
	pokey_reset(pokey, SAP_CLOCK);

	/* TYPEɂ... */
	switch(header->type) {
	case 'B': /* Any player */
		if(!header->init || !header->player) return -1; /* INIT,PLAYERK{ */
		sap_m6502_setup(sap,
			/*A */i_song,
			/*X */0,
			/*Y */0,
			/*PC*/header->init);
		m6502_run(m6502, SAP_CLOCK); /* 1bȓɊƉ  */
		if(!m6502->wait) return -1;  /* Ȃ΃G[ */
		break;
	case 'C': /* Player from CMC (Chaos Music Composer) */
		if(!header->music || !header->player) return -1; /* MUSIC,PLAYERK{ */
		sap_m6502_setup(sap,
			/*A */0x70,
			/*X */(unsigned char)header->music,
			/*Y */(unsigned char)(header->music >> 8),
			/*PC*/header->player + 3);
		m6502_run(m6502, SAP_CLOCK); /* 1bȓɊƉ  */
		if(!m6502->wait) return -1;  /* Ȃ΃G[ */
		sap_m6502_setup(sap,
			/*A */0x00,
			/*X */i_song,
			/*Y */0,
			/*PC*/header->player + 3);
		m6502_run(m6502, SAP_CLOCK); /* 1bȓɊƉ  */
		if(!m6502->wait) return -1;  /* Ȃ΃G[ */
		break;
	case 'D': /* Digital */
		/* TODO: Ή */
		return -1;
	case 'S': /* SoftSynth */
		/* TODO: Ή */
		return -1;
	default:
		return -1; /* TYPEs */
	}

	/* 荞݊Ԋȕo̓TvvZpDDAZbgAbvB
	 * (FASTPLAY=3121/50bAFASTPLAY=1561/100bA...)
	 */
	if(header->fastplay <= 0) return -1;
	sap->samples_dda.u = SAPBUFLEN * header->fastplay / 312;
	sap->samples_dda.n = SAPBUFLEN * header->fastplay % 312;
	sap->samples_dda.d =                               -312;
	sap->samples       = sap->samples_dda.u; /* 񊄂荞݂܂ł̏o̓Tvݒ */

	return 0;
}

/* sǂݍ݂܂B
 * [in]
 *	buf		ǂݍ񂾍si[obt@B
 *	size		obt@TCY[oCg]B
 *	data		ǂݍ݌AhXB
 * [out]
 *	߂l		̍s̊JnAhXB
 *			săobt@TCY𒴂ꍇ͎sƌȂANULLԂ܂B
 *	buf[...]	ǂݍ񂾍si[܂B
 *			I[̉s{CR,LF}͊i[܂B
 * [note]
 *	* sap_init_header()痘p邽߂ɗpӂ܂B
 *	  SAPt@C̃eLXgZNVǂݍݗpɓĂ܂B
 *	* s̏I[{CR,LF}łB'\0'͏I[Ƃ͌Ȃ܂B
 *	  2004/01/27ύX
 *	  SAPt@CɂċHCRorLF̂̂̂ŁAΉ܂B
 *	* oCiZNV̊Jn}[N{'\xff','\xff'}͐ɔfĂB
 *	  sap_gets()̓oCiZNV̊JnF܂B
 */
static const char*
sap_gets(char buf[/*size*/], int size, const char* data)
{
	char c;

	/* CRorLFɏo܂ŃRs[܂B */
	for(;;) {
		if(!size) return NULL; /* s */
		c = *data++;
		if(c == '\xd' || c == '\xa') break;
		*buf++ = c;
		size--;
	}
	*buf = '\0'; /* I[i[ */

	/* ACRorLFǂݔ΂܂B */
	for(;;) {
		c = *data;
		if(c != '\xd' && c != '\xa') break;
		data++;
	}
	return data;
}

const void*
sap_init_header(SAPHEADER* header, const void* _data)
{
	const char* data = (const char*)_data;
	char buf[256]; /* eLXgZNV̊es͍Œł256Ɖ */

	/* ܂NAB */
	memset(header, 0, sizeof(SAPHEADER));

	/* Kli[B */
	header->songs = 1; /* dlɂ͋Kl0ƏĂ܂A1̊ԈႢƎv܂ */
	header->defsong = 0;
	header->fastplay = 312;

	/* VOl`B */
	data = sap_gets(buf, sizeof buf, data);
	if(!data) return NULL;
	if(strcmp(buf, "SAP") != 0) return NULL;

	for(;;) {
		/* oCiZNVJn? */
		if(data[0] == '\xff' && data[1] == '\xff') { data += 2; break; }

		/* sǂݍ݁B */
		data = sap_gets(buf, sizeof buf, data);
		if(!data) return NULL;

		/* śB */
#if 0
		if(sscanf(buf, "AUTHOR \"%31[^\"]\"", header->author  ) == 1) continue;
		if(sscanf(buf, "NAME \"%31[^\"]\"",   header->name    ) == 1) continue;
		if(sscanf(buf, "DATE \"%31[^\"]\"",   header->date    ) == 1) continue;
#else		// EPSONCusscanf()"[...]"ɑΉĂȂ̂Ł̃R[h͎g܂B
		// dȂ̂Ŏ͂œǂݍ݂܂BꂿƂsscanf()֐܂傤B
		#define SAPSCANF(IN, TAG, OUT, SIZE) {							\
			unsigned char* in = (IN);							\
			int taglen = strlen(TAG);							\
			int i, c;									\
			if(strncmp(in, (TAG), taglen) == 0) {	/* ^Ov... */		\
				in += taglen;			/* ^O΂ */			\
				while(isspace(*in)) in++;	/* Zp[^΂ */		\
				if(*in != '"') return NULL;	/* u"vŊJnĂȂ΃G[ */	\
				in++;				/* u"v΂ */			\
				for(i = 0; i < (SIZE); i++) {	/* I[nulSIZE[]܂ */	\
					c = *in++;		/* ꕶǂݍ */			\
					if(!c) return NULL;	/* u"vɏI[ɒBG[ */	\
					if(c == '"') break;	/* u"vI[B */	\
					(OUT)[i] = c;		/* ꕶi[ */			\
				}									\
				(OUT)[i] = '\0';		/* I[nuli[ */			\
				continue;			/* ǂݍݐA̍s */		\
			}										\
		}
		SAPSCANF(buf, "AUTHOR", header->author, 31)
		SAPSCANF(buf, "NAME",   header->name,   31)
		SAPSCANF(buf, "DATE",   header->date,   31)
		#undef SAPSCANF
#endif
		if(sscanf(buf, "TYPE %1s",           &header->type    ) == 1) continue;
		if(sscanf(buf, "PLAYER %hx",         &header->player  ) == 1) continue;
		if(sscanf(buf, "MUSIC %hx",          &header->music   ) == 1) continue;
		if(sscanf(buf, "INIT %hx",           &header->init    ) == 1) continue;
		if(sscanf(buf, "SONGS %d",           &header->songs   ) == 1) continue;
		if(sscanf(buf, "DEFSONG %d",         &header->defsong ) == 1) continue;
		if(sscanf(buf, "FASTPLAY %d",        &header->fastplay) == 1) continue;
		if(strcmp(buf, "STEREO") == 0)      { header->stereo = 1;     continue; }
		return NULL; /* ^Os */
	}

	return data;
}

int
sap_mix(SAPDRIVER* sap, short* wbuff)
{
	M6502* m6502 = &sap->m6502;
	POKEY* pokey = &sap->pokey;
	SAPHEADER* header = &sap->header;
	//
	int cnt1 = SAPBUFLEN;	/* cTv */
	int cnt2;

	do {
		/* obt@邩A܂͊荞ݔ܂ł̃Tv... */
		cnt2 = sap->samples;
		if(cnt2 > cnt1) cnt2 = cnt1;

		/* ~LVOs܂B */
		pokey_mix(pokey, wbuff, cnt2);
		wbuff += cnt2;
		cnt1 -= cnt2;

		/* 荞ݔ܂ł̎co̓Tv炵āA0ɂȂ... */
		sap->samples -= cnt2;
		if(!sap->samples) {
			/* 񊄂荞ݔ܂ł̎co̓TvvZ܂B */
			sap->samples = sap->samples_dda.u;
			sap->samples_dda.d += sap->samples_dda.n;
			if(sap->samples_dda.d >= 0) {
				sap->samples_dda.d -= 312;
				sap->samples++;
			}

			/* 荞݉t[`Ăт܂B */
			switch(header->type) {
			case 'B': /* Any player */
				sap_m6502_setup(sap,
					/*A */0,
					/*X */0,
					/*Y */0,
					/*PC*/header->player);
				m6502_run(m6502, SAP_CLOCK); /* 1bȓɊƉ  */
				if(!m6502->wait) return -1;  /* Ȃ΃G[ */
				break;
			case 'C': /* Player from CMC (Chaos Music Composer) */
				sap_m6502_setup(sap,
					/*A */0,
					/*X */0,
					/*Y */0,
					/*PC*/header->player + 6);
				m6502_run(m6502, SAP_CLOCK); /* 1bȓɊƉ  */
				if(!m6502->wait) return -1;  /* Ȃ΃G[ */
				break;
			case 'D': /* Digital */
				/* TODO: Ή */
				return -1;
			case 'S': /* SoftSynth */
				/* TODO: Ή */
				return -1;
			default:
				return -1; /* TYPEs */
			}
		}
	} while(cnt1);

	return 0;
}

int
//{{2017/08/16ύX:64rbgΉ̂߂ɁASTREAMCALLBACKparam̌^Aintintptr_tɕύX܂B
//sap_stream_callback(short* wbuff, int param)
//2017/08/16ύX:64rbgΉ̂߂ɁASTREAMCALLBACKparam̌^Aintintptr_tɕύX܂B
sap_stream_callback(short* wbuff, intptr_t param)
//}}2017/08/16ύX:64rbgΉ̂߂ɁASTREAMCALLBACKparam̌^Aintintptr_tɕύX܂B
{
	return sap_mix((SAPDRIVER*)param, wbuff);
}

/****************************************************************************
 *	AvP[Vp֐
 ****************************************************************************/

int
sap_play(const void* data, int len, int i_song)
{
	static SAPDRIVER sap; /* STATICł! */

	/* ܂mɒ~܂B */
	sap_stop();

	/* SAPhCo܂B */
	if(sap_init(&sap, data, len, i_song) != 0) return -1;

	/* Xg[ĐJn܂B */
//{{2017/08/16ύX:64rbgΉ̂߂ɁASTREAMCALLBACKparam̌^Aintintptr_tɕύX܂B
//	stream_play(SAPBUFLEN, sap_stream_callback, (int)&sap, 1/*X^bN؊gp*/);
//2017/08/16ύX:64rbgΉ̂߂ɁASTREAMCALLBACKparam̌^Aintintptr_tɕύX܂B
	stream_play(SAPBUFLEN, sap_stream_callback, (intptr_t)&sap, 1/*X^bN؊gp*/);
//}}2017/08/16ύX:64rbgΉ̂߂ɁASTREAMCALLBACKparam̌^Aintintptr_tɕύX܂B

	return 0;
}

void
sap_stop()
{
	/* Xg[Đ~܂B */
	stream_stop();

	/* SAPhCõN[Abv͕svłB */
}

