/*	
 *	clips3m.c
 *
 *	P/ECE S3M Driver
 *
 *	CLiP - Common Library for P/ECE
 *	Copyright (C) 2001-2017 Naoyuki Sawa
 *
 *	* Tue Nov 14 20:03:00 JST 2004 Naoyuki Sawa
 *	- 쐬JnB
 *	* Wed Aug 16 22:59:27 JST 2017 Naoyuki Sawa
 *	- 64rbgΉ̂߂ɁASTREAMCALLBACKparam̌^Aintintptr_tɕύX܂B
 */
#include "clip.h"

/* * G[R[h̒ĺAsԍ𕉒lɂ̂łB
 *   vOCƁAG[R[hς\܂B
 *   G[R[h̒ĺAfobÔ߂ɗpĂB
 */
#define ERRNO	(-__LINE__)

/*
 *	-------	-------	-----------------------	-------	-----------------------
 *	Special					S3mod	
 *	Command	Name	Description		Support	Comment
 *	-------	-------	-----------------------	-------	-----------------------
 *	 1	Axy	Set speed			
 *	 2	Bxy	Position jump			
 *	 3	Cxy	Pattern break			
 *	 4	Dxy	Volume slide			
 *	 5	Exy	Portamento down			
 *	 6	Fxy	Portamento up			
 *	 7	Gxy	Tone portamento			
 *	 8	Hxy	Vibrato				
 *	 9	Ixy	Tremor				
 *	10	Jxy	Arpeggio			
 *	11	Kxy	Volslide+Vibrato		
 *	12	Lxy	Volslide+Toneporta		
 *	13	Mxy	Set channel volume		
 *	14	Nxy	Channel volslide		
 *	15	Oxy	Set offset			
 *	16	Pxy	Panning slide			
 *	17	Qxy	Retrigger note			
 *	18	Rxy	Tremolo				
 *	19	Sxy	Extended S3M commands		
 *	20	Txy	Set tempo			
 *	21	Uxy	Fine vibrato			
 *	22	Vxy	Set global volume		
 *	23	Wxy	Global volume slide		
 *	24	Xxy	Set panning			
 *	25	Yxy	Panbrello			
 *	26	Zxy	Midi macro			
 *	-------	-------	-----------------------	-------	-----------------------
 *	19	S0x	Set filter			Modplug Tracker͖Ή
 *	19	S1x	Glissando control		
 *	19	S2x	Set finetune			MODƂ̌݊̂߂̂
 *	19	S3x	Vibrato waveform		
 *	19	S4x	Tremolo waveform		
 *	19	S5x	Panbrello waveform		
 *	19	S6x	Fine pattern delay		
 *	19	S7x	Envelope and New Note		Modplug Tracker͖Ή
 *			Action (NNA) control		
 *	19	S8x	Set panning			
 *	19	S9x	Sound control			
 *	19	SAx	Set high offset			
 *	19	SBx	Pattern loop			
 *	19	SCx	Note cut			
 *	19	SDx	Note delay			
 *	19	SEx	Pattern delay			
 *	19	SFx	Funkrepeat			Modplug Tracker͖Ή
 *	-------	-------	-----------------------	-------	-----------------------
 */

/*
 *	NoteEInstLł̔ɂ
 *	======================================
 *
 *	S3MŁANoteEInstLł̔sƁAInstVolumeKp܂B
 *	 NoteLEInstł̔sƁAoInstKp܂B
 *	Inst𖾎Ȃꍇ́AVolume݂͌̒lێ܂B
 *	̗QƂĂB
 *
 *		==Channel 1==
 *		C-5 01 -- ---	; Inst=01ŔJnAVol=Vol(Inst 01)ɕύX
 *		--- 02 -- ---	; Inst=01ŔpAVol=Vol(Inst 02)ɕύX
 *		--- --v16 ---	; Inst=01ŔpAVol=16ɕύX
 *		C-5 -- -- ---	; Inst=02ŔJnAVol=16ێ
 *
 *	ȏ̓́uModplug Tracker version 1.16.0204vŊmF܂B
 */

/****************************************************************************
 *	P/ECE S3M Driver
 ****************************************************************************/

/*
 *	NoteFrequency̎Zo@
 *	===========================
 *
 *	Documentɂ́Â悤ɏĂ܂B
 *
 *	---------------------------------------------------------------------
 *
 *	                  8363 * 16 * ( period(NOTE) >> octave(NOTE) )
 *	note_st3period = ----------------------------------------------
 *	                       middle_c_finetunevalue(INSTRUMENT)
 *
 *	note_amigaperiod = st3_period / 4
 *
 *	note_herz = 14317056 / note_st3period
 *
 *	Note that ST3 uses period values that are 4 times larger than the
 *	amiga to allow for extra fine slides (which  are 4 times finer
 *	than normal fine slides).
 *
 *	---------------------------------------------------------------------
 *
 *	킩ՂƁÂ悤ɂȂ܂B
 *
 *	---------------------------------------------------------------------
 *
 *	                     (8363 << 4) * (s3m_note_frequency_table[Note & 15] >> (Note >> 4))
 *	S3MCHANNEL.period = --------------------------------------------------------------------
 *	                                      C2spd(S3MCHANNEL.playing_sample)
 *
 *	frequency = 14317056 / S3MCHANNEL.period
 *
 *	---------------------------------------------------------------------
 *
 *	ST3 periodAmiga periodɂ
 *	================================
 *
 *	S3MCHANNEL.period́AST3 periodłB
 *	ST3 period́AAmiga period4{̐x܂B
 *
 *	E           Portamento up/dowńAAmiga periodPʂŌpĂ܂B
 *	E      Fine portamento up/dowńAAmiga periodPʂňx܂B
 *	EExtra fine portamento up/dowńA  ST3 periodPʂňx܂B
 *
 *	Ƃ΁A
 *
 *	EE01(           Portamento down 1)́AS3MCHANNEL.period4Â܂B
 *	EEF1(      Find portamento down 1)́AS3MCHANNEL.period4܂B
 *	EEE1(Extra fine portamento down 1)́AS3MCHANNEL.period1܂B
 *
 *	PeriodFrequency̋tȂ̂ŁAtł邱ƂɒӂĂB
 */
const short s3m_note_frequency_table[12] = {
	1712,	/*  0: C  */
	1616,	/*  1: C# */
	1524,	/*  2: D  */
	1440,	/*  3: D# */
	1356,	/*  4: E  */
	1280,	/*  5: F  */
	1208,	/*  6: F# */
	1140,	/*  7: G  */
	1076,	/*  8: G# */
	1016,	/*  9: A  */
	 960,	/* 10: A# */
	 907,	/* 11: B  */
};

static int
_s3m_init(S3MDRIVER* driver, const void* data, int initial_row)
{
	const S3MMODULEHEADER* module_header;
	const S3MSAMPLEHEADER* sample_header;
	//int order;
	int i_sample;
	int i_pattern;
	int i_channel;
	//const unsigned short* parapointers_to_instruments;
	//const unsigned short* parapointers_to_patterns;
	//2004/11/17 Naoyuki Sawa OrdnumΉ
	const unsigned char* parapointers_to_instruments;
	const unsigned char* parapointers_to_patterns;
	S3MSAMPLE* sample;
	S3MCHANNEL* channel;

	/* ܂AS3MDRIVER\̂NA܂B */
	memset(driver, 0, sizeof(S3MDRIVER));

	/***********************
	 *  S3M Module header  *
	 ***********************/

	module_header = (const S3MMODULEHEADER*)data;

	/* ŒtB[h܂B */
	if(module_header->_1ah != '\x1a') {
		return ERRNO; /* ŒtB[hs */
	}
	if(module_header->type != 16) {
		return ERRNO; /* ST3 moduleȊO肦Ȃ */
	}
	if(module_header->ffv != 2) {
		return ERRNO; /* standard̂ݑΉ */
	}
	if(memcmp(module_header->scrm, "SCRM", 4) != 0) {
		return ERRNO; /* VOl`s */
	}

	/* OrdnumAInsnumAPatnum擾܂B */
	driver->ordnum = module_header->ordnum;
	//if((driver->ordnum < 1) ||
	//   (driver->ordnum & 1)) {
	//	return ERRNO; /* Ordnums܂͊ */
	//}
	//dlłOrdnumłȂ΂Ȃ̂łAɊS3Mt@C݂܂B(PARTY92.S3M)
	//dȂ̂ŁAOrdnume邱Ƃɂ܂BOrdnum̏ꍇAOrderstB[hTCYɂȂ邽߁A
	//OrderšɂParapointers to instrumentsParapointers to patterns̊etB[hHalfWord񂳂܂B
	//Parapointers to instrumentsParapointers to patterns̊etB[h̓ǂݍ݂́ALEHALF}NgĂB
	if(driver->ordnum < 1) {
		return ERRNO; /* Ordnums */
	}
	driver->insnum = module_header->insnum;
	if(driver->insnum < 1) {
		return ERRNO; /* Insnums */
	}
	driver->patnum = module_header->patnum;
	if(driver->patnum < 1) {
		return ERRNO; /* Patnums */
	}

	/* Global volumeAInitial speedAInitial tempo擾܂B */
	driver->g_v = module_header->g_v;
	driver->speed = module_header->i_s;
	if(driver->speed < 1) {
		return ERRNO; /* Initial speeds */
	}
	driver->tempo = module_header->i_t;
	if(driver->tempo < 1) {
		return ERRNO; /* Initial tempos */
	}

	/* OrdersAParapointers to instrumentsAParapointers to patterns̃AhX擾܂B */
	driver->orders              = (const unsigned char *)((int)module_header               + sizeof(S3MMODULEHEADER)                 );
      //parapointers_to_instruments = (const unsigned short*)((int)driver->orders              + sizeof(unsigned char  ) * driver->ordnum);
      //parapointers_to_patterns    = (const unsigned short*)((int)parapointers_to_instruments + sizeof(unsigned short ) * driver->insnum);
      //2004/11/17 Naoyuki Sawa OrdnumΉ
	parapointers_to_instruments = (const unsigned char *)((int)driver->orders              + sizeof(unsigned char  ) * driver->ordnum);
	parapointers_to_patterns    = (const unsigned char *)((int)parapointers_to_instruments + sizeof(unsigned short ) * driver->insnum);

	/* Orders܂B */
	//for(order = 0; order < driver->ordnum; order++) {
	//	i_pattern = driver->orders[order];
	//	if((i_pattern == 254) ||
	//	   (i_pattern == 255)) {
	//		continue; /* 254(XLbv)255(I)͋ */
	//	}
	//	if((i_pattern < 0) ||
	//	   (i_pattern > driver->patnum - 1)) {
	//		return ERRNO; /* Patternԍs */
	//	}
	//}
	//sPatternԍ܂S3Mt@CƂǂ݂悤Ȃ̂ŁAȂƂɂ܂B
	//  sPatternԍ͉tɌoASongIƌȂ܂B

	/* S3MSAMPLE\̔zmۂ܂B */
	driver->samples = calloc(driver->insnum, sizeof(S3MSAMPLE));
	if(!driver->samples) {
		return ERRNO;
	}

	/* eSampleɂ... */
	for(i_sample = 0, sample = driver->samples;
	    i_sample < driver->insnum;
	    i_sample++, sample++) {

		/* Digiplayer ST3/ samplefileformat̃AhX߂܂B */
		//sample_header = (const S3MSAMPLEHEADER*)((int)module_header +
		//					 (parapointers_to_instruments[i_sample] << 4));
		//2004/11/17 Naoyuki Sawa OrdnumΉ
		sample_header = (const S3MSAMPLEHEADER*)((int)module_header +
							 (LEHALF(&parapointers_to_instruments[sizeof(unsigned short) * i_sample]) << 4));

		/* Type=1(Sample)ȊOȂ΁AXLbv܂B */
		if(sample_header->type != 1) {
			continue;
		}

		/* ŒtB[h܂B */
		if(memcmp(sample_header->scrs, "SCRS", 4) != 0) {
			return ERRNO; /* VOl`s */
		}

		/* SampledataAhXZo܂B */
		sample->sampledata = (const unsigned char *)((int)module_header +
							     (sample_header->memseg << 4));
		if(sample_header->length < 1) {
			return ERRNO; /* Lengths */
		}
		if(!(sample_header->flags & 1)) { /* Loop off */
			sample->loop_end = sample->sampledata + sample_header->length;
		} else { /* Loop on */
			if((sample_header->loop_begin < 0) ||
			   (sample_header->loop_begin >= sample_header->length)) {
				return ERRNO; /* Loop begins (1..(Length-1)K{) */
			}
			if((sample_header->loop_end <= 0) ||
			   (sample_header->loop_end > sample_header->length)) {
				return ERRNO; /* Loop ends (0..(Length)K{) */
			}
			if(sample_header->loop_begin >= sample_header->loop_end) {
				return ERRNO; /* Loop begin/ends ((Loop begin)<(Loop end)K{) */
			}
			sample->loop_begin = sample->sampledata + sample_header->loop_begin;
			sample->loop_end = sample->sampledata + sample_header->loop_end;
		}

		/* VolAC2spd擾܂B */
		sample->vol = sample_header->vol;
		sample->c2spd = sample_header->c2spd;
		if(sample->c2spd < 1) {
			return ERRNO; /* C2spds (PeriodZõ[Zh~) */
		}
	}

	/* Patternszmۂ܂B */
	driver->patterns = calloc(driver->patnum, sizeof(const unsigned char*));
	if(!driver->patterns) {
		return ERRNO;
	}

	/* ePatternɂ... */
	for(i_pattern = 0;
	    i_pattern < driver->patnum;
	    i_pattern++) {

		/* Packed patterndatãAhXi[܂B
		 * Packed patterndata̐擪ɂ́ALength of packed patterntB[h(HalfWord)܂B
		 * Length of packed pattern͕svȂ̂ŁA炩߃XLbvĂ܂B
		 */
		//driver->patterns[i_pattern] = (const unsigned char*)((int)module_header +
		//						     (parapointers_to_patterns[i_pattern] << 4) +
		//						     sizeof(unsigned short)/*Length of packed pattern*/);
		//2004/11/17 Naoyuki Sawa OrdnumΉ
		driver->patterns[i_pattern] = (const unsigned char*)((int)module_header +
								     (LEHALF(&parapointers_to_patterns[sizeof(unsigned short) * i_pattern]) << 4) +
								     sizeof(unsigned short)/*Length of packed pattern*/);
	}

	/* eChannelɂ... */
	for(i_channel = 0, channel = driver->channels;
	    i_channel < 32;
	    i_channel++, channel++) {

		/* Channel setting = 0..15ȂSample channelłB
		 * Adlib channel(16..31)Disabled channel(255)̓XLbv܂B
		 */
		if(module_header->channel_settings[i_channel] >= 16) {
			continue;
		}

		/* Sampleŏ񔭐vꂽꍇɔāASample0ݒ肵Ă܂B
		 * Pending sampleݒ肷邱ƂAChannelLł邱Ƃ܂B
		 */
		channel->pending_sample = &driver->samples[0];
	}

	/* ŏPattern擾܂B */
	if(s3m_init_pattern(driver) != 0) {
		return ERRNO; /* SongI[܂Patterns */
	}

	/* tJnRow܂Ői߂܂B */
	if(s3m_seek_pattern(driver, initial_row) != 0) {
		return ERRNO; /* tJnRows */
	}

	/* Position jumpAPattern breakNA܂B */
	driver->position_jump = -1;
	driver->pattern_break = -1;

	return 0;
}

int
s3m_init(S3MDRIVER* driver, const void* data, int initial_row)
{
	int retval;

	retval = _s3m_init(driver, data, initial_row);
	if(retval != 0) {
		s3m_free(driver); /* J */
	}

	return retval;
}

void
s3m_free(S3MDRIVER* driver)
{
	/* S3MSAMPLE\̔zJ܂B */
	free(driver->samples); /* free(NULL)͈S */

	/* PatternszJ܂B */
	free((/*x}*/void*)driver->patterns); /* free(NULL)͈S */

	/* s3m_free()ȏĂ΂ꂽꍇ̂߂ɁAS3MDRIVER\̂NAĂ܂B */
	memset(driver, 0, sizeof(S3MDRIVER));
}

int
s3m_init_pattern(S3MDRIVER* driver)
{
	int i_pattern;

	for(;;) {
		if((driver->order < 0) ||
		   (driver->order > driver->ordnum - 1)) {
			return ERRNO; /* SongI[ */
		}
		i_pattern = driver->orders[driver->order];
		if(i_pattern != 254/*Skip*/) {
			break;
		}
		driver->order++;
	}
	if((i_pattern < 0) ||
	   (i_pattern > driver->patnum - 1)) {
		return ERRNO; /* Patterns */
	}
	driver->pattern_position = driver->patterns[i_pattern];

	return 0;
}

int
s3m_seek_pattern(S3MDRIVER* driver, int row)
{
	int flags;

	if((row < driver->row) || /* ޕs */
	   (row > 64 - 1)) {      /* Rows */
		return ERRNO;
	}
	while(driver->row < row) {
		for(;;) {
			flags = *driver->pattern_position++;
			if(!flags) break; /* end of row */
			if(flags & 0x20) driver->pattern_position += 2; /* note, instrument */
			if(flags & 0x40) driver->pattern_position += 1; /* volume */
			if(flags & 0x80) driver->pattern_position += 2; /* special_command, command_info */
		}
		driver->row++;
	}

	return 0;
}

int
//{{2017/08/16ύX:64rbgΉ̂߂ɁASTREAMCALLBACKparam̌^Aintintptr_tɕύX܂B
//s3m_stream_callback(short* wbuff, int param)
//2017/08/16ύX:64rbgΉ̂߂ɁASTREAMCALLBACKparam̌^Aintintptr_tɕύX܂B
s3m_stream_callback(short* wbuff, intptr_t param)
//}}2017/08/16ύX:64rbgΉ̂߂ɁASTREAMCALLBACKparam̌^Aintintptr_tɕύX܂B
{
	S3MDRIVER* driver = (S3MDRIVER*)param;
	//
	int retval;
	int i;

	/* e|h~̂߁A1/5[Tick]Â~LVO܂B */
	for(i = 0; i < 5; i++) {
		retval = s3m_run(driver);
		if(retval) break;
		retval = s3m_mix(driver, wbuff);
		if(retval) break;
		wbuff += S3MBUFLEN_5;
	}

	return retval;
}

/****************************************************************************
 *	AvP[Vp֐
 ****************************************************************************/

static S3MDRIVER driver;

int
s3m_play(const void* data, int initial_row)
{
	int retval;

	/* ܂mɒ~܂B */
	s3m_stop();

	/* S3M Driver܂B */
	retval = s3m_init(&driver, data, initial_row);
	if(retval != 0) {
		return retval;
	}

	/* Xg[ĐJn܂B */
//{{2017/08/16ύX:64rbgΉ̂߂ɁASTREAMCALLBACKparam̌^Aintintptr_tɕύX܂B
//	stream_play(S3MBUFLEN, s3m_stream_callback, (int)&driver, 1/*X^bN؊gp*/);
//2017/08/16ύX:64rbgΉ̂߂ɁASTREAMCALLBACKparam̌^Aintintptr_tɕύX܂B
	stream_play(S3MBUFLEN, s3m_stream_callback, (intptr_t)&driver, 1/*X^bN؊gp*/);
//}}2017/08/16ύX:64rbgΉ̂߂ɁASTREAMCALLBACKparam̌^Aintintptr_tɕύX܂B

	return 0;
}

void
s3m_stop()
{
	/* mɃXg[Đ~܂B */
	stream_stop();

	/* mS3M DriverJ܂B */
	s3m_free(&driver);
}

int
s3m_stat()
{
	int result;

	/* Xg[Đ(1)A~(0)B */
	result = stream_stat();

	/* Xg[Đ(1)G[Ȃ΁A߂lG[R[h(<0)ɁB
	 * G[ĂȂ΁A߂l1̂܂܂Ƃ܂B
	 */
	if(result) {
		if(result != 1) DIE(); /* stream_stat()̖߂lzO */
		if(driver.stat) {
			if(driver.stat > 0) DIE(); /* driver.stat̃G[vzO */
			result = driver.stat;
		}
	}

	return result;
}
