/*
 *	clipquat.c
 *
 *	NH[^jICu܂B
 *
 *	CLiP - Common Library for P/ECE
 *	Copyright (C) 2006-2017 Naoyuki Sawa
 *
 *	* Mon Sep 11 01:20:26 JST 2006 Naoyuki Sawa
 *	- 쐬JnB
 *	* Thu Sep 14 13:34:52 JST 2006 Naoyuki Sawa
 *	- 1st [XB
 *	* Sat Jul 22 22:21:25 JST 2017 Naoyuki Sawa
 *	- clipquat.h,clipquat.cWin32vWFNgɊ܂߂邽߂̏Cs܂B
 *	  ̓Iɂ́Aȉ̂悤ȓ_C܂B
 *	- GCCg@\̐֐gpquaternion\̂𐶐ĂӏAVɒ`quaternion_()gp悤ɏC܂B
 *	  quaternion_()́AGCCȂ΂܂Œʂ萶֐ɓWJAGCCȊOȂquaternion\̂𐶐CC֐ɓWJ܂B
 *	- GCCg@\'qɂ郉xtvf'gpquaternion\̂ĂӏAxw肵Ȃ悤ɂ܂B
 *	  quaternion\̂̃tB[hύX鎖͖Ǝv̂ŁAɖ͖Ǝv܂B
 */
#include "clip.h"

/*****************************************************************************
 *	quaternion
 *****************************************************************************/

//{{2017/07/22ύX:clipquat.h,clipquat.cWin32vWFNgɊ܂߂邽߂̏Cs܂B
//const quaternion QUATERNION_0 = {
//	.x = fild(0),
//	.y = fild(0),
//	.z = fild(0),
//	.w = fild(0),
//};
//const quaternion QUATERNION_1 = {
//	.x = fild(0),
//	.y = fild(0),
//	.z = fild(0),
//	.w = fild(1),
//};
//2017/07/22ύX:clipquat.h,clipquat.cWin32vWFNgɊ܂߂邽߂̏Cs܂B
const quaternion QUATERNION_0 = {
	/*.x =*/ fild(0),
	/*.y =*/ fild(0),
	/*.z =*/ fild(0),
	/*.w =*/ fild(0),
};
const quaternion QUATERNION_1 = {
	/*.x =*/ fild(0),
	/*.y =*/ fild(0),
	/*.z =*/ fild(0),
	/*.w =*/ fild(1),
};
//}}2017/07/22ύX:clipquat.h,clipquat.cWin32vWFNgɊ܂߂邽߂̏Cs܂B

quaternion
qadd(quaternion a, quaternion b)
{
	/* Qx = Ax + Bx
	 * Qy = Ay + By
	 * Qz = Az + Bz
	 * Qw = Aw + Bw
	 */
//{{2017/07/22ύX:clipquat.h,clipquat.cWin32vWFNgɊ܂߂邽߂̏Cs܂B
//	return (quaternion){
//		.x = fadd(a.x, b.x),
//		.y = fadd(a.y, b.y),
//		.z = fadd(a.z, b.z),
//		.w = fadd(a.w, b.w),
//	};
//2017/07/22ύX:clipquat.h,clipquat.cWin32vWFNgɊ܂߂邽߂̏Cs܂B
	return quaternion_(
		/*.x =*/ fadd(a.x, b.x),
		/*.y =*/ fadd(a.y, b.y),
		/*.z =*/ fadd(a.z, b.z),
		/*.w =*/ fadd(a.w, b.w));
//}}2017/07/22ύX:clipquat.h,clipquat.cWin32vWFNgɊ܂߂邽߂̏Cs܂B
}

quaternion
qneg(quaternion a)
{
	/* Qx = -Ax
	 * Qy = -Ay
	 * Qz = -Az
	 * Qw = -Aw
	 */
//{{2017/07/22ύX:clipquat.h,clipquat.cWin32vWFNgɊ܂߂邽߂̏Cs܂B
//	return (quaternion){
//		.x = fchs(a.x),
//		.y = fchs(a.y),
//		.z = fchs(a.z),
//		.w = fchs(a.w),
//	};
//2017/07/22ύX:clipquat.h,clipquat.cWin32vWFNgɊ܂߂邽߂̏Cs܂B
	return quaternion_(
		/*.x =*/ fchs(a.x),
		/*.y =*/ fchs(a.y),
		/*.z =*/ fchs(a.z),
		/*.w =*/ fchs(a.w));
//}}2017/07/22ύX:clipquat.h,clipquat.cWin32vWFNgɊ܂߂邽߂̏Cs܂B
}

quaternion
qmul(quaternion a, quaternion b)
{
	/* Qx = Ax * Bw + Aw * Bx + Ay * Bz - Az * By
	 * Qy = Ay * Bw + Aw * By + Az * Bx - Ax * Bz
	 * Qz = Az * Bw + Aw * Bz + Ax * By - Ay * Bx
	 * Qw = Aw * Bw - Ax * Bx - Ay * By - Az * Bz
	 */
//{{2017/07/22ύX:clipquat.h,clipquat.cWin32vWFNgɊ܂߂邽߂̏Cs܂B
//	return (quaternion){
//		.x = fsub(fadd(fadd(fmul(a.x, b.w), fmul(a.w, b.x)), fmul(a.y, b.z)), fmul(a.z, b.y)),
//		.y = fsub(fadd(fadd(fmul(a.y, b.w), fmul(a.w, b.y)), fmul(a.z, b.x)), fmul(a.x, b.z)),
//		.z = fsub(fadd(fadd(fmul(a.z, b.w), fmul(a.w, b.z)), fmul(a.x, b.y)), fmul(a.y, b.x)),
//		.w = fsub(fsub(fsub(fmul(a.w, b.w), fmul(a.x, b.x)), fmul(a.y, b.y)), fmul(a.z, b.z)),
//	};
//2017/07/22ύX:clipquat.h,clipquat.cWin32vWFNgɊ܂߂邽߂̏Cs܂B
	return quaternion_(
		/*.x =*/ fsub(fadd(fadd(fmul(a.x, b.w), fmul(a.w, b.x)), fmul(a.y, b.z)), fmul(a.z, b.y)),
		/*.y =*/ fsub(fadd(fadd(fmul(a.y, b.w), fmul(a.w, b.y)), fmul(a.z, b.x)), fmul(a.x, b.z)),
		/*.z =*/ fsub(fadd(fadd(fmul(a.z, b.w), fmul(a.w, b.z)), fmul(a.x, b.y)), fmul(a.y, b.x)),
		/*.w =*/ fsub(fsub(fsub(fmul(a.w, b.w), fmul(a.x, b.x)), fmul(a.y, b.y)), fmul(a.z, b.z)));
//}}2017/07/22ύX:clipquat.h,clipquat.cWin32vWFNgɊ܂߂邽߂̏Cs܂B
}

quaternion
qinv(quaternion a)
{
	/* ||A||^2 =        Ax^2+Ay^2+Az^2+Aw^2
	 *         = {0,0,0,Ax^2+Ay^2+Az^2+Aw^2}
	 *         = {-Ax,-Ay,-Az,Aw} * {Ax,Ay,Az,Aw}
	 *         = A*               * A
	 * A
	 * A^-1    = A* / ||A||^2
	 */
	return qfdiv(qconj(a), qnorm2(a));
}

quaternion
qfmul(quaternion a, fixed b)
{
	/* Qx = Ax * b
	 * Qy = Ay * b
	 * Qz = Az * b
	 * Qw = Aw * b
	 */
//{{2017/07/22ύX:clipquat.h,clipquat.cWin32vWFNgɊ܂߂邽߂̏Cs܂B
//	return (quaternion){
//		.x = fmul(a.x, b),
//		.y = fmul(a.y, b),
//		.z = fmul(a.z, b),
//		.w = fmul(a.w, b),
//	};
//2017/07/22ύX:clipquat.h,clipquat.cWin32vWFNgɊ܂߂邽߂̏Cs܂B
	return quaternion_(
		/*.x =*/ fmul(a.x, b),
		/*.y =*/ fmul(a.y, b),
		/*.z =*/ fmul(a.z, b),
		/*.w =*/ fmul(a.w, b));
//}}2017/07/22ύX:clipquat.h,clipquat.cWin32vWFNgɊ܂߂邽߂̏Cs܂B
}

quaternion
qimul(quaternion a, int b)
{
	/* Qx = Ax * b
	 * Qy = Ay * b
	 * Qz = Az * b
	 * Qw = Aw * b
	 */
//{{2017/07/22ύX:clipquat.h,clipquat.cWin32vWFNgɊ܂߂邽߂̏Cs܂B
//	return (quaternion){
//		.x = fimul(a.x, b),
//		.y = fimul(a.y, b),
//		.z = fimul(a.z, b),
//		.w = fimul(a.w, b),
//	};
//2017/07/22ύX:clipquat.h,clipquat.cWin32vWFNgɊ܂߂邽߂̏Cs܂B
	return quaternion_(
		/*.x =*/ fimul(a.x, b),
		/*.y =*/ fimul(a.y, b),
		/*.z =*/ fimul(a.z, b),
		/*.w =*/ fimul(a.w, b));
//}}2017/07/22ύX:clipquat.h,clipquat.cWin32vWFNgɊ܂߂邽߂̏Cs܂B
}

quaternion
qfdiv(quaternion a, fixed b)
{
	/* Qx = Ax / b
	 * Qy = Ay / b
	 * Qz = Az / b
	 * Qw = Aw / b
	 */
//{{2017/07/22ύX:clipquat.h,clipquat.cWin32vWFNgɊ܂߂邽߂̏Cs܂B
//	return (quaternion){
//		.x = fdiv(a.x, b),
//		.y = fdiv(a.y, b),
//		.z = fdiv(a.z, b),
//		.w = fdiv(a.w, b),
//	};
//2017/07/22ύX:clipquat.h,clipquat.cWin32vWFNgɊ܂߂邽߂̏Cs܂B
	return quaternion_(
		/*.x =*/ fdiv(a.x, b),
		/*.y =*/ fdiv(a.y, b),
		/*.z =*/ fdiv(a.z, b),
		/*.w =*/ fdiv(a.w, b));
//}}2017/07/22ύX:clipquat.h,clipquat.cWin32vWFNgɊ܂߂邽߂̏Cs܂B
}

quaternion
qidiv(quaternion a, int b)
{
	/* Qx = Ax / b
	 * Qy = Ay / b
	 * Qz = Az / b
	 * Qw = Aw / b
	 */
//{{2017/07/22ύX:clipquat.h,clipquat.cWin32vWFNgɊ܂߂邽߂̏Cs܂B
//	return (quaternion){
//		.x = fidiv(a.x, b),
//		.y = fidiv(a.y, b),
//		.z = fidiv(a.z, b),
//		.w = fidiv(a.w, b),
//	};
//2017/07/22ύX:clipquat.h,clipquat.cWin32vWFNgɊ܂߂邽߂̏Cs܂B
	return quaternion_(
		/*.x =*/ fidiv(a.x, b),
		/*.y =*/ fidiv(a.y, b),
		/*.z =*/ fidiv(a.z, b),
		/*.w =*/ fidiv(a.w, b));
//}}2017/07/22ύX:clipquat.h,clipquat.cWin32vWFNgɊ܂߂邽߂̏Cs܂B
}

quaternion
qconj(quaternion a)
{
	/* Qx = -Ax
	 * Qy = -Ay
	 * Qz = -Az
	 * Qw =  Aw
	 */
//{{2017/07/22ύX:clipquat.h,clipquat.cWin32vWFNgɊ܂߂邽߂̏Cs܂B
//	return (quaternion){
//		.x = fchs(a.x),
//		.y = fchs(a.y),
//		.z = fchs(a.z),
//		.w =      a.w ,
//	};
//2017/07/22ύX:clipquat.h,clipquat.cWin32vWFNgɊ܂߂邽߂̏Cs܂B
	return quaternion_(
		/*.x =*/ fchs(a.x),
		/*.y =*/ fchs(a.y),
		/*.z =*/ fchs(a.z),
		/*.w =*/      a.w );
//}}2017/07/22ύX:clipquat.h,clipquat.cWin32vWFNgɊ܂߂邽߂̏Cs܂B
}

fixed
qnorm(quaternion a)
{
	/* ||A|| = (||A||^2)
	 */
	return fsqrt(qnorm2(a));
}

fixed
qnorm2(quaternion a)
{
	/* ||A||^2 =        Ax^2+Ay^2+Az^2+Aw^2
	 *         = {0,0,0,Ax^2+Ay^2+Az^2+Aw^2}
	 *         = {-Ax,-Ay,-Az,Aw} * {Ax,Ay,Az,Aw}
	 *         = A*               * A
	 */
	return qdot(a, a);		/* Ax^2+Ay^2+Az^2+Aw^2 */
	//ʂ͂ǂłłB
	//return qmul(qconj(a), a).w;	/* A* * A */
}

quaternion
qnormal(quaternion a)
{
	/* Q = A / ||A||
	 */
	return qfdiv(a, qnorm(a));
}

fixed
qdot(quaternion a, quaternion b)
{
	/* AEB = Ax*Bx + Ay*By + Az*Bz + Aw*Bw
	 *      = (A * B* + B * A*) / 2
	 */
	return fadd(fadd(fadd(fmul(a.x, b.x), fmul(a.y, b.y)), fmul(a.z, b.z)), fmul(a.w, b.w));	/* Ax*Bx + Ay*By + Az*Bz + Aw*Bw */
	//ʂ͂ǂłłB
	//return qidiv(qadd(qmul(a, qconj(b)), qmul(b, qconj(a))), 2).w;				/* (A * B* + B * A*) / 2 */
}

quaternion
qrot(fixed x, fixed y, fixed z, fixed d)
{
	/* Qx = Ax * sin(/2)
	 * Qy = Ay * sin(/2)
	 * Qz = Az * sin(/2)
	 * Qw =      cos(/2)
	 */
//{{2017/07/22ύX:clipquat.h,clipquat.cWin32vWFNgɊ܂߂邽߂̏Cs܂B
//	vector v = vnormal((vector){ x, y, z }); /* ]xNg𐳋K */
//2017/07/22ύX:clipquat.h,clipquat.cWin32vWFNgɊ܂߂邽߂̏Cs܂B
	vector v = vnormal(vector_( x, y, z )); /* ]xNg𐳋K */
//}}2017/07/22ύX:clipquat.h,clipquat.cWin32vWFNgɊ܂߂邽߂̏Cs܂B
	fidiv_(d, 2);
	vfmul_(v, fsin(d));
//{{2017/07/22ύX:clipquat.h,clipquat.cWin32vWFNgɊ܂߂邽߂̏Cs܂B
//	return (quaternion){
//		.x = v.x,
//		.y = v.y,
//		.z = v.z,
//		.w = fcos(d),
//	};
//2017/07/22ύX:clipquat.h,clipquat.cWin32vWFNgɊ܂߂邽߂̏Cs܂B
	return quaternion_(
		/*.x =*/ v.x,
		/*.y =*/ v.y,
		/*.z =*/ v.z,
		/*.w =*/ fcos(d));
//}}2017/07/22ύX:clipquat.h,clipquat.cWin32vWFNgɊ܂߂邽߂̏Cs܂B
}

quaternion
qslerp(quaternion a, quaternion b, fixed t)
{
	fixed c;
	fixed s;
	fixed st;
	fixed s1_t;
	fixed d;
	fixed dt;
	fixed d1_t;

//{{
//	/* ]\NH[^jIq1,q2p[^tŋʐ`ԂA]\NH[^jIq߂ɂ́A
//	 *       q1 sin((1-t)) + q2 sin(t)
//	 *   q = -----------------------------   (: q1q2̐px c ȉ̃RgQ)
//	 *                   sin            
//	 *-------------------------------------------------------------------------------------------------------------------------------
//	 * qslerp()́ANH[^jIa,b]\NH[^jIłƉ肵āAʐ`Ԃs܂B
//	 * ]āA||a||=||b||=1 ƌȂāAKs܂B
//	 * ܂A]\NH[^jI̓/2ɍ쐬Ă̂ŁA҂̐px𓾂ɂ cos^-1(aEb) {Kv܂B
//	 * ANH[^jIa,bʒu\NH[^jIꍇ́Acos^-1(aEb) {Kv͂܂B
//	 * ]āÅ֐͉]\NH[^jI̋ʐ`ԐpłAʒu\NH[^jI̋ʐ`Ԃɂ͗pł܂B
//	 *-------------------------------------------------------------------------------------------------------------------------------
//	 */
//	c = qdot(a, b);			/* cos/2 = ||a||||b||cos/2 = aEb */
//	d = facos(c);			/*    /2                            */
//	fimul_(d, 2);			/*                                  */
//	s = fsin(d);			/* sin                              */
//	if(s) {				/* ab(=ʐ`ԕsv)A܂́A^t̕(=ʐ`ԕs\) ȂΏȂ */
//		dt   = fmul(d,  t);	/*                            t            */
//		d1_t = fsub(d, dt);	/*        (1-t)                            */
//		st   = fsin(dt  );	/*                     sin(   t )          */
//		s1_t = fsin(d1_t);	/*    sin((1-t))                           */
//		qfmul_(a, s1_t);	/*  a sin((1-t))                           */
//		qfmul_(b, st  );	/*                   b sin(   t )          */
//		qadd_(a, b);		/*  a sin((1-t)) + b sin(   t )          */
//		qfdiv_(a, s);		/* (a sin((1-t)) + b sin(   t )) / sin */
//	}
//}}

	/* ]\NH[^jIq1,q2p[^tŋʐ`ԂA]\NH[^jIq߂ɂ́A
	 *       q1 sin((1-t)) + q2 sin(t)
	 *   q = -----------------------------   (: q1q2̐px c ȉ̃RgQ)
	 *                   sin            
	 *-------------------------------------------------------------------------------------------------------------------------------
	 * q1q2]\NH[^jIłꍇAqaq2̓ς́A҂̐px̔(/2)ƂȂ܂B
	 * ꌩA{ăƂɖ߂Kv悤ɌAWeb̃vOłĂ̂ÛłA{Ă͂܂B
	 * {ɁA/2̂܂܂Ői߂ƁA]\NH[^jI̐ʐ`ԌʂɂȂ܂B
	 * ȂȂ̂A܂܂łĂ܂B(]\NH[^jI͏Inтă/2A߂Ă͂Ȃ?)
	 * ǁA]\NH[^jI̕ԂAʒu\NH[^jIԂAK̕sv/Kv̈Ⴂ΁A菇ƂȂ܂B
	 *-------------------------------------------------------------------------------------------------------------------------------
	 */
	c = qdot(a, b);			// cos = ||a||||b||cos/2 = aEb   A||a||=||b||=1 Ɖ肵܂B
	d = facos(c);			//    
	s = fsin(d);			// sin
	if(s) {				// ab(=ʐ`ԕsv)A܂́A^t̕(=ʐ`ԕs\)ȂΏ܂B
		dt   = fmul(d,  t);	//                            t 
		d1_t = fsub(d, dt);	//        (1-t)
		st   = fsin(dt  );	//                     sin(   t )
		s1_t = fsin(d1_t);	//    sin((1-t))
		qfmul_(a, s1_t);	//  a sin((1-t))
		qfmul_(b, st  );	//                   b sin(   t )
		qadd_(a, b);		//  a sin((1-t)) + b sin(   t )
		qfdiv_(a, s);		// (a sin((1-t)) + b sin(   t )) / sin
	}

	return a;
}

vector
vrotq(vector v, quaternion q)
{
	/* q = ]\NH[^jI
	 * p = ʒu\NH[^jI
	 * ̂ƂAqgp]A]̈ʒu\NH[^jIp'߂ɂ́A
	 * p' = q p q*
	 *-----------------------------------------------------------------------------------------------------------------------------------------------------------------------
	 * * Tue Sep 12 03:39:47 JST 2006 Naoyuki Sawa
	 * - up' = q* p qvƂ鎑łAup' = q* p qvł͋t]ɂȂĂ܂܂B
	 *   up' = q p q*vƂ΁A]ɂȂ܂B()
	 * - u3D-CGvO}[̂߂̃NH[^jIv(Hw)̃TvvÓAup' = q* p qvƂȂĂ܂AZ(quat_mul())̎dlςČʂ킹Ă܂B
	 *   ]āA]ɂȂ܂B
	 *   ʂ͐̂łA△Ȋ܂B
	 * - u70bŕAgAlE4ENH[^jIEQuaternionŉ]v(http://staff.aist.go.jp/toru-nakata/quaternion.html)̃TvvÓA
	 *   up' = q* p qvAAZ(Kakezan())̎dl̂܂܂łB
	 *   ]āAt]ɂȂĂ܂܂B
	 * - uNH[^jIɂWϊv(http://www.purose.net/~y_kim/QuaternionTransform.pdf)̉́Aup' = q p q*vƂĂ܂B
	 *   ]āA]ɂȂ܂B
	 *   ̎̂݁ADirectX̍svZ(xNg̉Es)pĂ̂ŁA̎Ƃ̈Ⴂ͒Pɂ̗Rɂ̂mȂ̂łA
	 *   ۂɎĂ݂ƁAOpenGL`̍svZ(xNg̍s)łĂAup' = q p q*v̕܂A]ɂȂ悤Ɏv܂B
	 *   AsvZ̕(/E)ĂANH[^jI̋Lq͓Ȃ̂łANH[^jIm̏Z̕яɂ͊֌Ŵł͂Ȃł傤H
	 *-----------------------------------------------------------------------------------------------------------------------------------------------------------------------
	 */
//{{2017/07/22ύX:clipquat.h,clipquat.cWin32vWFNgɊ܂߂邽߂̏Cs܂B
//	quaternion p = {
//		.x = v.x,
//		.y = v.y,
//		.z = v.z,
//		.w = fild(0),
//	};
//2017/07/22ύX:clipquat.h,clipquat.cWin32vWFNgɊ܂߂邽߂̏Cs܂B
	quaternion p = {
		/*.x =*/ v.x,
		/*.y =*/ v.y,
		/*.z =*/ v.z,
		/*.w =*/ fild(0),
	};
//}}2017/07/22ύX:clipquat.h,clipquat.cWin32vWFNgɊ܂߂邽߂̏Cs܂B
	p = qmul(qmul(q, p), qconj(q));
//{{2017/07/22ύX:clipquat.h,clipquat.cWin32vWFNgɊ܂߂邽߂̏Cs܂B
//	return (vector){
//		.x = p.x,
//		.y = p.y,
//		.z = p.z,
//	};
//2017/07/22ύX:clipquat.h,clipquat.cWin32vWFNgɊ܂߂邽߂̏Cs܂B
	return vector_(
		/*.x =*/ p.x,
		/*.y =*/ p.y,
		/*.z =*/ p.z);
//}}2017/07/22ύX:clipquat.h,clipquat.cWin32vWFNgɊ܂߂邽߂̏Cs܂B
}

matrix
mrotq(matrix m, quaternion q)
{
	/* ʒu\NH[^jIPƁA]\NH[^jIQA
	 *	Q = { Ax,Ay,Az,Aw }
	 *	P = { Px,Py,Pz, 0 }
	 * ̂ƂAPQŉ]ʒuP'߂NH[^jIZF
	 *	P' = Q P Q*
	 * ɑs񉉎ŹA̒ʂłB
	 *	| Px' |   | 1-2*(Qy*Qy+Qz*Qz)   2*(Qx*Qy-Qz*Qw)   2*(Qz*Qx+Qy*Qw) 0 | | Px |
	 *	| Py' | = |   2*(Qx*Qy+Qz*Qw) 1-2*(Qz*Qz+Qx*Qx)   2*(Qy*Qz-Qx*Qw) 0 | | Py |
	 *	| Pz' |   |   2*(Qz*Qx-Qy*Qw)   2*(Qy*Qz+Qx*Qw) 1-2*(Qx*Qx+Qy*Qy) 0 | | Pz |
	 */
//{{2017/07/22ύX:clipquat.h,clipquat.cWin32vWFNgɊ܂߂邽߂̏Cs܂B
//	return mxform(m, (matrix){
//		fisubr(fimul(fadd(fmul(q.y, q.y), fmul(q.z, q.z)), 2), 1),        fimul(fsub(fmul(q.x, q.y), fmul(q.z, q.w)), 2)    ,        fimul(fadd(fmul(q.z, q.x), fmul(q.y, q.w)), 2)    , fild(0),
//		       fimul(fadd(fmul(q.x, q.y), fmul(q.z, q.w)), 2)    , fisubr(fimul(fadd(fmul(q.z, q.z), fmul(q.x, q.x)), 2), 1),        fimul(fsub(fmul(q.y, q.z), fmul(q.x, q.w)), 2)    , fild(0),
//		       fimul(fsub(fmul(q.z, q.x), fmul(q.y, q.w)), 2)    ,        fimul(fadd(fmul(q.y, q.z), fmul(q.x, q.w)), 2)    , fisubr(fimul(fadd(fmul(q.x, q.x), fmul(q.y, q.y)), 2), 1), fild(0),
//	});
//2017/07/22ύX:clipquat.h,clipquat.cWin32vWFNgɊ܂߂邽߂̏Cs܂B
	return mxform(m, matrix_(
		fisubr(fimul(fadd(fmul(q.y, q.y), fmul(q.z, q.z)), 2), 1),        fimul(fsub(fmul(q.x, q.y), fmul(q.z, q.w)), 2)    ,        fimul(fadd(fmul(q.z, q.x), fmul(q.y, q.w)), 2)    , fild(0),
		       fimul(fadd(fmul(q.x, q.y), fmul(q.z, q.w)), 2)    , fisubr(fimul(fadd(fmul(q.z, q.z), fmul(q.x, q.x)), 2), 1),        fimul(fsub(fmul(q.y, q.z), fmul(q.x, q.w)), 2)    , fild(0),
		       fimul(fsub(fmul(q.z, q.x), fmul(q.y, q.w)), 2)    ,        fimul(fadd(fmul(q.y, q.z), fmul(q.x, q.w)), 2)    , fisubr(fimul(fadd(fmul(q.x, q.x), fmul(q.y, q.y)), 2), 1), fild(0)));
//}}2017/07/22ύX:clipquat.h,clipquat.cWin32vWFNgɊ܂߂邽߂̏Cs܂B
}
