/*	
 *	clippsid.h
 *
 *	P/ECE PSID Driver
 *
 *	CLiP - Common Library for P/ECE
 *	Copyright (C) 2001-2017 Naoyuki Sawa
 *
 *	* Sat Dec 27 06:00:00 JST 2003 Naoyuki Sawa
 *	- 쐬JnB
 *	* Wed Nov 18 21:37:53 JST 2015 Naoyuki Sawa
 *	- 'extern "C" {'`'}'ň݂͂܂B.cpp܂Win32vWFNgCN[ho悤ɂ邽߂łB
 *	* Wed Aug 16 22:59:27 JST 2017 Naoyuki Sawa
 *	- 64rbgΉ̂߂ɁASTREAMCALLBACKparam̌^Aintintptr_tɕύX܂B
 */
#ifndef __CLIP_PSID_H__
#define __CLIP_PSID_H__

#ifdef  __cplusplus
extern "C" {
#endif//__cplusplus

typedef struct _PSIDDRIVER PSIDDRIVER;

/****************************************************************************
 *	PSIDt@C`
 ****************************************************************************/

/* PSIDt@C̃tB[h́ArbOGfBAŃACgĂ܂B
 * Cӂ̔ACgʒuBYTE/HALF/WORD擾}NłB
 * !!}Ń|C^łB
 *         ϐnƃ|C^ɃLXgČxoȂ̂ŁAӂB
 */
#define PSID_BYTE(p)	(((unsigned char*)(p))[0])
#define PSID_HALF(p)	(((unsigned char*)(p))[0] <<  8 |	\
			 ((unsigned char*)(p))[1])
#define PSID_WORD(p)	(((unsigned char*)(p))[0] << 24 |	\
			 ((unsigned char*)(p))[1] << 16 |	\
			 ((unsigned char*)(p))[2] <<  8 |	\
			 ((unsigned char*)(p))[3])

/*
 *	PSIDt@Cwb_ ("SIDPLAY.htm"Q)
 */
typedef struct _PSIDHEADER {
	unsigned char signature[4];	/* +00, 4 */
	unsigned char version[2];	/* +04, 2 */
	unsigned char data_offset[2];	/* +06, 2 */
	unsigned char load_addr[2];	/* +08, 2 */
	unsigned char init_addr[2];	/* +0a, 2 */
	unsigned char play_addr[2];	/* +0c, 2 */
	unsigned char songs[2];		/* +0e, 1 */
	unsigned char start_song[2];	/* +10, 1 */
	unsigned char speed[4];		/* +12, 4 */
	unsigned char name[32];		/* +16,32 */
	unsigned char author[32];	/* +36,32 */
	unsigned char copyright[32];	/* +56,32 */
	/* version=1:܂Ł */
	unsigned char flags[2];		/* +76, 2 */
	unsigned char reserved[4];	/* +78, 4 */
	/* version=2:܂Ł */	/* =7c    */
} PSIDHEADER;

/****************************************************************************
 *	gSID
 ****************************************************************************/

/* Galway-Noise */
typedef struct _XSIDGN {
	int tones;		/* Number of tones */
	int addr;		/* Byte address (0x0000`0xffff) */
	int len;		/* Tonelength */
	int vol;		/* Volume of Noise */
	int period1;		/* Period for each value of ToneData */
	int period0;		/* Period for value 0 of ToneData */
	//
	int progress;		/* NbNisJE^ */
	int period;		/* ݂̃g[̔g`TCY[Clock] */
	int count;		/* ݂̃g[̎cg` */
} XSIDGN;

/* Sample */
typedef struct _XSIDSM {
	int vol;		/* Volume */
	int addr;		/* Nibble address (0x00000`0x1fffe) */
	int addr_end;		/* Nibble address (0x00002`0x20000) */
	int addr_rep;		/* Nibble address (0x00000`0x1fffe) */
	int rep_cnt;		/* 0x00`0xfe:count/0xff: */
	int period;		/* freq = clock / period */
	int stride;		/* Nibble address stride */
	int order;		/* Nibble order 0:Lo,Hi/1:Hi,Lo */
	//
	int dda_d;		/* Tvf[^AhXDDA */
} XSIDSM;

typedef struct _XSID {
	int state;		/* 0(OFF)/XSID_GALWAY_NOISE/XSID_SAMPLE */
	union {
		XSIDGN gn;	/* state=XSID_GALWAY_NOISE */
		XSIDSM sm;	/* state=XSID_SAMPLE       */
	} context;
	//
	unsigned char reg[0x80];/* gSID#1(0xd4xx)̂ݑΉB#2`(0xd5xx`)͖ΉłB */
} XSID;

/* XSID.state */
#define XSID_GALWAY_NOISE	1
#define XSID_SAMPLE		2

/*
 *	gSID֐
 */
void psid_xsid_write(PSIDDRIVER* psid, unsigned short addr, unsigned char data);
void psid_xsid_galway_noise_start(PSIDDRIVER* psid, unsigned char data);
void psid_xsid_sample_start(PSIDDRIVER* psid, unsigned char data);
int psid_xsid_process(PSIDDRIVER* psid, int step);		/* o̓Tv=t17.5bit */
int psid_xsid_galway_noise_process(PSIDDRIVER* psid, int step);	/* o̓Tv=t17.5bit */
int psid_xsid_sample_process(PSIDDRIVER* psid, int step);	/* o̓Tv=t17.5bit */

/****************************************************************************
 *	PSIDhCo
 ****************************************************************************/

#define PSIDBUFLEN	SIDBUFLEN	/* 1[tick](=1/50[sec])̃Tv */

#define PSID_C64_CLOCK	985248		/* CPUSIDNbN[Hz] (ʂł) */

/*
 *	PSIDhCo
 */
/*typedef*/ struct _PSIDDRIVER {
	/*==== Commodore64 n[hEFAɊւ ====**/
	/*{{M6502RAREADO֐g߁ACAEgŒ*/
	M6502 m6502;			/* 6502 Core */
	unsigned char mem[0x10000];	/* Main Memory */
	/*}}M6502RAREADO֐g߁ACAEgŒ*/
	//
	SID sid;			/* SID Chip */
	XSID xsid;			/* PlaySID Extended SID */
	//
	int speed;			/* 0:PAL(1/50[b])Œ / 1:CIA(1/60[b]) */
	int cia_timer;			/* CIA#1 Timer A start value */
	int cia_count;			/* CIA#1 TImer A count down  */

	/*==== PSIDt@C \tgEFAɊւ ====*/
	unsigned short play_addr;	/* Interrupt Handler */
	int progress;			/* SIDCPUNbNϊDDA */
} /*PSIDDRIVER*/;

/*
 *	M6502G~[VpO֐
 */
//unsigned char psid_m6502_read(M6502* m6502, unsigned short addr); /* I/O READ ȗ */
void psid_m6502_write(M6502* m6502, unsigned short addr, unsigned char data);
void psid_m6502_out(M6502* m6502, unsigned short addr, unsigned char data);

/*
 *	PSIDhCo֐
 */
void psid_m6502_setup(PSIDDRIVER* psid, int a, int pc);
int psid_init(PSIDDRIVER* psid, const void* data, int len, int i_song);
int psid_mix(PSIDDRIVER* psid, short* wbuff);
//{{2017/08/16ύX:64rbgΉ̂߂ɁASTREAMCALLBACKparam̌^Aintintptr_tɕύX܂B
//int psid_stream_callback(short* wbuff, int param);
//2017/08/16ύX:64rbgΉ̂߂ɁASTREAMCALLBACKparam̌^Aintintptr_tɕύX܂B
int psid_stream_callback(short* wbuff, intptr_t param);
//}}2017/08/16ύX:64rbgΉ̂߂ɁASTREAMCALLBACKparam̌^Aintintptr_tɕύX܂B

/****************************************************************************
 *	AvP[Vp֐
 ****************************************************************************/

/* PSIDt@C̍ĐJn܂B
 * [in]
 *	data		PSIDf[^̐擪AhXB
 *	len		PSIDf[^̃oCgB
 *	i_song		gbNԍB(0`)
 * [out]
 *	߂l		ĐJnɐA 0Ԃ܂B
 *			ĐJnłȂ΁A-1Ԃ܂B
 * [note]
 *	* ̊֐͓stream_play()ĂяoĂ܂B
 *	* stream_play()ĂԂƁATEh荞݃xN^tbN܂B
 *	  vOIOɕKpsid_stop()ĂŁAxN^𕜌ĂB
 */
int psid_play(const void* data, int len, int i_song);

/* PSIDt@C̍Đ~܂B
 * [note]
 *	* ĐłȂ΁Å֐͉܂B
 */
void psid_stop();

#ifdef  __cplusplus
}//extern "C"
#endif//__cplusplus

#endif /*__CLIP_PSID_H__*/
