/*	
 *	clippnm.c
 *
 *	Netpbm format
 *
 *	CLiP - Common Library for P/ECE
 *	Copyright (C) 2016-2018 Naoyuki Sawa
 *
 *	* Sat Apr 09 21:06:53 JST 2016 Naoyuki Sawa
 *	- 1st [XB
 *	- 摜APBMeLXg`(P1),,PGMeLXg`(P2),,PPMeLXg`(P3)ŕۑ܂B
 *	  ڃt@Cɕۑ֐(`_save())ƁAXg[ɏo͂֐(`_dump()pӂ܂B
 *	- W[쐬ȖړÍAP/ECẺʂȒPɕۑ邽߂łB
 *	  BMP`TGA`ŕۑAPNM`ŕۑȒPŃR[hʂȂôŁAPNM`I܂B
 *	  z肷ǵAP/ECẼtbVɃt@CƂĕۑ邩ÁAWG[o͂USBoRŏo͂܂B
 *	  ̌AImageMagickgāAPNM`ėpIȌ`(BMP`PNG`)֕ϊĉB
 *	- P/ECẺ摜`ɓKĂ̂PGM`łAۂɂ͂قƂpgm_save(),,pgm_dump()gȂƎv܂B
 *	  APBM`PPM`قƂǓőΉôŁAPBM`PPM`ΉĂɂ܂B
 *	- PNM`ŕۑ鎖ړIłAǂݍގ͖ړIł͂Ȃ̂ŁAPNM`̓ǂݍ݊֐͍쐬Ă܂B
 *	- QƎuWikipedia - Netpbm formatv(http://en.wikipedia.org/wiki/Netpbm_format)
 *	  A Netpbm format is any graphics format used and defined by the Netpbm project.
 *	  The portable pixmap format (PPM), the portable graymap format (PGM) and the portable bitmap format (PBM) are image file formats designed to be easily exchanged between platforms.
 *	  They are also sometimes referred to collectively as the portable anymap format (PNM), not to be confused with the related portable arbitrary map format.
 *	* Sun May 13 23:59:59 JST 2018 Naoyuki Sawa
 *	- pnm_load(),pnm_decode()ǉ܂B
 */
#include "clip.h"
/*****************************************************************************
 *	[J֐
 *****************************************************************************/
static char* complete_extension(char* dstPath, const char* srcPath, const char* defExt) {
	char drive[MAX_DRIVE], dir[MAX_DIR], fname[MAX_FNAME], ext[MAX_EXT];
	splitpath(srcPath, drive, dir, fname, ext);
	makepath(dstPath, drive, dir, fname, (*ext ? ext : defExt));
	return dstPath;
}
/*---------------------------------------------------------------------------*/
static void pnm_gets(char** lineptr, size_t* n, FILE* fp) {
	for(;;) {
		if(getline(lineptr, n, fp) == EOF) { DIE(); }
		{
			char* s = *lineptr;
			char* p = strchr(s, '#');
			if(p) { *p = '\0'; }
			strstrip(s);
			if(*s) { break; }
		}
	}
}
/*****************************************************************************
 *	Portable bitmap format (PBM)
 *****************************************************************************/
void pbm_save(const char* path/*gqȗ*/, int w, int h, int (*fnPoint)(int x, int y, void* arg), void* arg) {
	char tmpPath[MAX_PATH];
	FILE* fp = fopen(complete_extension(tmpPath, path, "pbm"), "w");
	if(!fp) { DIE(); }
	pbm_dump(fp, w, h, fnPoint, arg);
	fclose(fp);
}
/*---------------------------------------------------------------------------*/
void pbm_dump(FILE* fp, int w, int h, int (*fnPoint)(int x, int y, void* arg), void* arg) {
	int x, y;
	fprintf(fp, "P1\n");
	fprintf(fp, "%d %d\n", w, h);
	for(y = 0; y < h; y++) {
		for(x = 0; x < w; x++) {
			int c = (*fnPoint)(x, y, arg);
			if((unsigned)c > 1) { c = 1; }
			if(x) { fputc(' ', fp); }
			fprintf(fp, "%d", c);
		}
		fputc('\n', fp);
	}
}
/*****************************************************************************
 *	Portable graymap format (PGM)
 *****************************************************************************/
void pgm_save(const char* path/*gqȗ*/, int w, int h, int maxVal, int (*fnPoint)(int x, int y, void* arg), void* arg) {
	char tmpPath[MAX_PATH];
	FILE* fp = fopen(complete_extension(tmpPath, path, "pgm"), "w");
	if(!fp) { DIE(); }
	pgm_dump(fp, w, h, maxVal, fnPoint, arg);
	fclose(fp);
}
/*---------------------------------------------------------------------------*/
void pgm_dump(FILE* fp, int w, int h, int maxVal, int (*fnPoint)(int x, int y, void* arg), void* arg) {
	int x, y, maxLen = (int)log10(maxVal + 0.5) + 1;
	//                                     ~~~덷z邽߂ɕKvłBȂ'(int)log10(10)=0'ɂȂĂ܂܂B0.5Ă'(int)log10(10.5)=1'ɂȂ܂B
	fprintf(fp, "P2\n");
	fprintf(fp, "%d %d\n", w, h);
	fprintf(fp, "%d\n", maxVal);
	for(y = 0; y < h; y++) {
		for(x = 0; x < w; x++) {
			int c = (*fnPoint)(x, y, arg);
			if((unsigned)c > (unsigned)maxVal) { c = maxVal; }
			if(x) { fputc(' ', fp); }
			fprintf(fp, "%*d", maxLen, c);
		}
		fputc('\n', fp);
	}
}
/*****************************************************************************
 *	Portable pixmap format (PPM)
 *****************************************************************************/
void ppm_save(const char* path/*gqȗ*/, int w, int h, int maxVal, int (*fnPoint)(int x, int y, void* arg), void* arg) {
	char tmpPath[MAX_PATH];
	FILE* fp = fopen(complete_extension(tmpPath, path, "ppm"), "w");
	if(!fp) { DIE(); }
	ppm_dump(fp, w, h, maxVal, fnPoint, arg);
	fclose(fp);
}
/*---------------------------------------------------------------------------*/
void ppm_dump(FILE* fp, int w, int h, int maxVal, int (*fnPoint)(int x, int y, void* arg), void* arg) {
	int x, y, maxLen = (int)log10(maxVal + 0.5) + 1;
	//                                     ~~~덷z邽߂ɕKvłBȂ'(int)log10(10)=0'ɂȂĂ܂܂B0.5Ă'(int)log10(10.5)=1'ɂȂ܂B
	fprintf(fp, "P3\n");
	fprintf(fp, "%d %d\n", w, h);
	fprintf(fp, "%d\n", maxVal);
	for(y = 0; y < h; y++) {
		for(x = 0; x < w; x++) {
			int c = (*fnPoint)(x, y, arg);
			int r = (unsigned char)(c >> 16);
			int g = (unsigned char)(c >>  8);
			int b = (unsigned char)(c >>  0);
			if((unsigned)r > (unsigned)maxVal) { r = maxVal; }
			if((unsigned)g > (unsigned)maxVal) { g = maxVal; }
			if((unsigned)b > (unsigned)maxVal) { b = maxVal; }
			if(x) { fputc(' ', fp); }
			fprintf(fp, "%*d %*d %*d", maxLen, r, maxLen, g, maxLen, b);
		}
		fputc('\n', fp);
	}
}
/*****************************************************************************
 *	gp
 *****************************************************************************/
#if 0
//L̗̓T[tFCXŜۑłAꕔۑ鎖o܂B
#ifndef LDIRECT_INTERVAL
int fnPoint(int x, int y, void* arg) { return  3 - surface_point(arg, x, y); }
void test() { pgm_save("test", surface.w, surface.h,  3, fnPoint, &surface); }
#else //LDIRECT_INTERVAL
int fnPoint(int x, int y, void* arg) { return 15 - surface_point(arg, x, y); }
void test() { pgm_save("test", surface.w, surface.h, 15, fnPoint, &surface); }
#endif//LDIRECT_INTERVAL
#endif
/*****************************************************************************
 *	[_[
 *****************************************************************************/
void pnm_load(const char* path/*gqȗ*/,
    void (*size_proc)(int w, int h, void* user_data),
    void (*draw_proc)(int x, int y, int r, int g, int b, void* user_data),
    void* user_data) {
	char tmpPath[MAX_PATH];
	FILE*     fp = fopen(complete_extension(tmpPath, path, "pbm"), "r");
	if(!fp) { fp = fopen(complete_extension(tmpPath, path, "pgm"), "r"); }
	if(!fp) { fp = fopen(complete_extension(tmpPath, path, "ppm"), "r"); }
	if(!fp) { DIE(); }
	pnm_decode(fp, size_proc, draw_proc, user_data);
	fclose(fp);
}
/*---------------------------------------------------------------------------*/
void pnm_decode(FILE* fp,
    void (*size_proc)(int w, int h, void* user_data),
    void (*draw_proc)(int x, int y, int r, int g, int b, void* user_data),
    void* user_data) {
	size_t len = 0; //getline()pobt@
	char* s = NULL; //
	{
		int type, w, h, maxVal = 1, components = 1;
		pnm_gets(&s, &len, fp);
		if(sscanf(s, "P%d", &type) != 1) { DIE(); }
		if((type < 1) || (type > 3)) { DIE(); }
		pnm_gets(&s, &len, fp);
		if(sscanf(s, "%d%d", &w, &h) != 2) { DIE(); }
		if((w < 0) || (h < 0)) { DIE(); }
		(*size_proc)(w, h, user_data);
		if(type >= 2) {
			pnm_gets(&s, &len, fp);
			if(sscanf(s, "%d", &maxVal) != 1) { DIE(); }
			if(maxVal < 0) { DIE(); }
			if(type == 3) { components = 3; }
		}
		{
			char* saveptr = "";
			int y;
			for(y = 0; y < h; y++) {
				int x;
				for(x = 0; x < w; x++) {
					int i, c[3];
					for(i = 0; i < components; i++) {
						char* p = strtok_r(NULL, " \t\r\n", &saveptr);
						if(!p) {
							pnm_gets(&s, &len, fp);
							p = strtok_r(s, " \t\r\n", &saveptr);
							if(!p) { DIE(); }
						}
						c[i] = strtol(p, &p, 10);
						if(*p || ((unsigned)c[i] > (unsigned)maxVal)) { DIE(); }
					}
					while(i < 3) { c[i++] = c[0]; }
					(*draw_proc)(x, y, c[0], c[1], c[2], user_data);
				}
			}
		}
	}
	free(s);	//getline()pobt@JB
}
/*****************************************************************************
 *	gp
 *****************************************************************************/
#if 0
#ifndef LDIRECT_INTERVAL
void size_proc(int w, int h, void* user_data) { }
void draw_proc(int x, int y, int r, int g, int b, void* user_data) { render_point(&render, x, y,  3 - r); }
void test() { pnm_load("test", size_proc, draw_proc, NULL); }
#else //LDIRECT_INTERVAL
void size_proc(int w, int h, void* user_data) { }
void draw_proc(int x, int y, int r, int g, int b, void* user_data) { render_point(&render, x, y, 15 - r); }
void test() { pnm_load("test", size_proc, draw_proc, NULL); }
#endif//LDIRECT_INTERVAL
#endif
